<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:output method="html" encoding="iso-8859-1" omit-xml-declaration="yes"/>
	
	
  <xsl:template match="results">
  
    <html>
      <head>
        <link href='schemadoc.css' type='text/css' rel='stylesheet'/>
        <title>Primavera Schema Validation Report for <xsl:value-of select="@DBTYPE"/></title>
        <xsl:call-template name="style"/>
      </head>
      
      <body>  
        <h1><xsl:value-of select="@DBTYPE"/> Schema Validation Report</h1>

      <DIV class="DetailGroup">
        <h3>Missing Objects</h3>

        <table class='SummaryTable'>
          <tr class='SummaryLabel'>
            <th class='SummaryLabel'>Object Type</th>
            <th class='SummaryLabel'>Object Name</th>
            <th class='SummaryLabel'>Table Name</th>
            <th class='SummaryLabel'>Message</th>
          </tr>
          <xsl:apply-templates select="result[chgtype='CREATE']">
            <xsl:sort select="objtype"/>
          </xsl:apply-templates>
        </table>
        
        <h3>Changed Objects</h3>
        <table class='SummaryTable'>
          <tr class='SummaryLabel'>
            <th class='SummaryLabel'>Object Type</th>
            <th class='SummaryLabel'>Object Name</th>
            <th class='SummaryLabel'>Table Name</th>
            <th class='SummaryLabel'>Message</th>
            <th class='SummaryLabel'>Source</th>
            <th class='SummaryLabel'>Target</th>
          </tr>
          <xsl:apply-templates select="result[chgtype='ALTER']"></xsl:apply-templates>
        </table>
        
        <h3>Extra Objects</h3>
        <table class='SummaryTable'>
          <tr class='SummaryLabel'>
            <th class='SummaryLabel'>Object Type</th>
            <th class='SummaryLabel'>Object Name</th>
            <th class='SummaryLabel'>Table Name</th>
            <th class='SummaryLabel'>Message</th>
          </tr>
          <xsl:apply-templates select="result[chgtype='DROP']"></xsl:apply-templates>
        </table>
        
      </DIV>

        <xsl:if test="string-length(@RUNDATE)>0">
          <br></br>Report Date: <xsl:value-of select="@RUNDATE"/>
        </xsl:if>
      
      </body>
    </html>
      

  </xsl:template>

  <xsl:template match="result">
    <xsl:variable name="row_class">
      <xsl:if test="level='1'">ItemFail</xsl:if>
      <xsl:if test="level='2'">ItemWarn</xsl:if>
      <xsl:if test="level='3'">ItemWarn</xsl:if>
    </xsl:variable>
    
    <xsl:element name="tr">
      <xsl:attribute name="class"><xsl:value-of select="$row_class"/></xsl:attribute>
      <td class='SummaryValue'><xsl:value-of select="objtype"/></td>
      <td class='SummaryValue'><xsl:value-of select="objname"/></td>
      <td class='SummaryValue'>
        <xsl:if test="tablename!=objname"><xsl:value-of select="tablename"/></xsl:if>
      </td>
      <td class='SummaryValue'><xsl:value-of select="message"/></td>
      <xsl:if test="string-length(diff_message)>0"> 
        <td class='SummaryValue'><xsl:value-of select="sourceval"/></td>
        <td class='SummaryValue'><xsl:value-of select="targetval"/></td>
      </xsl:if>
<!--      <xsl:if test="string-length(diff_message)>0"> (<xsl:value-of select="diff_message"/>)</xsl:if> -->
    </xsl:element>
  </xsl:template>
  
  
  <xsl:template name="style">
<style>/* ****************************************************************************************************************** * 
 * CSS Styles For Primavera Validation HTML File
 * ****************************************************************************************************************** */

BODY
{
  background: #E8DFD0
}

TABLE
{
  border: 2px solid  #223100;
  border-collapse: collapse;
  font-size:  small;
  background: #FFF0E8;
  width:      96%;
}

TR:nth-child(n2)
{
  background: orange;
}

TR.HeaderRow, TR.DetailLabel, TR.SummaryLabel, TR.ExceptionLabel
{
  background: #C0C8D0;
}

TR.DetailRowEven TD
{
  background: #FFF4E8;
}

TABLE.HeaderTable
{
  border: 1px solid #223100;
}

TD.HeaderLabel
{
  color: black;
}

TH
{
  border-top:    2px solid #004300;
  border-bottom: 2px solid #004300;
}

TR:first-child
{
  border-top:    0px solid #004300;
}

TD.HeaderLabel
{
    font-weight: bold;
}

TD.HeaderLabel, TD.HeaderValue
{
  padding: 0.4em;
  padding-left: 10px;
  color: #000038;
}

TD.HeaderValue
{
}

TR.DetailLabel, TR.SummaryLabel, TR.ExceptionLabel
{
}

.ExceptionLabelRightAlign, .DetailLabelRightAlign, .SummaryLabelRightAlign
{
  text-align: right;
}

.ExceptionValueRightAlign, .DetailValueRightAlign, .SummaryValueRightAlign
{
  text-align: right;
}

H3
{
  color: #23123B;
  border-bottom: 2px solid #223100;
}

TH
{
  padding-left:  10px;
  padding-right: 1em;
  text-align: left;
}

TD
{
  padding-left:  10px;
  padding-right: 1em;
  white-space:nowrap;
}

TD.ExceptionMsgFail, TR.ExceptionRowFail TD
{
  background: #F0C0C0;
}

TD.ExceptionMsgWarn, TR.ExceptionRowWarn TD
{
  background: #E8E0A0;
}

TD.ExceptionMsgFail
{
  border-bottom:  1px solid #D0B0B0;
}

TD.ExceptionMsgWarn
{
  border-bottom:  1px solid #C0C0B0;
}

TD.ExceptionMsgFail, TD.ExceptionMsgWarn
{
  padding-top:    0.5em;
  padding-bottom: 0.5em;
  white-space:normal;
}

TD.ExceptionValue
{
  padding-bottom: 0.25em;
  padding-top:    0.25em;
}

TR.SummaryRowPass TD, TR.HeaderTablePass TD, TR.ItemPass TD
{
  background: #E0FFD8;
}

TR.SummaryRowWarn TD, TR.HeaderTableWarn TD, TR.ItemWarn TD
{
  background: #E8E0A0;
}

TR.SummaryRowFail TD, TR.HeaderTableFail TD, TR.ItemFail TD
{
  background: #F0C0C0;
}

ueRightAlign, .SummaryValueRightAlign
{
  text-align: right;
}

H3
{
  color: #23123B;
  border-bottom: 2px solid #223100;
}

TH
{
  padding-left:  10px;
  padding-right: 1em;
  text-align: left;
}

TD
{
  padding-left:  10px;
  padding-right: 1em;
  white-space:nowrap;
}

TD.ExceptionMsgFail, TR.ExceptionRowFail TD
{
  background: #F0C0C0;
}

TD.ExceptionMsgWarn, TR.ExceptionRowWarn TD
{
  background: #E8E0A0;
}

TD.ExceptionMsgFail
{
  border-bottom:  1px solid #D0B0B0;
}

TD.ExceptionMsgWarn
{
  border-bottom:  1px solid #C0C0B0;
}

TD.ExceptionMsgFail, TD.ExceptionMsgWarn
{
  padding-top:    0.5em;
  padding-bottom: 0.5em;
  white-space:normal;
}

TD.ExceptionValue
{
  paddin</style>
  </xsl:template>
  
</xsl:stylesheet>