set serveroutput on size 1000000
--METADATA NAME:dbtk_clear_database_objects TYPE:EXEC
DECLARE
  CURSOR seq IS
   select sequence_name, ut.table_name, column_name
   from user_sequences us, user_tables ut, user_tab_columns utc
   where ut.table_name = substr(us.sequence_name,5,length(us.sequence_name))
   and utc.table_name = ut.table_name and utc.column_id = 1
   and data_type = 'NUMBER';

  vsql varchar2(4000);
  vcnt pls_integer;
BEGIN

  
  FOR seq_rec IN seq LOOP
    vsql := 'select nvl(max(' || seq_rec.column_name || '),0) from ' || seq_rec.table_name;
    execute immediate vsql into vcnt;
    dbms_output.put_line(seq_rec.table_name||':'||to_char(vcnt));
    execute immediate 'drop sequence ' || seq_rec.sequence_name;
    vsql := 'create sequence ' || seq_rec.sequence_name || ' start with ' || to_char(vcnt+1);
    dbms_output.put_line(vsql);
    execute immediate vsql;
  END LOOP;

END;
/
show err
