--CONNECT USERNAME:pxrptuser
     
--METADATA  TYPE:SSCR NAME:RESOURCELIMIT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELIMIT ' and type='V')
  DROP VIEW RESOURCELIMIT 
go

print 'creating view RESOURCELIMIT'
go
     

--METADATA NAME:RESOURCELIMIT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCELIMIT
AS SELECT a.rsrc_id resourceobjectid
,a.startdate startdate
,a.enddate enddate
,a.limit limit
,a.update_date lastupdatedate
FROM dbo.RESOURCELIMIT A
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITY ' and type='V')
  DROP VIEW ACTIVITY 
go

print 'creating view ACTIVITY'
go
     

--METADATA NAME:ACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITY
AS SELECT a.task_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.clndr_id calendarobjectid
,a.rev_fdbk_flag isnewfeedback
,a.auto_compute_act_flag autocomputeactuals
,CASE a.complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.complete_pct_type END percentcompletetype
,CASE a.task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.task_type END type
,CASE a.duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.duration_type END durationtype
,CASE a.review_type WHEN 'RV_OK' THEN 'OK' WHEN 'RV_Review' THEN 'For Review' WHEN 'RV_Reject' THEN 'Reject' ELSE a.review_type END reviewstatus
,CASE a.status_code WHEN 'TK_NotStart' THEN 'Not Started' WHEN 'TK_Active' THEN 'In Progress' WHEN 'TK_Complete' THEN 'Completed' ELSE a.status_code END status
,a.task_code id
,a.task_name name
,a.rsrc_id primaryresourceobjectid
,a.total_float_hr_cnt totalfloat
,a.free_float_hr_cnt freefloat
,a.remain_drtn_hr_cnt remainingduration
,a.act_work_qty actuallaborunits
,a.remain_work_qty remaininglaborunits
,a.target_work_qty plannedlaborunits
,a.target_drtn_hr_cnt plannedduration
,a.target_equip_qty plannednonlaborunits
,a.act_equip_qty actualnonlaborunits
,a.remain_equip_qty remainingnonlaborunits
,a.cstr_date primaryconstraintdate
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.late_start_date latestartdate
,a.late_end_date latefinishdate
,a.expect_end_date expectedfinishdate
,a.early_start_date earlystartdate
,a.early_end_date earlyfinishdate
,a.restart_date remainingearlystartdate
,a.reend_date remainingearlyfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.review_end_date reviewfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.cstr_type WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type END primaryconstrainttype
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END levelingpriority
,a.cstr_date2 secondaryconstraintdate
,CASE a.cstr_type2 WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type2 END secondaryconstrainttype
,a.float_path floatpath
,a.float_path_order floatpathorder
,a.act_this_per_work_qty actualthisperiodlaborunits
,a.act_this_per_equip_qty actualthisperiodnonlaborunits
,a.driving_path_flag islongestpath
,a.suspend_date suspenddate
,a.resume_date resumedate
,a.external_early_start_date externalearlystartdate
,a.external_late_end_date externallatefinishdate
,P.accountingvariance accountingvariance
,P.accountingvariancelaborunits accountingvariancelaborunits
,P.actualduration actualduration
,P.actualexpensecost actualexpensecost
,P.actuallaborcost actuallaborcost
,P.actualmaterialcost actualmaterialcost
,P.actualnonlaborcost actualnonlaborcost
,P.actualthisperiodlaborcost actualthisperiodlaborcost
,P.actualthisperiodmaterialcost actualthisperiodmaterialcost
,P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost
,P.actualtotalcost actualtotalcost
,P.actualtotalunits actualtotalunits
,P.atcompletionduration atcompletionduration
,P.atcompletionexpensecost atcompletionexpensecost
,P.atcompletionlaborcost atcompletionlaborcost
,P.atcompletionlaborunits atcompletionlaborunits
,P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance
,P.atcompletionmaterialcost atcompletionmaterialcost
,P.atcompletionnonlaborcost atcompletionnonlaborcost
,P.atcompletionnonlaborunits atcompletionnonlaborunits
,P.atcompletiontotalcost atcompletiontotalcost
,P.atcompletiontotalunits atcompletiontotalunits
,P.atcompletionvariance atcompletionvariance
,P.baselineduration baselineduration
,P.baselinefinishdate baselinefinishdate
,P.baselineplannedduration baselineplannedduration
,P.baselineplannedexpensecost baselineplannedexpensecost
,P.baselineplannedlaborcost baselineplannedlaborcost
,P.baselineplannedlaborunits baselineplannedlaborunits
,P.baselineplannedmaterialcost baselineplannedmaterialcost
,P.baselineplannednonlaborcost baselineplannednonlaborcost
,P.baselineplannednonlaborunits baselineplannednonlaborunits
,P.baselineplannedtotalcost baselineplannedtotalcost
,P.baselinestartdate baselinestartdate
,P.baselinelatestartdate baselinelatestartdate
,P.baseline1latestartdate baseline1latestartdate
,P.baselinelatefinishdate baselinelatefinishdate
,P.baseline1latefinishdate baseline1latefinishdate
,P.budgetatcompletion budgetatcompletion
,P.calendarname calendarname
,P.costpercentcomplete costpercentcomplete
,P.costpercentofplanned costpercentofplanned
,P.costperformanceindex costperformanceindex
,P.costperformanceindexlaborunits costperformanceindexlaborunits
,P.costvariance costvariance
,P.costvarianceindex costvarianceindex
,P.costvarianceindexlaborunits costvarianceindexlaborunits
,P.costvariancelaborunits costvariancelaborunits
,(select datadate from dbo.projectx px where px.proj_id=a.proj_id) as  datadate
,P.duration1variance duration1variance
,P.durationpercentcomplete durationpercentcomplete
,P.durationpercentofplanned durationpercentofplanned
,P.durationvariance durationvariance
,P.earnedvaluecost earnedvaluecost
,P.earnedvaluelaborunits earnedvaluelaborunits
,P.estimateatcompletioncost estimateatcompletioncost
,P.estimateatcompletionlaborunits estimateatcompletionlaborunits
,P.estimatetocomplete estimatetocomplete
,P.estimatetocompletelaborunits estimatetocompletelaborunits
,P.expensecost1variance expensecost1variance
,P.expensecostpercentcomplete expensecostpercentcomplete
,P.expensecostvariance expensecostvariance
,P.finishdate finishdate
,P.finishdate1variance finishdate1variance
,P.finishdatevariance finishdatevariance
,P.iscritical iscritical
,P.laborcost1variance laborcost1variance
,P.laborcostpercentcomplete laborcostpercentcomplete
,P.laborcostvariance laborcostvariance
,P.laborunits1variance laborunits1variance
,P.laborunitspercentcomplete laborunitspercentcomplete
,P.laborunitsvariance laborunitsvariance
,P.materialcost1variance materialcost1variance
,P.materialcostpercentcomplete materialcostpercentcomplete
,P.materialcostvariance materialcostvariance
,P.nonlaborcost1variance nonlaborcost1variance
,P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete
,P.nonlaborcostvariance nonlaborcostvariance
,P.nonlaborunits1variance nonlaborunits1variance
,P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete
,P.nonlaborunitsvariance nonlaborunitsvariance
,P.percentcomplete percentcomplete
,P.performancepercentcomplete performancepercentcomplete
,P.physicalpercentcomplete physicalpercentcomplete
,P.plannedexpensecost plannedexpensecost
,P.plannedlaborcost plannedlaborcost
,P.plannedmaterialcost plannedmaterialcost
,P.plannednonlaborcost plannednonlaborcost
,P.plannedtotalcost plannedtotalcost
,P.plannedtotalunits plannedtotalunits
,P.plannedvaluecost plannedvaluecost
,P.plannedvaluelaborunits plannedvaluelaborunits
,P.primaryresourceid primaryresourceid
,P.primaryresourcename primaryresourcename
,P.remainingexpensecost remainingexpensecost
,P.remainingfloat remainingfloat
,P.remaininglaborcost remaininglaborcost
,P.remainingmaterialcost remainingmaterialcost
,P.remainingnonlaborcost remainingnonlaborcost
,P.remainingtotalcost remainingtotalcost
,P.remainingtotalunits remainingtotalunits
,P.schedulepercentcomplete schedulepercentcomplete
,P.scheduleperfindexlaborunits scheduleperfindexlaborunits
,P.scheduleperformanceindex scheduleperformanceindex
,P.schedulevariance schedulevariance
,P.schedulevarianceindex schedulevarianceindex
,P.schedulevariancelaborunits schedulevariancelaborunits
,P.schedulevarindexlaborunits schedulevarindexlaborunits
,P.startdate startdate
,P.startdate1variance startdate1variance
,P.startdatevariance startdatevariance
,P.tocompleteperformanceindex tocompleteperformanceindex
,P.totalcost1variance totalcost1variance
,P.totalcostvariance totalcostvariance
,P.unitspercentcomplete unitspercentcomplete
,P.wbscode wbscode
,P.wbsname wbsname
,a.location_id locationobjectid
,P.locationname locationname
,a.control_updates_flag reviewrequired
,a.starred_flag isstarred
,a.cbs_code cbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
,P.activityownerobjectid activityownerobjectid
,P.activityowner activityowner 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
FROM dbo.TASK A 
   INNER JOIN dbo.TASKX P
   ON a.task_id = p.task_id
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null
AND projects_tab.ORIG_PROJ_ID IS NULL
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODE ' and type='V')
  DROP VIEW ACTIVITYCODE 
go

print 'creating view ACTIVITYCODE'
go
     

--METADATA NAME:ACTIVITYCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODE
AS SELECT a.actv_code_id objectid
,a.actv_code_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.short_name codevalue
,a.parent_actv_code_id parentobjectid
,a.actv_code_name description
,P.codetypename codetypename
,P.issecurecode issecurecode
,P.projectobjectid projectobjectid
,P.codetypescope codetypescope
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ACTVCODE A 
   INNER JOIN dbo.ACTVCODEX P
   ON a.actv_code_id = p.actv_code_id 
   LEFT OUTER JOIN dbo.project PROJ
   ON PROJ.proj_id = p.projectobjectid 
WHERE A.DELETE_SESSION_ID is null 
AND (p.projectobjectid is null
          OR (PROJ.orig_proj_id is null 
               AND PROJ.proj_id is not null))
     
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEASSIGNMENT ' and type='V')
  DROP VIEW ACTIVITYCODEASSIGNMENT 
go

print 'creating view ACTIVITYCODEASSIGNMENT'
go
     

--METADATA NAME:ACTIVITYCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEASSIGNMENT
AS SELECT a.task_id activityobjectid
,a.actv_code_type_id activitycodetypeobjectid
,a.actv_code_id activitycodeobjectid
,a.proj_id projectobjectid
,P.activitycodedescription activitycodedescription
,P.activitycodetypename activitycodetypename
,P.activitycodetypescope activitycodetypescope
,P.activitycodevalue activitycodevalue
,P.activityid activityid
,P.activityname activityname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKACTV A 
   INNER JOIN dbo.TASKACTVX P
   ON a.task_id = p.task_id and a.actv_code_type_id = p.actv_code_type_id 
   INNER JOIN dbo.project PROJ
   ON PROJ.proj_id = a.proj_id and PROJ.orig_proj_id is null
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODETYPE ' and type='V')
  DROP VIEW ACTIVITYCODETYPE 
go

print 'creating view ACTIVITYCODETYPE'
go
     

--METADATA NAME:ACTIVITYCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODETYPE
AS SELECT a.actv_code_type_id objectid
,a.actv_short_len length
,a.seq_num sequencenumber
,a.actv_code_type name
,CASE a.actv_code_type_scope WHEN 'AS_Global' THEN 'Global' WHEN 'AS_EPS' THEN 'EPS' WHEN 'AS_Project' THEN 'Project' ELSE a.actv_code_type_scope END scope
,CASE WHEN a.actv_code_type_scope = 'AS_Project' THEN a.proj_id ELSE null END projectobjectid
,CASE WHEN a.actv_code_type_scope = 'AS_EPS' THEN (select min(p.wbs_id) from dbo.projwbs p where p.proj_id=a.proj_id and p.proj_node_flag='Y')  ELSE null END epsobjectid
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ACTVTYPE A 
   LEFT OUTER JOIN dbo.project PROJ
   ON PROJ.proj_id = a.proj_id 
WHERE A.DELETE_SESSION_ID is null 
AND (A.proj_id IS NULL
          OR (PROJ.orig_proj_id IS NULL
               AND PROJ.proj_id IS NOT NULL))
     
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYEXPENSE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYEXPENSE ' and type='V')
  DROP VIEW ACTIVITYEXPENSE 
go

print 'creating view ACTIVITYEXPENSE'
go
     

--METADATA NAME:ACTIVITYEXPENSE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYEXPENSE
AS SELECT a.cost_item_id objectid
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.auto_compute_act_flag autocomputeactuals
,CASE a.cost_load_type WHEN 'CL_Start' THEN 'Start of Activity' WHEN 'CL_End' THEN 'End of Activity' WHEN 'CL_Uniform' THEN 'Uniform over Activity' ELSE a.cost_load_type END accrualtype
,a.acct_id costaccountobjectid
,a.cost_type_id expensecategoryobjectid
,a.cbs_id cbsobjectid
,a.target_cost plannedcost
,a.act_cost actualcost
,a.remain_cost remainingcost
,a.qty_name unitofmeasure
,a.target_qty plannedunits
,a.cost_per_qty priceperunit
,a.po_number documentnumber
,a.vendor_name vendor
,a.cost_name expenseitem
,a.cost_descr expensedescription
,P.activityid activityid
,P.activityname activityname
,P.actualunits actualunits
,P.atcompletioncost atcompletioncost
,P.atcompletionunits atcompletionunits
,P.costaccountid costaccountid
,P.costaccountname costaccountname
,c.cbs_code cbscode
,c.description cbsname
,P.expensecategoryname expensecategoryname
,P.expensepercentcomplete expensepercentcomplete
,P.overbudget overbudget
,P.projectid projectid
,P.remainingunits remainingunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROJCOST A 
   INNER JOIN dbo.PROJCOSTX P
   ON a.cost_item_id = p.cost_item_id 
   LEFT OUTER JOIN dbo.cbs c
   ON a.cbs_id = c.cbs_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTE ' and type='V')
  DROP VIEW ACTIVITYNOTE 
go

print 'creating view ACTIVITYNOTE'
go
     

--METADATA NAME:ACTIVITYNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYNOTE
AS SELECT a.memo_id objectid
,a.task_id activityobjectid
,a.memo_type_id notebooktopicobjectid
,a.proj_id projectobjectid
,a.task_memo note
,P.activityid activityid
,P.activityname activityname
,P.notebooktopicname notebooktopicname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKMEMO A 
   INNER JOIN dbo.TASKMEMOX P
   ON a.memo_id = p.memo_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYPERIODACTUAL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYPERIODACTUAL ' and type='V')
  DROP VIEW ACTIVITYPERIODACTUAL 
go

print 'creating view ACTIVITYPERIODACTUAL'
go
     

--METADATA NAME:ACTIVITYPERIODACTUAL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYPERIODACTUAL
AS SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_work_qty actuallaborunits
,a.act_work_cost actuallaborcost
,a.act_equip_qty actualnonlaborunits
,a.act_equip_cost actualnonlaborcost
,a.act_mat_cost actualmaterialcost
,a.act_expense_cost actualexpensecost
,a.bcwp earnedvaluecost
,a.sched_work_qty plannedvaluelaborunits
,a.bcws plannedvaluecost
,a.perfm_work_qty earnedvaluelaborunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKFIN A 
   INNER JOIN dbo.TASKFINX P
   ON a.fin_dates_id = p.fin_dates_id and a.task_id = p.task_id
   INNER JOIN dbo.FINDATES FD
   ON a.fin_dates_id = fd.fin_dates_id  
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYRISK  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYRISK ' and type='V')
  DROP VIEW ACTIVITYRISK 
go

print 'creating view ACTIVITYRISK'
go
     

--METADATA NAME:ACTIVITYRISK TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYRISK
AS SELECT a.task_id activityobjectid
,a.proj_id projectobjectid
,a.risk_id riskobjectid
,P.projectid projectid
,P.projectname projectname
,P.activityid activityid
,P.activityname activityname
,P.riskname riskname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKRISK A 
   INNER JOIN dbo.TASKRISKX P
   ON a.task_id = p.task_id and a.risk_id = p.risk_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEP  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEP ' and type='V')
  DROP VIEW ACTIVITYSTEP 
go

print 'creating view ACTIVITYSTEP'
go
     

--METADATA NAME:ACTIVITYSTEP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEP
AS SELECT a.proc_id objectid
,a.task_id activityobjectid
,a.seq_num sequencenumber
,a.proj_id projectobjectid
,a.complete_flag iscompleted
,a.proc_name name
,a.proc_wt weight
,a.complete_pct percentcomplete
,a.proc_descr description
,P.activityid activityid
,P.activityname activityname
,P.projectid projectid
,P.wbsobjectid wbsobjectid
,P.weightpercent weightpercent
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKPROC A 
   INNER JOIN dbo.TASKPROCX P
   ON a.proc_id = p.proc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:BASELINETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BASELINETYPE ' and type='V')
  DROP VIEW BASELINETYPE 
go

print 'creating view BASELINETYPE'
go
     

--METADATA NAME:BASELINETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BASELINETYPE
AS SELECT a.base_type_id objectid
,a.base_type_seq_num sequencenumber
,a.base_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.BASETYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:CALENDAR  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CALENDAR ' and type='V')
  DROP VIEW CALENDAR 
go

print 'creating view CALENDAR'
go
     

--METADATA NAME:CALENDAR TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW CALENDAR
AS SELECT a.clndr_id objectid
,a.default_flag isdefault
,a.clndr_name name
,a.proj_id projectobjectid
,a.base_clndr_id basecalendarobjectid
,a.last_chng_date lastchangedate
,CASE a.clndr_type WHEN 'CA_Base' THEN 'Global' WHEN 'CA_Project' THEN 'Project' WHEN 'CA_Rsrc' THEN 'Resource' ELSE a.clndr_type END type
,P.daydate daydate
,P.weekdaynumber weekdaynumber
,P.workdayflag workdayflag
,P.totalworkhours totalworkhours
,P.workhoursbyhalfhour workhoursbyhalfhour
,P.workdaystarttime workdaystarttime
,P.workdayfinishtime workdayfinishtime
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
FROM dbo.CALENDAR A 
   INNER JOIN dbo.CALENDARX P
   ON a.clndr_id = p.clndr_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:CHANGESET  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHANGESET ' and type='V')
  DROP VIEW CHANGESET 
go

print 'creating view CHANGESET'
go
     

--METADATA NAME:CHANGESET TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW CHANGESET
AS SELECT a.transaction_id objectid
,a.transaction_date changedate
,a.request_user_name requestusername
,a.request_user_id requestuserobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.CHGHEAD A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYUPDATE ' and type='V')
  DROP VIEW ACTIVITYUPDATE 
go

print 'creating view ACTIVITYUPDATE'
go
     

--METADATA NAME:ACTIVITYUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,a.resubmitted_date resubmitteddate
,a.rejected_date rejecteddate
,a.new_act_start_date pendingactualstartdate
,a.ovr_act_start_date overrideactualstartdate
,a.new_act_end_date pendingactualfinishdate
,a.ovr_act_end_date overrideactualfinishdate
,a.new_remain_drtn pendingremainingduration
,a.ovr_remain_drtn overrideremainingduration
,a.new_complete_pct pendingpercentcomplete
,a.ovr_complete_pct overridepercentcomplete
,a.ovr_act_work_qty overrideactuallaborunits
,a.new_act_work_qty pendingactuallaborunits
,a.new_act_equip_qty pendingactualnonlaborunits
,a.ovr_act_equip_qty overrideactualnonlaborunits
,a.ovr_remain_work_qty overrideremaininglaborunits
,a.new_remain_work_qty pendingremaininglaborunits
,a.ovr_remain_equip_qty overrideremainingnonlaborunits
,a.new_remain_equip_qty pendingremainingnonlaborunits
,CASE WHEN YEAR(new_exp_end_date) = '4019' then null ELSE new_exp_end_date END pendingexpectedfinishdate
,CASE WHEN YEAR(ovr_exp_end_date) = '4019' then null ELSE ovr_exp_end_date END overrideexpectedfinishdate
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
FROM dbo.CHGTASK A 
   INNER JOIN dbo.CHGTASKX P
   ON a.transaction_id = p.transaction_id and a.task_id = p.task_id
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPUPDATE ' and type='V')
  DROP VIEW ACTIVITYSTEPUPDATE 
go

print 'creating view ACTIVITYSTEPUPDATE'
go
     

--METADATA NAME:ACTIVITYSTEPUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.proc_id activitystepobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,a.resubmitted_date resubmitteddate
,a.rejected_date rejecteddate
,P.changedate changedate
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.new_complete_pct pendingpercentcomplete
,a.ovr_complete_pct overridepercentcomplete
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
,P.pendingstepname pendingstepname
,P.overridestepname overridestepname
FROM dbo.CHGTASKPROC A 
   INNER JOIN dbo.CHGTASKPROCX P
   ON a.transaction_id = p.transaction_id and a.proc_id = p.proc_id
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPCREATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPCREATE ' and type='V')
  DROP VIEW ACTIVITYSTEPCREATE 
go

print 'creating view ACTIVITYSTEPCREATE'
go
     

--METADATA NAME:ACTIVITYSTEPCREATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPCREATE
AS SELECT a.proc_id activitystepobjectid
,a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,P.changedate changedate
,a.proc_name activitystepname
,a.complete_pct steppercentcomplete
,a.proc_wt stepweight
FROM dbo.ADDTASKPROC A 
   INNER JOIN dbo.ADDTASKPROCX P
   ON a.proc_id = p.proc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPDEL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPDEL ' and type='V')
  DROP VIEW ACTIVITYSTEPDEL 
go

print 'creating view ACTIVITYSTEPDEL'
go
     

--METADATA NAME:ACTIVITYSTEPDEL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPDEL
AS SELECT a.proc_id activitystepobjectid
,a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,P.changedate changedate
,a.proc_name activitystepname
FROM dbo.DELTASKPROC A 
   INNER JOIN dbo.DELTASKPROCX P
   ON a.proc_id = p.proc_id and a.transaction_id = p.transaction_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCOMMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCOMMENT ' and type='V')
  DROP VIEW ACTIVITYCOMMENT 
go

print 'creating view ACTIVITYCOMMENT'
go
     

--METADATA NAME:ACTIVITYCOMMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCOMMENT
AS SELECT a.discussion_id commentid
,a.task_id activityobjectid
,a.user_id userobjectid
,a.discussion_date commentdate
,a.discussion_value commenttext
FROM dbo.DISCUSSION A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEUPDATE ' and type='V')
  DROP VIEW ACTIVITYCODEUPDATE 
go

print 'creating view ACTIVITYCODEUPDATE'
go
     

--METADATA NAME:ACTIVITYCODEUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.actv_code_type_id activitycodetypeobjectid
,a.proj_id projectobjectid
,a.approval_user_id approvaluserobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,a.resubmitted_date resubmitteddate
,a.rejected_date rejecteddate
,a.ovr_actv_code_id overrideactivitycodeid
,a.new_actv_code_id pendingactivitycodeid
,P.requestuserobjectid requestuserobjectid
,a.approval_user_name approvalusername
,a.approval_date approvaldate
,a.held_date helddate
FROM dbo.CHGTASKACTV A 
   INNER JOIN dbo.CHGTASKACTVX P
   ON a.transaction_id = p.transaction_id and a.task_id = p.task_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTEUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTEUPDATE ' and type='V')
  DROP VIEW ACTIVITYNOTEUPDATE 
go

print 'creating view ACTIVITYNOTEUPDATE'
go
     

--METADATA NAME:ACTIVITYNOTEUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYNOTEUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.memo_id activitynoteobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
FROM dbo.CHGTASKMEMO A 
   INNER JOIN dbo.CHGTASKMEMOX P
   ON a.transaction_id = p.transaction_id and a.memo_id = p.memo_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:USERDEFINEDVALUEUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERDEFINEDVALUEUPDATE ' and type='V')
  DROP VIEW USERDEFINEDVALUEUPDATE 
go

print 'creating view USERDEFINEDVALUEUPDATE'
go
     

--METADATA NAME:USERDEFINEDVALUEUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW USERDEFINEDVALUEUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.udf_type_id udftypeobjectid
,a.fk_id foreignobjectid
,P.changedate changedate
,a.proj_id projectobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,a.resubmitted_date resubmitteddate
,a.rejected_date rejecteddate
,CASE a.ovr_udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.ovr_udf_text END overrideudftext
,CASE a.new_udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.new_udf_text END pendingudftext
,a.ovr_udf_date overrideudfstartdate
,a.new_udf_date pendingudfstartdate
,a.ovr_udf_date overrideudfenddate
,a.new_udf_date pendingudfenddate
,a.ovr_udf_code_id overrideudfcodeid
,a.new_udf_code_id pendingudfcodeid
,P.overrideudfnumber overrideudfnumber
,P.pendingudfnumber pendingudfnumber
,P.overrideudfinteger overrideudfinteger
,P.pendingudfinteger pendingudfinteger
,P.overrideudfcost overrideudfcost
,P.pendingudfcost pendingudfcost
,P.requestuserobjectid requestuserobjectid
,a.approval_user_id approvaluserobjectid
,a.approval_user_name approvalusername
,a.approval_date approvaldate
,a.held_date helddate
FROM dbo.CHGUDFVALUE A 
   INNER JOIN dbo.CHGUDFVALUEX P
   ON a.transaction_id = p.transaction_id and a.udf_type_id = p.udf_type_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTUPDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTUPDATE ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTUPDATE 
go

print 'creating view RESOURCEASSIGNMENTUPDATE'
go
     

--METADATA NAME:RESOURCEASSIGNMENTUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENTUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PARTIALLY_APPROVED' THEN 'Partially Approved' WHEN 'WITHDRAWN' THEN 'Withdrawn' ELSE a.status_code END status
,a.resubmitted_date resubmitteddate
,a.rejected_date rejecteddate
,a.proj_id projectobjectid
,a.new_act_start_date pendingactualstartdate
,a.ovr_act_start_date overrideactualstartdate
,a.new_act_end_date pendingactualfinishdate
,a.ovr_act_end_date overrideactualfinishdate
,a.ovr_act_reg_qty overrideactualunits
,a.new_act_reg_qty pendingactualunits
,a.ovr_remain_qty overrideremainingunits
,a.new_remain_qty pendingremainingunits
,a.new_remain_drtn pendingremainingduration
,a.ovr_remain_drtn overrideremainingduration
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,a.new_reend_date pendingremainingfinishdate
,a.ovr_reend_date overrideremainingfinishdate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
FROM dbo.CHGTRSRC A 
   INNER JOIN dbo.CHGTRSRCX P
   ON a.transaction_id = p.transaction_id and a.taskrsrc_id = p.taskrsrc_id
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNT ' and type='V')
  DROP VIEW COSTACCOUNT 
go

print 'creating view COSTACCOUNT'
go
     

--METADATA NAME:COSTACCOUNT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW COSTACCOUNT
AS SELECT a.acct_id objectid
,a.acct_seq_num sequencenumber
,a.acct_short_name id
,a.acct_name name
,a.parent_acct_id parentobjectid
,a.acct_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ACCOUNT A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:CURRENCY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CURRENCY ' and type='V')
  DROP VIEW CURRENCY 
go

print 'creating view CURRENCY'
go
     

--METADATA NAME:CURRENCY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW CURRENCY
AS SELECT a.curr_id objectid
,a.decimal_digit_cnt decimalplaces
,a.curr_symbol symbol
,CASE a.decimal_symbol WHEN '.' THEN 'Period' WHEN ',' THEN 'Comma' ELSE a.decimal_symbol END decimalsymbol
,CASE a.digit_group_symbol WHEN '.' THEN 'Period' WHEN ',' THEN 'Comma' ELSE a.digit_group_symbol END digitgroupingsymbol
,CASE a.pos_curr_fmt_type WHEN '#1.1' THEN '#1.1' WHEN '1.1#' THEN '1.1#' WHEN '# 1.1' THEN '# 1.1' WHEN '1.1 #' THEN '1.1 #' ELSE a.pos_curr_fmt_type END positivesymbol
,CASE a.neg_curr_fmt_type WHEN '(#1.1)' THEN '(#1.1)' WHEN '-#1.1' THEN '-#1.1' WHEN '#-1.1' THEN '#-1.1' WHEN '#1.1-' THEN '#1.1-' WHEN '(1.1#)' THEN '(1.1#)' WHEN '-1.1#' THEN '-1.1#' WHEN '1.1-#' THEN '1.1-#' WHEN '1.1#-' THEN '1.1#-' WHEN '-1.1 #' THEN '-1.1 #' WHEN '-# 1.1' THEN '-# 1.1' WHEN '1.1 #-' THEN '1.1 #-' WHEN '# 1.1-' THEN '# 1.1-' WHEN '# -1.1' THEN '# -1.1' WHEN '1.1- #' THEN '1.1- #' WHEN '(# 1.1)' THEN '(# 1.1)' WHEN '(1.1 #)' THEN '(1.1 #)' ELSE a.neg_curr_fmt_type END negativesymbol
,a.curr_type name
,a.curr_short_name id
,a.base_exch_rate exchangerate
,P.isbasecurrency isbasecurrency
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.CURRTYPE A 
   INNER JOIN dbo.CURRTYPEX P
   ON a.curr_id = p.curr_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENT ' and type='V')
  DROP VIEW DOCUMENT 
go

print 'creating view DOCUMENT'
go
     

--METADATA NAME:DOCUMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENT
AS SELECT a.doc_id objectid
,a.doc_seq_num sequencenumber
,a.deliv_flag deliverable
,a.doc_name title
,a.parent_doc_id parentobjectid
,a.proj_id projectobjectid
,a.doc_status_id documentstatuscodeobjectid
,a.doc_catg_id documentcategoryobjectid
,a.doc_date revisiondate
,a.version_name version
,a.doc_short_name referencenumber
,a.author_name author
,a.private_loc privatelocation
,a.public_loc publiclocation
,a.rsrc_id resourceobjectid
,a.doc_mgmt_type documenttype
,P.documentcategoryname documentcategoryname
,P.documentstatuscodename documentstatuscodename
,P.projectid projectid
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.DOCUMENT A 
   INNER JOIN dbo.DOCUMENTX P
   ON a.doc_id = p.doc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTCATEGORY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTCATEGORY ' and type='V')
  DROP VIEW DOCUMENTCATEGORY 
go

print 'creating view DOCUMENTCATEGORY'
go
     

--METADATA NAME:DOCUMENTCATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENTCATEGORY
AS SELECT a.doc_catg_id objectid
,a.seq_num sequencenumber
,a.doc_catg_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.DOCCATG A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTSTATUSCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTSTATUSCODE ' and type='V')
  DROP VIEW DOCUMENTSTATUSCODE 
go

print 'creating view DOCUMENTSTATUSCODE'
go
     

--METADATA NAME:DOCUMENTSTATUSCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENTSTATUSCODE
AS SELECT a.doc_status_id objectid
,a.seq_num sequencenumber
,a.doc_status_code name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.DOCSTAT A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EPS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPS ' and type='V')
  DROP VIEW EPS 
go

print 'creating view EPS'
go
     

--METADATA NAME:EPS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.wbs_name name
,a.parent_wbs_id parentobjectid
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.fullname fullname
,P.id id
,P.lastsummarizeddate lastsummarizeddate
,P.obsname obsname
,P.plannedstartdate plannedstartdate
,P.proposedbudget proposedbudget
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex
FROM dbo.PROJWBS A 
   INNER JOIN dbo.PROJWBSX P
   ON a.wbs_id = p.wbs_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EPSBUDGETCHANGELOG  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSBUDGETCHANGELOG ' and type='V')
  DROP VIEW EPSBUDGETCHANGELOG 
go

print 'creating view EPSBUDGETCHANGELOG'
go
     

--METADATA NAME:EPSBUDGETCHANGELOG TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSBUDGETCHANGELOG
AS SELECT a.budg_chng_id objectid
,a.proj_id projectobjectid
,a.wbs_id epsobjectid
,a.chng_date epsbudgetchangelogdate
,a.chng_short_name changenumber
,a.chng_cost amount
,a.chng_by_name responsible
,CASE a.status_code WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' ELSE a.status_code END status
,a.chng_descr reason
,P.epsid epsid
,P.epsname epsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.BUDGCHNG A 
   INNER JOIN dbo.BUDGCHNGX P
   ON a.budg_chng_id = p.budg_chng_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EPSFUNDING  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSFUNDING ' and type='V')
  DROP VIEW EPSFUNDING 
go

print 'creating view EPSFUNDING'
go
     

--METADATA NAME:EPSFUNDING TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSFUNDING
AS SELECT a.proj_fund_id objectid
,a.fund_id fundingsourceobjectid
,a.proj_id projectobjectid
,a.fund_cost amount
,a.fund_wt fundshare
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROJFUND A 
   INNER JOIN dbo.PROJFUNDX P
   ON a.proj_fund_id = p.proj_fund_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EPSNOTE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSNOTE ' and type='V')
  DROP VIEW EPSNOTE 
go

print 'creating view EPSNOTE'
go
     

--METADATA NAME:EPSNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSNOTE
AS SELECT a.wbs_memo_id objectid
,a.proj_id projectobjectid
,a.memo_type_id notebooktopicobjectid
,a.wbs_memo note
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,P.notebooktopicname notebooktopicname
,P.rawtextnote rawtextnote
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSMEMO A 
   INNER JOIN dbo.WBSMEMOX P
   ON a.wbs_memo_id = p.wbs_memo_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EPSSPENDINGPLAN  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPENDINGPLAN ' and type='V')
  DROP VIEW EPSSPENDINGPLAN 
go

print 'creating view EPSSPENDINGPLAN'
go
     

--METADATA NAME:EPSSPENDINGPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPENDINGPLAN
AS SELECT a.wbs_budg_id objectid
,a.proj_id projectobjectid
,a.spend_cost spendingplan
,a.benefit_cost benefitplan
,a.start_date spendingplandate
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSBUDG A 
   INNER JOIN dbo.WBSBUDGX P
   ON a.wbs_budg_id = p.wbs_budg_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:EXPENSECATEGORY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EXPENSECATEGORY ' and type='V')
  DROP VIEW EXPENSECATEGORY 
go

print 'creating view EXPENSECATEGORY'
go
     

--METADATA NAME:EXPENSECATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EXPENSECATEGORY
AS SELECT a.cost_type_id objectid
,a.seq_num sequencenumber
,a.cost_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.COSTTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:FINANCIALPERIOD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FINANCIALPERIOD ' and type='V')
  DROP VIEW FINANCIALPERIOD 
go

print 'creating view FINANCIALPERIOD'
go
     

--METADATA NAME:FINANCIALPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW FINANCIALPERIOD
AS SELECT a.fin_dates_id objectid
,a.fin_dates_name name
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.FINDATES A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:FUNDINGSOURCE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FUNDINGSOURCE ' and type='V')
  DROP VIEW FUNDINGSOURCE 
go

print 'creating view FUNDINGSOURCE'
go
     

--METADATA NAME:FUNDINGSOURCE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW FUNDINGSOURCE
AS SELECT a.fund_id objectid
,a.seq_num sequencenumber
,a.fund_name name
,a.parent_fund_id parentobjectid
,a.fund_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.FUNDSRC A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:GLOBALPROFILE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBALPROFILE ' and type='V')
  DROP VIEW GLOBALPROFILE 
go

print 'creating view GLOBALPROFILE'
go
     

--METADATA NAME:GLOBALPROFILE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW GLOBALPROFILE
AS SELECT a.prof_id objectid
,a.default_flag isdefault
,a.superuser_flag issuperuser
,a.prof_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROFILE A
WHERE A.DELETE_SESSION_ID is null 
AND SCOPE_TYPE = 'ST_Global'
     
go
     
--METADATA  TYPE:SSCR NAME:ISSUEHISTORY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ISSUEHISTORY ' and type='V')
  DROP VIEW ISSUEHISTORY 
go

print 'creating view ISSUEHISTORY'
go
     

--METADATA NAME:ISSUEHISTORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ISSUEHISTORY
AS SELECT a.issue_id projectissueobjectid
,a.proj_id projectobjectid
,a.issue_history notes
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ISSUHIST A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ITERATION  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATION ' and type='V')
  DROP VIEW ITERATION 
go

print 'creating view ITERATION'
go
     

--METADATA NAME:ITERATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ITERATION
AS SELECT a.iteration_id objectid
,a.iteration_name name
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ITERATION A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONACTIVITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONACTIVITY ' and type='V')
  DROP VIEW ITERATIONACTIVITY 
go

print 'creating view ITERATIONACTIVITY'
go
     

--METADATA NAME:ITERATIONACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ITERATIONACTIVITY
AS SELECT a.iteration_id iterationobjectid
,a.task_id activityobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ITERTASK A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONTEAM  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONTEAM ' and type='V')
  DROP VIEW ITERATIONTEAM 
go

print 'creating view ITERATIONTEAM'
go
     

--METADATA NAME:ITERATIONTEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ITERATIONTEAM
AS SELECT a.iteration_id iterationobjectid
,a.rfolio_id resourceteamobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ITERTEAM A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:LOCATION  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'LOCATION ' and type='V')
  DROP VIEW LOCATION 
go

print 'creating view LOCATION'
go
     

--METADATA NAME:LOCATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW LOCATION
AS SELECT a.location_id objectid
,a.location_name locationname
,a.location_type locationtype
,a.address_line1 addressline1
,a.address_line2 addressline2
,a.address_line3 addressline3
,a.city_name city
,a.municipality_name municipality
,a.state_name state
,a.state_code statecode
,a.country_name country
,a.country_code countrycode
,a.postal_code postalcode
,a.longitude longitude
,a.latitude latitude
,a.geo_location geolocation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.LOCATION A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:NOTEBOOKTOPIC  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'NOTEBOOKTOPIC ' and type='V')
  DROP VIEW NOTEBOOKTOPIC 
go

print 'creating view NOTEBOOKTOPIC'
go
     

--METADATA NAME:NOTEBOOKTOPIC TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW NOTEBOOKTOPIC
AS SELECT a.memo_type_id objectid
,a.seq_num sequencenumber
,a.eps_flag availableforeps
,a.proj_flag availableforproject
,a.wbs_flag availableforwbs
,a.task_flag availableforactivity
,a.memo_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.MEMOTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:OBS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBS ' and type='V')
  DROP VIEW OBS 
go

print 'creating view OBS'
go
     

--METADATA NAME:OBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW OBS
AS SELECT a.obs_id objectid
,a.seq_num sequencenumber
,a.obs_name name
,a.parent_obs_id parentobjectid
,a.obs_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.OBS A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:OVERHEADCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OVERHEADCODE ' and type='V')
  DROP VIEW OVERHEADCODE 
go

print 'creating view OVERHEADCODE'
go
     

--METADATA NAME:OVERHEADCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW OVERHEADCODE
AS SELECT a.nonwork_type_id objectid
,a.seq_num sequencenumber
,a.nonwork_code name
,a.nonwork_type description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.NONWORK A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT ' and type='V')
  DROP VIEW PROJECT 
go

print 'creating view PROJECT'
go
     

--METADATA NAME:PROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECT
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,P.annualdiscountrate annualdiscountrate
,P.anticipatedfinishdate anticipatedfinishdate
,P.anticipatedstartdate anticipatedstartdate
,P.containssummarydata containssummarydata
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.datadate datadate
,P.discountapplicationperiod discountapplicationperiod
,P.distributedcurrentbudget distributedcurrentbudget
,P.earnedvaluecomputetype earnedvaluecomputetype
,P.earnedvalueetccomputetype earnedvalueetccomputetype
,P.earnedvalueetcuservalue earnedvalueetcuservalue
,P.earnedvalueuserpercent earnedvalueuserpercent
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.independentetclaborunits independentetclaborunits
,P.independentetctotalcost independentetctotalcost
,P.name name
,P.obsname obsname
,P.obsobjectid obsobjectid
,P.originalbudget originalbudget
,P.overallprojectscore overallprojectscore
,P.parentepsobjectid parentepsobjectid
,P.proposedbudget proposedbudget
,P.risklevel risklevel
,P.riskscore riskscore
,P.riskexposure riskexposure
,P.startdate startdate
,P.status status
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.netpresentvalue netpresentvalue
,P.returnoninvestment returnoninvestment
,P.paybackperiod paybackperiod
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,P.locationname locationname
,a.control_updates_flag allowstatusreview
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,P.update_dim_date lastupdatedatex
FROM dbo.PROJECT A 
   INNER JOIN dbo.PROJECTX P
   ON a.proj_id = p.proj_id 
   AND a.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
AND a.ORIG_PROJ_ID IS NULL
go
     
--METADATA  TYPE:SSCR NAME:PROJECTBUDGETCHANGELOG  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTBUDGETCHANGELOG ' and type='V')
  DROP VIEW PROJECTBUDGETCHANGELOG 
go

print 'creating view PROJECTBUDGETCHANGELOG'
go
     

--METADATA NAME:PROJECTBUDGETCHANGELOG TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTBUDGETCHANGELOG
AS SELECT a.budg_chng_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.chng_date projectbudgetchangelogdate
,a.chng_short_name changenumber
,a.chng_cost amount
,a.chng_by_name responsible
,CASE a.status_code WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' ELSE a.status_code END status
,a.chng_descr reason
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.BUDGCHNG A 
   INNER JOIN dbo.BUDGCHNGX P
   ON a.budg_chng_id = p.budg_chng_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODE ' and type='V')
  DROP VIEW PROJECTCODE 
go

print 'creating view PROJECTCODE'
go
     

--METADATA NAME:PROJECTCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODE
AS SELECT a.proj_catg_id objectid
,a.proj_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.proj_catg_short_name codevalue
,a.parent_proj_catg_id parentobjectid
,a.proj_catg_name description
,a.proj_catg_wt weight
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PCATVAL A 
   INNER JOIN dbo.PCATVALX P
   ON a.proj_catg_id = p.proj_catg_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEASSIGNMENT ' and type='V')
  DROP VIEW PROJECTCODEASSIGNMENT 
go

print 'creating view PROJECTCODEASSIGNMENT'
go
     

--METADATA NAME:PROJECTCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEASSIGNMENT
AS SELECT a.proj_id projectobjectid
,a.proj_catg_type_id projectcodetypeobjectid
,a.proj_catg_id projectcodeobjectid
,P.projectcodedescription projectcodedescription
,P.projectcodetypename projectcodetypename
,P.projectcodevalue projectcodevalue
,P.projectname projectname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROJPCAT A 
   INNER JOIN dbo.PROJPCATX P
   ON a.proj_id = p.proj_id and a.proj_catg_type_id = p.proj_catg_type_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODETYPE ' and type='V')
  DROP VIEW PROJECTCODETYPE 
go

print 'creating view PROJECTCODETYPE'
go
     

--METADATA NAME:PROJECTCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODETYPE
AS SELECT a.proj_catg_type_id objectid
,a.seq_num sequencenumber
,a.proj_catg_short_len length
,a.proj_catg_type name
,a.super_flag issecurecode
,a.proj_catg_type_wt weight
,a.max_proj_catg_wt maxcodevalueweight
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PCATTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEUSER  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEUSER ' and type='V')
  DROP VIEW PROJECTCODEUSER 
go

print 'creating view PROJECTCODEUSER'
go
     

--METADATA NAME:PROJECTCODEUSER TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEUSER
AS SELECT a.proj_catg_id codeobjectid
,a.user_id userobjectid
,P.codetypeobjectid codetypeobjectid
,P.codevalue codevalue
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PCATUSER A 
   INNER JOIN dbo.PCATUSERX P
   ON a.proj_catg_id = p.proj_catg_id and a.user_id = p.user_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTDOCUMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTDOCUMENT ' and type='V')
  DROP VIEW PROJECTDOCUMENT 
go

print 'creating view PROJECTDOCUMENT'
go
     

--METADATA NAME:PROJECTDOCUMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTDOCUMENT
AS SELECT a.taskdoc_id objectid
,a.doc_id documentobjectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.wp_flag isworkproduct
,a.task_id activityobjectid
,P.activityid activityid
,P.activityname activityname
,P.documenttitle documenttitle
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKDOC A 
   INNER JOIN dbo.TASKDOCX P
   ON a.taskdoc_id = p.taskdoc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTFUNDING  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTFUNDING ' and type='V')
  DROP VIEW PROJECTFUNDING 
go

print 'creating view PROJECTFUNDING'
go
     

--METADATA NAME:PROJECTFUNDING TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTFUNDING
AS SELECT a.proj_fund_id objectid
,a.fund_id fundingsourceobjectid
,a.proj_id projectobjectid
,a.fund_cost amount
,a.fund_wt fundshare
,P.projectid projectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROJFUND A 
   INNER JOIN dbo.PROJFUNDX P
   ON a.proj_fund_id = p.proj_fund_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTISSUE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTISSUE ' and type='V')
  DROP VIEW PROJECTISSUE 
go

print 'creating view PROJECTISSUE'
go
     

--METADATA NAME:PROJECTISSUE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTISSUE
AS SELECT a.issue_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END priority
,CASE a.status_code WHEN 'IS_Open' THEN 'Open' WHEN 'IS_On_Hold' THEN 'On Hold' WHEN 'IS_Closed' THEN 'Closed' ELSE a.status_code END status
,a.issue_name name
,a.thresh_id projectthresholdobjectid
,a.wbs_id wbsobjectid
,a.task_id activityobjectid
,a.rsrc_id resourceobjectid
,a.thresh_parm_id thresholdparameterobjectid
,a.issue_value actualvalue
,a.lo_parm_value lowerthreshold
,a.hi_parm_value upperthreshold
,a.add_by_name identifiedby
,a.resolv_date resolutiondate
,a.add_date dateidentified
,a.issue_notes notes
,P.activityid activityid
,P.activityname activityname
,P.obsname obsname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.resourceid resourceid
,P.resourcename resourcename
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROJISSU A 
   INNER JOIN dbo.PROJISSUX P
   ON a.issue_id = p.issue_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTNOTE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTNOTE ' and type='V')
  DROP VIEW PROJECTNOTE 
go

print 'creating view PROJECTNOTE'
go
     

--METADATA NAME:PROJECTNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTNOTE
AS SELECT a.wbs_memo_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.memo_type_id notebooktopicobjectid
,a.wbs_memo note
,P.notebooktopicname notebooktopicname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSMEMO A 
   INNER JOIN dbo.WBSMEMOX P
   ON a.wbs_memo_id = p.wbs_memo_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPORTFOLIO  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPORTFOLIO ' and type='V')
  DROP VIEW PROJECTPORTFOLIO 
go

print 'creating view PROJECTPORTFOLIO'
go
     

--METADATA NAME:PROJECTPORTFOLIO TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPORTFOLIO
AS SELECT a.pfolio_id objectid
,a.closed_proj_flag includeclosedprojects
,a.whatif_proj_flag includewhatifprojects
,CASE a.pfolio_type WHEN 'PT_MAN' THEN 'Manual List' WHEN 'PT_AUTO' THEN 'Automatic List' WHEN 'PT_FLT' THEN 'Semi Automatic List' ELSE a.pfolio_type END type
,a.pfolio_name name
,a.user_id userobjectid
,a.pfolio_descr description
,u.user_name username
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PFOLIO A 
   LEFT OUTER JOIN dbo.USERS U
   ON a.user_id = u.user_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROFILE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROFILE ' and type='V')
  DROP VIEW PROJECTPROFILE 
go

print 'creating view PROJECTPROFILE'
go
     

--METADATA NAME:PROJECTPROFILE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPROFILE
AS SELECT a.prof_id objectid
,a.default_flag isdefault
,a.superuser_flag issuperuser
,a.prof_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROFILE A
WHERE A.DELETE_SESSION_ID is null 
AND SCOPE_TYPE = 'ST_Project'
     
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROJECTPORTFOLIO  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROJECTPORTFOLIO ' and type='V')
  DROP VIEW PROJECTPROJECTPORTFOLIO 
go

print 'creating view PROJECTPROJECTPORTFOLIO'
go
     

--METADATA NAME:PROJECTPROJECTPORTFOLIO TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPROJECTPORTFOLIO
AS SELECT a.pfolio_id projectportfolioobjectid
,P.proj_id projectobjectid
,a.update_user lastupdateuser
,case when a.update_date > b.update_date then a.update_date else b.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PRPFOLIO A 
   INNER JOIN dbo.pfolio B
   ON a.pfolio_id = b.pfolio_id
   INNER JOIN dbo.projwbs P
   ON a.wbs_id = p.wbs_id and p.proj_node_flag='Y'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCE ' and type='V')
  DROP VIEW PROJECTRESOURCE 
go

print 'creating view PROJECTRESOURCE'
go
     

--METADATA NAME:PROJECTRESOURCE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCE
AS SELECT a.wbsrsrc_id objectid
,a.wbs_id wbsobjectid
,a.rsrc_id resourceobjectid
,a.proj_id projectobjectid
,a.committed_flag committedflag
,a.start_date startdate
,a.end_date finishdate
,a.auto_compute_dates_flag lifeofprojectflag
,P.projectid projectid
,P.resourcename resourcename
,P.rolename rolename
,a.role_id roleobjectid
,P.status status
,P.wbscode wbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSRSRC A 
   INNER JOIN dbo.WBSRSRCX P
   ON a.wbsrsrc_id = p.wbsrsrc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCEQUANTITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCEQUANTITY ' and type='V')
  DROP VIEW PROJECTRESOURCEQUANTITY 
go

print 'creating view PROJECTRESOURCEQUANTITY'
go
     

--METADATA NAME:PROJECTRESOURCEQUANTITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCEQUANTITY
AS SELECT a.wbsrsrc_id projectresourceobjectid
,a.week_start weekstartdate
,a.month_start monthstartdate
,a.qty quantity
,P.committedflag committedflag
,P.projectobjectid projectobjectid
,P.resourceobjectid resourceobjectid
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSRSRC_QTY A 
   INNER JOIN dbo.WBSRSRC_QTYX P
   ON a.wbsrsrc_id = p.wbsrsrc_id and a.week_start = p.week_start and a.month_start = p.month_start
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISK  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISK ' and type='V')
  DROP VIEW RISK 
go

print 'creating view RISK'
go
     

--METADATA NAME:RISK TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISK
AS SELECT a.risk_id objectid
,a.proj_id projectobjectid
,a.id id
,a.name name
,a.total_cost totalcost
,a.rsrc_id resourceobjectid
,a.category_id riskcategoryobjectid
,CASE a.type WHEN 'RT_Threat' THEN 'Threat' WHEN 'RT_Opport' THEN 'Opportunity' ELSE a.type END risktype
,CASE a.status WHEN 'RS_Propose' THEN 'Proposed' WHEN 'RS_Open' THEN 'Open' WHEN 'RS_Active' THEN 'Active' WHEN 'RS_Reject' THEN 'Rejected (Closed)' WHEN 'RS_Manage' THEN 'Managed (Closed)' WHEN 'RS_Impact' THEN 'Impacted (Closed)' ELSE a.status END riskstatus
,a.description description
,a.effect effect
,a.cause cause
,a.note note
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,P.exposure exposure
,a.identified_by_id identifiedbyresourceobjectid
,P.identifiedbyresourceid identifiedbyresourceid
,P.identifiedbyresourcename identifiedbyresourcename
,a.identified_date identifieddate
,P.exposurestartdate exposurestartdate
,P.exposurefinishdate exposurefinishdate
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISK A 
   INNER JOIN dbo.RISKX P
   ON a.risk_id = p.risk_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKIMPACT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKIMPACT ' and type='V')
  DROP VIEW RISKIMPACT 
go

print 'creating view RISKIMPACT'
go
     

--METADATA NAME:RISKIMPACT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKIMPACT
AS SELECT a.risk_id riskobjectid
,a.proj_id projectobjectid
,a.scoretype_id riskthresholdobjectid
,a.threshold_id riskthresholdlevelobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKIMPACT A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTION  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTION ' and type='V')
  DROP VIEW RISKRESPONSEACTION 
go

print 'creating view RISKRESPONSEACTION'
go
     

--METADATA NAME:RISKRESPONSEACTION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTION
AS SELECT a.mitigation_id objectid
,a.response_id riskresponseplanobjectid
,a.rsrc_id resourceobjectid
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.id id
,a.name name
,CASE a.status WHEN 'MS_Propose' THEN 'Proposed' WHEN 'MS_Sanct' THEN 'Sanctioned' WHEN 'MS_Reject' THEN 'Rejected' WHEN 'MS_InProg' THEN 'In-Progress' WHEN 'MS_Compl' THEN 'Complete' ELSE a.status END riskresponseactionstatus
,P.actualcost actualcost
,P.remainingcost remainingcost
,P.plannedcost plannedcost
,P.physicalstartdate physicalstartdate
,P.physicalfinishdate physicalfinishdate
,P.physicalbasestartdate physicalbasestartdate
,P.physicalbasefinishdate physicalbasefinishdate
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKMIT A 
   INNER JOIN dbo.RISKMITX P
   ON a.mitigation_id = p.mitigation_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTIONIMPACT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTIONIMPACT ' and type='V')
  DROP VIEW RISKRESPONSEACTIONIMPACT 
go

print 'creating view RISKRESPONSEACTIONIMPACT'
go
     

--METADATA NAME:RISKRESPONSEACTIONIMPACT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTIONIMPACT
AS SELECT a.mitigation_id riskresponseactionobjectid
,a.proj_id projectobjectid
,a.scoretype_id riskthresholdobjectid
,a.threshold_id riskthresholdlevelobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKMITIMP A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEPLAN  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEPLAN ' and type='V')
  DROP VIEW RISKRESPONSEPLAN 
go

print 'creating view RISKRESPONSEPLAN'
go
     

--METADATA NAME:RISKRESPONSEPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEPLAN
AS SELECT a.response_id objectid
,a.risk_id riskobjectid
,a.proj_id projectobjectid
,a.id id
,a.name name
,a.used isactive
,CASE a.type WHEN 'RP_Avoid' THEN 'Avoid' WHEN 'RP_Trans' THEN 'Transfer' WHEN 'RP_Reduce' THEN 'Reduce' WHEN 'RP_Accept' THEN 'Accept' WHEN 'RP_Exploit' THEN 'Exploit' WHEN 'RP_Facil' THEN 'Facilitate' WHEN 'RP_Enhance' THEN 'Enhance' WHEN 'RP_Reject' THEN 'Reject' ELSE a.type END responsetype
,P.actualcost actualcost
,P.remainingcost remainingcost
,P.plannedcost plannedcost
,P.startdate startdate
,P.finishdate finishdate
,P.plannedstartdate plannedstartdate
,P.plannedfinishdate plannedfinishdate
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKRSPPLN A 
   INNER JOIN dbo.RISKRSPPLNX P
   ON a.response_id = p.response_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORETYPE ' and type='V')
  DROP VIEW RISKMATRIXSCORETYPE 
go

print 'creating view RISKMATRIXSCORETYPE'
go
     

--METADATA NAME:RISKMATRIXSCORETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKMATRIXSCORETYPE
AS SELECT a.matrix_id matrixid
,a.scoretype_id scoretypeid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.MTXSCRTYP A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKSCORETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCORETYPE ' and type='V')
  DROP VIEW RISKSCORETYPE 
go

print 'creating view RISKSCORETYPE'
go
     

--METADATA NAME:RISKSCORETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKSCORETYPE
AS SELECT a.scoretype_id scoretypeid
,a.name name
,CASE a.type WHEN 'ST_Prob' THEN 'Probability' WHEN 'ST_Tol' THEN 'Tolerance' WHEN 'ST_Sch' THEN 'Schedule Impact by value' WHEN 'ST_Cost' THEN 'Cost Impact by value' WHEN 'ST_RelSch' THEN 'Schedule Impact by percentage' WHEN 'ST_RelCost' THEN 'Cost Impact by percentage' WHEN 'ST_User' THEN 'User-defined Impact' ELSE a.type END scoretype
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKSCRTYP A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORE ' and type='V')
  DROP VIEW RISKMATRIXSCORE 
go

print 'creating view RISKMATRIXSCORE'
go
     

--METADATA NAME:RISKMATRIXSCORE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKMATRIXSCORE
AS SELECT a.score_id objectid
,a.matrix_id riskscorematrixobjectid
,a.probability_threshold_level probabilitythresholdlevel
,a.severity1 severity1
,a.severity2 severity2
,a.severity3 severity3
,a.severity4 severity4
,a.severity5 severity5
,a.severity6 severity6
,a.severity7 severity7
,a.severity8 severity8
,a.severity9 severity9
,a.severity1label severity1label
,a.severity2label severity2label
,a.severity3label severity3label
,a.severity4label severity4label
,a.severity5label severity5label
,a.severity6label severity6label
,a.severity7label severity7label
,a.severity8label severity8label
,a.severity9label severity9label
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKMTXSCR A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKSCOREMATRIX  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCOREMATRIX ' and type='V')
  DROP VIEW RISKSCOREMATRIX 
go

print 'creating view RISKSCOREMATRIX'
go
     

--METADATA NAME:RISKSCOREMATRIX TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKSCOREMATRIX
AS SELECT a.matrix_id objectid
,a.name name
,a.description description
,CASE a.method WHEN 'SM_High' THEN 'Highest Impact' WHEN 'SM_AvImps' THEN 'Average Impact' WHEN 'SM_AvIndiv' THEN 'Average Individual Impact' ELSE a.method END riskscoringmethod
,a.impact_levels impact_levels
,a.probability_levels probability_levels
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKSCRMTX A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKTHRESHOLDLEVEL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTHRESHOLDLEVEL ' and type='V')
  DROP VIEW RISKTHRESHOLDLEVEL 
go

print 'creating view RISKTHRESHOLDLEVEL'
go
     

--METADATA NAME:RISKTHRESHOLDLEVEL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKTHRESHOLDLEVEL
AS SELECT a.threshold_id objectid
,a.scoretype_id riskthresholdobjectid
,a.short_name code
,a.full_name name
,a.color color
,a.lvl riskscorelevel
,a.value value
,a.tolerance_value tolerancerange
,a.cost_value costrange
,a.schedule_value schedulerange
,a.probability_value probabiltyrange
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKSCRTHR A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPENDINGPLAN  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPENDINGPLAN ' and type='V')
  DROP VIEW PROJECTSPENDINGPLAN 
go

print 'creating view PROJECTSPENDINGPLAN'
go
     

--METADATA NAME:PROJECTSPENDINGPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPENDINGPLAN
AS SELECT a.wbs_budg_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.start_date spendingplandate
,a.spend_cost spendingplan
,a.benefit_cost benefitplan
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSBUDG A 
   INNER JOIN dbo.WBSBUDGX P
   ON a.wbs_budg_id = p.wbs_budg_id 
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RELATIONSHIP  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELATIONSHIP ' and type='V')
  DROP VIEW RELATIONSHIP 
go

print 'creating view RELATIONSHIP'
go
     

--METADATA NAME:RELATIONSHIP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RELATIONSHIP
AS SELECT a.task_pred_id objectid
,a.task_id successoractivityobjectid
,a.pred_task_id predecessoractivityobjectid
,a.proj_id successorprojectobjectid
,a.pred_proj_id predecessorprojectobjectid
,CASE a.pred_type WHEN 'PR_FS' THEN 'Finish to Start' WHEN 'PR_FF' THEN 'Finish to Finish' WHEN 'PR_SS' THEN 'Start to Start' WHEN 'PR_SF' THEN 'Start to Finish' ELSE a.pred_type END type
,a.lag_hr_cnt lag
,P.predecessoractivityid predecessoractivityid
,P.predecessoractivityname predecessoractivityname
,P.predecessorprojectid predecessorprojectid
,P.successoractivityid successoractivityid
,P.successoractivityname successoractivityname
,P.successorprojectid successorprojectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKPRED A 
   INNER JOIN dbo.TASKPREDX P
   ON a.task_pred_id = p.task_pred_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RELEASE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASE ' and type='V')
  DROP VIEW RELEASE 
go

print 'creating view RELEASE'
go
     

--METADATA NAME:RELEASE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RELEASE
AS SELECT a.release_id objectid
,a.release_name name
,a.start_date startdate
,a.release_theme releasetheme
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RELEASE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RELEASEPROJECT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEPROJECT ' and type='V')
  DROP VIEW RELEASEPROJECT 
go

print 'creating view RELEASEPROJECT'
go
     

--METADATA NAME:RELEASEPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RELEASEPROJECT
AS SELECT a.release_id releaseobjectid
,a.proj_id projectobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RELPROJ A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RELEASEITERATION  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEITERATION ' and type='V')
  DROP VIEW RELEASEITERATION 
go

print 'creating view RELEASEITERATION'
go
     

--METADATA NAME:RELEASEITERATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RELEASEITERATION
AS SELECT a.release_id releaseobjectid
,a.proj_id projectobjectid
,a.iteration_id iterationobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RELITER A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESASSIGNMENTPERIODACTUAL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESASSIGNMENTPERIODACTUAL ' and type='V')
  DROP VIEW RESASSIGNMENTPERIODACTUAL 
go

print 'creating view RESASSIGNMENTPERIODACTUAL'
go
     

--METADATA NAME:RESASSIGNMENTPERIODACTUAL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESASSIGNMENTPERIODACTUAL
AS SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_qty actualunits
,a.act_cost actualcost
,P.resourcetype resourcetype
,P.wbsobjectid wbsobjectid
,T.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TRSRCFIN A 
   INNER JOIN dbo.TRSRCFINX P
   ON a.fin_dates_id = p.fin_dates_id and a.taskrsrc_id = p.taskrsrc_id
   INNER JOIN dbo.taskrsrc T
   ON a.taskrsrc_id = T.taskrsrc_id and a.proj_id = t.proj_id 
   INNER JOIN dbo.FINDATES FD
   ON a.fin_dates_id = fd.fin_dates_id 
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEACCESS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEACCESS ' and type='V')
  DROP VIEW RESOURCEACCESS 
go

print 'creating view RESOURCEACCESS'
go
     

--METADATA NAME:RESOURCEACCESS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEACCESS
AS SELECT a.user_id userobjectid
,a.rsrc_id resourceobjectid
,P.resourceid resourceid
,P.resourcename resourcename
,P.username username
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
FROM dbo.RSRCSEC A 
   INNER JOIN dbo.RSRCSECX P
   ON a.user_id = p.user_id and a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENT ' and type='V')
  DROP VIEW RESOURCEASSIGNMENT 
go

print 'creating view RESOURCEASSIGNMENT'
go
     

--METADATA NAME:RESOURCEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENT
AS SELECT a.taskrsrc_id objectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,CASE a.rsrc_type WHEN 'RT_Labor' THEN 'Labor' WHEN 'RT_Equip' THEN 'Nonlabor' WHEN 'RT_Mat' THEN 'Material' ELSE a.rsrc_type END resourcetype
,a.cost_qty_link_flag iscostunitslinked
,a.role_id roleobjectid
,a.acct_id costaccountobjectid
,a.rsrc_id resourceobjectid
,P.proficiency proficiency
,a.pend_complete_pct pendingpercentcomplete
,a.remain_qty remainingunits
,a.pend_remain_qty pendingremainingunits
,a.target_qty plannedunits
,a.remain_qty_per_hr remainingunitspertime
,a.pend_act_reg_qty pendingactualregularunits
,a.target_lag_drtn_hr_cnt plannedlag
,a.target_qty_per_hr plannedunitspertime
,a.act_ot_qty actualovertimeunits
,a.pend_act_ot_qty pendingactualovertimeunits
,a.act_reg_qty actualregularunits
,P.remaininglag remaininglag
,a.ot_factor overtimefactor
,a.target_cost plannedcost
,a.act_reg_cost actualregularcost
,a.act_ot_cost actualovertimecost
,a.remain_cost remainingcost
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.restart_date remainingstartdate
,a.reend_date remainingfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.rate_type WHEN 'COST_PER_QTY' THEN 'Price/Unit' WHEN 'COST_PER_QTY2' THEN 'Price/Unit 2' WHEN 'COST_PER_QTY3' THEN 'Price/Unit 3' WHEN 'COST_PER_QTY4' THEN 'Price/Unit 4' WHEN 'COST_PER_QTY5' THEN 'Price/Unit 5' ELSE a.rate_type END ratetype
,a.act_this_per_cost actualthisperiodcost
,a.act_this_per_qty actualthisperiodunits
,a.curv_id resourcecurveobjectid
,a.rollup_dates_flag drivingactivitydatesflag
,CASE a.cost_per_qty_source_type WHEN 'ST_Rsrc' THEN 'Resource' WHEN 'ST_Role' THEN 'Role' WHEN 'ST_Custom' THEN 'Override' ELSE a.cost_per_qty_source_type END ratesource
,P.activityid activityid
,P.activityname activityname
,P.actualcost actualcost
,P.actualduration actualduration
,P.actualunits actualunits
,P.atcompletioncost atcompletioncost
,P.atcompletionduration atcompletionduration
,P.atcompletionunits atcompletionunits
,P.autocomputeactuals autocomputeactuals
,P.calendarobjectid calendarobjectid
,P.costaccountid costaccountid
,P.costaccountname costaccountname
,P.finishdate finishdate
,P.isactive isactive
,P.isovertimeallowed isovertimeallowed
,P.isprimaryresource isprimaryresource
,P.plannedduration plannedduration
,P.priceperunit priceperunit
,P.projectid projectid
,P.remainingduration remainingduration
,P.resourcecurvename resourcecurvename
,P.resourceid resourceid
,P.resourcename resourcename
,P.roleid roleid
,P.rolename rolename
,P.staffedremainingcost staffedremainingcost
,P.staffedremainingunits staffedremainingunits
,P.startdate startdate
,P.unitspercentcomplete unitspercentcomplete
,P.unstaffedremainingcost unstaffedremainingcost
,P.unstaffedremainingunits unstaffedremainingunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
FROM dbo.TASKRSRC A 
   INNER JOIN dbo.TASKRSRCX P
   ON a.taskrsrc_id = p.taskrsrc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODE ' and type='V')
  DROP VIEW ASSIGNMENTCODE 
go

print 'creating view ASSIGNMENTCODE'
go
     

--METADATA NAME:ASSIGNMENTCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODE
AS SELECT a.asgnmnt_catg_id objectid
,a.asgnmnt_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.asgnmnt_catg_short_name codevalue
,a.asgnmnt_catg_name description
,a.parent_asgnmnt_catg_id parentobjectid
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ASGNMNTCATVAL A 
   INNER JOIN dbo.ASGNMNTCATVALX P
   ON a.asgnmnt_catg_id = p.asgnmnt_catg_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODETYPE ' and type='V')
  DROP VIEW ASSIGNMENTCODETYPE 
go

print 'creating view ASSIGNMENTCODETYPE'
go
     

--METADATA NAME:ASSIGNMENTCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODETYPE
AS SELECT a.asgnmnt_catg_type_id objectid
,a.seq_num sequencenumber
,a.asgnmnt_catg_short_len length
,a.asgnmnt_catg_type name
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ASGNMNTCATTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODEASSIGNMENT ' and type='V')
  DROP VIEW ASSIGNMENTCODEASSIGNMENT 
go

print 'creating view ASSIGNMENTCODEASSIGNMENT'
go
     

--METADATA NAME:ASSIGNMENTCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODEASSIGNMENT
AS SELECT a.taskrsrc_id asgnmntobjectid
,a.asgnmnt_catg_type_id asgnmntcodetypeobjectid
,a.asgnmnt_catg_id asgnmntcodeobjectid
,P.asgnmntcodedescription asgnmntcodedescription
,P.asgnmntcodetypename asgnmntcodetypename
,P.asgnmntcodevalue asgnmntcodevalue
,P.asgnmntid asgnmntid
,P.asgnmntname asgnmntname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ASGNMNTACAT A 
   INNER JOIN dbo.ASGNMNTACATX P
   ON a.taskrsrc_id = p.taskrsrc_id and a.asgnmnt_catg_type_id = p.asgnmnt_catg_type_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODE ' and type='V')
  DROP VIEW RESOURCECODE 
go

print 'creating view RESOURCECODE'
go
     

--METADATA NAME:RESOURCECODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODE
AS SELECT a.rsrc_catg_id objectid
,a.rsrc_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.rsrc_catg_short_name codevalue
,a.rsrc_catg_name description
,a.parent_rsrc_catg_id parentobjectid
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RCATVAL A 
   INNER JOIN dbo.RCATVALX P
   ON a.rsrc_catg_id = p.rsrc_catg_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEASSIGNMENT ' and type='V')
  DROP VIEW RESOURCECODEASSIGNMENT 
go

print 'creating view RESOURCECODEASSIGNMENT'
go
     

--METADATA NAME:RESOURCECODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEASSIGNMENT
AS SELECT a.rsrc_id resourceobjectid
,a.rsrc_catg_type_id resourcecodetypeobjectid
,a.rsrc_catg_id resourcecodeobjectid
,P.resourcecodedescription resourcecodedescription
,P.resourcecodetypename resourcecodetypename
,P.resourcecodevalue resourcecodevalue
,P.resourceid resourceid
,P.resourcename resourcename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCRCAT A 
   INNER JOIN dbo.RSRCRCATX P
   ON a.rsrc_id = p.rsrc_id and a.rsrc_catg_type_id = p.rsrc_catg_type_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODETYPE ' and type='V')
  DROP VIEW RESOURCECODETYPE 
go

print 'creating view RESOURCECODETYPE'
go
     

--METADATA NAME:RESOURCECODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODETYPE
AS SELECT a.rsrc_catg_type_id objectid
,a.seq_num sequencenumber
,a.rsrc_catg_short_len length
,a.rsrc_catg_type name
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RCATTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECURVE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECURVE ' and type='V')
  DROP VIEW RESOURCECURVE 
go

print 'creating view RESOURCECURVE'
go
     

--METADATA NAME:RESOURCECURVE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECURVE
AS SELECT a.curv_id objectid
,a.curv_name name
,a.default_flag isdefault
,P.value0 value0
,P.value5 value5
,P.value10 value10
,P.value15 value15
,P.value20 value20
,P.value25 value25
,P.value30 value30
,P.value35 value35
,P.value40 value40
,P.value45 value45
,P.value50 value50
,P.value55 value55
,P.value60 value60
,P.value65 value65
,P.value70 value70
,P.value75 value75
,P.value80 value80
,P.value85 value85
,P.value90 value90
,P.value95 value95
,P.value100 value100
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCCURV A 
   INNER JOIN dbo.RSRCCURVX P
   ON a.curv_id = p.curv_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHOUR  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHOUR ' and type='V')
  DROP VIEW RESOURCEHOUR 
go

print 'creating view RESOURCEHOUR'
go
     

--METADATA NAME:RESOURCEHOUR TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHOUR
AS SELECT a.rsrc_hr_id objectid
,a.rsrc_id resourceobjectid
,a.ts_id timesheetperiodobjectid
,a.task_ts_flag activitytimesheetlinkflag
,a.taskrsrc_id resourceassignmentobjectid
,a.nonwork_type_id overheadcodeobjectid
,a.proj_id projectobjectid
,a.pend_hr_cnt unapprovedhours
,a.hr_cnt approvedhours
,a.pend_ot_hr_cnt unapprovedovertimehours
,a.ot_hr_cnt approvedovertimehours
,a.work_date resourcehourdate
,CASE a.status_code WHEN 'TS_Review' THEN 'Submitted' WHEN 'TS_Approv' THEN 'Approved' WHEN 'TS_RMApprov' THEN 'RM Approved' WHEN 'TS_PMApprov' THEN 'PM Approved' WHEN 'TS_Active' THEN 'Not Submitted' WHEN 'TS_Reject' THEN 'Rejected' WHEN 'TS_ReSubmit' THEN 'Resubmitted' WHEN 'TS_ReActive' THEN 'Not Submitted' WHEN 'TS_ReviewRM' THEN 'Submitted' WHEN 'TS_ReSubmitRM' THEN 'Resubmitted' ELSE a.status_code END status
,P.projectid projectid
,P.projectname projectname
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCHOUR A 
   INNER JOIN dbo.RSRCHOURX P
   ON a.rsrc_hr_id = p.rsrc_hr_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERATE ' and type='V')
  DROP VIEW RESOURCERATE 
go

print 'creating view RESOURCERATE'
go
     

--METADATA NAME:RESOURCERATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERATE
AS SELECT a.rsrc_rate_id objectid
,a.rsrc_id resourceobjectid
,a.start_date effectivedate
,a.shift_period_id shiftperiodobjectid
,a.max_qty_per_hr maxunitspertime
,a.cost_per_qty priceperunit
,a.cost_per_qty2 priceperunit2
,a.cost_per_qty3 priceperunit3
,a.cost_per_qty4 priceperunit4
,a.cost_per_qty5 priceperunit5
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCRATE A 
   INNER JOIN dbo.RSRCRATEX P
   ON a.rsrc_rate_id = p.rsrc_rate_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERESOURCETEAM  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERESOURCETEAM ' and type='V')
  DROP VIEW RESOURCERESOURCETEAM 
go

print 'creating view RESOURCERESOURCETEAM'
go
     

--METADATA NAME:RESOURCERESOURCETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERESOURCETEAM
AS SELECT a.rfolio_id resourceteamobjectid
,a.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > b.update_date then a.update_date else b.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRFOLIO A
   INNER JOIN (select rfolio_id,max(update_date) update_date from dbo.rsrfolio group by rfolio_id) B
   on A.rfolio_id = B.rfolio_id 
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEROLE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEROLE ' and type='V')
  DROP VIEW RESOURCEROLE 
go

print 'creating view RESOURCEROLE'
go
     

--METADATA NAME:RESOURCEROLE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEROLE
AS SELECT a.rsrc_id resourceobjectid
,a.role_id roleobjectid
,P.proficiency proficiency
,P.resourceid resourceid
,P.resourcename resourcename
,P.roleid roleid
,P.rolename rolename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCROLE A 
   INNER JOIN dbo.RSRCROLEX P
   ON a.rsrc_id = p.rsrc_id and a.role_id = p.role_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCES  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCES ' and type='V')
  DROP VIEW RESOURCES 
go

print 'creating view RESOURCES'
go
     

--METADATA NAME:RESOURCES TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCES
AS SELECT a.rsrc_id objectid
,a.clndr_id calendarobjectid
,a.rsrc_seq_num sequencenumber
,a.timesheet_flag usetimesheets
,a.active_flag isactive
,CASE a.rsrc_type WHEN 'RT_Labor' THEN 'Labor' WHEN 'RT_Equip' THEN 'Nonlabor' WHEN 'RT_Mat' THEN 'Material' ELSE a.rsrc_type END resourcetype
,a.auto_compute_act_flag autocomputeactuals
,a.ot_flag isovertimeallowed
,a.def_cost_qty_link_flag calculatecostfromunits
,a.rsrc_short_name id
,a.rsrc_name name
,a.parent_rsrc_id parentobjectid
,a.ts_approve_user_id timesheetapprovalmgrobjectid
,a.user_id userobjectid
,a.role_id primaryroleobjectid
,a.curr_id currencyobjectid
,a.shift_id shiftobjectid
,a.ot_factor overtimefactor
,a.def_qty_per_hr defaultunitspertime
,a.office_phone officephone
,a.other_phone otherphone
,a.employee_code employeeid
,a.rsrc_title_name title
,a.email_addr emailaddress
,a.unit_id unitofmeasureobjectid
,a.rsrc_notes resourcenotes
,P.calendarname calendarname
,P.currencyid currencyid
,P.currencyname currencyname
,P.primaryroleid primaryroleid
,P.primaryrolename primaryrolename
,P.timesheetapprovalmanager timesheetapprovalmanager
,P.username username
,a.location_id locationobjectid
,P.locationname locationname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
FROM dbo.RSRC A 
   INNER JOIN dbo.RSRCX P
   ON a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCELOCATION  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELOCATION ' and type='V')
  DROP VIEW RESOURCELOCATION 
go

print 'creating view RESOURCELOCATION'
go
     

--METADATA NAME:RESOURCELOCATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCELOCATION
AS SELECT a.rsrc_loc_id objectid
,a.rsrc_id resourceobjectid
,a.longitude longitude
,a.latitude latitude
,a.geo_location geolocation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RSRCLOC A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RESOURCETEAM  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCETEAM ' and type='V')
  DROP VIEW RESOURCETEAM 
go

print 'creating view RESOURCETEAM'
go
     

--METADATA NAME:RESOURCETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCETEAM
AS SELECT a.rfolio_id objectid
,a.user_id userobjectid
,a.rfolio_name name
,a.rfolio_descr description
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RFOLIO A 
   INNER JOIN dbo.RFOLIOX P
   ON a.rfolio_id = p.rfolio_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:RISKTYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTYPE ' and type='V')
  DROP VIEW RISKTYPE 
go

print 'creating view RISKTYPE'
go
     

--METADATA NAME:RISKTYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RISKTYPE
AS SELECT a.risk_type_id objectid
,a.seq_num sequencenumber
,a.risk_type name
,a.parent_risk_type_id parentobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RISKTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLE ' and type='V')
  DROP VIEW ROLE 
go

print 'creating view ROLE'
go
     

--METADATA NAME:ROLE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLE
AS SELECT a.role_id objectid
,a.role_short_name id
,a.role_name name
,a.seq_num sequencenumber
,a.parent_role_id parentobjectid
,a.def_cost_qty_link_flag calculatecostfromunits
,a.role_descr responsibilities
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLES A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLECODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODE ' and type='V')
  DROP VIEW ROLECODE 
go

print 'creating view ROLECODE'
go
     

--METADATA NAME:ROLECODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODE
AS SELECT a.role_catg_id objectid
,a.role_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.role_catg_short_name codevalue
,a.role_catg_name description
,a.parent_role_catg_id parentobjectid
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLECATVAL A 
   INNER JOIN dbo.ROLECATVALX P
   ON a.role_catg_id = p.role_catg_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLECODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODETYPE ' and type='V')
  DROP VIEW ROLECODETYPE 
go

print 'creating view ROLECODETYPE'
go
     

--METADATA NAME:ROLECODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODETYPE
AS SELECT a.role_catg_type_id objectid
,a.seq_num sequencenumber
,a.role_catg_short_len length
,a.role_catg_type name
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLECATTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLECODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODEASSIGNMENT ' and type='V')
  DROP VIEW ROLECODEASSIGNMENT 
go

print 'creating view ROLECODEASSIGNMENT'
go
     

--METADATA NAME:ROLECODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODEASSIGNMENT
AS SELECT a.role_id roleobjectid
,a.role_catg_type_id rolecodetypeobjectid
,a.role_catg_id rolecodeobjectid
,P.rolecodedescription rolecodedescription
,P.rolecodetypename rolecodetypename
,P.rolecodevalue rolecodevalue
,P.roleid roleid
,P.rolename rolename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLERCAT A 
   INNER JOIN dbo.ROLERCATX P
   ON a.role_id = p.role_id and a.role_catg_type_id = p.role_catg_type_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLERATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLERATE ' and type='V')
  DROP VIEW ROLERATE 
go

print 'creating view ROLERATE'
go
     

--METADATA NAME:ROLERATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLERATE
AS SELECT a.role_rate_id objectid
,a.role_id roleobjectid
,a.cost_per_qty priceperunit
,a.cost_per_qty2 priceperunit2
,a.cost_per_qty3 priceperunit3
,a.cost_per_qty4 priceperunit4
,a.cost_per_qty5 priceperunit5
,P.roleid roleid
,P.rolename rolename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLERATE A 
   INNER JOIN dbo.ROLERATEX P
   ON a.role_rate_id = p.role_rate_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLEROLETEAM  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLEROLETEAM ' and type='V')
  DROP VIEW ROLEROLETEAM 
go

print 'creating view ROLEROLETEAM'
go
     

--METADATA NAME:ROLEROLETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLEROLETEAM
AS SELECT a.rlfolio_id roleteamobjectid
,a.role_id roleobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ROLFOLIO A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:ROLETEAM  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLETEAM ' and type='V')
  DROP VIEW ROLETEAM 
go

print 'creating view ROLETEAM'
go
     

--METADATA NAME:ROLETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ROLETEAM
AS SELECT a.rlfolio_id objectid
,a.user_id userobjectid
,a.rlfolio_name name
,a.rlfolio_descr description
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.RLFOLIO A 
   INNER JOIN dbo.RLFOLIOX P
   ON a.rlfolio_id = p.rlfolio_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:SHIFT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFT ' and type='V')
  DROP VIEW SHIFT 
go

print 'creating view SHIFT'
go
     

--METADATA NAME:SHIFT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW SHIFT
AS SELECT a.shift_id objectid
,a.shift_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.SHIFT A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:SHIFTPERIOD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFTPERIOD ' and type='V')
  DROP VIEW SHIFTPERIOD 
go

print 'creating view SHIFTPERIOD'
go
     

--METADATA NAME:SHIFTPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW SHIFTPERIOD
AS SELECT a.shift_period_id objectid
,a.shift_id shiftobjectid
,a.shift_start_hr_num starthour
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.SHIFTPER A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOT ' and type='V')
  DROP VIEW SNAPSHOT 
go

print 'creating view SNAPSHOT'
go
     

--METADATA NAME:SNAPSHOT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOT
AS SELECT a.snapshot_id objectid
,a.snapshot_name name
,a.snapshot_date snapshotdate
,a.snap_group_id snapshotgroupobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.SNAPSHOT A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTGROUP  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTGROUP ' and type='V')
  DROP VIEW SNAPSHOTGROUP 
go

print 'creating view SNAPSHOTGROUP'
go
     

--METADATA NAME:SNAPSHOTGROUP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOTGROUP
AS SELECT a.snap_group_id objectid
,a.snap_group_name name
,a.snap_group_desc description
,a.snap_interval interval
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.SNAPGROUP A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTPROJECT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTPROJECT ' and type='V')
  DROP VIEW SNAPSHOTPROJECT 
go

print 'creating view SNAPSHOTPROJECT'
go
     

--METADATA NAME:SNAPSHOTPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOTPROJECT
AS SELECT a.snap_group_id snapshotgroupobjectid
,a.proj_id projectobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.SNAPPROJ A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEET  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEET ' and type='V')
  DROP VIEW TIMESHEET 
go

print 'creating view TIMESHEET'
go
     

--METADATA NAME:TIMESHEET TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW TIMESHEET
AS SELECT a.ts_id timesheetperiodobjectid
,a.rsrc_id resourceobjectid
,a.user_id userobjectid
,a.daily_flag isdaily
,CASE a.status_code WHEN 'TS_Review' THEN 'Submitted' WHEN 'TS_Approv' THEN 'Approved' WHEN 'TS_RMApprov' THEN 'RM Approved' WHEN 'TS_PMApprov' THEN 'PM Approved' WHEN 'TS_Active' THEN 'Not Submitted' WHEN 'TS_Reject' THEN 'Rejected' WHEN 'TS_NotStarted' THEN 'Not Started' WHEN 'TS_ReSubmit' THEN 'Resubmitted' WHEN 'TS_ReActive' THEN 'Not Submitted' WHEN 'TS_ReviewRM' THEN 'Submitted' WHEN 'TS_ReSubmitRM' THEN 'Resubmitted' ELSE a.status_code END status
,a.last_recv_date lastreceiveddate
,a.status_date statusdate
,a.ts_notes notes
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TIMESHT A 
   INNER JOIN dbo.TIMESHTX P
   ON a.ts_id = p.ts_id and a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEETPERIOD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEETPERIOD ' and type='V')
  DROP VIEW TIMESHEETPERIOD 
go

print 'creating view TIMESHEETPERIOD'
go
     

--METADATA NAME:TIMESHEETPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW TIMESHEETPERIOD
AS SELECT a.ts_id objectid
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TSDATES A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:UDFCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFCODE ' and type='V')
  DROP VIEW UDFCODE 
go

print 'creating view UDFCODE'
go
     

--METADATA NAME:UDFCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW UDFCODE
AS SELECT a.udf_code_id objectid
,a.udf_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.short_name codevalue
,a.udf_code_name description
,P.codetypetitle codetypetitle
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.UDFCODE A 
   INNER JOIN dbo.UDFCODEX P
   ON a.udf_code_id = p.udf_code_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:UDFTYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFTYPE ' and type='V')
  DROP VIEW UDFTYPE 
go

print 'creating view UDFTYPE'
go
     

--METADATA NAME:UDFTYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW UDFTYPE
AS SELECT a.udf_type_id objectid
,CASE a.table_name WHEN 'TASK' THEN 'Activity' WHEN 'PROJCOST' THEN 'Activity Expense' WHEN 'TASKPROC' THEN 'Activity Step' WHEN 'PROJECT' THEN 'Project' WHEN 'PROJISSU' THEN 'Project Issue' WHEN 'RISK' THEN 'Project Risk' WHEN 'RSRC' THEN 'Resource' WHEN 'TASKRSRC' THEN 'Assignment' WHEN 'PROJWBS' THEN 'WBS' WHEN 'DOCUMENT' THEN 'Work Products and Documents' WHEN 'PROCITEM' THEN 'Activity Step Template Item' WHEN 'LEANTASK' THEN '??enm.UDFBusinessObjectType.LEANTASK??' WHEN 'ROLES' THEN '??enm.UDFBusinessObjectType.ROLES??' ELSE a.table_name END subjectarea
,a.udf_type_label title
,CASE a.logical_data_type WHEN 'FT_TEXT' THEN 'Text' WHEN 'FT_START_DATE' THEN 'Start Date' WHEN 'FT_END_DATE' THEN 'Finish Date' WHEN 'FT_MONEY' THEN 'Cost' WHEN 'FT_FLOAT_2_DECIMALS' THEN 'Number' WHEN 'FT_INT' THEN 'Integer' WHEN 'FT_STATICTYPE' THEN 'Indicator' WHEN 'FT_CODE' THEN 'Code' ELSE a.logical_data_type END datatype
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.UDFTYPE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:UDFVALUE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFVALUE ' and type='V')
  DROP VIEW UDFVALUE 
go

print 'creating view UDFVALUE'
go
     

--METADATA NAME:UDFVALUE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW UDFVALUE
AS SELECT a.udf_type_id udftypeobjectid
,a.fk_id foreignobjectid
,a.proj_id projectobjectid
,a.udf_date udfdate
,CASE a.udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.udf_text END udftext
,a.udf_number udfnumber
,a.udf_code_id udfcodeobjectid
,P.subjectarea subjectarea
,P.datatype datatype
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.UDFVALUE A 
   INNER JOIN dbo.UDFVALUEX P
   ON a.udf_type_id = p.udf_type_id and a.fk_id = p.fk_id 
   LEFT OUTER JOIN dbo.project PROJ
   ON PROJ.proj_id = a.proj_id 
WHERE A.DELETE_SESSION_ID is null 
AND (A.proj_id IS NULL
          OR (PROJ.orig_proj_id IS NULL
               AND PROJ.proj_id IS NOT NULL))
     
go
     
--METADATA  TYPE:SSCR NAME:UNITOFMEASURE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UNITOFMEASURE ' and type='V')
  DROP VIEW UNITOFMEASURE 
go

print 'creating view UNITOFMEASURE'
go
     

--METADATA NAME:UNITOFMEASURE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW UNITOFMEASURE
AS SELECT a.unit_id objectid
,a.seq_num sequencenumber
,a.unit_name name
,a.unit_abbrev abbreviation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.UMEASURE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:USERMODULEACCESS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERMODULEACCESS ' and type='V')
  DROP VIEW USERMODULEACCESS 
go

print 'creating view USERMODULEACCESS'
go
     

--METADATA NAME:USERMODULEACCESS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW USERMODULEACCESS
AS SELECT a.user_eng_id objectid
,a.user_id userobjectid
,CASE a.db_engine_type WHEN 'PM' THEN 'P6 Professional' WHEN 'TS' THEN 'Contributor' WHEN 'WU' THEN 'Portfolios' WHEN 'WEB_PM' THEN 'Projects' WHEN 'WEB_RM' THEN 'Resources' WHEN 'INT_API' THEN 'Integration API' WHEN 'TS_ONLY' THEN 'Timesheet' WHEN 'WS' THEN 'Web Services' WHEN 'STAR' THEN 'P6 Analytics' WHEN 'RDB' THEN 'Enterprise Reports' WHEN 'TM' THEN 'Team Member' WHEN 'VIS' THEN 'Visualizer' ELSE a.db_engine_type END moduletypecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.USERENG A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:USEROBS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USEROBS ' and type='V')
  DROP VIEW USEROBS 
go

print 'creating view USEROBS'
go
     

--METADATA NAME:USEROBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW USEROBS
AS SELECT a.user_id userobjectid
,a.obs_id obsobjectid
,a.prof_id projectprofileobjectid
,P.obsname obsname
,P.profilename profilename
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.USEROBS A 
   INNER JOIN dbo.USEROBSX P
   ON a.user_id = p.user_id and a.obs_id = p.obs_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:USERPROFILEPRIVILEGE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERPROFILEPRIVILEGE ' and type='V')
  DROP VIEW USERPROFILEPRIVILEGE 
go

print 'creating view USERPROFILEPRIVILEGE'
go
     

--METADATA NAME:USERPROFILEPRIVILEGE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW USERPROFILEPRIVILEGE
AS SELECT a.prof_id profileid
,a.priv_num privlegenumber
,P.privlegename privlegename
,a.allow_flag allowflag
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PROFPRIV A 
   INNER JOIN dbo.PROFPRIVX P
   ON a.prof_id = p.prof_id and a.priv_num = p.priv_num
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:USERS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERS ' and type='V')
  DROP VIEW USERS 
go

print 'creating view USERS'
go
     

--METADATA NAME:USERS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW USERS
AS SELECT a.user_id objectid
,CASE a.email_type WHEN 'ET_Internet' THEN 'Internet' WHEN 'ET_MAPI' THEN 'MAPI' ELSE a.email_type END emailprotocol
,a.user_name rdbmsusername
,a.user_name name
,a.prof_id globalprofileobjectid
,a.curr_id currencyobjectid
,a.all_rsrc_access_flag allresourceaccessflag
,P.issuperuser issuperuser
,a.email_srv_user_name mailserverloginname
,a.office_phone officephone
,a.actual_name personalname
,a.email_send_server outgoingmailserver
,a.email_addr emailaddress
,a.notify_prefs notificationsettings
,P.respectactivitydurationtype respectactivitydurationtype
,P.assignmentstaffingpreference assignmentstaffingpreference
,P.currencyid currencyid
,P.currencyname currencyname
,P.financialperiodendobjectid financialperiodendobjectid
,P.financialperiodstartobjectid financialperiodstartobjectid
,P.newprojectdurationtype newprojectdurationtype
,P.ratesourcepreference ratesourcepreference
,a.report_user_flag reportingflag
,P.lastprojectsecuritydate lastprojectsecuritydate
,P.lastresourcesecuritydate lastresourcesecuritydate
,P.lastglobalsecuritydate lastglobalsecuritydate
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.USERS A 
   INNER JOIN dbo.USERSX P
   ON a.user_id = p.user_id
WHERE A.DELETE_SESSION_ID is null 
AND A.SYSTEMUSER='N'
     
go
     
--METADATA  TYPE:SSCR NAME:WBS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBS ' and type='V')
  DROP VIEW WBS 
go

print 'creating view WBS'
go
     

--METADATA NAME:WBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW WBS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.sum_data_flag containssummarydata
,CASE a.status_code WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' ELSE a.status_code END status
,a.wbs_short_name code
,a.wbs_name name
,a.phase_id wbscategoryobjectid
,a.parent_wbs_id parentobjectid
,a.ev_user_pct earnedvalueuserpercent
,a.ev_etc_user_value earnedvalueetcuservalue
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,CASE a.ev_compute_type WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' ELSE a.ev_compute_type END earnedvaluecomputetype
,CASE a.ev_etc_compute_type WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' ELSE a.ev_etc_compute_type END earnedvalueetccomputetype
,a.proj_node_flag projectnodeflag
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.fullname fullname
,P.fullsequence fullsequence
,P.obsname obsname
,P.projectid projectid
,P.proposedbudget proposedbudget
,CASE a.review_type WHEN 'Review_Any' THEN 'AnyoneCanReview' WHEN 'Review_All' THEN 'EveryoneMustReview' ELSE a.review_type END reviewtype
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
FROM dbo.PROJWBS A 
   INNER JOIN dbo.PROJWBSX P
   ON a.wbs_id = p.wbs_id
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null
AND projects_tab.PROJECT_FLAG = 'Y'
AND projects_tab.ORIG_PROJ_ID IS NULL
go
     
--METADATA  TYPE:SSCR NAME:WBSCATEGORY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSCATEGORY ' and type='V')
  DROP VIEW WBSCATEGORY 
go

print 'creating view WBSCATEGORY'
go
     

--METADATA NAME:WBSCATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW WBSCATEGORY
AS SELECT a.phase_id objectid
,a.seq_num sequencenumber
,a.phase_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.PHASE A
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:WBSMILESTONE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSMILESTONE ' and type='V')
  DROP VIEW WBSMILESTONE 
go

print 'creating view WBSMILESTONE'
go
     

--METADATA NAME:WBSMILESTONE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW WBSMILESTONE
AS SELECT a.wbs_step_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.seq_num sequencenumber
,a.complete_flag iscompleted
,a.step_name name
,a.step_wt weight
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.WBSSTEP A 
   INNER JOIN dbo.WBSSTEPX P
   ON a.wbs_step_id = p.wbs_step_id
WHERE A.DELETE_SESSION_ID is null
go
     
--METADATA  TYPE:SSCR NAME:PROJECTETLLIST  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTETLLIST ' and type='V')
  DROP VIEW PROJECTETLLIST 
go

print 'creating view PROJECTETLLIST'
go
     

--METADATA NAME:PROJECTETLLIST TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTETLLIST
AS SELECT a.etl_id objectid
,b.proj_id projectobjectid
,a.update_date lastupdatedate
FROM dbo.PROJECT_ETL_LIST A
   INNER JOIN dbo.PROJECTX B
   ON a.proj_id = b.proj_id
go
     
--METADATA  TYPE:SSCR NAME:BLACTIVITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITY ' and type='V')
  DROP VIEW BLACTIVITY 
go

print 'creating view BLACTIVITY'
go
     

--METADATA NAME:BLACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITY
AS SELECT a.task_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.clndr_id calendarobjectid
,a.rev_fdbk_flag isnewfeedback
,a.auto_compute_act_flag autocomputeactuals
,CASE a.complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.complete_pct_type END percentcompletetype
,CASE a.task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.task_type END type
,CASE a.duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.duration_type END durationtype
,CASE a.review_type WHEN 'RV_OK' THEN 'OK' WHEN 'RV_Review' THEN 'For Review' WHEN 'RV_Reject' THEN 'Reject' ELSE a.review_type END reviewstatus
,CASE a.status_code WHEN 'TK_NotStart' THEN 'Not Started' WHEN 'TK_Active' THEN 'In Progress' WHEN 'TK_Complete' THEN 'Completed' ELSE a.status_code END status
,a.task_code id
,a.task_name name
,a.rsrc_id primaryresourceobjectid
,a.total_float_hr_cnt totalfloat
,a.free_float_hr_cnt freefloat
,a.remain_drtn_hr_cnt remainingduration
,a.act_work_qty actuallaborunits
,a.remain_work_qty remaininglaborunits
,a.target_work_qty plannedlaborunits
,a.target_drtn_hr_cnt plannedduration
,a.target_equip_qty plannednonlaborunits
,a.act_equip_qty actualnonlaborunits
,a.remain_equip_qty remainingnonlaborunits
,a.cstr_date primaryconstraintdate
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.late_start_date latestartdate
,a.late_end_date latefinishdate
,a.expect_end_date expectedfinishdate
,a.early_start_date earlystartdate
,a.early_end_date earlyfinishdate
,a.restart_date remainingearlystartdate
,a.reend_date remainingearlyfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.review_end_date reviewfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.cstr_type WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type END primaryconstrainttype
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END levelingpriority
,a.cstr_date2 secondaryconstraintdate
,CASE a.cstr_type2 WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type2 END secondaryconstrainttype
,a.float_path floatpath
,a.float_path_order floatpathorder
,a.act_this_per_work_qty actualthisperiodlaborunits
,a.act_this_per_equip_qty actualthisperiodnonlaborunits
,a.driving_path_flag islongestpath
,a.suspend_date suspenddate
,a.resume_date resumedate
,a.external_early_start_date externalearlystartdate
,a.external_late_end_date externallatefinishdate
,P.accountingvariance accountingvariance
,P.accountingvariancelaborunits accountingvariancelaborunits
,P.actualduration actualduration
,P.actualexpensecost actualexpensecost
,P.actuallaborcost actuallaborcost
,P.actualmaterialcost actualmaterialcost
,P.actualnonlaborcost actualnonlaborcost
,P.actualthisperiodlaborcost actualthisperiodlaborcost
,P.actualthisperiodmaterialcost actualthisperiodmaterialcost
,P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost
,P.actualtotalcost actualtotalcost
,P.actualtotalunits actualtotalunits
,P.atcompletionduration atcompletionduration
,P.atcompletionexpensecost atcompletionexpensecost
,P.atcompletionlaborcost atcompletionlaborcost
,P.atcompletionlaborunits atcompletionlaborunits
,P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance
,P.atcompletionmaterialcost atcompletionmaterialcost
,P.atcompletionnonlaborcost atcompletionnonlaborcost
,P.atcompletionnonlaborunits atcompletionnonlaborunits
,P.atcompletiontotalcost atcompletiontotalcost
,P.atcompletiontotalunits atcompletiontotalunits
,P.atcompletionvariance atcompletionvariance
,P.baselineduration baselineduration
,P.baselinefinishdate baselinefinishdate
,P.baselineplannedduration baselineplannedduration
,P.baselineplannedexpensecost baselineplannedexpensecost
,P.baselineplannedlaborcost baselineplannedlaborcost
,P.baselineplannedlaborunits baselineplannedlaborunits
,P.baselineplannedmaterialcost baselineplannedmaterialcost
,P.baselineplannednonlaborcost baselineplannednonlaborcost
,P.baselineplannednonlaborunits baselineplannednonlaborunits
,P.baselineplannedtotalcost baselineplannedtotalcost
,P.baselinestartdate baselinestartdate
,P.baselinelatestartdate baselinelatestartdate
,P.baseline1latestartdate baseline1latestartdate
,P.baselinelatefinishdate baselinelatefinishdate
,P.baseline1latefinishdate baseline1latefinishdate
,P.budgetatcompletion budgetatcompletion
,P.calendarname calendarname
,P.costpercentcomplete costpercentcomplete
,P.costpercentofplanned costpercentofplanned
,P.costperformanceindex costperformanceindex
,P.costperformanceindexlaborunits costperformanceindexlaborunits
,P.costvariance costvariance
,P.costvarianceindex costvarianceindex
,P.costvarianceindexlaborunits costvarianceindexlaborunits
,P.costvariancelaborunits costvariancelaborunits
,(select datadate from dbo.projectx px where px.proj_id=a.proj_id) as  datadate
,P.duration1variance duration1variance
,P.durationpercentcomplete durationpercentcomplete
,P.durationpercentofplanned durationpercentofplanned
,P.durationvariance durationvariance
,P.earnedvaluecost earnedvaluecost
,P.earnedvaluelaborunits earnedvaluelaborunits
,P.estimateatcompletioncost estimateatcompletioncost
,P.estimateatcompletionlaborunits estimateatcompletionlaborunits
,P.estimatetocomplete estimatetocomplete
,P.estimatetocompletelaborunits estimatetocompletelaborunits
,P.expensecost1variance expensecost1variance
,P.expensecostpercentcomplete expensecostpercentcomplete
,P.expensecostvariance expensecostvariance
,P.finishdate finishdate
,P.finishdate1variance finishdate1variance
,P.finishdatevariance finishdatevariance
,P.iscritical iscritical
,P.laborcost1variance laborcost1variance
,P.laborcostpercentcomplete laborcostpercentcomplete
,P.laborcostvariance laborcostvariance
,P.laborunits1variance laborunits1variance
,P.laborunitspercentcomplete laborunitspercentcomplete
,P.laborunitsvariance laborunitsvariance
,P.materialcost1variance materialcost1variance
,P.materialcostpercentcomplete materialcostpercentcomplete
,P.materialcostvariance materialcostvariance
,P.nonlaborcost1variance nonlaborcost1variance
,P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete
,P.nonlaborcostvariance nonlaborcostvariance
,P.nonlaborunits1variance nonlaborunits1variance
,P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete
,P.nonlaborunitsvariance nonlaborunitsvariance
,P.percentcomplete percentcomplete
,P.performancepercentcomplete performancepercentcomplete
,P.physicalpercentcomplete physicalpercentcomplete
,P.plannedexpensecost plannedexpensecost
,P.plannedlaborcost plannedlaborcost
,P.plannedmaterialcost plannedmaterialcost
,P.plannednonlaborcost plannednonlaborcost
,P.plannedtotalcost plannedtotalcost
,P.plannedtotalunits plannedtotalunits
,P.plannedvaluecost plannedvaluecost
,P.plannedvaluelaborunits plannedvaluelaborunits
,P.primaryresourceid primaryresourceid
,P.primaryresourcename primaryresourcename
,P.remainingexpensecost remainingexpensecost
,P.remainingfloat remainingfloat
,P.remaininglaborcost remaininglaborcost
,P.remainingmaterialcost remainingmaterialcost
,P.remainingnonlaborcost remainingnonlaborcost
,P.remainingtotalcost remainingtotalcost
,P.remainingtotalunits remainingtotalunits
,P.schedulepercentcomplete schedulepercentcomplete
,P.scheduleperfindexlaborunits scheduleperfindexlaborunits
,P.scheduleperformanceindex scheduleperformanceindex
,P.schedulevariance schedulevariance
,P.schedulevarianceindex schedulevarianceindex
,P.schedulevariancelaborunits schedulevariancelaborunits
,P.schedulevarindexlaborunits schedulevarindexlaborunits
,P.startdate startdate
,P.startdate1variance startdate1variance
,P.startdatevariance startdatevariance
,P.tocompleteperformanceindex tocompleteperformanceindex
,P.totalcost1variance totalcost1variance
,P.totalcostvariance totalcostvariance
,P.unitspercentcomplete unitspercentcomplete
,P.wbscode wbscode
,P.wbsname wbsname
,a.location_id locationobjectid
,P.locationname locationname
,a.control_updates_flag reviewrequired
,a.starred_flag isstarred
,a.cbs_code cbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
,P.activityownerobjectid activityownerobjectid
,P.activityowner activityowner 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
FROM dbo.TASK A 
   INNER JOIN dbo.TASKX P
   ON a.task_id = p.task_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODE ' and type='V')
  DROP VIEW BLACTIVITYCODE 
go

print 'creating view BLACTIVITYCODE'
go
     

--METADATA NAME:BLACTIVITYCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODE
AS SELECT a.actv_code_id objectid
,a.actv_code_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.short_name codevalue
,a.parent_actv_code_id parentobjectid
,a.actv_code_name description
,P.codetypename codetypename
,P.issecurecode issecurecode
,P.projectobjectid projectobjectid
,P.codetypescope codetypescope
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ACTVCODE A 
   INNER JOIN dbo.ACTVCODEX P
   ON a.actv_code_id = p.actv_code_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON p.projectobjectid = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODEASSIGNMENT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODEASSIGNMENT ' and type='V')
  DROP VIEW BLACTIVITYCODEASSIGNMENT 
go

print 'creating view BLACTIVITYCODEASSIGNMENT'
go
     

--METADATA NAME:BLACTIVITYCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODEASSIGNMENT
AS SELECT a.task_id activityobjectid
,a.actv_code_type_id activitycodetypeobjectid
,a.actv_code_id activitycodeobjectid
,a.proj_id projectobjectid
,P.activitycodedescription activitycodedescription
,P.activitycodetypename activitycodetypename
,P.activitycodetypescope activitycodetypescope
,P.activitycodevalue activitycodevalue
,P.activityid activityid
,P.activityname activityname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.TASKACTV A 
   INNER JOIN dbo.TASKACTVX P
   ON a.task_id = p.task_id and a.actv_code_type_id = p.actv_code_type_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODETYPE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODETYPE ' and type='V')
  DROP VIEW BLACTIVITYCODETYPE 
go

print 'creating view BLACTIVITYCODETYPE'
go
     

--METADATA NAME:BLACTIVITYCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODETYPE
AS SELECT a.actv_code_type_id objectid
,a.actv_short_len length
,a.seq_num sequencenumber
,a.actv_code_type name
,CASE a.actv_code_type_scope WHEN 'AS_Global' THEN 'Global' WHEN 'AS_EPS' THEN 'EPS' WHEN 'AS_Project' THEN 'Project' ELSE a.actv_code_type_scope END scope
,CASE WHEN a.actv_code_type_scope = 'AS_Project' THEN a.proj_id ELSE null END projectobjectid
,CASE WHEN a.actv_code_type_scope = 'AS_EPS' THEN (select min(p.wbs_id) from dbo.projwbs p where p.proj_id=a.proj_id and p.proj_node_flag='Y')  ELSE null END epsobjectid
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.ACTVTYPE A  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLPROJECT  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLPROJECT ' and type='V')
  DROP VIEW BLPROJECT 
go

print 'creating view BLPROJECT'
go
     

--METADATA NAME:BLPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLPROJECT
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,P.annualdiscountrate annualdiscountrate
,P.anticipatedfinishdate anticipatedfinishdate
,P.anticipatedstartdate anticipatedstartdate
,P.containssummarydata containssummarydata
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.datadate datadate
,P.discountapplicationperiod discountapplicationperiod
,P.distributedcurrentbudget distributedcurrentbudget
,P.earnedvaluecomputetype earnedvaluecomputetype
,P.earnedvalueetccomputetype earnedvalueetccomputetype
,P.earnedvalueetcuservalue earnedvalueetcuservalue
,P.earnedvalueuserpercent earnedvalueuserpercent
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.independentetclaborunits independentetclaborunits
,P.independentetctotalcost independentetctotalcost
,P.name name
,P.obsname obsname
,P.obsobjectid obsobjectid
,P.originalbudget originalbudget
,P.overallprojectscore overallprojectscore
,P.parentepsobjectid parentepsobjectid
,P.proposedbudget proposedbudget
,P.risklevel risklevel
,P.riskscore riskscore
,P.riskexposure riskexposure
,P.startdate startdate
,P.status status
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.netpresentvalue netpresentvalue
,P.returnoninvestment returnoninvestment
,P.paybackperiod paybackperiod
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,P.locationname locationname
,a.control_updates_flag allowstatusreview
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,P.update_dim_date lastupdatedatex
FROM dbo.PROJECT A 
   INNER JOIN dbo.PROJECTX P
   ON a.proj_id = p.proj_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND a.ORIG_PROJ_ID IS NOT NULL
AND a.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLUDFVALUE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLUDFVALUE ' and type='V')
  DROP VIEW BLUDFVALUE 
go

print 'creating view BLUDFVALUE'
go
     

--METADATA NAME:BLUDFVALUE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLUDFVALUE
AS SELECT a.udf_type_id udftypeobjectid
,a.fk_id foreignobjectid
,a.proj_id projectobjectid
,a.udf_date udfdate
,CASE a.udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.udf_text END udftext
,a.udf_number udfnumber
,a.udf_code_id udfcodeobjectid
,P.subjectarea subjectarea
,P.datatype datatype
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
FROM dbo.UDFVALUE A 
   INNER JOIN dbo.UDFVALUEX P
   ON a.udf_type_id = p.udf_type_id and a.fk_id = p.fk_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:BLWBS  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLWBS ' and type='V')
  DROP VIEW BLWBS 
go

print 'creating view BLWBS'
go
     

--METADATA NAME:BLWBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BLWBS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.sum_data_flag containssummarydata
,CASE a.status_code WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' ELSE a.status_code END status
,a.wbs_short_name code
,a.wbs_name name
,a.phase_id wbscategoryobjectid
,a.parent_wbs_id parentobjectid
,a.ev_user_pct earnedvalueuserpercent
,a.ev_etc_user_value earnedvalueetcuservalue
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,CASE a.ev_compute_type WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' ELSE a.ev_compute_type END earnedvaluecomputetype
,CASE a.ev_etc_compute_type WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' ELSE a.ev_etc_compute_type END earnedvalueetccomputetype
,a.proj_node_flag projectnodeflag
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.fullname fullname
,P.fullsequence fullsequence
,P.obsname obsname
,P.projectid projectid
,P.proposedbudget proposedbudget
,CASE a.review_type WHEN 'Review_Any' THEN 'AnyoneCanReview' WHEN 'Review_All' THEN 'EveryoneMustReview' ELSE a.review_type END reviewtype
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
FROM dbo.PROJWBS A 
   INNER JOIN dbo.PROJWBSX P
   ON a.wbs_id = p.wbs_id  
   INNER JOIN dbo.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id   
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTSPREAD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTSPREAD ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTSPREAD 
go

print 'creating view RESOURCEASSIGNMENTSPREAD'
go
     
--METADATA NAME:RESOURCEASSIGNMENTSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENTSPREAD
AS
SELECT a.resourceassignmentobjectid  resourceassignmentobjectid
,a.startdate  startdate
,a.enddate  enddate
,a.resourceobjectid  resourceobjectid
,a.roleobjectid  roleobjectid
,a.activityobjectid  activityobjectid
,a.wbsobjectid  wbsobjectid
,a.projectobjectid  projectobjectid
,isnull(a.costaccountobjectid,0)  costaccountobjectid
,isnull(a.actualregularunits,0)  actualregularunits
,isnull(a.actualovertimeunits,0)  actualovertimeunits
,isnull(a.actualunits,0)  actualunits
,isnull(a.atcompletionunits,0)  atcompletionunits
,isnull(a.plannedunits,0)  plannedunits
,isnull(a.remainingunits,0)  remainingunits
,isnull(a.remaininglateunits,0)  remaininglateunits
,isnull(a.staffedremainingunits,0)  staffedremainingunits
,isnull(a.staffedremaininglateunits,0)  staffedremaininglateunits
,isnull(a.unstaffedremainingunits,0)  unstaffedremainingunits
,isnull(a.unstaffedremaininglateunits,0)  unstaffedremaininglateunits
,isnull(a.actualregularcost,0)  actualregularcost
,isnull(a.actualovertimecost,0)  actualovertimecost
,isnull(a.actualcost,0)  actualcost
,isnull(a.atcompletioncost,0)  atcompletioncost
,isnull(a.plannedcost,0)  plannedcost
,isnull(a.remainingcost,0)  remainingcost
,isnull(a.remaininglatecost,0)  remaininglatecost
,isnull(a.staffedremainingcost,0)  staffedremainingcost
,isnull(a.staffedremaininglatecost,0)  staffedremaininglatecost
,isnull(a.unstaffedremainingcost,0)  unstaffedremainingcost
,isnull(a.unstaffedremaininglatecost,0)  unstaffedremaininglatecost
,a.update_date  lastupdatedate
,T1.cbs_id cbsobjectid  
FROM dbo.RESOURCEASSIGNMENTSPREAD a
    INNER JOIN dbo.TASKRSRC T1 
ON T1.taskrsrc_id = ResourceAssignmentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSPREAD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSPREAD ' and type='V')
  DROP VIEW ACTIVITYSPREAD 
go

print 'creating view ACTIVITYSPREAD'
go
     
--METADATA NAME:ACTIVITYSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSPREAD
AS
SELECT a.activityobjectid  activityobjectid
,a.startdate  startdate
,a.enddate  enddate
,a.activitycode  activitycode
,a.activityname  activityname
,a.wbsobjectid  wbsobjectid
,a.projectobjectid  projectobjectid
,a.actuallaborunits  actuallaborunits
,a.actualnonlaborunits  actualnonlaborunits
,a.atcompletionlaborunits  atcompletionlaborunits
,a.atcompletionnonlaborunits  atcompletionnonlaborunits
,a.baselineactuallaborunits  baselineactuallaborunits
,a.baselineactualnonlaborunits  baselineactualnonlaborunits
,a.baselineplannedlaborunits  baselineplannedlaborunits
,a.baselineplannednonlaborunits  baselineplannednonlaborunits
,a.baseline1actuallaborunits  baseline1actuallaborunits
,a.baseline1actualnonlaborunits  baseline1actualnonlaborunits
,a.baseline1plannedlaborunits  baseline1plannedlaborunits
,a.baseline1plannednonlaborunits  baseline1plannednonlaborunits
,a.earnedvaluelaborunits  earnedvaluelaborunits
,a.estimateatcompletionlaborunits  estimateatcompletionlaborunits
,a.estimatetocompletelaborunits  estimatetocompletelaborunits
,a.plannedlaborunits  plannedlaborunits
,a.plannednonlaborunits  plannednonlaborunits
,a.plannedvaluelaborunits  plannedvaluelaborunits
,a.remaininglaborunits  remaininglaborunits
,a.remaininglatelaborunits  remaininglatelaborunits
,a.remaininglatenonlaborunits  remaininglatenonlaborunits
,a.remainingnonlaborunits  remainingnonlaborunits
,a.actualcost  actualcost
,a.actualexpensecost  actualexpensecost
,a.actuallaborcost  actuallaborcost
,a.actualmaterialcost  actualmaterialcost
,a.actualnonlaborcost  actualnonlaborcost
,a.actualtotalcost  actualtotalcost
,a.atcompletionexpensecost  atcompletionexpensecost
,a.atcompletionlaborcost  atcompletionlaborcost
,a.atcompletionmaterialcost  atcompletionmaterialcost
,a.atcompletionnonlaborcost  atcompletionnonlaborcost
,a.atcompletiontotalcost  atcompletiontotalcost
,a.baselineplannedexpensecost  baselineplannedexpensecost
,a.baselineplannedlaborcost  baselineplannedlaborcost
,a.baselineplannedmaterialcost  baselineplannedmaterialcost
,a.baselineplannednonlaborcost  baselineplannednonlaborcost
,a.baselineplannedtotalcost  baselineplannedtotalcost
,a.baselineactualexpensecost  baselineactualexpensecost
,a.baselineactuallaborcost  baselineactuallaborcost
,a.baselineactualmaterialcost  baselineactualmaterialcost
,a.baselineactualnonlaborcost  baselineactualnonlaborcost
,a.baselineactualtotalcost  baselineactualtotalcost
,a.baseline1actualexpensecost  baseline1actualexpensecost
,a.baseline1actuallaborcost  baseline1actuallaborcost
,a.baseline1actualmaterialcost  baseline1actualmaterialcost
,a.baseline1actualnonlaborcost  baseline1actualnonlaborcost
,a.baseline1actualtotalcost  baseline1actualtotalcost
,a.baseline1plannedexpensecost  baseline1plannedexpensecost
,a.baseline1plannedlaborcost  baseline1plannedlaborcost
,a.baseline1plannedmaterialcost  baseline1plannedmaterialcost
,a.baseline1plannednonlaborcost  baseline1plannednonlaborcost
,a.baseline1plannedtotalcost  baseline1plannedtotalcost
,a.earnedvaluecost  earnedvaluecost
,a.estimateatcompletioncost  estimateatcompletioncost
,a.estimatetocompletecost  estimatetocompletecost
,a.plannedexpensecost  plannedexpensecost
,a.plannedlaborcost  plannedlaborcost
,a.plannedmaterialcost  plannedmaterialcost
,a.plannednonlaborcost  plannednonlaborcost
,a.plannedtotalcost  plannedtotalcost
,a.plannedvaluecost  plannedvaluecost
,a.remainingexpensecost  remainingexpensecost
,a.remaininglaborcost  remaininglaborcost
,a.remaininglateexpensecost  remaininglateexpensecost
,a.remaininglatelaborcost  remaininglatelaborcost
,a.remaininglatematerialcost  remaininglatematerialcost
,a.remaininglatenonlaborcost  remaininglatenonlaborcost
,a.remaininglatetotalcost  remaininglatetotalcost
,a.remainingmaterialcost  remainingmaterialcost
,a.remainingnonlaborcost  remainingnonlaborcost
,a.remainingtotalcost  remainingtotalcost
,a.update_date  lastupdatedate
,T1.cbs_id cbsobjectid  
FROM dbo.ACTIVITYSPREAD a
    INNER JOIN dbo.TASK T1 
ON T1.task_id = ActivityObjectId  AND T1.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEHIERARCHY ' and type='V')
  DROP VIEW ACTIVITYCODEHIERARCHY 
go

print 'creating view ACTIVITYCODEHIERARCHY'
go
     
--METADATA NAME:ACTIVITYCODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.codetypescope
,a.codetypeprojectid 
FROM dbo.ACTIVITYCODEHIERARCHY a
    INNER JOIN dbo.ACTVCODE T1 
ON T1.actv_code_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.ACTVCODE T2 
ON T2.actv_code_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODETYPESECURITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODETYPESECURITY ' and type='V')
  DROP VIEW ACTIVITYCODETYPESECURITY 
go

print 'creating view ACTIVITYCODETYPESECURITY'
go
     
--METADATA NAME:ACTIVITYCODETYPESECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODETYPESECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid 
FROM dbo.ACTIVITYCODETYPESECURITY a
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNTHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNTHIERARCHY ' and type='V')
  DROP VIEW COSTACCOUNTHIERARCHY 
go

print 'creating view COSTACCOUNTHIERARCHY'
go
     
--METADATA NAME:COSTACCOUNTHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW COSTACCOUNTHIERARCHY
AS
SELECT a.parentobjectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname 
FROM dbo.COSTACCOUNTHIERARCHY a
    INNER JOIN dbo.ACCOUNT T1 
ON T1.acct_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.ACCOUNT T2 
ON T2.acct_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:COSTSECURITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTSECURITY ' and type='V')
  DROP VIEW COSTSECURITY 
go

print 'creating view COSTSECURITY'
go
     
--METADATA NAME:COSTSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW COSTSECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid
,a.wholeprojectflag 
FROM dbo.COSTSECURITY a
go
     
--METADATA  TYPE:SSCR NAME:EPSHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSHIERARCHY ' and type='V')
  DROP VIEW EPSHIERARCHY 
go

print 'creating view EPSHIERARCHY'
go
     
--METADATA NAME:EPSHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSHIERARCHY
AS
SELECT a.parentobjectid
,a.parentprojectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childprojectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
FROM dbo.EPSHIERARCHY a
    INNER JOIN dbo.PROJWBS T1 
ON T1.wbs_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.PROJWBS T2 
ON T2.wbs_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:WBSHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSHIERARCHY ' and type='V')
  DROP VIEW WBSHIERARCHY 
go

print 'creating view WBSHIERARCHY'
go
     
--METADATA NAME:WBSHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW WBSHIERARCHY
AS
SELECT a.parentobjectid
,a.parentprojectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childprojectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
FROM dbo.WBSHIERARCHY a
    INNER JOIN dbo.PROJWBS T1 
ON T1.wbs_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.PROJWBS T2 
ON T2.wbs_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:EPSSPREAD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPREAD ' and type='V')
  DROP VIEW EPSSPREAD 
go

print 'creating view EPSSPREAD'
go
     
--METADATA NAME:EPSSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPREAD
AS
SELECT a.objectid
,a.id
,a.name
,a.parentobjectid
,a.projectobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
FROM dbo.EPSSPREAD a
    INNER JOIN dbo.PROJWBS T1 
ON T1.wbs_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:GLOBALSECURITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBALSECURITY ' and type='V')
  DROP VIEW GLOBALSECURITY 
go

print 'creating view GLOBALSECURITY'
go
     
--METADATA NAME:GLOBALSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW GLOBALSECURITY
AS
SELECT a.rdbmsuserid
,a.securecodeflag
,a.resourcecostflag
,a.proficiencyflag
,a.auditdataflag 
FROM dbo.GLOBALSECURITY a
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEHIERARCHY ' and type='V')
  DROP VIEW PROJECTCODEHIERARCHY 
go

print 'creating view PROJECTCODEHIERARCHY'
go
     
--METADATA NAME:PROJECTCODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.codetypeweight
,a.maxcodevalueweight
,a.parentcodevalueweight
,a.childcodevalueweight 
FROM dbo.PROJECTCODEHIERARCHY a
    INNER JOIN dbo.PCATVAL T1 
ON T1.proj_catg_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.PCATVAL T2 
ON T2.proj_catg_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSECURITY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSECURITY ' and type='V')
  DROP VIEW PROJECTSECURITY 
go

print 'creating view PROJECTSECURITY'
go
     
--METADATA NAME:PROJECTSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid
,a.costflag
,a.update_date  lastupdatedate 
FROM dbo.PROJECTSECURITY a
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPREAD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPREAD ' and type='V')
  DROP VIEW PROJECTSPREAD 
go

print 'creating view PROJECTSPREAD'
go
     
--METADATA NAME:PROJECTSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPREAD
AS
SELECT a.objectid
,a.id
,a.name
,a.parentepsobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedlaborunits
,a.plannednonlaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedexpensecost
,a.plannedlaborcost
,a.plannedmaterialcost
,a.plannednonlaborcost
,a.plannedtotalcost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
FROM dbo.PROJECTSPREAD a
    INNER JOIN dbo.PROJECT T1 
ON T1.proj_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:REPORTDATE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTDATE ' and type='V')
  DROP VIEW REPORTDATE 
go

print 'creating view REPORTDATE'
go
     
--METADATA NAME:REPORTDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW REPORTDATE
AS
SELECT a.datename  datename
,a.daydate  daydate
,a.dayname  dayname
,a.dayofmonth  dayofmonth
,a.dayofyear  dayofyear
,a.ordinaldayofmonth  ordinaldayofmonth
,a.ordinaldayofyear  ordinaldayofyear
,a.weekbegindate  weekbegindate
,a.dayofweek  dayofweek
,a.weeknumber  weeknumber
,a.monthnumber  monthnumber
,a.monthname  monthname
,a.monthshortname  monthshortname
,a.monthenddate  monthenddate
,a.daysinmonth  daysinmonth
,a.yearmonth  yearmonth
,a.quarternumber  quarternumber
,a.quartername  quartername
,a.year  year
,a.etlprocess  etlprocess
,a.etluser  etluser 
FROM dbo.REPORTDATE a
go
     
--METADATA  TYPE:SSCR NAME:REPORTTIME  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTTIME ' and type='V')
  DROP VIEW REPORTTIME 
go

print 'creating view REPORTTIME'
go
     
--METADATA NAME:REPORTTIME TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW REPORTTIME
AS
SELECT a.civiliantime  civiliantime
,a.militarytime  militarytime
,a.twochar  twochar
,a.timename  timename
,a.timeofday  timeofday
,a.etlprocess  etlprocess
,a.etluser  etluser 
FROM dbo.REPORTTIME a
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEHIERARCHY ' and type='V')
  DROP VIEW RESOURCECODEHIERARCHY 
go

print 'creating view RESOURCECODEHIERARCHY'
go
     
--METADATA NAME:RESOURCECODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname 
FROM dbo.RESOURCECODEHIERARCHY a
    INNER JOIN dbo.RCATVAL T1 
ON T1.rsrc_catg_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.RCATVAL T2 
ON T2.rsrc_catg_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHIERARCHY  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHIERARCHY ' and type='V')
  DROP VIEW RESOURCEHIERARCHY 
go

print 'creating view RESOURCEHIERARCHY'
go
     
--METADATA NAME:RESOURCEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHIERARCHY
AS
SELECT a.parentobjectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
FROM dbo.RESOURCEHIERARCHY a
    INNER JOIN dbo.RSRC T1 
ON T1.rsrc_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN dbo.RSRC T2 
ON T2.rsrc_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
go
     
--METADATA  TYPE:SSCR NAME:WBSSPREAD  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSSPREAD ' and type='V')
  DROP VIEW WBSSPREAD 
go

print 'creating view WBSSPREAD'
go
     
--METADATA NAME:WBSSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW WBSSPREAD
AS
SELECT a.objectid
,a.parentobjectid
,a.code
,a.name
,a.projectobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedlaborunits
,a.plannednonlaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedexpensecost
,a.plannedlaborcost
,a.plannedmaterialcost
,a.plannednonlaborcost
,a.plannedtotalcost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
FROM dbo.WBSSPREAD a
    INNER JOIN dbo.PROJWBS T1 
ON T1.wbs_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
go
     
--CONNECT USERNAME:pxrptuser
	 
--METADATA  TYPE:SSCR NAME:BASELINE  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BASELINE ' and type='V')
  DROP VIEW BASELINE 
go

print 'creating view BASELINE'
go
     

--METADATA NAME:BASELINE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BASELINE
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,a.control_updates_flag allowstatusreview
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,p.proj_short_name parentprojectid
,PW.wbs_name name
FROM dbo.PROJECT a,dbo.PROJECT p,dbo.PROJWBS PW
WHERE (a.delete_session_id is null) and (a.orig_proj_id is not null) and (a.orig_proj_id != a.proj_id) and p.proj_id = a.orig_proj_id and pw.proj_id = a.proj_id and pw.proj_node_flag='Y'
go
     
IF OBJECT_ID (N'RESOURCESECURITY', N'V') IS NOT NULL
    DROP VIEW RESOURCESECURITY
GO

--METADATA NAME:RESOURCESECURITY TYPE:VIEW SET:RESOURCE_SECURITY CHANGE:CREATE
create view RESOURCESECURITY
as
select 0 rdbmsuserid, r.rsrc_id resourceobjectid, r.update_date lastupdatedate
from dbo.rsrc r
union
select u.user_id rdbmsuserid, r.rsrc_id resourceobjectid, r.update_date lastupdatedate
from dbo.rsrc r, dbo.users u
where u.all_rsrc_access_flag = 'Y'  and u.prof_id != 12
union
select r.user_id rdbmsuserid, rh.CHILDOBJECTID resourceobjectid, r.update_date lastupdatedate
from dbo.rsrcsec r, dbo.resourcehierarchy rh, dbo.users u
where rh.PARENTOBJECTID = r.rsrc_id
and r.user_id = u.user_id
and u.all_rsrc_access_flag = 'N'
go
--METADATA  TYPE:SSCR NAME:AUDIT_SETTINGS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'AUDIT_SETTINGS', N'V') IS NOT NULL
    DROP VIEW AUDIT_SETTINGS
GO

--METADATA NAME:AUDIT_SETTINGS TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE VIEW AUDIT_SETTINGS
AS
SELECT DISTINCT SUBSTRING(SES.NAMESPACE,16,LEN(SES.NAMESPACE)) AS TABLE_NAME FROM dbo.SETTINGS SES WHERE LOWER(SES.NAMESPACE) LIKE 'database.audit.%'
go

--METADATA  TYPE:SSCR NAME:AUDIT_USERS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'AUDIT_USERS', N'V') IS NOT NULL
    DROP VIEW AUDIT_USERS
GO

--METADATA NAME:AUDIT_USERS TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE VIEW AUDIT_USERS
AS
SELECT DISTINCT USER_NAME FROM dbo.USERS
go

--METADATA  TYPE:SSCR NAME:AUDIT_PROJINFO  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'AUDIT_PROJINFO', N'V') IS NOT NULL
    DROP VIEW AUDIT_PROJINFO
GO

--METADATA NAME:AUDIT_PROJINFO TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE VIEW AUDIT_PROJINFO
AS
SELECT PROJ_ID,PROJ_SHORT_NAME FROM dbo.PROJECT WHERE ORIG_PROJ_ID IS NULL
go

--METADATA  TYPE:SSCR NAME:PRMAUDIT_FULL  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'PRMAUDIT_FULL', N'V') IS NOT NULL
    DROP VIEW PRMAUDIT_FULL
GO

--METADATA NAME:PRMAUDIT_FULL TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE VIEW PRMAUDIT_FULL
AS
select TOP 100 PERCENT
px.audit_ts,
px.prm_user_name,
px.host_name,
px.app_name,
px.table_name,
px.tab_primary_keys,
px.tab_col_name,
px.old_value,
px.new_value,
px.oper
from  dbo.pauditx px
order by px.audit_ts desc,px.table_name,px.tab_col_name
go

--METADATA  TYPE:SSCR NAME:PRMAUDIT_PROJ  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'PRMAUDIT_PROJ', N'V') IS NOT NULL
    DROP VIEW PRMAUDIT_PROJ
GO

--METADATA NAME:PRMAUDIT_PROJ TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE VIEW PRMAUDIT_PROJ
AS
select distinct TOP 100 PERCENT 
   pr.proj_id, pr.proj_short_name, pw.wbs_name as proj_name, 
   paf.table_name, paf.pk1 as tab_primary_keys, paf.audit_ts,paf.tab_col_name,
   paf.old_value,paf.new_value,paf.oper, paf.prm_user_name, paf.app_name 
  from dbo.project pr inner join dbo.projwbs pw 
        on pr.proj_short_name=pw.wbs_short_name 
   inner join 
   (select case when CHARINDEX(':',px.tab_primary_keys) = 0 then px.tab_primary_keys 
              else  substring(px.tab_primary_keys,1,CHARINDEX(':',px.tab_primary_keys)-1) end pk1,
			  px.tab_primary_keys,px.proj_id,px.audit_ts, px.table_name, px.prm_user_name, px.app_name,
              px.tab_col_name,px.old_value,px.new_value,px.oper
     from dbo.pauditx px ) paf
 on pw.proj_id=paf.proj_id 
 order by paf.audit_ts desc,paf.table_name,paf.tab_col_name
go

--METADATA  TYPE:SSCR NAME:P6AUDIT_SETTINGS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6AUDIT_SETTINGS' and type='SN')
  DROP SYNONYM P6AUDIT_SETTINGS 
go

--METADATA NAME:P6AUDIT_SETTINGS TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create synonym P6AUDIT_SETTINGS for AUDIT_SETTINGS
go

--METADATA  TYPE:SSCR NAME:P6AUDIT_USERS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6AUDIT_USERS' and type='SN')
  DROP SYNONYM P6AUDIT_USERS 
go
--METADATA NAME:P6AUDIT_USERS TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create synonym P6AUDIT_USERS for AUDIT_USERS
go

--METADATA  TYPE:SSCR NAME:P6AUDIT_PROJINFO  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6AUDIT_PROJINFO' and type='SN')
  DROP SYNONYM P6AUDIT_PROJINFO 
go

--METADATA NAME:P6AUDIT_PROJINFO TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create synonym P6AUDIT_PROJINFO for AUDIT_PROJINFO
go

--METADATA  TYPE:SSCR NAME:P6PRMAUDIT_FULL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PRMAUDIT_FULL' and type='SN')
  DROP SYNONYM P6PRMAUDIT_FULL 
go
--METADATA NAME:P6PRMAUDIT_FULL TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create synonym P6PRMAUDIT_FULL for PRMAUDIT_FULL
go

--METADATA  TYPE:SSCR NAME:P6PRMAUDIT_PROJ  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PRMAUDIT_PROJ' and type='SN')
  DROP SYNONYM P6PRMAUDIT_PROJ 
go

--METADATA NAME:P6PRMAUDIT_PROJ TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create synonym P6PRMAUDIT_PROJ for PRMAUDIT_PROJ
go

--METADATA  TYPE:SSCR NAME:REFRDELETE  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'REFRDELETE', N'V') IS NOT NULL
    DROP VIEW REFRDELETE
GO

--METADATA NAME:REFRDELETE TYPE:VIEW SET:PRMAUDIT DATA FOR ANALYTICS CHANGE:CREATE
CREATE VIEW REFRDELETE(LASTUPDATEDATE,TABLENAME,OBJECTID,OBJECTID2,OBJECTID3,OBJECTID4,PROJECTOBJECTID) 
AS
select DELETE_DATE,TABLE_NAME,PK1,PK2,PK3,PK4,PROJ_ID FROM  REFRDEL
where upper(TABLE_NAME) in ('ACTVCODE','ACTVTYPE','ACCOUNT','CALENDAR','CBS','COSTTYPE','FINDATES','LOCATION','OBS','PCATVAL','PROJCOST','PROJECT','PROJWBS','PROJPCAT',
'PCATTYPE','PROJECT_ETL_LIST','PFOLIO','RSRCSEC','RCATVAL','RSRCRCAT','RSRCRATE','RSRFOLIO','RISK','RISKTYPE','ROLES','TASK','TASKACTV','TASKMEMO','TASKRISK','TASKPROC','TASKRSRC',
'UDFTYPE','UDFVALUE','USERENG','USERS','WBSMEMO','ACTIVITYSPREAD','PROJECTSECURITY',' RESOURCEASSIGNMENTSPREAD','RESOURCECODEHIERARCHY','WBSHIERARCHY','EPSHIERARCHY',
'PRPFOLIO','RSRCROLE','RSRC','RFOLIO')
go

--METADATA  TYPE:SSCR NAME:P6REFRDELETE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6REFRDELETE' and type='SN')
  DROP SYNONYM P6REFRDELETE 
go

--METADATA NAME:P6REFRDELETE TYPE:SYNONYM SET:PRMAUDIT DATA FOR ANALYTICS CHANGE:CREATE
create synonym P6REFRDELETE for REFRDELETE
go

--METADATA  TYPE:SSCR NAME:ROLELIMIT  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'ROLELIMIT', N'V') IS NOT NULL
    DROP VIEW ROLELIMIT
GO

--METADATA NAME:ROLELIMIT TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:CREATE
CREATE VIEW ROLELIMIT (roleobjectid,startdate,enddate,max_qty_per_hr,lastupdatedate) 
AS
SELECT R.ROLE_ID ROLEOBJECTID,
CONVERT(DATETIME, '12/31/1900') STARTDATE,
ISNULL((SELECT MIN(R2.START_DATE)FROM dbo.ROLERATE R2 WHERE R2.ROLE_ID = R.ROLE_ID), 
CONVERT(DATETIME, '12/31/3000')) ENDDATE,
0 MAX_QTY_PER_HR,
update_date lastupdatedate
FROM dbo.ROLES R
UNION
SELECT R.ROLE_ID ROLEOBJECTID,
R.START_DATE STARTDATE,
ISNULL((SELECT MIN(R2.START_DATE) FROM dbo.ROLERATE R2 WHERE R2.ROLE_ID = R.ROLE_ID AND R2.START_DATE > R.START_DATE), 
CONVERT(DATETIME, '12/31/3000')) ENDDATE,
MAX_QTY_PER_HR,
update_date lastupdatedate
FROM dbo.ROLERATE R
go
--METADATA  TYPE:SSCR NAME:ROLEAVAILABILITY  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'ROLEAVAILABILITY', N'V') IS NOT NULL
    DROP VIEW ROLEAVAILABILITY
GO
--METADATA NAME:ROLEAVAILABILITY TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:CREATE
CREATE VIEW ROLEAVAILABILITY(year,yearmonth,quarter,week,startdate,enddate,rolename,roleid,roleobjectid,limit,lastupdatedate) AS
select TOP 100 PERCENT rd.year,
rd.yearmonth yearmonth,
rd.quarternumber quarter,
rd.weekbegindate week,
rd.daydate startdate,
rd.daydate + 1 enddate,
r.name rolename,
r.id roleid,
r.objectid roleobjectid,
sum(c.totalworkhours * rv.max_qty_per_hr) limit,
r.lastupdatedate
from calendar c, rolelimit rv, reportdate rd, role r
where c.isdefault='Y' and c.daydate between rv.startdate and rv.enddate and rd.daydate = c.daydate and r.objectid = rv.roleobjectid
group by rd.year,rd.yearmonth,rd.quarternumber,rd.weekbegindate,rd.daydate,r.name,r.id,r.objectid,r.lastupdatedate
order by rd.year,rd.yearmonth,rd.quarternumber,rd.weekbegindate,rd.daydate,r.name,r.id,r.objectid
go
--METADATA  TYPE:SSCR NAME:PXSERVICES  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'PXSERVICES', N'V') IS NOT NULL
    DROP VIEW PXSERVICES
GO

--METADATA NAME:PXSERVICES TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:Lookup view for Jobsvc table 
create view PXSERVICES
(JOBID, SEQNUM,AUDITFLAG,JOBTYPE,JOBTYPEKEY, JOBNAME,USERID,LASTRUNDATE,STATUSCODE,RECURDATA,RECURTYPE,
SUBMITTEDDATE,WORKHOST,UPDATEDATE,UPDATEUSER,CREATEDATE,CREATEUSER,DELETESESSIONID,DELETEDATE)
AS
select job_id, seq_num, audit_flag, job_type, job_type_key, job_name, user_id, last_run_date, status_code, recur_data,
recur_type, submitted_date, worker_host, update_date, update_user, create_date, create_user, delete_session_id, delete_date
from dbo.jobsvc
where job_type in ('JT_EnterpriseSum', 'JT_Security', 'JT_ResourceMgmt', 'JT_EnterpriseData', 'JT_ProjectArbiter', 'JT_Project')
go

--METADATA  TYPE:SSCR NAME:PXSETTINGS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'PXSETTINGS', N'V') IS NOT NULL
    DROP VIEW PXSETTINGS
GO

--METADATA NAME:PXSETTINGS TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:Lookup view for settings table 
create view PXSETTINGS
(namespace, settingname, settingvalue, userid, updatedate, updateuser, createdate, createuser)
AS
select namespace, setting_name, setting_value, user_id, update_date, update_user, create_date, create_user
from dbo.settings
go
--METADATA  TYPE:SSCR NAME:USER_LOGIN_DTLS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'USER_LOGIN_DTLS', N'V') IS NOT NULL
    DROP VIEW USER_LOGIN_DTLS
GO

--METADATA NAME:USER_LOGIN_DTLS TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE VIEW USER_LOGIN_DTLS (USER_ID,USER_NAME,LOG_IN_DATE_AND_TIME,LOG_OUT_DATE_AND_TIME,TOTAL_TIME_LOGGED_IN,APP_NAME,HOST_NAME)
AS
with USESSAUDV as (
select USER_ID,USER_NAME,
CONVERT(VARCHAR,LOGIN_DATE ,120) as LOG_IN_DATE_AND_TIME,
CONVERT(VARCHAR,LOGOUT_DATE ,120) as LOG_OUT_DATE_AND_TIME,
cast((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))/3600 as varchar) + ':'+
cast(((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))%3600)/60  as varchar) +':'+
cast(((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))%3600)%60  as varchar) as TOTAL_TIME_LOGGED_IN,
case 
when APP_NAME = 'Projects' then 'P6 Web'
when APP_NAME = 'Resources' then 'P6 Web'
when APP_NAME = 'Portfolios' then 'P6 Web'
when APP_NAME = 'Enterprise Reports' then 'P6 Web'
when APP_NAME = 'P6 Optional Client' then 'P6 Client'
when APP_NAME = 'Team Member' then 'TM Web'
when APP_NAME = 'Web Services' then 'P6 Web Service'
when APP_NAME = 'Project Management' then 'P6 Client'
when APP_NAME is null or APP_NAME = '' then DB_ENGINE_TYPE
when DB_ENGINE_TYPE = 'INT_API' then 'Integration API'
else APP_NAME
end APP_NAME,
HOST_NAME,
RN = ROW_NUMBER()OVER(PARTITION BY login_date,logout_date ORDER BY login_date)
from USESSAUD
where app_name in ('Projects' ,'Resources' ,'Portfolios' ,'Enterprise Reports','Project Management')
and db_engine_type != 'INT_OVR')
SELECT USER_ID,USER_NAME,
CONVERT(VARCHAR,LOGIN_DATE ,120) as LOG_IN_DATE_AND_TIME,
CONVERT(VARCHAR,LOGOUT_DATE ,120) as LOG_OUT_DATE_AND_TIME,
cast((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))/3600 as varchar) + ':'+
cast(((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))%3600)/60  as varchar) +':'+
cast(((DateDiff(s,LOGIN_DATE,LOGOUT_DATE))%3600)%60  as varchar) as TOTAL_TIME_LOGGED_IN,
case 
when APP_NAME = 'Projects' then 'P6 Web'
when APP_NAME = 'Resources' then 'P6 Web'
when APP_NAME = 'Portfolios' then 'P6 Web'
when APP_NAME = 'Enterprise Reports' then 'P6 Web'
when APP_NAME = 'P6 Optional Client' then 'P6 Client'
when APP_NAME = 'Team Member' then 'TM Web'
when APP_NAME = 'Web Services' then 'P6 Web Service'
when APP_NAME = 'Project Management' then 'P6 Client'
when APP_NAME is null or APP_NAME = '' then DB_ENGINE_TYPE
when DB_ENGINE_TYPE = 'INT_API' then 'Integration API'
else APP_NAME
end APP_NAME,
HOST_NAME
FROM USESSAUD a
where not exists ( select 1 from USESSAUD b where b.login_date=a.login_date and b.logout_date=a.logout_date
                                   and app_name in ('Projects' ,'Resources' ,'Portfolios' ,'Enterprise Reports','Project Management' ))
and db_engine_type != 'INT_OVR'
union all
select USER_ID,USER_NAME,
LOG_IN_DATE_AND_TIME,
LOG_OUT_DATE_AND_TIME,
TOTAL_TIME_LOGGED_IN,
APP_NAME,
HOST_NAME 
from USESSAUDV us
WHERE NOT EXISTS  (SELECT 1 FROM dbo.USERS u where us.USER_ID = u.USER_ID and u.SYSTEMUSER ='Y')
AND RN = 1
go

--METADATA  TYPE:SSCR NAME:P6USER_LOGIN_DTLS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USER_LOGIN_DTLS' and type='SN')
  DROP SYNONYM P6USER_LOGIN_DTLS 
go

--METADATA NAME:P6REFRDELETE TYPE:SYNONYM SET:PRMAUDIT DATA FOR ANALYTICS CHANGE:CREATE
create synonym P6USER_LOGIN_DTLS for USER_LOGIN_DTLS
go

--METADATA  TYPE:SSCR NAME:USER_NOT_LOGGED_DTL  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'USER_NOT_LOGGED_DTL', N'V') IS NOT NULL
    DROP VIEW USER_NOT_LOGGED_DTL
GO

--METADATA NAME:USER_NOT_LOGGED_DTL TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE  VIEW  USER_NOT_LOGGED_DTL (USER_ID, USER_NAME,LAST_ACTIVE_TIME) 
AS 
select TOP 100 PERCENT U.USER_ID,U.USER_NAME,US.LAST_ACTIVE_TIME FROM
DBO.USERS U LEFT OUTER JOIN DBO.USESSAUD US 
ON U.USER_ID=US.USER_ID
WHERE U.SYSTEMUSER='N'
ORDER BY LAST_ACTIVE_TIME
go

--METADATA  TYPE:SSCR NAME:P6USER_NOT_LOGGED_DTL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USER_NOT_LOGGED_DTL' and type='SN')
  DROP SYNONYM P6USER_NOT_LOGGED_DTL 
go

--METADATA NAME:P6USER_NOT_LOGGED_DTL TYPE:SYNONYM SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
create synonym P6USER_NOT_LOGGED_DTL FOR USER_NOT_LOGGED_DTL
go

--METADATA  TYPE:SSCR NAME:NEVER_LOGGED_USER_DTL  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'NEVER_LOGGED_USER_DTL', N'V') IS NOT NULL
    DROP VIEW NEVER_LOGGED_USER_DTL
GO

--METADATA NAME:NEVER_LOGGED_USER_DTL TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE VIEW NEVER_LOGGED_USER_DTL(USER_ID, USER_NAME) 
AS 
SELECT TOP 100 PERCENT U.USER_ID,U.USER_NAME 
FROM dbo.USERS U
WHERE NOT EXISTS(SELECT 1 FROM dbo.USERSET US WHERE US.USER_ID=U.USER_ID 
AND US.SETTING_NAME='WebLoggedIn')
AND U.SYSTEMUSER='N'
ORDER BY U.USER_NAME
go

--METADATA  TYPE:SSCR NAME:P6NEVER_LOGGED_USER_DTL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6NEVER_LOGGED_USER_DTL' and type='SN')
  DROP SYNONYM P6NEVER_LOGGED_USER_DTL 
go

--METADATA NAME:NEVER_LOGGED_USER_DTL TYPE:SYNONYM SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
create synonym P6NEVER_LOGGED_USER_DTL FOR NEVER_LOGGED_USER_DTL
go
--METADATA  TYPE:SSCR NAME:TIMESHEETDELEGATE  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'TIMESHEETDELEGATE', N'V') IS NOT NULL
    DROP VIEW TIMESHEETDELEGATE
GO

--METADATA NAME:TIMESHEETDELEGATE TYPE:VIEW SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE VIEW TIMESHEETDELEGATE AS
    SELECT
        a.ts_delegate_id      objectid,
        a.user_id             userobjectid,
        a.ts_delegate_user_id delegateuserobjectid,
        a.proj_id             projectobjectid,
        a.active_flag         isactive,
        a.update_user         lastupdateuser,
        a.update_date         lastupdatedate,
        a.create_user         createuser,
        a.create_date         createdate
    FROM dbo.tsdelegate a
    WHERE
        a.delete_session_id IS NULL
GO

--METADATA  TYPE:SSCR NAME:P6TIMESHEETDELEGATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6TIMESHEETDELEGATE' and type='SN')
  DROP SYNONYM P6TIMESHEETDELEGATE 
go

--METADATA NAME:P6TIMESHEETDELEGATE TYPE:SYNONYM SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE SYNONYM P6TIMESHEETDELEGATE FOR TIMESHEETDELEGATE
GO

--METADATA  TYPE:SSCR NAME:OBSPROJ  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'OBSPROJ', N'V') IS NOT NULL
    DROP VIEW OBSPROJ
GO

--METADATA NAME:OBSPROJ TYPE:VIEW SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE VIEW OBSPROJ AS
    SELECT
        a.obs_id      obsobjectid,
        a.proj_id     projectobjectid,
        a.wbs_id      wbsobjectid
    FROM dbo.obsproj a
GO

--METADATA  TYPE:SSCR NAME:WBSREVIEWERS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'WBSREVIEWERS', N'V') IS NOT NULL
    DROP VIEW WBSREVIEWERS
GO

--METADATA NAME:WBSREVIEWERS TYPE:VIEW SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE VIEW WBSREVIEWERS AS
    SELECT
        a.wbsreviewers_id      objectid,
        a.wbs_id             wbsobjectid,
        a.status_reviewer revieweruserobjectid,
        a.update_user         lastupdateuser,
        a.update_date         lastupdatedate,
        a.create_user         createuser,
        a.create_date         createdate
    FROM dbo.wbsreviewers a
    WHERE
        a.delete_session_id IS NULL
GO

--METADATA  TYPE:SSCR NAME:P6WBSREVIEWERS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSREVIEWERS' and type='SN')
  DROP SYNONYM P6WBSREVIEWERS 
go

--METADATA NAME:P6WBSREVIEWERS TYPE:SYNONYM SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE  SYNONYM P6WBSREVIEWERS FOR WBSREVIEWERS
GO

--METADATA  TYPE:SSCR NAME:WBSREVIEWSTATUS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'WBSREVIEWSTATUS', N'V') IS NOT NULL
    DROP VIEW WBSREVIEWSTATUS
GO

--METADATA NAME:WBSREVIEWSTATUS TYPE:VIEW SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE VIEW WBSREVIEWSTATUS AS
    SELECT
        a.wbsreviewstatus_id      objectid,
        a.wbs_id             wbsobjectid,
        a.status_reviewer revieweruserobjectid,
        a.fk_id  foreignobjectid,
        a.table_name tablename,
        a.update_user         lastupdateuser,
        a.update_date         lastupdatedate,
        a.create_user         createuser,
        a.create_date         createdate
    FROM dbo.wbsreviewstatus a
    WHERE
        a.delete_session_id IS NULL
GO

--METADATA  TYPE:SSCR NAME:P6WBSREVIEWSTATUS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSREVIEWSTATUS' and type='SN')
  DROP SYNONYM P6WBSREVIEWSTATUS 
go

--METADATA NAME:P6WBSREVIEWSTATUS TYPE:SYNONYM SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE SYNONYM P6WBSREVIEWSTATUS FOR WBSREVIEWSTATUS
GO

--METADATA  TYPE:SSCR NAME:STATUS_REVIEWERS  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'STATUS_REVIEWERS', N'V') IS NOT NULL
    DROP VIEW STATUS_REVIEWERS
GO

--METADATA NAME:STATUS_REVIEWERS TYPE:VIEW SET:PX VIEWS FOR REPORTS CHANGE:CREATE
CREATE VIEW STATUS_REVIEWERS AS
    SELECT
        u.name
    FROM users u
    WHERE
        EXISTS (
            SELECT
                1
            FROM wbsreviewers w
            WHERE
                w.revieweruserobjectid = u.objectid
        )
GO

print 'Creating Full View RESOURCEASSIGNMENTSPREAD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTSPREAD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTSPREAD_FULL ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTSPREAD_FULL 
go

print 'Creating Full View RESOURCEASSIGNMENTSPREAD_FULL'
go

     
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENTSPREAD_FULL
AS SELECT 
ResourceAssignmentObjectId,
StartDate,
EndDate,
resourceobjectid,
RoleObjectId,
ActivityObjectId,
WBSObjectId,
projectobjectid,
CostAccountObjectId,
ActualRegularUnits,
ActualOvertimeUnits,
ActualUnits,
AtCompletionUnits,
PlannedUnits,
RemainingUnits,
RemainingLateUnits,
StaffedRemainingUnits,
StaffedRemainingLateUnits,
UnstaffedRemainingUnits,
UnstaffedRemainingLateUnits,
ActualRegularCost,
ActualOvertimeCost,
ActualCost,
AtCompletionCost,
PlannedCost,
RemainingCost,
RemainingLateCost,
StaffedRemainingCost,
StaffedRemainingLateCost,
UnstaffedRemainingCost,
UnstaffedRemainingLateCost,
lastupdatedate
FROM RESOURCEASSIGNMENTSPREAD
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTSPREAD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTSPREAD_U ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTSPREAD_U 
go

print 'Creating Project-Level View RESOURCEASSIGNMENTSPREAD_U'
go

     
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENTSPREAD_U
AS SELECT 
t.ResourceAssignmentObjectId,
t.StartDate,
t.EndDate,
t.resourceobjectid,
t.RoleObjectId,
t.ActivityObjectId,
t.WBSObjectId,
t.projectobjectid,
t.CostAccountObjectId,
t.ActualRegularUnits,
t.ActualOvertimeUnits,
t.ActualUnits,
t.AtCompletionUnits,
t.PlannedUnits,
t.RemainingUnits,
t.RemainingLateUnits,
t.StaffedRemainingUnits,
t.StaffedRemainingLateUnits,
t.UnstaffedRemainingUnits,
t.UnstaffedRemainingLateUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualRegularCost ELSE null END ActualRegularCost,
CASE CostFlag WHEN 'Y' THEN t.ActualOvertimeCost ELSE null END ActualOvertimeCost,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionCost ELSE null END AtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedCost ELSE null END PlannedCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingCost ELSE null END RemainingCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateCost ELSE null END RemainingLateCost,
CASE CostFlag WHEN 'Y' THEN t.StaffedRemainingCost ELSE null END StaffedRemainingCost,
CASE CostFlag WHEN 'Y' THEN t.StaffedRemainingLateCost ELSE null END StaffedRemainingLateCost,
CASE CostFlag WHEN 'Y' THEN t.UnstaffedRemainingCost ELSE null END UnstaffedRemainingCost,
CASE CostFlag WHEN 'Y' THEN t.UnstaffedRemainingLateCost ELSE null END UnstaffedRemainingLateCost,
t.lastupdatedate, ps.rdbmsuserid rpt_user_id
FROM RESOURCEASSIGNMENTSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RESOURCELIMIT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCELIMIT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELIMIT_FULL ' and type='V')
  DROP VIEW RESOURCELIMIT_FULL 
go

print 'Creating Full View RESOURCELIMIT_FULL'
go

     
--METADATA NAME:RESOURCELIMIT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCELIMIT_FULL
AS SELECT 
resourceobjectid,
startdate,
enddate,
limit,
lastupdatedate
FROM RESOURCELIMIT
go
     
--METADATA  TYPE:SSCR NAME:RESOURCELIMIT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELIMIT_U ' and type='V')
  DROP VIEW RESOURCELIMIT_U 
go

print 'Creating Project-Level View RESOURCELIMIT_U'
go

     
--METADATA NAME:RESOURCELIMIT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCELIMIT_U
AS SELECT 
t.resourceobjectid,
t.startdate,
t.enddate,
t.limit,
t.lastupdatedate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCELIMIT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View ACTIVITYSPREAD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSPREAD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSPREAD_FULL ' and type='V')
  DROP VIEW ACTIVITYSPREAD_FULL 
go

print 'Creating Full View ACTIVITYSPREAD_FULL'
go

     
--METADATA NAME:ACTIVITYSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSPREAD_FULL
AS SELECT 
ActivityObjectId,
StartDate,
EndDate,
ActivityCode,
ActivityName,
WBSObjectId,
projectobjectid,
ActualLaborUnits,
ActualNonLaborUnits,
AtCompletionLaborUnits,
AtCompletionNonLaborUnits,
BaselineActualLaborUnits,
BaselineActualNonLaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonLaborUnits,
Baseline1ActualLaborUnits,
Baseline1ActualNonLaborUnits,
Baseline1PlannedLaborUnits,
Baseline1PlannedNonLaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonLaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingLateLaborUnits,
RemainingLateNonLaborUnits,
RemainingNonLaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonLaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonLaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonLaborCost,
BaselinePlannedTotalCost,
BaselineActualExpenseCost,
BaselineActualLaborCost,
BaselineActualMaterialCost,
BaselineActualNonLaborCost,
BaselineActualTotalCost,
Baseline1ActualExpenseCost,
Baseline1ActualLaborCost,
Baseline1ActualMaterialCost,
Baseline1ActualNonLaborCost,
Baseline1ActualTotalCost,
Baseline1PlannedExpenseCost,
Baseline1PlannedLaborCost,
Baseline1PlannedMaterialCost,
Baseline1PlannedNonLaborCost,
Baseline1PlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonLaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingLateExpenseCost,
RemainingLateLaborCost,
RemainingLateMaterialCost,
RemainingLateNonLaborCost,
RemainingLateTotalCost,
RemainingMaterialCost,
RemainingNonLaborCost,
RemainingTotalCost,
lastupdatedate
FROM ACTIVITYSPREAD
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSPREAD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSPREAD_U ' and type='V')
  DROP VIEW ACTIVITYSPREAD_U 
go

print 'Creating Project-Level View ACTIVITYSPREAD_U'
go

     
--METADATA NAME:ACTIVITYSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSPREAD_U
AS SELECT 
t.ActivityObjectId,
t.StartDate,
t.EndDate,
t.ActivityCode,
t.ActivityName,
t.WBSObjectId,
t.projectobjectid,
t.ActualLaborUnits,
t.ActualNonLaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonLaborUnits,
t.BaselineActualLaborUnits,
t.BaselineActualNonLaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonLaborUnits,
t.Baseline1ActualLaborUnits,
t.Baseline1ActualNonLaborUnits,
t.Baseline1PlannedLaborUnits,
t.Baseline1PlannedNonLaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonLaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingLateLaborUnits,
t.RemainingLateNonLaborUnits,
t.RemainingNonLaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonLaborCost ELSE null END ActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonLaborCost ELSE null END AtCompletionNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonLaborCost ELSE null END BaselinePlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualExpenseCost ELSE null END BaselineActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualLaborCost ELSE null END BaselineActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualMaterialCost ELSE null END BaselineActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualNonLaborCost ELSE null END BaselineActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualTotalCost ELSE null END BaselineActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualExpenseCost ELSE null END Baseline1ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualLaborCost ELSE null END Baseline1ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualMaterialCost ELSE null END Baseline1ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualNonLaborCost ELSE null END Baseline1ActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualTotalCost ELSE null END Baseline1ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedExpenseCost ELSE null END Baseline1PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedLaborCost ELSE null END Baseline1PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedMaterialCost ELSE null END Baseline1PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedNonLaborCost ELSE null END Baseline1PlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedTotalCost ELSE null END Baseline1PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonLaborCost ELSE null END PlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateExpenseCost ELSE null END RemainingLateExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateLaborCost ELSE null END RemainingLateLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateMaterialCost ELSE null END RemainingLateMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateNonLaborCost ELSE null END RemainingLateNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateTotalCost ELSE null END RemainingLateTotalCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonLaborCost ELSE null END RemainingNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost,
t.lastupdatedate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITY_FULL ' and type='V')
  DROP VIEW ACTIVITY_FULL 
go

print 'Creating Full View ACTIVITY_FULL'
go

     
--METADATA NAME:ACTIVITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITY_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
calendarobjectid,
isnewfeedback,
autocomputeactuals,
percentcompletetype,
type,
durationtype,
reviewstatus,
status,
id,
name,
primaryresourceobjectid,
totalfloat,
freefloat,
remainingduration,
actuallaborunits,
remaininglaborunits,
plannedlaborunits,
plannedduration,
plannednonlaborunits,
actualnonlaborunits,
remainingnonlaborunits,
primaryconstraintdate,
actualstartdate,
actualfinishdate,
latestartdate,
latefinishdate,
expectedfinishdate,
earlystartdate,
earlyfinishdate,
remainingearlystartdate,
remainingearlyfinishdate,
plannedstartdate,
plannedfinishdate,
reviewfinishdate,
remaininglatestartdate,
remaininglatefinishdate,
primaryconstrainttype,
levelingpriority,
secondaryconstraintdate,
secondaryconstrainttype,
floatpath,
floatpathorder,
actualthisperiodlaborunits,
actualthisperiodnonlaborunits,
islongestpath,
suspenddate,
resumedate,
externalearlystartdate,
externallatefinishdate,
accountingvariance,
accountingvariancelaborunits,
actualduration,
actualexpensecost,
actuallaborcost,
actualmaterialcost,
actualnonlaborcost,
actualthisperiodlaborcost,
actualthisperiodmaterialcost,
actualthisperiodnonlaborcost,
actualtotalcost,
actualtotalunits,
atcompletionduration,
atcompletionexpensecost,
atcompletionlaborcost,
atcompletionlaborunits,
atcompletionlaborunitsvariance,
atcompletionmaterialcost,
atcompletionnonlaborcost,
atcompletionnonlaborunits,
atcompletiontotalcost,
atcompletiontotalunits,
atcompletionvariance,
baselineduration,
baselinefinishdate,
baselineplannedduration,
baselineplannedexpensecost,
baselineplannedlaborcost,
baselineplannedlaborunits,
baselineplannedmaterialcost,
baselineplannednonlaborcost,
baselineplannednonlaborunits,
baselineplannedtotalcost,
baselinestartdate,
baselinelatestartdate,
baseline1latestartdate,
baselinelatefinishdate,
baseline1latefinishdate,
budgetatcompletion,
calendarname,
costpercentcomplete,
costpercentofplanned,
costperformanceindex,
costperformanceindexlaborunits,
costvariance,
costvarianceindex,
costvarianceindexlaborunits,
costvariancelaborunits,
datadate,
duration1variance,
durationpercentcomplete,
durationpercentofplanned,
durationvariance,
earnedvaluecost,
earnedvaluelaborunits,
estimateatcompletioncost,
estimateatcompletionlaborunits,
estimatetocomplete,
estimatetocompletelaborunits,
expensecost1variance,
expensecostpercentcomplete,
expensecostvariance,
finishdate,
finishdate1variance,
finishdatevariance,
iscritical,
laborcost1variance,
laborcostpercentcomplete,
laborcostvariance,
laborunits1variance,
laborunitspercentcomplete,
laborunitsvariance,
materialcost1variance,
materialcostpercentcomplete,
materialcostvariance,
nonlaborcost1variance,
nonlaborcostpercentcomplete,
nonlaborcostvariance,
nonlaborunits1variance,
nonlaborunitspercentcomplete,
nonlaborunitsvariance,
percentcomplete,
performancepercentcomplete,
physicalpercentcomplete,
plannedexpensecost,
plannedlaborcost,
plannedmaterialcost,
plannednonlaborcost,
plannedtotalcost,
plannedtotalunits,
plannedvaluecost,
plannedvaluelaborunits,
primaryresourceid,
primaryresourcename,
remainingexpensecost,
remainingfloat,
remaininglaborcost,
remainingmaterialcost,
remainingnonlaborcost,
remainingtotalcost,
remainingtotalunits,
schedulepercentcomplete,
scheduleperfindexlaborunits,
scheduleperformanceindex,
schedulevariance,
schedulevarianceindex,
schedulevariancelaborunits,
schedulevarindexlaborunits,
startdate,
startdate1variance,
startdatevariance,
tocompleteperformanceindex,
totalcost1variance,
totalcostvariance,
unitspercentcomplete,
wbscode,
wbsname,
locationobjectid,
locationname,
reviewrequired,
isstarred,
cbscode,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex,
ActivityOwnerObjectId,
ActivityOwner 
,RPT_CURRENT_FLAG
FROM ACTIVITY
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITY_U ' and type='V')
  DROP VIEW ACTIVITY_U 
go

print 'Creating Project-Level View ACTIVITY_U'
go

     
--METADATA NAME:ACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITY_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.calendarobjectid,
t.isnewfeedback,
t.autocomputeactuals,
t.percentcompletetype,
t.type,
t.durationtype,
t.reviewstatus,
t.status,
t.id,
t.name,
t.primaryresourceobjectid,
t.totalfloat,
t.freefloat,
t.remainingduration,
t.actuallaborunits,
t.remaininglaborunits,
t.plannedlaborunits,
t.plannedduration,
t.plannednonlaborunits,
t.actualnonlaborunits,
t.remainingnonlaborunits,
t.primaryconstraintdate,
t.actualstartdate,
t.actualfinishdate,
t.latestartdate,
t.latefinishdate,
t.expectedfinishdate,
t.earlystartdate,
t.earlyfinishdate,
t.remainingearlystartdate,
t.remainingearlyfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.reviewfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.primaryconstrainttype,
t.levelingpriority,
t.secondaryconstraintdate,
t.secondaryconstrainttype,
t.floatpath,
t.floatpathorder,
t.actualthisperiodlaborunits,
t.actualthisperiodnonlaborunits,
t.islongestpath,
t.suspenddate,
t.resumedate,
t.externalearlystartdate,
t.externallatefinishdate,
CASE CostFlag WHEN 'Y' THEN t.accountingvariance ELSE null END accountingvariance,
t.accountingvariancelaborunits,
t.actualduration,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodlaborcost ELSE null END actualthisperiodlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodmaterialcost ELSE null END actualthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodnonlaborcost ELSE null END actualthisperiodnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualtotalcost ELSE null END actualtotalcost,
t.actualtotalunits,
t.atcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.atcompletionexpensecost ELSE null END atcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionlaborcost ELSE null END atcompletionlaborcost,
t.atcompletionlaborunits,
t.atcompletionlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.atcompletionmaterialcost ELSE null END atcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionnonlaborcost ELSE null END atcompletionnonlaborcost,
t.atcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletiontotalcost ELSE null END atcompletiontotalcost,
t.atcompletiontotalunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletionvariance ELSE null END atcompletionvariance,
t.baselineduration,
t.baselinefinishdate,
t.baselineplannedduration,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedexpensecost ELSE null END baselineplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedlaborcost ELSE null END baselineplannedlaborcost,
t.baselineplannedlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedmaterialcost ELSE null END baselineplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannednonlaborcost ELSE null END baselineplannednonlaborcost,
t.baselineplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedtotalcost ELSE null END baselineplannedtotalcost,
t.baselinestartdate,
t.baselinelatestartdate,
t.baseline1latestartdate,
t.baselinelatefinishdate,
t.baseline1latefinishdate,
CASE CostFlag WHEN 'Y' THEN t.budgetatcompletion ELSE null END budgetatcompletion,
t.calendarname,
t.costpercentcomplete,
t.costpercentofplanned,
t.costperformanceindex,
t.costperformanceindexlaborunits,
CASE CostFlag WHEN 'Y' THEN t.costvariance ELSE null END costvariance,
t.costvarianceindex,
t.costvarianceindexlaborunits,
t.costvariancelaborunits,
t.datadate,
t.duration1variance,
t.durationpercentcomplete,
t.durationpercentofplanned,
t.durationvariance,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.earnedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimateatcompletioncost ELSE null END estimateatcompletioncost,
t.estimateatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimatetocomplete ELSE null END estimatetocomplete,
t.estimatetocompletelaborunits,
CASE CostFlag WHEN 'Y' THEN t.expensecost1variance ELSE null END expensecost1variance,
t.expensecostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.expensecostvariance ELSE null END expensecostvariance,
t.finishdate,
t.finishdate1variance,
t.finishdatevariance,
t.iscritical,
CASE CostFlag WHEN 'Y' THEN t.laborcost1variance ELSE null END laborcost1variance,
t.laborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.laborcostvariance ELSE null END laborcostvariance,
t.laborunits1variance,
t.laborunitspercentcomplete,
t.laborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.materialcost1variance ELSE null END materialcost1variance,
t.materialcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.materialcostvariance ELSE null END materialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcost1variance ELSE null END nonlaborcost1variance,
t.nonlaborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcostvariance ELSE null END nonlaborcostvariance,
t.nonlaborunits1variance,
t.nonlaborunitspercentcomplete,
t.nonlaborunitsvariance,
t.percentcomplete,
t.performancepercentcomplete,
t.physicalpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.plannedexpensecost ELSE null END plannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.plannedlaborcost ELSE null END plannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedmaterialcost ELSE null END plannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.plannednonlaborcost ELSE null END plannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedtotalcost ELSE null END plannedtotalcost,
t.plannedtotalunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.plannedvaluelaborunits,
t.primaryresourceid,
t.primaryresourcename,
CASE CostFlag WHEN 'Y' THEN t.remainingexpensecost ELSE null END remainingexpensecost,
t.remainingfloat,
CASE CostFlag WHEN 'Y' THEN t.remaininglaborcost ELSE null END remaininglaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingmaterialcost ELSE null END remainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.remainingnonlaborcost ELSE null END remainingnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingtotalcost ELSE null END remainingtotalcost,
t.remainingtotalunits,
t.schedulepercentcomplete,
t.scheduleperfindexlaborunits,
t.scheduleperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.schedulevariance ELSE null END schedulevariance,
t.schedulevarianceindex,
t.schedulevariancelaborunits,
t.schedulevarindexlaborunits,
t.startdate,
t.startdate1variance,
t.startdatevariance,
t.tocompleteperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.totalcost1variance ELSE null END totalcost1variance,
CASE CostFlag WHEN 'Y' THEN t.totalcostvariance ELSE null END totalcostvariance,
t.unitspercentcomplete,
t.wbscode,
t.wbsname,
t.locationobjectid,
t.locationname,
t.reviewrequired,
t.isstarred,
t.cbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex,
t.ActivityOwnerObjectId,
t.ActivityOwner, ps.rdbmsuserid rpt_user_id 
,RPT_CURRENT_FLAG
FROM ACTIVITY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
-- START BASELINE VIEW of ACTIVITY_U
--METADATA  TYPE:SSCR NAME:BLACTIVITY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITY_U ' and type='V')
  DROP VIEW BLACTIVITY_U 
go

print 'Creating Project-Level View BLACTIVITY_U'
go

     
--METADATA NAME:BLACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITY_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.calendarobjectid,
t.isnewfeedback,
t.autocomputeactuals,
t.percentcompletetype,
t.type,
t.durationtype,
t.reviewstatus,
t.status,
t.id,
t.name,
t.primaryresourceobjectid,
t.totalfloat,
t.freefloat,
t.remainingduration,
t.actuallaborunits,
t.remaininglaborunits,
t.plannedlaborunits,
t.plannedduration,
t.plannednonlaborunits,
t.actualnonlaborunits,
t.remainingnonlaborunits,
t.primaryconstraintdate,
t.actualstartdate,
t.actualfinishdate,
t.latestartdate,
t.latefinishdate,
t.expectedfinishdate,
t.earlystartdate,
t.earlyfinishdate,
t.remainingearlystartdate,
t.remainingearlyfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.reviewfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.primaryconstrainttype,
t.levelingpriority,
t.secondaryconstraintdate,
t.secondaryconstrainttype,
t.floatpath,
t.floatpathorder,
t.actualthisperiodlaborunits,
t.actualthisperiodnonlaborunits,
t.islongestpath,
t.suspenddate,
t.resumedate,
t.externalearlystartdate,
t.externallatefinishdate,
CASE CostFlag WHEN 'Y' THEN t.accountingvariance ELSE null END accountingvariance,
t.accountingvariancelaborunits,
t.actualduration,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodlaborcost ELSE null END actualthisperiodlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodmaterialcost ELSE null END actualthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodnonlaborcost ELSE null END actualthisperiodnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualtotalcost ELSE null END actualtotalcost,
t.actualtotalunits,
t.atcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.atcompletionexpensecost ELSE null END atcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionlaborcost ELSE null END atcompletionlaborcost,
t.atcompletionlaborunits,
t.atcompletionlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.atcompletionmaterialcost ELSE null END atcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionnonlaborcost ELSE null END atcompletionnonlaborcost,
t.atcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletiontotalcost ELSE null END atcompletiontotalcost,
t.atcompletiontotalunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletionvariance ELSE null END atcompletionvariance,
t.baselineduration,
t.baselinefinishdate,
t.baselineplannedduration,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedexpensecost ELSE null END baselineplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedlaborcost ELSE null END baselineplannedlaborcost,
t.baselineplannedlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedmaterialcost ELSE null END baselineplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannednonlaborcost ELSE null END baselineplannednonlaborcost,
t.baselineplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedtotalcost ELSE null END baselineplannedtotalcost,
t.baselinestartdate,
t.baselinelatestartdate,
t.baseline1latestartdate,
t.baselinelatefinishdate,
t.baseline1latefinishdate,
CASE CostFlag WHEN 'Y' THEN t.budgetatcompletion ELSE null END budgetatcompletion,
t.calendarname,
t.costpercentcomplete,
t.costpercentofplanned,
t.costperformanceindex,
t.costperformanceindexlaborunits,
CASE CostFlag WHEN 'Y' THEN t.costvariance ELSE null END costvariance,
t.costvarianceindex,
t.costvarianceindexlaborunits,
t.costvariancelaborunits,
t.datadate,
t.duration1variance,
t.durationpercentcomplete,
t.durationpercentofplanned,
t.durationvariance,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.earnedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimateatcompletioncost ELSE null END estimateatcompletioncost,
t.estimateatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimatetocomplete ELSE null END estimatetocomplete,
t.estimatetocompletelaborunits,
CASE CostFlag WHEN 'Y' THEN t.expensecost1variance ELSE null END expensecost1variance,
t.expensecostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.expensecostvariance ELSE null END expensecostvariance,
t.finishdate,
t.finishdate1variance,
t.finishdatevariance,
t.iscritical,
CASE CostFlag WHEN 'Y' THEN t.laborcost1variance ELSE null END laborcost1variance,
t.laborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.laborcostvariance ELSE null END laborcostvariance,
t.laborunits1variance,
t.laborunitspercentcomplete,
t.laborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.materialcost1variance ELSE null END materialcost1variance,
t.materialcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.materialcostvariance ELSE null END materialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcost1variance ELSE null END nonlaborcost1variance,
t.nonlaborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcostvariance ELSE null END nonlaborcostvariance,
t.nonlaborunits1variance,
t.nonlaborunitspercentcomplete,
t.nonlaborunitsvariance,
t.percentcomplete,
t.performancepercentcomplete,
t.physicalpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.plannedexpensecost ELSE null END plannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.plannedlaborcost ELSE null END plannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedmaterialcost ELSE null END plannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.plannednonlaborcost ELSE null END plannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedtotalcost ELSE null END plannedtotalcost,
t.plannedtotalunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.plannedvaluelaborunits,
t.primaryresourceid,
t.primaryresourcename,
CASE CostFlag WHEN 'Y' THEN t.remainingexpensecost ELSE null END remainingexpensecost,
t.remainingfloat,
CASE CostFlag WHEN 'Y' THEN t.remaininglaborcost ELSE null END remaininglaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingmaterialcost ELSE null END remainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.remainingnonlaborcost ELSE null END remainingnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingtotalcost ELSE null END remainingtotalcost,
t.remainingtotalunits,
t.schedulepercentcomplete,
t.scheduleperfindexlaborunits,
t.scheduleperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.schedulevariance ELSE null END schedulevariance,
t.schedulevarianceindex,
t.schedulevariancelaborunits,
t.schedulevarindexlaborunits,
t.startdate,
t.startdate1variance,
t.startdatevariance,
t.tocompleteperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.totalcost1variance ELSE null END totalcost1variance,
CASE CostFlag WHEN 'Y' THEN t.totalcostvariance ELSE null END totalcostvariance,
t.unitspercentcomplete,
t.wbscode,
t.wbsname,
t.locationobjectid,
t.locationname,
t.reviewrequired,
t.isstarred,
t.cbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex,
t.ActivityOwnerObjectId,
t.ActivityOwner, ps.rdbmsuserid rpt_user_id
FROM BLACTIVITY t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
    
go
     
-- FINISH BASELINE VIEW of ACTIVITY_U
print 'Creating Full View ACTIVITYCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODE_FULL ' and type='V')
  DROP VIEW ACTIVITYCODE_FULL 
go

print 'Creating Full View ACTIVITYCODE_FULL'
go

     
--METADATA NAME:ACTIVITYCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
parentobjectid,
description,
codetypename,
issecurecode,
projectobjectid,
codetypescope,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODE_U ' and type='V')
  DROP VIEW ACTIVITYCODE_U 
go

print 'Creating Project-Level View ACTIVITYCODE_U'
go

     
--METADATA NAME:ACTIVITYCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId 
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.codetypescope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
go
     
-- START BASELINE VIEW of ACTIVITYCODE_U
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODE_U ' and type='V')
  DROP VIEW BLACTIVITYCODE_U 
go

print 'Creating Project-Level View BLACTIVITYCODE_U'
go

     
--METADATA NAME:BLACTIVITYCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM BLACTIVITYCODE t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
     and (ps.ProjectObjectId is not null 
or t.codetypescope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
go
     
-- FINISH BASELINE VIEW of ACTIVITYCODE_U
print 'Creating Full View ACTIVITYCODEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEASSIGNMENT_FULL ' and type='V')
  DROP VIEW ACTIVITYCODEASSIGNMENT_FULL 
go

print 'Creating Full View ACTIVITYCODEASSIGNMENT_FULL'
go

     
--METADATA NAME:ACTIVITYCODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEASSIGNMENT_FULL
AS SELECT 
activityobjectid,
activitycodetypeobjectid,
activitycodeobjectid,
projectobjectid,
activitycodedescription,
activitycodetypename,
activitycodetypescope,
activitycodevalue,
activityid,
activityname,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEASSIGNMENT_U ' and type='V')
  DROP VIEW ACTIVITYCODEASSIGNMENT_U 
go

print 'Creating Project-Level View ACTIVITYCODEASSIGNMENT_U'
go

     
--METADATA NAME:ACTIVITYCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEASSIGNMENT_U
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODEASSIGNMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEASSIGNMENT_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEASSIGNMENT_S ' and type='V')
  DROP VIEW ACTIVITYCODEASSIGNMENT_S 
go

print 'Creating Project-Level View ACTIVITYCODEASSIGNMENT_S'
go

     
--METADATA NAME:ACTIVITYCODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEASSIGNMENT_S
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = gs.RDBMSUserId and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
-- START BASELINE VIEW of ACTIVITYCODEASSIGNMENT_U
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODEASSIGNMENT_U ' and type='V')
  DROP VIEW BLACTIVITYCODEASSIGNMENT_U 
go

print 'Creating Project-Level View BLACTIVITYCODEASSIGNMENT_U'
go

     
--METADATA NAME:BLACTIVITYCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODEASSIGNMENT_U
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM BLACTIVITYCODEASSIGNMENT t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
     and issecurecode='N' 
go
     
-- FINISH BASELINE VIEW of ACTIVITYCODEASSIGNMENT_U
print 'Creating Full View ACTIVITYCODEHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEHIERARCHY_FULL ' and type='V')
  DROP VIEW ACTIVITYCODEHIERARCHY_FULL 
go

print 'Creating Full View ACTIVITYCODEHIERARCHY_FULL'
go

     
--METADATA NAME:ACTIVITYCODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
CodeTypeScope,
CodeTypeProjectId
FROM ACTIVITYCODEHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEHIERARCHY_U ' and type='V')
  DROP VIEW ACTIVITYCODEHIERARCHY_U 
go

print 'Creating Project-Level View ACTIVITYCODEHIERARCHY_U'
go

     
--METADATA NAME:ACTIVITYCODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeScope,
t.CodeTypeProjectId, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODEHIERARCHY t left outer join ProjectSecurity ps on t.CodeTypeProjectId = ps.ProjectObjectId 
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.CodeTypeScope in ('AS_Global','AS_EPS','Global','EPS') ) and CodeTypeIsSecure='N' 
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEHIERARCHY_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEHIERARCHY_S ' and type='V')
  DROP VIEW ACTIVITYCODEHIERARCHY_S 
go

print 'Creating Project-Level View ACTIVITYCODEHIERARCHY_S'
go

     
--METADATA NAME:ACTIVITYCODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeScope,
t.CodeTypeProjectId, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODEHIERARCHY t left outer join ProjectSecurity ps on t.CodeTypeProjectId = ps.ProjectObjectId , GlobalSecurity gs
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.CodeTypeScope in ('AS_Global','AS_EPS','Global','EPS') ) and ps.RDBMSUserId = gs.RDBMSUserId and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
go
     
print 'Creating Full View ACTIVITYCODETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODETYPE_FULL ' and type='V')
  DROP VIEW ACTIVITYCODETYPE_FULL 
go

print 'Creating Full View ACTIVITYCODETYPE_FULL'
go

     
--METADATA NAME:ACTIVITYCODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODETYPE_FULL
AS SELECT 
objectid,
length,
sequencenumber,
name,
scope,
projectobjectid,
epsobjectid,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODETYPE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODETYPE_U ' and type='V')
  DROP VIEW ACTIVITYCODETYPE_U 
go

print 'Creating Project-Level View ACTIVITYCODETYPE_U'
go

     
--METADATA NAME:ACTIVITYCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODETYPE_U
AS SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODETYPE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId 
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.scope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
go
     
-- START BASELINE VIEW of ACTIVITYCODETYPE_U
--METADATA  TYPE:SSCR NAME:BLACTIVITYCODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLACTIVITYCODETYPE_U ' and type='V')
  DROP VIEW BLACTIVITYCODETYPE_U 
go

print 'Creating Project-Level View BLACTIVITYCODETYPE_U'
go

     
--METADATA NAME:BLACTIVITYCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODETYPE_U
AS SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM BLACTIVITYCODETYPE t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
     and (ps.ProjectObjectId is not null 
or t.scope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
go
     
-- FINISH BASELINE VIEW of ACTIVITYCODETYPE_U
print 'Creating Full View ACTIVITYEXPENSE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYEXPENSE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYEXPENSE_FULL ' and type='V')
  DROP VIEW ACTIVITYEXPENSE_FULL 
go

print 'Creating Full View ACTIVITYEXPENSE_FULL'
go

     
--METADATA NAME:ACTIVITYEXPENSE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYEXPENSE_FULL
AS SELECT 
objectid,
projectobjectid,
activityobjectid,
autocomputeactuals,
accrualtype,
costaccountobjectid,
expensecategoryobjectid,
cbsobjectid,
plannedcost,
actualcost,
remainingcost,
unitofmeasure,
plannedunits,
priceperunit,
documentnumber,
vendor,
expenseitem,
expensedescription,
activityid,
activityname,
actualunits,
atcompletioncost,
atcompletionunits,
costaccountid,
costaccountname,
cbscode,
cbsname,
expensecategoryname,
expensepercentcomplete,
overbudget,
projectid,
remainingunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYEXPENSE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYEXPENSE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYEXPENSE_U ' and type='V')
  DROP VIEW ACTIVITYEXPENSE_U 
go

print 'Creating Project-Level View ACTIVITYEXPENSE_U'
go

     
--METADATA NAME:ACTIVITYEXPENSE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYEXPENSE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.activityobjectid,
t.autocomputeactuals,
t.accrualtype,
t.costaccountobjectid,
t.expensecategoryobjectid,
t.cbsobjectid,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
t.unitofmeasure,
t.plannedunits,
CASE CostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
t.documentnumber,
t.vendor,
t.expenseitem,
t.expensedescription,
t.activityid,
t.activityname,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletioncost ELSE null END atcompletioncost,
t.atcompletionunits,
t.costaccountid,
t.costaccountname,
t.cbscode,
t.cbsname,
t.expensecategoryname,
t.expensepercentcomplete,
t.overbudget,
t.projectid,
t.remainingunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYEXPENSE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYNOTE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTE_FULL ' and type='V')
  DROP VIEW ACTIVITYNOTE_FULL 
go

print 'Creating Full View ACTIVITYNOTE_FULL'
go

     
--METADATA NAME:ACTIVITYNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYNOTE_FULL
AS SELECT 
objectid,
activityobjectid,
notebooktopicobjectid,
projectobjectid,
note,
activityid,
activityname,
notebooktopicname,
projectid,
rawtextnote,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYNOTE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTE_U ' and type='V')
  DROP VIEW ACTIVITYNOTE_U 
go

print 'Creating Project-Level View ACTIVITYNOTE_U'
go

     
--METADATA NAME:ACTIVITYNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYNOTE_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.notebooktopicobjectid,
t.projectobjectid,
t.note,
t.activityid,
t.activityname,
t.notebooktopicname,
t.projectid,
t.rawtextnote,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYPERIODACTUAL_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYPERIODACTUAL_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYPERIODACTUAL_FULL ' and type='V')
  DROP VIEW ACTIVITYPERIODACTUAL_FULL 
go

print 'Creating Full View ACTIVITYPERIODACTUAL_FULL'
go

     
--METADATA NAME:ACTIVITYPERIODACTUAL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYPERIODACTUAL_FULL
AS SELECT 
financialperiodobjectid,
startdate,
enddate,
activityobjectid,
projectobjectid,
actuallaborunits,
actuallaborcost,
actualnonlaborunits,
actualnonlaborcost,
actualmaterialcost,
actualexpensecost,
earnedvaluecost,
plannedvaluelaborunits,
plannedvaluecost,
earnedvaluelaborunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYPERIODACTUAL
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYPERIODACTUAL_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYPERIODACTUAL_U ' and type='V')
  DROP VIEW ACTIVITYPERIODACTUAL_U 
go

print 'Creating Project-Level View ACTIVITYPERIODACTUAL_U'
go

     
--METADATA NAME:ACTIVITYPERIODACTUAL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYPERIODACTUAL_U
AS SELECT 
t.financialperiodobjectid,
t.startdate,
t.enddate,
t.activityobjectid,
t.projectobjectid,
t.actuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
t.actualnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.plannedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.earnedvaluelaborunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYPERIODACTUAL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYRISK_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYRISK_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYRISK_FULL ' and type='V')
  DROP VIEW ACTIVITYRISK_FULL 
go

print 'Creating Full View ACTIVITYRISK_FULL'
go

     
--METADATA NAME:ACTIVITYRISK_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYRISK_FULL
AS SELECT 
activityobjectid,
projectobjectid,
riskobjectid,
projectid,
projectname,
activityid,
activityname,
riskname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYRISK
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYRISK_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYRISK_U ' and type='V')
  DROP VIEW ACTIVITYRISK_U 
go

print 'Creating Project-Level View ACTIVITYRISK_U'
go

     
--METADATA NAME:ACTIVITYRISK_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYRISK_U
AS SELECT 
t.activityobjectid,
t.projectobjectid,
t.riskobjectid,
t.projectid,
t.projectname,
t.activityid,
t.activityname,
t.riskname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYRISK t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYSTEP_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEP_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEP_FULL ' and type='V')
  DROP VIEW ACTIVITYSTEP_FULL 
go

print 'Creating Full View ACTIVITYSTEP_FULL'
go

     
--METADATA NAME:ACTIVITYSTEP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEP_FULL
AS SELECT 
objectid,
activityobjectid,
sequencenumber,
projectobjectid,
iscompleted,
name,
weight,
percentcomplete,
description,
activityid,
activityname,
projectid,
wbsobjectid,
weightpercent,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYSTEP
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEP_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEP_U ' and type='V')
  DROP VIEW ACTIVITYSTEP_U 
go

print 'Creating Project-Level View ACTIVITYSTEP_U'
go

     
--METADATA NAME:ACTIVITYSTEP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEP_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.sequencenumber,
t.projectobjectid,
t.iscompleted,
t.name,
t.weight,
t.percentcomplete,
t.description,
t.activityid,
t.activityname,
t.projectid,
t.wbsobjectid,
t.weightpercent,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYSTEP t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View BASELINETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:BASELINETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BASELINETYPE_FULL ' and type='V')
  DROP VIEW BASELINETYPE_FULL 
go

print 'Creating Full View BASELINETYPE_FULL'
go

     
--METADATA NAME:BASELINETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BASELINETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM BASELINETYPE
go
     
print 'Creating Global View BASELINETYPE_U'
go
     
--METADATA  TYPE:SSCR NAME:BASELINETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BASELINETYPE_U ' and type='V')
  DROP VIEW BASELINETYPE_U 
go

print 'Creating Global View BASELINETYPE_U'
go

     
--METADATA NAME:BASELINETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  BASELINETYPE_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM BASELINETYPE
go
     
print 'Creating Full View CALENDAR_FULL'
go
     
--METADATA  TYPE:SSCR NAME:CALENDAR_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CALENDAR_FULL ' and type='V')
  DROP VIEW CALENDAR_FULL 
go

print 'Creating Full View CALENDAR_FULL'
go

     
--METADATA NAME:CALENDAR_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW CALENDAR_FULL
AS SELECT 
objectid,
isdefault,
name,
projectobjectid,
basecalendarobjectid,
lastchangedate,
type,
daydate,
WeekdayNumber,
WorkDayFlag,
TotalWorkHours,
WorkHoursByHalfHour,
WorkDayStartTime,
WorkDayFinishTime,
lastupdatedate
FROM CALENDAR
go
     
--METADATA  TYPE:SSCR NAME:CALENDAR_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CALENDAR_U ' and type='V')
  DROP VIEW CALENDAR_U 
go

print 'Creating Project-Level View CALENDAR_U'
go

     
--METADATA NAME:CALENDAR_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW CALENDAR_U
AS SELECT 
t.objectid,
t.isdefault,
t.name,
t.projectobjectid,
t.basecalendarobjectid,
t.lastchangedate,
t.type,
t.daydate,
t.WeekdayNumber,
t.WorkDayFlag,
t.TotalWorkHours,
t.WorkHoursByHalfHour,
t.WorkDayStartTime,
t.WorkDayFinishTime,
t.lastupdatedate, ps.rdbmsuserid rpt_user_id
FROM CALENDAR t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId 
WHERE 1=1  and ( ps.projectobjectid is not null
or t.projectobjectid is null )
go
     
print 'Creating Full View CHANGESET_FULL'
go
     
--METADATA  TYPE:SSCR NAME:CHANGESET_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHANGESET_FULL ' and type='V')
  DROP VIEW CHANGESET_FULL 
go

print 'Creating Full View CHANGESET_FULL'
go

     
--METADATA NAME:CHANGESET_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW CHANGESET_FULL
AS SELECT 
objectid,
changedate,
requestusername,
requestuserobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CHANGESET
go
     
print 'Creating Global View CHANGESET_U'
go
     
--METADATA  TYPE:SSCR NAME:CHANGESET_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHANGESET_U ' and type='V')
  DROP VIEW CHANGESET_U 
go

print 'Creating Global View CHANGESET_U'
go

     
--METADATA NAME:CHANGESET_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  CHANGESET_U
AS SELECT 
objectid,
changedate,
requestusername,
requestuserobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CHANGESET
go
     
print 'Creating Full View ACTIVITYUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYUPDATE_FULL ' and type='V')
  DROP VIEW ACTIVITYUPDATE_FULL 
go

print 'Creating Full View ACTIVITYUPDATE_FULL'
go

     
--METADATA NAME:ACTIVITYUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYUPDATE_FULL
AS SELECT 
changesetobjectid,
activityobjectid,
projectobjectid,
changedate,
status,
resubmitteddate,
rejecteddate,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
pendingremainingduration,
overrideremainingduration,
pendingpercentcomplete,
overridepercentcomplete,
overrideactuallaborunits,
pendingactuallaborunits,
pendingactualnonlaborunits,
overrideactualnonlaborunits,
overrideremaininglaborunits,
pendingremaininglaborunits,
overrideremainingnonlaborunits,
pendingremainingnonlaborunits,
pendingexpectedfinishdate,
overrideexpectedfinishdate,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
requestusername,
requestuserobjectid
FROM ACTIVITYUPDATE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYUPDATE_U ' and type='V')
  DROP VIEW ACTIVITYUPDATE_U 
go

print 'Creating Project-Level View ACTIVITYUPDATE_U'
go

     
--METADATA NAME:ACTIVITYUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.changedate,
t.status,
t.resubmitteddate,
t.rejecteddate,
t.pendingactualstartdate,
t.overrideactualstartdate,
t.pendingactualfinishdate,
t.overrideactualfinishdate,
t.pendingremainingduration,
t.overrideremainingduration,
t.pendingpercentcomplete,
t.overridepercentcomplete,
t.overrideactuallaborunits,
t.pendingactuallaborunits,
t.pendingactualnonlaborunits,
t.overrideactualnonlaborunits,
t.overrideremaininglaborunits,
t.pendingremaininglaborunits,
t.overrideremainingnonlaborunits,
t.pendingremainingnonlaborunits,
t.pendingexpectedfinishdate,
t.overrideexpectedfinishdate,
t.approvaldate,
t.approvalusername,
t.approvaluserobjectid,
t.helddate,
t.requestusername,
t.requestuserobjectid, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYSTEPUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPUPDATE_FULL ' and type='V')
  DROP VIEW ACTIVITYSTEPUPDATE_FULL 
go

print 'Creating Full View ACTIVITYSTEPUPDATE_FULL'
go

     
--METADATA NAME:ACTIVITYSTEPUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPUPDATE_FULL
AS SELECT 
changesetobjectid,
activitystepobjectid,
status,
resubmitteddate,
rejecteddate,
changedate,
projectobjectid,
activityobjectid,
pendingpercentcomplete,
overridepercentcomplete,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
requestusername,
requestuserobjectid,
pendingstepname,
overridestepname
FROM ACTIVITYSTEPUPDATE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPUPDATE_U ' and type='V')
  DROP VIEW ACTIVITYSTEPUPDATE_U 
go

print 'Creating Project-Level View ACTIVITYSTEPUPDATE_U'
go

     
--METADATA NAME:ACTIVITYSTEPUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activitystepobjectid,
t.status,
t.resubmitteddate,
t.rejecteddate,
t.changedate,
t.projectobjectid,
t.activityobjectid,
t.pendingpercentcomplete,
t.overridepercentcomplete,
t.approvaldate,
t.approvalusername,
t.approvaluserobjectid,
t.helddate,
t.requestusername,
t.requestuserobjectid,
t.pendingstepname,
t.overridestepname, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYSTEPUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYSTEPCREATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPCREATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPCREATE_FULL ' and type='V')
  DROP VIEW ACTIVITYSTEPCREATE_FULL 
go

print 'Creating Full View ACTIVITYSTEPCREATE_FULL'
go

     
--METADATA NAME:ACTIVITYSTEPCREATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPCREATE_FULL
AS SELECT 
activitystepobjectid,
changesetobjectid,
activityobjectid,
projectobjectid,
status,
changedate,
activitystepname,
steppercentcomplete,
stepweight
FROM ACTIVITYSTEPCREATE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPCREATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPCREATE_U ' and type='V')
  DROP VIEW ACTIVITYSTEPCREATE_U 
go

print 'Creating Project-Level View ACTIVITYSTEPCREATE_U'
go

     
--METADATA NAME:ACTIVITYSTEPCREATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPCREATE_U
AS SELECT 
t.activitystepobjectid,
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.status,
t.changedate,
t.activitystepname,
t.steppercentcomplete,
t.stepweight, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYSTEPCREATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYSTEPDEL_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPDEL_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPDEL_FULL ' and type='V')
  DROP VIEW ACTIVITYSTEPDEL_FULL 
go

print 'Creating Full View ACTIVITYSTEPDEL_FULL'
go

     
--METADATA NAME:ACTIVITYSTEPDEL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPDEL_FULL
AS SELECT 
activitystepobjectid,
changesetobjectid,
activityobjectid,
projectobjectid,
changedate,
activitystepname
FROM ACTIVITYSTEPDEL
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYSTEPDEL_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYSTEPDEL_U ' and type='V')
  DROP VIEW ACTIVITYSTEPDEL_U 
go

print 'Creating Project-Level View ACTIVITYSTEPDEL_U'
go

     
--METADATA NAME:ACTIVITYSTEPDEL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYSTEPDEL_U
AS SELECT 
t.activitystepobjectid,
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.changedate,
t.activitystepname, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYSTEPDEL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYCOMMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCOMMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCOMMENT_FULL ' and type='V')
  DROP VIEW ACTIVITYCOMMENT_FULL 
go

print 'Creating Full View ACTIVITYCOMMENT_FULL'
go

     
--METADATA NAME:ACTIVITYCOMMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCOMMENT_FULL
AS SELECT 
commentid,
activityobjectid,
userobjectid,
commentdate,
commenttext
FROM ACTIVITYCOMMENT
go
     
print 'Creating Global View ACTIVITYCOMMENT_U'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCOMMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCOMMENT_U ' and type='V')
  DROP VIEW ACTIVITYCOMMENT_U 
go

print 'Creating Global View ACTIVITYCOMMENT_U'
go

     
--METADATA NAME:ACTIVITYCOMMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ACTIVITYCOMMENT_U
AS SELECT 
commentid,
activityobjectid,
userobjectid,
commentdate,
commenttext
FROM ACTIVITYCOMMENT
go
     
print 'Creating Full View ACTIVITYCODEUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEUPDATE_FULL ' and type='V')
  DROP VIEW ACTIVITYCODEUPDATE_FULL 
go

print 'Creating Full View ACTIVITYCODEUPDATE_FULL'
go

     
--METADATA NAME:ACTIVITYCODEUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEUPDATE_FULL
AS SELECT 
changesetobjectid,
activityobjectid,
activitycodetypeobjectid,
projectobjectid,
approvaluserobjectid,
changedate,
status,
resubmitteddate,
rejecteddate,
overrideactivitycodeid,
pendingactivitycodeid,
requestuserobjectid,
approvalusername,
approvaldate,
helddate
FROM ACTIVITYCODEUPDATE
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYCODEUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODEUPDATE_U ' and type='V')
  DROP VIEW ACTIVITYCODEUPDATE_U 
go

print 'Creating Project-Level View ACTIVITYCODEUPDATE_U'
go

     
--METADATA NAME:ACTIVITYCODEUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODEUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activityobjectid,
t.activitycodetypeobjectid,
t.projectobjectid,
t.approvaluserobjectid,
t.changedate,
t.status,
t.resubmitteddate,
t.rejecteddate,
t.overrideactivitycodeid,
t.pendingactivitycodeid,
t.requestuserobjectid,
t.approvalusername,
t.approvaldate,
t.helddate, ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODEUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ACTIVITYNOTEUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTEUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTEUPDATE_FULL ' and type='V')
  DROP VIEW ACTIVITYNOTEUPDATE_FULL 
go

print 'Creating Full View ACTIVITYNOTEUPDATE_FULL'
go

     
--METADATA NAME:ACTIVITYNOTEUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYNOTEUPDATE_FULL
AS SELECT 
changesetobjectid,
activityobjectid,
activitynoteobjectid,
changedate,
status,
requestusername,
requestuserobjectid
FROM ACTIVITYNOTEUPDATE
go
     
print 'Creating Global View ACTIVITYNOTEUPDATE_U'
go
     
--METADATA  TYPE:SSCR NAME:ACTIVITYNOTEUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYNOTEUPDATE_U ' and type='V')
  DROP VIEW ACTIVITYNOTEUPDATE_U 
go

print 'Creating Global View ACTIVITYNOTEUPDATE_U'
go

     
--METADATA NAME:ACTIVITYNOTEUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ACTIVITYNOTEUPDATE_U
AS SELECT 
changesetobjectid,
activityobjectid,
activitynoteobjectid,
changedate,
status,
requestusername,
requestuserobjectid
FROM ACTIVITYNOTEUPDATE
go
     
print 'Creating Full View USERDEFINEDVALUEUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:USERDEFINEDVALUEUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERDEFINEDVALUEUPDATE_FULL ' and type='V')
  DROP VIEW USERDEFINEDVALUEUPDATE_FULL 
go

print 'Creating Full View USERDEFINEDVALUEUPDATE_FULL'
go

     
--METADATA NAME:USERDEFINEDVALUEUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USERDEFINEDVALUEUPDATE_FULL
AS SELECT 
changesetobjectid,
udftypeobjectid,
foreignobjectid,
changedate,
projectobjectid,
status,
resubmitteddate,
rejecteddate,
overrideudftext,
pendingudftext,
overrideudfstartdate,
pendingudfstartdate,
overrideudfenddate,
pendingudfenddate,
overrideudfcodeid,
pendingudfcodeid,
overrideudfnumber,
pendingudfnumber,
overrideudfinteger,
pendingudfinteger,
overrideudfcost,
pendingudfcost,
requestuserobjectid,
approvaluserobjectid,
approvalusername,
approvaldate,
helddate
FROM USERDEFINEDVALUEUPDATE
go
     
--METADATA  TYPE:SSCR NAME:USERDEFINEDVALUEUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERDEFINEDVALUEUPDATE_U ' and type='V')
  DROP VIEW USERDEFINEDVALUEUPDATE_U 
go

print 'Creating Project-Level View USERDEFINEDVALUEUPDATE_U'
go

     
--METADATA NAME:USERDEFINEDVALUEUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USERDEFINEDVALUEUPDATE_U
AS SELECT 
t.changesetobjectid,
t.udftypeobjectid,
t.foreignobjectid,
t.changedate,
t.projectobjectid,
t.status,
t.resubmitteddate,
t.rejecteddate,
t.overrideudftext,
t.pendingudftext,
t.overrideudfstartdate,
t.pendingudfstartdate,
t.overrideudfenddate,
t.pendingudfenddate,
t.overrideudfcodeid,
t.pendingudfcodeid,
t.overrideudfnumber,
t.pendingudfnumber,
t.overrideudfinteger,
t.pendingudfinteger,
t.overrideudfcost,
t.pendingudfcost,
t.requestuserobjectid,
t.approvaluserobjectid,
t.approvalusername,
t.approvaldate,
t.helddate, ps.rdbmsuserid rpt_user_id
FROM USERDEFINEDVALUEUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RESOURCEASSIGNMENTUPDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTUPDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTUPDATE_FULL ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTUPDATE_FULL 
go

print 'Creating Full View RESOURCEASSIGNMENTUPDATE_FULL'
go

     
--METADATA NAME:RESOURCEASSIGNMENTUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENTUPDATE_FULL
AS SELECT 
changesetobjectid,
resourceassignmentobjectid,
activityobjectid,
changedate,
status,
resubmitteddate,
rejecteddate,
projectobjectid,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
overrideactualunits,
pendingactualunits,
overrideremainingunits,
pendingremainingunits,
pendingremainingduration,
overrideremainingduration,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
pendingremainingfinishdate,
overrideremainingfinishdate,
requestusername,
requestuserobjectid
FROM RESOURCEASSIGNMENTUPDATE
go
     
print 'Creating Global View RESOURCEASSIGNMENTUPDATE_U'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENTUPDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENTUPDATE_U ' and type='V')
  DROP VIEW RESOURCEASSIGNMENTUPDATE_U 
go

print 'Creating Global View RESOURCEASSIGNMENTUPDATE_U'
go

     
--METADATA NAME:RESOURCEASSIGNMENTUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RESOURCEASSIGNMENTUPDATE_U
AS SELECT 
changesetobjectid,
resourceassignmentobjectid,
activityobjectid,
changedate,
status,
resubmitteddate,
rejecteddate,
projectobjectid,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
overrideactualunits,
pendingactualunits,
overrideremainingunits,
pendingremainingunits,
pendingremainingduration,
overrideremainingduration,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
pendingremainingfinishdate,
overrideremainingfinishdate,
requestusername,
requestuserobjectid
FROM RESOURCEASSIGNMENTUPDATE
go
     
print 'Creating Full View COSTACCOUNT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNT_FULL ' and type='V')
  DROP VIEW COSTACCOUNT_FULL 
go

print 'Creating Full View COSTACCOUNT_FULL'
go

     
--METADATA NAME:COSTACCOUNT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW COSTACCOUNT_FULL
AS SELECT 
objectid,
sequencenumber,
id,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM COSTACCOUNT
go
     
print 'Creating Global View COSTACCOUNT_U'
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNT_U ' and type='V')
  DROP VIEW COSTACCOUNT_U 
go

print 'Creating Global View COSTACCOUNT_U'
go

     
--METADATA NAME:COSTACCOUNT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  COSTACCOUNT_U
AS SELECT 
objectid,
sequencenumber,
id,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM COSTACCOUNT
go
     
print 'Creating Full View COSTACCOUNTHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNTHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNTHIERARCHY_FULL ' and type='V')
  DROP VIEW COSTACCOUNTHIERARCHY_FULL 
go

print 'Creating Full View COSTACCOUNTHIERARCHY_FULL'
go

     
--METADATA NAME:COSTACCOUNTHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW COSTACCOUNTHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM COSTACCOUNTHIERARCHY
go
     
print 'Creating Global View COSTACCOUNTHIERARCHY_U'
go
     
--METADATA  TYPE:SSCR NAME:COSTACCOUNTHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTACCOUNTHIERARCHY_U ' and type='V')
  DROP VIEW COSTACCOUNTHIERARCHY_U 
go

print 'Creating Global View COSTACCOUNTHIERARCHY_U'
go

     
--METADATA NAME:COSTACCOUNTHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  COSTACCOUNTHIERARCHY_U
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM COSTACCOUNTHIERARCHY
go
     
print 'Creating Full View COSTSECURITY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:COSTSECURITY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTSECURITY_FULL ' and type='V')
  DROP VIEW COSTSECURITY_FULL 
go

print 'Creating Full View COSTSECURITY_FULL'
go

     
--METADATA NAME:COSTSECURITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW COSTSECURITY_FULL
AS SELECT 
PROJECTOBJECTID,
WHOLEPROJECTFLAG
FROM COSTSECURITY
go
     
print 'Creating Global View COSTSECURITY_U'
go
     
--METADATA  TYPE:SSCR NAME:COSTSECURITY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COSTSECURITY_U ' and type='V')
  DROP VIEW COSTSECURITY_U 
go

print 'Creating Global View COSTSECURITY_U'
go

     
--METADATA NAME:COSTSECURITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  COSTSECURITY_U
AS SELECT 
PROJECTOBJECTID,
WHOLEPROJECTFLAG
FROM COSTSECURITY
go
     
print 'Creating Full View CURRENCY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:CURRENCY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CURRENCY_FULL ' and type='V')
  DROP VIEW CURRENCY_FULL 
go

print 'Creating Full View CURRENCY_FULL'
go

     
--METADATA NAME:CURRENCY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW CURRENCY_FULL
AS SELECT 
objectid,
decimalplaces,
symbol,
decimalsymbol,
digitgroupingsymbol,
positivesymbol,
negativesymbol,
name,
id,
exchangerate,
isbasecurrency,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CURRENCY
go
     
print 'Creating Global View CURRENCY_U'
go
     
--METADATA  TYPE:SSCR NAME:CURRENCY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CURRENCY_U ' and type='V')
  DROP VIEW CURRENCY_U 
go

print 'Creating Global View CURRENCY_U'
go

     
--METADATA NAME:CURRENCY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  CURRENCY_U
AS SELECT 
objectid,
decimalplaces,
symbol,
decimalsymbol,
digitgroupingsymbol,
positivesymbol,
negativesymbol,
name,
id,
exchangerate,
isbasecurrency,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CURRENCY
go
     
print 'Creating Full View DOCUMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENT_FULL ' and type='V')
  DROP VIEW DOCUMENT_FULL 
go

print 'Creating Full View DOCUMENT_FULL'
go

     
--METADATA NAME:DOCUMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENT_FULL
AS SELECT 
objectid,
sequencenumber,
deliverable,
title,
parentobjectid,
projectobjectid,
documentstatuscodeobjectid,
documentcategoryobjectid,
revisiondate,
version,
referencenumber,
author,
privatelocation,
publiclocation,
resourceobjectid,
documenttype,
documentcategoryname,
documentstatuscodename,
projectid,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENT
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENT_U ' and type='V')
  DROP VIEW DOCUMENT_U 
go

print 'Creating Project-Level View DOCUMENT_U'
go

     
--METADATA NAME:DOCUMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENT_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.deliverable,
t.title,
t.parentobjectid,
t.projectobjectid,
t.documentstatuscodeobjectid,
t.documentcategoryobjectid,
t.revisiondate,
t.version,
t.referencenumber,
t.author,
t.privatelocation,
t.publiclocation,
t.resourceobjectid,
t.documenttype,
t.documentcategoryname,
t.documentstatuscodename,
t.projectid,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM DOCUMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View DOCUMENTCATEGORY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTCATEGORY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTCATEGORY_FULL ' and type='V')
  DROP VIEW DOCUMENTCATEGORY_FULL 
go

print 'Creating Full View DOCUMENTCATEGORY_FULL'
go

     
--METADATA NAME:DOCUMENTCATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENTCATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTCATEGORY
go
     
print 'Creating Global View DOCUMENTCATEGORY_U'
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTCATEGORY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTCATEGORY_U ' and type='V')
  DROP VIEW DOCUMENTCATEGORY_U 
go

print 'Creating Global View DOCUMENTCATEGORY_U'
go

     
--METADATA NAME:DOCUMENTCATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  DOCUMENTCATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTCATEGORY
go
     
print 'Creating Full View DOCUMENTSTATUSCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTSTATUSCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTSTATUSCODE_FULL ' and type='V')
  DROP VIEW DOCUMENTSTATUSCODE_FULL 
go

print 'Creating Full View DOCUMENTSTATUSCODE_FULL'
go

     
--METADATA NAME:DOCUMENTSTATUSCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW DOCUMENTSTATUSCODE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTSTATUSCODE
go
     
print 'Creating Global View DOCUMENTSTATUSCODE_U'
go
     
--METADATA  TYPE:SSCR NAME:DOCUMENTSTATUSCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DOCUMENTSTATUSCODE_U ' and type='V')
  DROP VIEW DOCUMENTSTATUSCODE_U 
go

print 'Creating Global View DOCUMENTSTATUSCODE_U'
go

     
--METADATA NAME:DOCUMENTSTATUSCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  DOCUMENTSTATUSCODE_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTSTATUSCODE
go
     
print 'Creating Full View EPS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPS_FULL ' and type='V')
  DROP VIEW EPS_FULL 
go

print 'Creating Full View EPS_FULL'
go

     
--METADATA NAME:EPS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPS_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
sequencenumber,
name,
parentobjectid,
originalbudget,
independentetctotalcost,
independentetclaborunits,
anticipatedstartdate,
anticipatedfinishdate,
currentbudget,
currentvariance,
distributedcurrentbudget,
finishdate,
fullname,
id,
lastsummarizeddate,
obsname,
plannedstartdate,
proposedbudget,
startdate,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
totalbenefitplan,
totalbenefitplantally,
totalfunding,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
undistributedcurrentvariance,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex
FROM EPS
go
     
--METADATA  TYPE:SSCR NAME:EPS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPS_U ' and type='V')
  DROP VIEW EPS_U 
go

print 'Creating Project-Level View EPS_U'
go

     
--METADATA NAME:EPS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.name,
t.parentobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.fullname,
t.id,
t.lastsummarizeddate,
t.obsname,
t.plannedstartdate,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id
FROM EPS t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSBUDGETCHANGELOG_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSBUDGETCHANGELOG_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSBUDGETCHANGELOG_FULL ' and type='V')
  DROP VIEW EPSBUDGETCHANGELOG_FULL 
go

print 'Creating Full View EPSBUDGETCHANGELOG_FULL'
go

     
--METADATA NAME:EPSBUDGETCHANGELOG_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSBUDGETCHANGELOG_FULL
AS SELECT 
objectid,
projectobjectid,
epsobjectid,
epsbudgetchangelogdate,
changenumber,
amount,
responsible,
status,
reason,
epsid,
epsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSBUDGETCHANGELOG
go
     
--METADATA  TYPE:SSCR NAME:EPSBUDGETCHANGELOG_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSBUDGETCHANGELOG_U ' and type='V')
  DROP VIEW EPSBUDGETCHANGELOG_U 
go

print 'Creating Project-Level View EPSBUDGETCHANGELOG_U'
go

     
--METADATA NAME:EPSBUDGETCHANGELOG_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSBUDGETCHANGELOG_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.epsobjectid,
t.epsbudgetchangelogdate,
t.changenumber,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.responsible,
t.status,
t.reason,
t.epsid,
t.epsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM EPSBUDGETCHANGELOG t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSFUNDING_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSFUNDING_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSFUNDING_FULL ' and type='V')
  DROP VIEW EPSFUNDING_FULL 
go

print 'Creating Full View EPSFUNDING_FULL'
go

     
--METADATA NAME:EPSFUNDING_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSFUNDING_FULL
AS SELECT 
objectid,
fundingsourceobjectid,
projectobjectid,
amount,
fundshare,
epsid,
epsname,
epsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSFUNDING
go
     
--METADATA  TYPE:SSCR NAME:EPSFUNDING_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSFUNDING_U ' and type='V')
  DROP VIEW EPSFUNDING_U 
go

print 'Creating Project-Level View EPSFUNDING_U'
go

     
--METADATA NAME:EPSFUNDING_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSFUNDING_U
AS SELECT 
t.objectid,
t.fundingsourceobjectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.fundshare,
t.epsid,
t.epsname,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM EPSFUNDING t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSHIERARCHY_FULL ' and type='V')
  DROP VIEW EPSHIERARCHY_FULL 
go

print 'Creating Full View EPSHIERARCHY_FULL'
go

     
--METADATA NAME:EPSHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentProjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildProjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM EPSHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:EPSHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSHIERARCHY_U ' and type='V')
  DROP VIEW EPSHIERARCHY_U 
go

print 'Creating Project-Level View EPSHIERARCHY_U'
go

     
--METADATA NAME:EPSHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentProjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildProjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate, ps.rdbmsuserid rpt_user_id
FROM EPSHIERARCHY t, ProjectSecurity ps
WHERE 1=1  and t.ParentProjectId = ps.ProjectObjectId 
go
     
print 'Creating Full View WBSHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:WBSHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSHIERARCHY_FULL ' and type='V')
  DROP VIEW WBSHIERARCHY_FULL 
go

print 'Creating Full View WBSHIERARCHY_FULL'
go

     
--METADATA NAME:WBSHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentProjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildProjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM WBSHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:WBSHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSHIERARCHY_U ' and type='V')
  DROP VIEW WBSHIERARCHY_U 
go

print 'Creating Project-Level View WBSHIERARCHY_U'
go

     
--METADATA NAME:WBSHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentProjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildProjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate, ps.rdbmsuserid rpt_user_id
FROM WBSHIERARCHY t, ProjectSecurity ps
WHERE 1=1  and t.ParentProjectId = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSNOTE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSNOTE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSNOTE_FULL ' and type='V')
  DROP VIEW EPSNOTE_FULL 
go

print 'Creating Full View EPSNOTE_FULL'
go

     
--METADATA NAME:EPSNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSNOTE_FULL
AS SELECT 
objectid,
projectobjectid,
notebooktopicobjectid,
note,
epsid,
epsname,
epsobjectid,
notebooktopicname,
rawtextnote,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSNOTE
go
     
--METADATA  TYPE:SSCR NAME:EPSNOTE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSNOTE_U ' and type='V')
  DROP VIEW EPSNOTE_U 
go

print 'Creating Project-Level View EPSNOTE_U'
go

     
--METADATA NAME:EPSNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSNOTE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.notebooktopicobjectid,
t.note,
t.epsid,
t.epsname,
t.epsobjectid,
t.notebooktopicname,
t.rawtextnote,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM EPSNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSSPENDINGPLAN_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSSPENDINGPLAN_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPENDINGPLAN_FULL ' and type='V')
  DROP VIEW EPSSPENDINGPLAN_FULL 
go

print 'Creating Full View EPSSPENDINGPLAN_FULL'
go

     
--METADATA NAME:EPSSPENDINGPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPENDINGPLAN_FULL
AS SELECT 
objectid,
projectobjectid,
spendingplan,
benefitplan,
spendingplandate,
epsid,
epsname,
epsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSSPENDINGPLAN
go
     
--METADATA  TYPE:SSCR NAME:EPSSPENDINGPLAN_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPENDINGPLAN_U ' and type='V')
  DROP VIEW EPSSPENDINGPLAN_U 
go

print 'Creating Project-Level View EPSSPENDINGPLAN_U'
go

     
--METADATA NAME:EPSSPENDINGPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPENDINGPLAN_U
AS SELECT 
t.objectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.spendingplan ELSE null END spendingplan,
CASE CostFlag WHEN 'Y' THEN t.benefitplan ELSE null END benefitplan,
t.spendingplandate,
t.epsid,
t.epsname,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM EPSSPENDINGPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EPSSPREAD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EPSSPREAD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPREAD_FULL ' and type='V')
  DROP VIEW EPSSPREAD_FULL 
go

print 'Creating Full View EPSSPREAD_FULL'
go

     
--METADATA NAME:EPSSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPREAD_FULL
AS SELECT 
ObjectId,
Id,
Name,
ParentObjectId,
projectobjectid,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM EPSSPREAD
go
     
--METADATA  TYPE:SSCR NAME:EPSSPREAD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EPSSPREAD_U ' and type='V')
  DROP VIEW EPSSPREAD_U 
go

print 'Creating Project-Level View EPSSPREAD_U'
go

     
--METADATA NAME:EPSSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EPSSPREAD_U
AS SELECT 
t.ObjectId,
t.Id,
t.Name,
t.ParentObjectId,
t.projectobjectid,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost, ps.rdbmsuserid rpt_user_id
FROM EPSSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View EXPENSECATEGORY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:EXPENSECATEGORY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EXPENSECATEGORY_FULL ' and type='V')
  DROP VIEW EXPENSECATEGORY_FULL 
go

print 'Creating Full View EXPENSECATEGORY_FULL'
go

     
--METADATA NAME:EXPENSECATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW EXPENSECATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EXPENSECATEGORY
go
     
print 'Creating Global View EXPENSECATEGORY_U'
go
     
--METADATA  TYPE:SSCR NAME:EXPENSECATEGORY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'EXPENSECATEGORY_U ' and type='V')
  DROP VIEW EXPENSECATEGORY_U 
go

print 'Creating Global View EXPENSECATEGORY_U'
go

     
--METADATA NAME:EXPENSECATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  EXPENSECATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EXPENSECATEGORY
go
     
print 'Creating Full View FINANCIALPERIOD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:FINANCIALPERIOD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FINANCIALPERIOD_FULL ' and type='V')
  DROP VIEW FINANCIALPERIOD_FULL 
go

print 'Creating Full View FINANCIALPERIOD_FULL'
go

     
--METADATA NAME:FINANCIALPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW FINANCIALPERIOD_FULL
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FINANCIALPERIOD
go
     
print 'Creating Global View FINANCIALPERIOD_U'
go
     
--METADATA  TYPE:SSCR NAME:FINANCIALPERIOD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FINANCIALPERIOD_U ' and type='V')
  DROP VIEW FINANCIALPERIOD_U 
go

print 'Creating Global View FINANCIALPERIOD_U'
go

     
--METADATA NAME:FINANCIALPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  FINANCIALPERIOD_U
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FINANCIALPERIOD
go
     
print 'Creating Full View FUNDINGSOURCE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:FUNDINGSOURCE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FUNDINGSOURCE_FULL ' and type='V')
  DROP VIEW FUNDINGSOURCE_FULL 
go

print 'Creating Full View FUNDINGSOURCE_FULL'
go

     
--METADATA NAME:FUNDINGSOURCE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW FUNDINGSOURCE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FUNDINGSOURCE
go
     
print 'Creating Global View FUNDINGSOURCE_U'
go
     
--METADATA  TYPE:SSCR NAME:FUNDINGSOURCE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'FUNDINGSOURCE_U ' and type='V')
  DROP VIEW FUNDINGSOURCE_U 
go

print 'Creating Global View FUNDINGSOURCE_U'
go

     
--METADATA NAME:FUNDINGSOURCE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  FUNDINGSOURCE_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FUNDINGSOURCE
go
     
print 'Creating Full View GLOBALPROFILE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:GLOBALPROFILE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBALPROFILE_FULL ' and type='V')
  DROP VIEW GLOBALPROFILE_FULL 
go

print 'Creating Full View GLOBALPROFILE_FULL'
go

     
--METADATA NAME:GLOBALPROFILE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW GLOBALPROFILE_FULL
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM GLOBALPROFILE
go
     
print 'Creating Global View GLOBALPROFILE_U'
go
     
--METADATA  TYPE:SSCR NAME:GLOBALPROFILE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBALPROFILE_U ' and type='V')
  DROP VIEW GLOBALPROFILE_U 
go

print 'Creating Global View GLOBALPROFILE_U'
go

     
--METADATA NAME:GLOBALPROFILE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  GLOBALPROFILE_U
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM GLOBALPROFILE
go
     
print 'Creating Full View ISSUEHISTORY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ISSUEHISTORY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ISSUEHISTORY_FULL ' and type='V')
  DROP VIEW ISSUEHISTORY_FULL 
go

print 'Creating Full View ISSUEHISTORY_FULL'
go

     
--METADATA NAME:ISSUEHISTORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ISSUEHISTORY_FULL
AS SELECT 
projectissueobjectid,
projectobjectid,
notes,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ISSUEHISTORY
go
     
--METADATA  TYPE:SSCR NAME:ISSUEHISTORY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ISSUEHISTORY_U ' and type='V')
  DROP VIEW ISSUEHISTORY_U 
go

print 'Creating Project-Level View ISSUEHISTORY_U'
go

     
--METADATA NAME:ISSUEHISTORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ISSUEHISTORY_U
AS SELECT 
t.projectissueobjectid,
t.projectobjectid,
t.notes,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM ISSUEHISTORY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View ITERATION_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ITERATION_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATION_FULL ' and type='V')
  DROP VIEW ITERATION_FULL 
go

print 'Creating Full View ITERATION_FULL'
go

     
--METADATA NAME:ITERATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ITERATION_FULL
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATION
go
     
print 'Creating Global View ITERATION_U'
go
     
--METADATA  TYPE:SSCR NAME:ITERATION_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATION_U ' and type='V')
  DROP VIEW ITERATION_U 
go

print 'Creating Global View ITERATION_U'
go

     
--METADATA NAME:ITERATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ITERATION_U
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATION
go
     
print 'Creating Full View ITERATIONACTIVITY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONACTIVITY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONACTIVITY_FULL ' and type='V')
  DROP VIEW ITERATIONACTIVITY_FULL 
go

print 'Creating Full View ITERATIONACTIVITY_FULL'
go

     
--METADATA NAME:ITERATIONACTIVITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ITERATIONACTIVITY_FULL
AS SELECT 
iterationobjectid,
activityobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONACTIVITY
go
     
print 'Creating Global View ITERATIONACTIVITY_U'
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONACTIVITY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONACTIVITY_U ' and type='V')
  DROP VIEW ITERATIONACTIVITY_U 
go

print 'Creating Global View ITERATIONACTIVITY_U'
go

     
--METADATA NAME:ITERATIONACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ITERATIONACTIVITY_U
AS SELECT 
iterationobjectid,
activityobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONACTIVITY
go
     
print 'Creating Full View ITERATIONTEAM_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONTEAM_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONTEAM_FULL ' and type='V')
  DROP VIEW ITERATIONTEAM_FULL 
go

print 'Creating Full View ITERATIONTEAM_FULL'
go

     
--METADATA NAME:ITERATIONTEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ITERATIONTEAM_FULL
AS SELECT 
iterationobjectid,
resourceteamobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONTEAM
go
     
print 'Creating Global View ITERATIONTEAM_U'
go
     
--METADATA  TYPE:SSCR NAME:ITERATIONTEAM_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ITERATIONTEAM_U ' and type='V')
  DROP VIEW ITERATIONTEAM_U 
go

print 'Creating Global View ITERATIONTEAM_U'
go

     
--METADATA NAME:ITERATIONTEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ITERATIONTEAM_U
AS SELECT 
iterationobjectid,
resourceteamobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONTEAM
go
     
print 'Creating Full View LOCATION_FULL'
go
     
--METADATA  TYPE:SSCR NAME:LOCATION_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'LOCATION_FULL ' and type='V')
  DROP VIEW LOCATION_FULL 
go

print 'Creating Full View LOCATION_FULL'
go

     
--METADATA NAME:LOCATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW LOCATION_FULL
AS SELECT 
objectid,
locationname,
locationtype,
addressline1,
addressline2,
addressline3,
city,
municipality,
state,
statecode,
country,
countrycode,
postalcode,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM LOCATION
go
     
print 'Creating Global View LOCATION_U'
go
     
--METADATA  TYPE:SSCR NAME:LOCATION_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'LOCATION_U ' and type='V')
  DROP VIEW LOCATION_U 
go

print 'Creating Global View LOCATION_U'
go

     
--METADATA NAME:LOCATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  LOCATION_U
AS SELECT 
objectid,
locationname,
locationtype,
addressline1,
addressline2,
addressline3,
city,
municipality,
state,
statecode,
country,
countrycode,
postalcode,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM LOCATION
go
     
print 'Creating Full View NOTEBOOKTOPIC_FULL'
go
     
--METADATA  TYPE:SSCR NAME:NOTEBOOKTOPIC_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'NOTEBOOKTOPIC_FULL ' and type='V')
  DROP VIEW NOTEBOOKTOPIC_FULL 
go

print 'Creating Full View NOTEBOOKTOPIC_FULL'
go

     
--METADATA NAME:NOTEBOOKTOPIC_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW NOTEBOOKTOPIC_FULL
AS SELECT 
objectid,
sequencenumber,
availableforeps,
availableforproject,
availableforwbs,
availableforactivity,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM NOTEBOOKTOPIC
go
     
print 'Creating Global View NOTEBOOKTOPIC_U'
go
     
--METADATA  TYPE:SSCR NAME:NOTEBOOKTOPIC_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'NOTEBOOKTOPIC_U ' and type='V')
  DROP VIEW NOTEBOOKTOPIC_U 
go

print 'Creating Global View NOTEBOOKTOPIC_U'
go

     
--METADATA NAME:NOTEBOOKTOPIC_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  NOTEBOOKTOPIC_U
AS SELECT 
objectid,
sequencenumber,
availableforeps,
availableforproject,
availableforwbs,
availableforactivity,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM NOTEBOOKTOPIC
go
     
print 'Creating Full View OBS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:OBS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBS_FULL ' and type='V')
  DROP VIEW OBS_FULL 
go

print 'Creating Full View OBS_FULL'
go

     
--METADATA NAME:OBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW OBS_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OBS
go
     
print 'Creating Global View OBS_U'
go
     
--METADATA  TYPE:SSCR NAME:OBS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBS_U ' and type='V')
  DROP VIEW OBS_U 
go

print 'Creating Global View OBS_U'
go

     
--METADATA NAME:OBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  OBS_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OBS
go
     
print 'Creating Full View OVERHEADCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:OVERHEADCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OVERHEADCODE_FULL ' and type='V')
  DROP VIEW OVERHEADCODE_FULL 
go

print 'Creating Full View OVERHEADCODE_FULL'
go

     
--METADATA NAME:OVERHEADCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW OVERHEADCODE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OVERHEADCODE
go
     
print 'Creating Global View OVERHEADCODE_U'
go
     
--METADATA  TYPE:SSCR NAME:OVERHEADCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OVERHEADCODE_U ' and type='V')
  DROP VIEW OVERHEADCODE_U 
go

print 'Creating Global View OVERHEADCODE_U'
go

     
--METADATA NAME:OVERHEADCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  OVERHEADCODE_U
AS SELECT 
objectid,
sequencenumber,
name,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OVERHEADCODE
go
     
print 'Creating Full View PROJECT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_FULL ' and type='V')
  DROP VIEW PROJECT_FULL 
go

print 'Creating Full View PROJECT_FULL'
go

     
--METADATA NAME:PROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECT_FULL
AS SELECT 
objectid,
id,
fiscalyearstartmonth,
resourcescaneditasgnmtpctcmp,
resourcescanselfassigntoacts,
primaryrescanmarkactsascmp,
resourcecanassigntosameact,
checkoutstatus,
activitypctcmpbasedonsteps,
costquantityrecalculateflag,
containssummarydataonly,
enablesummarization,
wbscodeseparator,
activitydefaultpctcmptype,
activitydefcostacctobjectid,
activitydefcalendarobjectid,
currentbaselineprojectobjectid,
activityidsuffix,
activityidincrement,
levelingpriority,
summarizetowbslevel,
strategicpriority,
criticalactivityfloatlimit,
activitydefaultpriceperunit,
plannedstartdate,
mustfinishbydate,
scheduledfinishdate,
dateadded,
summarizeddatadate,
lastsummarizeddate,
projectforecaststartdate,
activitydefaultdurationtype,
activityidprefix,
defaultpricetimeunits,
addedby,
websiterootdirectory,
websiteurl,
assignmentdefaultratetype,
linkactualtoactualthisperiod,
activitydefaultactivitytype,
linkpercentcompletewithactual,
addactualtoremaining,
criticalactivitypathtype,
activityidbasedonselactivity,
assignmentdefaultdrivingflag,
linkplannedandatcompletionflag,
resetplannedtoremainingflag,
allownegativeactualunitsflag,
ownerresourceobjectid,
checkoutdate,
checkoutuserobjectid,
lastfinancialperiodobjectid,
useprojectblforearnedvalue,
annualdiscountrate,
anticipatedfinishdate,
anticipatedstartdate,
containssummarydata,
currentbudget,
currentvariance,
datadate,
discountapplicationperiod,
distributedcurrentbudget,
earnedvaluecomputetype,
earnedvalueetccomputetype,
earnedvalueetcuservalue,
earnedvalueuserpercent,
finishdate,
forecastfinishdate,
forecaststartdate,
independentetclaborunits,
independentetctotalcost,
name,
obsname,
obsobjectid,
originalbudget,
overallprojectscore,
parentepsobjectid,
proposedbudget,
risklevel,
riskscore,
riskexposure,
startdate,
status,
originalprojectobjectid,
riskscorematrixobjectid,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
summaxactualfinishdate,
summaxrestartdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
sumearlystartdate,
sumearlyenddate,
sumlatestartdate,
sumlateenddate,
summaxcalendarid,
summincalendarid,
totalbenefitplan,
totalbenefitplantally,
totalfunding,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
NetPresentValue,
ReturnOnInvestment,
PaybackPeriod,
undistributedcurrentvariance,
projectdescription,
baselinetypeobjectid,
enablepublication,
nextpublicationdate,
lastpublishedon,
publicationpriority,
locationobjectid,
historyinterval,
historylevel,
locationname,
allowstatusreview,
lastupdateuser,
lastupdatedate,
createuser,
etlinterval,
etlhour,
createdate,
lastupdatedatex
FROM PROJECT
go
     
--METADATA  TYPE:SSCR NAME:PROJECT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_U ' and type='V')
  DROP VIEW PROJECT_U 
go

print 'Creating Project-Level View PROJECT_U'
go

     
--METADATA NAME:PROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECT_U
AS SELECT 
t.objectid,
t.id,
t.fiscalyearstartmonth,
t.resourcescaneditasgnmtpctcmp,
t.resourcescanselfassigntoacts,
t.primaryrescanmarkactsascmp,
t.resourcecanassigntosameact,
t.checkoutstatus,
t.activitypctcmpbasedonsteps,
t.costquantityrecalculateflag,
t.containssummarydataonly,
t.enablesummarization,
t.wbscodeseparator,
t.activitydefaultpctcmptype,
t.activitydefcostacctobjectid,
t.activitydefcalendarobjectid,
t.currentbaselineprojectobjectid,
t.activityidsuffix,
t.activityidincrement,
t.levelingpriority,
t.summarizetowbslevel,
t.strategicpriority,
t.criticalactivityfloatlimit,
CASE CostFlag WHEN 'Y' THEN t.activitydefaultpriceperunit ELSE null END activitydefaultpriceperunit,
t.plannedstartdate,
t.mustfinishbydate,
t.scheduledfinishdate,
t.dateadded,
t.summarizeddatadate,
t.lastsummarizeddate,
t.projectforecaststartdate,
t.activitydefaultdurationtype,
t.activityidprefix,
t.defaultpricetimeunits,
t.addedby,
t.websiterootdirectory,
t.websiteurl,
t.assignmentdefaultratetype,
t.linkactualtoactualthisperiod,
t.activitydefaultactivitytype,
t.linkpercentcompletewithactual,
t.addactualtoremaining,
t.criticalactivitypathtype,
t.activityidbasedonselactivity,
t.assignmentdefaultdrivingflag,
t.linkplannedandatcompletionflag,
t.resetplannedtoremainingflag,
t.allownegativeactualunitsflag,
t.ownerresourceobjectid,
t.checkoutdate,
t.checkoutuserobjectid,
t.lastfinancialperiodobjectid,
t.useprojectblforearnedvalue,
t.annualdiscountrate,
t.anticipatedfinishdate,
t.anticipatedstartdate,
t.containssummarydata,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
t.datadate,
t.discountapplicationperiod,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.earnedvalueetcuservalue,
t.earnedvalueuserpercent,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.independentetclaborunits,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.name,
t.obsname,
t.obsobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
t.overallprojectscore,
t.parentepsobjectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.risklevel,
t.riskscore,
t.riskexposure,
t.startdate,
t.status,
t.originalprojectobjectid,
t.riskscorematrixobjectid,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.NetPresentValue ELSE null END NetPresentValue,
t.ReturnOnInvestment,
t.PaybackPeriod,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.projectdescription,
t.baselinetypeobjectid,
t.enablepublication,
t.nextpublicationdate,
t.lastpublishedon,
t.publicationpriority,
t.locationobjectid,
t.historyinterval,
t.historylevel,
t.locationname,
t.allowstatusreview,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.etlinterval,
t.etlhour,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id
FROM PROJECT t, ProjectSecurity ps
WHERE 1=1  and t.objectid = ps.ProjectObjectId 
go
     
-- START BASELINE VIEW of PROJECT_U
--METADATA  TYPE:SSCR NAME:BLPROJECT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLPROJECT_U ' and type='V')
  DROP VIEW BLPROJECT_U 
go

print 'Creating Project-Level View BLPROJECT_U'
go

     
--METADATA NAME:BLPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLPROJECT_U
AS SELECT 
t.objectid,
t.id,
t.fiscalyearstartmonth,
t.resourcescaneditasgnmtpctcmp,
t.resourcescanselfassigntoacts,
t.primaryrescanmarkactsascmp,
t.resourcecanassigntosameact,
t.checkoutstatus,
t.activitypctcmpbasedonsteps,
t.costquantityrecalculateflag,
t.containssummarydataonly,
t.enablesummarization,
t.wbscodeseparator,
t.activitydefaultpctcmptype,
t.activitydefcostacctobjectid,
t.activitydefcalendarobjectid,
t.currentbaselineprojectobjectid,
t.activityidsuffix,
t.activityidincrement,
t.levelingpriority,
t.summarizetowbslevel,
t.strategicpriority,
t.criticalactivityfloatlimit,
CASE CostFlag WHEN 'Y' THEN t.activitydefaultpriceperunit ELSE null END activitydefaultpriceperunit,
t.plannedstartdate,
t.mustfinishbydate,
t.scheduledfinishdate,
t.dateadded,
t.summarizeddatadate,
t.lastsummarizeddate,
t.projectforecaststartdate,
t.activitydefaultdurationtype,
t.activityidprefix,
t.defaultpricetimeunits,
t.addedby,
t.websiterootdirectory,
t.websiteurl,
t.assignmentdefaultratetype,
t.linkactualtoactualthisperiod,
t.activitydefaultactivitytype,
t.linkpercentcompletewithactual,
t.addactualtoremaining,
t.criticalactivitypathtype,
t.activityidbasedonselactivity,
t.assignmentdefaultdrivingflag,
t.linkplannedandatcompletionflag,
t.resetplannedtoremainingflag,
t.allownegativeactualunitsflag,
t.ownerresourceobjectid,
t.checkoutdate,
t.checkoutuserobjectid,
t.lastfinancialperiodobjectid,
t.useprojectblforearnedvalue,
t.annualdiscountrate,
t.anticipatedfinishdate,
t.anticipatedstartdate,
t.containssummarydata,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
t.datadate,
t.discountapplicationperiod,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.earnedvalueetcuservalue,
t.earnedvalueuserpercent,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.independentetclaborunits,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.name,
t.obsname,
t.obsobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
t.overallprojectscore,
t.parentepsobjectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.risklevel,
t.riskscore,
t.riskexposure,
t.startdate,
t.status,
t.originalprojectobjectid,
t.riskscorematrixobjectid,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.NetPresentValue ELSE null END NetPresentValue,
t.ReturnOnInvestment,
t.PaybackPeriod,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.projectdescription,
t.baselinetypeobjectid,
t.enablepublication,
t.nextpublicationdate,
t.lastpublishedon,
t.publicationpriority,
t.locationobjectid,
t.historyinterval,
t.historylevel,
t.locationname,
t.allowstatusreview,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.etlinterval,
t.etlhour,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id
FROM BLPROJECT t
LEFT OUTER JOIN Baseline b ON t.objectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.objectid
    
go
     
-- FINISH BASELINE VIEW of PROJECT_U
print 'Creating Full View PROJECTBUDGETCHANGELOG_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTBUDGETCHANGELOG_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTBUDGETCHANGELOG_FULL ' and type='V')
  DROP VIEW PROJECTBUDGETCHANGELOG_FULL 
go

print 'Creating Full View PROJECTBUDGETCHANGELOG_FULL'
go

     
--METADATA NAME:PROJECTBUDGETCHANGELOG_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTBUDGETCHANGELOG_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
projectbudgetchangelogdate,
changenumber,
amount,
responsible,
status,
reason,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTBUDGETCHANGELOG
go
     
--METADATA  TYPE:SSCR NAME:PROJECTBUDGETCHANGELOG_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTBUDGETCHANGELOG_U ' and type='V')
  DROP VIEW PROJECTBUDGETCHANGELOG_U 
go

print 'Creating Project-Level View PROJECTBUDGETCHANGELOG_U'
go

     
--METADATA NAME:PROJECTBUDGETCHANGELOG_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTBUDGETCHANGELOG_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.projectbudgetchangelogdate,
t.changenumber,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.responsible,
t.status,
t.reason,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTBUDGETCHANGELOG t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODE_FULL ' and type='V')
  DROP VIEW PROJECTCODE_FULL 
go

print 'Creating Full View PROJECTCODE_FULL'
go

     
--METADATA NAME:PROJECTCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
parentobjectid,
description,
weight,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODE
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODE_U ' and type='V')
  DROP VIEW PROJECTCODE_U 
go

print 'Creating Project-Level View PROJECTCODE_U'
go

     
--METADATA NAME:PROJECTCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.weight,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODE_S ' and type='V')
  DROP VIEW PROJECTCODE_S 
go

print 'Creating Project-Level View PROJECTCODE_S'
go

     
--METADATA NAME:PROJECTCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.weight,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM PROJECTCODE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View PROJECTCODEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEASSIGNMENT_FULL ' and type='V')
  DROP VIEW PROJECTCODEASSIGNMENT_FULL 
go

print 'Creating Full View PROJECTCODEASSIGNMENT_FULL'
go

     
--METADATA NAME:PROJECTCODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEASSIGNMENT_FULL
AS SELECT 
projectobjectid,
projectcodetypeobjectid,
projectcodeobjectid,
projectcodedescription,
projectcodetypename,
projectcodevalue,
projectname,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEASSIGNMENT_U ' and type='V')
  DROP VIEW PROJECTCODEASSIGNMENT_U 
go

print 'Creating Project-Level View PROJECTCODEASSIGNMENT_U'
go

     
--METADATA NAME:PROJECTCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEASSIGNMENT_U
AS SELECT 
t.projectobjectid,
t.projectcodetypeobjectid,
t.projectcodeobjectid,
t.projectcodedescription,
t.projectcodetypename,
t.projectcodevalue,
t.projectname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTCODEASSIGNMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEASSIGNMENT_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEASSIGNMENT_S ' and type='V')
  DROP VIEW PROJECTCODEASSIGNMENT_S 
go

print 'Creating Project-Level View PROJECTCODEASSIGNMENT_S'
go

     
--METADATA NAME:PROJECTCODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEASSIGNMENT_S
AS SELECT 
t.projectobjectid,
t.projectcodetypeobjectid,
t.projectcodeobjectid,
t.projectcodedescription,
t.projectcodetypename,
t.projectcodevalue,
t.projectname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTCODEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = gs.RDBMSUserId and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View PROJECTCODEHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEHIERARCHY_FULL ' and type='V')
  DROP VIEW PROJECTCODEHIERARCHY_FULL 
go

print 'Creating Full View PROJECTCODEHIERARCHY_FULL'
go

     
--METADATA NAME:PROJECTCODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
CodeTypeWeight,
MaxCodeValueWeight,
ParentCodeValueWeight,
ChildCodeValueWeight
FROM PROJECTCODEHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEHIERARCHY_U ' and type='V')
  DROP VIEW PROJECTCODEHIERARCHY_U 
go

print 'Creating Project-Level View PROJECTCODEHIERARCHY_U'
go

     
--METADATA NAME:PROJECTCODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeWeight,
t.MaxCodeValueWeight,
t.ParentCodeValueWeight,
t.ChildCodeValueWeight
FROM PROJECTCODEHIERARCHY t
WHERE 1=1  and CodeTypeIsSecure='N' 
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEHIERARCHY_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEHIERARCHY_S ' and type='V')
  DROP VIEW PROJECTCODEHIERARCHY_S 
go

print 'Creating Project-Level View PROJECTCODEHIERARCHY_S'
go

     
--METADATA NAME:PROJECTCODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeWeight,
t.MaxCodeValueWeight,
t.ParentCodeValueWeight,
t.ChildCodeValueWeight, gs.rdbmsuserid  rpt_user_id
FROM PROJECTCODEHIERARCHY t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
go
     
print 'Creating Full View PROJECTCODETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODETYPE_FULL ' and type='V')
  DROP VIEW PROJECTCODETYPE_FULL 
go

print 'Creating Full View PROJECTCODETYPE_FULL'
go

     
--METADATA NAME:PROJECTCODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
weight,
maxcodevalueweight,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODETYPE
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODETYPE_U ' and type='V')
  DROP VIEW PROJECTCODETYPE_U 
go

print 'Creating Project-Level View PROJECTCODETYPE_U'
go

     
--METADATA NAME:PROJECTCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.weight,
t.maxcodevalueweight,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODETYPE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODETYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODETYPE_S ' and type='V')
  DROP VIEW PROJECTCODETYPE_S 
go

print 'Creating Project-Level View PROJECTCODETYPE_S'
go

     
--METADATA NAME:PROJECTCODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.weight,
t.maxcodevalueweight,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM PROJECTCODETYPE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View PROJECTCODEUSER_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEUSER_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEUSER_FULL ' and type='V')
  DROP VIEW PROJECTCODEUSER_FULL 
go

print 'Creating Full View PROJECTCODEUSER_FULL'
go

     
--METADATA NAME:PROJECTCODEUSER_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTCODEUSER_FULL
AS SELECT 
codeobjectid,
userobjectid,
codetypeobjectid,
codevalue,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEUSER
go
     
print 'Creating Global View PROJECTCODEUSER_U'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTCODEUSER_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTCODEUSER_U ' and type='V')
  DROP VIEW PROJECTCODEUSER_U 
go

print 'Creating Global View PROJECTCODEUSER_U'
go

     
--METADATA NAME:PROJECTCODEUSER_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  PROJECTCODEUSER_U
AS SELECT 
codeobjectid,
userobjectid,
codetypeobjectid,
codevalue,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEUSER
go
     
print 'Creating Full View PROJECTDOCUMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTDOCUMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTDOCUMENT_FULL ' and type='V')
  DROP VIEW PROJECTDOCUMENT_FULL 
go

print 'Creating Full View PROJECTDOCUMENT_FULL'
go

     
--METADATA NAME:PROJECTDOCUMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTDOCUMENT_FULL
AS SELECT 
objectid,
documentobjectid,
projectobjectid,
wbsobjectid,
isworkproduct,
activityobjectid,
activityid,
activityname,
documenttitle,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTDOCUMENT
go
     
--METADATA  TYPE:SSCR NAME:PROJECTDOCUMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTDOCUMENT_U ' and type='V')
  DROP VIEW PROJECTDOCUMENT_U 
go

print 'Creating Project-Level View PROJECTDOCUMENT_U'
go

     
--METADATA NAME:PROJECTDOCUMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTDOCUMENT_U
AS SELECT 
t.objectid,
t.documentobjectid,
t.projectobjectid,
t.wbsobjectid,
t.isworkproduct,
t.activityobjectid,
t.activityid,
t.activityname,
t.documenttitle,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTDOCUMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTFUNDING_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTFUNDING_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTFUNDING_FULL ' and type='V')
  DROP VIEW PROJECTFUNDING_FULL 
go

print 'Creating Full View PROJECTFUNDING_FULL'
go

     
--METADATA NAME:PROJECTFUNDING_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTFUNDING_FULL
AS SELECT 
objectid,
fundingsourceobjectid,
projectobjectid,
amount,
fundshare,
projectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTFUNDING
go
     
--METADATA  TYPE:SSCR NAME:PROJECTFUNDING_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTFUNDING_U ' and type='V')
  DROP VIEW PROJECTFUNDING_U 
go

print 'Creating Project-Level View PROJECTFUNDING_U'
go

     
--METADATA NAME:PROJECTFUNDING_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTFUNDING_U
AS SELECT 
t.objectid,
t.fundingsourceobjectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.fundshare,
t.projectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTFUNDING t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTISSUE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTISSUE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTISSUE_FULL ' and type='V')
  DROP VIEW PROJECTISSUE_FULL 
go

print 'Creating Full View PROJECTISSUE_FULL'
go

     
--METADATA NAME:PROJECTISSUE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTISSUE_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
priority,
status,
name,
projectthresholdobjectid,
wbsobjectid,
activityobjectid,
resourceobjectid,
thresholdparameterobjectid,
actualvalue,
lowerthreshold,
upperthreshold,
identifiedby,
resolutiondate,
dateidentified,
notes,
activityid,
activityname,
obsname,
projectid,
rawtextnote,
resourceid,
resourcename,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTISSUE
go
     
--METADATA  TYPE:SSCR NAME:PROJECTISSUE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTISSUE_U ' and type='V')
  DROP VIEW PROJECTISSUE_U 
go

print 'Creating Project-Level View PROJECTISSUE_U'
go

     
--METADATA NAME:PROJECTISSUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTISSUE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.priority,
t.status,
t.name,
t.projectthresholdobjectid,
t.wbsobjectid,
t.activityobjectid,
t.resourceobjectid,
t.thresholdparameterobjectid,
t.actualvalue,
t.lowerthreshold,
t.upperthreshold,
t.identifiedby,
t.resolutiondate,
t.dateidentified,
t.notes,
t.activityid,
t.activityname,
t.obsname,
t.projectid,
t.rawtextnote,
t.resourceid,
t.resourcename,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTISSUE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTNOTE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTNOTE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTNOTE_FULL ' and type='V')
  DROP VIEW PROJECTNOTE_FULL 
go

print 'Creating Full View PROJECTNOTE_FULL'
go

     
--METADATA NAME:PROJECTNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTNOTE_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
notebooktopicobjectid,
note,
notebooktopicname,
projectid,
rawtextnote,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTNOTE
go
     
--METADATA  TYPE:SSCR NAME:PROJECTNOTE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTNOTE_U ' and type='V')
  DROP VIEW PROJECTNOTE_U 
go

print 'Creating Project-Level View PROJECTNOTE_U'
go

     
--METADATA NAME:PROJECTNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTNOTE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.notebooktopicobjectid,
t.note,
t.notebooktopicname,
t.projectid,
t.rawtextnote,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTPORTFOLIO_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPORTFOLIO_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPORTFOLIO_FULL ' and type='V')
  DROP VIEW PROJECTPORTFOLIO_FULL 
go

print 'Creating Full View PROJECTPORTFOLIO_FULL'
go

     
--METADATA NAME:PROJECTPORTFOLIO_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPORTFOLIO_FULL
AS SELECT 
objectid,
includeclosedprojects,
includewhatifprojects,
type,
name,
userobjectid,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPORTFOLIO
go
     
print 'Creating Global View PROJECTPORTFOLIO_U'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPORTFOLIO_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPORTFOLIO_U ' and type='V')
  DROP VIEW PROJECTPORTFOLIO_U 
go

print 'Creating Global View PROJECTPORTFOLIO_U'
go

     
--METADATA NAME:PROJECTPORTFOLIO_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  PROJECTPORTFOLIO_U
AS SELECT 
objectid,
includeclosedprojects,
includewhatifprojects,
type,
name,
userobjectid,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPORTFOLIO
go
     
print 'Creating Full View PROJECTPROFILE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROFILE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROFILE_FULL ' and type='V')
  DROP VIEW PROJECTPROFILE_FULL 
go

print 'Creating Full View PROJECTPROFILE_FULL'
go

     
--METADATA NAME:PROJECTPROFILE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPROFILE_FULL
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROFILE
go
     
print 'Creating Global View PROJECTPROFILE_U'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROFILE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROFILE_U ' and type='V')
  DROP VIEW PROJECTPROFILE_U 
go

print 'Creating Global View PROJECTPROFILE_U'
go

     
--METADATA NAME:PROJECTPROFILE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  PROJECTPROFILE_U
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROFILE
go
     
print 'Creating Full View PROJECTPROJECTPORTFOLIO_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROJECTPORTFOLIO_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROJECTPORTFOLIO_FULL ' and type='V')
  DROP VIEW PROJECTPROJECTPORTFOLIO_FULL 
go

print 'Creating Full View PROJECTPROJECTPORTFOLIO_FULL'
go

     
--METADATA NAME:PROJECTPROJECTPORTFOLIO_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTPROJECTPORTFOLIO_FULL
AS SELECT 
projectportfolioobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROJECTPORTFOLIO
go
     
print 'Creating Global View PROJECTPROJECTPORTFOLIO_U'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTPROJECTPORTFOLIO_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTPROJECTPORTFOLIO_U ' and type='V')
  DROP VIEW PROJECTPROJECTPORTFOLIO_U 
go

print 'Creating Global View PROJECTPROJECTPORTFOLIO_U'
go

     
--METADATA NAME:PROJECTPROJECTPORTFOLIO_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  PROJECTPROJECTPORTFOLIO_U
AS SELECT 
projectportfolioobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROJECTPORTFOLIO
go
     
print 'Creating Full View PROJECTRESOURCE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCE_FULL ' and type='V')
  DROP VIEW PROJECTRESOURCE_FULL 
go

print 'Creating Full View PROJECTRESOURCE_FULL'
go

     
--METADATA NAME:PROJECTRESOURCE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCE_FULL
AS SELECT 
objectid,
wbsobjectid,
resourceobjectid,
projectobjectid,
committedflag,
startdate,
finishdate,
lifeofprojectflag,
projectid,
resourcename,
rolename,
roleobjectid,
status,
wbscode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTRESOURCE
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCE_U ' and type='V')
  DROP VIEW PROJECTRESOURCE_U 
go

print 'Creating Project-Level View PROJECTRESOURCE_U'
go

     
--METADATA NAME:PROJECTRESOURCE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCE_U
AS SELECT 
t.objectid,
t.wbsobjectid,
t.resourceobjectid,
t.projectobjectid,
t.committedflag,
t.startdate,
t.finishdate,
t.lifeofprojectflag,
t.projectid,
t.resourcename,
t.rolename,
t.roleobjectid,
t.status,
t.wbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTRESOURCE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTRESOURCEQUANTITY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCEQUANTITY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCEQUANTITY_FULL ' and type='V')
  DROP VIEW PROJECTRESOURCEQUANTITY_FULL 
go

print 'Creating Full View PROJECTRESOURCEQUANTITY_FULL'
go

     
--METADATA NAME:PROJECTRESOURCEQUANTITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCEQUANTITY_FULL
AS SELECT 
projectresourceobjectid,
weekstartdate,
monthstartdate,
quantity,
committedflag,
projectobjectid,
resourceobjectid,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTRESOURCEQUANTITY
go
     
--METADATA  TYPE:SSCR NAME:PROJECTRESOURCEQUANTITY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTRESOURCEQUANTITY_U ' and type='V')
  DROP VIEW PROJECTRESOURCEQUANTITY_U 
go

print 'Creating Project-Level View PROJECTRESOURCEQUANTITY_U'
go

     
--METADATA NAME:PROJECTRESOURCEQUANTITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTRESOURCEQUANTITY_U
AS SELECT 
t.projectresourceobjectid,
t.weekstartdate,
t.monthstartdate,
t.quantity,
t.committedflag,
t.projectobjectid,
t.resourceobjectid,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTRESOURCEQUANTITY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISK_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISK_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISK_FULL ' and type='V')
  DROP VIEW RISK_FULL 
go

print 'Creating Full View RISK_FULL'
go

     
--METADATA NAME:RISK_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISK_FULL
AS SELECT 
objectid,
projectobjectid,
id,
name,
totalcost,
resourceobjectid,
riskcategoryobjectid,
risktype,
riskstatus,
description,
effect,
cause,
note,
score,
scoretext,
scorecolor,
exposure,
identifiedbyresourceobjectid,
identifiedbyresourceid,
identifiedbyresourcename,
identifieddate,
exposurestartdate,
exposurefinishdate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISK
go
     
--METADATA  TYPE:SSCR NAME:RISK_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISK_U ' and type='V')
  DROP VIEW RISK_U 
go

print 'Creating Project-Level View RISK_U'
go

     
--METADATA NAME:RISK_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISK_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.id,
t.name,
CASE CostFlag WHEN 'Y' THEN t.totalcost ELSE null END totalcost,
t.resourceobjectid,
t.riskcategoryobjectid,
t.risktype,
t.riskstatus,
t.description,
t.effect,
t.cause,
t.note,
t.score,
t.scoretext,
t.scorecolor,
CASE CostFlag WHEN 'Y' THEN t.exposure ELSE null END exposure,
t.identifiedbyresourceobjectid,
t.identifiedbyresourceid,
t.identifiedbyresourcename,
t.identifieddate,
t.exposurestartdate,
t.exposurefinishdate,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RISK t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISKIMPACT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKIMPACT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKIMPACT_FULL ' and type='V')
  DROP VIEW RISKIMPACT_FULL 
go

print 'Creating Full View RISKIMPACT_FULL'
go

     
--METADATA NAME:RISKIMPACT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKIMPACT_FULL
AS SELECT 
riskobjectid,
projectobjectid,
riskthresholdobjectid,
riskthresholdlevelobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKIMPACT
go
     
--METADATA  TYPE:SSCR NAME:RISKIMPACT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKIMPACT_U ' and type='V')
  DROP VIEW RISKIMPACT_U 
go

print 'Creating Project-Level View RISKIMPACT_U'
go

     
--METADATA NAME:RISKIMPACT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKIMPACT_U
AS SELECT 
t.riskobjectid,
t.projectobjectid,
t.riskthresholdobjectid,
t.riskthresholdlevelobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RISKIMPACT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISKRESPONSEACTION_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTION_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTION_FULL ' and type='V')
  DROP VIEW RISKRESPONSEACTION_FULL 
go

print 'Creating Full View RISKRESPONSEACTION_FULL'
go

     
--METADATA NAME:RISKRESPONSEACTION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTION_FULL
AS SELECT 
objectid,
riskresponseplanobjectId,
resourceobjectid,
projectobjectid,
activityobjectid,
id,
name,
riskresponseactionstatus,
actualcost,
remainingcost,
plannedcost,
PhysicalStartDate,
PhysicalFinishDate,
PhysicalBaseStartDate,
PhysicalBaseFinishDate,
score,
scoretext,
scorecolor,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEACTION
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTION_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTION_U ' and type='V')
  DROP VIEW RISKRESPONSEACTION_U 
go

print 'Creating Project-Level View RISKRESPONSEACTION_U'
go

     
--METADATA NAME:RISKRESPONSEACTION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTION_U
AS SELECT 
t.objectid,
t.riskresponseplanobjectId,
t.resourceobjectid,
t.projectobjectid,
t.activityobjectid,
t.id,
t.name,
t.riskresponseactionstatus,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
t.PhysicalStartDate,
t.PhysicalFinishDate,
t.PhysicalBaseStartDate,
t.PhysicalBaseFinishDate,
t.score,
t.scoretext,
t.scorecolor,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RISKRESPONSEACTION t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISKRESPONSEACTIONIMPACT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTIONIMPACT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTIONIMPACT_FULL ' and type='V')
  DROP VIEW RISKRESPONSEACTIONIMPACT_FULL 
go

print 'Creating Full View RISKRESPONSEACTIONIMPACT_FULL'
go

     
--METADATA NAME:RISKRESPONSEACTIONIMPACT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTIONIMPACT_FULL
AS SELECT 
riskresponseactionobjectid,
projectobjectid,
riskthresholdobjectid,
riskthresholdlevelobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEACTIONIMPACT
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEACTIONIMPACT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEACTIONIMPACT_U ' and type='V')
  DROP VIEW RISKRESPONSEACTIONIMPACT_U 
go

print 'Creating Project-Level View RISKRESPONSEACTIONIMPACT_U'
go

     
--METADATA NAME:RISKRESPONSEACTIONIMPACT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEACTIONIMPACT_U
AS SELECT 
t.riskresponseactionobjectid,
t.projectobjectid,
t.riskthresholdobjectid,
t.riskthresholdlevelobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RISKRESPONSEACTIONIMPACT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISKRESPONSEPLAN_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEPLAN_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEPLAN_FULL ' and type='V')
  DROP VIEW RISKRESPONSEPLAN_FULL 
go

print 'Creating Full View RISKRESPONSEPLAN_FULL'
go

     
--METADATA NAME:RISKRESPONSEPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEPLAN_FULL
AS SELECT 
objectid,
riskobjectid,
projectobjectid,
id,
name,
isactive,
responsetype,
actualcost,
remainingcost,
plannedcost,
startdate,
finishdate,
plannedstartdate,
plannedfinishdate,
score,
scoretext,
scorecolor,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEPLAN
go
     
--METADATA  TYPE:SSCR NAME:RISKRESPONSEPLAN_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKRESPONSEPLAN_U ' and type='V')
  DROP VIEW RISKRESPONSEPLAN_U 
go

print 'Creating Project-Level View RISKRESPONSEPLAN_U'
go

     
--METADATA NAME:RISKRESPONSEPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKRESPONSEPLAN_U
AS SELECT 
t.objectid,
t.riskobjectid,
t.projectobjectid,
t.id,
t.name,
t.isactive,
t.responsetype,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
t.startdate,
t.finishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.score,
t.scoretext,
t.scorecolor,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RISKRESPONSEPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RISKMATRIXSCORETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORETYPE_FULL ' and type='V')
  DROP VIEW RISKMATRIXSCORETYPE_FULL 
go

print 'Creating Full View RISKMATRIXSCORETYPE_FULL'
go

     
--METADATA NAME:RISKMATRIXSCORETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKMATRIXSCORETYPE_FULL
AS SELECT 
matrixid,
scoretypeid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORETYPE
go
     
print 'Creating Global View RISKMATRIXSCORETYPE_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORETYPE_U ' and type='V')
  DROP VIEW RISKMATRIXSCORETYPE_U 
go

print 'Creating Global View RISKMATRIXSCORETYPE_U'
go

     
--METADATA NAME:RISKMATRIXSCORETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKMATRIXSCORETYPE_U
AS SELECT 
matrixid,
scoretypeid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORETYPE
go
     
print 'Creating Full View RISKSCORETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKSCORETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCORETYPE_FULL ' and type='V')
  DROP VIEW RISKSCORETYPE_FULL 
go

print 'Creating Full View RISKSCORETYPE_FULL'
go

     
--METADATA NAME:RISKSCORETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKSCORETYPE_FULL
AS SELECT 
scoretypeid,
name,
scoretype,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCORETYPE
go
     
print 'Creating Global View RISKSCORETYPE_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKSCORETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCORETYPE_U ' and type='V')
  DROP VIEW RISKSCORETYPE_U 
go

print 'Creating Global View RISKSCORETYPE_U'
go

     
--METADATA NAME:RISKSCORETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKSCORETYPE_U
AS SELECT 
scoretypeid,
name,
scoretype,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCORETYPE
go
     
print 'Creating Full View RISKMATRIXSCORE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORE_FULL ' and type='V')
  DROP VIEW RISKMATRIXSCORE_FULL 
go

print 'Creating Full View RISKMATRIXSCORE_FULL'
go

     
--METADATA NAME:RISKMATRIXSCORE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKMATRIXSCORE_FULL
AS SELECT 
objectid,
riskscorematrixobjectid,
probabilitythresholdlevel,
severity1,
severity2,
severity3,
severity4,
severity5,
severity6,
severity7,
severity8,
severity9,
severity1label,
severity2label,
severity3label,
severity4label,
severity5label,
severity6label,
severity7label,
severity8label,
severity9label,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORE
go
     
print 'Creating Global View RISKMATRIXSCORE_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKMATRIXSCORE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKMATRIXSCORE_U ' and type='V')
  DROP VIEW RISKMATRIXSCORE_U 
go

print 'Creating Global View RISKMATRIXSCORE_U'
go

     
--METADATA NAME:RISKMATRIXSCORE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKMATRIXSCORE_U
AS SELECT 
objectid,
riskscorematrixobjectid,
probabilitythresholdlevel,
severity1,
severity2,
severity3,
severity4,
severity5,
severity6,
severity7,
severity8,
severity9,
severity1label,
severity2label,
severity3label,
severity4label,
severity5label,
severity6label,
severity7label,
severity8label,
severity9label,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORE
go
     
print 'Creating Full View RISKSCOREMATRIX_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKSCOREMATRIX_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCOREMATRIX_FULL ' and type='V')
  DROP VIEW RISKSCOREMATRIX_FULL 
go

print 'Creating Full View RISKSCOREMATRIX_FULL'
go

     
--METADATA NAME:RISKSCOREMATRIX_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKSCOREMATRIX_FULL
AS SELECT 
objectid,
name,
description,
riskscoringmethod,
impact_levels,
probability_levels,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCOREMATRIX
go
     
print 'Creating Global View RISKSCOREMATRIX_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKSCOREMATRIX_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKSCOREMATRIX_U ' and type='V')
  DROP VIEW RISKSCOREMATRIX_U 
go

print 'Creating Global View RISKSCOREMATRIX_U'
go

     
--METADATA NAME:RISKSCOREMATRIX_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKSCOREMATRIX_U
AS SELECT 
objectid,
name,
description,
riskscoringmethod,
impact_levels,
probability_levels,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCOREMATRIX
go
     
print 'Creating Full View RISKTHRESHOLDLEVEL_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKTHRESHOLDLEVEL_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTHRESHOLDLEVEL_FULL ' and type='V')
  DROP VIEW RISKTHRESHOLDLEVEL_FULL 
go

print 'Creating Full View RISKTHRESHOLDLEVEL_FULL'
go

     
--METADATA NAME:RISKTHRESHOLDLEVEL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKTHRESHOLDLEVEL_FULL
AS SELECT 
objectid,
riskthresholdobjectId,
code,
name,
color,
riskscorelevel,
value,
tolerancerange,
costrange,
schedulerange,
probabiltyrange,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTHRESHOLDLEVEL
go
     
print 'Creating Global View RISKTHRESHOLDLEVEL_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKTHRESHOLDLEVEL_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTHRESHOLDLEVEL_U ' and type='V')
  DROP VIEW RISKTHRESHOLDLEVEL_U 
go

print 'Creating Global View RISKTHRESHOLDLEVEL_U'
go

     
--METADATA NAME:RISKTHRESHOLDLEVEL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKTHRESHOLDLEVEL_U
AS SELECT 
objectid,
riskthresholdobjectId,
code,
name,
color,
riskscorelevel,
value,
tolerancerange,
costrange,
schedulerange,
probabiltyrange,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTHRESHOLDLEVEL
go
     
print 'Creating Full View PROJECTSPENDINGPLAN_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPENDINGPLAN_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPENDINGPLAN_FULL ' and type='V')
  DROP VIEW PROJECTSPENDINGPLAN_FULL 
go

print 'Creating Full View PROJECTSPENDINGPLAN_FULL'
go

     
--METADATA NAME:PROJECTSPENDINGPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPENDINGPLAN_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
spendingplandate,
spendingplan,
benefitplan,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTSPENDINGPLAN
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPENDINGPLAN_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPENDINGPLAN_U ' and type='V')
  DROP VIEW PROJECTSPENDINGPLAN_U 
go

print 'Creating Project-Level View PROJECTSPENDINGPLAN_U'
go

     
--METADATA NAME:PROJECTSPENDINGPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPENDINGPLAN_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.spendingplandate,
CASE CostFlag WHEN 'Y' THEN t.spendingplan ELSE null END spendingplan,
CASE CostFlag WHEN 'Y' THEN t.benefitplan ELSE null END benefitplan,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM PROJECTSPENDINGPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTSPREAD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPREAD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPREAD_FULL ' and type='V')
  DROP VIEW PROJECTSPREAD_FULL 
go

print 'Creating Full View PROJECTSPREAD_FULL'
go

     
--METADATA NAME:PROJECTSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPREAD_FULL
AS SELECT 
ObjectId,
Id,
Name,
ParentEPSObjectId,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonlaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonlaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM PROJECTSPREAD
go
     
--METADATA  TYPE:SSCR NAME:PROJECTSPREAD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTSPREAD_U ' and type='V')
  DROP VIEW PROJECTSPREAD_U 
go

print 'Creating Project-Level View PROJECTSPREAD_U'
go

     
--METADATA NAME:PROJECTSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTSPREAD_U
AS SELECT 
t.ObjectId,
t.Id,
t.Name,
t.ParentEPSObjectId,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonlaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonlaborCost ELSE null END PlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost, ps.rdbmsuserid rpt_user_id
FROM PROJECTSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.ObjectId = ps.ProjectObjectId 
go
     
print 'Creating Full View RELATIONSHIP_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RELATIONSHIP_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELATIONSHIP_FULL ' and type='V')
  DROP VIEW RELATIONSHIP_FULL 
go

print 'Creating Full View RELATIONSHIP_FULL'
go

     
--METADATA NAME:RELATIONSHIP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RELATIONSHIP_FULL
AS SELECT 
objectid,
successoractivityobjectid,
predecessoractivityobjectid,
successorprojectobjectid,
predecessorprojectobjectid,
type,
lag,
predecessoractivityid,
predecessoractivityname,
predecessorprojectid,
successoractivityid,
successoractivityname,
successorprojectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELATIONSHIP
go
     
--METADATA  TYPE:SSCR NAME:RELATIONSHIP_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELATIONSHIP_U ' and type='V')
  DROP VIEW RELATIONSHIP_U 
go

print 'Creating Project-Level View RELATIONSHIP_U'
go

     
--METADATA NAME:RELATIONSHIP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RELATIONSHIP_U
AS SELECT 
t.objectid,
t.successoractivityobjectid,
t.predecessoractivityobjectid,
t.successorprojectobjectid,
t.predecessorprojectobjectid,
t.type,
t.lag,
t.predecessoractivityid,
t.predecessoractivityname,
t.predecessorprojectid,
t.successoractivityid,
t.successoractivityname,
t.successorprojectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RELATIONSHIP t, ProjectSecurity ps
WHERE 1=1  and t.successorprojectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RELEASE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RELEASE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASE_FULL ' and type='V')
  DROP VIEW RELEASE_FULL 
go

print 'Creating Full View RELEASE_FULL'
go

     
--METADATA NAME:RELEASE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RELEASE_FULL
AS SELECT 
objectid,
name,
startdate,
releasetheme,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASE
go
     
print 'Creating Global View RELEASE_U'
go
     
--METADATA  TYPE:SSCR NAME:RELEASE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASE_U ' and type='V')
  DROP VIEW RELEASE_U 
go

print 'Creating Global View RELEASE_U'
go

     
--METADATA NAME:RELEASE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RELEASE_U
AS SELECT 
objectid,
name,
startdate,
releasetheme,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASE
go
     
print 'Creating Full View RELEASEPROJECT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RELEASEPROJECT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEPROJECT_FULL ' and type='V')
  DROP VIEW RELEASEPROJECT_FULL 
go

print 'Creating Full View RELEASEPROJECT_FULL'
go

     
--METADATA NAME:RELEASEPROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RELEASEPROJECT_FULL
AS SELECT 
releaseobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEPROJECT
go
     
print 'Creating Global View RELEASEPROJECT_U'
go
     
--METADATA  TYPE:SSCR NAME:RELEASEPROJECT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEPROJECT_U ' and type='V')
  DROP VIEW RELEASEPROJECT_U 
go

print 'Creating Global View RELEASEPROJECT_U'
go

     
--METADATA NAME:RELEASEPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RELEASEPROJECT_U
AS SELECT 
releaseobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEPROJECT
go
     
print 'Creating Full View RELEASEITERATION_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RELEASEITERATION_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEITERATION_FULL ' and type='V')
  DROP VIEW RELEASEITERATION_FULL 
go

print 'Creating Full View RELEASEITERATION_FULL'
go

     
--METADATA NAME:RELEASEITERATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RELEASEITERATION_FULL
AS SELECT 
releaseobjectid,
projectobjectid,
iterationobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEITERATION
go
     
print 'Creating Global View RELEASEITERATION_U'
go
     
--METADATA  TYPE:SSCR NAME:RELEASEITERATION_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RELEASEITERATION_U ' and type='V')
  DROP VIEW RELEASEITERATION_U 
go

print 'Creating Global View RELEASEITERATION_U'
go

     
--METADATA NAME:RELEASEITERATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RELEASEITERATION_U
AS SELECT 
releaseobjectid,
projectobjectid,
iterationobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEITERATION
go
     
print 'Creating Full View REPORTDATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:REPORTDATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTDATE_FULL ' and type='V')
  DROP VIEW REPORTDATE_FULL 
go

print 'Creating Full View REPORTDATE_FULL'
go

     
--METADATA NAME:REPORTDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW REPORTDATE_FULL
AS SELECT 
DateName,
DayDate,
DayName,
DayOfMonth,
DayOfYear,
OrdinalDayOfMonth,
OrdinalDayOfYear,
WeekBeginDate,
DayOfWeek,
WeekNumber,
MonthNumber,
MonthName,
MonthShortName,
MonthEndDate,
DaysInMonth,
YearMonth,
QuarterNumber,
QuarterName,
Year,
ETLProcess,
ETLUser
FROM REPORTDATE
go
     
print 'Creating Global View REPORTDATE_U'
go
     
--METADATA  TYPE:SSCR NAME:REPORTDATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTDATE_U ' and type='V')
  DROP VIEW REPORTDATE_U 
go

print 'Creating Global View REPORTDATE_U'
go

     
--METADATA NAME:REPORTDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  REPORTDATE_U
AS SELECT 
DateName,
DayDate,
DayName,
DayOfMonth,
DayOfYear,
OrdinalDayOfMonth,
OrdinalDayOfYear,
WeekBeginDate,
DayOfWeek,
WeekNumber,
MonthNumber,
MonthName,
MonthShortName,
MonthEndDate,
DaysInMonth,
YearMonth,
QuarterNumber,
QuarterName,
Year,
ETLProcess,
ETLUser
FROM REPORTDATE
go
     
print 'Creating Full View REPORTTIME_FULL'
go
     
--METADATA  TYPE:SSCR NAME:REPORTTIME_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTTIME_FULL ' and type='V')
  DROP VIEW REPORTTIME_FULL 
go

print 'Creating Full View REPORTTIME_FULL'
go

     
--METADATA NAME:REPORTTIME_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW REPORTTIME_FULL
AS SELECT 
CivilianTime,
MilitaryTime,
TwoChar,
TimeName,
TimeOfDay,
ETLProcess,
ETLUser
FROM REPORTTIME
go
     
print 'Creating Global View REPORTTIME_U'
go
     
--METADATA  TYPE:SSCR NAME:REPORTTIME_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPORTTIME_U ' and type='V')
  DROP VIEW REPORTTIME_U 
go

print 'Creating Global View REPORTTIME_U'
go

     
--METADATA NAME:REPORTTIME_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  REPORTTIME_U
AS SELECT 
CivilianTime,
MilitaryTime,
TwoChar,
TimeName,
TimeOfDay,
ETLProcess,
ETLUser
FROM REPORTTIME
go
     
print 'Creating Full View RESASSIGNMENTPERIODACTUAL_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESASSIGNMENTPERIODACTUAL_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESASSIGNMENTPERIODACTUAL_FULL ' and type='V')
  DROP VIEW RESASSIGNMENTPERIODACTUAL_FULL 
go

print 'Creating Full View RESASSIGNMENTPERIODACTUAL_FULL'
go

     
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESASSIGNMENTPERIODACTUAL_FULL
AS SELECT 
financialperiodobjectid,
startdate,
enddate,
resourceassignmentobjectid,
activityobjectid,
projectobjectid,
actualunits,
actualcost,
resourcetype,
wbsobjectid,
resourceobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESASSIGNMENTPERIODACTUAL
go
     
--METADATA  TYPE:SSCR NAME:RESASSIGNMENTPERIODACTUAL_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESASSIGNMENTPERIODACTUAL_U ' and type='V')
  DROP VIEW RESASSIGNMENTPERIODACTUAL_U 
go

print 'Creating Project-Level View RESASSIGNMENTPERIODACTUAL_U'
go

     
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESASSIGNMENTPERIODACTUAL_U
AS SELECT 
t.financialperiodobjectid,
t.startdate,
t.enddate,
t.resourceassignmentobjectid,
t.activityobjectid,
t.projectobjectid,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
t.resourcetype,
t.wbsobjectid,
t.resourceobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RESASSIGNMENTPERIODACTUAL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View RESOURCEACCESS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEACCESS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEACCESS_FULL ' and type='V')
  DROP VIEW RESOURCEACCESS_FULL 
go

print 'Creating Full View RESOURCEACCESS_FULL'
go

     
--METADATA NAME:RESOURCEACCESS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEACCESS_FULL
AS SELECT 
userobjectid,
resourceobjectid,
resourceid,
resourcename,
username,
lastupdatedate
FROM RESOURCEACCESS
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEACCESS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEACCESS_U ' and type='V')
  DROP VIEW RESOURCEACCESS_U 
go

print 'Creating Project-Level View RESOURCEACCESS_U'
go

     
--METADATA NAME:RESOURCEACCESS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEACCESS_U
AS SELECT 
t.userobjectid,
t.resourceobjectid,
t.resourceid,
t.resourcename,
t.username,
t.lastupdatedate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCEACCESS t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENT_FULL ' and type='V')
  DROP VIEW RESOURCEASSIGNMENT_FULL 
go

print 'Creating Full View RESOURCEASSIGNMENT_FULL'
go

     
--METADATA NAME:RESOURCEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENT_FULL
AS SELECT 
objectid,
activityobjectid,
projectobjectid,
resourcetype,
iscostunitslinked,
roleobjectid,
costaccountobjectid,
resourceobjectid,
proficiency,
pendingpercentcomplete,
remainingunits,
pendingremainingunits,
plannedunits,
remainingunitspertime,
pendingactualregularunits,
plannedlag,
plannedunitspertime,
actualovertimeunits,
pendingactualovertimeunits,
actualregularunits,
remaininglag,
overtimefactor,
plannedcost,
actualregularcost,
actualovertimecost,
remainingcost,
actualstartdate,
actualfinishdate,
remainingstartdate,
remainingfinishdate,
plannedstartdate,
plannedfinishdate,
remaininglatestartdate,
remaininglatefinishdate,
ratetype,
actualthisperiodcost,
actualthisperiodunits,
resourcecurveobjectid,
drivingactivitydatesflag,
ratesource,
activityid,
activityname,
actualcost,
actualduration,
actualunits,
atcompletioncost,
atcompletionduration,
atcompletionunits,
autocomputeactuals,
calendarobjectid,
costaccountid,
costaccountname,
finishdate,
isactive,
isovertimeallowed,
isprimaryresource,
plannedduration,
priceperunit,
projectid,
remainingduration,
resourcecurvename,
resourceid,
resourcename,
roleid,
rolename,
staffedremainingcost,
staffedremainingunits,
startdate,
unitspercentcomplete,
unstaffedremainingcost,
unstaffedremainingunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex 
,RPT_CURRENT_FLAG
FROM RESOURCEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEASSIGNMENT_U ' and type='V')
  DROP VIEW RESOURCEASSIGNMENT_U 
go

print 'Creating Project-Level View RESOURCEASSIGNMENT_U'
go

     
--METADATA NAME:RESOURCEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEASSIGNMENT_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.projectobjectid,
t.resourcetype,
t.iscostunitslinked,
t.roleobjectid,
t.costaccountobjectid,
t.resourceobjectid,
CASE ProficiencyFlag WHEN 'Y' THEN t.proficiency ELSE null END proficiency,
t.pendingpercentcomplete,
t.remainingunits,
t.pendingremainingunits,
t.plannedunits,
t.remainingunitspertime,
t.pendingactualregularunits,
t.plannedlag,
t.plannedunitspertime,
t.actualovertimeunits,
t.pendingactualovertimeunits,
t.actualregularunits,
t.remaininglag,
t.overtimefactor,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
CASE CostFlag WHEN 'Y' THEN t.actualregularcost ELSE null END actualregularcost,
CASE CostFlag WHEN 'Y' THEN t.actualovertimecost ELSE null END actualovertimecost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
t.actualstartdate,
t.actualfinishdate,
t.remainingstartdate,
t.remainingfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.ratetype,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodcost ELSE null END actualthisperiodcost,
t.actualthisperiodunits,
t.resourcecurveobjectid,
t.drivingactivitydatesflag,
t.ratesource,
t.activityid,
t.activityname,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
t.actualduration,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletioncost ELSE null END atcompletioncost,
t.atcompletionduration,
t.atcompletionunits,
t.autocomputeactuals,
t.calendarobjectid,
t.costaccountid,
t.costaccountname,
t.finishdate,
t.isactive,
t.isovertimeallowed,
t.isprimaryresource,
t.plannedduration,
CASE CostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
t.projectid,
t.remainingduration,
t.resourcecurvename,
t.resourceid,
t.resourcename,
t.roleid,
t.rolename,
CASE CostFlag WHEN 'Y' THEN t.staffedremainingcost ELSE null END staffedremainingcost,
t.staffedremainingunits,
t.startdate,
t.unitspercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.unstaffedremainingcost ELSE null END unstaffedremainingcost,
t.unstaffedremainingunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id 
,RPT_CURRENT_FLAG
FROM RESOURCEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = gs.RDBMSUserId
go
     
print 'Creating Full View ASSIGNMENTCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODE_FULL ' and type='V')
  DROP VIEW ASSIGNMENTCODE_FULL 
go

print 'Creating Full View ASSIGNMENTCODE_FULL'
go

     
--METADATA NAME:ASSIGNMENTCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
parentobjectid,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ASSIGNMENTCODE
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODE_U ' and type='V')
  DROP VIEW ASSIGNMENTCODE_U 
go

print 'Creating Project-Level View ASSIGNMENTCODE_U'
go

     
--METADATA NAME:ASSIGNMENTCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ASSIGNMENTCODE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODE_S ' and type='V')
  DROP VIEW ASSIGNMENTCODE_S 
go

print 'Creating Project-Level View ASSIGNMENTCODE_S'
go

     
--METADATA NAME:ASSIGNMENTCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ASSIGNMENTCODE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View ASSIGNMENTCODETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODETYPE_FULL ' and type='V')
  DROP VIEW ASSIGNMENTCODETYPE_FULL 
go

print 'Creating Full View ASSIGNMENTCODETYPE_FULL'
go

     
--METADATA NAME:ASSIGNMENTCODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ASSIGNMENTCODETYPE
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODETYPE_U ' and type='V')
  DROP VIEW ASSIGNMENTCODETYPE_U 
go

print 'Creating Project-Level View ASSIGNMENTCODETYPE_U'
go

     
--METADATA NAME:ASSIGNMENTCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ASSIGNMENTCODETYPE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODETYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODETYPE_S ' and type='V')
  DROP VIEW ASSIGNMENTCODETYPE_S 
go

print 'Creating Project-Level View ASSIGNMENTCODETYPE_S'
go

     
--METADATA NAME:ASSIGNMENTCODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ASSIGNMENTCODETYPE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View ASSIGNMENTCODEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODEASSIGNMENT_FULL ' and type='V')
  DROP VIEW ASSIGNMENTCODEASSIGNMENT_FULL 
go

print 'Creating Full View ASSIGNMENTCODEASSIGNMENT_FULL'
go

     
--METADATA NAME:ASSIGNMENTCODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODEASSIGNMENT_FULL
AS SELECT 
asgnmntobjectid,
asgnmntcodetypeobjectid,
asgnmntcodeobjectid,
asgnmntcodedescription,
asgnmntcodetypename,
asgnmntcodevalue,
asgnmntid,
asgnmntname,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ASSIGNMENTCODEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODEASSIGNMENT_U ' and type='V')
  DROP VIEW ASSIGNMENTCODEASSIGNMENT_U 
go

print 'Creating Project-Level View ASSIGNMENTCODEASSIGNMENT_U'
go

     
--METADATA NAME:ASSIGNMENTCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODEASSIGNMENT_U
AS SELECT 
t.asgnmntobjectid,
t.asgnmntcodetypeobjectid,
t.asgnmntcodeobjectid,
t.asgnmntcodedescription,
t.asgnmntcodetypename,
t.asgnmntcodevalue,
t.asgnmntid,
t.asgnmntname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ASSIGNMENTCODEASSIGNMENT t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ASSIGNMENTCODEASSIGNMENT_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ASSIGNMENTCODEASSIGNMENT_S ' and type='V')
  DROP VIEW ASSIGNMENTCODEASSIGNMENT_S 
go

print 'Creating Project-Level View ASSIGNMENTCODEASSIGNMENT_S'
go

     
--METADATA NAME:ASSIGNMENTCODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ASSIGNMENTCODEASSIGNMENT_S
AS SELECT 
t.asgnmntobjectid,
t.asgnmntcodetypeobjectid,
t.asgnmntcodeobjectid,
t.asgnmntcodedescription,
t.asgnmntcodetypename,
t.asgnmntcodevalue,
t.asgnmntid,
t.asgnmntname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ASSIGNMENTCODEASSIGNMENT t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View RESOURCECODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODE_FULL ' and type='V')
  DROP VIEW RESOURCECODE_FULL 
go

print 'Creating Full View RESOURCECODE_FULL'
go

     
--METADATA NAME:RESOURCECODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
parentobjectid,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODE
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODE_U ' and type='V')
  DROP VIEW RESOURCECODE_U 
go

print 'Creating Project-Level View RESOURCECODE_U'
go

     
--METADATA NAME:RESOURCECODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODE_S ' and type='V')
  DROP VIEW RESOURCECODE_S 
go

print 'Creating Project-Level View RESOURCECODE_S'
go

     
--METADATA NAME:RESOURCECODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM RESOURCECODE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View RESOURCECODEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEASSIGNMENT_FULL ' and type='V')
  DROP VIEW RESOURCECODEASSIGNMENT_FULL 
go

print 'Creating Full View RESOURCECODEASSIGNMENT_FULL'
go

     
--METADATA NAME:RESOURCECODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEASSIGNMENT_FULL
AS SELECT 
resourceobjectid,
resourcecodetypeobjectid,
resourcecodeobjectid,
resourcecodedescription,
resourcecodetypename,
resourcecodevalue,
resourceid,
resourcename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEASSIGNMENT_U ' and type='V')
  DROP VIEW RESOURCECODEASSIGNMENT_U 
go

print 'Creating Project-Level View RESOURCECODEASSIGNMENT_U'
go

     
--METADATA NAME:RESOURCECODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEASSIGNMENT_U
AS SELECT 
t.resourceobjectid,
t.resourcecodetypeobjectid,
t.resourcecodeobjectid,
t.resourcecodedescription,
t.resourcecodetypename,
t.resourcecodevalue,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCECODEASSIGNMENT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEASSIGNMENT_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEASSIGNMENT_S ' and type='V')
  DROP VIEW RESOURCECODEASSIGNMENT_S 
go

print 'Creating Project-Level View RESOURCECODEASSIGNMENT_S'
go

     
--METADATA NAME:RESOURCECODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEASSIGNMENT_S
AS SELECT 
t.resourceobjectid,
t.resourcecodetypeobjectid,
t.resourcecodeobjectid,
t.resourcecodedescription,
t.resourcecodetypename,
t.resourcecodevalue,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCECODEASSIGNMENT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View RESOURCECODEHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEHIERARCHY_FULL ' and type='V')
  DROP VIEW RESOURCECODEHIERARCHY_FULL 
go

print 'Creating Full View RESOURCECODEHIERARCHY_FULL'
go

     
--METADATA NAME:RESOURCECODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM RESOURCECODEHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEHIERARCHY_U ' and type='V')
  DROP VIEW RESOURCECODEHIERARCHY_U 
go

print 'Creating Project-Level View RESOURCECODEHIERARCHY_U'
go

     
--METADATA NAME:RESOURCECODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName
FROM RESOURCECODEHIERARCHY t
WHERE 1=1  and CodeTypeIsSecure='N' 
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODEHIERARCHY_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODEHIERARCHY_S ' and type='V')
  DROP VIEW RESOURCECODEHIERARCHY_S 
go

print 'Creating Project-Level View RESOURCECODEHIERARCHY_S'
go

     
--METADATA NAME:RESOURCECODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName, gs.rdbmsuserid  rpt_user_id
FROM RESOURCECODEHIERARCHY t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
go
     
print 'Creating Full View RESOURCECODETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODETYPE_FULL ' and type='V')
  DROP VIEW RESOURCECODETYPE_FULL 
go

print 'Creating Full View RESOURCECODETYPE_FULL'
go

     
--METADATA NAME:RESOURCECODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODETYPE
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODETYPE_U ' and type='V')
  DROP VIEW RESOURCECODETYPE_U 
go

print 'Creating Project-Level View RESOURCECODETYPE_U'
go

     
--METADATA NAME:RESOURCECODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODETYPE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECODETYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECODETYPE_S ' and type='V')
  DROP VIEW RESOURCECODETYPE_S 
go

print 'Creating Project-Level View RESOURCECODETYPE_S'
go

     
--METADATA NAME:RESOURCECODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM RESOURCECODETYPE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View RESOURCECURVE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECURVE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECURVE_FULL ' and type='V')
  DROP VIEW RESOURCECURVE_FULL 
go

print 'Creating Full View RESOURCECURVE_FULL'
go

     
--METADATA NAME:RESOURCECURVE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCECURVE_FULL
AS SELECT 
objectid,
name,
isdefault,
value0,
value5,
value10,
value15,
value20,
value25,
value30,
value35,
value40,
value45,
value50,
value55,
value60,
value65,
value70,
value75,
value80,
value85,
value90,
value95,
value100,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECURVE
go
     
print 'Creating Global View RESOURCECURVE_U'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCECURVE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCECURVE_U ' and type='V')
  DROP VIEW RESOURCECURVE_U 
go

print 'Creating Global View RESOURCECURVE_U'
go

     
--METADATA NAME:RESOURCECURVE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RESOURCECURVE_U
AS SELECT 
objectid,
name,
isdefault,
value0,
value5,
value10,
value15,
value20,
value25,
value30,
value35,
value40,
value45,
value50,
value55,
value60,
value65,
value70,
value75,
value80,
value85,
value90,
value95,
value100,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECURVE
go
     
print 'Creating Full View RESOURCEHIERARCHY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHIERARCHY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHIERARCHY_FULL ' and type='V')
  DROP VIEW RESOURCEHIERARCHY_FULL 
go

print 'Creating Full View RESOURCEHIERARCHY_FULL'
go

     
--METADATA NAME:RESOURCEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM RESOURCEHIERARCHY
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHIERARCHY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHIERARCHY_U ' and type='V')
  DROP VIEW RESOURCEHIERARCHY_U 
go

print 'Creating Project-Level View RESOURCEHIERARCHY_U'
go

     
--METADATA NAME:RESOURCEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCEHIERARCHY t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.ParentObjectId = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCEHOUR_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHOUR_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHOUR_FULL ' and type='V')
  DROP VIEW RESOURCEHOUR_FULL 
go

print 'Creating Full View RESOURCEHOUR_FULL'
go

     
--METADATA NAME:RESOURCEHOUR_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHOUR_FULL
AS SELECT 
objectid,
resourceobjectid,
timesheetperiodobjectid,
activitytimesheetlinkflag,
resourceassignmentobjectid,
overheadcodeobjectid,
projectobjectid,
unapprovedhours,
approvedhours,
unapprovedovertimehours,
approvedovertimehours,
resourcehourdate,
status,
projectid,
projectname,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCEHOUR
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEHOUR_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEHOUR_U ' and type='V')
  DROP VIEW RESOURCEHOUR_U 
go

print 'Creating Project-Level View RESOURCEHOUR_U'
go

     
--METADATA NAME:RESOURCEHOUR_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEHOUR_U
AS SELECT 
t.objectid,
t.resourceobjectid,
t.timesheetperiodobjectid,
t.activitytimesheetlinkflag,
t.resourceassignmentobjectid,
t.overheadcodeobjectid,
t.projectobjectid,
t.unapprovedhours,
t.approvedhours,
t.unapprovedovertimehours,
t.approvedovertimehours,
t.resourcehourdate,
t.status,
t.projectid,
t.projectname,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM RESOURCEHOUR t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId 
WHERE 1=1  and ( ps.projectobjectid is not null
or t.projectobjectid is null )
go
     
print 'Creating Full View RESOURCERATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERATE_FULL ' and type='V')
  DROP VIEW RESOURCERATE_FULL 
go

print 'Creating Full View RESOURCERATE_FULL'
go

     
--METADATA NAME:RESOURCERATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERATE_FULL
AS SELECT 
objectid,
resourceobjectid,
effectivedate,
shiftperiodobjectid,
maxunitspertime,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCERATE
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERATE_U ' and type='V')
  DROP VIEW RESOURCERATE_U 
go

print 'Creating Project-Level View RESOURCERATE_U'
go

     
--METADATA NAME:RESOURCERATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERATE_U
AS SELECT 
t.objectid,
t.resourceobjectid,
t.effectivedate,
t.shiftperiodobjectid,
t.maxunitspertime,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit2 ELSE null END priceperunit2,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit3 ELSE null END priceperunit3,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit4 ELSE null END priceperunit4,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit5 ELSE null END priceperunit5,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCERATE t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCERESOURCETEAM_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERESOURCETEAM_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERESOURCETEAM_FULL ' and type='V')
  DROP VIEW RESOURCERESOURCETEAM_FULL 
go

print 'Creating Full View RESOURCERESOURCETEAM_FULL'
go

     
--METADATA NAME:RESOURCERESOURCETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERESOURCETEAM_FULL
AS SELECT 
resourceteamobjectid,
resourceobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCERESOURCETEAM
go
     
--METADATA  TYPE:SSCR NAME:RESOURCERESOURCETEAM_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCERESOURCETEAM_U ' and type='V')
  DROP VIEW RESOURCERESOURCETEAM_U 
go

print 'Creating Project-Level View RESOURCERESOURCETEAM_U'
go

     
--METADATA NAME:RESOURCERESOURCETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCERESOURCETEAM_U
AS SELECT 
t.resourceteamobjectid,
t.resourceobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCERESOURCETEAM t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCEROLE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEROLE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEROLE_FULL ' and type='V')
  DROP VIEW RESOURCEROLE_FULL 
go

print 'Creating Full View RESOURCEROLE_FULL'
go

     
--METADATA NAME:RESOURCEROLE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEROLE_FULL
AS SELECT 
resourceobjectid,
roleobjectid,
proficiency,
resourceid,
resourcename,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCEROLE
go
     
--METADATA  TYPE:SSCR NAME:RESOURCEROLE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCEROLE_U ' and type='V')
  DROP VIEW RESOURCEROLE_U 
go

print 'Creating Project-Level View RESOURCEROLE_U'
go

     
--METADATA NAME:RESOURCEROLE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCEROLE_U
AS SELECT 
t.resourceobjectid,
t.roleobjectid,
CASE ProficiencyFlag WHEN 'Y' THEN t.proficiency ELSE null END proficiency,
t.resourceid,
t.resourcename,
t.roleid,
t.rolename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, rs.rdbmsuserid  rpt_user_id
FROM RESOURCEROLE t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCES_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCES_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCES_FULL ' and type='V')
  DROP VIEW RESOURCES_FULL 
go

print 'Creating Full View RESOURCES_FULL'
go

     
--METADATA NAME:RESOURCES_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCES_FULL
AS SELECT 
objectid,
calendarobjectid,
sequencenumber,
usetimesheets,
isactive,
resourcetype,
autocomputeactuals,
isovertimeallowed,
calculatecostfromunits,
id,
name,
parentobjectid,
timesheetapprovalmgrobjectid,
userobjectid,
primaryroleobjectid,
currencyobjectid,
shiftobjectid,
overtimefactor,
defaultunitspertime,
officephone,
otherphone,
employeeid,
title,
emailaddress,
unitofmeasureobjectid,
resourcenotes,
calendarname,
currencyid,
currencyname,
primaryroleid,
primaryrolename,
timesheetapprovalmanager,
username,
locationobjectid,
locationname,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex
FROM RESOURCES
go
     
--METADATA  TYPE:SSCR NAME:RESOURCES_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCES_U ' and type='V')
  DROP VIEW RESOURCES_U 
go

print 'Creating Project-Level View RESOURCES_U'
go

     
--METADATA NAME:RESOURCES_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCES_U
AS SELECT 
t.objectid,
t.calendarobjectid,
t.sequencenumber,
t.usetimesheets,
t.isactive,
t.resourcetype,
t.autocomputeactuals,
t.isovertimeallowed,
t.calculatecostfromunits,
t.id,
t.name,
t.parentobjectid,
t.timesheetapprovalmgrobjectid,
t.userobjectid,
t.primaryroleobjectid,
t.currencyobjectid,
t.shiftobjectid,
t.overtimefactor,
t.defaultunitspertime,
t.officephone,
t.otherphone,
t.employeeid,
t.title,
t.emailaddress,
t.unitofmeasureobjectid,
t.resourcenotes,
t.calendarname,
t.currencyid,
t.currencyname,
t.primaryroleid,
t.primaryrolename,
t.timesheetapprovalmanager,
t.username,
t.locationobjectid,
t.locationname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex, rs.rdbmsuserid  rpt_user_id
FROM RESOURCES t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.objectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid  
go
     
print 'Creating Full View RESOURCELOCATION_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCELOCATION_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELOCATION_FULL ' and type='V')
  DROP VIEW RESOURCELOCATION_FULL 
go

print 'Creating Full View RESOURCELOCATION_FULL'
go

     
--METADATA NAME:RESOURCELOCATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCELOCATION_FULL
AS SELECT 
objectid,
resourceobjectid,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCELOCATION
go
     
print 'Creating Global View RESOURCELOCATION_U'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCELOCATION_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCELOCATION_U ' and type='V')
  DROP VIEW RESOURCELOCATION_U 
go

print 'Creating Global View RESOURCELOCATION_U'
go

     
--METADATA NAME:RESOURCELOCATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RESOURCELOCATION_U
AS SELECT 
objectid,
resourceobjectid,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCELOCATION
go
     
print 'Creating Full View RESOURCETEAM_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCETEAM_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCETEAM_FULL ' and type='V')
  DROP VIEW RESOURCETEAM_FULL 
go

print 'Creating Full View RESOURCETEAM_FULL'
go

     
--METADATA NAME:RESOURCETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCETEAM_FULL
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCETEAM
go
     
print 'Creating Global View RESOURCETEAM_U'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCETEAM_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCETEAM_U ' and type='V')
  DROP VIEW RESOURCETEAM_U 
go

print 'Creating Global View RESOURCETEAM_U'
go

     
--METADATA NAME:RESOURCETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RESOURCETEAM_U
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCETEAM
go
     
print 'Creating Full View RISKTYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:RISKTYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTYPE_FULL ' and type='V')
  DROP VIEW RISKTYPE_FULL 
go

print 'Creating Full View RISKTYPE_FULL'
go

     
--METADATA NAME:RISKTYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RISKTYPE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTYPE
go
     
print 'Creating Global View RISKTYPE_U'
go
     
--METADATA  TYPE:SSCR NAME:RISKTYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RISKTYPE_U ' and type='V')
  DROP VIEW RISKTYPE_U 
go

print 'Creating Global View RISKTYPE_U'
go

     
--METADATA NAME:RISKTYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  RISKTYPE_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTYPE
go
     
print 'Creating Full View ROLE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLE_FULL ' and type='V')
  DROP VIEW ROLE_FULL 
go

print 'Creating Full View ROLE_FULL'
go

     
--METADATA NAME:ROLE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLE_FULL
AS SELECT 
objectid,
id,
name,
sequencenumber,
parentobjectid,
calculatecostfromunits,
responsibilities,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLE
go
     
print 'Creating Global View ROLE_U'
go
     
--METADATA  TYPE:SSCR NAME:ROLE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLE_U ' and type='V')
  DROP VIEW ROLE_U 
go

print 'Creating Global View ROLE_U'
go

     
--METADATA NAME:ROLE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ROLE_U
AS SELECT 
objectid,
id,
name,
sequencenumber,
parentobjectid,
calculatecostfromunits,
responsibilities,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLE
go
     
print 'Creating Full View ROLECODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLECODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODE_FULL ' and type='V')
  DROP VIEW ROLECODE_FULL 
go

print 'Creating Full View ROLECODE_FULL'
go

     
--METADATA NAME:ROLECODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
parentobjectid,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLECODE
go
     
--METADATA  TYPE:SSCR NAME:ROLECODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODE_U ' and type='V')
  DROP VIEW ROLECODE_U 
go

print 'Creating Project-Level View ROLECODE_U'
go

     
--METADATA NAME:ROLECODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ROLECODE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ROLECODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODE_S ' and type='V')
  DROP VIEW ROLECODE_S 
go

print 'Creating Project-Level View ROLECODE_S'
go

     
--METADATA NAME:ROLECODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ROLECODE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View ROLECODETYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLECODETYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODETYPE_FULL ' and type='V')
  DROP VIEW ROLECODETYPE_FULL 
go

print 'Creating Full View ROLECODETYPE_FULL'
go

     
--METADATA NAME:ROLECODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLECODETYPE
go
     
--METADATA  TYPE:SSCR NAME:ROLECODETYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODETYPE_U ' and type='V')
  DROP VIEW ROLECODETYPE_U 
go

print 'Creating Project-Level View ROLECODETYPE_U'
go

     
--METADATA NAME:ROLECODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ROLECODETYPE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ROLECODETYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODETYPE_S ' and type='V')
  DROP VIEW ROLECODETYPE_S 
go

print 'Creating Project-Level View ROLECODETYPE_S'
go

     
--METADATA NAME:ROLECODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ROLECODETYPE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View ROLECODEASSIGNMENT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLECODEASSIGNMENT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODEASSIGNMENT_FULL ' and type='V')
  DROP VIEW ROLECODEASSIGNMENT_FULL 
go

print 'Creating Full View ROLECODEASSIGNMENT_FULL'
go

     
--METADATA NAME:ROLECODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODEASSIGNMENT_FULL
AS SELECT 
roleobjectid,
rolecodetypeobjectid,
rolecodeobjectid,
rolecodedescription,
rolecodetypename,
rolecodevalue,
roleid,
rolename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLECODEASSIGNMENT
go
     
--METADATA  TYPE:SSCR NAME:ROLECODEASSIGNMENT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODEASSIGNMENT_U ' and type='V')
  DROP VIEW ROLECODEASSIGNMENT_U 
go

print 'Creating Project-Level View ROLECODEASSIGNMENT_U'
go

     
--METADATA NAME:ROLECODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODEASSIGNMENT_U
AS SELECT 
t.roleobjectid,
t.rolecodetypeobjectid,
t.rolecodeobjectid,
t.rolecodedescription,
t.rolecodetypename,
t.rolecodevalue,
t.roleid,
t.rolename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ROLECODEASSIGNMENT t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:ROLECODEASSIGNMENT_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLECODEASSIGNMENT_S ' and type='V')
  DROP VIEW ROLECODEASSIGNMENT_S 
go

print 'Creating Project-Level View ROLECODEASSIGNMENT_S'
go

     
--METADATA NAME:ROLECODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLECODEASSIGNMENT_S
AS SELECT 
t.roleobjectid,
t.rolecodetypeobjectid,
t.rolecodeobjectid,
t.rolecodedescription,
t.rolecodetypename,
t.rolecodevalue,
t.roleid,
t.rolename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM ROLECODEASSIGNMENT t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View ROLERATE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLERATE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLERATE_FULL ' and type='V')
  DROP VIEW ROLERATE_FULL 
go

print 'Creating Full View ROLERATE_FULL'
go

     
--METADATA NAME:ROLERATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLERATE_FULL
AS SELECT 
objectid,
roleobjectid,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLERATE
go
     
print 'Creating Global View ROLERATE_U'
go
     
--METADATA  TYPE:SSCR NAME:ROLERATE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLERATE_U ' and type='V')
  DROP VIEW ROLERATE_U 
go

print 'Creating Global View ROLERATE_U'
go

     
--METADATA NAME:ROLERATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ROLERATE_U
AS SELECT 
objectid,
roleobjectid,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLERATE
go
     
print 'Creating Full View ROLEROLETEAM_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLEROLETEAM_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLEROLETEAM_FULL ' and type='V')
  DROP VIEW ROLEROLETEAM_FULL 
go

print 'Creating Full View ROLEROLETEAM_FULL'
go

     
--METADATA NAME:ROLEROLETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLEROLETEAM_FULL
AS SELECT 
roleteamobjectid,
roleobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLEROLETEAM
go
     
print 'Creating Global View ROLEROLETEAM_U'
go
     
--METADATA  TYPE:SSCR NAME:ROLEROLETEAM_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLEROLETEAM_U ' and type='V')
  DROP VIEW ROLEROLETEAM_U 
go

print 'Creating Global View ROLEROLETEAM_U'
go

     
--METADATA NAME:ROLEROLETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ROLEROLETEAM_U
AS SELECT 
roleteamobjectid,
roleobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLEROLETEAM
go
     
print 'Creating Full View ROLETEAM_FULL'
go
     
--METADATA  TYPE:SSCR NAME:ROLETEAM_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLETEAM_FULL ' and type='V')
  DROP VIEW ROLETEAM_FULL 
go

print 'Creating Full View ROLETEAM_FULL'
go

     
--METADATA NAME:ROLETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ROLETEAM_FULL
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLETEAM
go
     
print 'Creating Global View ROLETEAM_U'
go
     
--METADATA  TYPE:SSCR NAME:ROLETEAM_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ROLETEAM_U ' and type='V')
  DROP VIEW ROLETEAM_U 
go

print 'Creating Global View ROLETEAM_U'
go

     
--METADATA NAME:ROLETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  ROLETEAM_U
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLETEAM
go
     
print 'Creating Full View SHIFT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:SHIFT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFT_FULL ' and type='V')
  DROP VIEW SHIFT_FULL 
go

print 'Creating Full View SHIFT_FULL'
go

     
--METADATA NAME:SHIFT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW SHIFT_FULL
AS SELECT 
objectid,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFT
go
     
print 'Creating Global View SHIFT_U'
go
     
--METADATA  TYPE:SSCR NAME:SHIFT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFT_U ' and type='V')
  DROP VIEW SHIFT_U 
go

print 'Creating Global View SHIFT_U'
go

     
--METADATA NAME:SHIFT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  SHIFT_U
AS SELECT 
objectid,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFT
go
     
print 'Creating Full View SHIFTPERIOD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:SHIFTPERIOD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFTPERIOD_FULL ' and type='V')
  DROP VIEW SHIFTPERIOD_FULL 
go

print 'Creating Full View SHIFTPERIOD_FULL'
go

     
--METADATA NAME:SHIFTPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW SHIFTPERIOD_FULL
AS SELECT 
objectid,
shiftobjectid,
starthour,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFTPERIOD
go
     
print 'Creating Global View SHIFTPERIOD_U'
go
     
--METADATA  TYPE:SSCR NAME:SHIFTPERIOD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SHIFTPERIOD_U ' and type='V')
  DROP VIEW SHIFTPERIOD_U 
go

print 'Creating Global View SHIFTPERIOD_U'
go

     
--METADATA NAME:SHIFTPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  SHIFTPERIOD_U
AS SELECT 
objectid,
shiftobjectid,
starthour,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFTPERIOD
go
     
print 'Creating Full View SNAPSHOT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOT_FULL ' and type='V')
  DROP VIEW SNAPSHOT_FULL 
go

print 'Creating Full View SNAPSHOT_FULL'
go

     
--METADATA NAME:SNAPSHOT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOT_FULL
AS SELECT 
objectid,
name,
snapshotdate,
snapshotgroupobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOT
go
     
print 'Creating Global View SNAPSHOT_U'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOT_U ' and type='V')
  DROP VIEW SNAPSHOT_U 
go

print 'Creating Global View SNAPSHOT_U'
go

     
--METADATA NAME:SNAPSHOT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  SNAPSHOT_U
AS SELECT 
objectid,
name,
snapshotdate,
snapshotgroupobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOT
go
     
print 'Creating Full View SNAPSHOTGROUP_FULL'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTGROUP_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTGROUP_FULL ' and type='V')
  DROP VIEW SNAPSHOTGROUP_FULL 
go

print 'Creating Full View SNAPSHOTGROUP_FULL'
go

     
--METADATA NAME:SNAPSHOTGROUP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOTGROUP_FULL
AS SELECT 
objectid,
name,
description,
interval,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTGROUP
go
     
print 'Creating Global View SNAPSHOTGROUP_U'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTGROUP_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTGROUP_U ' and type='V')
  DROP VIEW SNAPSHOTGROUP_U 
go

print 'Creating Global View SNAPSHOTGROUP_U'
go

     
--METADATA NAME:SNAPSHOTGROUP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  SNAPSHOTGROUP_U
AS SELECT 
objectid,
name,
description,
interval,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTGROUP
go
     
print 'Creating Full View SNAPSHOTPROJECT_FULL'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTPROJECT_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTPROJECT_FULL ' and type='V')
  DROP VIEW SNAPSHOTPROJECT_FULL 
go

print 'Creating Full View SNAPSHOTPROJECT_FULL'
go

     
--METADATA NAME:SNAPSHOTPROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW SNAPSHOTPROJECT_FULL
AS SELECT 
snapshotgroupobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTPROJECT
go
     
print 'Creating Global View SNAPSHOTPROJECT_U'
go
     
--METADATA  TYPE:SSCR NAME:SNAPSHOTPROJECT_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SNAPSHOTPROJECT_U ' and type='V')
  DROP VIEW SNAPSHOTPROJECT_U 
go

print 'Creating Global View SNAPSHOTPROJECT_U'
go

     
--METADATA NAME:SNAPSHOTPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  SNAPSHOTPROJECT_U
AS SELECT 
snapshotgroupobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTPROJECT
go
     
print 'Creating Full View TIMESHEET_FULL'
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEET_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEET_FULL ' and type='V')
  DROP VIEW TIMESHEET_FULL 
go

print 'Creating Full View TIMESHEET_FULL'
go

     
--METADATA NAME:TIMESHEET_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW TIMESHEET_FULL
AS SELECT 
timesheetperiodobjectid,
resourceobjectid,
userobjectid,
isdaily,
status,
lastreceiveddate,
statusdate,
notes,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEET
go
     
print 'Creating Global View TIMESHEET_U'
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEET_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEET_U ' and type='V')
  DROP VIEW TIMESHEET_U 
go

print 'Creating Global View TIMESHEET_U'
go

     
--METADATA NAME:TIMESHEET_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  TIMESHEET_U
AS SELECT 
timesheetperiodobjectid,
resourceobjectid,
userobjectid,
isdaily,
status,
lastreceiveddate,
statusdate,
notes,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEET
go
     
print 'Creating Full View TIMESHEETPERIOD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEETPERIOD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEETPERIOD_FULL ' and type='V')
  DROP VIEW TIMESHEETPERIOD_FULL 
go

print 'Creating Full View TIMESHEETPERIOD_FULL'
go

     
--METADATA NAME:TIMESHEETPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW TIMESHEETPERIOD_FULL
AS SELECT 
objectid,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEETPERIOD
go
     
print 'Creating Global View TIMESHEETPERIOD_U'
go
     
--METADATA  TYPE:SSCR NAME:TIMESHEETPERIOD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIMESHEETPERIOD_U ' and type='V')
  DROP VIEW TIMESHEETPERIOD_U 
go

print 'Creating Global View TIMESHEETPERIOD_U'
go

     
--METADATA NAME:TIMESHEETPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  TIMESHEETPERIOD_U
AS SELECT 
objectid,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEETPERIOD
go
     
print 'Creating Full View UDFCODE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:UDFCODE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFCODE_FULL ' and type='V')
  DROP VIEW UDFCODE_FULL 
go

print 'Creating Full View UDFCODE_FULL'
go

     
--METADATA NAME:UDFCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
codetypetitle,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFCODE
go
     
--METADATA  TYPE:SSCR NAME:UDFCODE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFCODE_U ' and type='V')
  DROP VIEW UDFCODE_U 
go

print 'Creating Project-Level View UDFCODE_U'
go

     
--METADATA NAME:UDFCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.codetypetitle,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFCODE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:UDFCODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFCODE_S ' and type='V')
  DROP VIEW UDFCODE_S 
go

print 'Creating Project-Level View UDFCODE_S'
go

     
--METADATA NAME:UDFCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.codetypetitle,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM UDFCODE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View UDFTYPE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:UDFTYPE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFTYPE_FULL ' and type='V')
  DROP VIEW UDFTYPE_FULL 
go

print 'Creating Full View UDFTYPE_FULL'
go

     
--METADATA NAME:UDFTYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFTYPE_FULL
AS SELECT 
objectid,
subjectarea,
title,
datatype,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFTYPE
go
     
--METADATA  TYPE:SSCR NAME:UDFTYPE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFTYPE_U ' and type='V')
  DROP VIEW UDFTYPE_U 
go

print 'Creating Project-Level View UDFTYPE_U'
go

     
--METADATA NAME:UDFTYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFTYPE_U
AS SELECT 
t.objectid,
t.subjectarea,
t.title,
t.datatype,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFTYPE t
WHERE 1=1  and issecurecode='N' 
go
     
--METADATA  TYPE:SSCR NAME:UDFTYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFTYPE_S ' and type='V')
  DROP VIEW UDFTYPE_S 
go

print 'Creating Project-Level View UDFTYPE_S'
go

     
--METADATA NAME:UDFTYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFTYPE_S
AS SELECT 
t.objectid,
t.subjectarea,
t.title,
t.datatype,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, gs.rdbmsuserid  rpt_user_id
FROM UDFTYPE t, GlobalSecurity gs
WHERE 1=1  and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go
     
print 'Creating Full View UDFVALUE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:UDFVALUE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UDFVALUE_FULL ' and type='V')
  DROP VIEW UDFVALUE_FULL 
go

print 'Creating Full View UDFVALUE_FULL'
go

     
--METADATA NAME:UDFVALUE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UDFVALUE_FULL
AS SELECT 
udftypeobjectid,
foreignobjectid,
projectobjectid,
udfdate,
udftext,
udfnumber,
udfcodeobjectid,
subjectarea,
datatype,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFVALUE
go
     
-- START BASELINE VIEW of UDFVALUE_U
--METADATA  TYPE:SSCR NAME:BLUDFVALUE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLUDFVALUE_U ' and type='V')
  DROP VIEW BLUDFVALUE_U 
go

print 'Creating Project-Level View BLUDFVALUE_U'
go

     
--METADATA NAME:BLUDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLUDFVALUE_U
AS SELECT 
t.udftypeobjectid,
t.foreignobjectid,
t.projectobjectid,
t.udfdate,
t.udftext,
t.udfnumber,
t.udfcodeobjectid,
t.subjectarea,
t.datatype,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM BLUDFVALUE t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
    
go
     
-- FINISH BASELINE VIEW of UDFVALUE_U
--METADATA  TYPE:SSCR NAME:PROJECT_UDFVALUE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_UDFVALUE_U ' and type='V')
  DROP VIEW PROJECT_UDFVALUE_U 
go

print 'Creating UDF View PROJECT_UDFVALUE_U'
go

     
--METADATA NAME:PROJECT_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECT_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,case when datatype = 'FT_MONEY' and costflag = 'N' then null else t.UdfNumber end UdfNumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate, ps.rdbmsuserid rpt_user_id
FROM udfvalue t, ProjectSecurity ps 
WHERE t.ProjectObjectId = ps.ProjectObjectId
go
     
print 'Creating view RESOURCE_UDFVALUE_U'
go
     
--METADATA  TYPE:SSCR NAME:RESOURCE_UDFVALUE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RESOURCE_UDFVALUE_U ' and type='V')
  DROP VIEW RESOURCE_UDFVALUE_U 
go

print 'Creating UDF View RESOURCE_UDFVALUE_U'
go

     
--METADATA NAME:RESOURCE_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW RESOURCE_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,case when datatype = 'FT_MONEY' and resourcecostflag = 'N' then null else t.UdfNumber end UdfNumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate, rs.rdbmsuserid rpt_user_id
FROM udfvalue t, ResourceSecurity rs, GlobalSecurity gs
WHERE t.SubjectArea = 'RSRC' and t.ForeignObjectId = rs.ResourceObjectId and rs.rdbmsuserid = gs.rdbmsuserid
go
     
print 'Creating view GLOBAL_UDFVALUE_U'
go
     
--METADATA  TYPE:SSCR NAME:GLOBAL_UDFVALUE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBAL_UDFVALUE_U ' and type='V')
  DROP VIEW GLOBAL_UDFVALUE_U 
go

print 'Creating UDF View GLOBAL_UDFVALUE_U'
go

     
--METADATA NAME:GLOBAL_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW GLOBAL_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,t.udfnumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate
FROM udfvalue t
WHERE ProjectobjectId is null and t.SubjectArea != 'RSRC' 

go
     
print 'Creating Full View UNITOFMEASURE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:UNITOFMEASURE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UNITOFMEASURE_FULL ' and type='V')
  DROP VIEW UNITOFMEASURE_FULL 
go

print 'Creating Full View UNITOFMEASURE_FULL'
go

     
--METADATA NAME:UNITOFMEASURE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW UNITOFMEASURE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
abbreviation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UNITOFMEASURE
go
     
print 'Creating Global View UNITOFMEASURE_U'
go
     
--METADATA  TYPE:SSCR NAME:UNITOFMEASURE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UNITOFMEASURE_U ' and type='V')
  DROP VIEW UNITOFMEASURE_U 
go

print 'Creating Global View UNITOFMEASURE_U'
go

     
--METADATA NAME:UNITOFMEASURE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  UNITOFMEASURE_U
AS SELECT 
objectid,
sequencenumber,
name,
abbreviation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UNITOFMEASURE
go
     
print 'Creating Full View USERMODULEACCESS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:USERMODULEACCESS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERMODULEACCESS_FULL ' and type='V')
  DROP VIEW USERMODULEACCESS_FULL 
go

print 'Creating Full View USERMODULEACCESS_FULL'
go

     
--METADATA NAME:USERMODULEACCESS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USERMODULEACCESS_FULL
AS SELECT 
objectid,
userobjectid,
moduletypecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERMODULEACCESS
go
     
print 'Creating Global View USERMODULEACCESS_U'
go
     
--METADATA  TYPE:SSCR NAME:USERMODULEACCESS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERMODULEACCESS_U ' and type='V')
  DROP VIEW USERMODULEACCESS_U 
go

print 'Creating Global View USERMODULEACCESS_U'
go

     
--METADATA NAME:USERMODULEACCESS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  USERMODULEACCESS_U
AS SELECT 
objectid,
userobjectid,
moduletypecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERMODULEACCESS
go
     
print 'Creating Full View USEROBS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:USEROBS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USEROBS_FULL ' and type='V')
  DROP VIEW USEROBS_FULL 
go

print 'Creating Full View USEROBS_FULL'
go

     
--METADATA NAME:USEROBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USEROBS_FULL
AS SELECT 
userobjectid,
obsobjectid,
projectprofileobjectid,
obsname,
profilename,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USEROBS
go
     
print 'Creating Global View USEROBS_U'
go
     
--METADATA  TYPE:SSCR NAME:USEROBS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USEROBS_U ' and type='V')
  DROP VIEW USEROBS_U 
go

print 'Creating Global View USEROBS_U'
go

     
--METADATA NAME:USEROBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  USEROBS_U
AS SELECT 
userobjectid,
obsobjectid,
projectprofileobjectid,
obsname,
profilename,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USEROBS
go
     
print 'Creating Full View USERPROFILEPRIVILEGE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:USERPROFILEPRIVILEGE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERPROFILEPRIVILEGE_FULL ' and type='V')
  DROP VIEW USERPROFILEPRIVILEGE_FULL 
go

print 'Creating Full View USERPROFILEPRIVILEGE_FULL'
go

     
--METADATA NAME:USERPROFILEPRIVILEGE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USERPROFILEPRIVILEGE_FULL
AS SELECT 
profileid,
privlegenumber,
privlegename,
allowflag,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERPROFILEPRIVILEGE
go
     
print 'Creating Global View USERPROFILEPRIVILEGE_U'
go
     
--METADATA  TYPE:SSCR NAME:USERPROFILEPRIVILEGE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERPROFILEPRIVILEGE_U ' and type='V')
  DROP VIEW USERPROFILEPRIVILEGE_U 
go

print 'Creating Global View USERPROFILEPRIVILEGE_U'
go

     
--METADATA NAME:USERPROFILEPRIVILEGE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  USERPROFILEPRIVILEGE_U
AS SELECT 
profileid,
privlegenumber,
privlegename,
allowflag,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERPROFILEPRIVILEGE
go
     
print 'Creating Full View USERS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:USERS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERS_FULL ' and type='V')
  DROP VIEW USERS_FULL 
go

print 'Creating Full View USERS_FULL'
go

     
--METADATA NAME:USERS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW USERS_FULL
AS SELECT 
objectid,
emailprotocol,
rdbmsusername,
name,
globalprofileobjectid,
currencyobjectid,
allresourceaccessflag,
issuperuser,
mailserverloginname,
officephone,
personalname,
outgoingmailserver,
emailaddress,
notificationsettings,
respectactivitydurationtype,
assignmentstaffingpreference,
currencyid,
currencyname,
financialperiodendobjectid,
financialperiodstartobjectid,
newprojectdurationtype,
ratesourcepreference,
reportingflag,
lastprojectsecuritydate,
lastresourcesecuritydate,
lastglobalsecuritydate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERS
go
     
print 'Creating Global View USERS_U'
go
     
--METADATA  TYPE:SSCR NAME:USERS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USERS_U ' and type='V')
  DROP VIEW USERS_U 
go

print 'Creating Global View USERS_U'
go

     
--METADATA NAME:USERS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  USERS_U
AS SELECT 
objectid,
emailprotocol,
rdbmsusername,
name,
globalprofileobjectid,
currencyobjectid,
allresourceaccessflag,
issuperuser,
mailserverloginname,
officephone,
personalname,
outgoingmailserver,
emailaddress,
notificationsettings,
respectactivitydurationtype,
assignmentstaffingpreference,
currencyid,
currencyname,
financialperiodendobjectid,
financialperiodstartobjectid,
newprojectdurationtype,
ratesourcepreference,
reportingflag,
lastprojectsecuritydate,
lastresourcesecuritydate,
lastglobalsecuritydate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERS
go
     
print 'Creating Full View WBS_FULL'
go
     
--METADATA  TYPE:SSCR NAME:WBS_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBS_FULL ' and type='V')
  DROP VIEW WBS_FULL 
go

print 'Creating Full View WBS_FULL'
go

     
--METADATA NAME:WBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBS_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
sequencenumber,
containssummarydata,
status,
code,
name,
wbscategoryobjectid,
parentobjectid,
earnedvalueuserpercent,
earnedvalueetcuservalue,
originalbudget,
independentetctotalcost,
independentetclaborunits,
anticipatedstartdate,
anticipatedfinishdate,
earnedvaluecomputetype,
earnedvalueetccomputetype,
projectnodeflag,
currentbudget,
currentvariance,
distributedcurrentbudget,
finishdate,
forecastfinishdate,
forecaststartdate,
fullname,
fullsequence,
obsname,
projectid,
proposedbudget,
reviewtype,
startdate,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
summaxactualfinishdate,
summaxrestartdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
sumearlystartdate,
sumearlyenddate,
sumlatestartdate,
sumlateenddate,
summaxcalendarid,
summincalendarid,
totalbenefitplan,
totalbenefitplantally,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
undistributedcurrentvariance,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex 
,RPT_CURRENT_FLAG
FROM WBS
go
     
--METADATA  TYPE:SSCR NAME:WBS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBS_U ' and type='V')
  DROP VIEW WBS_U 
go

print 'Creating Project-Level View WBS_U'
go

     
--METADATA NAME:WBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.containssummarydata,
t.status,
t.code,
t.name,
t.wbscategoryobjectid,
t.parentobjectid,
t.earnedvalueuserpercent,
t.earnedvalueetcuservalue,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.projectnodeflag,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.fullname,
t.fullsequence,
t.obsname,
t.projectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.reviewtype,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id 
,RPT_CURRENT_FLAG
FROM WBS t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
-- START BASELINE VIEW of WBS_U
--METADATA  TYPE:SSCR NAME:BLWBS_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BLWBS_U ' and type='V')
  DROP VIEW BLWBS_U 
go

print 'Creating Project-Level View BLWBS_U'
go

     
--METADATA NAME:BLWBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLWBS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.containssummarydata,
t.status,
t.code,
t.name,
t.wbscategoryobjectid,
t.parentobjectid,
t.earnedvalueuserpercent,
t.earnedvalueetcuservalue,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.projectnodeflag,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.fullname,
t.fullsequence,
t.obsname,
t.projectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.reviewtype,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex, ps.rdbmsuserid rpt_user_id
FROM BLWBS t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and b.objectid = t.projectobjectid
    
go
     
-- FINISH BASELINE VIEW of WBS_U
print 'Creating Full View WBSCATEGORY_FULL'
go
     
--METADATA  TYPE:SSCR NAME:WBSCATEGORY_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSCATEGORY_FULL ' and type='V')
  DROP VIEW WBSCATEGORY_FULL 
go

print 'Creating Full View WBSCATEGORY_FULL'
go

     
--METADATA NAME:WBSCATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSCATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSCATEGORY
go
     
print 'Creating Global View WBSCATEGORY_U'
go
     
--METADATA  TYPE:SSCR NAME:WBSCATEGORY_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSCATEGORY_U ' and type='V')
  DROP VIEW WBSCATEGORY_U 
go

print 'Creating Global View WBSCATEGORY_U'
go

     
--METADATA NAME:WBSCATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  WBSCATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSCATEGORY
go
     
print 'Creating Full View WBSMILESTONE_FULL'
go
     
--METADATA  TYPE:SSCR NAME:WBSMILESTONE_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSMILESTONE_FULL ' and type='V')
  DROP VIEW WBSMILESTONE_FULL 
go

print 'Creating Full View WBSMILESTONE_FULL'
go

     
--METADATA NAME:WBSMILESTONE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSMILESTONE_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
sequencenumber,
iscompleted,
name,
weight,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSMILESTONE
go
     
--METADATA  TYPE:SSCR NAME:WBSMILESTONE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSMILESTONE_U ' and type='V')
  DROP VIEW WBSMILESTONE_U 
go

print 'Creating Project-Level View WBSMILESTONE_U'
go

     
--METADATA NAME:WBSMILESTONE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSMILESTONE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.sequencenumber,
t.iscompleted,
t.name,
t.weight,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate, ps.rdbmsuserid rpt_user_id
FROM WBSMILESTONE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View WBSSPREAD_FULL'
go
     
--METADATA  TYPE:SSCR NAME:WBSSPREAD_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSSPREAD_FULL ' and type='V')
  DROP VIEW WBSSPREAD_FULL 
go

print 'Creating Full View WBSSPREAD_FULL'
go

     
--METADATA NAME:WBSSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSSPREAD_FULL
AS SELECT 
ObjectId,
ParentObjectId,
Code,
Name,
projectobjectid,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonlaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonlaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM WBSSPREAD
go
     
--METADATA  TYPE:SSCR NAME:WBSSPREAD_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSSPREAD_U ' and type='V')
  DROP VIEW WBSSPREAD_U 
go

print 'Creating Project-Level View WBSSPREAD_U'
go

     
--METADATA NAME:WBSSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW WBSSPREAD_U
AS SELECT 
t.ObjectId,
t.ParentObjectId,
t.Code,
t.Name,
t.projectobjectid,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonlaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonlaborCost ELSE null END PlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost, ps.rdbmsuserid rpt_user_id
FROM WBSSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId 
go
     
print 'Creating Full View PROJECTETLLIST_FULL'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTETLLIST_FULL  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTETLLIST_FULL ' and type='V')
  DROP VIEW PROJECTETLLIST_FULL 
go

print 'Creating Full View PROJECTETLLIST_FULL'
go

     
--METADATA NAME:PROJECTETLLIST_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW PROJECTETLLIST_FULL
AS SELECT 
OBJECTID,
PROJECTOBJECTID,
LASTUPDATEDATE
FROM PROJECTETLLIST
go
     
print 'Creating Global View PROJECTETLLIST_U'
go
     
--METADATA  TYPE:SSCR NAME:PROJECTETLLIST_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECTETLLIST_U ' and type='V')
  DROP VIEW PROJECTETLLIST_U 
go

print 'Creating Global View PROJECTETLLIST_U'
go

     
--METADATA NAME:PROJECTETLLIST_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW  PROJECTETLLIST_U
AS SELECT 
OBJECTID,
PROJECTOBJECTID,
LASTUPDATEDATE
FROM PROJECTETLLIST
go
     
--METADATA  TYPE:SSCR NAME:PXSERVICES  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'CBS', N'V') IS NOT NULL
    DROP VIEW CBS
GO
--METADATA NAME:CBS TYPE:VIEW SET:CBS DATA  CHANGE:Lookup view for cbs
CREATE VIEW CBS AS SELECT A.cbs_id objectid,A.proj_id projectobjectid,A.cbs_code code,A.description name,A.parent_cbs_id parentobjectid,
A.status status,A.update_user lasteupdateuser,A.update_date lastupdatedate,A.create_user createuser,A.create_date createdate,P.update_dim_date lastupdatedatex
FROM dbo.CBS A INNER JOIN dbo.PROJECTX P ON a.proj_id = p.proj_id
INNER JOIN dbo.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null AND projects_tab.PROJECT_FLAG = 'Y'
go
--METADATA  TYPE:SSCR NAME:ETLFILTER  OBJECT_TYPE:VIEW
IF OBJECT_ID (N'ETLFILTER', N'V') IS NOT NULL
    DROP VIEW ETLFILTER
GO
--METADATA NAME:ETLFILTER TYPE:VIEW SET:ETLFILTER DATA  CHANGE:List of project object ids
CREATE VIEW ETLFILTER (objectid) AS
select projectobjectid from projectcodeassignment
where projectcodetypeobjectid =(select objectid from projectcodetype where UPPER(name) = 'ETLFILTER')
go

print 'Creating Full View ACTIVITYCODE_S'
go
  
--METADATA  TYPE:SSCR NAME:ACTIVITYCODE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODE_S ' and type='V')
  DROP VIEW ACTIVITYCODE_S 
go

print 'Creating Secure View ACTIVITYCODE_S'
go

     
--METADATA NAME:ACTIVITYCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODE_S
AS
SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.issecurecode,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODE t INNER JOIN ProjectSecurity ps ON t.projectobjectid = ps.projectobjectid
WHERE t.isSecureCode = 'Y'

UNION

SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.issecurecode,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
gs.rdbmsuserid rpt_user_id
FROM ACTIVITYCODE t, GlobalSecurity gs
WHERE t.projectobjectid IS NULL  AND t.isSecureCode = 'Y' AND gs.secureCodeFlag = 'Y'
    
go
     
print 'Creating Full View ACTIVITYCODETYPE_S'
go
  
--METADATA  TYPE:SSCR NAME:ACTIVITYCODETYPE_S  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITYCODETYPE_S ' and type='V')
  DROP VIEW ACTIVITYCODETYPE_S 
go

print 'Creating Secure View ACTIVITYCODETYPE_S'
go

     
--METADATA NAME:ACTIVITYCODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW ACTIVITYCODETYPE_S
AS
SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.issecurecode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
ps.rdbmsuserid rpt_user_id
FROM ACTIVITYCODETYPE t INNER JOIN ProjectSecurity ps ON t.projectobjectid = ps.projectobjectid
WHERE t.isSecureCode = 'Y'

UNION

SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.issecurecode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
gs.rdbmsuserid rpt_user_id
FROM ACTIVITYCODETYPE t, GlobalSecurity gs
WHERE t.projectobjectid IS NULL  AND t.isSecureCode = 'Y' AND gs.secureCodeFlag = 'Y'
    
go
     
--CONNECT USERNAME:pxrptuser
	 
--METADATA  TYPE:SSCR NAME:BASELINE_U  OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BASELINE_U' and type='V')
  DROP VIEW BASELINE_U
go

print 'creating view BASELINE'
go
     

--METADATA NAME:BASELINE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE VIEW BASELINE_U
AS SELECT  baseline.objectid
, baseline.id
, baseline.fiscalyearstartmonth
, baseline.resourcescaneditasgnmtpctcmp
, baseline.resourcescanselfassigntoacts
, baseline.primaryrescanmarkactsascmp
, baseline.resourcecanassigntosameact
, baseline.checkoutstatus
, baseline.activitypctcmpbasedonsteps
, baseline.costquantityrecalculateflag
, baseline.containssummarydataonly
, baseline.enablesummarization
, baseline.wbscodeseparator
, baseline.activitydefaultpctcmptype
, baseline.activitydefcostacctobjectid
, baseline.activitydefcalendarobjectid
, baseline.currentbaselineprojectobjectid
, baseline.activityidsuffix
, baseline.activityidincrement
, baseline.levelingpriority
, baseline.summarizetowbslevel
, baseline.strategicpriority
, baseline.criticalactivityfloatlimit
, baseline.activitydefaultpriceperunit
, baseline.plannedstartdate
, baseline.mustfinishbydate
, baseline.scheduledfinishdate
, baseline.dateadded
, baseline.summarizeddatadate
, baseline.lastsummarizeddate
, baseline.projectforecaststartdate
, baseline.activitydefaultdurationtype
, baseline.activityidprefix
, baseline.defaultpricetimeunits
, baseline.addedby
, baseline.websiterootdirectory
, baseline.websiteurl
, baseline.assignmentdefaultratetype
, baseline.linkactualtoactualthisperiod
, baseline.activitydefaultactivitytype
, baseline.linkpercentcompletewithactual
, baseline.addactualtoremaining
, baseline.criticalactivitypathtype
, baseline.activityidbasedonselactivity
, baseline.assignmentdefaultdrivingflag
, baseline.linkplannedandatcompletionflag
, baseline.resetplannedtoremainingflag
, baseline.allownegativeactualunitsflag
, baseline.ownerresourceobjectid
, baseline.checkoutdate
, baseline.checkoutuserobjectid
, baseline.lastfinancialperiodobjectid
, baseline.useprojectblforearnedvalue
, baseline.originalprojectobjectid
, baseline.riskscorematrixobjectid
, baseline.projectdescription
, baseline.baselinetypeobjectid
, baseline.enablepublication
, baseline.nextpublicationdate
, baseline.lastpublishedon
, baseline.publicationpriority
, baseline.locationobjectid
, baseline.historyinterval
, baseline.historylevel
, baseline.allowstatusreview
, baseline.lastupdateuser
, baseline.lastupdatedate
, baseline.createuser
, baseline.etlinterval
, baseline.etlhour
, baseline.createdate
, parentprojectid
, name,ps.rdbmsuserid rpt_user_id
FROM BASELINE, projectsecurity ps
WHERE 1=1 and ps.projectobjectid = baseline.originalprojectobjectid
go
     

--METADATA NAME:BLACTIVITYCODE_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
IF OBJECT_ID (N'BLACTIVITYCODE_S', N'V') IS NOT NULL
    DROP VIEW BLACTIVITYCODE_S
GO

--METADATA NAME:BLACTIVITYCODE_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM BLACTIVITYCODE t INNER JOIN ProjectSecurity ps ON t.projectobjectid = ps.projectobjectid
WHERE t.isSecureCode = 'Y'
go

--METADATA NAME:BLACTIVITYCODETYPE_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
IF OBJECT_ID (N'BLACTIVITYCODETYPE_S', N'V') IS NOT NULL
    DROP VIEW BLACTIVITYCODETYPE_S
GO

--METADATA NAME:BLACTIVITYCODETYPE_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODETYPE_S
AS SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.issecurecode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
ps.rdbmsuserid rpt_user_id
FROM BLACTIVITYCODETYPE t INNER JOIN ProjectSecurity ps ON t.projectobjectid = ps.projectobjectid
WHERE t.isSecureCode = 'Y'
UNION
SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.issecurecode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
gs.rdbmsuserid rpt_user_id
FROM BLACTIVITYCODETYPE t, GlobalSecurity gs
WHERE t.projectobjectid IS NULL  AND t.isSecureCode = 'Y' AND gs.secureCodeFlag = 'Y'
go

--METADATA NAME:BLACTIVITYCODEASSIGNMENT_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
IF OBJECT_ID (N'BLACTIVITYCODEASSIGNMENT_S', N'V') IS NOT NULL
    DROP VIEW BLACTIVITYCODEASSIGNMENT_S
GO

--METADATA NAME:BLACTIVITYCODEASSIGNMENT_S TYPE:VIEW SET:MANUAL_RPT_SEC_VIEWS CHANGE:CREATE
CREATE VIEW BLACTIVITYCODEASSIGNMENT_S
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM BLACTIVITYCODEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = gs.RDBMSUserId and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
go

--METADATA  TYPE:SSCR NAME:P6RESOURCEASSIGNMENTSPREAD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEASSIGNMENTSPREAD' and type='SN')
  DROP SYNONYM P6RESOURCEASSIGNMENTSPREAD 
go

--METADATA NAME:P6RESOURCEASSIGNMENTSPREAD TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEASSIGNMENTSPREAD CHANGE:CREATE
CREATE SYNONYM P6RESOURCEASSIGNMENTSPREAD FOR RESOURCEASSIGNMENTSPREAD_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCELIMIT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCELIMIT' and type='SN')
  DROP SYNONYM P6RESOURCELIMIT 
go

--METADATA NAME:P6RESOURCELIMIT TYPE:SYNONYM TARGET_OBJECT:P6RESOURCELIMIT CHANGE:CREATE
CREATE SYNONYM P6RESOURCELIMIT FOR RESOURCELIMIT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYSPREAD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYSPREAD' and type='SN')
  DROP SYNONYM P6ACTIVITYSPREAD 
go

--METADATA NAME:P6ACTIVITYSPREAD TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYSPREAD CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYSPREAD FOR ACTIVITYSPREAD_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITY' and type='SN')
  DROP SYNONYM P6ACTIVITY 
go

--METADATA NAME:P6ACTIVITY TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITY CHANGE:CREATE
CREATE SYNONYM P6ACTIVITY FOR ACTIVITY_U
go
		
--METADATA  TYPE:SSCR NAME:P6BLACTIVITY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6BLACTIVITY' and type='SN')
  DROP SYNONYM P6BLACTIVITY 
go

--METADATA NAME:P6BLACTIVITY TYPE:SYNONYM TARGET_OBJECT:P6BLACTIVITY CHANGE:CREATE
CREATE SYNONYM P6BLACTIVITY FOR BLACTIVITY_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODE' and type='SN')
  DROP SYNONYM P6ACTIVITYCODE 
go

--METADATA NAME:P6ACTIVITYCODE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODE FOR ACTIVITYCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODE_S' and type='SN')
  DROP SYNONYM P6ACTIVITYCODE_S 
go

--METADATA NAME:P6ACTIVITYCODE_S TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODE_S CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODE_S FOR ACTIVITYCODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODEASSIGNMENT' and type='SN')
  DROP SYNONYM P6ACTIVITYCODEASSIGNMENT 
go

--METADATA NAME:P6ACTIVITYCODEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODEASSIGNMENT FOR ACTIVITYCODEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODEASSIGNMENT_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODEASSIGNMENT_S' and type='SN')
  DROP SYNONYM P6ACTIVITYCODEASSIGNMENT_S 
go

--METADATA NAME:P6ACTIVITYCODEASSIGNMENT_S TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODEASSIGNMENT_S CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODEASSIGNMENT_S FOR ACTIVITYCODEASSIGNMENT_S
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODEHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODEHIERARCHY' and type='SN')
  DROP SYNONYM P6ACTIVITYCODEHIERARCHY 
go

--METADATA NAME:P6ACTIVITYCODEHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODEHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODEHIERARCHY FOR ACTIVITYCODEHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODEHIERARCHY_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODEHIERARCHY_S' and type='SN')
  DROP SYNONYM P6ACTIVITYCODEHIERARCHY_S 
go

--METADATA NAME:P6ACTIVITYCODEHIERARCHY_S TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODEHIERARCHY_S CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODEHIERARCHY_S FOR ACTIVITYCODEHIERARCHY_S
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODETYPE' and type='SN')
  DROP SYNONYM P6ACTIVITYCODETYPE 
go

--METADATA NAME:P6ACTIVITYCODETYPE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODETYPE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODETYPE FOR ACTIVITYCODETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODETYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODETYPE_S' and type='SN')
  DROP SYNONYM P6ACTIVITYCODETYPE_S 
go

--METADATA NAME:P6ACTIVITYCODETYPE_S TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODETYPE_S CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODETYPE_S FOR ACTIVITYCODETYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYEXPENSE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYEXPENSE' and type='SN')
  DROP SYNONYM P6ACTIVITYEXPENSE 
go

--METADATA NAME:P6ACTIVITYEXPENSE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYEXPENSE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYEXPENSE FOR ACTIVITYEXPENSE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYNOTE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYNOTE' and type='SN')
  DROP SYNONYM P6ACTIVITYNOTE 
go

--METADATA NAME:P6ACTIVITYNOTE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYNOTE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYNOTE FOR ACTIVITYNOTE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYPERIODACTUAL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYPERIODACTUAL' and type='SN')
  DROP SYNONYM P6ACTIVITYPERIODACTUAL 
go

--METADATA NAME:P6ACTIVITYPERIODACTUAL TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYPERIODACTUAL CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYPERIODACTUAL FOR ACTIVITYPERIODACTUAL_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYRISK  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYRISK' and type='SN')
  DROP SYNONYM P6ACTIVITYRISK 
go

--METADATA NAME:P6ACTIVITYRISK TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYRISK CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYRISK FOR ACTIVITYRISK_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYSTEP  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYSTEP' and type='SN')
  DROP SYNONYM P6ACTIVITYSTEP 
go

--METADATA NAME:P6ACTIVITYSTEP TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYSTEP CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYSTEP FOR ACTIVITYSTEP_U
go
		
--METADATA  TYPE:SSCR NAME:P6BASELINETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6BASELINETYPE' and type='SN')
  DROP SYNONYM P6BASELINETYPE 
go

--METADATA NAME:P6BASELINETYPE TYPE:SYNONYM TARGET_OBJECT:P6BASELINETYPE CHANGE:CREATE
CREATE SYNONYM P6BASELINETYPE FOR BASELINETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6CALENDAR  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6CALENDAR' and type='SN')
  DROP SYNONYM P6CALENDAR 
go

--METADATA NAME:P6CALENDAR TYPE:SYNONYM TARGET_OBJECT:P6CALENDAR CHANGE:CREATE
CREATE SYNONYM P6CALENDAR FOR CALENDAR_U
go
		
--METADATA  TYPE:SSCR NAME:P6CHANGESET  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6CHANGESET' and type='SN')
  DROP SYNONYM P6CHANGESET 
go

--METADATA NAME:P6CHANGESET TYPE:SYNONYM TARGET_OBJECT:P6CHANGESET CHANGE:CREATE
CREATE SYNONYM P6CHANGESET FOR CHANGESET_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYUPDATE' and type='SN')
  DROP SYNONYM P6ACTIVITYUPDATE 
go

--METADATA NAME:P6ACTIVITYUPDATE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYUPDATE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYUPDATE FOR ACTIVITYUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYSTEPUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYSTEPUPDATE' and type='SN')
  DROP SYNONYM P6ACTIVITYSTEPUPDATE 
go

--METADATA NAME:P6ACTIVITYSTEPUPDATE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYSTEPUPDATE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYSTEPUPDATE FOR ACTIVITYSTEPUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYSTEPCREATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYSTEPCREATE' and type='SN')
  DROP SYNONYM P6ACTIVITYSTEPCREATE 
go

--METADATA NAME:P6ACTIVITYSTEPCREATE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYSTEPCREATE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYSTEPCREATE FOR ACTIVITYSTEPCREATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYSTEPDEL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYSTEPDEL' and type='SN')
  DROP SYNONYM P6ACTIVITYSTEPDEL 
go

--METADATA NAME:P6ACTIVITYSTEPDEL TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYSTEPDEL CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYSTEPDEL FOR ACTIVITYSTEPDEL_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCOMMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCOMMENT' and type='SN')
  DROP SYNONYM P6ACTIVITYCOMMENT 
go

--METADATA NAME:P6ACTIVITYCOMMENT TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCOMMENT CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCOMMENT FOR ACTIVITYCOMMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYCODEUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYCODEUPDATE' and type='SN')
  DROP SYNONYM P6ACTIVITYCODEUPDATE 
go

--METADATA NAME:P6ACTIVITYCODEUPDATE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYCODEUPDATE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYCODEUPDATE FOR ACTIVITYCODEUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ACTIVITYNOTEUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ACTIVITYNOTEUPDATE' and type='SN')
  DROP SYNONYM P6ACTIVITYNOTEUPDATE 
go

--METADATA NAME:P6ACTIVITYNOTEUPDATE TYPE:SYNONYM TARGET_OBJECT:P6ACTIVITYNOTEUPDATE CHANGE:CREATE
CREATE SYNONYM P6ACTIVITYNOTEUPDATE FOR ACTIVITYNOTEUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6USERDEFINEDVALUEUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USERDEFINEDVALUEUPDATE' and type='SN')
  DROP SYNONYM P6USERDEFINEDVALUEUPDATE 
go

--METADATA NAME:P6USERDEFINEDVALUEUPDATE TYPE:SYNONYM TARGET_OBJECT:P6USERDEFINEDVALUEUPDATE CHANGE:CREATE
CREATE SYNONYM P6USERDEFINEDVALUEUPDATE FOR USERDEFINEDVALUEUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEASSIGNMENTUPDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEASSIGNMENTUPDATE' and type='SN')
  DROP SYNONYM P6RESOURCEASSIGNMENTUPDATE 
go

--METADATA NAME:P6RESOURCEASSIGNMENTUPDATE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEASSIGNMENTUPDATE CHANGE:CREATE
CREATE SYNONYM P6RESOURCEASSIGNMENTUPDATE FOR RESOURCEASSIGNMENTUPDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6COSTACCOUNT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6COSTACCOUNT' and type='SN')
  DROP SYNONYM P6COSTACCOUNT 
go

--METADATA NAME:P6COSTACCOUNT TYPE:SYNONYM TARGET_OBJECT:P6COSTACCOUNT CHANGE:CREATE
CREATE SYNONYM P6COSTACCOUNT FOR COSTACCOUNT_U
go
		
--METADATA  TYPE:SSCR NAME:P6COSTACCOUNTHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6COSTACCOUNTHIERARCHY' and type='SN')
  DROP SYNONYM P6COSTACCOUNTHIERARCHY 
go

--METADATA NAME:P6COSTACCOUNTHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6COSTACCOUNTHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6COSTACCOUNTHIERARCHY FOR COSTACCOUNTHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6COSTSECURITY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6COSTSECURITY' and type='SN')
  DROP SYNONYM P6COSTSECURITY 
go

--METADATA NAME:P6COSTSECURITY TYPE:SYNONYM TARGET_OBJECT:P6COSTSECURITY CHANGE:CREATE
CREATE SYNONYM P6COSTSECURITY FOR COSTSECURITY_U
go
		
--METADATA  TYPE:SSCR NAME:P6CURRENCY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6CURRENCY' and type='SN')
  DROP SYNONYM P6CURRENCY 
go

--METADATA NAME:P6CURRENCY TYPE:SYNONYM TARGET_OBJECT:P6CURRENCY CHANGE:CREATE
CREATE SYNONYM P6CURRENCY FOR CURRENCY_U
go
		
--METADATA  TYPE:SSCR NAME:P6DOCUMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6DOCUMENT' and type='SN')
  DROP SYNONYM P6DOCUMENT 
go

--METADATA NAME:P6DOCUMENT TYPE:SYNONYM TARGET_OBJECT:P6DOCUMENT CHANGE:CREATE
CREATE SYNONYM P6DOCUMENT FOR DOCUMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6DOCUMENTCATEGORY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6DOCUMENTCATEGORY' and type='SN')
  DROP SYNONYM P6DOCUMENTCATEGORY 
go

--METADATA NAME:P6DOCUMENTCATEGORY TYPE:SYNONYM TARGET_OBJECT:P6DOCUMENTCATEGORY CHANGE:CREATE
CREATE SYNONYM P6DOCUMENTCATEGORY FOR DOCUMENTCATEGORY_U
go
		
--METADATA  TYPE:SSCR NAME:P6DOCUMENTSTATUSCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6DOCUMENTSTATUSCODE' and type='SN')
  DROP SYNONYM P6DOCUMENTSTATUSCODE 
go

--METADATA NAME:P6DOCUMENTSTATUSCODE TYPE:SYNONYM TARGET_OBJECT:P6DOCUMENTSTATUSCODE CHANGE:CREATE
CREATE SYNONYM P6DOCUMENTSTATUSCODE FOR DOCUMENTSTATUSCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPS' and type='SN')
  DROP SYNONYM P6EPS 
go

--METADATA NAME:P6EPS TYPE:SYNONYM TARGET_OBJECT:P6EPS CHANGE:CREATE
CREATE SYNONYM P6EPS FOR EPS_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSBUDGETCHANGELOG  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSBUDGETCHANGELOG' and type='SN')
  DROP SYNONYM P6EPSBUDGETCHANGELOG 
go

--METADATA NAME:P6EPSBUDGETCHANGELOG TYPE:SYNONYM TARGET_OBJECT:P6EPSBUDGETCHANGELOG CHANGE:CREATE
CREATE SYNONYM P6EPSBUDGETCHANGELOG FOR EPSBUDGETCHANGELOG_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSFUNDING  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSFUNDING' and type='SN')
  DROP SYNONYM P6EPSFUNDING 
go

--METADATA NAME:P6EPSFUNDING TYPE:SYNONYM TARGET_OBJECT:P6EPSFUNDING CHANGE:CREATE
CREATE SYNONYM P6EPSFUNDING FOR EPSFUNDING_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSHIERARCHY' and type='SN')
  DROP SYNONYM P6EPSHIERARCHY 
go

--METADATA NAME:P6EPSHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6EPSHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6EPSHIERARCHY FOR EPSHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6WBSHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSHIERARCHY' and type='SN')
  DROP SYNONYM P6WBSHIERARCHY 
go

--METADATA NAME:P6WBSHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6WBSHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6WBSHIERARCHY FOR WBSHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSNOTE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSNOTE' and type='SN')
  DROP SYNONYM P6EPSNOTE 
go

--METADATA NAME:P6EPSNOTE TYPE:SYNONYM TARGET_OBJECT:P6EPSNOTE CHANGE:CREATE
CREATE SYNONYM P6EPSNOTE FOR EPSNOTE_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSSPENDINGPLAN  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSSPENDINGPLAN' and type='SN')
  DROP SYNONYM P6EPSSPENDINGPLAN 
go

--METADATA NAME:P6EPSSPENDINGPLAN TYPE:SYNONYM TARGET_OBJECT:P6EPSSPENDINGPLAN CHANGE:CREATE
CREATE SYNONYM P6EPSSPENDINGPLAN FOR EPSSPENDINGPLAN_U
go
		
--METADATA  TYPE:SSCR NAME:P6EPSSPREAD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EPSSPREAD' and type='SN')
  DROP SYNONYM P6EPSSPREAD 
go

--METADATA NAME:P6EPSSPREAD TYPE:SYNONYM TARGET_OBJECT:P6EPSSPREAD CHANGE:CREATE
CREATE SYNONYM P6EPSSPREAD FOR EPSSPREAD_U
go
		
--METADATA  TYPE:SSCR NAME:P6EXPENSECATEGORY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6EXPENSECATEGORY' and type='SN')
  DROP SYNONYM P6EXPENSECATEGORY 
go

--METADATA NAME:P6EXPENSECATEGORY TYPE:SYNONYM TARGET_OBJECT:P6EXPENSECATEGORY CHANGE:CREATE
CREATE SYNONYM P6EXPENSECATEGORY FOR EXPENSECATEGORY_U
go
		
--METADATA  TYPE:SSCR NAME:P6FINANCIALPERIOD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6FINANCIALPERIOD' and type='SN')
  DROP SYNONYM P6FINANCIALPERIOD 
go

--METADATA NAME:P6FINANCIALPERIOD TYPE:SYNONYM TARGET_OBJECT:P6FINANCIALPERIOD CHANGE:CREATE
CREATE SYNONYM P6FINANCIALPERIOD FOR FINANCIALPERIOD_U
go
		
--METADATA  TYPE:SSCR NAME:P6FUNDINGSOURCE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6FUNDINGSOURCE' and type='SN')
  DROP SYNONYM P6FUNDINGSOURCE 
go

--METADATA NAME:P6FUNDINGSOURCE TYPE:SYNONYM TARGET_OBJECT:P6FUNDINGSOURCE CHANGE:CREATE
CREATE SYNONYM P6FUNDINGSOURCE FOR FUNDINGSOURCE_U
go
		
--METADATA  TYPE:SSCR NAME:P6GLOBALPROFILE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6GLOBALPROFILE' and type='SN')
  DROP SYNONYM P6GLOBALPROFILE 
go

--METADATA NAME:P6GLOBALPROFILE TYPE:SYNONYM TARGET_OBJECT:P6GLOBALPROFILE CHANGE:CREATE
CREATE SYNONYM P6GLOBALPROFILE FOR GLOBALPROFILE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ISSUEHISTORY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ISSUEHISTORY' and type='SN')
  DROP SYNONYM P6ISSUEHISTORY 
go

--METADATA NAME:P6ISSUEHISTORY TYPE:SYNONYM TARGET_OBJECT:P6ISSUEHISTORY CHANGE:CREATE
CREATE SYNONYM P6ISSUEHISTORY FOR ISSUEHISTORY_U
go
		
--METADATA  TYPE:SSCR NAME:P6ITERATION  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ITERATION' and type='SN')
  DROP SYNONYM P6ITERATION 
go

--METADATA NAME:P6ITERATION TYPE:SYNONYM TARGET_OBJECT:P6ITERATION CHANGE:CREATE
CREATE SYNONYM P6ITERATION FOR ITERATION_U
go
		
--METADATA  TYPE:SSCR NAME:P6ITERATIONACTIVITY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ITERATIONACTIVITY' and type='SN')
  DROP SYNONYM P6ITERATIONACTIVITY 
go

--METADATA NAME:P6ITERATIONACTIVITY TYPE:SYNONYM TARGET_OBJECT:P6ITERATIONACTIVITY CHANGE:CREATE
CREATE SYNONYM P6ITERATIONACTIVITY FOR ITERATIONACTIVITY_U
go
		
--METADATA  TYPE:SSCR NAME:P6ITERATIONTEAM  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ITERATIONTEAM' and type='SN')
  DROP SYNONYM P6ITERATIONTEAM 
go

--METADATA NAME:P6ITERATIONTEAM TYPE:SYNONYM TARGET_OBJECT:P6ITERATIONTEAM CHANGE:CREATE
CREATE SYNONYM P6ITERATIONTEAM FOR ITERATIONTEAM_U
go
		
--METADATA  TYPE:SSCR NAME:P6LOCATION  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6LOCATION' and type='SN')
  DROP SYNONYM P6LOCATION 
go

--METADATA NAME:P6LOCATION TYPE:SYNONYM TARGET_OBJECT:P6LOCATION CHANGE:CREATE
CREATE SYNONYM P6LOCATION FOR LOCATION_U
go
		
--METADATA  TYPE:SSCR NAME:P6NOTEBOOKTOPIC  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6NOTEBOOKTOPIC' and type='SN')
  DROP SYNONYM P6NOTEBOOKTOPIC 
go

--METADATA NAME:P6NOTEBOOKTOPIC TYPE:SYNONYM TARGET_OBJECT:P6NOTEBOOKTOPIC CHANGE:CREATE
CREATE SYNONYM P6NOTEBOOKTOPIC FOR NOTEBOOKTOPIC_U
go
		
--METADATA  TYPE:SSCR NAME:P6OBS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6OBS' and type='SN')
  DROP SYNONYM P6OBS 
go

--METADATA NAME:P6OBS TYPE:SYNONYM TARGET_OBJECT:P6OBS CHANGE:CREATE
CREATE SYNONYM P6OBS FOR OBS_U
go
		
--METADATA  TYPE:SSCR NAME:P6OVERHEADCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6OVERHEADCODE' and type='SN')
  DROP SYNONYM P6OVERHEADCODE 
go

--METADATA NAME:P6OVERHEADCODE TYPE:SYNONYM TARGET_OBJECT:P6OVERHEADCODE CHANGE:CREATE
CREATE SYNONYM P6OVERHEADCODE FOR OVERHEADCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECT' and type='SN')
  DROP SYNONYM P6PROJECT 
go

--METADATA NAME:P6PROJECT TYPE:SYNONYM TARGET_OBJECT:P6PROJECT CHANGE:CREATE
CREATE SYNONYM P6PROJECT FOR PROJECT_U
go
		
--METADATA  TYPE:SSCR NAME:P6BLPROJECT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6BLPROJECT' and type='SN')
  DROP SYNONYM P6BLPROJECT 
go

--METADATA NAME:P6BLPROJECT TYPE:SYNONYM TARGET_OBJECT:P6BLPROJECT CHANGE:CREATE
CREATE SYNONYM P6BLPROJECT FOR BLPROJECT_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTBUDGETCHANGELOG  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTBUDGETCHANGELOG' and type='SN')
  DROP SYNONYM P6PROJECTBUDGETCHANGELOG 
go

--METADATA NAME:P6PROJECTBUDGETCHANGELOG TYPE:SYNONYM TARGET_OBJECT:P6PROJECTBUDGETCHANGELOG CHANGE:CREATE
CREATE SYNONYM P6PROJECTBUDGETCHANGELOG FOR PROJECTBUDGETCHANGELOG_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODE' and type='SN')
  DROP SYNONYM P6PROJECTCODE 
go

--METADATA NAME:P6PROJECTCODE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODE CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODE FOR PROJECTCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODE_S' and type='SN')
  DROP SYNONYM P6PROJECTCODE_S 
go

--METADATA NAME:P6PROJECTCODE_S TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODE_S CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODE_S FOR PROJECTCODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODEASSIGNMENT' and type='SN')
  DROP SYNONYM P6PROJECTCODEASSIGNMENT 
go

--METADATA NAME:P6PROJECTCODEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODEASSIGNMENT FOR PROJECTCODEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODEASSIGNMENT_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODEASSIGNMENT_S' and type='SN')
  DROP SYNONYM P6PROJECTCODEASSIGNMENT_S 
go

--METADATA NAME:P6PROJECTCODEASSIGNMENT_S TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODEASSIGNMENT_S CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODEASSIGNMENT_S FOR PROJECTCODEASSIGNMENT_S
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODEHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODEHIERARCHY' and type='SN')
  DROP SYNONYM P6PROJECTCODEHIERARCHY 
go

--METADATA NAME:P6PROJECTCODEHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODEHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODEHIERARCHY FOR PROJECTCODEHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODEHIERARCHY_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODEHIERARCHY_S' and type='SN')
  DROP SYNONYM P6PROJECTCODEHIERARCHY_S 
go

--METADATA NAME:P6PROJECTCODEHIERARCHY_S TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODEHIERARCHY_S CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODEHIERARCHY_S FOR PROJECTCODEHIERARCHY_S
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODETYPE' and type='SN')
  DROP SYNONYM P6PROJECTCODETYPE 
go

--METADATA NAME:P6PROJECTCODETYPE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODETYPE CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODETYPE FOR PROJECTCODETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODETYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODETYPE_S' and type='SN')
  DROP SYNONYM P6PROJECTCODETYPE_S 
go

--METADATA NAME:P6PROJECTCODETYPE_S TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODETYPE_S CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODETYPE_S FOR PROJECTCODETYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTCODEUSER  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTCODEUSER' and type='SN')
  DROP SYNONYM P6PROJECTCODEUSER 
go

--METADATA NAME:P6PROJECTCODEUSER TYPE:SYNONYM TARGET_OBJECT:P6PROJECTCODEUSER CHANGE:CREATE
CREATE SYNONYM P6PROJECTCODEUSER FOR PROJECTCODEUSER_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTDOCUMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTDOCUMENT' and type='SN')
  DROP SYNONYM P6PROJECTDOCUMENT 
go

--METADATA NAME:P6PROJECTDOCUMENT TYPE:SYNONYM TARGET_OBJECT:P6PROJECTDOCUMENT CHANGE:CREATE
CREATE SYNONYM P6PROJECTDOCUMENT FOR PROJECTDOCUMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTFUNDING  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTFUNDING' and type='SN')
  DROP SYNONYM P6PROJECTFUNDING 
go

--METADATA NAME:P6PROJECTFUNDING TYPE:SYNONYM TARGET_OBJECT:P6PROJECTFUNDING CHANGE:CREATE
CREATE SYNONYM P6PROJECTFUNDING FOR PROJECTFUNDING_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTISSUE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTISSUE' and type='SN')
  DROP SYNONYM P6PROJECTISSUE 
go

--METADATA NAME:P6PROJECTISSUE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTISSUE CHANGE:CREATE
CREATE SYNONYM P6PROJECTISSUE FOR PROJECTISSUE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTNOTE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTNOTE' and type='SN')
  DROP SYNONYM P6PROJECTNOTE 
go

--METADATA NAME:P6PROJECTNOTE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTNOTE CHANGE:CREATE
CREATE SYNONYM P6PROJECTNOTE FOR PROJECTNOTE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTPORTFOLIO  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTPORTFOLIO' and type='SN')
  DROP SYNONYM P6PROJECTPORTFOLIO 
go

--METADATA NAME:P6PROJECTPORTFOLIO TYPE:SYNONYM TARGET_OBJECT:P6PROJECTPORTFOLIO CHANGE:CREATE
CREATE SYNONYM P6PROJECTPORTFOLIO FOR PROJECTPORTFOLIO_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTPROFILE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTPROFILE' and type='SN')
  DROP SYNONYM P6PROJECTPROFILE 
go

--METADATA NAME:P6PROJECTPROFILE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTPROFILE CHANGE:CREATE
CREATE SYNONYM P6PROJECTPROFILE FOR PROJECTPROFILE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTPROJECTPORTFOLIO  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTPROJECTPORTFOLIO' and type='SN')
  DROP SYNONYM P6PROJECTPROJECTPORTFOLIO 
go

--METADATA NAME:P6PROJECTPROJECTPORTFOLIO TYPE:SYNONYM TARGET_OBJECT:P6PROJECTPROJECTPORTFOLIO CHANGE:CREATE
CREATE SYNONYM P6PROJECTPROJECTPORTFOLIO FOR PROJECTPROJECTPORTFOLIO_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTRESOURCE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTRESOURCE' and type='SN')
  DROP SYNONYM P6PROJECTRESOURCE 
go

--METADATA NAME:P6PROJECTRESOURCE TYPE:SYNONYM TARGET_OBJECT:P6PROJECTRESOURCE CHANGE:CREATE
CREATE SYNONYM P6PROJECTRESOURCE FOR PROJECTRESOURCE_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTRESOURCEQUANTITY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTRESOURCEQUANTITY' and type='SN')
  DROP SYNONYM P6PROJECTRESOURCEQUANTITY 
go

--METADATA NAME:P6PROJECTRESOURCEQUANTITY TYPE:SYNONYM TARGET_OBJECT:P6PROJECTRESOURCEQUANTITY CHANGE:CREATE
CREATE SYNONYM P6PROJECTRESOURCEQUANTITY FOR PROJECTRESOURCEQUANTITY_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISK  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISK' and type='SN')
  DROP SYNONYM P6RISK 
go

--METADATA NAME:P6RISK TYPE:SYNONYM TARGET_OBJECT:P6RISK CHANGE:CREATE
CREATE SYNONYM P6RISK FOR RISK_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKIMPACT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKIMPACT' and type='SN')
  DROP SYNONYM P6RISKIMPACT 
go

--METADATA NAME:P6RISKIMPACT TYPE:SYNONYM TARGET_OBJECT:P6RISKIMPACT CHANGE:CREATE
CREATE SYNONYM P6RISKIMPACT FOR RISKIMPACT_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKRESPONSEACTION  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKRESPONSEACTION' and type='SN')
  DROP SYNONYM P6RISKRESPONSEACTION 
go

--METADATA NAME:P6RISKRESPONSEACTION TYPE:SYNONYM TARGET_OBJECT:P6RISKRESPONSEACTION CHANGE:CREATE
CREATE SYNONYM P6RISKRESPONSEACTION FOR RISKRESPONSEACTION_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKRESPONSEACTIONIMPACT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKRESPONSEACTIONIMPACT' and type='SN')
  DROP SYNONYM P6RISKRESPONSEACTIONIMPACT 
go

--METADATA NAME:P6RISKRESPONSEACTIONIMPACT TYPE:SYNONYM TARGET_OBJECT:P6RISKRESPONSEACTIONIMPACT CHANGE:CREATE
CREATE SYNONYM P6RISKRESPONSEACTIONIMPACT FOR RISKRESPONSEACTIONIMPACT_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKRESPONSEPLAN  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKRESPONSEPLAN' and type='SN')
  DROP SYNONYM P6RISKRESPONSEPLAN 
go

--METADATA NAME:P6RISKRESPONSEPLAN TYPE:SYNONYM TARGET_OBJECT:P6RISKRESPONSEPLAN CHANGE:CREATE
CREATE SYNONYM P6RISKRESPONSEPLAN FOR RISKRESPONSEPLAN_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKMATRIXSCORETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKMATRIXSCORETYPE' and type='SN')
  DROP SYNONYM P6RISKMATRIXSCORETYPE 
go

--METADATA NAME:P6RISKMATRIXSCORETYPE TYPE:SYNONYM TARGET_OBJECT:P6RISKMATRIXSCORETYPE CHANGE:CREATE
CREATE SYNONYM P6RISKMATRIXSCORETYPE FOR RISKMATRIXSCORETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKSCORETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKSCORETYPE' and type='SN')
  DROP SYNONYM P6RISKSCORETYPE 
go

--METADATA NAME:P6RISKSCORETYPE TYPE:SYNONYM TARGET_OBJECT:P6RISKSCORETYPE CHANGE:CREATE
CREATE SYNONYM P6RISKSCORETYPE FOR RISKSCORETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKMATRIXSCORE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKMATRIXSCORE' and type='SN')
  DROP SYNONYM P6RISKMATRIXSCORE 
go

--METADATA NAME:P6RISKMATRIXSCORE TYPE:SYNONYM TARGET_OBJECT:P6RISKMATRIXSCORE CHANGE:CREATE
CREATE SYNONYM P6RISKMATRIXSCORE FOR RISKMATRIXSCORE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKSCOREMATRIX  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKSCOREMATRIX' and type='SN')
  DROP SYNONYM P6RISKSCOREMATRIX 
go

--METADATA NAME:P6RISKSCOREMATRIX TYPE:SYNONYM TARGET_OBJECT:P6RISKSCOREMATRIX CHANGE:CREATE
CREATE SYNONYM P6RISKSCOREMATRIX FOR RISKSCOREMATRIX_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKTHRESHOLDLEVEL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKTHRESHOLDLEVEL' and type='SN')
  DROP SYNONYM P6RISKTHRESHOLDLEVEL 
go

--METADATA NAME:P6RISKTHRESHOLDLEVEL TYPE:SYNONYM TARGET_OBJECT:P6RISKTHRESHOLDLEVEL CHANGE:CREATE
CREATE SYNONYM P6RISKTHRESHOLDLEVEL FOR RISKTHRESHOLDLEVEL_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTSPENDINGPLAN  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTSPENDINGPLAN' and type='SN')
  DROP SYNONYM P6PROJECTSPENDINGPLAN 
go

--METADATA NAME:P6PROJECTSPENDINGPLAN TYPE:SYNONYM TARGET_OBJECT:P6PROJECTSPENDINGPLAN CHANGE:CREATE
CREATE SYNONYM P6PROJECTSPENDINGPLAN FOR PROJECTSPENDINGPLAN_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTSPREAD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTSPREAD' and type='SN')
  DROP SYNONYM P6PROJECTSPREAD 
go

--METADATA NAME:P6PROJECTSPREAD TYPE:SYNONYM TARGET_OBJECT:P6PROJECTSPREAD CHANGE:CREATE
CREATE SYNONYM P6PROJECTSPREAD FOR PROJECTSPREAD_U
go
		
--METADATA  TYPE:SSCR NAME:P6RELATIONSHIP  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RELATIONSHIP' and type='SN')
  DROP SYNONYM P6RELATIONSHIP 
go

--METADATA NAME:P6RELATIONSHIP TYPE:SYNONYM TARGET_OBJECT:P6RELATIONSHIP CHANGE:CREATE
CREATE SYNONYM P6RELATIONSHIP FOR RELATIONSHIP_U
go
		
--METADATA  TYPE:SSCR NAME:P6RELEASE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RELEASE' and type='SN')
  DROP SYNONYM P6RELEASE 
go

--METADATA NAME:P6RELEASE TYPE:SYNONYM TARGET_OBJECT:P6RELEASE CHANGE:CREATE
CREATE SYNONYM P6RELEASE FOR RELEASE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RELEASEPROJECT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RELEASEPROJECT' and type='SN')
  DROP SYNONYM P6RELEASEPROJECT 
go

--METADATA NAME:P6RELEASEPROJECT TYPE:SYNONYM TARGET_OBJECT:P6RELEASEPROJECT CHANGE:CREATE
CREATE SYNONYM P6RELEASEPROJECT FOR RELEASEPROJECT_U
go
		
--METADATA  TYPE:SSCR NAME:P6RELEASEITERATION  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RELEASEITERATION' and type='SN')
  DROP SYNONYM P6RELEASEITERATION 
go

--METADATA NAME:P6RELEASEITERATION TYPE:SYNONYM TARGET_OBJECT:P6RELEASEITERATION CHANGE:CREATE
CREATE SYNONYM P6RELEASEITERATION FOR RELEASEITERATION_U
go
		
--METADATA  TYPE:SSCR NAME:P6REPORTDATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6REPORTDATE' and type='SN')
  DROP SYNONYM P6REPORTDATE 
go

--METADATA NAME:P6REPORTDATE TYPE:SYNONYM TARGET_OBJECT:P6REPORTDATE CHANGE:CREATE
CREATE SYNONYM P6REPORTDATE FOR REPORTDATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6REPORTTIME  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6REPORTTIME' and type='SN')
  DROP SYNONYM P6REPORTTIME 
go

--METADATA NAME:P6REPORTTIME TYPE:SYNONYM TARGET_OBJECT:P6REPORTTIME CHANGE:CREATE
CREATE SYNONYM P6REPORTTIME FOR REPORTTIME_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESASSIGNMENTPERIODACTUAL  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESASSIGNMENTPERIODACTUAL' and type='SN')
  DROP SYNONYM P6RESASSIGNMENTPERIODACTUAL 
go

--METADATA NAME:P6RESASSIGNMENTPERIODACTUAL TYPE:SYNONYM TARGET_OBJECT:P6RESASSIGNMENTPERIODACTUAL CHANGE:CREATE
CREATE SYNONYM P6RESASSIGNMENTPERIODACTUAL FOR RESASSIGNMENTPERIODACTUAL_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEACCESS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEACCESS' and type='SN')
  DROP SYNONYM P6RESOURCEACCESS 
go

--METADATA NAME:P6RESOURCEACCESS TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEACCESS CHANGE:CREATE
CREATE SYNONYM P6RESOURCEACCESS FOR RESOURCEACCESS_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEASSIGNMENT' and type='SN')
  DROP SYNONYM P6RESOURCEASSIGNMENT 
go

--METADATA NAME:P6RESOURCEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6RESOURCEASSIGNMENT FOR RESOURCEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODE' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODE 
go

--METADATA NAME:P6ASSIGNMENTCODE TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODE CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODE FOR ASSIGNMENTCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODE_S' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODE_S 
go

--METADATA NAME:P6ASSIGNMENTCODE_S TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODE_S CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODE_S FOR ASSIGNMENTCODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODETYPE' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODETYPE 
go

--METADATA NAME:P6ASSIGNMENTCODETYPE TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODETYPE CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODETYPE FOR ASSIGNMENTCODETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODETYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODETYPE_S' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODETYPE_S 
go

--METADATA NAME:P6ASSIGNMENTCODETYPE_S TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODETYPE_S CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODETYPE_S FOR ASSIGNMENTCODETYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODEASSIGNMENT' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODEASSIGNMENT 
go

--METADATA NAME:P6ASSIGNMENTCODEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODEASSIGNMENT FOR ASSIGNMENTCODEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ASSIGNMENTCODEASSIGNMENT_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ASSIGNMENTCODEASSIGNMENT_S' and type='SN')
  DROP SYNONYM P6ASSIGNMENTCODEASSIGNMENT_S 
go

--METADATA NAME:P6ASSIGNMENTCODEASSIGNMENT_S TYPE:SYNONYM TARGET_OBJECT:P6ASSIGNMENTCODEASSIGNMENT_S CHANGE:CREATE
CREATE SYNONYM P6ASSIGNMENTCODEASSIGNMENT_S FOR ASSIGNMENTCODEASSIGNMENT_S
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODE' and type='SN')
  DROP SYNONYM P6RESOURCECODE 
go

--METADATA NAME:P6RESOURCECODE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODE CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODE FOR RESOURCECODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODE_S' and type='SN')
  DROP SYNONYM P6RESOURCECODE_S 
go

--METADATA NAME:P6RESOURCECODE_S TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODE_S CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODE_S FOR RESOURCECODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODEASSIGNMENT' and type='SN')
  DROP SYNONYM P6RESOURCECODEASSIGNMENT 
go

--METADATA NAME:P6RESOURCECODEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODEASSIGNMENT FOR RESOURCECODEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODEASSIGNMENT_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODEASSIGNMENT_S' and type='SN')
  DROP SYNONYM P6RESOURCECODEASSIGNMENT_S 
go

--METADATA NAME:P6RESOURCECODEASSIGNMENT_S TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODEASSIGNMENT_S CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODEASSIGNMENT_S FOR RESOURCECODEASSIGNMENT_S
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODEHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODEHIERARCHY' and type='SN')
  DROP SYNONYM P6RESOURCECODEHIERARCHY 
go

--METADATA NAME:P6RESOURCECODEHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODEHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODEHIERARCHY FOR RESOURCECODEHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODEHIERARCHY_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODEHIERARCHY_S' and type='SN')
  DROP SYNONYM P6RESOURCECODEHIERARCHY_S 
go

--METADATA NAME:P6RESOURCECODEHIERARCHY_S TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODEHIERARCHY_S CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODEHIERARCHY_S FOR RESOURCECODEHIERARCHY_S
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODETYPE' and type='SN')
  DROP SYNONYM P6RESOURCECODETYPE 
go

--METADATA NAME:P6RESOURCECODETYPE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODETYPE CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODETYPE FOR RESOURCECODETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECODETYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECODETYPE_S' and type='SN')
  DROP SYNONYM P6RESOURCECODETYPE_S 
go

--METADATA NAME:P6RESOURCECODETYPE_S TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECODETYPE_S CHANGE:CREATE
CREATE SYNONYM P6RESOURCECODETYPE_S FOR RESOURCECODETYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCECURVE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCECURVE' and type='SN')
  DROP SYNONYM P6RESOURCECURVE 
go

--METADATA NAME:P6RESOURCECURVE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCECURVE CHANGE:CREATE
CREATE SYNONYM P6RESOURCECURVE FOR RESOURCECURVE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEHIERARCHY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEHIERARCHY' and type='SN')
  DROP SYNONYM P6RESOURCEHIERARCHY 
go

--METADATA NAME:P6RESOURCEHIERARCHY TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEHIERARCHY CHANGE:CREATE
CREATE SYNONYM P6RESOURCEHIERARCHY FOR RESOURCEHIERARCHY_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEHOUR  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEHOUR' and type='SN')
  DROP SYNONYM P6RESOURCEHOUR 
go

--METADATA NAME:P6RESOURCEHOUR TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEHOUR CHANGE:CREATE
CREATE SYNONYM P6RESOURCEHOUR FOR RESOURCEHOUR_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCERATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCERATE' and type='SN')
  DROP SYNONYM P6RESOURCERATE 
go

--METADATA NAME:P6RESOURCERATE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCERATE CHANGE:CREATE
CREATE SYNONYM P6RESOURCERATE FOR RESOURCERATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCERESOURCETEAM  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCERESOURCETEAM' and type='SN')
  DROP SYNONYM P6RESOURCERESOURCETEAM 
go

--METADATA NAME:P6RESOURCERESOURCETEAM TYPE:SYNONYM TARGET_OBJECT:P6RESOURCERESOURCETEAM CHANGE:CREATE
CREATE SYNONYM P6RESOURCERESOURCETEAM FOR RESOURCERESOURCETEAM_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCEROLE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCEROLE' and type='SN')
  DROP SYNONYM P6RESOURCEROLE 
go

--METADATA NAME:P6RESOURCEROLE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCEROLE CHANGE:CREATE
CREATE SYNONYM P6RESOURCEROLE FOR RESOURCEROLE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCES  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCES' and type='SN')
  DROP SYNONYM P6RESOURCES 
go

--METADATA NAME:P6RESOURCES TYPE:SYNONYM TARGET_OBJECT:P6RESOURCES CHANGE:CREATE
CREATE SYNONYM P6RESOURCES FOR RESOURCES_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCELOCATION  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCELOCATION' and type='SN')
  DROP SYNONYM P6RESOURCELOCATION 
go

--METADATA NAME:P6RESOURCELOCATION TYPE:SYNONYM TARGET_OBJECT:P6RESOURCELOCATION CHANGE:CREATE
CREATE SYNONYM P6RESOURCELOCATION FOR RESOURCELOCATION_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCETEAM  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCETEAM' and type='SN')
  DROP SYNONYM P6RESOURCETEAM 
go

--METADATA NAME:P6RESOURCETEAM TYPE:SYNONYM TARGET_OBJECT:P6RESOURCETEAM CHANGE:CREATE
CREATE SYNONYM P6RESOURCETEAM FOR RESOURCETEAM_U
go
		
--METADATA  TYPE:SSCR NAME:P6RISKTYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RISKTYPE' and type='SN')
  DROP SYNONYM P6RISKTYPE 
go

--METADATA NAME:P6RISKTYPE TYPE:SYNONYM TARGET_OBJECT:P6RISKTYPE CHANGE:CREATE
CREATE SYNONYM P6RISKTYPE FOR RISKTYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLE' and type='SN')
  DROP SYNONYM P6ROLE 
go

--METADATA NAME:P6ROLE TYPE:SYNONYM TARGET_OBJECT:P6ROLE CHANGE:CREATE
CREATE SYNONYM P6ROLE FOR ROLE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODE' and type='SN')
  DROP SYNONYM P6ROLECODE 
go

--METADATA NAME:P6ROLECODE TYPE:SYNONYM TARGET_OBJECT:P6ROLECODE CHANGE:CREATE
CREATE SYNONYM P6ROLECODE FOR ROLECODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODE_S' and type='SN')
  DROP SYNONYM P6ROLECODE_S 
go

--METADATA NAME:P6ROLECODE_S TYPE:SYNONYM TARGET_OBJECT:P6ROLECODE_S CHANGE:CREATE
CREATE SYNONYM P6ROLECODE_S FOR ROLECODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODETYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODETYPE' and type='SN')
  DROP SYNONYM P6ROLECODETYPE 
go

--METADATA NAME:P6ROLECODETYPE TYPE:SYNONYM TARGET_OBJECT:P6ROLECODETYPE CHANGE:CREATE
CREATE SYNONYM P6ROLECODETYPE FOR ROLECODETYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODETYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODETYPE_S' and type='SN')
  DROP SYNONYM P6ROLECODETYPE_S 
go

--METADATA NAME:P6ROLECODETYPE_S TYPE:SYNONYM TARGET_OBJECT:P6ROLECODETYPE_S CHANGE:CREATE
CREATE SYNONYM P6ROLECODETYPE_S FOR ROLECODETYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODEASSIGNMENT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODEASSIGNMENT' and type='SN')
  DROP SYNONYM P6ROLECODEASSIGNMENT 
go

--METADATA NAME:P6ROLECODEASSIGNMENT TYPE:SYNONYM TARGET_OBJECT:P6ROLECODEASSIGNMENT CHANGE:CREATE
CREATE SYNONYM P6ROLECODEASSIGNMENT FOR ROLECODEASSIGNMENT_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLECODEASSIGNMENT_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLECODEASSIGNMENT_S' and type='SN')
  DROP SYNONYM P6ROLECODEASSIGNMENT_S 
go

--METADATA NAME:P6ROLECODEASSIGNMENT_S TYPE:SYNONYM TARGET_OBJECT:P6ROLECODEASSIGNMENT_S CHANGE:CREATE
CREATE SYNONYM P6ROLECODEASSIGNMENT_S FOR ROLECODEASSIGNMENT_S
go
		
--METADATA  TYPE:SSCR NAME:P6ROLERATE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLERATE' and type='SN')
  DROP SYNONYM P6ROLERATE 
go

--METADATA NAME:P6ROLERATE TYPE:SYNONYM TARGET_OBJECT:P6ROLERATE CHANGE:CREATE
CREATE SYNONYM P6ROLERATE FOR ROLERATE_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLEROLETEAM  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLEROLETEAM' and type='SN')
  DROP SYNONYM P6ROLEROLETEAM 
go

--METADATA NAME:P6ROLEROLETEAM TYPE:SYNONYM TARGET_OBJECT:P6ROLEROLETEAM CHANGE:CREATE
CREATE SYNONYM P6ROLEROLETEAM FOR ROLEROLETEAM_U
go
		
--METADATA  TYPE:SSCR NAME:P6ROLETEAM  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6ROLETEAM' and type='SN')
  DROP SYNONYM P6ROLETEAM 
go

--METADATA NAME:P6ROLETEAM TYPE:SYNONYM TARGET_OBJECT:P6ROLETEAM CHANGE:CREATE
CREATE SYNONYM P6ROLETEAM FOR ROLETEAM_U
go
		
--METADATA  TYPE:SSCR NAME:P6SHIFT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6SHIFT' and type='SN')
  DROP SYNONYM P6SHIFT 
go

--METADATA NAME:P6SHIFT TYPE:SYNONYM TARGET_OBJECT:P6SHIFT CHANGE:CREATE
CREATE SYNONYM P6SHIFT FOR SHIFT_U
go
		
--METADATA  TYPE:SSCR NAME:P6SHIFTPERIOD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6SHIFTPERIOD' and type='SN')
  DROP SYNONYM P6SHIFTPERIOD 
go

--METADATA NAME:P6SHIFTPERIOD TYPE:SYNONYM TARGET_OBJECT:P6SHIFTPERIOD CHANGE:CREATE
CREATE SYNONYM P6SHIFTPERIOD FOR SHIFTPERIOD_U
go
		
--METADATA  TYPE:SSCR NAME:P6SNAPSHOT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6SNAPSHOT' and type='SN')
  DROP SYNONYM P6SNAPSHOT 
go

--METADATA NAME:P6SNAPSHOT TYPE:SYNONYM TARGET_OBJECT:P6SNAPSHOT CHANGE:CREATE
CREATE SYNONYM P6SNAPSHOT FOR SNAPSHOT_U
go
		
--METADATA  TYPE:SSCR NAME:P6SNAPSHOTGROUP  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6SNAPSHOTGROUP' and type='SN')
  DROP SYNONYM P6SNAPSHOTGROUP 
go

--METADATA NAME:P6SNAPSHOTGROUP TYPE:SYNONYM TARGET_OBJECT:P6SNAPSHOTGROUP CHANGE:CREATE
CREATE SYNONYM P6SNAPSHOTGROUP FOR SNAPSHOTGROUP_U
go
		
--METADATA  TYPE:SSCR NAME:P6SNAPSHOTPROJECT  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6SNAPSHOTPROJECT' and type='SN')
  DROP SYNONYM P6SNAPSHOTPROJECT 
go

--METADATA NAME:P6SNAPSHOTPROJECT TYPE:SYNONYM TARGET_OBJECT:P6SNAPSHOTPROJECT CHANGE:CREATE
CREATE SYNONYM P6SNAPSHOTPROJECT FOR SNAPSHOTPROJECT_U
go
		
--METADATA  TYPE:SSCR NAME:P6TIMESHEET  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6TIMESHEET' and type='SN')
  DROP SYNONYM P6TIMESHEET 
go

--METADATA NAME:P6TIMESHEET TYPE:SYNONYM TARGET_OBJECT:P6TIMESHEET CHANGE:CREATE
CREATE SYNONYM P6TIMESHEET FOR TIMESHEET_U
go
		
--METADATA  TYPE:SSCR NAME:P6TIMESHEETPERIOD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6TIMESHEETPERIOD' and type='SN')
  DROP SYNONYM P6TIMESHEETPERIOD 
go

--METADATA NAME:P6TIMESHEETPERIOD TYPE:SYNONYM TARGET_OBJECT:P6TIMESHEETPERIOD CHANGE:CREATE
CREATE SYNONYM P6TIMESHEETPERIOD FOR TIMESHEETPERIOD_U
go
		
--METADATA  TYPE:SSCR NAME:P6UDFCODE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6UDFCODE' and type='SN')
  DROP SYNONYM P6UDFCODE 
go

--METADATA NAME:P6UDFCODE TYPE:SYNONYM TARGET_OBJECT:P6UDFCODE CHANGE:CREATE
CREATE SYNONYM P6UDFCODE FOR UDFCODE_U
go
		
--METADATA  TYPE:SSCR NAME:P6UDFCODE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6UDFCODE_S' and type='SN')
  DROP SYNONYM P6UDFCODE_S 
go

--METADATA NAME:P6UDFCODE_S TYPE:SYNONYM TARGET_OBJECT:P6UDFCODE_S CHANGE:CREATE
CREATE SYNONYM P6UDFCODE_S FOR UDFCODE_S
go
		
--METADATA  TYPE:SSCR NAME:P6UDFTYPE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6UDFTYPE' and type='SN')
  DROP SYNONYM P6UDFTYPE 
go

--METADATA NAME:P6UDFTYPE TYPE:SYNONYM TARGET_OBJECT:P6UDFTYPE CHANGE:CREATE
CREATE SYNONYM P6UDFTYPE FOR UDFTYPE_U
go
		
--METADATA  TYPE:SSCR NAME:P6UDFTYPE_S  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6UDFTYPE_S' and type='SN')
  DROP SYNONYM P6UDFTYPE_S 
go

--METADATA NAME:P6UDFTYPE_S TYPE:SYNONYM TARGET_OBJECT:P6UDFTYPE_S CHANGE:CREATE
CREATE SYNONYM P6UDFTYPE_S FOR UDFTYPE_S
go
		
--METADATA  TYPE:SSCR NAME:P6UNITOFMEASURE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6UNITOFMEASURE' and type='SN')
  DROP SYNONYM P6UNITOFMEASURE 
go

--METADATA NAME:P6UNITOFMEASURE TYPE:SYNONYM TARGET_OBJECT:P6UNITOFMEASURE CHANGE:CREATE
CREATE SYNONYM P6UNITOFMEASURE FOR UNITOFMEASURE_U
go
		
--METADATA  TYPE:SSCR NAME:P6USERMODULEACCESS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USERMODULEACCESS' and type='SN')
  DROP SYNONYM P6USERMODULEACCESS 
go

--METADATA NAME:P6USERMODULEACCESS TYPE:SYNONYM TARGET_OBJECT:P6USERMODULEACCESS CHANGE:CREATE
CREATE SYNONYM P6USERMODULEACCESS FOR USERMODULEACCESS_U
go
		
--METADATA  TYPE:SSCR NAME:P6USEROBS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USEROBS' and type='SN')
  DROP SYNONYM P6USEROBS 
go

--METADATA NAME:P6USEROBS TYPE:SYNONYM TARGET_OBJECT:P6USEROBS CHANGE:CREATE
CREATE SYNONYM P6USEROBS FOR USEROBS_U
go
		
--METADATA  TYPE:SSCR NAME:P6USERPROFILEPRIVILEGE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USERPROFILEPRIVILEGE' and type='SN')
  DROP SYNONYM P6USERPROFILEPRIVILEGE 
go

--METADATA NAME:P6USERPROFILEPRIVILEGE TYPE:SYNONYM TARGET_OBJECT:P6USERPROFILEPRIVILEGE CHANGE:CREATE
CREATE SYNONYM P6USERPROFILEPRIVILEGE FOR USERPROFILEPRIVILEGE_U
go
		
--METADATA  TYPE:SSCR NAME:P6USERS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6USERS' and type='SN')
  DROP SYNONYM P6USERS 
go

--METADATA NAME:P6USERS TYPE:SYNONYM TARGET_OBJECT:P6USERS CHANGE:CREATE
CREATE SYNONYM P6USERS FOR USERS_U
go
		
--METADATA  TYPE:SSCR NAME:P6WBS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBS' and type='SN')
  DROP SYNONYM P6WBS 
go

--METADATA NAME:P6WBS TYPE:SYNONYM TARGET_OBJECT:P6WBS CHANGE:CREATE
CREATE SYNONYM P6WBS FOR WBS_U
go
		
--METADATA  TYPE:SSCR NAME:P6BLWBS  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6BLWBS' and type='SN')
  DROP SYNONYM P6BLWBS 
go

--METADATA NAME:P6BLWBS TYPE:SYNONYM TARGET_OBJECT:P6BLWBS CHANGE:CREATE
CREATE SYNONYM P6BLWBS FOR BLWBS_U
go
		
--METADATA  TYPE:SSCR NAME:P6WBSCATEGORY  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSCATEGORY' and type='SN')
  DROP SYNONYM P6WBSCATEGORY 
go

--METADATA NAME:P6WBSCATEGORY TYPE:SYNONYM TARGET_OBJECT:P6WBSCATEGORY CHANGE:CREATE
CREATE SYNONYM P6WBSCATEGORY FOR WBSCATEGORY_U
go
		
--METADATA  TYPE:SSCR NAME:P6WBSMILESTONE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSMILESTONE' and type='SN')
  DROP SYNONYM P6WBSMILESTONE 
go

--METADATA NAME:P6WBSMILESTONE TYPE:SYNONYM TARGET_OBJECT:P6WBSMILESTONE CHANGE:CREATE
CREATE SYNONYM P6WBSMILESTONE FOR WBSMILESTONE_U
go
		
--METADATA  TYPE:SSCR NAME:P6WBSSPREAD  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6WBSSPREAD' and type='SN')
  DROP SYNONYM P6WBSSPREAD 
go

--METADATA NAME:P6WBSSPREAD TYPE:SYNONYM TARGET_OBJECT:P6WBSSPREAD CHANGE:CREATE
CREATE SYNONYM P6WBSSPREAD FOR WBSSPREAD_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECTETLLIST  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECTETLLIST' and type='SN')
  DROP SYNONYM P6PROJECTETLLIST 
go

--METADATA NAME:P6PROJECTETLLIST TYPE:SYNONYM TARGET_OBJECT:P6PROJECTETLLIST CHANGE:CREATE
CREATE SYNONYM P6PROJECTETLLIST FOR PROJECTETLLIST_U
go
		
--METADATA  TYPE:SSCR NAME:P6PROJECT_UDFVALUE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6PROJECT_UDFVALUE' and type='SN')
  DROP SYNONYM P6PROJECT_UDFVALUE 
go

--METADATA NAME:P6PROJECT_UDFVALUE TYPE:SYNONYM TARGET_OBJECT:P6PROJECT_UDFVALUE CHANGE:CREATE
CREATE SYNONYM P6PROJECT_UDFVALUE FOR PROJECT_UDFVALUE_U
go
		
--METADATA  TYPE:SSCR NAME:P6RESOURCE_UDFVALUE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6RESOURCE_UDFVALUE' and type='SN')
  DROP SYNONYM P6RESOURCE_UDFVALUE 
go

--METADATA NAME:P6RESOURCE_UDFVALUE TYPE:SYNONYM TARGET_OBJECT:P6RESOURCE_UDFVALUE CHANGE:CREATE
CREATE SYNONYM P6RESOURCE_UDFVALUE FOR RESOURCE_UDFVALUE_U
go
		
--METADATA  TYPE:SSCR NAME:P6GLOBAL_UDFVALUE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'P6GLOBAL_UDFVALUE' and type='SN')
  DROP SYNONYM P6GLOBAL_UDFVALUE 
go

--METADATA NAME:P6GLOBAL_UDFVALUE TYPE:SYNONYM TARGET_OBJECT:P6GLOBAL_UDFVALUE CHANGE:CREATE
CREATE SYNONYM P6GLOBAL_UDFVALUE FOR GLOBAL_UDFVALUE_U
go
		

--METADATA  TYPE:SSCR NAME:p6BASELINE  OBJECT_TYPE:SYNONYM
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'p6BASELINE' and type='SN')
  DROP SYNONYM p6BASELINE 
go

--METADATA NAME:p6BASELINE TYPE:SYNONYM TARGET_OBJECT:p6BASELINE CHANGE:CREATE
CREATE SYNONYM p6BASELINE FOR BASELINE_u
go
		
