--METADATA NAME:dbtk_ss_create_database TYPE:EXEC
DECLARE @default_data_path nvarchar(256)
SET @default_data_path = (SELECT SUBSTRING(physical_name, 1, CHARINDEX(N'master.mdf', LOWER(physical_name)) - 1)
				  FROM master.sys.master_files
				  WHERE database_id = 1 AND file_id = 1);
DECLARE @DB_NAME sysname, @DB_DATA_PATH sysname, @DB_LOG_PATH sysname, @DB_CODEPAGE sysname

set @DB_NAME='${pm.ss.database_name}';
if len(@DB_NAME)=0 or patindex('%${%',@DB_NAME) >0 
  SET @DB_NAME='PMDB'

if ( select count(*) from master..sysdatabases where name = @DB_NAME ) > 0
begin
return
end

set @DB_DATA_PATH='${pm.ss.data_path}';
if len(@DB_DATA_PATH)=0 or patindex('%${%',@DB_DATA_PATH) >0 
  SET @DB_DATA_PATH=@default_data_path + @DB_NAME + '.mdf'
set @DB_LOG_PATH='${pm.ss.log_path}';
if len(@DB_LOG_PATH)=0 or patindex('%${%',@DB_LOG_PATH) >0 
  SET @DB_LOG_PATH=@default_data_path + @DB_NAME + '.ldf'

DECLARE @CDB nvarchar(4000)

set @CDB='CREATE DATABASE ' +  @DB_NAME+ 
' ON 
( NAME = ' + @DB_NAME + '_dat,
	FILENAME = '''+ @DB_DATA_PATH + ''',
	SIZE = 10MB,
	MAXSIZE = UNLIMITED,
	FILEGROWTH = 5mb )
LOG ON
( NAME = '+ @DB_NAME +'_log,
	FILENAME = '''+ @DB_LOG_PATH + ''',
	SIZE = 5MB,
	MAXSIZE = UNLIMITED,
	FILEGROWTH = 5MB )' 

set @DB_CODEPAGE='${pm.ss.codepage}';
if len(@DB_CODEPAGE)>0 and patindex('%${%',@DB_CODEPAGE) =0 
  SET @CDB=@CDB + ' COLLATE ' + @DB_CODEPAGE + '_CI_AS'

print 'Creating: ' + @CDB
EXEC (@CDB)
go

--METADATA NAME:dbtk_ss_change_isolation_level TYPE:EXEC
DECLARE @DB_NAME sysname
DECLARE @SQLST nvarchar(4000)
set @DB_NAME='${pm.ss.database_name}'

if len(@DB_NAME)=0 or patindex('%${%',@DB_NAME) >0 
  SET @DB_NAME='PMDB'

SET @SQLST = 'alter database ' + @DB_NAME + ' set read_committed_snapshot on'
EXEC (@SQLST)
go
