--METADATA NAME:dbtk_or_set_currency TYPE:EXEC
Declare
v_curr_rate CURRTYPE.base_exch_rate%TYPE;
v_old_curr_id CURRTYPE.curr_id%TYPE;
v_new_curr_id CURRTYPE.curr_id%TYPE;
v_existing_base_currency varchar2(25);
v_new_base_currency varchar2(25);
begin
v_existing_base_currency := 'USD';
v_new_base_currency := 'USD';
if (v_existing_base_currency <> v_new_base_currency) then
    select base_exch_rate, curr_id
      into v_curr_rate, v_new_curr_id
      from currtype
     where curr_short_name = v_new_base_currency;
    select curr_id
      into v_old_curr_id
      from currtype
     where curr_short_name = v_existing_base_currency;
    update currtype
       set curr_id = v_new_curr_id
     where curr_id = v_old_curr_id;
    update currtype
       set curr_id = v_old_curr_id
     where curr_short_name = v_new_base_currency;
    update currtype set base_exch_rate = base_exch_rate / v_curr_rate;
  end if;
exception 
 when NO_DATA_FOUND then
      dbms_output.put_line('Specified currency does not exist');
 when OTHERS then 
      dbms_output.put_line(SQLERRM);
end;
/

--Run Script as ADMUSER    
SET DEFINE OFF

--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('LOCATION', 'GEO_LOCATION', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_location_geo_location TYPE:INDEX TABLE_NAME:LOCATION CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_location_geo_location
ON location (geo_location)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  
prompt Creating constraint pk_account on table ACCOUNT


--METADATA NAME:pk_account TYPE:CONSTRAINT TABLE_NAME:ACCOUNT CHANGE:CREATE
ALTER TABLE ACCOUNT
ADD CONSTRAINT pk_account PRIMARY KEY (acct_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_actvcode on table ACTVCODE


--METADATA NAME:pk_actvcode TYPE:CONSTRAINT TABLE_NAME:ACTVCODE CHANGE:CREATE
ALTER TABLE ACTVCODE
ADD CONSTRAINT pk_actvcode PRIMARY KEY (actv_code_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_actvtype on table ACTVTYPE


--METADATA NAME:pk_actvtype TYPE:CONSTRAINT TABLE_NAME:ACTVTYPE CHANGE:CREATE
ALTER TABLE ACTVTYPE
ADD CONSTRAINT pk_actvtype PRIMARY KEY (actv_code_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_admin_config on table ADMIN_CONFIG


--METADATA NAME:pk_admin_config TYPE:CONSTRAINT TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
ALTER TABLE ADMIN_CONFIG
ADD CONSTRAINT pk_admin_config PRIMARY KEY (config_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_asgnmntacat on table ASGNMNTACAT


--METADATA NAME:pk_asgnmntacat TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_asgnmntcattype on table ASGNMNTCATTYPE


--METADATA NAME:pk_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
ALTER TABLE ASGNMNTCATTYPE
ADD CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_asgnmntcatval on table ASGNMNTCATVAL


--METADATA NAME:pk_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_basetype on table BASETYPE


--METADATA NAME:pk_basetype TYPE:CONSTRAINT TABLE_NAME:BASETYPE CHANGE:CREATE
ALTER TABLE BASETYPE
ADD CONSTRAINT pk_basetype PRIMARY KEY (base_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_bre_registry on table BRE_REGISTRY


--METADATA NAME:pk_bre_registry TYPE:CONSTRAINT TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
ALTER TABLE BRE_REGISTRY
ADD CONSTRAINT pk_bre_registry PRIMARY KEY (bre_registry_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_budgchng on table BUDGCHNG


--METADATA NAME:pk_budgchng TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT pk_budgchng PRIMARY KEY (budg_chng_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_calendar on table CALENDAR


--METADATA NAME:pk_calendar TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT pk_calendar PRIMARY KEY (clndr_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_costtype on table COSTTYPE


--METADATA NAME:pk_costtype TYPE:CONSTRAINT TABLE_NAME:COSTTYPE CHANGE:CREATE
ALTER TABLE COSTTYPE
ADD CONSTRAINT pk_costtype PRIMARY KEY (cost_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_currtype on table CURRTYPE


--METADATA NAME:pk_currtype TYPE:CONSTRAINT TABLE_NAME:CURRTYPE CHANGE:CREATE
ALTER TABLE CURRTYPE
ADD CONSTRAINT pk_currtype PRIMARY KEY (curr_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_dashboard on table DASHBOARD


--METADATA NAME:pk_dashboard TYPE:CONSTRAINT TABLE_NAME:DASHBOARD CHANGE:CREATE
ALTER TABLE DASHBOARD
ADD CONSTRAINT pk_dashboard PRIMARY KEY (dashboard_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_dashuser on table DASHUSER


--METADATA NAME:pk_dashuser TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT pk_dashuser PRIMARY KEY (dashboard_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_discussion on table DISCUSSION


--METADATA NAME:pk_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_discussion_read on table DISCUSSION_READ


--METADATA NAME:pk_discussion_read TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_doccatg on table DOCCATG


--METADATA NAME:pk_doccatg TYPE:CONSTRAINT TABLE_NAME:DOCCATG CHANGE:CREATE
ALTER TABLE DOCCATG
ADD CONSTRAINT pk_doccatg PRIMARY KEY (doc_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_docreview on table DOCREVIEW


--METADATA NAME:pk_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_docreviewtask on table DOCREVIEWTASK


--METADATA NAME:pk_docreviewtask TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_docstat on table DOCSTAT


--METADATA NAME:pk_docstat TYPE:CONSTRAINT TABLE_NAME:DOCSTAT CHANGE:CREATE
ALTER TABLE DOCSTAT
ADD CONSTRAINT pk_docstat PRIMARY KEY (doc_status_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_document on table DOCUMENT


--METADATA NAME:pk_document TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT pk_document PRIMARY KEY (doc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_expproj on table EXPPROJ


--METADATA NAME:pk_expproj TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT pk_expproj PRIMARY KEY (proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_extapp on table EXTAPP


--METADATA NAME:pk_extapp TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT pk_extapp PRIMARY KEY (app_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_factor on table FACTOR


--METADATA NAME:pk_factor TYPE:CONSTRAINT TABLE_NAME:FACTOR CHANGE:CREATE
ALTER TABLE FACTOR
ADD CONSTRAINT pk_factor PRIMARY KEY (fact_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_factval on table FACTVAL


--METADATA NAME:pk_factval TYPE:CONSTRAINT TABLE_NAME:FACTVAL CHANGE:CREATE
ALTER TABLE FACTVAL
ADD CONSTRAINT pk_factval PRIMARY KEY (fact_val_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_filtprop on table FILTPROP


--METADATA NAME:pk_filtprop TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT pk_filtprop PRIMARY KEY (filter_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_findates on table FINDATES


--METADATA NAME:pk_findates TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT pk_findates PRIMARY KEY (fin_dates_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_fintmpl on table FINTMPL


--METADATA NAME:pk_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINTMPL CHANGE:CREATE
ALTER TABLE FINTMPL
ADD CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_formcatg on table FORMCATG


--METADATA NAME:pk_formcatg TYPE:CONSTRAINT TABLE_NAME:FORMCATG CHANGE:CREATE
ALTER TABLE FORMCATG
ADD CONSTRAINT pk_formcatg PRIMARY KEY (form_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_formproj on table FORMPROJ


--METADATA NAME:pk_formproj TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT pk_formproj PRIMARY KEY (form_tmpl_id,proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_formtmpl on table FORMTMPL


--METADATA NAME:pk_formtmpl TYPE:CONSTRAINT TABLE_NAME:FORMTMPL CHANGE:CREATE
ALTER TABLE FORMTMPL
ADD CONSTRAINT pk_formtmpl PRIMARY KEY (form_tmpl_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_fundsrc on table FUNDSRC


--METADATA NAME:pk_fundsrc TYPE:CONSTRAINT TABLE_NAME:FUNDSRC CHANGE:CREATE
ALTER TABLE FUNDSRC
ADD CONSTRAINT pk_fundsrc PRIMARY KEY (fund_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_gchange_id on table GCHANGE


--METADATA NAME:pk_gchange_id TYPE:CONSTRAINT TABLE_NAME:GCHANGE CHANGE:CREATE
ALTER TABLE GCHANGE
ADD CONSTRAINT pk_gchange_id PRIMARY KEY (gchange_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_hqdata on table HQDATA


--METADATA NAME:pk_hqdata TYPE:CONSTRAINT TABLE_NAME:HQDATA CHANGE:CREATE
ALTER TABLE HQDATA
ADD CONSTRAINT pk_hqdata PRIMARY KEY (session_id,context_id,fk_id,value)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 5M next 5M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_hquery on table HQUERY


--METADATA NAME:pk_hquery TYPE:CONSTRAINT TABLE_NAME:HQUERY CHANGE:CREATE
ALTER TABLE HQUERY
ADD CONSTRAINT pk_hquery PRIMARY KEY (session_id,context_id,fk_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 5M next 5M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_imagedata on table IMAGEDATA


--METADATA NAME:pk_imagedata TYPE:CONSTRAINT TABLE_NAME:IMAGEDATA CHANGE:CREATE
ALTER TABLE IMAGEDATA
ADD CONSTRAINT pk_imagedata PRIMARY KEY (image_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_issuhist on table ISSUHIST


--METADATA NAME:pk_issuhist TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT pk_issuhist PRIMARY KEY (issue_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_iteration on table ITERATION


--METADATA NAME:pk_iteration TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:CREATE
ALTER TABLE ITERATION
ADD CONSTRAINT pk_iteration PRIMARY KEY (iteration_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 64K next 64K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_iterdays on table ITERDAYS


--METADATA NAME:pk_iterdays TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT pk_iterdays PRIMARY KEY (task_id,day_number)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_itergoal on table ITERGOAL


--METADATA NAME:pk_itergoal TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT pk_itergoal PRIMARY KEY (iter_goal_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_joblog on table JOBLOG


--METADATA NAME:pk_joblog TYPE:CONSTRAINT TABLE_NAME:JOBLOG CHANGE:CREATE
ALTER TABLE JOBLOG
ADD CONSTRAINT pk_joblog PRIMARY KEY (job_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_jobrpt on table JOBRPT


--METADATA NAME:pk_jobrpt TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT pk_jobrpt PRIMARY KEY (job_id,rpt_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_jobsvc on table JOBSVC


--METADATA NAME:pk_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT pk_jobsvc PRIMARY KEY (job_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_location on table LOCATION


--METADATA NAME:pk_location TYPE:CONSTRAINT TABLE_NAME:LOCATION CHANGE:CREATE
ALTER TABLE LOCATION
ADD CONSTRAINT pk_location PRIMARY KEY (location_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_memotype on table MEMOTYPE


--METADATA NAME:pk_memotype TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT pk_memotype PRIMARY KEY (memo_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_nextkey on table NEXTKEY


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_nonwork on table NONWORK


--METADATA NAME:pk_nonwork TYPE:CONSTRAINT TABLE_NAME:NONWORK CHANGE:CREATE
ALTER TABLE NONWORK
ADD CONSTRAINT pk_nonwork PRIMARY KEY (nonwork_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_note on table NOTE


--METADATA NAME:pk_note TYPE:CONSTRAINT TABLE_NAME:NOTE CHANGE:CREATE
ALTER TABLE NOTE
ADD CONSTRAINT pk_note PRIMARY KEY (note_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_obs on table OBS


--METADATA NAME:pk_obs TYPE:CONSTRAINT TABLE_NAME:OBS CHANGE:CREATE
ALTER TABLE OBS
ADD CONSTRAINT pk_obs PRIMARY KEY (obs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_obsproj on table OBSPROJ


--METADATA NAME:pk_obsproj TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT pk_obsproj PRIMARY KEY (obs_id,proj_id,wbs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pcattype on table PCATTYPE


--METADATA NAME:pk_pcattype TYPE:CONSTRAINT TABLE_NAME:PCATTYPE CHANGE:CREATE
ALTER TABLE PCATTYPE
ADD CONSTRAINT pk_pcattype PRIMARY KEY (proj_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pcatuser on table PCATUSER


--METADATA NAME:pk_pcatuser TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT pk_pcatuser PRIMARY KEY (proj_catg_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pcatval on table PCATVAL


--METADATA NAME:pk_pcatval TYPE:CONSTRAINT TABLE_NAME:PCATVAL CHANGE:CREATE
ALTER TABLE PCATVAL
ADD CONSTRAINT pk_pcatval PRIMARY KEY (proj_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pfolio on table PFOLIO


--METADATA NAME:pk_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT pk_pfolio PRIMARY KEY (pfolio_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pfoliouser on table PFOLIOUSER


--METADATA NAME:pk_pfoliouser TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_phase on table PHASE


--METADATA NAME:pk_phase TYPE:CONSTRAINT TABLE_NAME:PHASE CHANGE:CREATE
ALTER TABLE PHASE
ADD CONSTRAINT pk_phase PRIMARY KEY (phase_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pobs on table POBS


--METADATA NAME:pk_pobs TYPE:CONSTRAINT TABLE_NAME:POBS CHANGE:CREATE
ALTER TABLE POBS
ADD CONSTRAINT pk_pobs PRIMARY KEY (pobs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_prefer on table PREFER


--METADATA NAME:pk_prefer TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT pk_prefer PRIMARY KEY (prefer_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 8K next 8K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_prmqueue on table PRMQUEUE


--METADATA NAME:pk_prmqueue TYPE:CONSTRAINT TABLE_NAME:PRMQUEUE CHANGE:CREATE
ALTER TABLE PRMQUEUE
ADD CONSTRAINT pk_prmqueue PRIMARY KEY (queue_name,msg_key,enqueue_date)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_procgroup on table PROCGROUP


--METADATA NAME:pk_procgroup TYPE:CONSTRAINT TABLE_NAME:PROCGROUP CHANGE:CREATE
ALTER TABLE PROCGROUP
ADD CONSTRAINT pk_procgroup PRIMARY KEY (proc_group_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_procitem on table PROCITEM


--METADATA NAME:pk_procitem TYPE:CONSTRAINT TABLE_NAME:PROCITEM CHANGE:CREATE
ALTER TABLE PROCITEM
ADD CONSTRAINT pk_procitem PRIMARY KEY (proc_item_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 64K next 64K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_profile on table PROFILE


--METADATA NAME:pk_profile TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT pk_profile PRIMARY KEY (prof_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_profpriv on table PROFPRIV


--METADATA NAME:pk_profpriv TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT pk_profpriv PRIMARY KEY (prof_id,priv_num)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projcost on table PROJCOST


--METADATA NAME:pk_projcost TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT pk_projcost PRIMARY KEY (cost_item_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_project on table PROJECT


--METADATA NAME:pk_project TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT pk_project PRIMARY KEY (proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projest on table PROJEST


--METADATA NAME:pk_projest TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT pk_projest PRIMARY KEY (proj_est_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projfund on table PROJFUND


--METADATA NAME:pk_projfund TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT pk_projfund PRIMARY KEY (proj_fund_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projissu on table PROJISSU


--METADATA NAME:pk_projissu TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT pk_projissu PRIMARY KEY (issue_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projpcat on table PROJPCAT


--METADATA NAME:pk_projpcat TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT pk_projpcat PRIMARY KEY (proj_id,proj_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projprop on table PROJPROP


--METADATA NAME:pk_projprop TYPE:CONSTRAINT TABLE_NAME:PROJPROP CHANGE:CREATE
ALTER TABLE PROJPROP
ADD CONSTRAINT pk_projprop PRIMARY KEY (proj_id,prop_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projrisk on table PROJRISK


--METADATA NAME:pk_projrisk TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK
ADD CONSTRAINT pk_projrisk PRIMARY KEY (risk_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projshar on table PROJSHAR


--METADATA NAME:pk_projshar TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT pk_projshar PRIMARY KEY (proj_id,session_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projthrs on table PROJTHRS


--METADATA NAME:pk_projthrs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT pk_projthrs PRIMARY KEY (thresh_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projwbs on table PROJWBS


--METADATA NAME:pk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT pk_projwbs PRIMARY KEY (wbs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_projwsrpt on table PROJWSRPT


--METADATA NAME:pk_projwsrpt TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT pk_projwsrpt PRIMARY KEY (rpt_id,proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_prpfolio on table PRPFOLIO


--METADATA NAME:pk_prpfolio TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT pk_prpfolio PRIMARY KEY (pfolio_id,wbs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_pubuser on table PUBUSER


--METADATA NAME:pk_pubuser TYPE:CONSTRAINT TABLE_NAME:PUBUSER CHANGE:CREATE
ALTER TABLE PUBUSER
ADD CONSTRAINT pk_pubuser PRIMARY KEY (public_group_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_querylib on table QUERYLIB


--METADATA NAME:pk_querylib TYPE:CONSTRAINT TABLE_NAME:QUERYLIB CHANGE:CREATE
ALTER TABLE QUERYLIB
ADD CONSTRAINT pk_querylib PRIMARY KEY (query_lib_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rcattype on table RCATTYPE


--METADATA NAME:pk_rcattype TYPE:CONSTRAINT TABLE_NAME:RCATTYPE CHANGE:CREATE
ALTER TABLE RCATTYPE
ADD CONSTRAINT pk_rcattype PRIMARY KEY (rsrc_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rcatval on table RCATVAL


--METADATA NAME:pk_rcatval TYPE:CONSTRAINT TABLE_NAME:RCATVAL CHANGE:CREATE
ALTER TABLE RCATVAL
ADD CONSTRAINT pk_rcatval PRIMARY KEY (rsrc_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_reittype on table REITTYPE


--METADATA NAME:pk_reittype TYPE:CONSTRAINT TABLE_NAME:REITTYPE CHANGE:CREATE
ALTER TABLE REITTYPE
ADD CONSTRAINT pk_reittype PRIMARY KEY (related_item_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 32K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_release on table RELEASE


--METADATA NAME:pk_release TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT pk_release PRIMARY KEY (release_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_relitems on table RELITEMS


--METADATA NAME:pk_relitems TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT pk_relitems PRIMARY KEY (item_type_id,fk_id,related_item_type_id,related_fk_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 2M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rfolio on table RFOLIO


--METADATA NAME:pk_rfolio TYPE:CONSTRAINT TABLE_NAME:RFOLIO CHANGE:CREATE
ALTER TABLE RFOLIO
ADD CONSTRAINT pk_rfolio PRIMARY KEY (rfolio_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_riskctrl on table RISKCTRL


--METADATA NAME:pk_riskctrl TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:CREATE
ALTER TABLE RISKCTRL
ADD CONSTRAINT pk_riskctrl PRIMARY KEY (risk_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_risktype on table RISKTYPE


--METADATA NAME:pk_risktype TYPE:CONSTRAINT TABLE_NAME:RISKTYPE CHANGE:CREATE
ALTER TABLE RISKTYPE
ADD CONSTRAINT pk_risktype PRIMARY KEY (risk_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rlfolio_id on table RLFOLIO


--METADATA NAME:pk_rlfolio_id TYPE:CONSTRAINT TABLE_NAME:RLFOLIO CHANGE:CREATE
ALTER TABLE RLFOLIO
ADD CONSTRAINT pk_rlfolio_id PRIMARY KEY (rlfolio_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolecattype on table ROLECATTYPE


--METADATA NAME:pk_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATTYPE CHANGE:CREATE
ALTER TABLE ROLECATTYPE
ADD CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolecatval on table ROLECATVAL


--METADATA NAME:pk_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolelimit on table ROLELIMIT


--METADATA NAME:pk_rolelimit TYPE:CONSTRAINT TABLE_NAME:ROLELIMIT CHANGE:CREATE
ALTER TABLE ROLELIMIT
ADD CONSTRAINT pk_rolelimit PRIMARY KEY (rolelimit_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolerate on table ROLERATE


--METADATA NAME:pk_rolerate TYPE:CONSTRAINT TABLE_NAME:ROLERATE CHANGE:CREATE
ALTER TABLE ROLERATE
ADD CONSTRAINT pk_rolerate PRIMARY KEY (role_rate_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolercat on table ROLERCAT


--METADATA NAME:pk_rolercat TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_roles on table ROLES


--METADATA NAME:pk_roles TYPE:CONSTRAINT TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES
ADD CONSTRAINT pk_roles PRIMARY KEY (role_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 90K next 90K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rolfolio on table ROLFOLIO


--METADATA NAME:pk_rolfolio TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT pk_rolfolio PRIMARY KEY (rlfolio_id,role_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rpt on table RPT


--METADATA NAME:pk_rpt TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT pk_rpt PRIMARY KEY (rpt_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rptbatch on table RPTBATCH


--METADATA NAME:pk_rptbatch TYPE:CONSTRAINT TABLE_NAME:RPTBATCH CHANGE:CREATE
ALTER TABLE RPTBATCH
ADD CONSTRAINT pk_rptbatch PRIMARY KEY (rpt_batch_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rptgroup on table RPTGROUP


--METADATA NAME:pk_rptgroup TYPE:CONSTRAINT TABLE_NAME:RPTGROUP CHANGE:CREATE
ALTER TABLE RPTGROUP
ADD CONSTRAINT pk_rptgroup PRIMARY KEY (rpt_group_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rptlist on table RPTLIST


--METADATA NAME:pk_rptlist TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT pk_rptlist PRIMARY KEY (rpt_batch_id,rpt_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrc on table RSRC


--METADATA NAME:pk_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT pk_rsrc PRIMARY KEY (rsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcandash on table RSRCANDASH


--METADATA NAME:pk_rsrcandash TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT pk_rsrcandash PRIMARY KEY (dashboard_id,rsrcan_view_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcanview on table RSRCANVIEW


--METADATA NAME:pk_rsrcanview TYPE:CONSTRAINT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
ALTER TABLE RSRCANVIEW
ADD CONSTRAINT pk_rsrcanview PRIMARY KEY (rsrcan_view_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrccurv on table RSRCCURV


--METADATA NAME:pk_rsrccurv TYPE:CONSTRAINT TABLE_NAME:RSRCCURV CHANGE:CREATE
ALTER TABLE RSRCCURV
ADD CONSTRAINT pk_rsrccurv PRIMARY KEY (curv_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrchour on table RSRCHOUR


--METADATA NAME:pk_rsrchour TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT pk_rsrchour PRIMARY KEY (rsrc_hr_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 800K next 800K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcprop on table RSRCPROP


--METADATA NAME:pk_rsrcprop TYPE:CONSTRAINT TABLE_NAME:RSRCPROP CHANGE:CREATE
ALTER TABLE RSRCPROP
ADD CONSTRAINT pk_rsrcprop PRIMARY KEY (rsrc_id,prop_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcrate on table RSRCRATE


--METADATA NAME:pk_rsrcrate TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT pk_rsrcrate PRIMARY KEY (rsrc_rate_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcrcat on table RSRCRCAT


--METADATA NAME:pk_rsrcrcat TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT pk_rsrcrcat PRIMARY KEY (rsrc_id,rsrc_catg_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcrole on table RSRCROLE


--METADATA NAME:pk_rsrcrole TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT pk_rsrcrole PRIMARY KEY (rsrc_id,role_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrcsec on table RSRCSEC


--METADATA NAME:pk_rsrcsec TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT pk_rsrcsec PRIMARY KEY (user_id,rsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_rsrfolio on table RSRFOLIO


--METADATA NAME:pk_rsrfolio TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT pk_rsrfolio PRIMARY KEY (rfolio_id,rsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_scenario on table SCENARIO


--METADATA NAME:pk_scenario TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT pk_scenario PRIMARY KEY (scenario_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_scenprog on table SCENPROJ


--METADATA NAME:pk_scenprog TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT pk_scenprog PRIMARY KEY (scenario_id,proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_scenrole on table SCENROLE


--METADATA NAME:pk_scenrole TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT pk_scenrole PRIMARY KEY (scenario_id,role_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_scenuser on table SCENUSER


--METADATA NAME:pk_scenuser TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT pk_scenuser PRIMARY KEY (scenario_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_settings on table SETTINGS


--METADATA NAME:pk_settings TYPE:CONSTRAINT TABLE_NAME:SETTINGS CHANGE:CREATE
ALTER TABLE SETTINGS
ADD CONSTRAINT pk_settings PRIMARY KEY (namespace,setting_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_shift on table SHIFT


--METADATA NAME:pk_shift TYPE:CONSTRAINT TABLE_NAME:SHIFT CHANGE:CREATE
ALTER TABLE SHIFT
ADD CONSTRAINT pk_shift PRIMARY KEY (shift_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_shiftper on table SHIFTPER


--METADATA NAME:pk_shiftper TYPE:CONSTRAINT TABLE_NAME:SHIFTPER CHANGE:CREATE
ALTER TABLE SHIFTPER
ADD CONSTRAINT pk_shiftper PRIMARY KEY (shift_period_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_spidmap on table SPIDMAP


--METADATA NAME:pk_spidmap TYPE:CONSTRAINT TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP
ADD CONSTRAINT pk_spidmap PRIMARY KEY (spid)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_sumtrsrc on table SUMTRSRC


--METADATA NAME:pk_sumtrsrc TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_task on table TASK


--METADATA NAME:pk_task TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT pk_task PRIMARY KEY (task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 2M next 2M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskactv on table TASKACTV


--METADATA NAME:pk_taskactv TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT pk_taskactv PRIMARY KEY (task_id,actv_code_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskdoc on table TASKDOC


--METADATA NAME:pk_taskdoc TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT pk_taskdoc PRIMARY KEY (taskdoc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskfdbk on table TASKFDBK


--METADATA NAME:pk_taskfdbk TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT pk_taskfdbk PRIMARY KEY (task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskfin on table TASKFIN


--METADATA NAME:pk_taskfin TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT pk_taskfin PRIMARY KEY (fin_dates_id,task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskmemo on table TASKMEMO


--METADATA NAME:pk_taskmemo TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT pk_taskmemo PRIMARY KEY (memo_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 400K next 400K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tasknote on table TASKNOTE


--METADATA NAME:pk_tasknote TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT pk_tasknote PRIMARY KEY (task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 300K next 300K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskpred on table TASKPRED


--METADATA NAME:pk_taskpred TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT pk_taskpred PRIMARY KEY (task_pred_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskproc on table TASKPROC


--METADATA NAME:pk_taskproc TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT pk_taskproc PRIMARY KEY (proc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_risk_task on table TASKRISK


--METADATA NAME:pk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskrsrc on table TASKRSRC


--METADATA NAME:pk_taskrsrc TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT pk_taskrsrc PRIMARY KEY (taskrsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tasksum on table TASKSUM


--METADATA NAME:pk_tasksum TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:CREATE
ALTER TABLE TASKSUM
ADD CONSTRAINT pk_tasksum PRIMARY KEY (task_sum_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tasksumfin on table TASKSUMFIN


--METADATA NAME:pk_tasksumfin TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:CREATE
ALTER TABLE TASKSUMFIN
ADD CONSTRAINT pk_tasksumfin PRIMARY KEY (task_sum_fin_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskuser on table TASKUSER


--METADATA NAME:pk_taskuser TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_taskwksp on table TASKWKSP


--METADATA NAME:pk_taskwksp TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT pk_taskwksp PRIMARY KEY (workspace_id,task_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_thrsparm on table THRSPARM


--METADATA NAME:pk_thrsparm TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT pk_thrsparm PRIMARY KEY (thresh_parm_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_timesht on table TIMESHT


--METADATA NAME:pk_timesht TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT pk_timesht PRIMARY KEY (ts_id,rsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tmplcatg on table TMPLCATG


--METADATA NAME:pk_tmplcatg TYPE:CONSTRAINT TABLE_NAME:TMPLCATG CHANGE:CREATE
ALTER TABLE TMPLCATG
ADD CONSTRAINT pk_tmplcatg PRIMARY KEY (tmplcatg_catg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_trakview on table TRAKVIEW


--METADATA NAME:pk_trakview TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT pk_trakview PRIMARY KEY (track_view_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_trsrcfin on table TRSRCFIN


--METADATA NAME:pk_trsrcfin TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT pk_trsrcfin PRIMARY KEY (fin_dates_id,taskrsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_trsrcsum on table TRSRCSUM


--METADATA NAME:pk_trsrcsum TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:CREATE
ALTER TABLE TRSRCSUM
ADD CONSTRAINT pk_trsrcsum PRIMARY KEY (taskrsrc_sum_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_trsrcsumfn on table TRSRCSUMFN


--METADATA NAME:pk_trsrcsumfn TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
ALTER TABLE TRSRCSUMFN
ADD CONSTRAINT pk_trsrcsumfn PRIMARY KEY (trsrc_sum_fin_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tsaudit on table TSAUDIT


--METADATA NAME:pk_tsaudit TYPE:CONSTRAINT TABLE_NAME:TSAUDIT CHANGE:CREATE
ALTER TABLE TSAUDIT
ADD CONSTRAINT pk_tsaudit PRIMARY KEY (ts_audit_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tsdates on table TSDATES


--METADATA NAME:pk_tsdates TYPE:CONSTRAINT TABLE_NAME:TSDATES CHANGE:CREATE
ALTER TABLE TSDATES
ADD CONSTRAINT pk_tsdates PRIMARY KEY (ts_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_tsdelegate on table TSDELEGATE


--METADATA NAME:pk_tsdelegate TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT pk_tsdelegate PRIMARY KEY (ts_delegate_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_uaccess on table UACCESS


--METADATA NAME:pk_uaccess TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:CREATE
ALTER TABLE UACCESS
ADD CONSTRAINT pk_uaccess PRIMARY KEY (user_id,proj_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating constraint pk_udfcode on table UDFCODE


--METADATA NAME:pk_udfcode TYPE:CONSTRAINT TABLE_NAME:UDFCODE CHANGE:CREATE
ALTER TABLE UDFCODE
ADD CONSTRAINT pk_udfcode PRIMARY KEY (udf_code_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 32K next 16K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_udftype on table UDFTYPE


--METADATA NAME:pk_udftype TYPE:CONSTRAINT TABLE_NAME:UDFTYPE CHANGE:CREATE
ALTER TABLE UDFTYPE
ADD CONSTRAINT pk_udftype PRIMARY KEY (udf_type_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 32K next 16K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_udfvalue on table UDFVALUE


--METADATA NAME:pk_udfvalue TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT pk_udfvalue PRIMARY KEY (udf_type_id,fk_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_uevntreg on table UEVNTREG


--METADATA NAME:pk_uevntreg TYPE:CONSTRAINT TABLE_NAME:UEVNTREG CHANGE:CREATE
ALTER TABLE UEVNTREG
ADD CONSTRAINT pk_uevntreg PRIMARY KEY (user_id,app_name,operation_name,action_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_umeasure on table UMEASURE


--METADATA NAME:pk_umeasure TYPE:CONSTRAINT TABLE_NAME:UMEASURE CHANGE:CREATE
ALTER TABLE UMEASURE
ADD CONSTRAINT pk_umeasure PRIMARY KEY (unit_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_usercol on table USERCOL


--METADATA NAME:pk_usercol TYPE:CONSTRAINT TABLE_NAME:USERCOL CHANGE:CREATE
ALTER TABLE USERCOL
ADD CONSTRAINT pk_usercol PRIMARY KEY (user_col_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_userdata on table USERDATA


--METADATA NAME:pk_userdata TYPE:CONSTRAINT TABLE_NAME:USERDATA CHANGE:CREATE
ALTER TABLE USERDATA
ADD CONSTRAINT pk_userdata PRIMARY KEY (user_data_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_usereng on table USERENG


--METADATA NAME:pk_usereng TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:CREATE
ALTER TABLE USERENG
ADD CONSTRAINT pk_usereng PRIMARY KEY (user_eng_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_userobs on table USEROBS


--METADATA NAME:pk_userobs TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT pk_userobs PRIMARY KEY (user_id,obs_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_useropen on table USEROPEN


--METADATA NAME:pk_useropen TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT pk_useropen PRIMARY KEY (user_open_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_users on table USERS


--METADATA NAME:pk_users TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT pk_users PRIMARY KEY (user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_userset on table USERSET


--METADATA NAME:pk_userset TYPE:CONSTRAINT TABLE_NAME:USERSET CHANGE:CREATE
ALTER TABLE USERSET
ADD CONSTRAINT pk_userset PRIMARY KEY (namespace,setting_name,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_userwksp on table USERWKSP


--METADATA NAME:pk_userwksp TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT pk_userwksp PRIMARY KEY (user_id,workspace_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_user_acceptance_consent on table USER_ACCEPTANCE_CONSENT


--METADATA NAME:pk_user_acceptance_consent TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 30K next 30K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_usession on table USESSION


--METADATA NAME:pk_usession TYPE:CONSTRAINT TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION
ADD CONSTRAINT pk_usession PRIMARY KEY (session_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_usropnval on table USROPNVAL


--METADATA NAME:pk_usropnval TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT pk_usropnval PRIMARY KEY (user_open_id,pk_id,usropn_type)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_viewpref on table VIEWPREF


--METADATA NAME:pk_viewpref TYPE:CONSTRAINT TABLE_NAME:VIEWPREF CHANGE:CREATE
ALTER TABLE VIEWPREF
ADD CONSTRAINT pk_viewpref PRIMARY KEY (view_pref_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_viewprop on table VIEWPROP


--METADATA NAME:pk_viewprop TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT pk_viewprop PRIMARY KEY (view_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_vwprefdash on table VWPREFDASH


--METADATA NAME:pk_vwprefdash TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT pk_vwprefdash PRIMARY KEY (dashboard_id,view_pref_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_vwprefdata on table VWPREFDATA


--METADATA NAME:pk_vwprefdata TYPE:CONSTRAINT TABLE_NAME:VWPREFDATA CHANGE:CREATE
ALTER TABLE VWPREFDATA
ADD CONSTRAINT pk_vwprefdata PRIMARY KEY (view_pref_id,view_pref_key)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_vwprefuser on table VWPREFUSER


--METADATA NAME:pk_vwprefuser TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT pk_vwprefuser PRIMARY KEY (view_pref_id,user_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbrscat on table WBRSCAT


--METADATA NAME:pk_wbrscat TYPE:CONSTRAINT TABLE_NAME:WBRSCAT CHANGE:CREATE
ALTER TABLE WBRSCAT
ADD CONSTRAINT pk_wbrscat PRIMARY KEY (wbrs_cat_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbsbudg on table WBSBUDG


--METADATA NAME:pk_wbsbudg TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT pk_wbsbudg PRIMARY KEY (wbs_budg_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbsmemo on table WBSMEMO


--METADATA NAME:pk_wbsmemo TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT pk_wbsmemo PRIMARY KEY (wbs_memo_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbsrsrc on table WBSRSRC


--METADATA NAME:pk_wbsrsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT pk_wbsrsrc PRIMARY KEY (wbsrsrc_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbsrsrc_qty on table WBSRSRC_QTY


--METADATA NAME:pk_wbsrsrc_qty TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT pk_wbsrsrc_qty PRIMARY KEY (wbsrsrc_id,week_start,month_start)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wbsstep on table WBSSTEP


--METADATA NAME:pk_wbsstep TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT pk_wbsstep PRIMARY KEY (wbs_step_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wkfltmpl on table WKFLTMPL


--METADATA NAME:pk_wkfltmpl TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT pk_wkfltmpl PRIMARY KEY (wkfl_tmpl_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_wkfluser on table WKFLUSER


--METADATA NAME:pk_wkfluser TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT pk_wkfluser PRIMARY KEY (work_flow_id,user_id,stage_num)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_workflow on table WORKFLOW


--METADATA NAME:pk_workflow TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT pk_workflow PRIMARY KEY (work_flow_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 32K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint pk_workspace on table WORKSPACE


--METADATA NAME:pk_workspace TYPE:CONSTRAINT TABLE_NAME:WORKSPACE CHANGE:CREATE
ALTER TABLE WORKSPACE
ADD CONSTRAINT pk_workspace PRIMARY KEY (workspace_id)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 256K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating constraint fk_actvcode_actvtype on table ACTVCODE


--METADATA NAME:fk_actvcode_actvtype TYPE:CONSTRAINT TABLE_NAME:ACTVCODE CHANGE:CREATE
ALTER TABLE ACTVCODE
ADD CONSTRAINT fk_actvcode_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
/

prompt Creating constraint fk_actvtype_project on table ACTVTYPE


--METADATA NAME:fk_actvtype_project TYPE:CONSTRAINT TABLE_NAME:ACTVTYPE CHANGE:CREATE
ALTER TABLE ACTVTYPE
ADD CONSTRAINT fk_actvtype_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
/

prompt Creating constraint fk_budgchng_project on table BUDGCHNG


--METADATA NAME:fk_budgchng_project TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT fk_budgchng_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_budgchng_projwbs on table BUDGCHNG


--METADATA NAME:fk_budgchng_projwbs TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT fk_budgchng_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_calendar_project on table CALENDAR


--METADATA NAME:fk_calendar_project TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT fk_calendar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_dashboard_users on table DASHBOARD


--METADATA NAME:fk_dashboard_users TYPE:CONSTRAINT TABLE_NAME:DASHBOARD CHANGE:CREATE
ALTER TABLE DASHBOARD
ADD CONSTRAINT fk_dashboard_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_dashuser_users on table DASHUSER


--METADATA NAME:fk_dashuser_users TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT fk_dashuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_dashuser_dashboard on table DASHUSER


--METADATA NAME:fk_dashuser_dashboard TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT fk_dashuser_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_discussion_task on table DISCUSSION


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_discussion_read_users on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_docreview_document on table DOCREVIEW


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
/

prompt Creating constraint fk_docreview_users on table DOCREVIEW


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
/

prompt Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_document_doccatg on table DOCUMENT


--METADATA NAME:fk_document_doccatg TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_doccatg FOREIGN KEY (doc_catg_id)
REFERENCES DOCCATG (doc_catg_id) 
/

prompt Creating constraint fk_document_project on table DOCUMENT


--METADATA NAME:fk_document_project TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_document_docstat on table DOCUMENT


--METADATA NAME:fk_document_docstat TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_docstat FOREIGN KEY (doc_status_id)
REFERENCES DOCSTAT (doc_status_id) 
/

prompt Creating constraint fk_document_rsrc on table DOCUMENT


--METADATA NAME:fk_document_rsrc TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_expproj_project on table EXPPROJ


--METADATA NAME:fk_expproj_project TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT fk_expproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_extapp_project on table EXTAPP


--METADATA NAME:fk_extapp_project TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT fk_extapp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_factval_factor on table FACTVAL


--METADATA NAME:fk_factval_factor TYPE:CONSTRAINT TABLE_NAME:FACTVAL CHANGE:CREATE
ALTER TABLE FACTVAL
ADD CONSTRAINT fk_factval_factor FOREIGN KEY (fact_id)
REFERENCES FACTOR (fact_id) 
/

prompt Creating constraint fk_filtprop_users on table FILTPROP


--METADATA NAME:fk_filtprop_users TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_filtprop_rpt on table FILTPROP


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
/

prompt Creating constraint fk_findates_fintmpl on table FINDATES


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_formproj_formtmpl on table FORMPROJ


--METADATA NAME:fk_formproj_formtmpl TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT fk_formproj_formtmpl FOREIGN KEY (form_tmpl_id)
REFERENCES FORMTMPL (form_tmpl_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_formproj_project on table FORMPROJ


--METADATA NAME:fk_formproj_project TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT fk_formproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_formtmpl_formcatg on table FORMTMPL


--METADATA NAME:fk_formtmpl_formcatg TYPE:CONSTRAINT TABLE_NAME:FORMTMPL CHANGE:CREATE
ALTER TABLE FORMTMPL
ADD CONSTRAINT fk_formtmpl_formcatg FOREIGN KEY (form_catg_id)
REFERENCES FORMCATG (form_catg_id) 
/

prompt Creating constraint fk_gchange_user on table GCHANGE


--METADATA NAME:fk_gchange_user TYPE:CONSTRAINT TABLE_NAME:GCHANGE CHANGE:CREATE
ALTER TABLE GCHANGE
ADD CONSTRAINT fk_gchange_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_hqdata_usession on table HQDATA


--METADATA NAME:fk_hqdata_usession TYPE:CONSTRAINT TABLE_NAME:HQDATA CHANGE:CREATE
ALTER TABLE HQDATA
ADD CONSTRAINT fk_hqdata_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_hquery_usession on table HQUERY


--METADATA NAME:fk_hquery_usession TYPE:CONSTRAINT TABLE_NAME:HQUERY CHANGE:CREATE
ALTER TABLE HQUERY
ADD CONSTRAINT fk_hquery_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_issuhist_project on table ISSUHIST


--METADATA NAME:fk_issuhist_project TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT fk_issuhist_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_issuhist_projissu on table ISSUHIST


--METADATA NAME:fk_issuhist_projissu TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT fk_issuhist_projissu FOREIGN KEY (issue_id)
REFERENCES PROJISSU (issue_id) 
/

prompt Creating constraint fk_iteration_release on table ITERATION


--METADATA NAME:fk_iteration_release TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:CREATE
ALTER TABLE ITERATION
ADD CONSTRAINT fk_iteration_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_iterdays_project on table ITERDAYS


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_iterdays_iteration on table ITERDAYS


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_iterdays_task on table ITERDAYS


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_itergoal_iteration on table ITERGOAL


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT fk_itergoal_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_itergoal_rfolio on table ITERGOAL


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT fk_itergoal_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
/

prompt Creating constraint fk_joblog_jobsvc on table JOBLOG


--METADATA NAME:fk_joblog_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBLOG CHANGE:CREATE
ALTER TABLE JOBLOG
ADD CONSTRAINT fk_joblog_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_jobrpt_jobsvc on table JOBRPT


--METADATA NAME:fk_jobrpt_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT fk_jobrpt_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_jobrpt_rpt on table JOBRPT


--METADATA NAME:fk_jobrpt_rpt TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT fk_jobrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_jobsvc_users on table JOBSVC


--METADATA NAME:fk_jobsvc_users TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT fk_jobsvc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_obsproj_obs on table OBSPROJ


--METADATA NAME:fk_obsproj_obs TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT fk_obsproj_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_obsproj_project on table OBSPROJ


--METADATA NAME:fk_obsproj_project TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT fk_obsproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_pcatuser_user on table PCATUSER


--METADATA NAME:fk_pcatuser_user TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT fk_pcatuser_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_pcatuser_pcatval on table PCATUSER


--METADATA NAME:fk_pcatuser_pcatval TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT fk_pcatuser_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
/

prompt Creating constraint fk_pcatval_pcattype on table PCATVAL


--METADATA NAME:fk_pcatval_pcattype TYPE:CONSTRAINT TABLE_NAME:PCATVAL CHANGE:CREATE
ALTER TABLE PCATVAL
ADD CONSTRAINT fk_pcatval_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
/

prompt Creating constraint fk_pfolio_users on table PFOLIO


--METADATA NAME:fk_pfolio_users TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT fk_pfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_prefer_currtype on table PREFER


--METADATA NAME:fk_prefer_currtype TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
/

prompt Creating constraint fk_prefer_users on table PREFER


--METADATA NAME:fk_prefer_users TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_users FOREIGN KEY (ts_approve_user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_prefer_rsrc on table PREFER


--METADATA NAME:fk_prefer_rsrc TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_rsrc FOREIGN KEY (default_rsrc_sec_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_procitem_procgroup on table PROCITEM


--METADATA NAME:fk_procitem_procgroup TYPE:CONSTRAINT TABLE_NAME:PROCITEM CHANGE:CREATE
ALTER TABLE PROCITEM
ADD CONSTRAINT fk_procitem_procgroup FOREIGN KEY (proc_group_id)
REFERENCES PROCGROUP (proc_group_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_profpriv_profile on table PROFPRIV


--METADATA NAME:fk_profpriv_profile TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT fk_profpriv_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
/

prompt Creating constraint fk_projcost_account on table PROJCOST


--METADATA NAME:fk_projcost_account TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
/

prompt Creating constraint fk_projcost_project on table PROJCOST


--METADATA NAME:fk_projcost_project TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projcost_task on table PROJCOST


--METADATA NAME:fk_projcost_task TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_projcost_costtype on table PROJCOST


--METADATA NAME:fk_projcost_costtype TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id) 
/

prompt Creating constraint fk_projcost_pobs on table PROJCOST


--METADATA NAME:fk_projcost_pobs TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
/

prompt Creating constraint fk_project_account on table PROJECT


--METADATA NAME:fk_project_account TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
/

prompt Creating constraint fk_project_basetype on table PROJECT


--METADATA NAME:fk_project_basetype TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_basetype FOREIGN KEY (base_type_id)
REFERENCES BASETYPE (base_type_id) 
/

prompt Creating constraint fk_project_findates on table PROJECT


--METADATA NAME:fk_project_findates TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_findates FOREIGN KEY (last_fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_project_users on table PROJECT


--METADATA NAME:fk_project_users TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_users FOREIGN KEY (checkout_user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_project_fintmpl on table PROJECT


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
/

prompt Creating constraint fk_projest_project on table PROJEST


--METADATA NAME:fk_projest_project TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projest_rsrc on table PROJEST


--METADATA NAME:fk_projest_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_projest_projwbs on table PROJEST


--METADATA NAME:fk_projest_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_projfund_fundsrc on table PROJFUND


--METADATA NAME:fk_projfund_fundsrc TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT fk_projfund_fundsrc FOREIGN KEY (fund_id)
REFERENCES FUNDSRC (fund_id) 
/

prompt Creating constraint fk_projfund_project on table PROJFUND


--METADATA NAME:fk_projfund_project TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT fk_projfund_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projissu_obs on table PROJISSU


--METADATA NAME:fk_projissu_obs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
/

prompt Creating constraint fk_projissu_project on table PROJISSU


--METADATA NAME:fk_projissu_project TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projissu_projwbs on table PROJISSU


--METADATA NAME:fk_projissu_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_projissu_task on table PROJISSU


--METADATA NAME:fk_projissu_task TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_projissu_trakview on table PROJISSU


--METADATA NAME:fk_projissu_trakview TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
/

prompt Creating constraint fk_projissu_thrsparm on table PROJISSU


--METADATA NAME:fk_projissu_thrsparm TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
/

prompt Creating constraint fk_projissu_rsrc on table PROJISSU


--METADATA NAME:fk_projissu_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_projissu_projthrs on table PROJISSU


--METADATA NAME:fk_projissu_projthrs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_projthrs FOREIGN KEY (thresh_id)
REFERENCES PROJTHRS (thresh_id) 
/

prompt Creating constraint fk_projissu_workspace on table PROJISSU


--METADATA NAME:fk_projissu_workspace TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
/

prompt Creating constraint fk_projpcat_pcattype on table PROJPCAT


--METADATA NAME:fk_projpcat_pcattype TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
/

prompt Creating constraint fk_projpcat_pcatval on table PROJPCAT


--METADATA NAME:fk_projpcat_pcatval TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
/

prompt Creating constraint fk_projpcat_project on table PROJPCAT


--METADATA NAME:fk_projpcat_project TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projprop_project on table PROJPROP


--METADATA NAME:fk_projprop_project TYPE:CONSTRAINT TABLE_NAME:PROJPROP CHANGE:CREATE
ALTER TABLE PROJPROP
ADD CONSTRAINT fk_projprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projshar_project on table PROJSHAR


--METADATA NAME:fk_projshar_project TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT fk_projshar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projshar_usession on table PROJSHAR


--METADATA NAME:fk_projshar_usession TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT fk_projshar_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_projthrs_obs on table PROJTHRS


--METADATA NAME:fk_projthrs_obs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
/

prompt Creating constraint fk_projthrs_trakview on table PROJTHRS


--METADATA NAME:fk_projthrs_trakview TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
/

prompt Creating constraint fk_projthrs_thrsparm on table PROJTHRS


--METADATA NAME:fk_projthrs_thrsparm TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
/

prompt Creating constraint fk_projthrs_project on table PROJTHRS


--METADATA NAME:fk_projthrs_project TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projthrs_projwbs on table PROJTHRS


--METADATA NAME:fk_projthrs_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_projwbs_obs on table PROJWBS


--METADATA NAME:fk_projwbs_obs TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
/

prompt Creating constraint fk_projwbs_project on table PROJWBS


--METADATA NAME:fk_projwbs_project TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_projwbs_phase on table PROJWBS


--METADATA NAME:fk_projwbs_phase TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_phase FOREIGN KEY (phase_id)
REFERENCES PHASE (phase_id) 
/

prompt Creating constraint fk_projwbs_rfolio_team on table PROJWBS


--METADATA NAME:fk_projwbs_rfolio_team TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_rfolio_team FOREIGN KEY (resp_team_id)
REFERENCES RFOLIO (rfolio_id) 
/

prompt Creating constraint fk_projwbs_iteration on table PROJWBS


--METADATA NAME:fk_projwbs_iteration TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
/

prompt Creating constraint fk_projwsrpt_rpt on table PROJWSRPT


--METADATA NAME:fk_projwsrpt_rpt TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT fk_projwsrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_projwsrpt_project on table PROJWSRPT


--METADATA NAME:fk_projwsrpt_project TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT fk_projwsrpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_prpfolio_pfolio on table PRPFOLIO


--METADATA NAME:fk_prpfolio_pfolio TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT fk_prpfolio_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_prpfolio_projwbs on table PRPFOLIO


--METADATA NAME:fk_prpfolio_projwbs TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT fk_prpfolio_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_rcatval_rcattype on table RCATVAL


--METADATA NAME:fk_rcatval_rcattype TYPE:CONSTRAINT TABLE_NAME:RCATVAL CHANGE:CREATE
ALTER TABLE RCATVAL
ADD CONSTRAINT fk_rcatval_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
/

prompt Creating constraint fk_release_rfolio on table RELEASE


--METADATA NAME:fk_release_rfolio TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT fk_release_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
/

prompt Creating constraint fk_release_proj_id on table RELEASE


--METADATA NAME:fk_release_proj_id TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT fk_release_proj_id FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_relitems_project on table RELITEMS


--METADATA NAME:fk_relitems_project TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_relitems_reittype on table RELITEMS


--METADATA NAME:fk_relitems_reittype TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_reittype FOREIGN KEY (item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
/

prompt Creating constraint fk_relitems_reittype_related on table RELITEMS


--METADATA NAME:fk_relitems_reittype_related TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_reittype_related FOREIGN KEY (related_item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
/

prompt Creating constraint fk_rfolio_users on table RFOLIO


--METADATA NAME:fk_rfolio_users TYPE:CONSTRAINT TABLE_NAME:RFOLIO CHANGE:CREATE
ALTER TABLE RFOLIO
ADD CONSTRAINT fk_rfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rlfolio_user on table RLFOLIO


--METADATA NAME:fk_rlfolio_user TYPE:CONSTRAINT TABLE_NAME:RLFOLIO CHANGE:CREATE
ALTER TABLE RLFOLIO
ADD CONSTRAINT fk_rlfolio_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolelimit_roles on table ROLELIMIT


--METADATA NAME:fk_rolelimit_roles TYPE:CONSTRAINT TABLE_NAME:ROLELIMIT CHANGE:CREATE
ALTER TABLE ROLELIMIT
ADD CONSTRAINT fk_rolelimit_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rolerate_roles on table ROLERATE


--METADATA NAME:fk_rolerate_roles TYPE:CONSTRAINT TABLE_NAME:ROLERATE CHANGE:CREATE
ALTER TABLE ROLERATE
ADD CONSTRAINT fk_rolerate_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rolercat_rolecattype on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolercat_rolecatval on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
/

prompt Creating constraint fk_rolercat_roles on table ROLERCAT


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_roles_pobs on table ROLES


--METADATA NAME:fk_roles_pobs TYPE:CONSTRAINT TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES
ADD CONSTRAINT fk_roles_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
/

prompt Creating constraint fk_rolfolio_rlfolio on table ROLFOLIO


--METADATA NAME:fk_rolfolio_rlfolio TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT fk_rolfolio_rlfolio FOREIGN KEY (rlfolio_id)
REFERENCES RLFOLIO (rlfolio_id) 
/

prompt Creating constraint fk_rolfolio_role on table ROLFOLIO


--METADATA NAME:fk_rolfolio_role TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT fk_rolfolio_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_rpt_project on table RPT


--METADATA NAME:fk_rpt_project TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_rpt_rptgroup on table RPT


--METADATA NAME:fk_rpt_rptgroup TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_rptgroup FOREIGN KEY (rpt_group_id)
REFERENCES RPTGROUP (rpt_group_id) 
/

prompt Creating constraint fk_rpt_users on table RPT


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rptbatch_project on table RPTBATCH


--METADATA NAME:fk_rptbatch_project TYPE:CONSTRAINT TABLE_NAME:RPTBATCH CHANGE:CREATE
ALTER TABLE RPTBATCH
ADD CONSTRAINT fk_rptbatch_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_rptlist_rpt on table RPTLIST


--METADATA NAME:fk_rptlist_rpt TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT fk_rptlist_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
/

prompt Creating constraint fk_rptlist_rptbatch on table RPTLIST


--METADATA NAME:fk_rptlist_rptbatch TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT fk_rptlist_rptbatch FOREIGN KEY (rpt_batch_id)
REFERENCES RPTBATCH (rpt_batch_id) 
/

prompt Creating constraint fk_rsrc_calendar on table RSRC


--METADATA NAME:fk_rsrc_calendar TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
/

prompt Creating constraint fk_rsrc_currtype on table RSRC


--METADATA NAME:fk_rsrc_currtype TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
/

prompt Creating constraint fk_rsrc_shift on table RSRC


--METADATA NAME:fk_rsrc_shift TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
/

prompt Creating constraint fk_rsrc_users on table RSRC


--METADATA NAME:fk_rsrc_users TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rsrc_roles on table RSRC


--METADATA NAME:fk_rsrc_roles TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_rsrc_umeasure on table RSRC


--METADATA NAME:fk_rsrc_umeasure TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_umeasure FOREIGN KEY (unit_id)
REFERENCES UMEASURE (unit_id) 
/

prompt Creating constraint fk_rsrc_pobs on table RSRC


--METADATA NAME:fk_rsrc_pobs TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
/

prompt Creating constraint fk_rsrcandash_dashboard on table RSRCANDASH


--METADATA NAME:fk_rsrcandash_dashboard TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT fk_rsrcandash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rsrcandash_rsrcanview on table RSRCANDASH


--METADATA NAME:fk_rsrcandash_rsrcanview TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT fk_rsrcandash_rsrcanview FOREIGN KEY (rsrcan_view_id)
REFERENCES RSRCANVIEW (rsrcan_view_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rsrcanview_users on table RSRCANVIEW


--METADATA NAME:fk_rsrcanview_users TYPE:CONSTRAINT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
ALTER TABLE RSRCANVIEW
ADD CONSTRAINT fk_rsrcanview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rsrchour_nonwork on table RSRCHOUR


--METADATA NAME:fk_rsrchour_nonwork TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_nonwork FOREIGN KEY (nonwork_type_id)
REFERENCES NONWORK (nonwork_type_id) 
/

prompt Creating constraint fk_rsrchour_taskrsrc on table RSRCHOUR


--METADATA NAME:fk_rsrchour_taskrsrc TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
/

prompt Creating constraint fk_rsrchour_timesht on table RSRCHOUR


--METADATA NAME:fk_rsrchour_timesht TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_timesht FOREIGN KEY (ts_id,rsrc_id)
REFERENCES TIMESHT (ts_id,rsrc_id) 
/

prompt Creating constraint fk_rsrchour_rsrc on table RSRCHOUR


--METADATA NAME:fk_rsrchour_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_rsrcprop_rsrc on table RSRCPROP


--METADATA NAME:fk_rsrcprop_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCPROP CHANGE:CREATE
ALTER TABLE RSRCPROP
ADD CONSTRAINT fk_rsrcprop_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_rsrcrate_rsrc on table RSRCRATE


--METADATA NAME:fk_rsrcrate_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT fk_rsrcrate_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_rsrcrate_shiftper on table RSRCRATE


--METADATA NAME:fk_rsrcrate_shiftper TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT fk_rsrcrate_shiftper FOREIGN KEY (shift_period_id)
REFERENCES SHIFTPER (shift_period_id) 
/

prompt Creating constraint fk_rsrcrcat_rcattype on table RSRCRCAT


--METADATA NAME:fk_rsrcrcat_rcattype TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
/

prompt Creating constraint fk_rsrcrcat_rcatval on table RSRCRCAT


--METADATA NAME:fk_rsrcrcat_rcatval TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rcatval FOREIGN KEY (rsrc_catg_id)
REFERENCES RCATVAL (rsrc_catg_id) 
/

prompt Creating constraint fk_rsrcrcat_rsrc on table RSRCRCAT


--METADATA NAME:fk_rsrcrcat_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_rsrcrole_roles on table RSRCROLE


--METADATA NAME:fk_rsrcrole_roles TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT fk_rsrcrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_rsrcrole_rsrc on table RSRCROLE


--METADATA NAME:fk_rsrcrole_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT fk_rsrcrole_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_rsrcsec_users on table RSRCSEC


--METADATA NAME:fk_rsrcsec_users TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT fk_rsrcsec_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rsrcsec_rsrc on table RSRCSEC


--METADATA NAME:fk_rsrcsec_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT fk_rsrcsec_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_rsrfolio_rfolio on table RSRFOLIO


--METADATA NAME:fk_rsrfolio_rfolio TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT fk_rsrfolio_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
/

prompt Creating constraint fk_rsrfolio_rsrc on table RSRFOLIO


--METADATA NAME:fk_rsrfolio_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT fk_rsrfolio_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_scenario_users on table SCENARIO


--METADATA NAME:fk_scenario_users TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT fk_scenario_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_scenario_viewpref on table SCENARIO


--METADATA NAME:fk_scenario_viewpref TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT fk_scenario_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id) 
/

prompt Creating constraint fk_scenproj_project on table SCENPROJ


--METADATA NAME:fk_scenproj_project TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT fk_scenproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_scenproj_scenario on table SCENPROJ


--METADATA NAME:fk_scenproj_scenario TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT fk_scenproj_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_scenrole_roles on table SCENROLE


--METADATA NAME:fk_scenrole_roles TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT fk_scenrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_scenrole_scenario on table SCENROLE


--METADATA NAME:fk_scenrole_scenario TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT fk_scenrole_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_scenuser_users on table SCENUSER


--METADATA NAME:fk_scenuser_users TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT fk_scenuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_scenuser_scenario on table SCENUSER


--METADATA NAME:fk_scenuser_scenario TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT fk_scenuser_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_shiftper_shift on table SHIFTPER


--METADATA NAME:fk_shiftper_shift TYPE:CONSTRAINT TABLE_NAME:SHIFTPER CHANGE:CREATE
ALTER TABLE SHIFTPER
ADD CONSTRAINT fk_shiftper_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
/

prompt Creating constraint fk_sumprojcost_project on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_project on table SUMTASK


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_projwbs on table SUMTASK


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_project on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_task_calendar on table TASK


--METADATA NAME:fk_task_calendar TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
/

prompt Creating constraint fk_task_rsrc on table TASK


--METADATA NAME:fk_task_rsrc TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_task_project on table TASK


--METADATA NAME:fk_task_project TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_task_projwbs on table TASK


--METADATA NAME:fk_task_projwbs TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_taskactv_actvcode on table TASKACTV


--METADATA NAME:fk_taskactv_actvcode TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_actvcode FOREIGN KEY (actv_code_id)
REFERENCES ACTVCODE (actv_code_id) 
/

prompt Creating constraint fk_taskactv_actvtype on table TASKACTV


--METADATA NAME:fk_taskactv_actvtype TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
/

prompt Creating constraint fk_taskactv_task on table TASKACTV


--METADATA NAME:fk_taskactv_task TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskactv_project on table TASKACTV


--METADATA NAME:fk_taskactv_project TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskdoc_document on table TASKDOC


--METADATA NAME:fk_taskdoc_document TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
/

prompt Creating constraint fk_taskdoc_projwbs on table TASKDOC


--METADATA NAME:fk_taskdoc_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_taskdoc_project on table TASKDOC


--METADATA NAME:fk_taskdoc_project TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskdoc_task on table TASKDOC


--METADATA NAME:fk_taskdoc_task TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskfdbk_project on table TASKFDBK


--METADATA NAME:fk_taskfdbk_project TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT fk_taskfdbk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskfdbk_task on table TASKFDBK


--METADATA NAME:fk_taskfdbk_task TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT fk_taskfdbk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskfin_project on table TASKFIN


--METADATA NAME:fk_taskfin_project TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskfin_task on table TASKFIN


--METADATA NAME:fk_taskfin_task TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskfin_findates on table TASKFIN


--METADATA NAME:fk_taskfin_findates TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskmemo_memotype on table TASKMEMO


--METADATA NAME:fk_taskmemo_memotype TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
/

prompt Creating constraint fk_taskmemo_project on table TASKMEMO


--METADATA NAME:fk_taskmemo_project TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskmemo_task on table TASKMEMO


--METADATA NAME:fk_taskmemo_task TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_tasknote_project on table TASKNOTE


--METADATA NAME:fk_tasknote_project TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT fk_tasknote_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_tasknote_task on table TASKNOTE


--METADATA NAME:fk_tasknote_task TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT fk_tasknote_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskpred_project on table TASKPRED


--METADATA NAME:fk_taskpred_project TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskpred_project_2 on table TASKPRED


--METADATA NAME:fk_taskpred_project_2 TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_project_2 FOREIGN KEY (pred_proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskpred_task_2 on table TASKPRED


--METADATA NAME:fk_taskpred_task_2 TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_task_2 FOREIGN KEY (pred_task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskpred_task on table TASKPRED


--METADATA NAME:fk_taskpred_task TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskproc_project on table TASKPROC


--METADATA NAME:fk_taskproc_project TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT fk_taskproc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskproc_task on table TASKPROC


--METADATA NAME:fk_taskproc_task TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT fk_taskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_risk_riskid on table TASKRISK


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
/

prompt Creating constraint fk_risk_task on table TASKRISK


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskrisk_project on table TASKRISK


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskrsrc_account on table TASKRSRC


--METADATA NAME:fk_taskrsrc_account TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
/

prompt Creating constraint fk_taskrsrc_roles on table TASKRSRC


--METADATA NAME:fk_taskrsrc_roles TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_taskrsrc_rsrc on table TASKRSRC


--METADATA NAME:fk_taskrsrc_rsrc TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_taskrsrc_project on table TASKRSRC


--METADATA NAME:fk_taskrsrc_project TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskrsrc_task on table TASKRSRC


--METADATA NAME:fk_taskrsrc_task TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskrsrc_rsrccurv on table TASKRSRC


--METADATA NAME:fk_taskrsrc_rsrccurv TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_rsrccurv FOREIGN KEY (curv_id)
REFERENCES RSRCCURV (curv_id) 
/

prompt Creating constraint fk_taskrsrc_pobs on table TASKRSRC


--METADATA NAME:fk_taskrsrc_pobs TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
/

prompt Creating constraint fk_taskuser_users on table TASKUSER


--METADATA NAME:fk_taskuser_users TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskuser_task on table TASKUSER


--METADATA NAME:fk_taskuser_task TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_taskuser_project on table TASKUSER


--METADATA NAME:fk_taskuser_project TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_taskwksp_workspace on table TASKWKSP


--METADATA NAME:fk_taskwksp_workspace TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
/

prompt Creating constraint fk_taskwksp_task on table TASKWKSP


--METADATA NAME:fk_taskwksp_task TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskwksp_project on table TASKWKSP


--METADATA NAME:fk_taskwksp_project TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_trakview_users on table TRAKVIEW


--METADATA NAME:fk_trakview_users TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT fk_trakview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_trsrcfin_project on table TRSRCFIN


--METADATA NAME:fk_trsrcfin_project TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_trsrcfin_task on table TRSRCFIN


--METADATA NAME:fk_trsrcfin_task TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_trsrcfin_taskrsrc on table TRSRCFIN


--METADATA NAME:fk_trsrcfin_taskrsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
/

prompt Creating constraint fk_trsrcfin_findates on table TRSRCFIN


--METADATA NAME:fk_trsrcfin_findates TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_tsdelegate_users on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_users2 on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users2 TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users2 FOREIGN KEY (ts_delegate_user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_project on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_project TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_uaccess_users on table UACCESS


--METADATA NAME:fk_uaccess_users TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:CREATE
ALTER TABLE UACCESS
ADD CONSTRAINT fk_uaccess_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_udfcode_udftype on table UDFCODE


--METADATA NAME:fk_udfcode_udftype TYPE:CONSTRAINT TABLE_NAME:UDFCODE CHANGE:CREATE
ALTER TABLE UDFCODE
ADD CONSTRAINT fk_udfcode_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_udfvalue_project on table UDFVALUE


--METADATA NAME:fk_udfvalue_project TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_udfvalue_udftype on table UDFVALUE


--METADATA NAME:fk_udfvalue_udftype TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id) 
/

prompt Creating constraint fk_udfvalue_udfcode on table UDFVALUE


--METADATA NAME:fk_udfvalue_udfcode TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_udfcode FOREIGN KEY (udf_code_id)
REFERENCES UDFCODE (udf_code_id) 
/

prompt Creating constraint fk_uevntreg_users on table UEVNTREG


--METADATA NAME:fk_uevntreg_users TYPE:CONSTRAINT TABLE_NAME:UEVNTREG CHANGE:CREATE
ALTER TABLE UEVNTREG
ADD CONSTRAINT fk_uevntreg_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_upklist_usession on table UPKLIST


--METADATA NAME:fk_upklist_usession TYPE:CONSTRAINT TABLE_NAME:UPKLIST CHANGE:CREATE
ALTER TABLE UPKLIST
ADD CONSTRAINT fk_upklist_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_userdata_users on table USERDATA


--METADATA NAME:fk_userdata_users TYPE:CONSTRAINT TABLE_NAME:USERDATA CHANGE:CREATE
ALTER TABLE USERDATA
ADD CONSTRAINT fk_userdata_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_usereng_users on table USERENG


--METADATA NAME:fk_usereng_users TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:CREATE
ALTER TABLE USERENG
ADD CONSTRAINT fk_usereng_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_userobs_obs on table USEROBS


--METADATA NAME:fk_userobs_obs TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
/

prompt Creating constraint fk_userobs_users on table USEROBS


--METADATA NAME:fk_userobs_users TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_userobs_profile on table USEROBS


--METADATA NAME:fk_userobs_profile TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
/

prompt Creating constraint fk_useropen_users on table USEROPEN


--METADATA NAME:fk_useropen_users TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT fk_useropen_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_users_currtype on table USERS


--METADATA NAME:fk_users_currtype TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT fk_users_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
/

prompt Creating constraint fk_users_profile on table USERS


--METADATA NAME:fk_users_profile TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT fk_users_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
/

prompt Creating constraint fk_userset_users on table USERSET


--METADATA NAME:fk_userset_users TYPE:CONSTRAINT TABLE_NAME:USERSET CHANGE:CREATE
ALTER TABLE USERSET
ADD CONSTRAINT fk_userset_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_userwksp_users on table USERWKSP


--METADATA NAME:fk_userwksp_users TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_userwksp_workspace on table USERWKSP


--METADATA NAME:fk_userwksp_workspace TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
/

prompt Creating constraint fk_userwksp_project on table USERWKSP


--METADATA NAME:fk_userwksp_project TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_usession_users on table USESSION


--METADATA NAME:fk_usession_users TYPE:CONSTRAINT TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION
ADD CONSTRAINT fk_usession_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_usropnval_useropen on table USROPNVAL


--METADATA NAME:fk_usropnval_useropen TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT fk_usropnval_useropen FOREIGN KEY (user_open_id)
REFERENCES USEROPEN (user_open_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_viewpref_users on table VIEWPREF


--METADATA NAME:fk_viewpref_users TYPE:CONSTRAINT TABLE_NAME:VIEWPREF CHANGE:CREATE
ALTER TABLE VIEWPREF
ADD CONSTRAINT fk_viewpref_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_viewprop_users on table VIEWPROP


--METADATA NAME:fk_viewprop_users TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT fk_viewprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_viewprop_project on table VIEWPROP


--METADATA NAME:fk_viewprop_project TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT fk_viewprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_dashboard on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_dashboard TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_viewpref on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdata_viewpref on table VWPREFDATA


--METADATA NAME:fk_vwprefdata_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDATA CHANGE:CREATE
ALTER TABLE VWPREFDATA
ADD CONSTRAINT fk_vwprefdata_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefuser_viewpref on table VWPREFUSER


--METADATA NAME:fk_vwprefuser_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT fk_vwprefuser_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefuser_users on table VWPREFUSER


--METADATA NAME:fk_vwprefuser_users TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT fk_vwprefuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_wbsbudg_project on table WBSBUDG


--METADATA NAME:fk_wbsbudg_project TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT fk_wbsbudg_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_wbsbudg_projwbs on table WBSBUDG


--METADATA NAME:fk_wbsbudg_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT fk_wbsbudg_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_wbsmemo_memotype on table WBSMEMO


--METADATA NAME:fk_wbsmemo_memotype TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
/

prompt Creating constraint fk_wbsmemo_project on table WBSMEMO


--METADATA NAME:fk_wbsmemo_project TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_wbsmemo_projwbs on table WBSMEMO


--METADATA NAME:fk_wbsmemo_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_wbsrsrc_project on table WBSRSRC


--METADATA NAME:fk_wbsrsrc_project TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_wbsrsrc_projwbs on table WBSRSRC


--METADATA NAME:fk_wbsrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_wbsrsrc_rsrc on table WBSRSRC


--METADATA NAME:fk_wbsrsrc_rsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
/

prompt Creating constraint fk_wbsrsrc_role on table WBSRSRC


--METADATA NAME:fk_wbsrsrc_role TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_wbsrsrc_wbrscat on table WBSRSRC


--METADATA NAME:fk_wbsrsrc_wbrscat TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_wbrscat FOREIGN KEY (wbrs_cat_id)
REFERENCES WBRSCAT (wbrs_cat_id) 
/

prompt Creating constraint fk_wbsrsrc_qty_wbsrsrc on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_wbsrsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_wbsrsrc FOREIGN KEY (wbsrsrc_id)
REFERENCES WBSRSRC (wbsrsrc_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_wbsrsrc_qty_findates1 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates1 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates1 FOREIGN KEY (fin_dates_id1)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wbsrsrc_qty_findates2 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates2 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates2 FOREIGN KEY (fin_dates_id2)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wbsstep_project on table WBSSTEP


--METADATA NAME:fk_wbsstep_project TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT fk_wbsstep_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_wbsstep_projwbs on table WBSSTEP


--METADATA NAME:fk_wbsstep_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT fk_wbsstep_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
/

prompt Creating constraint fk_wkfltmpl_tmplcatg on table WKFLTMPL


--METADATA NAME:fk_wkfltmpl_tmplcatg TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT fk_wkfltmpl_tmplcatg FOREIGN KEY (tmplcatg_catg_id)
REFERENCES TMPLCATG (tmplcatg_catg_id) 
/

prompt Creating constraint fk_wkfluser_workflow on table WKFLUSER


--METADATA NAME:fk_wkfluser_workflow TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT fk_wkfluser_workflow FOREIGN KEY (work_flow_id)
REFERENCES WORKFLOW (work_flow_id) 
/

prompt Creating constraint ndx_wkfluser_users on table WKFLUSER


--METADATA NAME:ndx_wkfluser_users TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT ndx_wkfluser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_workflow_project on table WORKFLOW


--METADATA NAME:fk_workflow_project TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint fk_workflow_users on table WORKFLOW


--METADATA NAME:fk_workflow_users TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_workflow_workspace on table WORKFLOW


--METADATA NAME:fk_workflow_workspace TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
/

prompt Creating constraint fk_workspace_project on table WORKSPACE


--METADATA NAME:fk_workspace_project TYPE:CONSTRAINT TABLE_NAME:WORKSPACE CHANGE:CREATE
ALTER TABLE WORKSPACE
ADD CONSTRAINT fk_workspace_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
/

prompt Creating constraint ck_calendar_default_flag on table CALENDAR


--METADATA NAME:ck_calendar_default_flag TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT ck_calendar_default_flag CHECK (default_flag in ('Y', 'N'))
/

prompt Creating constraint ck_document_deliv_flag on table DOCUMENT


--METADATA NAME:ck_document_deliv_flag TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT ck_document_deliv_flag CHECK (deliv_flag in ('Y', 'N'))
/

prompt Creating constraint ck_expproj_login_supplied_flag on table EXPPROJ


--METADATA NAME:ck_expproj_login_supplied_flag TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT ck_expproj_login_supplied_flag CHECK (login_supplied_flag in ('Y', 'N'))
/

prompt Creating constraint ck_extapp_login_supply_flag on table EXTAPP


--METADATA NAME:ck_extapp_login_supply_flag TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT ck_extapp_login_supply_flag CHECK (login_supply_flag in ('Y', 'N'))
/

prompt Creating constraint ck_jobsvc_audit_flag on table JOBSVC


--METADATA NAME:ck_jobsvc_audit_flag TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT ck_jobsvc_audit_flag CHECK (audit_flag in ('Y', 'N'))
/

prompt Creating constraint ck_memotype_eps_flag on table MEMOTYPE


--METADATA NAME:ck_memotype_eps_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_eps_flag CHECK (eps_flag in ('Y', 'N'))
/

prompt Creating constraint ck_memotype_proj_flag on table MEMOTYPE


--METADATA NAME:ck_memotype_proj_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_proj_flag CHECK (proj_flag in ('Y', 'N'))
/

prompt Creating constraint ck_memotype_task_flag on table MEMOTYPE


--METADATA NAME:ck_memotype_task_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_task_flag CHECK (task_flag in ('Y', 'N'))
/

prompt Creating constraint ck_memotype_wbs_flag on table MEMOTYPE


--METADATA NAME:ck_memotype_wbs_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_wbs_flag CHECK (wbs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_pfolio_closed_flag on table PFOLIO


--METADATA NAME:ck_pfolio_closed_flag TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT ck_pfolio_closed_flag CHECK (closed_proj_flag in ('Y', 'N'))
/

prompt Creating constraint ck_pfolio_whatif_flag on table PFOLIO


--METADATA NAME:ck_pfolio_whatif_flag TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT ck_pfolio_whatif_flag CHECK (whatif_proj_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_complete_task_hrs on table PREFER


--METADATA NAME:ck_prefer_complete_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_complete_task_hrs CHECK (complete_task_hrs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_default_timesheet on table PREFER


--METADATA NAME:ck_prefer_default_timesheet TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_default_timesheet CHECK (default_timesheet_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_ev_fix_cost_flag on table PREFER


--METADATA NAME:ck_prefer_ev_fix_cost_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_ev_fix_cost_flag CHECK (ev_fix_cost_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_future_ts_hrs_flag on table PREFER


--METADATA NAME:ck_prefer_future_ts_hrs_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_future_ts_hrs_flag CHECK (future_ts_hrs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_notstart_task_hrs on table PREFER


--METADATA NAME:ck_prefer_notstart_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_notstart_task_hrs CHECK (notstart_task_hrs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_postend_task_hrs on table PREFER


--METADATA NAME:ck_prefer_postend_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_postend_task_hrs CHECK (postend_task_hrs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_prestart_task_hrs on table PREFER


--METADATA NAME:ck_prefer_prestart_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_prestart_task_hrs CHECK (prestart_task_hrs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_prefer_ts_daily_flag on table PREFER


--METADATA NAME:ck_prefer_ts_daily_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_ts_daily_flag CHECK (ts_daily_flag in ('Y', 'N'))
/

prompt Creating constraint ck_profile_default_flag on table PROFILE


--METADATA NAME:ck_profile_default_flag TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT ck_profile_default_flag CHECK (default_flag in ('Y', 'N'))
/

prompt Creating constraint ck_profile_superuser_flag on table PROFILE


--METADATA NAME:ck_profile_superuser_flag TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT ck_profile_superuser_flag CHECK (superuser_flag in ('Y', 'N'))
/

prompt Creating constraint ck_profpriv_allow_flag on table PROFPRIV


--METADATA NAME:ck_profpriv_allow_flag TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT ck_profpriv_allow_flag CHECK (allow_flag in ('Y', 'N'))
/

prompt Creating constraint ck_projcost_auto_compute_act on table PROJCOST


--METADATA NAME:ck_projcost_auto_compute_act TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT ck_projcost_auto_compute_act CHECK (auto_compute_act_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_allow_complete_flag on table PROJECT


--METADATA NAME:ck_project_allow_complete_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_allow_complete_flag CHECK (allow_complete_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_batch_sum_flag on table PROJECT


--METADATA NAME:ck_project_batch_sum_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_batch_sum_flag CHECK (batch_sum_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_chng_eff_cmp_pct on table PROJECT


--METADATA NAME:ck_project_chng_eff_cmp_pct TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_chng_eff_cmp_pct CHECK (chng_eff_cmp_pct_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_project_flag on table PROJECT


--METADATA NAME:ck_project_project_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_project_flag CHECK (project_flag in ('Y', 'N'))
/

prompt Creating constraint ck_proj_cost_qty_recalc_flag on table PROJECT


--METADATA NAME:ck_proj_cost_qty_recalc_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_proj_cost_qty_recalc_flag CHECK (cost_qty_recalc_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_rsrc_self_add_flag on table PROJECT


--METADATA NAME:ck_project_rsrc_self_add_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_rsrc_self_add_flag CHECK (rsrc_self_add_flag in ('Y', 'N'))
/

prompt Creating constraint ck_proj_rsrc_role_match_flag on table PROJECT


--METADATA NAME:ck_proj_rsrc_role_match_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_step_complete_flag on table PROJECT


--METADATA NAME:ck_project_step_complete_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_step_complete_flag CHECK (step_complete_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_sum_only_flag on table PROJECT


--METADATA NAME:ck_project_sum_only_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_sum_only_flag CHECK (sum_only_flag in ('Y', 'N'))
/

prompt Creating constraint ck_act_this_lnk_flag on table PROJECT


--METADATA NAME:ck_act_this_lnk_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_act_this_lnk_flag CHECK (act_this_per_link_flag in ('Y', 'N'))
/

prompt Creating constraint ck_act_pct_link_flag on table PROJECT


--METADATA NAME:ck_act_pct_link_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_act_pct_link_flag CHECK (act_pct_link_flag in ('Y', 'N'))
/

prompt Creating constraint ck_add_act_remain_flag on table PROJECT


--METADATA NAME:ck_add_act_remain_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_add_act_remain_flag CHECK (add_act_remain_flag in ('Y', 'N'))
/

prompt Creating constraint ck_project_tsk_cd_prfx_flag on table PROJECT


--METADATA NAME:ck_project_tsk_cd_prfx_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_tsk_cd_prfx_flag CHECK (task_code_prefix_flag in ('Y', 'N'))
/

prompt Creating constraint ck_projest_applied_flag on table PROJEST


--METADATA NAME:ck_projest_applied_flag TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT ck_projest_applied_flag CHECK (applied_flag in ('Y', 'N'))
/

prompt Creating constraint ck_projwbs_proj_node_flag on table PROJWBS


--METADATA NAME:ck_projwbs_proj_node_flag TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT ck_projwbs_proj_node_flag CHECK (proj_node_flag in ('Y', 'N'))
/

prompt Creating constraint ck_projwbs_sum_data_flag on table PROJWBS


--METADATA NAME:ck_projwbs_sum_data_flag TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT ck_projwbs_sum_data_flag CHECK (sum_data_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rpt_global_flag on table RPT


--METADATA NAME:ck_rpt_global_flag TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT ck_rpt_global_flag CHECK (global_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrc_active_flag on table RSRC


--METADATA NAME:ck_rsrc_active_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_active_flag CHECK (active_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrc_auto_compute_act_flag on table RSRC


--METADATA NAME:ck_rsrc_auto_compute_act_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_auto_compute_act_flag CHECK (auto_compute_act_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrc_ot_flag on table RSRC


--METADATA NAME:ck_rsrc_ot_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_ot_flag CHECK (ot_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrc_timesheet_flag on table RSRC


--METADATA NAME:ck_rsrc_timesheet_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_timesheet_flag CHECK (timesheet_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrc_def_cost_qty_flag on table RSRC


--METADATA NAME:ck_rsrc_def_cost_qty_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_def_cost_qty_flag CHECK (def_cost_qty_link_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrccurv_default_flag on table RSRCCURV


--METADATA NAME:ck_rsrccurv_default_flag TYPE:CONSTRAINT TABLE_NAME:RSRCCURV CHANGE:CREATE
ALTER TABLE RSRCCURV
ADD CONSTRAINT ck_rsrccurv_default_flag CHECK (default_flag in ('Y', 'N'))
/

prompt Creating constraint ck_rsrchour_task_ts_flag on table RSRCHOUR


--METADATA NAME:ck_rsrchour_task_ts_flag TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT ck_rsrchour_task_ts_flag CHECK (task_ts_flag in ('Y', 'N'))
/

prompt Creating constraint ck_task_auto_compute_act_flag on table TASK


--METADATA NAME:ck_task_auto_compute_act_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_auto_compute_act_flag CHECK (auto_compute_act_flag in ('Y', 'N'))
/

prompt Creating constraint ck_task_rev_fdbk_flag on table TASK


--METADATA NAME:ck_task_rev_fdbk_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_rev_fdbk_flag CHECK (rev_fdbk_flag in ('Y', 'N'))
/

prompt Creating constraint ck_task_lock_plan_flag on table TASK


--METADATA NAME:ck_task_lock_plan_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_lock_plan_flag CHECK (lock_plan_flag in ('Y', 'N'))
/

prompt Creating constraint ck_driving_path_flag on table TASK


--METADATA NAME:ck_driving_path_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_driving_path_flag CHECK (driving_path_flag in ('Y', 'N'))
/

prompt Creating constraint ck_taskdoc_wp_flag on table TASKDOC


--METADATA NAME:ck_taskdoc_wp_flag TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT ck_taskdoc_wp_flag CHECK (wp_flag in ('Y', 'N'))
/

prompt Creating constraint ck_taskproc_complete_flag on table TASKPROC


--METADATA NAME:ck_taskproc_complete_flag TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT ck_taskproc_complete_flag CHECK (complete_flag in ('Y', 'N'))
/

prompt Creating constraint ck_taskrsrc_cost_qty_flag on table TASKRSRC


--METADATA NAME:ck_taskrsrc_cost_qty_flag TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT ck_taskrsrc_cost_qty_flag CHECK (cost_qty_link_flag in ('Y', 'N'))
/

prompt Creating constraint ck_thrsparm_rsrc_flag on table THRSPARM


--METADATA NAME:ck_thrsparm_rsrc_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_rsrc_flag CHECK (rsrc_flag in ('Y', 'N'))
/

prompt Creating constraint ck_thrsparm_task_flag on table THRSPARM


--METADATA NAME:ck_thrsparm_task_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_task_flag CHECK (task_flag in ('Y', 'N'))
/

prompt Creating constraint ck_thrsparm_wbs_flag on table THRSPARM


--METADATA NAME:ck_thrsparm_wbs_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_wbs_flag CHECK (wbs_flag in ('Y', 'N'))
/

prompt Creating constraint ck_timesht_daily_flag on table TIMESHT


--METADATA NAME:ck_timesht_daily_flag TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT ck_timesht_daily_flag CHECK (daily_flag in ('Y', 'N'))
/

prompt Creating constraint ck_trakview_web_view_flag on table TRAKVIEW


--METADATA NAME:ck_trakview_web_view_flag TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT ck_trakview_web_view_flag CHECK (web_view_flag in ('Y', 'N'))
/

prompt Creating constraint ck_users_global_flag on table USERS


--METADATA NAME:ck_users_global_flag TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT ck_users_global_flag CHECK (global_flag in ('Y', 'N'))
/

prompt Creating constraint ck_wbsstep_complete_flag on table WBSSTEP


--METADATA NAME:ck_wbsstep_complete_flag TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT ck_wbsstep_complete_flag CHECK (complete_flag in ('Y', 'N'))
/

prompt Creating constraint ck_workflow_existing_proj_flag on table WORKFLOW


--METADATA NAME:ck_workflow_existing_proj_flag TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT ck_workflow_existing_proj_flag CHECK (existing_project_flag in ('Y', 'N'))
/

prompt Creating index ndx_account_parent_acct on table ACCOUNT

--METADATA NAME:ndx_account_parent_acct TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE INDEX ndx_account_parent_acct
ON ACCOUNT (parent_acct_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_account_dsi on table ACCOUNT

--METADATA NAME:ndx_account_dsi TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE INDEX ndx_account_dsi
ON ACCOUNT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_account_upd on table ACCOUNT

--METADATA NAME:ndx_account_upd TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE INDEX ndx_account_upd
ON ACCOUNT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcode_1 on table ACTVCODE

--METADATA NAME:ndx_actvcode_1 TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE INDEX ndx_actvcode_1
ON ACTVCODE (actv_code_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcode_parent_actv on table ACTVCODE

--METADATA NAME:ndx_actvcode_parent_actv TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE INDEX ndx_actvcode_parent_actv
ON ACTVCODE (parent_actv_code_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 400K next 400K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcode_update_date1 on table ACTVCODE

--METADATA NAME:ndx_actvcode_update_date1 TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE INDEX ndx_actvcode_update_date1
ON ACTVCODE (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 400K next 400K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcode_dsi on table ACTVCODE

--METADATA NAME:ndx_actvcode_dsi TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE INDEX ndx_actvcode_dsi
ON ACTVCODE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 400K next 400K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcode_upd on table ACTVCODE

--METADATA NAME:ndx_actvcode_upd TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE INDEX ndx_actvcode_upd
ON ACTVCODE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvtype_1 on table ACTVTYPE

--METADATA NAME:ndx_actvtype_1 TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE INDEX ndx_actvtype_1
ON ACTVTYPE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvtype_dsi on table ACTVTYPE

--METADATA NAME:ndx_actvtype_dsi TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE INDEX ndx_actvtype_dsi
ON ACTVTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvtype_upd on table ACTVTYPE

--METADATA NAME:ndx_actvtype_upd TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE INDEX ndx_actvtype_upd
ON ACTVTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_admin_config_dsi on table ADMIN_CONFIG

--METADATA NAME:ndx_admin_config_dsi TYPE:INDEX TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
CREATE INDEX ndx_admin_config_dsi
ON ADMIN_CONFIG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_admin_config_upd on table ADMIN_CONFIG

--METADATA NAME:ndx_admin_config_upd TYPE:INDEX TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
CREATE INDEX ndx_admin_config_upd
ON ADMIN_CONFIG (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnacat_asgnmntcattype
ON ASGNMNTACAT (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_asgnmntcatval
ON ASGNMNTACAT (asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_update_date1
ON ASGNMNTACAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_dsi
ON ASGNMNTACAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_upd
ON ASGNMNTACAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_proj_id
ON ASGNMNTACAT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX ndx_asgnmntacat_taskrsrc_id
ON ASGNMNTACAT (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX ndx_asgnmntcattype_dsi
ON ASGNMNTCATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX ndx_asgnmntcattype_upd
ON ASGNMNTCATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX ndx_asgncatval_asgnmntcattype
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX ndx_asgnmntcatval_parent_catg
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX ndx_asgnmntcatval_dsi
ON ASGNMNTCATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX ndx_asgnmntcatval_upd
ON ASGNMNTCATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_basetype_dsi on table BASETYPE

--METADATA NAME:ndx_basetype_dsi TYPE:INDEX TABLE_NAME:BASETYPE CHANGE:CREATE
CREATE INDEX ndx_basetype_dsi
ON BASETYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_basetype_upd on table BASETYPE

--METADATA NAME:ndx_basetype_upd TYPE:INDEX TABLE_NAME:BASETYPE CHANGE:CREATE
CREATE INDEX ndx_basetype_upd
ON BASETYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_bgplog on table BGPLOG

--METADATA NAME:ndx_bgplog TYPE:INDEX TABLE_NAME:BGPLOG CHANGE:CREATE
CREATE INDEX ndx_bgplog
ON BGPLOG (log_time)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_bre_registry_dsi on table BRE_REGISTRY

--METADATA NAME:ndx_bre_registry_dsi TYPE:INDEX TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
CREATE INDEX ndx_bre_registry_dsi
ON BRE_REGISTRY (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_budgchng_1 on table BUDGCHNG

--METADATA NAME:ndx_budgchng_1 TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE INDEX ndx_budgchng_1
ON BUDGCHNG (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_budgchng_2 on table BUDGCHNG

--METADATA NAME:ndx_budgchng_2 TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE INDEX ndx_budgchng_2
ON BUDGCHNG (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_budgchng_dsi on table BUDGCHNG

--METADATA NAME:ndx_budgchng_dsi TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE INDEX ndx_budgchng_dsi
ON BUDGCHNG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_calendar_1 on table CALENDAR

--METADATA NAME:ndx_calendar_1 TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE INDEX ndx_calendar_1
ON CALENDAR (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_calendar_dsi on table CALENDAR

--METADATA NAME:ndx_calendar_dsi TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE INDEX ndx_calendar_dsi
ON CALENDAR (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_calendar_upd on table CALENDAR

--METADATA NAME:ndx_calendar_upd TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE INDEX ndx_calendar_upd
ON CALENDAR (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_costtype_dsi on table COSTTYPE

--METADATA NAME:ndx_costtype_dsi TYPE:INDEX TABLE_NAME:COSTTYPE CHANGE:CREATE
CREATE INDEX ndx_costtype_dsi
ON COSTTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_costtype_upd on table COSTTYPE

--METADATA NAME:ndx_costtype_upd TYPE:INDEX TABLE_NAME:COSTTYPE CHANGE:CREATE
CREATE INDEX ndx_costtype_upd
ON COSTTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_curr_short_name on table CURRTYPE

--METADATA NAME:ndx_curr_short_name TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE UNIQUE INDEX ndx_curr_short_name
ON CURRTYPE (curr_short_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_currtype_dsi on table CURRTYPE

--METADATA NAME:ndx_currtype_dsi TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE INDEX ndx_currtype_dsi
ON CURRTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_currtype_upd on table CURRTYPE

--METADATA NAME:ndx_currtype_upd TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE INDEX ndx_currtype_upd
ON CURRTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashboard_1 on table DASHBOARD

--METADATA NAME:ndx_dashboard_1 TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE INDEX ndx_dashboard_1
ON DASHBOARD (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashboard_dsi on table DASHBOARD

--METADATA NAME:ndx_dashboard_dsi TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE INDEX ndx_dashboard_dsi
ON DASHBOARD (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashboard_upd on table DASHBOARD

--METADATA NAME:ndx_dashboard_upd TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE INDEX ndx_dashboard_upd
ON DASHBOARD (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashuser_1 on table DASHUSER

--METADATA NAME:ndx_dashuser_1 TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE INDEX ndx_dashuser_1
ON DASHUSER (user_id,dashboard_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashuser_dsi on table DASHUSER

--METADATA NAME:ndx_dashuser_dsi TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE INDEX ndx_dashuser_dsi
ON DASHUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dashuser_upd on table DASHUSER

--METADATA NAME:ndx_dashuser_upd TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE INDEX ndx_dashuser_upd
ON DASHUSER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_1 on table DISCUSSION

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_2 on table DISCUSSION

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_dsi on table DISCUSSION

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_read_dsi on table DISCUSSION_READ

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doccatg_dsi on table DOCCATG

--METADATA NAME:ndx_doccatg_dsi TYPE:INDEX TABLE_NAME:DOCCATG CHANGE:CREATE
CREATE INDEX ndx_doccatg_dsi
ON DOCCATG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doccatg_upd on table DOCCATG

--METADATA NAME:ndx_doccatg_upd TYPE:INDEX TABLE_NAME:DOCCATG CHANGE:CREATE
CREATE INDEX ndx_doccatg_upd
ON DOCCATG (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_document on table DOCREVIEW

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX ndx_docreview_document
ON DOCREVIEW (doc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_users on table DOCREVIEW

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX ndx_docreview_users
ON DOCREVIEW (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX ndx_docreviewtask_docreview
ON DOCREVIEWTASK (doc_review_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_users on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX ndx_docreviewtask_users
ON DOCREVIEWTASK (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docstat_dsi on table DOCSTAT

--METADATA NAME:ndx_docstat_dsi TYPE:INDEX TABLE_NAME:DOCSTAT CHANGE:CREATE
CREATE INDEX ndx_docstat_dsi
ON DOCSTAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docstat_upd on table DOCSTAT

--METADATA NAME:ndx_docstat_upd TYPE:INDEX TABLE_NAME:DOCSTAT CHANGE:CREATE
CREATE INDEX ndx_docstat_upd
ON DOCSTAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_1 on table DOCUMENT

--METADATA NAME:ndx_document_1 TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_1
ON DOCUMENT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_doccatg on table DOCUMENT

--METADATA NAME:ndx_document_doccatg TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_doccatg
ON DOCUMENT (doc_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_docstat on table DOCUMENT

--METADATA NAME:ndx_document_docstat TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_docstat
ON DOCUMENT (doc_status_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_parent_doc on table DOCUMENT

--METADATA NAME:ndx_document_parent_doc TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_parent_doc
ON DOCUMENT (parent_doc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_dsi on table DOCUMENT

--METADATA NAME:ndx_document_dsi TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_dsi
ON DOCUMENT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_rsrc on table DOCUMENT

--METADATA NAME:ndx_document_rsrc TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_rsrc
ON DOCUMENT (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_cr_external_key on table DOCUMENT

--METADATA NAME:ndx_document_cr_external_key TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
declare 
v_spl_ind number;
maximum_key_length exception;
pragma EXCEPTION_INIT (maximum_key_length, -1450);
begin
  select count(*)  into v_spl_ind from user_ind_columns 
  where index_name= 'NDX_DOCUMENT_CR_EXTERNAL_KEY' 
  and table_name = 'DOCUMENT' 
  and column_name = 'CR_EXTERNAL_DOC_KEY'; 

  if v_spl_ind = 0 then
    execute immediate 'CREATE INDEX ndx_document_cr_external_key
    ON DOCUMENT (cr_external_doc_key)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';

  end if;
exception when maximum_key_length then 
    execute immediate 'CREATE INDEX ndx_document_cr_external_key
    ON DOCUMENT (standard_hash(cr_external_doc_key))
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';

  when others then
    null;
end;
/

prompt Creating index ndx_expproj_dsi on table EXPPROJ

--METADATA NAME:ndx_expproj_dsi TYPE:INDEX TABLE_NAME:EXPPROJ CHANGE:CREATE
CREATE INDEX ndx_expproj_dsi
ON EXPPROJ (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_expproj_upd on table EXPPROJ

--METADATA NAME:ndx_expproj_upd TYPE:INDEX TABLE_NAME:EXPPROJ CHANGE:CREATE
CREATE INDEX ndx_expproj_upd
ON EXPPROJ (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_extapp_1 on table EXTAPP

--METADATA NAME:ndx_extapp_1 TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE INDEX ndx_extapp_1
ON EXTAPP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_extapp_dsi on table EXTAPP

--METADATA NAME:ndx_extapp_dsi TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE INDEX ndx_extapp_dsi
ON EXTAPP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_extapp_upd on table EXTAPP

--METADATA NAME:ndx_extapp_upd TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE INDEX ndx_extapp_upd
ON EXTAPP (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_factor_dsi on table FACTOR

--METADATA NAME:ndx_factor_dsi TYPE:INDEX TABLE_NAME:FACTOR CHANGE:CREATE
CREATE INDEX ndx_factor_dsi
ON FACTOR (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_factor_upd on table FACTOR

--METADATA NAME:ndx_factor_upd TYPE:INDEX TABLE_NAME:FACTOR CHANGE:CREATE
CREATE INDEX ndx_factor_upd
ON FACTOR (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_factval_factor on table FACTVAL

--METADATA NAME:ndx_factval_factor TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE INDEX ndx_factval_factor
ON FACTVAL (fact_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_factval_dsi on table FACTVAL

--METADATA NAME:ndx_factval_dsi TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE INDEX ndx_factval_dsi
ON FACTVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_factval_upd on table FACTVAL

--METADATA NAME:ndx_factval_upd TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE INDEX ndx_factval_upd
ON FACTVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_filtprop_1 on table FILTPROP

--METADATA NAME:ndx_filtprop_1 TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE INDEX ndx_filtprop_1
ON FILTPROP (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_filtprop_dsi on table FILTPROP

--METADATA NAME:ndx_filtprop_dsi TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE INDEX ndx_filtprop_dsi
ON FILTPROP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_filtprop_upd on table FILTPROP

--METADATA NAME:ndx_filtprop_upd TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE INDEX ndx_filtprop_upd
ON FILTPROP (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_dsi on table FINDATES

--METADATA NAME:ndx_findates_dsi TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX ndx_findates_dsi
ON FINDATES (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_upd on table FINDATES

--METADATA NAME:ndx_findates_upd TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX ndx_findates_upd
ON FINDATES (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_1 on table FINDATES

--METADATA NAME:ndx_findates_1 TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX ndx_findates_1
ON FINDATES (start_date,end_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_fintmpl on table FINDATES

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX ndx_findates_fintmpl
ON FINDATES (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_dsi on table FINTMPL

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX ndx_fintmpl_dsi
ON FINTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_upd on table FINTMPL

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX ndx_fintmpl_upd
ON FINTMPL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formcatg_dsi on table FORMCATG

--METADATA NAME:ndx_formcatg_dsi TYPE:INDEX TABLE_NAME:FORMCATG CHANGE:CREATE
CREATE INDEX ndx_formcatg_dsi
ON FORMCATG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formproj_formtmpl on table FORMPROJ

--METADATA NAME:ndx_formproj_formtmpl TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE INDEX ndx_formproj_formtmpl
ON FORMPROJ (form_tmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formproj_project on table FORMPROJ

--METADATA NAME:ndx_formproj_project TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE INDEX ndx_formproj_project
ON FORMPROJ (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formproj_dsi on table FORMPROJ

--METADATA NAME:ndx_formproj_dsi TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE INDEX ndx_formproj_dsi
ON FORMPROJ (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formtmpl_formcatg on table FORMTMPL

--METADATA NAME:ndx_formtmpl_formcatg TYPE:INDEX TABLE_NAME:FORMTMPL CHANGE:CREATE
CREATE INDEX ndx_formtmpl_formcatg
ON FORMTMPL (form_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_formtmpl_dsi on table FORMTMPL

--METADATA NAME:ndx_formtmpl_dsi TYPE:INDEX TABLE_NAME:FORMTMPL CHANGE:CREATE
CREATE INDEX ndx_formtmpl_dsi
ON FORMTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fundsrc_parent_fund on table FUNDSRC

--METADATA NAME:ndx_fundsrc_parent_fund TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE INDEX ndx_fundsrc_parent_fund
ON FUNDSRC (parent_fund_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 1000K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fundsrc_dsi on table FUNDSRC

--METADATA NAME:ndx_fundsrc_dsi TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE INDEX ndx_fundsrc_dsi
ON FUNDSRC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fundsrc_upd on table FUNDSRC

--METADATA NAME:ndx_fundsrc_upd TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE INDEX ndx_fundsrc_upd
ON FUNDSRC (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_gchange_user on table GCHANGE

--METADATA NAME:ndx_gchange_user TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE INDEX ndx_gchange_user
ON GCHANGE (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_gchange_dsi on table GCHANGE

--METADATA NAME:ndx_gchange_dsi TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE INDEX ndx_gchange_dsi
ON GCHANGE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_gchange_upd on table GCHANGE

--METADATA NAME:ndx_gchange_upd TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE INDEX ndx_gchange_upd
ON GCHANGE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_imagedata_image_name on table IMAGEDATA

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_issuhist_1 on table ISSUHIST

--METADATA NAME:ndx_issuhist_1 TYPE:INDEX TABLE_NAME:ISSUHIST CHANGE:CREATE
CREATE INDEX ndx_issuhist_1
ON ISSUHIST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_issuhist_dsi on table ISSUHIST

--METADATA NAME:ndx_issuhist_dsi TYPE:INDEX TABLE_NAME:ISSUHIST CHANGE:CREATE
CREATE INDEX ndx_issuhist_dsi
ON ISSUHIST (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iteration_release on table ITERATION

--METADATA NAME:ndx_iteration_release TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE
CREATE INDEX ndx_iteration_release
ON ITERATION (release_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 64K next 64K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iteration_dsi on table ITERATION

--METADATA NAME:ndx_iteration_dsi TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE
CREATE INDEX ndx_iteration_dsi
ON ITERATION (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iterdays_project on table ITERDAYS

--METADATA NAME:ndx_iterdays_project TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE INDEX ndx_iterdays_project
ON ITERDAYS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iterdays_iteration on table ITERDAYS

--METADATA NAME:ndx_iterdays_iteration TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE INDEX ndx_iterdays_iteration
ON ITERDAYS (iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iterdays_task on table ITERDAYS

--METADATA NAME:ndx_iterdays_task TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE INDEX ndx_iterdays_task
ON ITERDAYS (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_iterdays_dsi on table ITERDAYS

--METADATA NAME:ndx_iterdays_dsi TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE INDEX ndx_iterdays_dsi
ON ITERDAYS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_itergoal_iteration on table ITERGOAL

--METADATA NAME:ndx_itergoal_iteration TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE INDEX ndx_itergoal_iteration
ON ITERGOAL (iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_itergoal_rfolio on table ITERGOAL

--METADATA NAME:ndx_itergoal_rfolio TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE INDEX ndx_itergoal_rfolio
ON ITERGOAL (rfolio_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 128K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_itergoal_dsi on table ITERGOAL

--METADATA NAME:ndx_itergoal_dsi TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE INDEX ndx_itergoal_dsi
ON ITERGOAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_joblog_dsi on table JOBLOG

--METADATA NAME:ndx_joblog_dsi TYPE:INDEX TABLE_NAME:JOBLOG CHANGE:CREATE
CREATE INDEX ndx_joblog_dsi
ON JOBLOG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_joblog_upd on table JOBLOG

--METADATA NAME:ndx_joblog_upd TYPE:INDEX TABLE_NAME:JOBLOG CHANGE:CREATE
CREATE INDEX ndx_joblog_upd
ON JOBLOG (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobrpt_jobsvc on table JOBRPT

--METADATA NAME:ndx_jobrpt_jobsvc TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE UNIQUE INDEX ndx_jobrpt_jobsvc
ON JOBRPT (job_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobrpt_rpt on table JOBRPT

--METADATA NAME:ndx_jobrpt_rpt TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE INDEX ndx_jobrpt_rpt
ON JOBRPT (rpt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobrpt_dsi on table JOBRPT

--METADATA NAME:ndx_jobrpt_dsi TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE INDEX ndx_jobrpt_dsi
ON JOBRPT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobrpt_upd on table JOBRPT

--METADATA NAME:ndx_jobrpt_upd TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE INDEX ndx_jobrpt_upd
ON JOBRPT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobsvc_users on table JOBSVC

--METADATA NAME:ndx_jobsvc_users TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE INDEX ndx_jobsvc_users
ON JOBSVC (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobsvc_dsi on table JOBSVC

--METADATA NAME:ndx_jobsvc_dsi TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE INDEX ndx_jobsvc_dsi
ON JOBSVC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobsvc_upd on table JOBSVC

--METADATA NAME:ndx_jobsvc_upd TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE INDEX ndx_jobsvc_upd
ON JOBSVC (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_memotype_dsi on table MEMOTYPE

--METADATA NAME:ndx_memotype_dsi TYPE:INDEX TABLE_NAME:MEMOTYPE CHANGE:CREATE
CREATE INDEX ndx_memotype_dsi
ON MEMOTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_memotype_upd on table MEMOTYPE

--METADATA NAME:ndx_memotype_upd TYPE:INDEX TABLE_NAME:MEMOTYPE CHANGE:CREATE
CREATE INDEX ndx_memotype_upd
ON MEMOTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_nonwork_dsi on table NONWORK

--METADATA NAME:ndx_nonwork_dsi TYPE:INDEX TABLE_NAME:NONWORK CHANGE:CREATE
CREATE INDEX ndx_nonwork_dsi
ON NONWORK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_nonwork_upd on table NONWORK

--METADATA NAME:ndx_nonwork_upd TYPE:INDEX TABLE_NAME:NONWORK CHANGE:CREATE
CREATE INDEX ndx_nonwork_upd
ON NONWORK (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_note_dsi on table NOTE

--METADATA NAME:ndx_note_dsi TYPE:INDEX TABLE_NAME:NOTE CHANGE:CREATE
CREATE INDEX ndx_note_dsi
ON NOTE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_note_upd on table NOTE

--METADATA NAME:ndx_note_upd TYPE:INDEX TABLE_NAME:NOTE CHANGE:CREATE
CREATE INDEX ndx_note_upd
ON NOTE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_obs_parent_obs on table OBS

--METADATA NAME:ndx_obs_parent_obs TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE INDEX ndx_obs_parent_obs
ON OBS (parent_obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_obs_dsi on table OBS

--METADATA NAME:ndx_obs_dsi TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE INDEX ndx_obs_dsi
ON OBS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_obs_upd on table OBS

--METADATA NAME:ndx_obs_upd TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE INDEX ndx_obs_upd
ON OBS (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_obsproj_project on table OBSPROJ

--METADATA NAME:ndx_obsproj_project TYPE:INDEX TABLE_NAME:OBSPROJ CHANGE:CREATE
CREATE INDEX ndx_obsproj_project
ON OBSPROJ (proj_id,obs_id,wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_obsproj_wbs on table OBSPROJ

--METADATA NAME:ndx_obsproj_wbs TYPE:INDEX TABLE_NAME:OBSPROJ CHANGE:CREATE
CREATE INDEX ndx_obsproj_wbs
ON OBSPROJ (wbs_id,proj_id,obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcattype_dsi on table PCATTYPE

--METADATA NAME:ndx_pcattype_dsi TYPE:INDEX TABLE_NAME:PCATTYPE CHANGE:CREATE
CREATE INDEX ndx_pcattype_dsi
ON PCATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcattype_upd on table PCATTYPE

--METADATA NAME:ndx_pcattype_upd TYPE:INDEX TABLE_NAME:PCATTYPE CHANGE:CREATE
CREATE INDEX ndx_pcattype_upd
ON PCATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatuser_user on table PCATUSER

--METADATA NAME:ndx_pcatuser_user TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE INDEX ndx_pcatuser_user
ON PCATUSER (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50k next 50k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatuser_dsi on table PCATUSER

--METADATA NAME:ndx_pcatuser_dsi TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE INDEX ndx_pcatuser_dsi
ON PCATUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatuser_upd on table PCATUSER

--METADATA NAME:ndx_pcatuser_upd TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE INDEX ndx_pcatuser_upd
ON PCATUSER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatval_pcattype on table PCATVAL

--METADATA NAME:ndx_pcatval_pcattype TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE INDEX ndx_pcatval_pcattype
ON PCATVAL (proj_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatval_parent_catg on table PCATVAL

--METADATA NAME:ndx_pcatval_parent_catg TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE INDEX ndx_pcatval_parent_catg
ON PCATVAL (parent_proj_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatval_dsi on table PCATVAL

--METADATA NAME:ndx_pcatval_dsi TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE INDEX ndx_pcatval_dsi
ON PCATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pcatval_upd on table PCATVAL

--METADATA NAME:ndx_pcatval_upd TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE INDEX ndx_pcatval_upd
ON PCATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pfolio_1 on table PFOLIO

--METADATA NAME:ndx_pfolio_1 TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE INDEX ndx_pfolio_1
ON PFOLIO (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pfolio_dsi on table PFOLIO

--METADATA NAME:ndx_pfolio_dsi TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE INDEX ndx_pfolio_dsi
ON PFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pfolio_upd on table PFOLIO

--METADATA NAME:ndx_pfolio_upd TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE INDEX ndx_pfolio_upd
ON PFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_phase_dsi on table PHASE

--METADATA NAME:ndx_phase_dsi TYPE:INDEX TABLE_NAME:PHASE CHANGE:CREATE
CREATE INDEX ndx_phase_dsi
ON PHASE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_phase_upd on table PHASE

--METADATA NAME:ndx_phase_upd TYPE:INDEX TABLE_NAME:PHASE CHANGE:CREATE
CREATE INDEX ndx_phase_upd
ON PHASE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pkxref_1 on table PKXREF

--METADATA NAME:ndx_pkxref_1 TYPE:INDEX TABLE_NAME:PKXREF CHANGE:CREATE
CREATE INDEX ndx_pkxref_1
ON PKXREF (system_id,context_name,pk1,pk2)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pkxref_2 on table PKXREF

--METADATA NAME:ndx_pkxref_2 TYPE:INDEX TABLE_NAME:PKXREF CHANGE:CREATE
CREATE INDEX ndx_pkxref_2
ON PKXREF (system_id,context_name,old_pk1,old_pk2)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pobs_parent_id on table POBS

--METADATA NAME:ndx_pobs_parent_id TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE INDEX ndx_pobs_parent_id
ON POBS (pobs_parent_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pobs_dsi on table POBS

--METADATA NAME:ndx_pobs_dsi TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE INDEX ndx_pobs_dsi
ON POBS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pobs_upd on table POBS

--METADATA NAME:ndx_pobs_upd TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE INDEX ndx_pobs_upd
ON POBS (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_users on table PREFER

--METADATA NAME:ndx_prefer_users TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE INDEX ndx_prefer_users
ON PREFER (ts_approve_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32k next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_users2 on table PREFER

--METADATA NAME:ndx_prefer_users2 TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE INDEX ndx_prefer_users2
ON PREFER (projinit_admin_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32k next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_rsrc on table PREFER

--METADATA NAME:ndx_prefer_rsrc TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE INDEX ndx_prefer_rsrc
ON PREFER (default_rsrc_sec_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32k next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_dsi on table PREFER

--METADATA NAME:ndx_prefer_dsi TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE INDEX ndx_prefer_dsi
ON PREFER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_upd on table PREFER

--METADATA NAME:ndx_prefer_upd TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE INDEX ndx_prefer_upd
ON PREFER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prmaudit_audit_date on table PRMAUDIT

--METADATA NAME:ndx_prmaudit_audit_date TYPE:INDEX TABLE_NAME:PRMAUDIT CHANGE:CREATE
CREATE INDEX ndx_prmaudit_audit_date
ON PRMAUDIT (audit_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prmqueue_lookup on table PRMQUEUE

--METADATA NAME:ndx_prmqueue_lookup TYPE:INDEX TABLE_NAME:PRMQUEUE CHANGE:CREATE
CREATE INDEX ndx_prmqueue_lookup
ON PRMQUEUE (queue_name,msg_type,msg_sub_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_procgroup_dsi on table PROCGROUP

--METADATA NAME:ndx_procgroup_dsi TYPE:INDEX TABLE_NAME:PROCGROUP CHANGE:CREATE
CREATE INDEX ndx_procgroup_dsi
ON PROCGROUP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_procgroup_upd on table PROCGROUP

--METADATA NAME:ndx_procgroup_upd TYPE:INDEX TABLE_NAME:PROCGROUP CHANGE:CREATE
CREATE INDEX ndx_procgroup_upd
ON PROCGROUP (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_procitem on table PROCITEM

--METADATA NAME:ndx_procitem TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE INDEX ndx_procitem
ON PROCITEM (proc_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 64k next 64k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_procitem_dsi on table PROCITEM

--METADATA NAME:ndx_procitem_dsi TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE INDEX ndx_procitem_dsi
ON PROCITEM (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_procitem_upd on table PROCITEM

--METADATA NAME:ndx_procitem_upd TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE INDEX ndx_procitem_upd
ON PROCITEM (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_profile_dsi on table PROFILE

--METADATA NAME:ndx_profile_dsi TYPE:INDEX TABLE_NAME:PROFILE CHANGE:CREATE
CREATE INDEX ndx_profile_dsi
ON PROFILE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_profile_upd on table PROFILE

--METADATA NAME:ndx_profile_upd TYPE:INDEX TABLE_NAME:PROFILE CHANGE:CREATE
CREATE INDEX ndx_profile_upd
ON PROFILE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_profpriv_dsi on table PROFPRIV

--METADATA NAME:ndx_profpriv_dsi TYPE:INDEX TABLE_NAME:PROFPRIV CHANGE:CREATE
CREATE INDEX ndx_profpriv_dsi
ON PROFPRIV (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_profpriv_upd on table PROFPRIV

--METADATA NAME:ndx_profpriv_upd TYPE:INDEX TABLE_NAME:PROFPRIV CHANGE:CREATE
CREATE INDEX ndx_profpriv_upd
ON PROFPRIV (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_1 on table PROJCOST

--METADATA NAME:ndx_projcost_1 TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_1
ON PROJCOST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_account on table PROJCOST

--METADATA NAME:ndx_projcost_account TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_account
ON PROJCOST (acct_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_costtype on table PROJCOST

--METADATA NAME:ndx_projcost_costtype TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_costtype
ON PROJCOST (cost_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_task on table PROJCOST

--METADATA NAME:ndx_projcost_task TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_task
ON PROJCOST (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_pobs on table PROJCOST

--METADATA NAME:ndx_projcost_pobs TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_pobs
ON PROJCOST (pobs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_update_date1 on table PROJCOST

--METADATA NAME:ndx_projcost_update_date1 TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_update_date1
ON PROJCOST (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_dsi on table PROJCOST

--METADATA NAME:ndx_projcost_dsi TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE INDEX ndx_projcost_dsi
ON PROJCOST (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_account on table PROJECT

--METADATA NAME:ndx_project_account TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_account
ON PROJECT (acct_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_basetype on table PROJECT

--METADATA NAME:ndx_project_basetype TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_basetype
ON PROJECT (base_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_orig_proj_id on table PROJECT

--METADATA NAME:ndx_project_orig_proj_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_orig_proj_id
ON PROJECT (orig_proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_checkout_user_id on table PROJECT

--METADATA NAME:ndx_project_checkout_user_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_checkout_user_id
ON PROJECT (checkout_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_update_date1 on table PROJECT

--METADATA NAME:ndx_project_update_date1 TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_update_date1
ON PROJECT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_source_proj_id on table PROJECT

--METADATA NAME:ndx_project_source_proj_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_source_proj_id
ON PROJECT (source_proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_calendar on table PROJECT

--METADATA NAME:ndx_project_calendar TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_calendar
ON PROJECT (clndr_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_last_fin_dates on table PROJECT

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_last_fin_dates
ON PROJECT (last_fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_matrix on table PROJECT

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_matrix
ON PROJECT (matrix_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_dsi on table PROJECT

--METADATA NAME:ndx_project_dsi TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_dsi
ON PROJECT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_upd on table PROJECT

--METADATA NAME:ndx_project_upd TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_upd
ON PROJECT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_fintmpl on table PROJECT

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_fintmpl
ON PROJECT (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projest_1 on table PROJEST

--METADATA NAME:ndx_projest_1 TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE INDEX ndx_projest_1
ON PROJEST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projest_projwbs on table PROJEST

--METADATA NAME:ndx_projest_projwbs TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE INDEX ndx_projest_projwbs
ON PROJEST (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projest_rsrc on table PROJEST

--METADATA NAME:ndx_projest_rsrc TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE INDEX ndx_projest_rsrc
ON PROJEST (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projest_dsi on table PROJEST

--METADATA NAME:ndx_projest_dsi TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE INDEX ndx_projest_dsi
ON PROJEST (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projfund_1 on table PROJFUND

--METADATA NAME:ndx_projfund_1 TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE INDEX ndx_projfund_1
ON PROJFUND (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projfund_fundsrc on table PROJFUND

--METADATA NAME:ndx_projfund_fundsrc TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE INDEX ndx_projfund_fundsrc
ON PROJFUND (fund_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projfund_dsi on table PROJFUND

--METADATA NAME:ndx_projfund_dsi TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE INDEX ndx_projfund_dsi
ON PROJFUND (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_1 on table PROJISSU

--METADATA NAME:ndx_projissu_1 TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_1
ON PROJISSU (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_obs on table PROJISSU

--METADATA NAME:ndx_projissu_obs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_obs
ON PROJISSU (obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_projthrs on table PROJISSU

--METADATA NAME:ndx_projissu_projthrs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_projthrs
ON PROJISSU (thresh_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_projwbs on table PROJISSU

--METADATA NAME:ndx_projissu_projwbs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_projwbs
ON PROJISSU (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_rsrc on table PROJISSU

--METADATA NAME:ndx_projissu_rsrc TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_rsrc
ON PROJISSU (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_task on table PROJISSU

--METADATA NAME:ndx_projissu_task TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_task
ON PROJISSU (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_thrsparm on table PROJISSU

--METADATA NAME:ndx_projissu_thrsparm TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_thrsparm
ON PROJISSU (thresh_parm_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_trakview on table PROJISSU

--METADATA NAME:ndx_projissu_trakview TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_trakview
ON PROJISSU (track_view_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_workspace on table PROJISSU

--METADATA NAME:ndx_projissu_workspace TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_workspace
ON PROJISSU (workspace_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projissu_dsi on table PROJISSU

--METADATA NAME:ndx_projissu_dsi TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE INDEX ndx_projissu_dsi
ON PROJISSU (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_pcattype on table PROJPCAT

--METADATA NAME:ndx_projpcat_pcattype TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE INDEX ndx_projpcat_pcattype
ON PROJPCAT (proj_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_pcatval on table PROJPCAT

--METADATA NAME:ndx_projpcat_pcatval TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE INDEX ndx_projpcat_pcatval
ON PROJPCAT (proj_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_update_date1 on table PROJPCAT

--METADATA NAME:ndx_projpcat_update_date1 TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE INDEX ndx_projpcat_update_date1
ON PROJPCAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_dsi on table PROJPCAT

--METADATA NAME:ndx_projpcat_dsi TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE INDEX ndx_projpcat_dsi
ON PROJPCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_upd on table PROJPCAT

--METADATA NAME:ndx_projpcat_upd TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE INDEX ndx_projpcat_upd
ON PROJPCAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projprop_dsi on table PROJPROP

--METADATA NAME:ndx_projprop_dsi TYPE:INDEX TABLE_NAME:PROJPROP CHANGE:CREATE
CREATE INDEX ndx_projprop_dsi
ON PROJPROP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_1 on table PROJRISK

--METADATA NAME:ndx_projrisk_1 TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE INDEX ndx_projrisk_1
ON PROJRISK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_risktype on table PROJRISK

--METADATA NAME:ndx_projrisk_risktype TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE INDEX ndx_projrisk_risktype
ON PROJRISK (risk_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_rsrc on table PROJRISK

--METADATA NAME:ndx_projrisk_rsrc TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE INDEX ndx_projrisk_rsrc
ON PROJRISK (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_dsi on table PROJRISK

--METADATA NAME:ndx_projrisk_dsi TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE INDEX ndx_projrisk_dsi
ON PROJRISK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projshar_usession on table PROJSHAR

--METADATA NAME:ndx_projshar_usession TYPE:INDEX TABLE_NAME:PROJSHAR CHANGE:CREATE
CREATE INDEX ndx_projshar_usession
ON PROJSHAR (session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_1 on table PROJTHRS

--METADATA NAME:ndx_projthrs_1 TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_1
ON PROJTHRS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_obs on table PROJTHRS

--METADATA NAME:ndx_projthrs_obs TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_obs
ON PROJTHRS (obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_projwbs on table PROJTHRS

--METADATA NAME:ndx_projthrs_projwbs TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_projwbs
ON PROJTHRS (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_thrsparm on table PROJTHRS

--METADATA NAME:ndx_projthrs_thrsparm TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_thrsparm
ON PROJTHRS (thresh_parm_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_trakview on table PROJTHRS

--METADATA NAME:ndx_projthrs_trakview TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_trakview
ON PROJTHRS (track_view_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projthrs_dsi on table PROJTHRS

--METADATA NAME:ndx_projthrs_dsi TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE INDEX ndx_projthrs_dsi
ON PROJTHRS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_1 on table PROJWBS

--METADATA NAME:ndx_projwbs_1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_1
ON PROJWBS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_obs on table PROJWBS

--METADATA NAME:ndx_projwbs_obs TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_obs
ON PROJWBS (obs_id,proj_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_parent_wbs_id on table PROJWBS

--METADATA NAME:ndx_projwbs_parent_wbs_id TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_parent_wbs_id
ON PROJWBS (parent_wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_projwbs_phase on table PROJWBS

--METADATA NAME:ndx_projwbs_phase TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_phase
ON PROJWBS (phase_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_update_date1 on table PROJWBS

--METADATA NAME:ndx_projwbs_update_date1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_update_date1
ON PROJWBS (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_rfolio_team on table PROJWBS

--METADATA NAME:ndx_projwbs_rfolio_team TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_rfolio_team
ON PROJWBS (resp_team_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_iteration on table PROJWBS

--METADATA NAME:ndx_projwbs_iteration TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_iteration
ON PROJWBS (iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_perf1 on table PROJWBS

--METADATA NAME:ndx_projwbs_perf1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_perf1
ON PROJWBS (proj_node_flag,proj_id,wbs_id,parent_wbs_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_perf2 on table PROJWBS

--METADATA NAME:ndx_projwbs_perf2 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_perf2
ON PROJWBS (proj_node_flag,obs_id,wbs_id,proj_id,parent_wbs_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_dsi on table PROJWBS

--METADATA NAME:ndx_projwbs_dsi TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_dsi
ON PROJWBS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_upd on table PROJWBS

--METADATA NAME:ndx_projwbs_upd TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE INDEX ndx_projwbs_upd
ON PROJWBS (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwsrpt_dsi on table PROJWSRPT

--METADATA NAME:ndx_projwsrpt_dsi TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE INDEX ndx_projwsrpt_dsi
ON PROJWSRPT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwsrpt_rpt on table PROJWSRPT

--METADATA NAME:ndx_projwsrpt_rpt TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE INDEX ndx_projwsrpt_rpt
ON PROJWSRPT (rpt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwsrpt_project on table PROJWSRPT

--METADATA NAME:ndx_projwsrpt_project TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE INDEX ndx_projwsrpt_project
ON PROJWSRPT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prpfolio_projwbs on table PRPFOLIO

--METADATA NAME:ndx_prpfolio_projwbs TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE INDEX ndx_prpfolio_projwbs
ON PRPFOLIO (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prpfolio_dsi on table PRPFOLIO

--METADATA NAME:ndx_prpfolio_dsi TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE INDEX ndx_prpfolio_dsi
ON PRPFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prpfolio_upd on table PRPFOLIO

--METADATA NAME:ndx_prpfolio_upd TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE INDEX ndx_prpfolio_upd
ON PRPFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_querylib_dsi on table QUERYLIB

--METADATA NAME:ndx_querylib_dsi TYPE:INDEX TABLE_NAME:QUERYLIB CHANGE:CREATE
CREATE INDEX ndx_querylib_dsi
ON QUERYLIB (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcattype_dsi on table RCATTYPE

--METADATA NAME:ndx_rcattype_dsi TYPE:INDEX TABLE_NAME:RCATTYPE CHANGE:CREATE
CREATE INDEX ndx_rcattype_dsi
ON RCATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcattype_upd on table RCATTYPE

--METADATA NAME:ndx_rcattype_upd TYPE:INDEX TABLE_NAME:RCATTYPE CHANGE:CREATE
CREATE INDEX ndx_rcattype_upd
ON RCATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcatval_rcattype on table RCATVAL

--METADATA NAME:ndx_rcatval_rcattype TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE INDEX ndx_rcatval_rcattype
ON RCATVAL (rsrc_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcatval_parent_catg on table RCATVAL

--METADATA NAME:ndx_rcatval_parent_catg TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE INDEX ndx_rcatval_parent_catg
ON RCATVAL (parent_rsrc_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcatval_dsi on table RCATVAL

--METADATA NAME:ndx_rcatval_dsi TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE INDEX ndx_rcatval_dsi
ON RCATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rcatval_upd on table RCATVAL

--METADATA NAME:ndx_rcatval_upd TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE INDEX ndx_rcatval_upd
ON RCATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_refrdel_delete_date on table REFRDEL

--METADATA NAME:ndx_refrdel_delete_date TYPE:INDEX TABLE_NAME:REFRDEL CHANGE:CREATE
CREATE INDEX ndx_refrdel_delete_date
ON REFRDEL (delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_refrdel_table_pk on table REFRDEL

--METADATA NAME:ndx_refrdel_table_pk TYPE:INDEX TABLE_NAME:REFRDEL CHANGE:CREATE
CREATE INDEX ndx_refrdel_table_pk
ON REFRDEL (table_name,pk1,pk2)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_reittype_dsi on table REITTYPE

--METADATA NAME:ndx_reittype_dsi TYPE:INDEX TABLE_NAME:REITTYPE CHANGE:CREATE
CREATE INDEX ndx_reittype_dsi
ON REITTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_release_rfolio on table RELEASE

--METADATA NAME:ndx_release_rfolio TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE INDEX ndx_release_rfolio
ON RELEASE (rfolio_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_release_project on table RELEASE

--METADATA NAME:ndx_release_project TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE INDEX ndx_release_project
ON RELEASE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_release_dsi on table RELEASE

--METADATA NAME:ndx_release_dsi TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE INDEX ndx_release_dsi
ON RELEASE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_relitems_project on table RELITEMS

--METADATA NAME:ndx_relitems_project TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE INDEX ndx_relitems_project
ON RELITEMS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 256K next 128K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_relitems_related on table RELITEMS

--METADATA NAME:ndx_relitems_related TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE INDEX ndx_relitems_related
ON RELITEMS (related_item_type_id,related_fk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 512K next 256K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_relitems_dsi on table RELITEMS

--METADATA NAME:ndx_relitems_dsi TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE INDEX ndx_relitems_dsi
ON RELITEMS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rfolio_user on table RFOLIO

--METADATA NAME:ndx_rfolio_user TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE INDEX ndx_rfolio_user
ON RFOLIO (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rfolio_dsi on table RFOLIO

--METADATA NAME:ndx_rfolio_dsi TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE INDEX ndx_rfolio_dsi
ON RFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rfolio_upd on table RFOLIO

--METADATA NAME:ndx_rfolio_upd TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE INDEX ndx_rfolio_upd
ON RFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskctrl_1 on table RISKCTRL

--METADATA NAME:ndx_riskctrl_1 TYPE:INDEX TABLE_NAME:RISKCTRL CHANGE:CREATE
CREATE INDEX ndx_riskctrl_1
ON RISKCTRL (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskctrl_dsi on table RISKCTRL

--METADATA NAME:ndx_riskctrl_dsi TYPE:INDEX TABLE_NAME:RISKCTRL CHANGE:CREATE
CREATE INDEX ndx_riskctrl_dsi
ON RISKCTRL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_risktype_dsi on table RISKTYPE

--METADATA NAME:ndx_risktype_dsi TYPE:INDEX TABLE_NAME:RISKTYPE CHANGE:CREATE
CREATE INDEX ndx_risktype_dsi
ON RISKTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_risktype_upd on table RISKTYPE

--METADATA NAME:ndx_risktype_upd TYPE:INDEX TABLE_NAME:RISKTYPE CHANGE:CREATE
CREATE INDEX ndx_risktype_upd
ON RISKTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rlfolio_user on table RLFOLIO

--METADATA NAME:ndx_rlfolio_user TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rlfolio_user
ON RLFOLIO (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rlfolio_dsi on table RLFOLIO

--METADATA NAME:ndx_rlfolio_dsi TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rlfolio_dsi
ON RLFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rlfolio_upd on table RLFOLIO

--METADATA NAME:ndx_rlfolio_upd TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rlfolio_upd
ON RLFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_dsi on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX ndx_rolecattype_dsi
ON ROLECATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_upd on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX ndx_rolecattype_upd
ON ROLECATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_rolecattype on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX ndx_rolecatval_rolecattype
ON ROLECATVAL (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_parent_catg on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX ndx_rolecatval_parent_catg
ON ROLECATVAL (parent_role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_dsi on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX ndx_rolecatval_dsi
ON ROLECATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_upd on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX ndx_rolecatval_upd
ON ROLECATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolelimit_roles on table ROLELIMIT

--METADATA NAME:ndx_rolelimit_roles TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE INDEX ndx_rolelimit_roles
ON ROLELIMIT (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolelimit_dsi on table ROLELIMIT

--METADATA NAME:ndx_rolelimit_dsi TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE INDEX ndx_rolelimit_dsi
ON ROLELIMIT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolelimit_upd on table ROLELIMIT

--METADATA NAME:ndx_rolelimit_upd TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE INDEX ndx_rolelimit_upd
ON ROLELIMIT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolerate_rsrc on table ROLERATE

--METADATA NAME:ndx_rolerate_rsrc TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE INDEX ndx_rolerate_rsrc
ON ROLERATE (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolerate_dsi on table ROLERATE

--METADATA NAME:ndx_rolerate_dsi TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE INDEX ndx_rolerate_dsi
ON ROLERATE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolerate_upd on table ROLERATE

--METADATA NAME:ndx_rolerate_upd TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE INDEX ndx_rolerate_upd
ON ROLERATE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecattype on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX ndx_rolercat_rolecattype
ON ROLERCAT (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecatval on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX ndx_rolercat_rolecatval
ON ROLERCAT (role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_update_date1 on table ROLERCAT

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX ndx_rolercat_update_date1
ON ROLERCAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_dsi on table ROLERCAT

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX ndx_rolercat_dsi
ON ROLERCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_upd on table ROLERCAT

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX ndx_rolercat_upd
ON ROLERCAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_roles_parent_role on table ROLES

--METADATA NAME:ndx_roles_parent_role TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE INDEX ndx_roles_parent_role
ON ROLES (parent_role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_roles_pobs on table ROLES

--METADATA NAME:ndx_roles_pobs TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE INDEX ndx_roles_pobs
ON ROLES (pobs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_roles_update_date1 on table ROLES

--METADATA NAME:ndx_roles_update_date1 TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE INDEX ndx_roles_update_date1
ON ROLES (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_roles_dsi on table ROLES

--METADATA NAME:ndx_roles_dsi TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE INDEX ndx_roles_dsi
ON ROLES (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_roles_upd on table ROLES

--METADATA NAME:ndx_roles_upd TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE INDEX ndx_roles_upd
ON ROLES (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolfolio_role on table ROLFOLIO

--METADATA NAME:ndx_rolfolio_role TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rolfolio_role
ON ROLFOLIO (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolfolio_dsi on table ROLFOLIO

--METADATA NAME:ndx_rolfolio_dsi TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rolfolio_dsi
ON ROLFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolfolio_upd on table ROLFOLIO

--METADATA NAME:ndx_rolfolio_upd TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE INDEX ndx_rolfolio_upd
ON ROLFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rpt_1 on table RPT

--METADATA NAME:ndx_rpt_1 TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE INDEX ndx_rpt_1
ON RPT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rpt_rptgroup on table RPT

--METADATA NAME:ndx_rpt_rptgroup TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE INDEX ndx_rpt_rptgroup
ON RPT (rpt_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rpt_dsi on table RPT

--METADATA NAME:ndx_rpt_dsi TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE INDEX ndx_rpt_dsi
ON RPT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rpt_upd on table RPT

--METADATA NAME:ndx_rpt_upd TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE INDEX ndx_rpt_upd
ON RPT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptbatch_1 on table RPTBATCH

--METADATA NAME:ndx_rptbatch_1 TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE INDEX ndx_rptbatch_1
ON RPTBATCH (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptbatch_dsi on table RPTBATCH

--METADATA NAME:ndx_rptbatch_dsi TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE INDEX ndx_rptbatch_dsi
ON RPTBATCH (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptbatch_upd on table RPTBATCH

--METADATA NAME:ndx_rptbatch_upd TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE INDEX ndx_rptbatch_upd
ON RPTBATCH (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptgroup_parent_group on table RPTGROUP

--METADATA NAME:ndx_rptgroup_parent_group TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE INDEX ndx_rptgroup_parent_group
ON RPTGROUP (parent_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptgroup_dsi on table RPTGROUP

--METADATA NAME:ndx_rptgroup_dsi TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE INDEX ndx_rptgroup_dsi
ON RPTGROUP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptgroup_upd on table RPTGROUP

--METADATA NAME:ndx_rptgroup_upd TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE INDEX ndx_rptgroup_upd
ON RPTGROUP (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptlist_rpt on table RPTLIST

--METADATA NAME:ndx_rptlist_rpt TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE INDEX ndx_rptlist_rpt
ON RPTLIST (rpt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptlist_dsi on table RPTLIST

--METADATA NAME:ndx_rptlist_dsi TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE INDEX ndx_rptlist_dsi
ON RPTLIST (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rptlist_upd on table RPTLIST

--METADATA NAME:ndx_rptlist_upd TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE INDEX ndx_rptlist_upd
ON RPTLIST (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_calendar on table RSRC

--METADATA NAME:ndx_rsrc_calendar TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_calendar
ON RSRC (clndr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_roles on table RSRC

--METADATA NAME:ndx_rsrc_roles TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_roles
ON RSRC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_shift on table RSRC

--METADATA NAME:ndx_rsrc_shift TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_shift
ON RSRC (shift_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_users on table RSRC

--METADATA NAME:ndx_rsrc_users TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_users
ON RSRC (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_parent_rsrc_id on table RSRC

--METADATA NAME:ndx_rsrc_parent_rsrc_id TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_parent_rsrc_id
ON RSRC (parent_rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_pobs on table RSRC

--METADATA NAME:ndx_rsrc_pobs TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_pobs
ON RSRC (pobs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_update_date1 on table RSRC

--METADATA NAME:ndx_rsrc_update_date1 TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_update_date1
ON RSRC (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_unit on table RSRC

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_unit
ON RSRC (unit_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_curr on table RSRC

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_curr
ON RSRC (curr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_dsi on table RSRC

--METADATA NAME:ndx_rsrc_dsi TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_dsi
ON RSRC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_upd on table RSRC

--METADATA NAME:ndx_rsrc_upd TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_upd
ON RSRC (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcandash_1 on table RSRCANDASH

--METADATA NAME:ndx_rsrcandash_1 TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE INDEX ndx_rsrcandash_1
ON RSRCANDASH (rsrcan_view_id,dashboard_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcandash_dsi on table RSRCANDASH

--METADATA NAME:ndx_rsrcandash_dsi TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE INDEX ndx_rsrcandash_dsi
ON RSRCANDASH (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcandash_upd on table RSRCANDASH

--METADATA NAME:ndx_rsrcandash_upd TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE INDEX ndx_rsrcandash_upd
ON RSRCANDASH (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcanview_1 on table RSRCANVIEW

--METADATA NAME:ndx_rsrcanview_1 TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE INDEX ndx_rsrcanview_1
ON RSRCANVIEW (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcanview_dsi on table RSRCANVIEW

--METADATA NAME:ndx_rsrcanview_dsi TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE INDEX ndx_rsrcanview_dsi
ON RSRCANVIEW (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcanview_upd on table RSRCANVIEW

--METADATA NAME:ndx_rsrcanview_upd TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE INDEX ndx_rsrcanview_upd
ON RSRCANVIEW (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrccurv_dsi on table RSRCCURV

--METADATA NAME:ndx_rsrccurv_dsi TYPE:INDEX TABLE_NAME:RSRCCURV CHANGE:CREATE
CREATE INDEX ndx_rsrccurv_dsi
ON RSRCCURV (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrccurv_upd on table RSRCCURV

--METADATA NAME:ndx_rsrccurv_upd TYPE:INDEX TABLE_NAME:RSRCCURV CHANGE:CREATE
CREATE INDEX ndx_rsrccurv_upd
ON RSRCCURV (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_project on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_project TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_project
ON RSRCHOUR (proj_id,ts_id,task_ts_flag,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_nonwork on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_nonwork TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_nonwork
ON RSRCHOUR (nonwork_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_rsrc on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_rsrc
ON RSRCHOUR (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_taskrsrc on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_taskrsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_taskrsrc
ON RSRCHOUR (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_timesht on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_timesht TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_timesht
ON RSRCHOUR (rsrc_id,ts_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_work_date on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_work_date TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_work_date
ON RSRCHOUR (work_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_status_code on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_status_code TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_status_code
ON RSRCHOUR (status_code,proj_id,ts_id,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_dsi on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_dsi TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_dsi
ON RSRCHOUR (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_ts_rsrc
ON RSRCHOUR (ts_id,rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcprop_dsi on table RSRCPROP

--METADATA NAME:ndx_rsrcprop_dsi TYPE:INDEX TABLE_NAME:RSRCPROP CHANGE:CREATE
CREATE INDEX ndx_rsrcprop_dsi
ON RSRCPROP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrate_rsrc on table RSRCRATE

--METADATA NAME:ndx_rsrcrate_rsrc TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE INDEX ndx_rsrcrate_rsrc
ON RSRCRATE (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrate_shiftper on table RSRCRATE

--METADATA NAME:ndx_rsrcrate_shiftper TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE INDEX ndx_rsrcrate_shiftper
ON RSRCRATE (shift_period_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrate_update_date1 on table RSRCRATE

--METADATA NAME:ndx_rsrcrate_update_date1 TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE INDEX ndx_rsrcrate_update_date1
ON RSRCRATE (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrate_dsi on table RSRCRATE

--METADATA NAME:ndx_rsrcrate_dsi TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE INDEX ndx_rsrcrate_dsi
ON RSRCRATE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrate_upd on table RSRCRATE

--METADATA NAME:ndx_rsrcrate_upd TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE INDEX ndx_rsrcrate_upd
ON RSRCRATE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrcat_rcattype on table RSRCRCAT

--METADATA NAME:ndx_rsrcrcat_rcattype TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE INDEX ndx_rsrcrcat_rcattype
ON RSRCRCAT (rsrc_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrcat_rcatval on table RSRCRCAT

--METADATA NAME:ndx_rsrcrcat_rcatval TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE INDEX ndx_rsrcrcat_rcatval
ON RSRCRCAT (rsrc_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrcat_update_date1 on table RSRCRCAT

--METADATA NAME:ndx_rsrcrcat_update_date1 TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE INDEX ndx_rsrcrcat_update_date1
ON RSRCRCAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrcat_dsi on table RSRCRCAT

--METADATA NAME:ndx_rsrcrcat_dsi TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE INDEX ndx_rsrcrcat_dsi
ON RSRCRCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrcat_upd on table RSRCRCAT

--METADATA NAME:ndx_rsrcrcat_upd TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE INDEX ndx_rsrcrcat_upd
ON RSRCRCAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrole_roles on table RSRCROLE

--METADATA NAME:ndx_rsrcrole_roles TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE INDEX ndx_rsrcrole_roles
ON RSRCROLE (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrole_dsi on table RSRCROLE

--METADATA NAME:ndx_rsrcrole_dsi TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE INDEX ndx_rsrcrole_dsi
ON RSRCROLE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrole_upd on table RSRCROLE

--METADATA NAME:ndx_rsrcrole_upd TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE INDEX ndx_rsrcrole_upd
ON RSRCROLE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcsec_rsrc on table RSRCSEC

--METADATA NAME:ndx_rsrcsec_rsrc TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE INDEX ndx_rsrcsec_rsrc
ON RSRCSEC (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcsec_dsi on table RSRCSEC

--METADATA NAME:ndx_rsrcsec_dsi TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE INDEX ndx_rsrcsec_dsi
ON RSRCSEC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcsec_upd on table RSRCSEC

--METADATA NAME:ndx_rsrcsec_upd TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE INDEX ndx_rsrcsec_upd
ON RSRCSEC (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrfolio_rsrc on table RSRFOLIO

--METADATA NAME:ndx_rsrfolio_rsrc TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE INDEX ndx_rsrfolio_rsrc
ON RSRFOLIO (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrfolio_dsi on table RSRFOLIO

--METADATA NAME:ndx_rsrfolio_dsi TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE INDEX ndx_rsrfolio_dsi
ON RSRFOLIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrfolio_upd on table RSRFOLIO

--METADATA NAME:ndx_rsrfolio_upd TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE INDEX ndx_rsrfolio_upd
ON RSRFOLIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenario_1 on table SCENARIO

--METADATA NAME:ndx_scenario_1 TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE INDEX ndx_scenario_1
ON SCENARIO (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenario_viewpref on table SCENARIO

--METADATA NAME:ndx_scenario_viewpref TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE INDEX ndx_scenario_viewpref
ON SCENARIO (view_pref_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenario_dsi on table SCENARIO

--METADATA NAME:ndx_scenario_dsi TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE INDEX ndx_scenario_dsi
ON SCENARIO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenario_upd on table SCENARIO

--METADATA NAME:ndx_scenario_upd TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE INDEX ndx_scenario_upd
ON SCENARIO (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenproj_1 on table SCENPROJ

--METADATA NAME:ndx_scenproj_1 TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE INDEX ndx_scenproj_1
ON SCENPROJ (proj_id,scenario_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenproj_dsi on table SCENPROJ

--METADATA NAME:ndx_scenproj_dsi TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE INDEX ndx_scenproj_dsi
ON SCENPROJ (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenproj_upd on table SCENPROJ

--METADATA NAME:ndx_scenproj_upd TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE INDEX ndx_scenproj_upd
ON SCENPROJ (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenrole_roles on table SCENROLE

--METADATA NAME:ndx_scenrole_roles TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE INDEX ndx_scenrole_roles
ON SCENROLE (role_id,scenario_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenrole_dsi on table SCENROLE

--METADATA NAME:ndx_scenrole_dsi TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE INDEX ndx_scenrole_dsi
ON SCENROLE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenrole_upd on table SCENROLE

--METADATA NAME:ndx_scenrole_upd TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE INDEX ndx_scenrole_upd
ON SCENROLE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenuser_1 on table SCENUSER

--METADATA NAME:ndx_scenuser_1 TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE INDEX ndx_scenuser_1
ON SCENUSER (user_id,scenario_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenuser_dsi on table SCENUSER

--METADATA NAME:ndx_scenuser_dsi TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE INDEX ndx_scenuser_dsi
ON SCENUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_scenuser_upd on table SCENUSER

--METADATA NAME:ndx_scenuser_upd TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE INDEX ndx_scenuser_upd
ON SCENUSER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_settings_dsi on table SETTINGS

--METADATA NAME:ndx_settings_dsi TYPE:INDEX TABLE_NAME:SETTINGS CHANGE:CREATE
CREATE INDEX ndx_settings_dsi
ON SETTINGS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shift_dsi on table SHIFT

--METADATA NAME:ndx_shift_dsi TYPE:INDEX TABLE_NAME:SHIFT CHANGE:CREATE
CREATE INDEX ndx_shift_dsi
ON SHIFT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shift_upd on table SHIFT

--METADATA NAME:ndx_shift_upd TYPE:INDEX TABLE_NAME:SHIFT CHANGE:CREATE
CREATE INDEX ndx_shift_upd
ON SHIFT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shiftper_shift on table SHIFTPER

--METADATA NAME:ndx_shiftper_shift TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE INDEX ndx_shiftper_shift
ON SHIFTPER (shift_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shiftper_shift_start on table SHIFTPER

--METADATA NAME:ndx_shiftper_shift_start TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE UNIQUE INDEX ndx_shiftper_shift_start
ON SHIFTPER (shift_id,shift_start_hr_num)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shiftper_dsi on table SHIFTPER

--METADATA NAME:ndx_shiftper_dsi TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE INDEX ndx_shiftper_dsi
ON SHIFTPER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_shiftper_upd on table SHIFTPER

--METADATA NAME:ndx_shiftper_upd TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE INDEX ndx_shiftper_upd
ON SHIFTPER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_wbs on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_wbs
ON SUMPROJCOST (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_cost_type
ON SUMPROJCOST (cost_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_proj on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_proj
ON SUMPROJCOST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_proj on table SUMTASK

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX ndx_sumtask_proj
ON SUMTASK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_wbs on table SUMTASK

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX ndx_sumtask_wbs
ON SUMTASK (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX ndx_sumtaskspread_proj
ON SUMTASKSPREAD (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX ndx_sumtaskspread_wbs
ON SUMTASKSPREAD (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_project on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_project
ON SUMTRSRC (proj_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_projwbs
ON SUMTRSRC (wbs_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_rsrcrole
ON SUMTRSRC (rsrc_id,role_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_1 on table TASK

--METADATA NAME:ndx_task_1 TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_1
ON TASK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 2M next 2M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_calendar on table TASK

--METADATA NAME:ndx_task_calendar TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_calendar
ON TASK (clndr_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_projwbs on table TASK

--METADATA NAME:ndx_task_projwbs TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_projwbs
ON TASK (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_rsrc on table TASK

--METADATA NAME:ndx_task_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_rsrc
ON TASK (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_guid on table TASK

--METADATA NAME:ndx_task_guid TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_guid
ON TASK (guid)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500k next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_proj_rsrc on table TASK

--METADATA NAME:ndx_task_proj_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_proj_rsrc
ON TASK (proj_id,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500k next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_dsi on table TASK

--METADATA NAME:ndx_task_dsi TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_dsi
ON TASK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fn_task_code on table TASK

--METADATA NAME:ndx_fn_task_code TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_fn_task_code
ON TASK (task_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_1 on table TASKACTV

--METADATA NAME:ndx_taskactv_1 TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_1
ON TASKACTV (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_actvcode on table TASKACTV

--METADATA NAME:ndx_taskactv_actvcode TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_actvcode
ON TASKACTV (actv_code_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_actvtype on table TASKACTV

--METADATA NAME:ndx_taskactv_actvtype TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_actvtype
ON TASKACTV (actv_code_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_task on table TASKACTV

--METADATA NAME:ndx_taskactv_task TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_task
ON TASKACTV (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_actv_code on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_actv_code TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_proj_actv_code
ON TASKACTV (proj_id,actv_code_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_task_actv on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_task_actv TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_proj_task_actv
ON TASKACTV (proj_id,task_id,actv_code_type_id,actv_code_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_dsi on table TASKACTV

--METADATA NAME:ndx_taskactv_dsi TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_dsi
ON TASKACTV (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskdoc_1 on table TASKDOC

--METADATA NAME:ndx_taskdoc_1 TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE INDEX ndx_taskdoc_1
ON TASKDOC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskdoc_document on table TASKDOC

--METADATA NAME:ndx_taskdoc_document TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE INDEX ndx_taskdoc_document
ON TASKDOC (doc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskdoc_projwbs on table TASKDOC

--METADATA NAME:ndx_taskdoc_projwbs TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE INDEX ndx_taskdoc_projwbs
ON TASKDOC (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskdoc_task on table TASKDOC

--METADATA NAME:ndx_taskdoc_task TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE INDEX ndx_taskdoc_task
ON TASKDOC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskdoc_dsi on table TASKDOC

--METADATA NAME:ndx_taskdoc_dsi TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE INDEX ndx_taskdoc_dsi
ON TASKDOC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfdbk_1 on table TASKFDBK

--METADATA NAME:ndx_taskfdbk_1 TYPE:INDEX TABLE_NAME:TASKFDBK CHANGE:CREATE
CREATE INDEX ndx_taskfdbk_1
ON TASKFDBK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfdbk_dsi on table TASKFDBK

--METADATA NAME:ndx_taskfdbk_dsi TYPE:INDEX TABLE_NAME:TASKFDBK CHANGE:CREATE
CREATE INDEX ndx_taskfdbk_dsi
ON TASKFDBK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfin_project on table TASKFIN

--METADATA NAME:ndx_taskfin_project TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE INDEX ndx_taskfin_project
ON TASKFIN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfin_task on table TASKFIN

--METADATA NAME:ndx_taskfin_task TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE INDEX ndx_taskfin_task
ON TASKFIN (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfin_findates on table TASKFIN

--METADATA NAME:ndx_taskfin_findates TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE INDEX ndx_taskfin_findates
ON TASKFIN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskfin_dsi on table TASKFIN

--METADATA NAME:ndx_taskfin_dsi TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE INDEX ndx_taskfin_dsi
ON TASKFIN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskmemo_1 on table TASKMEMO

--METADATA NAME:ndx_taskmemo_1 TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE INDEX ndx_taskmemo_1
ON TASKMEMO (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 400K next 400K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskmemo_memotype on table TASKMEMO

--METADATA NAME:ndx_taskmemo_memotype TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE INDEX ndx_taskmemo_memotype
ON TASKMEMO (memo_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskmemo_task on table TASKMEMO

--METADATA NAME:ndx_taskmemo_task TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE INDEX ndx_taskmemo_task
ON TASKMEMO (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskmemo_dsi on table TASKMEMO

--METADATA NAME:ndx_taskmemo_dsi TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE INDEX ndx_taskmemo_dsi
ON TASKMEMO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasknote_1 on table TASKNOTE

--METADATA NAME:ndx_tasknote_1 TYPE:INDEX TABLE_NAME:TASKNOTE CHANGE:CREATE
CREATE INDEX ndx_tasknote_1
ON TASKNOTE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 300K next 300K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasknote_dsi on table TASKNOTE

--METADATA NAME:ndx_tasknote_dsi TYPE:INDEX TABLE_NAME:TASKNOTE CHANGE:CREATE
CREATE INDEX ndx_tasknote_dsi
ON TASKNOTE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_1 on table TASKPRED

--METADATA NAME:ndx_taskpred_1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_1
ON TASKPRED (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_pred_proj on table TASKPRED

--METADATA NAME:ndx_taskpred_pred_proj TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_pred_proj
ON TASKPRED (pred_proj_id,proj_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_task on table TASKPRED

--METADATA NAME:ndx_taskpred_task TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_task
ON TASKPRED (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_task_2 on table TASKPRED

--METADATA NAME:ndx_taskpred_task_2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_task_2
ON TASKPRED (pred_task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc1 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_perfc1
ON TASKPRED (proj_id, pred_proj_id, task_pred_id, task_id, pred_task_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc2 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_perfc2
ON TASKPRED (pred_proj_id,proj_id, task_id, pred_task_id, task_pred_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_dsi on table TASKPRED

--METADATA NAME:ndx_taskpred_dsi TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_dsi
ON TASKPRED (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskproc_1 on table TASKPROC

--METADATA NAME:ndx_taskproc_1 TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE INDEX ndx_taskproc_1
ON TASKPROC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskproc_task on table TASKPROC

--METADATA NAME:ndx_taskproc_task TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE INDEX ndx_taskproc_task
ON TASKPROC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskproc_dsi on table TASKPROC

--METADATA NAME:ndx_taskproc_dsi TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE INDEX ndx_taskproc_dsi
ON TASKPROC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_risk on table TASKRISK

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_risk
ON TASKRISK (risk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_proj on table TASKRISK

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_proj
ON TASKRISK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_task on table TASKRISK

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_task
ON TASKRISK (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_1 on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_1 TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_1
ON TASKRSRC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_account on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_account TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_account
ON TASKRSRC (acct_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_roles on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_roles TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_roles
ON TASKRSRC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_rsrc on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_rsrc
ON TASKRSRC (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_task on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_task TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_task
ON TASKRSRC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_rsrccurv on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_rsrccurv TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_rsrccurv
ON TASKRSRC (curv_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_pobs on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_pobs TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_pobs
ON TASKRSRC (pobs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_rsrc on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_rsrc
ON TASKRSRC (proj_id,rsrc_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_role on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_role TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_role
ON TASKRSRC (proj_id,role_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_acct on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_acct TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_acct
ON TASKRSRC (proj_id,acct_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_dsi on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_dsi TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_dsi
ON TASKRSRC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_1 on table TASKSUM

--METADATA NAME:ndx_tasksum_1 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_1
ON TASKSUM (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_projwbs on table TASKSUM

--METADATA NAME:ndx_tasksum_projwbs TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_projwbs
ON TASKSUM (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_update_date on table TASKSUM

--METADATA NAME:ndx_tasksum_update_date TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_update_date
ON TASKSUM (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_dsi on table TASKSUM

--METADATA NAME:ndx_tasksum_dsi TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_dsi
ON TASKSUM (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_upd on table TASKSUM

--METADATA NAME:ndx_tasksum_upd TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_upd
ON TASKSUM (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m1 on table TASKSUM

--METADATA NAME:ndx_tasksum_m1 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_m1
ON TASKSUM (task_sum_id, wbs_id, proj_id, complete_cnt, active_cnt, notstarted_cnt, base_complete_cnt, base_active_cnt, base_notstarted_cnt, act_drtn_hr_cnt, act_equip_qty, act_work_qty, total_drtn_hr_cnt, base_drtn_hr_cnt, base_work_qty, base_equip_qty, remain_drtn_hr_cnt, remain_work_qty, remain_equip_qty, total_float_hr_cnt, act_expense_cost, act_work_cost, act_equip_cost, base_expense_cost, base_work_cost, base_equip_cost, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m2 on table TASKSUM

--METADATA NAME:ndx_tasksum_m2 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_m2
ON TASKSUM (task_sum_id, wbs_id, proj_id, bcwp, bcws, remain_expense_cost, remain_work_cost, remain_equip_cost, perfm_work_qty, sched_work_qty, act_end_date, act_start_date, base_end_date, base_start_date, reend_date, restart_date, etc_work_qty, etc, act_this_per_work_cost, act_this_per_work_qty, act_this_per_equip_cost, act_this_per_equip_qty, base_mat_cost, act_mat_cost, remain_mat_cost, act_this_per_mat_cost, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_1 on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_1 TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_1
ON TASKSUMFIN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_projwbs on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_projwbs TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_projwbs
ON TASKSUMFIN (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_findates on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_findates TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_findates
ON TASKSUMFIN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_tasksum on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_tasksum TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_tasksum
ON TASKSUMFIN (task_sum_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_dsi on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_dsi TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_dsi
ON TASKSUMFIN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_upd on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_upd TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_upd
ON TASKSUMFIN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskuser_user on table TASKUSER

--METADATA NAME:ndx_taskuser_user TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE INDEX ndx_taskuser_user
ON TASKUSER (user_id,task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskuser_project on table TASKUSER

--METADATA NAME:ndx_taskuser_project TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE INDEX ndx_taskuser_project
ON TASKUSER (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskuser_dsi on table TASKUSER

--METADATA NAME:ndx_taskuser_dsi TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE INDEX ndx_taskuser_dsi
ON TASKUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskwksp_project on table TASKWKSP

--METADATA NAME:ndx_taskwksp_project TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE INDEX ndx_taskwksp_project
ON TASKWKSP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskwksp_task on table TASKWKSP

--METADATA NAME:ndx_taskwksp_task TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE INDEX ndx_taskwksp_task
ON TASKWKSP (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskwksp_dsi on table TASKWKSP

--METADATA NAME:ndx_taskwksp_dsi TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE INDEX ndx_taskwksp_dsi
ON TASKWKSP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_thrsparm_dsi on table THRSPARM

--METADATA NAME:ndx_thrsparm_dsi TYPE:INDEX TABLE_NAME:THRSPARM CHANGE:CREATE
CREATE INDEX ndx_thrsparm_dsi
ON THRSPARM (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_timesht_1 on table TIMESHT

--METADATA NAME:ndx_timesht_1 TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE INDEX ndx_timesht_1
ON TIMESHT (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_timesht_rsrc on table TIMESHT

--METADATA NAME:ndx_timesht_rsrc TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE INDEX ndx_timesht_rsrc
ON TIMESHT (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_timesht_ts_user on table TIMESHT

--METADATA NAME:ndx_timesht_ts_user TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE INDEX ndx_timesht_ts_user
ON TIMESHT (ts_id,user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_timesht_dsi on table TIMESHT

--METADATA NAME:ndx_timesht_dsi TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE INDEX ndx_timesht_dsi
ON TIMESHT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tmplcatg_dsi on table TMPLCATG

--METADATA NAME:ndx_tmplcatg_dsi TYPE:INDEX TABLE_NAME:TMPLCATG CHANGE:CREATE
CREATE INDEX ndx_tmplcatg_dsi
ON TMPLCATG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trakview_1 on table TRAKVIEW

--METADATA NAME:ndx_trakview_1 TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE INDEX ndx_trakview_1
ON TRAKVIEW (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trakview_dsi on table TRAKVIEW

--METADATA NAME:ndx_trakview_dsi TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE INDEX ndx_trakview_dsi
ON TRAKVIEW (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trakview_upd on table TRAKVIEW

--METADATA NAME:ndx_trakview_upd TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE INDEX ndx_trakview_upd
ON TRAKVIEW (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcfin_project on table TRSRCFIN

--METADATA NAME:ndx_trsrcfin_project TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE INDEX ndx_trsrcfin_project
ON TRSRCFIN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcfin_task on table TRSRCFIN

--METADATA NAME:ndx_trsrcfin_task TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE INDEX ndx_trsrcfin_task
ON TRSRCFIN (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcfin_taskrsrc on table TRSRCFIN

--METADATA NAME:ndx_trsrcfin_taskrsrc TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE INDEX ndx_trsrcfin_taskrsrc
ON TRSRCFIN (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcfin_findates on table TRSRCFIN

--METADATA NAME:ndx_trsrcfin_findates TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE INDEX ndx_trsrcfin_findates
ON TRSRCFIN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcfin_dsi on table TRSRCFIN

--METADATA NAME:ndx_trsrcfin_dsi TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE INDEX ndx_trsrcfin_dsi
ON TRSRCFIN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_1 on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_1 TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_1
ON TRSRCSUM (proj_id,rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_roles on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_roles TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_roles
ON TRSRCSUM (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_rsrc on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_rsrc
ON TRSRCSUM (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_update_date on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_update_date TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_update_date
ON TRSRCSUM (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_dsi on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_dsi TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_dsi
ON TRSRCSUM (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_upd on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_upd TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_upd
ON TRSRCSUM (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_role_dialog on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_role_dialog TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_role_dialog
ON TRSRCSUM (proj_id,taskrsrc_sum_id,rsrc_id,role_id,skill_level,overalloc_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_1 on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_1 TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_1
ON TRSRCSUMFN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_project on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_project TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_project
ON TRSRCSUMFN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_roles on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_roles TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_roles
ON TRSRCSUMFN (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_rsrc on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_rsrc
ON TRSRCSUMFN (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_trsrcsum on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_trsrcsum TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_trsrcsum
ON TRSRCSUMFN (taskrsrc_sum_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_dsi on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_dsi TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_dsi
ON TRSRCSUMFN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_upd on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_upd TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_upd
ON TRSRCSUMFN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsaudit_audit_date on table TSAUDIT

--METADATA NAME:ndx_tsaudit_audit_date TYPE:INDEX TABLE_NAME:TSAUDIT CHANGE:CREATE
CREATE INDEX ndx_tsaudit_audit_date
ON TSAUDIT (audit_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdates_dsi on table TSDATES

--METADATA NAME:ndx_tsdates_dsi TYPE:INDEX TABLE_NAME:TSDATES CHANGE:CREATE
CREATE INDEX ndx_tsdates_dsi
ON TSDATES (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdates_upd on table TSDATES

--METADATA NAME:ndx_tsdates_upd TYPE:INDEX TABLE_NAME:TSDATES CHANGE:CREATE
CREATE INDEX ndx_tsdates_upd
ON TSDATES (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_1
ON TSDELEGATE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_users1
ON TSDELEGATE (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users2 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users2 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_users2
ON TSDELEGATE (ts_delegate_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uaccess_project on table UACCESS

--METADATA NAME:ndx_uaccess_project TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE INDEX ndx_uaccess_project
ON UACCESS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_uaccess_user_wbs on table UACCESS

--METADATA NAME:ndx_uaccess_user_wbs TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE INDEX ndx_uaccess_user_wbs
ON UACCESS (user_id,wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_uaccess_user_parent on table UACCESS

--METADATA NAME:ndx_uaccess_user_parent TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE INDEX ndx_uaccess_user_parent
ON UACCESS (user_id,parent_wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_udfcode_udf_type_id on table UDFCODE

--METADATA NAME:ndx_udfcode_udf_type_id TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE INDEX ndx_udfcode_udf_type_id
ON UDFCODE (udf_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32K next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfcode_dsi on table UDFCODE

--METADATA NAME:ndx_udfcode_dsi TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE INDEX ndx_udfcode_dsi
ON UDFCODE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfcode_upd on table UDFCODE

--METADATA NAME:ndx_udfcode_upd TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE INDEX ndx_udfcode_upd
ON UDFCODE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udftype_table_name on table UDFTYPE

--METADATA NAME:ndx_udftype_table_name TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE INDEX ndx_udftype_table_name
ON UDFTYPE (table_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32K next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udftype_dsi on table UDFTYPE

--METADATA NAME:ndx_udftype_dsi TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE INDEX ndx_udftype_dsi
ON UDFTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udftype_upd on table UDFTYPE

--METADATA NAME:ndx_udftype_upd TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE INDEX ndx_udftype_upd
ON UDFTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_project on table UDFVALUE

--METADATA NAME:ndx_udfvalue_project TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_project
ON UDFVALUE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_fk on table UDFVALUE

--METADATA NAME:ndx_udfvalue_fk TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_fk
ON UDFVALUE (fk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_update_date1 on table UDFVALUE

--METADATA NAME:ndx_udfvalue_update_date1 TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_update_date1
ON UDFVALUE (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_udfcode on table UDFVALUE

--METADATA NAME:ndx_udfvalue_udfcode TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_udfcode
ON UDFVALUE (udf_code_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_dsi on table UDFVALUE

--METADATA NAME:ndx_udfvalue_dsi TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_dsi
ON UDFVALUE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_udfvalue_upd on table UDFVALUE

--METADATA NAME:ndx_udfvalue_upd TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE INDEX ndx_udfvalue_upd
ON UDFVALUE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uevntreg_users on table UEVNTREG

--METADATA NAME:ndx_uevntreg_users TYPE:INDEX TABLE_NAME:UEVNTREG CHANGE:CREATE
CREATE INDEX ndx_uevntreg_users
ON UEVNTREG (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uevntreg_user_name on table UEVNTREG

--METADATA NAME:ndx_uevntreg_user_name TYPE:INDEX TABLE_NAME:UEVNTREG CHANGE:CREATE
CREATE INDEX ndx_uevntreg_user_name
ON UEVNTREG (user_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_umeasure_dsi on table UMEASURE

--METADATA NAME:ndx_umeasure_dsi TYPE:INDEX TABLE_NAME:UMEASURE CHANGE:CREATE
CREATE INDEX ndx_umeasure_dsi
ON UMEASURE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_umeasure_upd on table UMEASURE

--METADATA NAME:ndx_umeasure_upd TYPE:INDEX TABLE_NAME:UMEASURE CHANGE:CREATE
CREATE INDEX ndx_umeasure_upd
ON UMEASURE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_upklist_session_pk on table UPKLIST

--METADATA NAME:ndx_upklist_session_pk TYPE:INDEX TABLE_NAME:UPKLIST CHANGE:CREATE
CREATE INDEX ndx_upklist_session_pk
ON UPKLIST (session_id,pk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 5M next 1M minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_usercol_dsi on table USERCOL

--METADATA NAME:ndx_usercol_dsi TYPE:INDEX TABLE_NAME:USERCOL CHANGE:CREATE
CREATE INDEX ndx_usercol_dsi
ON USERCOL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usercol_upd on table USERCOL

--METADATA NAME:ndx_usercol_upd TYPE:INDEX TABLE_NAME:USERCOL CHANGE:CREATE
CREATE INDEX ndx_usercol_upd
ON USERCOL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userdata_1 on table USERDATA

--METADATA NAME:ndx_userdata_1 TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE INDEX ndx_userdata_1
ON USERDATA (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userdata_dsi on table USERDATA

--METADATA NAME:ndx_userdata_dsi TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE INDEX ndx_userdata_dsi
ON USERDATA (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userdata_upd on table USERDATA

--METADATA NAME:ndx_userdata_upd TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE INDEX ndx_userdata_upd
ON USERDATA (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usereng_users on table USERENG

--METADATA NAME:ndx_usereng_users TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE INDEX ndx_usereng_users
ON USERENG (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usereng_dsi on table USERENG

--METADATA NAME:ndx_usereng_dsi TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE INDEX ndx_usereng_dsi
ON USERENG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usereng_upd on table USERENG

--METADATA NAME:ndx_usereng_upd TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE INDEX ndx_usereng_upd
ON USERENG (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userobs_obs on table USEROBS

--METADATA NAME:ndx_userobs_obs TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE INDEX ndx_userobs_obs
ON USEROBS (obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userobs_profile on table USEROBS

--METADATA NAME:ndx_userobs_profile TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE INDEX ndx_userobs_profile
ON USEROBS (prof_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userobs_dsi on table USEROBS

--METADATA NAME:ndx_userobs_dsi TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE INDEX ndx_userobs_dsi
ON USEROBS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userobs_upd on table USEROBS

--METADATA NAME:ndx_userobs_upd TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE INDEX ndx_userobs_upd
ON USEROBS (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_users on table USEROPEN

--METADATA NAME:ndx_useropen_users TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE UNIQUE INDEX ndx_useropen_users
ON USEROPEN (user_id,user_open_name,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_dsi on table USEROPEN

--METADATA NAME:ndx_useropen_dsi TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX ndx_useropen_dsi
ON USEROPEN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_upd on table USEROPEN

--METADATA NAME:ndx_useropen_upd TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX ndx_useropen_upd
ON USEROPEN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_profile on table USERS

--METADATA NAME:ndx_users_profile TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX ndx_users_profile
ON USERS (prof_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_dsi on table USERS

--METADATA NAME:ndx_users_dsi TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX ndx_users_dsi
ON USERS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_upd on table USERS

--METADATA NAME:ndx_users_upd TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX ndx_users_upd
ON USERS (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_curr on table USERS

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX ndx_users_curr
ON USERS (curr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userset_dsi on table USERSET

--METADATA NAME:ndx_userset_dsi TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE INDEX ndx_userset_dsi
ON USERSET (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userset_user on table USERSET

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE INDEX ndx_userset_user
ON USERSET (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userwksp_project on table USERWKSP

--METADATA NAME:ndx_userwksp_project TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE INDEX ndx_userwksp_project
ON USERWKSP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 256K next 128K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_userwksp_workspace on table USERWKSP

--METADATA NAME:ndx_userwksp_workspace TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE INDEX ndx_userwksp_workspace
ON USERWKSP (workspace_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 256K next 128K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_userwksp_dsi on table USERWKSP

--METADATA NAME:ndx_userwksp_dsi TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE INDEX ndx_userwksp_dsi
ON USERWKSP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usessaud_logout_date on table USESSAUD

--METADATA NAME:ndx_usessaud_logout_date TYPE:INDEX TABLE_NAME:USESSAUD CHANGE:CREATE
CREATE INDEX ndx_usessaud_logout_date
ON USESSAUD (logout_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usession_users on table USESSION

--METADATA NAME:ndx_usession_users TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE INDEX ndx_usession_users
ON USESSION (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usession_spid on table USESSION

--METADATA NAME:ndx_usession_spid TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE INDEX ndx_usession_spid
ON USESSION (spid,user_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_ussesion_dsi on table USESSION

--METADATA NAME:ndx_ussesion_dsi TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE INDEX ndx_ussesion_dsi
ON USESSION (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_user_open_id on table USROPNVAL

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_user_open_id
ON USROPNVAL (user_open_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_dsi on table USROPNVAL

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_dsi
ON USROPNVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_upd on table USROPNVAL

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_upd
ON USROPNVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewpref_user on table VIEWPREF

--METADATA NAME:ndx_viewpref_user TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE INDEX ndx_viewpref_user
ON VIEWPREF (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewpref_type on table VIEWPREF

--METADATA NAME:ndx_viewpref_type TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE INDEX ndx_viewpref_type
ON VIEWPREF (view_pref_type,user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewpref_dsi on table VIEWPREF

--METADATA NAME:ndx_viewpref_dsi TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE INDEX ndx_viewpref_dsi
ON VIEWPREF (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewpref_upd on table VIEWPREF

--METADATA NAME:ndx_viewpref_upd TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE INDEX ndx_viewpref_upd
ON VIEWPREF (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewprop_1 on table VIEWPROP

--METADATA NAME:ndx_viewprop_1 TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE INDEX ndx_viewprop_1
ON VIEWPROP (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewprop_project on table VIEWPROP

--METADATA NAME:ndx_viewprop_project TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE INDEX ndx_viewprop_project
ON VIEWPROP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewprop_dsi on table VIEWPROP

--METADATA NAME:ndx_viewprop_dsi TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE INDEX ndx_viewprop_dsi
ON VIEWPROP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_viewprop_upd on table VIEWPROP

--METADATA NAME:ndx_viewprop_upd TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE INDEX ndx_viewprop_upd
ON VIEWPROP (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_viewpref on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_viewpref TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_viewpref
ON VWPREFDASH (view_pref_id,dashboard_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_dsi on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_dsi TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_dsi
ON VWPREFDASH (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_upd on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_upd TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_upd
ON VWPREFDASH (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdata_dsi on table VWPREFDATA

--METADATA NAME:ndx_vwprefdata_dsi TYPE:INDEX TABLE_NAME:VWPREFDATA CHANGE:CREATE
CREATE INDEX ndx_vwprefdata_dsi
ON VWPREFDATA (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdata_upd on table VWPREFDATA

--METADATA NAME:ndx_vwprefdata_upd TYPE:INDEX TABLE_NAME:VWPREFDATA CHANGE:CREATE
CREATE INDEX ndx_vwprefdata_upd
ON VWPREFDATA (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefuser_users on table VWPREFUSER

--METADATA NAME:ndx_vwprefuser_users TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE INDEX ndx_vwprefuser_users
ON VWPREFUSER (user_id,view_pref_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefuser_dsi on table VWPREFUSER

--METADATA NAME:ndx_vwprefuser_dsi TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE INDEX ndx_vwprefuser_dsi
ON VWPREFUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefuser_upd on table VWPREFUSER

--METADATA NAME:ndx_vwprefuser_upd TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE INDEX ndx_vwprefuser_upd
ON VWPREFUSER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbrscat_dsi on table WBRSCAT

--METADATA NAME:ndx_wbrscat_dsi TYPE:INDEX TABLE_NAME:WBRSCAT CHANGE:CREATE
CREATE INDEX ndx_wbrscat_dsi
ON WBRSCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsbudg_1 on table WBSBUDG

--METADATA NAME:ndx_wbsbudg_1 TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE INDEX ndx_wbsbudg_1
ON WBSBUDG (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsbudg_2 on table WBSBUDG

--METADATA NAME:ndx_wbsbudg_2 TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE INDEX ndx_wbsbudg_2
ON WBSBUDG (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsbudg_dsi on table WBSBUDG

--METADATA NAME:ndx_wbsbudg_dsi TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE INDEX ndx_wbsbudg_dsi
ON WBSBUDG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsbudg_upd on table WBSBUDG

--METADATA NAME:ndx_wbsbudg_upd TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE INDEX ndx_wbsbudg_upd
ON WBSBUDG (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsmemo_1 on table WBSMEMO

--METADATA NAME:ndx_wbsmemo_1 TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE INDEX ndx_wbsmemo_1
ON WBSMEMO (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsmemo_2 on table WBSMEMO

--METADATA NAME:ndx_wbsmemo_2 TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE INDEX ndx_wbsmemo_2
ON WBSMEMO (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsmemo_memotype on table WBSMEMO

--METADATA NAME:ndx_wbsmemo_memotype TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE INDEX ndx_wbsmemo_memotype
ON WBSMEMO (memo_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsmemo_dsi on table WBSMEMO

--METADATA NAME:ndx_wbsmemo_dsi TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE INDEX ndx_wbsmemo_dsi
ON WBSMEMO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_project on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_project TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_project
ON WBSRSRC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_projwbs on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_projwbs TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_projwbs
ON WBSRSRC (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_rsrc on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_rsrc TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_rsrc
ON WBSRSRC (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_wbrscat on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_wbrscat TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_wbrscat
ON WBSRSRC (wbrs_cat_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_role on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_role
ON WBSRSRC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_dsi on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_dsi TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_dsi
ON WBSRSRC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_dsi on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_dsi TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_qty_dsi
ON WBSRSRC_QTY (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_qty_fin_dates_id2
ON WBSRSRC_QTY (fin_dates_id2)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_qty_fin_dates_id1
ON WBSRSRC_QTY (fin_dates_id1)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsstep_1 on table WBSSTEP

--METADATA NAME:ndx_wbsstep_1 TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE INDEX ndx_wbsstep_1
ON WBSSTEP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsstep_2 on table WBSSTEP

--METADATA NAME:ndx_wbsstep_2 TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE INDEX ndx_wbsstep_2
ON WBSSTEP (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsstep_dsi on table WBSSTEP

--METADATA NAME:ndx_wbsstep_dsi TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE INDEX ndx_wbsstep_dsi
ON WBSSTEP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_tmplcatg on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_tmplcatg TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX ndx_wkfltmpl_tmplcatg
ON WKFLTMPL (tmplcatg_catg_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_dsi on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_dsi TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX ndx_wkfltmpl_dsi
ON WKFLTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfluser_workflow on table WKFLUSER

--METADATA NAME:ndx_wkfluser_workflow TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE INDEX ndx_wkfluser_workflow
ON WKFLUSER (work_flow_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 256K next 128K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_wkfluser_users on table WKFLUSER

--METADATA NAME:ndx_wkfluser_users TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE INDEX ndx_wkfluser_users
ON WKFLUSER (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 0
    STORAGE (initial 256K next 128K minextents 1 maxextents 99 pctincrease 50)
/

prompt Creating index ndx_wkfluser_dsi on table WKFLUSER

--METADATA NAME:ndx_wkfluser_dsi TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE INDEX ndx_wkfluser_dsi
ON WKFLUSER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workflow_project on table WORKFLOW

--METADATA NAME:ndx_workflow_project TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE INDEX ndx_workflow_project
ON WORKFLOW (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workflow_users on table WORKFLOW

--METADATA NAME:ndx_workflow_users TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE INDEX ndx_workflow_users
ON WORKFLOW (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workflow_workspace on table WORKFLOW

--METADATA NAME:ndx_workflow_workspace TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE INDEX ndx_workflow_workspace
ON WORKFLOW (workspace_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workflow_dsi on table WORKFLOW

--METADATA NAME:ndx_workflow_dsi TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE INDEX ndx_workflow_dsi
ON WORKFLOW (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workspace_project on table WORKSPACE

--METADATA NAME:ndx_workspace_project TYPE:INDEX TABLE_NAME:WORKSPACE CHANGE:CREATE
CREATE INDEX ndx_workspace_project
ON WORKSPACE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 256K next 128K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_workspace_dsi on table WORKSPACE

--METADATA NAME:ndx_workspace_dsi TYPE:INDEX TABLE_NAME:WORKSPACE CHANGE:CREATE
CREATE INDEX ndx_workspace_dsi
ON WORKSPACE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=DELETE
delete from querylib where core_flag='Y'
/
--METADATA NAME=QUERYLIB TYPE=DML CHANGE=UPDATE
update querylib set query_lib_id=query_lib_id+100000 where core_flag='N'
/
--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
1,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,UDFVALUE uv :HS2 , UDFTYPE ut :HS3 Where orig_proj_id is null and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) UNION ALL SELECT :HO1 :COLS2 FROM RSRC r :HS4 , UDFVALUE uv :HS5 , UDFTYPE ut :HS6 WHERE (user_id = :BN1) and (uv.fk_id= r.rsrc_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO2 :COLS3 from UDFVALUE uv :HS7 , UDFTYPE ut :HS8 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS3)','QH=/*+ ordered */;HO1=/*+LEADING (r,ut,uv) USE_NL(ut,uv) */;HO2=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
2,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,UDFVALUE uv :HS2 , UDFTYPE ut :HS3 Where orig_proj_id is null and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) UNION ALL SELECT :HO1 :COLS2 from UDFVALUE uv :HS4 , UDFTYPE ut :HS5 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name in (:INCL1))','QH=/*+ ordered */;HO1=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
3,'CLIENT_SERVER','Y','Select :COLS1 FROM actvcode ac :HS1 , actvtype act :HS2 WHERE act.actv_code_type_id = ac.actv_code_type_id and ( act.proj_id is null OR act.proj_id in (select :HO1 :COLS2 from projwbs pw :HS3 , project p :HS4 where p.proj_id = pw.proj_id and pw.proj_node_flag = :BS1 and p.project_flag = :BS2) OR (1=2) ) ORDER BY ac.actv_code_id','QH=/*+ use_nl(ac) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
4,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,PFLOAD_VIEW prj :HS2 , udfvalue uv :HS3 , udftype ut :HS4 WHERE ( st.proj_id = prj.proj_id and PRJ.PFOLIO_ID IN (:INCL1)) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) UNION ALL SELECT :HO1 :COLS2 from UDFVALUE uv :HS5 , UDFTYPE ut :HS6 where ut.udf_type_id = uv.udf_type_id and ut.table_name in (:INCL2)','QH=/*+ ordered */;HO1=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
5,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,PFLOAD_VIEW prj :HS2 , udfvalue uv :HS3 , udftype ut :HS4 WHERE ( st.proj_id = prj.proj_id and PRJ.PFOLIO_ID IN (:INCL1)) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) UNION ALL SELECT :HO1 :COLS2 FROM RSRC r :HS5 , UDFVALUE uv :HS6 , UDFTYPE ut :HS7 WHERE (user_id = :BN1) and (uv.udf_type_id=ut.udf_type_id) and (uv.fk_id= r.rsrc_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO2 :COLS3 from UDFVALUE uv :HS8 , UDFTYPE ut :HS9 where ut.udf_type_id = uv.udf_type_id and ut.table_name = :BS3','QH=/*+ ordered */;HO2=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
6,'CLIENT_SERVER','Y','SELECT :COLS1 from UDFVALUE uv :HS1 , UDFTYPE ut :HS2 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name in (:INCL1))','QH=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
7,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,UDFVALUE uv :HS2 , UDFTYPE ut :HS3 where (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) and st.proj_id IN ( SELECT :HO1 :COLS2 FROM PROJWBS pw start with pw.wbs_id in ( select :HO2 :COLS3 from prpfolio :HS4 where pfolio_id = :BN1) connect by prior pw.parent_wbs_id = pw.wbs_id) UNION ALL SELECT :HO3 :COLS4 from UDFVALUE uv :HS5 , UDFTYPE ut :HS6 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name in (:INCL1))','HO3=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
8,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,UACCESS prj :HS2 ,UDFVALUE uv :HS3 , UDFTYPE ut :HS4 WHERE ( st.proj_id = prj.proj_id and orig_proj_id is null and prj.USER_ID = :BN1 AND prj.ACCESS_FLAG=:BS1) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO1 :COLS2 from UDFVALUE uv :HS5 , UDFTYPE ut :HS6 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name in (:INCL1))','HO1=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
9,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,PFLOAD_UACCESS_VIEW prj :HS2 , udfvalue uv :HS3 , udftype ut :HS4 WHERE ( st.proj_id = prj.proj_id and PRJ.PFOLIO_ID IN (:INCL1) AND USER_ID = :BN1 AND ACCESS_FLAG = :BS1) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO1 :COLS2 from UDFVALUE uv :HS5 , UDFTYPE ut :HS6 where ut.udf_type_id = uv.udf_type_id and ut.table_name in (:INCL2)','HO1=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
10,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 , UACCESS ua :HS2 , udfvalue uv :HS3 , udftype ut :HS4 where (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) and (ua.proj_id = st.proj_id) and ua.user_id = :BN1 and ua.access_flag = :BS2 and st.proj_id IN ( SELECT :HO1 :COLS2 FROM PROJWBS pw start with pw.wbs_id in ( select :HO2 :COLS3 from prpfolio :HS5 where pfolio_id = :BN2) connect by prior pw.parent_wbs_id = pw.wbs_id) UNION ALL SELECT :HO3 :COLS4 from UDFVALUE uv :HS6 , UDFTYPE ut :HS7 where ut.udf_type_id = uv.udf_type_id and ut.table_name in (:INCL1)','HO3=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
11,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,UACCESS prj :HS2 ,UDFVALUE uv :HS3 , UDFTYPE ut :HS4 WHERE ( st.proj_id = prj.proj_id and orig_proj_id is null and prj.USER_ID = :BN1 AND prj.ACCESS_FLAG=:BS1) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO1 :COLS2 FROM RSRC r :HS5 , UDFVALUE uv :HS6 , UDFTYPE ut :HS7 WHERE (user_id = :BN2) and (uv.fk_id= r.rsrc_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS3) UNION ALL SELECT :HO2 :COLS3 from UDFVALUE uv :HS8 , UDFTYPE ut :HS9 where (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS4)','QH=/*+LEADING(prj,st,ut,uv)  USE_NL(ut,uv)  */;HO1=/*+LEADING (r,ut,uv) USE_NL(ut,uv)*/;HO2=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
16,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 , UACCESS ua :HS2 , udfvalue uv :HS3 , udftype ut :HS4 where (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS1) and (ua.proj_id = st.proj_id) and ua.user_id = :BN1 and ua.access_flag = :BS2 and st.proj_id IN ( SELECT :HO1 :COLS2 FROM PROJWBS pw start with pw.wbs_id in ( select :HO2 :COLS3 from prpfolio :HS5 where pfolio_id = :BN2) connect by prior pw.parent_wbs_id = pw.wbs_id) UNION ALL SELECT :HO3 :COLS4 FROM RSRC r :HS6 , UDFVALUE uv :HS7 , UDFTYPE ut :HS8 WHERE (user_id = :BN3) and (uv.udf_type_id=ut.udf_type_id) and (uv.fk_id= r.rsrc_id) and (ut.table_name=:BS3) UNION ALL SELECT :HO4 :COLS5 from UDFVALUE uv :HS9 , UDFTYPE ut :HS10 where ut.udf_type_id = uv.udf_type_id and ut.table_name = :BS4','HO4=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
17,'CLIENT_SERVER','Y','SELECT :COLS1 FROM PROJECT st :HS1 ,PFLOAD_UACCESS_VIEW prj :HS2 , udfvalue uv :HS3 , udftype ut :HS4 WHERE ( st.proj_id = prj.proj_id and PRJ.PFOLIO_ID IN (:INCL1) AND USER_ID = :BN1 AND ACCESS_FLAG = :BS1) and (st.proj_id=uv.fk_id) and (uv.udf_type_id=ut.udf_type_id) and (ut.table_name=:BS2) UNION ALL SELECT :HO1 :COLS2 FROM RSRC r :HS5 , UDFVALUE uv :HS6 , UDFTYPE ut :HS7 WHERE (user_id = :BN2) and (uv.udf_type_id=ut.udf_type_id) and (uv.fk_id= r.rsrc_id) and (ut.table_name=:BS3) UNION ALL SELECT :HO2 :COLS3 from UDFVALUE uv :HS8 , UDFTYPE ut :HS9 where ut.udf_type_id = uv.udf_type_id and ut.table_name = :BS4','HO2=/*+ index(uv pk_udfvalue) use_nl(uv ut) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
500,'CLIENT_SERVER','Y','SELECT :COLS1 FROM rsrc r :HS1 , timesht ts :HS2 , tsdates tsd :HS3 WHERE r.rsrc_id = ts.rsrc_id AND ts.status_code <> :BS1 AND ts.ts_id = tsd.ts_id AND tsd.start_date >= TO_DATE(:BS2, :BS3) AND tsd.end_date <= TO_DATE(:BS4, :BS5) ORDER BY r.rsrc_id','QH=/*+ FULL(tsd) INDEX(ts pk_timesht) */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
18,'CLIENT_SERVER','Y','SELECT :COLS1 FROM rsrchour RH :HS1 , timesht TS :HS2 , tsdates TD :HS3 WHERE ( RH.proj_id IN (SELECT :HO1 :COLS2 FROM PROJSHAR :HS4 WHERE SESSION_ID = :BN1 AND LOAD_STATUS = :BS1)) AND RH.nonwork_type_id IS NULL AND RH.task_ts_flag = :BS2 AND (RH.hr_cnt IS NOT NULL or RH.ot_hr_cnt IS NOT NULL) AND RH.ts_id = TS.ts_id AND RH.rsrc_id = TS.rsrc_id AND TS.status_code = :BS3 AND RH.ts_id = TD.ts_id ORDER BY rsrc_hr_id','QH=/*+ ordered */')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
19,'MYPRIMAVERA','Y','SELECT :COLS1 FROM TASKRSRC :HS1 , TASK :HS2 , RSRC :HS3 , PROJECT :HS4 , ROLES :HS5 , PROJWBS ALIAS_PROJWBS :HS6 WHERE TASKRSRC.PROJ_ID=PROJECT.PROJ_ID AND TASKRSRC.TASK_ID=TASK.TASK_ID AND TASKRSRC.PROJ_ID=ALIAS_PROJWBS.PROJ_ID AND ALIAS_PROJWBS.PROJ_NODE_FLAG=:BS1 AND TASKRSRC.ROLE_ID=ROLES.ROLE_ID(+) AND TASKRSRC.RSRC_ID=RSRC.RSRC_ID(+) AND ( ( TASKRSRC.ROLE_ID IS NOT NULL) AND ( ( DECODE(PROJECT.ORIG_PROJ_ID, NULL, :BS2 , :BS3 ) = :BS4 AND DECODE(ALIAS_PROJWBS.STATUS_CODE, :BS5 , :BS6 , :BS7 ) = :BS8 AND DECODE(ALIAS_PROJWBS.STATUS_CODE, :BS9 , :BS10 , :BS11 ) = :BS12 ) ) ) ORDER BY TASKRSRC.TASKRSRC_ID ASC','QH=/*+ FIRST_ROWS*/')
/

--METADATA NAME=QUERYLIB TYPE=DML CHANGE=INSERT
insert into querylib(query_lib_id,app_name,core_flag,match_sql,hints)values(
20,'MYPRIMAVERA','Y','SELECT :COLS1 FROM TASKRSRC :HS1 , TASK :HS2 , RSRC :HS3 , PROJECT :HS4 , ROLES :HS5 , PROJWBS ALIAS_PROJWBS :HS6 WHERE TASKRSRC.PROJ_ID=PROJECT.PROJ_ID AND TASKRSRC.TASK_ID=TASK.TASK_ID AND TASKRSRC.PROJ_ID=ALIAS_PROJWBS.PROJ_ID AND ALIAS_PROJWBS.PROJ_NODE_FLAG=:BS1 AND TASKRSRC.ROLE_ID=ROLES.ROLE_ID(+) AND TASKRSRC.RSRC_ID=RSRC.RSRC_ID(+) AND ( ( TASKRSRC.ROLE_ID IS NULL) AND ( ( DECODE(PROJECT.ORIG_PROJ_ID, NULL, :BS2 , :BS3 ) = :BS4 AND DECODE(ALIAS_PROJWBS.STATUS_CODE, :BS5 , :BS6 , :BS7 ) = :BS8 AND DECODE(ALIAS_PROJWBS.STATUS_CODE, :BS9 , :BS10 , :BS11 ) = :BS12 ) ) ) ORDER BY TASKRSRC.TASKRSRC_ID ASC','QH=/*+ FIRST_ROWS*/')
/
--METADATA NAME:or_create_private_user TYPE:EXEC
declare
  vprivate_user varchar2(40);
  vprivate_passwd varchar2(255);
begin
  vprivate_user := '${pm.or.privileged_user}';
  vprivate_passwd := '${pm.or.privileged_password_encrypted}';
  if instr(vprivate_user,'${') = 0 then
    delete from PUBUSER where public_group_id = 1;
    insert into PUBUSER (public_group_id, private_db_user_name, private_db_passwd)
    values (1, vprivate_user, vprivate_passwd );
  end if;
end;
/
  
--METADATA NAME:orpm_settings TYPE:EXEC
begin
merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N');
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
begin
insert into settings(namespace,setting_name,setting_value)  
select 'Administrator_Settings','OnlineHelpRootUrl','https://docs.oracle.com/cd/F74771_01/client_help/' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','AlwaysLaunchOnlineHelp','Y' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','MaxRoleCodeTreeLevelCnt','20' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxRoleCodeTreeLevelCnt');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt','20' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxAssignmentCodeTreeLevelCnt');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','EnablePasswordPolicy','Y' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='EnablePasswordPolicy');
commit;
END;
/

--METADATA NAME:orpm_settings TYPE:EXEC
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
	v_no_data_found NUMBER;
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
		  select count(*) into v_no_data_found from nextkey
          where key_name='findates_fin_dates_id';
          if  v_no_data_found = 0 then
           insert into nextkey select 'findates_fin_dates_id',1 from dual where not exists (select * from nextkey where key_name=lower('findates_fin_dates_id')); 
          commit;
          end if; 
          select key_seq_num into v_fin_dates_id from nextkey
          where key_name='findates_fin_dates_id';
          update nextkey set key_seq_num = key_seq_num + 1
          where key_name='findates_fin_dates_id'; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 

--METADATA NAME:PREFER TYPE:UPDATE CHANGE:UPDATE
update prefer set database_version='PPMDB,2312.0006.0000.0000'
/
--METADATA NAME:PREFER TYPE:UPDATE CHANGE:UPDATE
update prefer set min_pro_version='23.10.00'
/
--CONNECT USERNAME:admuser
prompt Creating package UTILS

--METADATA NAME:UTILS TYPE:PACKAGE SET:UTILS CHANGE:CREATE
CREATE OR REPLACE PACKAGE UTILS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
3c4 185
Odyv2sR76eLvQBvwms8gspSQrfQwg5W3r0hqynRAv/9ezlpjQUUmANKi4xNR81uIXg2w7bW6
dPGg3rfYo7+IGI42ndf+BY8NOncq5o4e5muE+1CqQbrWXF0/HtUOV/2iWMiquCV+Sux4CnNR
ITswkS0Ew0HxSKVvwv8jqiW5f/qo8fMFCU+MYH95FPtg9FlnLT73HzJGwctiF24mSRGxoMW9
A7zwZePaOb4wRvekfqazY4QRKHhUgbwxeb/VS8PuiJfZUy1zVOVAbBLqSulbv0nLORwdixs0
yVUUHfONBzhffx7hQdBCrj+295k8XIqTTrZxL/nVgwpwZHCT8aqvm9EaDMpUKJx+FLZ0Zc2L
cmQB4PMm/CzN+c39hkddzQ==

/
show err
--METADATA NAME:UTILS TYPE:GRANT TABLE_NAME:UTILS CHANGE:CREATE
GRANT EXECUTE ON UTILS TO PRIVUSER
/
prompt Creating package body UTILS

--METADATA NAME:UTILS TYPE:PACKAGE BODY SET:UTILS CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY UTILS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
dd6 44f
NayoLW2gvrPrUgHj/pS4No3RxV0wg1Urr0gFfHRVrQ+vun4hsuyk/aCp4ArifOnfFL4Mrr7Y
B0w8hBK0aywk8qcBe59o9YhLODnxV46hAJvMGsWnEDhEBy5YJOZ5AiGCycmmJVRiAi3KDFzd
gbJNo5cq0bTGGGozs8LwqrY5pVzAFrtpAZjugz76bpM5kOycPriujF16h63e940NwmmhAx+X
m6xWAQ08ZiRxozsXUyspwpsPcbqvLtXZMIf2uYZn/TjasqXMeTCod0evuNXZbgxIAFfim38s
QLYf9BJcftnuNymKQSlymbuLN/oWoUkz9DMpe9EyZR+6pWD7VT3FA1HDskGsBvvXeTuUdijx
Fl9b3r4tGT7rfm3asc/FhcJhxh2BDQNfFtoHhI/wgMSh0pDcyLipKBWE5NdwkojU9RgCmUJW
yamHjwbL5Wya7pN/Ri4Scj3Yu9nzz1QdpjrJ9jNTDFwFbD8zCRbmFQX9R2Q4uT/e6HzqJaXr
AM8SPyM3LHJkpdJO+NkeNIFrwKIkkEJ+HZ0T/tDJEMXBtYRFElCDnyOrmbS1+Z6ZGv5B6UZi
/i6arudstXZJ6h3mn4hkcf6Bm2QEqzCrM3EeCetUKraLkDUG6N7xiCTD0Cu/glfzDHaQoWf8
6oXbGB2U59J8LiYWWcznA+v9YQOk6bIOa4RraT7eKh98D6A+hBk91lkao91cnlMo14TW8bvY
ch33bNcYxpwzDOajYmH0M5rNQN57FJOnAZT2Hy3cUdJh2jgA9qEsfMyIavh/2+gZ0nw0eJPo
QT2TPHXxDFRj3vKG78MsZjI5HxFQJ5hFv61Ite+zs3ZkQuWgvPbMRbWi4VuJ67ZamgX8t3GU
M7wD1gU/skCEqf3TptYn/KD/VzNqhKGjNXxizA8TtztKh+SrNO7yH0izhv7tZmDPz1EwjTay
g21Mhn+kUohFhlAeplEVe7iJV23zDoWHPzC1u9e3UApIusAECdMB1ewVys0jg+drfyycO9Nr
LL8MrLbS9zNtg/4MmjkQhqWVNPIf7f+zqOcgH6SOwigyPFcnd66BotzmX4BdjHhb/rGaFbFP
P/sqKknN

/
show err
--METADATA NAME:UTILS TYPE:GRANT TABLE_NAME:UTILS CHANGE:CREATE
GRANT EXECUTE ON UTILS TO PRIVUSER
/
prompt Creating procedure SETTINGS_READ_STRING

--METADATA NAME:SETTINGS_READ_STRING TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_READ_STRING wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
227 148
AiCwdvSowjMmi07SvgJ1ZOlm5Gowg5X3NcBqynTpmIuOo9+ChzKT0B+e43WIZnrKJblTtWLl
fN/0rlBstRAU+RfZ+vEKWA7IWo+63lhQDWaTKIuCXibMylw3W8mY4PnscAs0XjFQ0zYcRVhF
+dEuj4WMyxEoX4FGy+FxC3cKDWlIrybp3H3gS3XVVeH9qY/uAVaQ1tjSog77ZpOtwF/w8XAo
s0wisPiFg41PjSH51SWbp2T9yFV1g7a5SpM+lea1AxDdjMgB9ess6BTOMVBkYy7mI58amARX
Kges17Dlp7MZ+Ze7Q+QBe6lV5AhbHVJtJw==

/
show err
--METADATA NAME:SETTINGS_READ_STRING TYPE:GRANT TABLE_NAME:SETTINGS_READ_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_STRING TO PRIVUSER
/
--METADATA NAME:SETTINGS_READ_STRING TYPE:GRANT TABLE_NAME:SETTINGS_READ_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_STRING TO PM_BG_JOB_ROLE
/
prompt Creating procedure SETTINGS_READ_NUMBER

--METADATA NAME:SETTINGS_READ_NUMBER TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_READ_NUMBER wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
139 103
vzqUNOj91Y6iSkEdyW0FoIcjSrswg1xK2ssVfHRAWMee0CaJ+wQmBGjUiVreo62hsWi1b1PQ
plWKtWMgiyZJE1jKCfLRdC18a2Ko0KQtJVl/+DZe3EsMOYup75WIEuEfcDW5moW/Ad9zD2Vw
KQIJlpmSNJP4YD1DgYcYrdMfF2zI3CuMfMWpMGd3TBCYhxMrMiFTS4NJpXVUHEzai4CYTxsu
AUyzSWGLmahqpoA6CDahu0cyzM+eYe3PpgFMXtU=

/
show err
--METADATA NAME:SETTINGS_READ_NUMBER TYPE:GRANT TABLE_NAME:SETTINGS_READ_NUMBER CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_NUMBER TO PRIVUSER
/
prompt Creating procedure SETTINGS_READ_BOOL

--METADATA NAME:SETTINGS_READ_BOOL TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_READ_BOOL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
248 168
6zh43ti9MvGQAaweb7pIE/TY65Qwg3lp2Uhqyi+KMQ8teNrTW3E+nGA7oooyrKL7Yi8+SbW1
D/Xw1g8pvXVYkKTUtx5LrkYvfGB5IDgUw3MwMv/DsjhaG6wM86Dw4TRcnQQ0/MiapWl3VZQQ
K2aGulpn0NYGMQhrWZeO/Y4vFNAaqSH8PwcFkUcmCWvh52RVlS3eY3pMG1HjH4tHzpQgg2UK
B2qLLMgvu1dSEzFkIE3vbNhJgCH7mik1f3pOp17LQv7ijC/0LC6hxTyfiwoWP9kXwSg00jQU
QtDDdGX6OpkPZqyMpCuEyxKpBYy5k7VJEuBXnpCQjQwM9ryf6nIY2Xliz4ci+aYhi0q6

/
show err
--METADATA NAME:SETTINGS_READ_BOOL TYPE:GRANT TABLE_NAME:SETTINGS_READ_BOOL CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_BOOL TO PRIVUSER
/
prompt Creating procedure SETTINGS_READ_DATE

--METADATA NAME:SETTINGS_READ_DATE TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_READ_DATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
193 134
P6Q5KXrq6+C4P2NIAJSf+7iY/T8wgxBpmMsVfHSR/+owjI2sNuMm468hOcUCoJfWKgwHZfXg
Bruho+FiHVhumE46imCxbL2wvXSTuiYDCOxpMDenVOj6V95rn29m3WvMMGzrcKFpPlNr0ZZN
xF8ozo4Gyn1GazGaaUU3GMu9REMadHn/yDON56CQzK2EaqZH2mfA198eMrzQotO1fIB76ieX
H1tLDdDxfm/jlk/uO5I/PWFQMgVMs5ptxgutRXLcONjLT1YB7pr9X2yuaiIedBsgOgTKuUF2
+V8bbDNtH4QTfoQ=

/
show err
--METADATA NAME:SETTINGS_READ_DATE TYPE:GRANT TABLE_NAME:SETTINGS_READ_DATE CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_DATE TO PRIVUSER
/
prompt Creating procedure SETTINGS_WRITE_STRING

--METADATA NAME:SETTINGS_WRITE_STRING TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_WRITE_STRING wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
258 15c
/f9bdQ/13B42/x3rqsF453dJIbwwg5X3NUpqynTpmIuOGcPyFG+MMWCTUI8UWnQ4fCHZaLVv
bOihfb1F5uQgisHQKNmpe0Q2FQTwExG61vRTzHQ6G6u1w9+oBFuulECTAg/Ij5CShJsnznxG
ke2nwN5mdBOzmCdxNvCM8t+sDDxh5vcwj5FupnwLXAyKhG5SxKbxscWHX93gvKSXKxYSFlN+
ZIKLDdElvNSLnkPSMan6mmxMn7PTPzjS3hzM0hfFWY2kgp9s0ZLE/kvYavHA4gDkuHFj7VI6
LmgdD9Gbi5HIgRE6LePPrva+KAx3cdJDbQExXBwRedencrkz4Z5Qp1E=

/
show err
--METADATA NAME:SETTINGS_WRITE_STRING TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_STRING TO PRIVUSER
/
--METADATA NAME:SETTINGS_WRITE_STRING TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_STRING TO PM_BG_JOB_ROLE
/
prompt Creating procedure SETTINGS_WRITE_NUMBER

--METADATA NAME:SETTINGS_WRITE_NUMBER TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_WRITE_NUMBER wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
cf d2
5cSvtk8IHLQlmRHgjMZBkhgPH+Ewg0xKf8tqynTp2see0DXg/Oz6+3g1ZstlG6S+tWLy8Ss7
RRAkk7u1VhOwaQIOyCddvqCwomPUMpBaR8i/WY3KZXE2dpHUjfJgqgaklZYWv4bc+W2S9mIU
YkDWYCvn0t3soJgJwjltWBFKfo+d7U3S9lA7pFH+5x681+r1LJ2kslIEIJbYJXih

/
show err
--METADATA NAME:SETTINGS_WRITE_NUMBER TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_NUMBER CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_NUMBER TO PRIVUSER
/
prompt Creating procedure SETTINGS_WRITE_BOOL

--METADATA NAME:SETTINGS_WRITE_BOOL TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_WRITE_BOOL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
12f 10f
U3TTsVM2WlSA+oTFzqiN/+R19RIwgwHQAMsVfHQCWMeeIGIJOUbb5jbxBUV5Gshg9F7UGbVv
UyRpNgk5wRI/YQ/jhC4uSjb0dTu7JdJfp97lQK8mZV99ZTeBm1QdNtAo8vseAvAEHhyGkykC
qu+yqEkYt3nfgiF34J90Itq/w3WO3TTvUuR1l9mzTRh7HumgYn4Fu7jhud5AmMEj1qwL6BXn
G5x9rnnMfcUSvlEq8pdPiSXVncADKQAZo/y/574MQHVqmVDxWdM=

/
show err
--METADATA NAME:SETTINGS_WRITE_BOOL TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_BOOL CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_BOOL TO PRIVUSER
/
prompt Creating procedure SETTINGS_WRITE_DATE

--METADATA NAME:SETTINGS_WRITE_DATE TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SETTINGS_WRITE_DATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
112 10f
4tyl1mJFe50Rb5Qpdyoy87EF2Bowg0yuACisfI71uWQw/ciJ2w6222slSd8mAtIdxtF0V3x/
Ort5843O6L/+udH+e1U8hZBgfBE7afAIv2JWI/9W8aAeWPXn5jXbjnuVSBF7K5ZxcvUQAUXK
9e7Ew8h71oOZHJNrVrg0fEliFkkBYHWoS5GrCp3o0ktyxcDUYE3XDXo3eRCO2DIRm3S3rl4i
dHxKlS1uHEN6Sa+ZtSBGqaklKm35kp3qkt6I7TaUZJ+WSdhapQ==

/
show err
--METADATA NAME:SETTINGS_WRITE_DATE TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_DATE CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_DATE TO PRIVUSER
/
prompt Creating procedure BGP_WRITE_TO_LOG

--METADATA NAME:BGP_WRITE_TO_LOG TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BGP_WRITE_TO_LOG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
53b 2c1
dA3NsEysBz1A9pdju8S1QlKArCIwg5DD2UhofHSKDfiUNDEnpHDzIenzxFs71zLDVChawKxu
zxaSHzrO8fEswKug6TJ8Vvdq7siJbsSkM7eAU3RIP5vFBnbNeoPuNmmYcEmaqHrymgBaqgWp
Hn/1HkFhCDF5yX0IxbB/5mNHPSNijMLoUVdQV9IZkjELNoIpmbm8yauAGLfNe3T9sbNqTLhp
6JzzqKqejFcmZ1b/2TUMyF6g1CfaAq0j3qyKV/CndleS+CrPcynPIpki387D5U0gu7klvoTr
IEbPqe8+JeeXonZQxLCJXilCtbIVx1RzPTIm0J5wfv+UBh1lkbBsWZuXdPu3LaAc5Vg0Wa4t
6kDtwlnHDnCvdkESn+eq2xACTkoxaVzAqUWsnB/jhynsi2aUEQeer9TyaISbo+F+Cn3FmENp
QqzTViZCO984b9mH0NanRvnER9+e8TTC5CuwnZR6Y8KU7eSW3PQO0eigir4UZHq92CCJ0XAo
evKNVxstcgRjzAPYz7qeN0Ilq0286hoIizL6TiMdUwFhZ0TPqZZPKdPnzs6fyCTrW4e1TxWe
H3n7wRxOZggeR2gaG2RcoRAoJKrD2uVTdBsO0M/aYiTJ0kY1Lk9Y97JdnNj7SIQdeumHrblL
yn2Mdkl0aZacxJMZ7cmIGEDCofSfK/aUBbb3Ybs/+4nOAMQ=

/
show err
--METADATA NAME:BGP_WRITE_TO_LOG TYPE:GRANT TABLE_NAME:BGP_WRITE_TO_LOG CHANGE:CREATE
GRANT EXECUTE ON BGP_WRITE_TO_LOG TO PRIVUSER
/
prompt Creating function CURRENT_SESSION

--METADATA NAME:CURRENT_SESSION TYPE:FUNCTION SET:GET_FUNCTIONS CHANGE:CREATE
CREATE OR REPLACE FUNCTION CURRENT_SESSION wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
273 17d
Mz+8OkPCPKftrAQd4tjaXn1ZHD4wgztpLcDWfHTNR+oRHWFxxsB022+vv6K4wpDJC6EHVind
tZpcOWxLoF54+CkpKe2xYGWvsjYbZe8C+oz+m3Kegmnd9qaAuN609bKdnIgL41lnCM+i/6tP
+xoC+pOVxTUGub/bt++vcZlE21KiP56caYTisW7XDOekG4vozsxqa5dvfT4DShIh+/Uq86QC
7g09m7hATV7Oisjz5H1+YnUUNI465Cpy/rvGcxuA/cJw6XyPoB/S0w67CkNmh7JKJu/tlvE2
1lMBnTA5YkMO9cIehDiBjXyIofM9uzIUbSVEipfj+GZhq6BGoKUnyvmqkhAzncBka5RaIit+
LpgI083NW/pTkAQ=

/
show err
--METADATA NAME:CURRENT_SESSION TYPE:GRANT TABLE_NAME:CURRENT_SESSION CHANGE:CREATE
GRANT EXECUTE ON CURRENT_SESSION TO PRIVUSER
/
prompt Creating procedure GET_INTERVAL_DIFFERENCE

--METADATA NAME:GET_INTERVAL_DIFFERENCE TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GET_INTERVAL_DIFFERENCE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2ac 1d2
1AZAfHGKo/WTVsuMhjYd6uhTruEwgzL310isZ44CmIs+uctaS0TWLu9SfxXpsK83R9Ch6rdg
S2wm3y3ocpo1layvlVaL2a3BQdpepXrUolJGRPIuWKK8G1jcEexmgG+MRI+O6kjLaTn2FYZs
7gsoGKpsXfLhXgqtm0C3eC7x6myjOb3oogHT5Mb09vM4rGxMa0pONgVnSbjvagVSHxfWolll
NBnBUw7YH3yQN2nHqEKd2JyouoUBLEUZ1wQLp74iB9rWf6+4UBa4cqHesJd0ipCywPQuamG+
iPNGa5rjf7bEkk+oc9nHfZqCz8uI1O6kMjHMvyRHMG6fT8zBxtza+7iJGAMMG0Hza+EqPhhf
1KIlbt5desH/EYqu5N0DJOWM4v7G/KX4+WPZI5g7yz0/Xi43ubImDFc8mJ7fmgEBT0DKDEeG
6ac91d+QDTtB3Nnpp7PpKKofF2So

/
show err
--METADATA NAME:GET_INTERVAL_DIFFERENCE TYPE:GRANT TABLE_NAME:GET_INTERVAL_DIFFERENCE CHANGE:CREATE
GRANT EXECUTE ON GET_INTERVAL_DIFFERENCE TO PRIVUSER
/
prompt Creating procedure APPLY_ACTUALS_TASK

--METADATA NAME:APPLY_ACTUALS_TASK TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE APPLY_ACTUALS_TASK wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3ef 191
E+Pwm08SZxxYwqPBh2R7tAe93sMwgxBeNUpqynRogmSlUtXNOLtcy0ilYczrRqzMPba1tZXT
CQl0zL7KQsl+1N/U/wDeIL1QdQiISxfQjJlfueW8LkVqDu4QG6ra93PMcKwLkbvmJPYjN3NE
6haLk3DZNe9J9b544xvt+0SRoSc2FCpEjmwX00MnTcgYF3rJErK/P6f/Z+sskvfu/lz+QGrD
Zb/e+ndVKMkM/j66r9je/A5QJraQB6E+piAlmOtXpnYI8UXN2mdJwfMKQ+tK4AHZMGxNE1Vc
1tV9zVArI4gf0nu/6LtdSICY8RMwCvNcRZ8fxWrAlBlAx3FXTepm2i8IRYzg2hhKizC6NVpF
kIH0GMYCBsECM0/J6z4/w8WSIj9zHZJyTow=

/
show err
--METADATA NAME:APPLY_ACTUALS_TASK TYPE:GRANT TABLE_NAME:APPLY_ACTUALS_TASK CHANGE:CREATE
GRANT EXECUTE ON APPLY_ACTUALS_TASK TO PRIVUSER
/
prompt Creating procedure APPLY_ACTUALS_TASKRSRC

--METADATA NAME:APPLY_ACTUALS_TASKRSRC TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE APPLY_ACTUALS_TASKRSRC wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
34f 164
pxJzhYyQBJgXHi/IZltkuaWEeD4wgxBe10hqynQZMa7uhhvNSxI9HbKHb2IuWH/sIwZzmlEa
XzaEISxa0nOpOm5XvLKRHbarwYsSIdY2gvgW1KoDwfuHVTMcSW2+p7jtL50d4hTQFLOwsKL2
RrhMJxhvE71oPuiXpdgY5XTs8tfpzV6JMz4Y3l8kwOrNjGOutsmv0C6ft/IyVgtF7N46rjkg
cHpxEW5vptuPQQB5N2Yj8T2xSQcwIvIhkLrl0MNCnoetkhoDjNSNNC6dhSgzucH3lasgdM35
wckj8HGuSJy17vCjKLjqF3FVA6QLvhevtzP+bSXQN3P+D+aapbZn/LXSm6bxjJdc

/
show err
--METADATA NAME:APPLY_ACTUALS_TASKRSRC TYPE:GRANT TABLE_NAME:APPLY_ACTUALS_TASKRSRC CHANGE:CREATE
GRANT EXECUTE ON APPLY_ACTUALS_TASKRSRC TO PRIVUSER
/
prompt Creating procedure APPLY_ESTIMATE_TASK

--METADATA NAME:APPLY_ESTIMATE_TASK TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE APPLY_ESTIMATE_TASK wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
33f 158
zGjaFpZsCUGczEurYVlMG+Euow0wgwJe2UoVfHRdimSlUuoG3aTNqC8d8yFGd/MGXbW1bbLM
RR7fzPpj/DAc/02yCD8UE2Zrve4z06sxskChtF/qzp5DPv9ReyKyWxi63cr3hbotk6V4EJ2J
iBMwG28uVP9B/jCNW535TLMl+hr9huKSKNQ6cjQ+HvdxTdsqndA0/BfvEr6irSOHgbqGr3h1
88v1nxymfwIJYCYfUhQ/miZe7/lH/Nfe6ynSo4WZNFx9bw3gFY1R6xJMEUC/YQnX/2Hspd8a
91YI3+n+O16OGYshUW9y7MECm3KpkHK8OZTPKMgSGSA/+76mUBo=

/
show err
--METADATA NAME:APPLY_ESTIMATE_TASK TYPE:GRANT TABLE_NAME:APPLY_ESTIMATE_TASK CHANGE:CREATE
GRANT EXECUTE ON APPLY_ESTIMATE_TASK TO PRIVUSER
/
prompt Creating procedure APPLY_ESTIMATE_TASKRSRC

--METADATA NAME:APPLY_ESTIMATE_TASKRSRC TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE APPLY_ESTIMATE_TASKRSRC wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
282 130
1FHYw948tqXiSEycyS5vqG1EIfwwgwIJNcsVyi/SNGS0jBscNHh2EZMF1G9Sa38ACLUPWvaV
4N5omZG/yXAb9s6H96t1aavr8EHY9hIphdreIH6+rIz0v5rFcfIoEKHPOW7ocbdOGo3qN60u
sMdBfzsFdUdvGWrwdeVRUQp2ewecLG5427zupHZelrpzD7ttBT3WtlqZbD07OWd2R4rKYKwR
+i6SiB7gE1owgV5YeqLTXqxVzvP6/gO0faFd2OIWWM7p8Z9vE4UggzcIfhZWtskri9fjzeHK
ddHLlitDkMQ=

/
show err
--METADATA NAME:APPLY_ESTIMATE_TASKRSRC TYPE:GRANT TABLE_NAME:APPLY_ESTIMATE_TASKRSRC CHANGE:CREATE
GRANT EXECUTE ON APPLY_ESTIMATE_TASKRSRC TO PRIVUSER
/
prompt Creating function PROJSHAR_INSERT_REC

--METADATA NAME:PROJSHAR_INSERT_REC TYPE:FUNCTION SET:PROJSHAR_INS CHANGE:CREATE
CREATE OR REPLACE FUNCTION PROJSHAR_INSERT_REC wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
aa8 3f9
+VH4LDnkspbIL+FPzqoL89nJoVMwgz0rr0oFyi/NKvkYvjtevrNIIwp49+PwA0i9VKm3M121
tW3LcHwvu2DlMyWNwr2CHTRCIAR9YBl9h7gEGs4mGeNuI+JNd7caLswVuNomJiA30Jy2jVwt
MX45JSHDJvSz1QEZ+9bm/eK3W4I1g6HeUYBE6mb9aDi7eoRJVJZZz3LBPlAlSl9Zhsgteagm
HGP+lKKUptcWjcipTbhQE6qmGGWDEbhaO2O3BuC25v3ocHnEeMU+dKIJ4rCtCtZycmAvGYOh
th9ikHtg/wSl0sE+V7poWus+l6DqbyfwqBruI0AnQOqYCcoLfzEysrJD2TyjAopy6/KgvHQI
L/rjBztLx1kGE7cvX9OHH0kjua0jc7+PybQ6suU6eKNijoJK87STALFmkWmV3QqOu6sFlDBw
hFnPZ3BampVOsg21G4VLEurTwZ3NIndf+Uh9cOWaHZXgtl4MIVh7fwbhqy48W8pEC0kl5OVz
tJTBxLufqBk8RD8TrpqVRpPdb1nFoAeIn93eCPeFVSZdJMsOQ1qkb5eOkAvYpecdi51dEUfC
4ExEtVaQBXhUkOAK8TaLHSWENtq9Osg6Wz5DJXqnFwG+Ssp/OACMUOQdvuIAwXF9kYfYU17O
rZAXWzUtGh8cKKXTlrgfyDrWIrLJjNlkBXDE8lhK8dVDI/Xod8DC4gi+m+ainjQct2CQRgFa
/sflx2Zh7aTuiMAlTsfzT/Bz4F/eKEQYjZgVs/kk7n19DIYDPsW5PphkvGZu/mbuPtfRJJv2
jgDKFmPBL7e3+q3LMN/eVBwXKTTl0zvV4w9bfV9AKEPZARIsVBnyHCrT/qbAdwJx8qr90RPD
odHzM2NgCPpqYOUOcdHr5wGN6/c0p2EvGmQflYbojhgVTGq5TJEcSIvpAdELG0YfGbwsSz7i
ek4O0k6f4uuahvJ8xsoKTfgS3bmeIfjtBjhaTZCz/Rdz3I39R8mgFCfnzpsffcEQNQ==

/
show err
--METADATA NAME:PROJSHAR_INSERT_REC TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT_REC CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT_REC TO PRIVUSER
/
prompt Creating procedure PROJSHAR_INSERT

--METADATA NAME:PROJSHAR_INSERT TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJSHAR_INSERT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2d9 1ba
Abx5U9TKLwm2jJGTp9uiBLqOHykwg0wJLcBqynTNq6oCYRS/ucgNvss2XUAcNXYVoXj5tZbF
ikaXAd3C0hRBQYllk/XHYFpYvDonwIH3f5zupilS7vyk2zqfr3oVSwXN8S1vWPbd2kB5RpW7
PuVflZAtd5i9Z8cxzuuir16E+M50qWr6R2vu5lcVcDCmWnF5z2NBlVIokXFD4JdHcAII7vVG
0K60B3PT+dXkl76PnNDTIxD7dz2u+E62EeB09yvfaeJT6PxlzXw5oET12gKObctuZVVBS7kS
cS2hmsckPU6kkVG2AeFv2PKGYNzjkE985C11GNv1efOn5YKVd/TJJlHsEYChbJJ55enE7ODj
FgpVgD6PqgUJgqN9/YIVyS6nQh5zBHiCdirQ726czH4Fk6OoOE+T/g697U+r+gK/mBk/+2hb
5SA=

/
show err
--METADATA NAME:PROJSHAR_INSERT TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT TO PRIVUSER
/
prompt Creating procedure PROJSHAR_INSERT_UPD

--METADATA NAME:PROJSHAR_INSERT_UPD TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJSHAR_INSERT_UPD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
135 107
HGMxdoc0v9CMPmBfhu43Iv5SApgwg1xK7csVfHRGk/peMDa9FHAUjj55VhbFoZHaAmK7tW91
LI131lv4uZgMjtrSWC/Tlf0PpI0ifPGJbjSTNeCRuQsW7QfIu2Il1FYkt0B9zzhS8YhggJAj
KOu3aZd9OeOTP7wqBMbolQwsdKklkOSEgRUWae/9TbbDpVNRPNiSITLalFOPF0brQkBLxVgj
pP20kwulMTjTbM86+1ERnta5/t5ItLk7r4/NBkQ/ji4j

/
show err
--METADATA NAME:PROJSHAR_INSERT_UPD TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT_UPD CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT_UPD TO PRIVUSER
/
prompt Creating procedure PROJSHAR_INSERT_MULTIPLE_IDS

--METADATA NAME:PROJSHAR_INSERT_MULTIPLE_IDS TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJSHAR_INSERT_MULTIPLE_IDS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
306 213
inUzZYkZMwLM/MXhtUQtv4tnMlAwgxAJBdxGfC+BlLzgh3Qv/QP8BQYiuIif9vIFoAIyC6Ak
FcbaREXY1IWZxwDB9cmgzLJh1jVQYO0xXgF6nG/wTnPKdrHhACB57LoXU3pBvtoNFjBypKsE
1etpaoIM+/U9IRE7H1dRpq3SKqs5qDg+R40UdQTLzNb/0I2mKlNPV0VerAo7q6OKxfHm4i9E
Go0CId45C437kjrHeYR/xHd2Im3h/Vs50M7i7aQnCfmcIzkxxh/4z4UEen91AR9nj9WHF8Mo
zWn0lG8OzAk5XZLCw2oeqMIhJ8i5D/FRWbd/J7K3G05SUrtV6QuIEfFXiUNDx3RgnY+HsImd
ip+YUXS+oNTvnMeTgIaP3UPNWUYJe5ed8bsoj4kPBMC8J+ebpj9PZxwTtNDNwhONwlxlBTMr
if3BZpAW7yUhAfh+7DzR4C4wxKQdxE6nr5BpCcX09HOo5gLLjm8gA+6hsxvPYM66Qmgc8kX3
SAjWpMmCEl2Jv5p3d9R4

/
show err
--METADATA NAME:PROJSHAR_INSERT_MULTIPLE_IDS TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT_MULTIPLE_IDS CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT_MULTIPLE_IDS TO PRIVUSER
/
prompt Creating procedure POPULATE_UACCESS

--METADATA NAME:POPULATE_UACCESS TYPE:PROCEDURE SET:POPULATE_UACCESS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE POPULATE_UACCESS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
740 35f
Daws6OOsaVd8VvFu16cF82/g86owg5CN18CGynTG/oqwUGJSxrcpuVJeLOP3tnvRfAQGM13+
qm2Nft0s3pjaHoTgFM4eSahLMug1iHasKt/1FYYEoutwmh+A/SP1jPEOIX2lnzXqNzJ9xph9
3TYs8OkBAomMlMsNu0KbTFOLG2iWyLQYUEJXfYST47ymEawe8B0XX8FrBk8c2n563bgprauT
oxcZysBQJBNA/dORZuWor/cMEb2DMN2/PbbdfykAzfXsFCVub5DKm6kyhR9/G7Fud1cTl8c1
s7n9utivWKTy/k9UO4Jk2l6MALRKGyfQ6mFMpeUhQhT3Emjgqo1Xr7j7KvB6c0K36naGX8VA
4sn4tJ8Go9epPd8tAbYUjWneI6E4xcfyZQfQhJX9gG3g95u474Anx56LJU6jfGh4i400Lx/D
XuZdB3AwI1klGu1NzcleR/pZlzIj7iqK+rgyG/RDybvU6PDbJjYqQ8wUN66Si8FvhzmYj9mo
UfEyciEpLQCoAVOOX5AtNYfnEFRi/QZNh9f0SoCSm/c/W08weQYQjlg2iqV5+3kVIzG5+M/T
w5kTtw8d2ZL9wNVemaWtv7Sl8HyQv31fLbeZyjLk5KLOzfrsIyO/g9/611hDhpctZppGeCRq
LjJTnMxzw3ukRUiylXKSjrXiv5nqRU+EcpCbRBANcTmaQwj+yPC9gyxPlwRGZLeqRWWLAPDn
MuitZGZQQdwjKnqW2liQtb8xif3zkjA2GjI6rL7B+Oks5Vw62Sof074n+gnYYjS/3m+8eBHt
ZSMNgVos0YLy7pW0CdddImxIqYIULglfPYf2wYXZxNCSBjpxpdIsqqZLXzwn

/
show err
--METADATA NAME:POPULATE_UACCESS TYPE:GRANT TABLE_NAME:POPULATE_UACCESS CHANGE:CREATE
GRANT EXECUTE ON POPULATE_UACCESS TO PRIVUSER
/
prompt Creating procedure UACCESS_MAINTAIN_FOR_USER

--METADATA NAME:UACCESS_MAINTAIN_FOR_USER TYPE:PROCEDURE SET:UACCESS_MAINTAIN CHANGE:CREATE
CREATE OR REPLACE PROCEDURE UACCESS_MAINTAIN_FOR_USER wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
b5 ce
dWuVfHddx+02AXzXo/CXAovtNYcwg1zwLZ5qfHSi2vjVoGw3WUyCPmElq3aThSsrc7UPoDcj
fbh2dsYSUSoJZWx8X/ejTraC/iDkTfw8Wmp0wMTBNlg3zWih6i9juR9vTTzGFnXxmcVSIP7+
5vAgd0kUe1DyB/SwbHCZ2u1lWybgRNo6crJOLzvW+QdxYWduYcZbmCl/mQ==

/
show err
--METADATA NAME:UACCESS_MAINTAIN_FOR_USER TYPE:GRANT TABLE_NAME:UACCESS_MAINTAIN_FOR_USER CHANGE:CREATE
GRANT EXECUTE ON UACCESS_MAINTAIN_FOR_USER TO PRIVUSER
/
prompt Creating procedure UPDATE_TASKACTV

--METADATA NAME:UPDATE_TASKACTV TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE UPDATE_TASKACTV wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
124 d6
Bzb7gQjPQWgx43xZP1XO8WojxfAwgzLQLsvhf+dgTMeep+ww1vSZ6C95X1nrLPAKGbVvCYKk
61mK4s/QW0ZTV+7TRAxwlwmCY9q+5EbvRruwI9SaThijHAPbgqMZ3fxvYWG/yGD52ZiR2e42
iXCnCuqmcbCG36R/oUiyEpVEgC0tZBO0RFMPxC3tJ3Y+0P+8M31xCrapFq4HKAu0gHI=

/
show err
--METADATA NAME:UPDATE_TASKACTV TYPE:GRANT TABLE_NAME:UPDATE_TASKACTV CHANGE:CREATE
GRANT EXECUTE ON UPDATE_TASKACTV TO PRIVUSER
/
prompt Creating procedure GETNEXTKEYS

--METADATA NAME:GETNEXTKEYS TYPE:PROCEDURE SET:GETNEXTKEYS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GETNEXTKEYS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
147 130
dUXXm5xmFrIQjaJZFgSiZIi337cwg1zQ7Qkdf3RGJrs+YVlAGqnxE457T4sG+wwHVgdpVfid
RJsv5yH5k7uwTGTo9MHJXwJMzvxk5JMHpG7oGiCFrJmTe7cAKN37JfJ49QBKtgX7Pfp7RHk/
tv6E4jgP8KfmDovFo6A91/AaCZvYZcu2lpMVPDxYblKZgAGAirpD/mLU7kZVmh6GrgcAIv92
7fiMae58P5xK99QZWcJWtTGGkNcGkroQdBTePjHGN2T0sYd8oOcvTYBZ6dhMFXOdlkl2T+HI
Qs/O4d+Yw/w=

/
show err
--METADATA NAME:GETNEXTKEYS TYPE:GRANT TABLE_NAME:GETNEXTKEYS CHANGE:CREATE
GRANT EXECUTE ON GETNEXTKEYS TO PRIVUSER
/
prompt Creating procedure BRE_ADD

--METADATA NAME:BRE_ADD TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BRE_ADD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
252 1c6
y8OPjaEwDSgDLfy5sptpVjyPtJEwg0zMmEhqfHSKJ6pEeNqpQCJQbDU56VGk+2GOyPXrWfnz
qs8+1XlodN/1gJv1ekwWrdK2qG7nFx4QVYuEpS9mUwNsttGXJSw2nOAfklsbiViVl9vIGzeW
DFiaPaYvU+KSD4vtc89VpPzFeuPQWREPQ6+6NWKbxYO8Q2D+ejEAGHv1FSLb2J0k5i00GNXF
Suoq6fB5K38Abx4KCdHbyZTh1PuQpppXmFDXFDcHSiXnP8KE3p739xqOTjIasQNQsoNiCR+r
VP/3yDER0RQDRvMu9BGf+ow3r5uQvBLsjFWmTIIzfcFIS3PcXgQbkU0KYXivMGqSreuNjvWR
dtbYwdcMXYF3HyHZJZYMjJb7lWbTI0z9naSHFBpNx7GCYFrAYOBQncmSFEai9DNLPZijQHVd
nRZw0gecLFoj9x0=

/
show err
--METADATA NAME:BRE_ADD TYPE:GRANT TABLE_NAME:BRE_ADD CHANGE:CREATE
GRANT EXECUTE ON BRE_ADD TO PRIVUSER
/
prompt Creating procedure BRE_CHECKCHANGE

--METADATA NAME:BRE_CHECKCHANGE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BRE_CHECKCHANGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1e3 15c
5gNj1fC6IuA68zLGU/oWlrijeCYwgzLILUjbyi+i6xXqfsGi8p7ErWOPcPDMipWjj/EK5LWq
90TczM+XzA49fDSItFej9QLz/1+YkLM/gzHIgHOK2Rx2NuHzzpRFisqndB9qXM+zxRQ7iWJu
ZtakqBRaUw7XssZ9hJfPlEpo0CFEnZp8+KAEKLbGgY82ayZkiGNyqvkoBOIdBMD+MK3eMq6j
kOlsr1klTX7/XSegzaTvVn9IKlEsdoy2i4BrIWeWgVcrP6ji9oUQNHM9EtVoFNRxdfzjCZ0z
TU4P7yqGZCidYkitokKZZ/BJ45PyFMiQIdIyojTwv3TAsLAsIs71vw==

/
show err
--METADATA NAME:BRE_CHECKCHANGE TYPE:GRANT TABLE_NAME:BRE_CHECKCHANGE CHANGE:CREATE
GRANT EXECUTE ON BRE_CHECKCHANGE TO PRIVUSER
/
prompt Creating procedure BRE_REMOVE

--METADATA NAME:BRE_REMOVE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BRE_REMOVE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
16d 128
4i+4ByxelsF9Pup8IBGNdYguMuYwg5DQ1ydqfC9GEjtP4Eqfoai+PF1wDF6AL95qJ41hSZ21
usPAkreHbXDzmIJqeB+UgA+JdY0KZZeNTJ2JKjBGNr/s9VtjOzEb1YgJ2Ll5faZGaBt6ch6O
YxSExVLoBkPjc7RIgpzI38yLWP/lPPQXu+xFqquf+JLLhAyJ+G7X4TTl25bibJHrKDSQztYj
uipQ79+PCP0H1LVCkNsEijOdIEyZcyUNgpqklm8ajQq+veAqAIz/dwD5MiIs5db60ChPYDa6
BA==

/
show err
--METADATA NAME:BRE_REMOVE TYPE:GRANT TABLE_NAME:BRE_REMOVE CHANGE:CREATE
GRANT EXECUTE ON BRE_REMOVE TO PRIVUSER
/
prompt Creating procedure BRE_KEEPALIVE

--METADATA NAME:BRE_KEEPALIVE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BRE_KEEPALIVE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
127 10f
V6NhjWj1oDkApAtrvEj/+SLjANQwg0xKf8vWfHTpmKde5PAr/L1ndDdUL5TTkdppG7mqbRtL
UMlLVh7B7STHfYVgG6BZ+BMR34y6TTDSUr9v/4z9dJ3dGphNsxbnzC0E//4X+92hQWKB/8FE
UmFgrhywjBYgLwlfYPXqePOrhRuAEaTjqowxg49LsVvimetd0mhOmCEmq4kplst9Jg0B3CWw
jJNMhQLxFe8R070l0pVz0GdHNwpx4Qrzzg7qb0JtkjNEpwnySQ==

/
show err
--METADATA NAME:BRE_KEEPALIVE TYPE:GRANT TABLE_NAME:BRE_KEEPALIVE CHANGE:CREATE
GRANT EXECUTE ON BRE_KEEPALIVE TO PRIVUSER
/
prompt Creating procedure BRE_PING

--METADATA NAME:BRE_PING TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BRE_PING wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
301 1ea
fAon7jfwgTafHbAo7i87UU/3WWYwgzLxVUjWfHQCvwxBFb9zk9oN66BtqMWz2wJayA7bszzV
GbViiy/y+3kW5sK2+G6W3MHYopR2FT04mt5e9GIpb3kOGYw2eTCz+3bAWWxEKDSUx9r7Du2F
kbgZe8gXSt0L1vFAh8vVzfpVEjuPi36YWhW/8NihPPqrXCyUC769Lh1jzMgaI96U5vsTwLYD
Vlf4Yfm5XKEwfvKuhAdVP/hCg04jtbSvRMkErVkN0XUUH/ZOPkwDYtm8BHTV9aVc3a0fMXDI
eTaEAzte2JhlGIj8gH2zrnoXT2UdRZ4Bt6COT2zk/uYraKChxH/x0eIem6Vuq5owOfo7DAuG
NyE8nygVrb1q12qx43scmVXdS0uL96e3xRs0aixK6Tnv15KIjq4HIArtwUYaebou+i9lz0Z1
itdB7tNmH87vLe95hllUGals3+43tWCR2RWGiFNsv3IPP/tvfd3T

/
show err
--METADATA NAME:BRE_PING TYPE:GRANT TABLE_NAME:BRE_PING CHANGE:CREATE
GRANT EXECUTE ON BRE_PING TO PRIVUSER
/
prompt Creating procedure COUNT_RSRC_LVLS

--METADATA NAME:COUNT_RSRC_LVLS TYPE:PROCEDURE SET:RSRC_TREE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE COUNT_RSRC_LVLS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
130 117
NrgrjB+zzX1nhq577tODFec5HOwwg1zQf8vWfHTp2see0Mpcdg7j+9MfVgI2MfuD9PiaUdQC
8oHgOsFzzhKLXVCWX48l007/FUgo9shRNkuo0bZpNnkAm6Th4gQ2JfFc11fKhFzIjg4qMpYN
hyOMo9Ad6RK2dH2bN4kz6URbnNzQqK7ct802YUL9zMdCKsloROkWlZB6yBHspYFauVdqYEI2
4mJk4c2Wvn/RlTCKuZp8gmz5SR6+CzTRSZp1QzSbs0E6y5SMIEgsOetZ6g==

/
show err
--METADATA NAME:COUNT_RSRC_LVLS TYPE:GRANT TABLE_NAME:COUNT_RSRC_LVLS CHANGE:CREATE
GRANT EXECUTE ON COUNT_RSRC_LVLS TO PRIVUSER
/
prompt Creating procedure GET_RSRC_ASSOC_TYPES

--METADATA NAME:GET_RSRC_ASSOC_TYPES TYPE:PROCEDURE SET:RSRC_TREE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GET_RSRC_ASSOC_TYPES wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
4f3 367
fMOiuhvW3G3D1YseK1R4AnZO0WMwgxDDTCCDfI5Vgp0GvGwxL/KYxFyQkdMdGfF1g9w+rvPW
WfDb5o02MrfOCJix9OsyD+MHHmq+LCLB7A3x89DHlTj6LmugGJ7oDV+eA0zHAAiv5mbRZ5HO
Kl51qXNQu/RQOZFIj0EmEZV3Kja2a/epfC8Tlr5Fry+oaot8m+T+OLiENJiinanqOLRqv8kK
qNnrrcmukiuJIAW9Ew60PJ3LHchtJCdmzNCKKMTR0gBq0hdF8HiBPPI/BoN091B7xlDjiR6U
N4WjhaJaIJ4AKmYhp8xBm18V13EF8rS4/5xmamGZJmfIWneqYS/yEzFH1L1qNdM+se3Ac8Pu
ypnSl9LHJw+01d0OdFGHuhzZEFv467655MT7z3ncmo+4GaTuOi1+8had6nmxy2PPBH0uBYpt
/FAD7dlEbQ/RHPVrAyhwAwZ9kvs6TJOgAQUrsOwJ5W/8TgjnmJJ8wEy+5T/6tRKWe2e/KsKD
SLH1pXEy0OP/doGnycATAtbw0nMm4iaLnCyld8OwizLTHEGfLpO/Amqs3dY1f/ndjGi4L96X
C698wqsGb/J3z8r0RCm18+Z81UHwecYBGyxABMbsM5e+OZNfOvUO43QN1Ue2cSjjkUGIm8Yz
A5k0aWUCVxf6yiqq3eVFH1C/QtbnADF5fbsblYUqNFBx9qiCUZkjLKHgQnSw+rm2T+nOqTrC
3Yuly30UsqToztyl1O+xDY4xqmAtC3UfLA04l91gdZRRgoDtpLUcYOAUA1/l18RLK+EsldV7
HDxZ7u/Fdm+08IAP2MlkkDqcYmCGzWlUza14Iw8/Q0lg9He/hY7t22Ba7UJOtlil6aI=

/
show err
--METADATA NAME:GET_RSRC_ASSOC_TYPES TYPE:GRANT TABLE_NAME:GET_RSRC_ASSOC_TYPES CHANGE:CREATE
GRANT EXECUTE ON GET_RSRC_ASSOC_TYPES TO PRIVUSER
/
prompt Creating package GUID

--METADATA NAME:GUID TYPE:PACKAGE SET:GUID CHANGE:CREATE
CREATE OR REPLACE PACKAGE GUID wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
2f4 185
xUjGLvqHYk0MwsmTyDTq/Qs7adIwgzv3r0jWfC+iEovVM2/II6gYwO6g1Jktnm0NtN5XOrW1
Ud8+IRTeCvIA/yOLQjxhVJ04DFAjjIJ2gqZ4k+EzEGfzbqZH58tcgHwhDnSMWa9LjKc2dPZF
qey5i5TdFSaNIN9GkkbxnJXEs2xNuBqGa4DaClpXcjKbhmtUfPqYg3ATTcIwtDDikIgwh9Ev
sdYbha8bvay7ROetlm60vVOdDPeZ6h6u4hnS9Wrc+NHU6ktNDe6fkKnoORDBcMaYBwVrI48n
I9QQp1+zLjtIeljUNUhqiNosD8jrT8XxVMVThRydYPYKwGwPKN8CXZr0l1M1ZpZIkxlLUWiq
lw8lnJ3UguBM7c+mEnqvHw==

/
show err
--METADATA NAME:GUID TYPE:GRANT TABLE_NAME:GUID CHANGE:CREATE
GRANT EXECUTE ON GUID TO PRIVUSER
/
prompt Creating package body GUID

--METADATA NAME:GUID TYPE:PACKAGE BODY SET:GUID CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY GUID wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
1b5c 9c6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/
show err
--METADATA NAME:GUID TYPE:GRANT TABLE_NAME:GUID CHANGE:CREATE
GRANT EXECUTE ON GUID TO PRIVUSER
/
prompt Creating package COPY_UTILS

--METADATA NAME:COPY_UTILS TYPE:PACKAGE SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE COPY_UTILS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
1fe 13c
GNF//8xVqDPmKl/ilQxmPk0hTzAwg2PImEhqfHTpmIMPry05ZQGBFAygCoPoNhiXCwa1tek7
Grh2W1oH3Dbi9dDbtvCk16lwhDQnbyRjgxqrDnKRlVus++m9llHvh+62BmWJR1+4ZX6ddCxr
+6Zg+llnQrnIBWMsrVT1WPMlD6kd27dYZflha0LN78dwkOtppgF+ReLrTJtTzb3mp4HYN5+Y
o52EtW00e1TtoBLwrMd3x4/M7RIXR17mb9filh4YKRs0/U6gc1kkp4/LV2dMXFwUeh7Hz21v
0r9Cx9cflVric877YeICTg==

/
show err
--METADATA NAME:COPY_UTILS TYPE:GRANT TABLE_NAME:COPY_UTILS CHANGE:CREATE
GRANT EXECUTE ON COPY_UTILS TO PRIVUSER
/
prompt Creating package body COPY_UTILS

--METADATA NAME:COPY_UTILS TYPE:PACKAGE BODY SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY COPY_UTILS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
6db 343
deozNxaGtC8naT1yrJuPB7gFYcUwg2PD2eITfC/N3zoYMfvTRUXNwn0rwHDKjuBeJFoDm9Bd
hto/phuhPdUqbQRyhm6CC9BJKyjYhFf0izkNdUg8fT/DgOhKpk4WewqlH7jHrWtGuyylh6T6
s6uHHoe4fWm6Sp0NpKU5rVmgVP/R54K3gVj6IGmmlQx3YJvnhBLmsKpmuN6v/FKutIHkMMrD
W/LcjWTIbM9iEObMpCgH430zjQfhxtY0CFe3jirfYGZNqr1WOOwxEbgmsx6BPVt/yzFZsuuO
8yFCtu6salG5VJdG0OeGkLGC04HygS2zK23yls6hPvI+Gu1N/6EyDFHCrTFb2W9Vxy9gZLzG
qzRNvALzQrByQuyT3SgwWxBgHJh1zn1Tt1VzyzEAx23qb0VKjOYwkKH2X+6y9+ooxXECLRqi
hEaSGjxyJvBW2SqhbCT7RrQqIVy8fmG6Ydw1+LiftRL12UOHyX06YLxFVtXMviCjTRvgSEGc
jVNCPDBYilyFrzPXbfqy7ROnqQEj/vxg2CoRONZ4W4wRZs5uF56NZlG8+hh8J/W0cW2Ucrqj
PtFQBN+5Y8bI/EMO/m4WoCouHoNrMd7bfBAArv2ay/9Lp4Y/kUMwDSZJ7OdzsApSDR9ySfv3
rYk10u4q+inZ/AVGiQ/m2s5sBo3RR0VJY9LM0tjO0IXNIvazRkc7yGYllYurc2GM4yqKjUlZ
SwmvmlPnwIxtfvkWPOVHigOkPunGyKWDzfEp+oK2TA3PIzxyEUpHbhi/s5gnJVpz6HSoMZ+R
pETJegWGzjxFSWGkYW3u+Z3k+3kJOy8=

/
show err
--METADATA NAME:COPY_UTILS TYPE:GRANT TABLE_NAME:COPY_UTILS CHANGE:CREATE
GRANT EXECUTE ON COPY_UTILS TO PRIVUSER
/
prompt Creating package TASK_COPY_PKG

--METADATA NAME:TASK_COPY_PKG TYPE:PACKAGE SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE TASK_COPY_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
67c 2a1
Z5lBRIX5q8KglzNnHQzkVcUsnD4wgw3Dr0iGyi9V1fkYregJrgBIoFt8tpzwmVaPGiIItaqz
+xPwLZCgTN5i6WGLrxP+yRsLQhKLpOaP+Xa6C8YRckxqEB0vYNqVEkOEj1GAaRzoKMfhADS9
9Q6g278v7+djvv2MJfva9cbmyi4KGmrfVWOcUvEvqdYpARRWxb2CPcc5Z4YyRN22d/U69iZj
FN60Ha1nJB5ZbcC45zSy/FEVdS5q+3VsingBAQOrPHwjilzOjlazPnUKDVeXb+48WpEfuYPq
uYfoTr7i5gJctIfwBYxSBAYC/l9YqGeNeKggvNY2juLDbq5uzdlzteW52RhoxfFhzGG6xzm4
nd3Q7Y6zvyoDxlGVBKF0dmHr905IidzMhsMfF03mMwHi1UHgJciiZuIoP2RbS4iywobWXkVt
KSSQfmP+ZQxOY8D59vl3nV32HNed/yavlBOzEEG26Wwv1NKFgUbjTc+OaAtkIdQ8qChdJ0IG
Bavq0wCk7LEo1xeHVsRjTnQCHEiK/RgjJZCbwYSjJ07YsQVKQaC9uzgBivLlRPHiPX0ahiER
lyAhVnukYr8ct2to/rq6Pi/CjSNyJGNModxbsBe5We3l1C1Gic+aMcSQ49bGfQiuKajk5DIG
7bBtTUMIxltoZxj0

/
show err
--METADATA NAME:TASK_COPY_PKG TYPE:GRANT TABLE_NAME:TASK_COPY_PKG CHANGE:CREATE
GRANT EXECUTE ON TASK_COPY_PKG TO PRIVUSER
/
prompt Creating package body TASK_COPY_PKG

--METADATA NAME:TASK_COPY_PKG TYPE:PACKAGE BODY SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY TASK_COPY_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
f65f 2dac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/
show err
--METADATA NAME:TASK_COPY_PKG TYPE:GRANT TABLE_NAME:TASK_COPY_PKG CHANGE:CREATE
GRANT EXECUTE ON TASK_COPY_PKG TO PRIVUSER
/
prompt Creating package PROJECT_COPY_PKG

--METADATA NAME:PROJECT_COPY_PKG TYPE:PACKAGE SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE PROJECT_COPY_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
3f4 1e6
30l/ZsL8YY4JjApfNXZ8CkCAOsswg40JmMBqyi9Z/apEY3q3UvdlQY563GXzOcBbYVwItarz
L8LkSrae9IafIB/eAJwAu6lC9Q/KhPH/KPr+VazrrI1evcVmS8AZXSUDBKBrXDHhObKgcZqm
twQlh2mGTu/elfzCUtWmmm+KrwlnqNdfF33ljIQ7n3ZDQIb4CzToeiPiRsc5U9fsYtAbS6f9
rMaR0C8lShOjvgRBg/2IuvzcX8Fv7SCQs0iS4IPcZgOh/fA6Ai5nGpA70qoD8zShbEQCqpyS
e+JW1tpi7uSWTKZkm7jzVnd3ePlNm5xpWbluzOqLwlkbPkkeDt0mT2qYq9BqjzgQ2xEycOa6
SoQl32dbVKNEFRU5N9+jqIVu06cPy1yCe8XCDRDT4odiiiB72RP3C/cXOdF0fLGHJ5NEMXe4
crE2/SCf3x40v7tgvlX0jr3Tr/52m9By7LtoWwo8liTZyUMp

/
show err
--METADATA NAME:PROJECT_COPY_PKG TYPE:GRANT TABLE_NAME:PROJECT_COPY_PKG CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_PKG TO PRIVUSER
/
prompt Creating package body PROJECT_COPY_PKG

--METADATA NAME:PROJECT_COPY_PKG TYPE:PACKAGE BODY SET:CPDP_ORACLE_API CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY PROJECT_COPY_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
1708d 4ba9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/
show err
--METADATA NAME:PROJECT_COPY_PKG TYPE:GRANT TABLE_NAME:PROJECT_COPY_PKG CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_PKG TO PRIVUSER
/
prompt Creating procedure MULTI_PROJECT_COPY

--METADATA NAME:MULTI_PROJECT_COPY TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE OR REPLACE PROCEDURE MULTI_PROJECT_COPY wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
4c7 213
o7C7sJbQdcA8niQcRTQmKhMG3nkwgzu3cq4VfI7GAE7q0tRa51vQ0ygLEl8n3hNhHQAqZhHJ
6LoEs86a+EUYdCHc49ohEkJzz/jX+KiN48rclMjel3QNCfTV41/wRjTNNtHCXyeEaHiZXCG9
PUKdhEr44FDU/4CDJQTvQdyADkpvUkqK4yPVsBL3nl+QAkeAZiqwkiYC6HsxvZC5oUpEjBWc
B2n53r0e38st1QRlnzRNOTsmj4eBnaKUWiso9LdzNS2A5vBR8RpAZQDdE9OJaw4HkPMUiQv/
F2jePrDoQgGWJmv3mUVDRTDCQit5RRCbKpztmlhD5YO0xOkBA2wJ8H9+7rltm1XRZf53n4qj
48LPFpvYpSjNkjFgXArllxicrn6xLd9I7cXHuurbt9dhd9gUH5wuNzbLnlVx9dVktzf4vV2a
j3N2QzkfxQJnM/QDYS1kv76/XGSju9pR8HtnQQrGYqwMAudoosqypx3uOjZX88nh8rZ6QgBh
xRqrpRzQBxcs9RfKaQ==

/
show err
--METADATA NAME:MULTI_PROJECT_COPY TYPE:GRANT TABLE_NAME:MULTI_PROJECT_COPY CHANGE:CREATE
GRANT EXECUTE ON MULTI_PROJECT_COPY TO PRIVUSER
/
prompt Creating procedure PROJECT_COPY

--METADATA NAME:PROJECT_COPY TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJECT_COPY wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
33d 134
hL7QRV/cVBFTu0RsN+PKNrsU9dswg2PxmNMVyi/pO06UifpfjXnFHP2VqN2l4wuVtbUCL5vF
2/Njum//Gb6/DcyOdXipoMy/DtFpY08uCl6IV4RO9z8UcP+ykjN8S9F649dG/LuhhMpoQycV
QBlLvsOmoPsfG1bAYzQKsXzvYBJV8519UNbTcWJgwL6F4/l0tG0a8uOrbkT2vvFY/iT/qW84
LpKyCoS03zbicWB9BCBCV+KhHsNaSn4FJZRALDxrpeAuNFCHTuR3SpONg7qeY1uYZEO9mFxM
mqmRcylE2JGQ6g==

/
show err
--METADATA NAME:PROJECT_COPY TYPE:GRANT TABLE_NAME:PROJECT_COPY CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY TO PRIVUSER
/
prompt Creating procedure TIME_APPROVAL_WBS

--METADATA NAME:TIME_APPROVAL_WBS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE TIME_APPROVAL_WBS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
267 1ad
SxkdIW/32AoOHxH22MUSkgYyX9swg1z3LsBqynQCmIuOg2xY+tLhHJZLYkkhBH/KBsmVcyDM
OKsT2KZrT667Omfv3D7KS5N89rsdAA3XHi+Ubq+w46gTvXGjOXTqpfMLIV0i4O+t1A9I4J4a
90LJQrne+60M9g7bgN690QhhRE97X7+kj+HygCqP11dEfGvpYHUdYsjkauyFSxnM4/2J+R10
oBMON/y629w3UsKU2a+gxHosgbHoKy8swHGJWQNXwqVaYVLATnnpCq9c27deXMnz0hdeA+ax
MsCE9lGFODvFXkyIfzQahWmpg7CPHqlKTpggkWLOCu7aaS5/4lZL+wnaNLRJ+1rDoOi+dWY8
NDgZuTMHs+l7u50MwHOhoCQznfx+qjDktYw7YypyK5oapdJ7THtpfei5HiiPSxol

/
show err
--METADATA NAME:TIME_APPROVAL_WBS TYPE:GRANT TABLE_NAME:TIME_APPROVAL_WBS CHANGE:CREATE
GRANT EXECUTE ON TIME_APPROVAL_WBS TO PRIVUSER
/
prompt Creating procedure PV_WBS_ROOT_PROC_CAND

--METADATA NAME:PV_WBS_ROOT_PROC_CAND TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PV_WBS_ROOT_PROC_CAND wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2ef 1ea
FmoyqykZ4jVEZ12L6CEgvKMJ/Q8wgxAJmEhqfHSK2GSPpxp8GBoL8I7IeXtca+OsHJ+CKbW1
UYlmbDWznwNKxoYIER4R2z57NpgaMqX68wKRiC6MIbe0g32zbCo39MH7TFvfAxyay4SjGjkY
a6zaqO2myWU75gCdKTyND4y9fBbvVWw+tqWJs/uul13/6DqfRhAbxOGpgPALptWk7MjlnMtN
z445CsxYVUP0ROykkJOJIlgPqYEdQkODEH7ajdMgsrYovXV6I2SFkUqbfkweikSdYKA3UhEJ
OXRjoTlYyRhoHATFKqaHFHteg0d3mVK6cJHJtCK74p+tdFLErbqwbyJaW63Ph7Jm9Ml7JQza
vf1kTwb8E/Z3n1GAIW08SmMAJw2mJ6HPiNEsh/0WDegq16NBBBlx378tJOveO7XbxsUn0cSq
B3MATcbWLCMI763NCJeSzR8CzWIC4kHtJs0nuXrCH621sCB3gph4

/
show err
--METADATA NAME:PV_WBS_ROOT_PROC_CAND TYPE:GRANT TABLE_NAME:PV_WBS_ROOT_PROC_CAND CHANGE:CREATE
GRANT EXECUTE ON PV_WBS_ROOT_PROC_CAND TO PRIVUSER
/
prompt Creating procedure PV_WBS_ROOT_NODES

--METADATA NAME:PV_WBS_ROOT_NODES TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PV_WBS_ROOT_NODES wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
ab6 483
8dtnQC/ykq0e3XDfE4gmycyKjKswgw0ruiCDfI4ZHs6UwWJLf3eLOCgBWZ6vUFmv/35JoK7z
4WF/XFAB9esa+c6k2p8GuPY93lpjM76qwc9hoVeZ+hZDNvFWT7Lp/4i3rQHvZqPNFJRGwbPn
EXuk0xkCopPb98jdCb2T3Woeqb+6jbS/Q1AuV/dCb9ujo9R8FSZ1U+gi9aM3EftGPh9fhKuP
e9OpmqzbFIl1vpy4M71tzFzSw+btoojlTlJ2WVAwRzF3l8op4G58FOaPqhZ5syhVs8CfLi/H
q9JW2/tUoE2yfYX643shIRMAO/yJ/0pgGTsXDUr2pLCfpKgWocA3Delfxdo2DOtX3xlJgRs2
AdOFst9xZwWffS70vECKmMgQ0tgiOeR/XT2AY68Essq81ho4MEX9Esm8WG4pDN29jUI+e8nP
Ra6QIoOxRr2zhF7qTug1ExjFBzpWTNS90GV6pkxVtkCyDDGqqNA9fwVGiVgNCGpzOFkKzI2r
Lsl430/TopNKB3Q9nLyUOVJHyYDOOhREA0l0S24f93dYmzG5JNbUn54/u1a3ctO+4IOz9CHm
NHBlsnskquaWrWWuT3WqHAoiwKiNpmrjOeTf0E0UthXwUzS1KFxYyBTM/hAyMcSaD/WSMCMH
kdPMoE0PjQo3/3e/ArzVO5txstGrr7PUDFTx1Ps8SPrHD34fCkOELfxCe128vCOPjpWXsPI3
X9Q9byLPRpnIsaKx3g/RjV+OlWGpBjgDkyC8FSl3e4J76G4GGHDQjH/R5t+QYJumrJv4vKOK
cANM4o/GauXOHb8FzRC9cNhP1G63L2bluWN1LaK3Z41xMrPLd4k7IvBvDKcKraDZaUCHI0Wm
FG9d467tP8/SRRw/T9AJFVaGoJft5YGmu+C8k+KcTlWevNh4TtfgAJ3asgBdbyMyVeqkuKrt
j/t0xwGs/twA7iWYQqnsxwfUXVvJpaWjhMB16mSaFQG1DrX5MfvOuTZZLvAZvu8RRa0T1j52
baAkAuwQ/2dgaiaFCLBU8Zcc+TjP8oOPCM2fW45JCLY/ZL+ayj48neIOWCX1a4wcC8C28aIG
ArPsJkF/Rv8C3mc9CaL53CqKRzUliMUYj4MSd2YIrRturn/zpIEPc0Se2+0p

/
show err
--METADATA NAME:PV_WBS_ROOT_NODES TYPE:GRANT TABLE_NAME:PV_WBS_ROOT_NODES CHANGE:CREATE
GRANT EXECUTE ON PV_WBS_ROOT_NODES TO PRIVUSER
/
prompt Creating procedure WBS_TREE_HAS_RSRC_ASSGN

--METADATA NAME:WBS_TREE_HAS_RSRC_ASSGN TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE WBS_TREE_HAS_RSRC_ASSGN wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
647 284
oaNs2Xk2sgpZHAn7QwsGIXOMP0owg+3Dr0rrfI5dimQwEoNvMvPZ9yWNccENvfLNigPrVRMo
aS9bRdMBtU8fxqETIWup24t3Iq6L11+APoUWWfLmMFSju+ezsCUjwho0oJ87laLd3V7DpVY3
WdbReAwaiHSG4V5bV6yEwcRlW15FDF9faLQyZ0hsJsMlmCbIp7PlFPbnw+xD9BcCepdWVEfM
rU2UsW7VZf3JZSz2LyQoPsDnAhR3/4DHbTzJ8Pd7N0b6diNtPMlgWxenRME6cXwRCqDWTU9b
DHEXo/Xk7Q/dBaYB3goLeplTvkScUUpBjMkB8s0bZLB2T4I3AEFbHVbiI536JmFQsRwolhFk
ynW65E8e0If9Bapr8Kgx/ARx55IYA3qyOzs5B8/XHjefB7DBLE+fyigHIA/+mr/4T1vOm9I0
tc8AH+0GCNrE18gXbCk31wrrn0LmXIFFpGdIWfM+P7++nE6k3M5WhkqJeJDdtRY9/5CdbuWz
ZnHTstf//2NfHwaaxX8JGEhiI7PwzwBJhJNHowUDn+vYXHuQ1hHehG1Rpyi/EMcQ6Re+IaoT
mlwkOi8slG9KA5TuuSEE6Gz9he6KxzK2tlfwJRnBWqA40a80Tuqdpv1Px4Y=

/
show err
--METADATA NAME:WBS_TREE_HAS_RSRC_ASSGN TYPE:GRANT TABLE_NAME:WBS_TREE_HAS_RSRC_ASSGN CHANGE:CREATE
GRANT EXECUTE ON WBS_TREE_HAS_RSRC_ASSGN TO PRIVUSER
/
prompt Creating procedure WBS_TREE_HAS_ROLE_ASSGN

--METADATA NAME:WBS_TREE_HAS_ROLE_ASSGN TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE WBS_TREE_HAS_ROLE_ASSGN wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
629 26c
CYci26wtEezx6/zGVHbF9mL3EWUwg+2JfyAFfC8Cgh7qcbC0Al4UpIxTpi6QYpQhJnY+sP2c
6Ok3PIhu5LVuFqOnjr6fQCu3Mj9XvP4INWyI9JPp5yiZHqSoknFUrmBrHzzi9WWhcF0+9kL3
NWs16h5EJX5xb2+QjITBeOY3Jmje7oPirLjvWousIq62OJNi1cJAZ4sCl3r4hsw4r1HmKQ4I
BYpx8ZOxPLzfZj8cwJE2Y8p3/8YRThCFYGb1OYi7wH1io7oEpMCTYQrDl+zwd8tROiGTj+VQ
oZYFzXbi63zFp1tlx1NF+5yMSkKMD97FzRsssFn/WEva+SxHA3/CFIZNUiRI+KAgpsNvte4p
Bxr4ULtL1PHgMQmZXyR8xtEtYbZ0zvGuWyOSc+fgxPiBx/jBUvg01iyulgW7nN5lFv0eIDOE
QVwamhxFit+XtpdFl82miX8BaKXEDACyn47N/VMASU8jGnIVMZgetcn8Efv/gWi+0IYqMKrz
SsNrD0D7wu9P+voERpMTvzxBIfZM3CjBAvyiSb8PQC1AP0BnRSCBu0W33qyaFKdKNxvuFSEE
h/IzS0UTc8VAu9Og/p70PDShFymV1UD5SJM=

/
show err
--METADATA NAME:WBS_TREE_HAS_ROLE_ASSGN TYPE:GRANT TABLE_NAME:WBS_TREE_HAS_ROLE_ASSGN CHANGE:CREATE
GRANT EXECUTE ON WBS_TREE_HAS_ROLE_ASSGN TO PRIVUSER
/
prompt Creating procedure DB_TO_IANA_CHARSET

--METADATA NAME:DB_TO_IANA_CHARSET TYPE:PROCEDURE SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE DB_TO_IANA_CHARSET wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
38e 1f6
HxQ4akqYMU9mNDbG/OOlGdKcadAwgxDxr0gVfHRAv7leznw+ysz0wmHVhBOJbx03JQ5XRN6c
hxvf0QU4WXEwzmwLAi55hfpKtbUDCwFjkUCGCahf6/LZ8qWs6jFf1ebNMnCB/axWKti+wimm
RY9Sm6Y8Mg1SJ95Jy5jvlpUmFl9BfMZHwJvTLsWeYnJ0t66JcRWSYYUmo1KVnE3M83UVyUDJ
3U6keuEDZh5dWJRrye9y00k58qMyJyfQvfGh07KTH0EOKCNAny9Teoqv3V/UxGZPrwjnw+i1
Lz9QmUfvpnywpzkMg+NmBHF5uLTtnc92IqTkSx/57k+cJ89jQRSKB71QGj/NxD8VdtxFwYm9
7p+cXU+OzamtKODsmcAdfXnEVeorJdwwQSnK3JUh4MpcA5sDxDh3v3hav2T3ty41ei4fdG5I
unl4TuRIuDHYx2RQJ4eFI9K4MGPap1idaYGmtI5u8pW05JP9Qht2Vc8dnPy0eQ==

/
show err
--METADATA NAME:DB_TO_IANA_CHARSET TYPE:GRANT TABLE_NAME:DB_TO_IANA_CHARSET CHANGE:CREATE
GRANT EXECUTE ON DB_TO_IANA_CHARSET TO PRIVUSER
/
prompt Creating package BLOB_INTERFACE

--METADATA NAME:BLOB_INTERFACE TYPE:PACKAGE SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PACKAGE BLOB_INTERFACE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
55e 21f
kcc2vZd6GuankIZdjwR58VMpaXQwgzuJ+kgVfC9AEnlPFXhn/ESiCml3attYBJnGSjRGJW2a
tWInE0uRa/DF2G7UmuSGMQkdVR2E8ZmNEtFi/NMWvKlCqBo8GODuIdNAPICsRx7hVi9DVrO4
MGwqXBVcJQxNyLihq1D1WyOUNIDcj2Jd4VswU03++RoBGyk2bh/3ieKXzE9iCkr0uW5oEmqd
CCe8ClQOLSI5KhESIOuoczmi8vhmHPCNOPowyR8Fs8JC9A+nR6GdMO9FhnL2rkmL+qiiz7nb
IVBwsOqojaqg/Djt7GhWXKd5Q6r2w4mCl94YKH1c5/MiK10fOx6tC07+gazPzzliqOC/WKb6
cXGIZQLLmWO+XJJX9G8YrKXU/MwjvpOw+wv/p5NPq68lorXwDUOKrIRW18O1ogtF7ZMNE7rR
NSzrIAJr3HGDRjeXyB5+hu1F18t1UozCinlelhfE+vUASc6h22Z0DX5p/eKR+NFjNqxf0Wzn
1vRd1OrcVEEszSqxqPTCtCJzppSTV6Y=

/
show err
--METADATA NAME:BLOB_INTERFACE TYPE:GRANT TABLE_NAME:BLOB_INTERFACE CHANGE:CREATE
GRANT EXECUTE ON BLOB_INTERFACE TO PRIVUSER
/
prompt Creating package body BLOB_INTERFACE

--METADATA NAME:BLOB_INTERFACE TYPE:PACKAGE BODY SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY BLOB_INTERFACE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
21bc a0b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/
show err
--METADATA NAME:BLOB_INTERFACE TYPE:GRANT TABLE_NAME:BLOB_INTERFACE CHANGE:CREATE
GRANT EXECUTE ON BLOB_INTERFACE TO PRIVUSER
/
prompt Creating procedure GS_SAVE_BLOB

--METADATA NAME:GS_SAVE_BLOB TYPE:PROCEDURE SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GS_SAVE_BLOB wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
17a 117
j3Ag116OWgTsq1kNdGahKiz910UwgzLQ7cvWyo4C2k6Ofjxd6NZetrCZcTs+rO7GSjS1uo7l
YYPoX5ru3TobF2wmfeP+IkJuPr15RNqunh2br7gHKI+3oHtKG4h2Jt2IkDRr9sDTaRGSvVTc
6BKjJ/kK8dY1lMkGFoV5GjoOCcRMwT524q2e3mDXeXSAV5L5RMSuJ0BBvfxbaleW5t58N3EH
8dEg+pXzM0hL6zeQpl0X+ZABetjLS7lAxUC5o69hiGGQMtmIiD1BQfRrOG8=

/
show err
--METADATA NAME:GS_SAVE_BLOB TYPE:GRANT TABLE_NAME:GS_SAVE_BLOB CHANGE:CREATE
GRANT EXECUTE ON GS_SAVE_BLOB TO PRIVUSER
/
prompt Creating procedure GS_GET_BLOB

--METADATA NAME:GS_GET_BLOB TYPE:PROCEDURE SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GS_GET_BLOB wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
180 117
1UKDHTgxyg+XUrUivtWXOMPisL8wgzLQ2Z7WfC/pmP/qR/+ehB/inuIbUncOYPpq5ng6tZ1N
0DlmoJNBDPHHb9rVSKwBfXGKtICt/wlonEB6r3Z6VCOoViccapFRa/Q1/VT65UF+DWJBXYWd
QAHjwWKcKAZx9QOEthv63/f8rMMsRy+QP05EBS5SYwhpmN36MltZLI2sbsho3u+mM01N8BcF
8QaA/HqCf2RqVucDOWiHOr/cEOQrcOhK6aXNA90a8KEN2DVL3vwFWxEuCxc=

/
show err
--METADATA NAME:GS_GET_BLOB TYPE:GRANT TABLE_NAME:GS_GET_BLOB CHANGE:CREATE
GRANT EXECUTE ON GS_GET_BLOB TO PRIVUSER
/
prompt Creating procedure GS_GET_BLOB_NEXT

--METADATA NAME:GS_GET_BLOB_NEXT TYPE:PROCEDURE SET:I18N_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GS_GET_BLOB_NEXT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
9f ba
yoShzxh3D7iQc/QhmFa+MAsL5FIwg1zwf8sVfHSmWHOe0MMYBFTarfS9jaNJwG4Vp7W1URZQ
N4HcRdXsHcboXyYz2zxz7BAfP/1xDBTvR9dpKUNLfYC7oMtmeU7YJFM9IY/cq0Ea/r1NrMGg
58pKj2bUkg7dxJ3Gv+7/wtr261/d08HZ+7c3xdQ=

/
show err
--METADATA NAME:GS_GET_BLOB_NEXT TYPE:GRANT TABLE_NAME:GS_GET_BLOB_NEXT CHANGE:CREATE
GRANT EXECUTE ON GS_GET_BLOB_NEXT TO PRIVUSER
/
prompt Creating package REFRDEL_BYPASS

--METADATA NAME:REFRDEL_BYPASS TYPE:PACKAGE SET:REFRESH_UTILS CHANGE:CREATE
CREATE OR REPLACE PACKAGE REFRDEL_BYPASS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
47 75
PnmxoZ5qQMyb3dmiqJosjzMeFQUwg5m49TOf9b9c58AymcBSgfS/GHS4dMuLwHSLCWm40Af0
OTY6Er57B2cBlOTmEJBx1o7YfpR02L5xc3HYiKYNWNNR

/
show err
--METADATA NAME:REFRDEL_BYPASS TYPE:GRANT TABLE_NAME:REFRDEL_BYPASS CHANGE:CREATE
GRANT EXECUTE ON REFRDEL_BYPASS TO PRIVUSER
/
prompt Creating package body REFRDEL_BYPASS

/* ERROR:  No source found for PACKAGE BODY: REFRDEL_BYPASS Set: REFRESH_UTILS*/
prompt Creating procedure SET_REFRDEL_PROJECT_BYPASS

--METADATA NAME:SET_REFRDEL_PROJECT_BYPASS TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SET_REFRDEL_PROJECT_BYPASS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
7a 9a
fSxr6XjIHmmDGRoRnTw6cTUiuHUwg5nnm7+fMr2ywFznn7L0KMAymcBSgfQo55v+wDLL9L8Y
dLh0y4sl5+fH0r0yXKXSXqWZgTLAsiVdwHSLwMAy/tKGrN43Fj3HxjhArI1id44u9tHqJB/2
OaYhgKgP

/
show err
--METADATA NAME:SET_REFRDEL_PROJECT_BYPASS TYPE:GRANT TABLE_NAME:SET_REFRDEL_PROJECT_BYPASS CHANGE:CREATE
GRANT EXECUTE ON SET_REFRDEL_PROJECT_BYPASS TO PRIVUSER
/
prompt Creating package SAFETY_DATE_PKG

--METADATA NAME:SAFETY_DATE_PKG TYPE:PACKAGE SET:SAFETY_DATE_PKG CHANGE:CREATE
CREATE OR REPLACE PACKAGE SAFETY_DATE_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
d9 d2
fvKZ9UvWjxPQ1Y5iQSQWoZyXlTcwg0zw154dqHRGEjM+wH5rsOaW1QAa7Fy0LGxga0matWIn
eR8aLzmbAcnTs1Z959P/FGQnzE3UlT5Zng50jiJRW4Uhgmy1v3pNzug4DUvBzaF06x25q2eB
9HZ0MUc2ShpKrv9SaOanGc959MlWU5/SO+SvYr7LmcIIhcRtK6C6ECMdWSRX2w==

/
show err
--METADATA NAME:SAFETY_DATE_PKG TYPE:GRANT TABLE_NAME:SAFETY_DATE_PKG CHANGE:CREATE
GRANT EXECUTE ON SAFETY_DATE_PKG TO PRIVUSER
/
prompt Creating package body SAFETY_DATE_PKG

--METADATA NAME:SAFETY_DATE_PKG TYPE:PACKAGE BODY SET:SAFETY_DATE_PKG CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY SAFETY_DATE_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
50f 302
0ntuIDo6MfkmvtNIdMPEMVgcmfcwg/DDedDsZy+5F6qVId7hIaMA9uLq1yrucKLANDIffTr0
UAsAoaK2n2TwtbyZJ0wPkhUHAb8wn4tYWBfjWR6z9S8c5hLLd27genJ+gtRWI/V7G82mohSg
UNznrNZS6Gdn0HdeddtQfkWbQDbo6LHsrNuqZ8J4knfe8Cah2FihQEDSmjn7S9Pm4LHGPMai
7BxQUtbrroYSDseDpiOSLrW5nyEEBLdvJdG5jgmN9wwB9a4lyg4enZDSyloAc6YUV2xaFzFK
OvuRBKUcQO++zzSkdI+ZGltxerf2fTE5hUxLbQV6gGGYW09Q8qvLvNBh1ZD2jgCg4KVVZx8T
2IVE676F9vf0wuBMLgrlP8zSxLpU0QeMUlxKrbEhHexZICKyuzk5BEtNeJQ05DBJ/M/XThfM
SDyrUzV2rIMY9BWEMZeborGX6xRR3Y+ObPY/TRj8Hx26e+SEGtJHr72+9mcNmUnzXEuOaeas
C1rPwnwYVWlstTve8haCZtJllpOmkj0D5v3uzQDSItBAnARX5cTMBcsirQduQ7GJCOOtwUI7
cZvYG8DolFBXui0X+1y+POoTnMBVGJGater/V5yQB08MK4IWFMNLfiBHl+Hyyx6xPfxkl86u
f+S6nifJfcyKcZ11hzhrb/x96GIuwXyujoa0snbFbOCDMbkX4ZKVV581t7aNqnKt+N1ORLYF
nxUh3mQxUcnPWPQBToPYnt40dsGhsPT4ix9imCT0

/
show err
--METADATA NAME:SAFETY_DATE_PKG TYPE:GRANT TABLE_NAME:SAFETY_DATE_PKG CHANGE:CREATE
GRANT EXECUTE ON SAFETY_DATE_PKG TO PRIVUSER
/
prompt Creating procedure GET_SAFETY_DATE

--METADATA NAME:GET_SAFETY_DATE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GET_SAFETY_DATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
c4 c2
hwE1SWiD4E7JmIDyAA8bIL8Staowg0zwLcvWfHSikwjqaOfT/FCN+i94O56owNMU6OS1D2fe
XGOB9TzrVU5FX+Dxntjbds4bUtlAjGkdDzRUCdvV9cOdch7MVEJ79AxOypLZi3CuYcJKvzzV
oy9bq9sidvuVMDOuEjpOjD6BpLxFrno8BUHbWLyD+w3sfzY=

/
show err
--METADATA NAME:GET_SAFETY_DATE TYPE:GRANT TABLE_NAME:GET_SAFETY_DATE CHANGE:CREATE
GRANT EXECUTE ON GET_SAFETY_DATE TO PRIVUSER
/
prompt Creating procedure POPULATE_DELAYED_LOADING

--METADATA NAME:POPULATE_DELAYED_LOADING TYPE:PROCEDURE SET:DL_PROC CHANGE:CREATE
CREATE OR REPLACE PROCEDURE POPULATE_DELAYED_LOADING wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
19bc 62d
H1exAH5+XMc40bR+M9KuYLVkPaEwg+1ULscFVi+5KvmUaHZyTVhFoRPECM6pbG59Ym/FypgA
KSX1g1jcZQuuIHMIVenCdMIi44wUB1RWmKWmcj9nxemFUVll8RghhsMDeuBuPwvM/0TwBl2f
9Z9BxejDVvF6SlpuyBS6YnV0WsVY/7GJtvfe6lMJxGBT6GU0jJsQfGZDD57NXadDbVTVdvZk
NWZhGoixkVmtLK5gwzehp2CmFpdj8aiT56+ILslhdhQuwC1pYTCQPhvzEjdS36NLBVcm0KqC
SQyXlNrsDiYdF1eFa++HRQwTH5k+PGIUzDHm3kJIHjaxu9YpNiqwhgMD3Ne1GTonh0LQQkLN
Ozr66sd7Oyb82qcEbZIr9liU/YCPXa3rX1ZjVPfj9owtvgtnoW2fx+D3L64VddS9bthALGLF
607Wh2dp4Sy3CQ+vw2thB+XDGDoqXE/0YG9ttZSl08MM6+HM5dFLCmcaCiDsolCD0I7V8efS
5/8uKAQNOxq0EzarP7RHng31+2EGt9FnOiXnUt/oZ9Y6+1lYHS/sZKZ8K8Xv3or0fJ/z1Jbw
uANpAh0wQQjUAIbXoRd6gowH4A0YKj+CadCcTFKyHamGJR0CltCmCUBdSqasq+37Gn8/DmP9
JGclHySeje7PoHYgZ6wx5/44ZfE3Oo3foB0Siw5pKriSn3AOVzZ8bkd2qcP7LXCDpcPaIus6
wue6z0694jrSjKTdKs3fuSBDCcb0nE99eBExib9zdk17hQaY/yvbdqEcVHRSWlJ8NQml5Vxu
eiQ6fRJwjdx3N+Xw5aT1Vu+DXv+YmHbkfM/uMDIyJ+4wjkfZZUUAp4wVoYmihAf3yn3uOGtS
Fo7dVaFFCNi230iQULlQV2coTvxnQVwtdBiimqG0ts30ovhmiOyBnCwHnVRMPxHuwPAtIUYu
evTC1CXuVvIjWrrldF4Q9fdE+P63kzoKB2fLescAZ7Ku+XofE1uv0KUC4buWa0kVpb4vrnC8
kHKvJNqh+LPaTapFSGv++TvbZo/5rZUvxCNxf7p1jQwzU91qo51AVj3KPgdbEzafGwcNs88+
ZdgH/nxHBbP53r0J1FdCFKqf/rqbhghyar/OnWyY+FW5sYYdiLedqvRvrbzVMa7qt1ja07xx
r1ogsFut44JYiX3xTa1J7qyuTrgLKTAwvkJMHLlIuImzIk/HgfaNni1tiYXRCTT2jusPUt3a
jhGN645oAdeb6jW0fE8ktHvmVkkvypcI2rZvhVlxifQliSND/qWNh/5s+JIlsbFzT+cQXkGH
/nuix9QdaqPU6x56jvOCO4nyp31ob9x7Ze4C9rKsQPtf7TVKCY4VBzJ1ivbYoCak147rhMkq
ESqy7GQ/7IP0NTobOYKsa9Uyj9YreTW36jFqtnhLfD2aCRERZAV/O+VqJ5luRIZUjYv3U8II
MaMXD3+m26EyvNxPLn3gmGKwejD8IhJoR5rXYJ/Tgr1ZqRNnjc+FcdyD4AViGuUPKF34u88S
tQsSnfhCXpFWgQKCPuoDzBJArPYbD1Clgkee+inXJHcUIzA=

/
show err
--METADATA NAME:POPULATE_DELAYED_LOADING TYPE:GRANT TABLE_NAME:POPULATE_DELAYED_LOADING CHANGE:CREATE
GRANT EXECUTE ON POPULATE_DELAYED_LOADING TO PRIVUSER
/
prompt Creating procedure GLOBAL_TABLE_CHANGE

--METADATA NAME:GLOBAL_TABLE_CHANGE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GLOBAL_TABLE_CHANGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
407b 75d
yQJkGHVluoMN8esJIMQ2UNgs88Uwg0MTzCAF3y/G/ieqnryOYZiOS34MYfb1pmzMwtP0d1qX
3E90v0484emZFDUtB8/O98BuMFQcObWurk4MZvQaP3scu0pdLTzF896MRNkMlE7AF0JxGEzC
i2Ufc4dkeNg7OAKRPsQGl5pN0HKfUjguriqneVOfxNJdznelWbTQ2g80EJIJrpmYBaXC7dUT
xW+SQz8Bm6qglWDYci5PLS5meWTR1+LIK13mZGjtklgxU+VK1rKTO6OXC5jv6k07pG00yBD+
KAvpPKc63eHJseZh/mi75PYZqgQ21saAyey0VAB6qvUqvuxGhrPlOxvy74dktaPXj5ft/kx8
4OIBsbz4TqM+6ovBj4qkWYV3fyyWks1D5arkdtTA/jEXwDNPqp9CldxRP5JyvcR5geQCinNb
3wS1IKrWjerth53Bw02O9AH0JxqkvKStbMLlPXun3lwtoO5sBeICXt9SugRJU+4mlwULvUGg
Mk+eKg27rAvE5BXktFJRuwA+cAWKoR2ul9p0YArBGRvuLROiYwbADr0AyHNUHWde4A6gxV3R
zGXVm9lrydtpG5yNoHruqcUuydncTXaOPNa3MVHVS9fHs21Ti6Bxf78uhFGe3jfTh0U8U7x2
41PB0wFnAWY8CBqzqx2e1KCiPngeVFKQ4Vp3GM1Yq++mAJ7o2596YlklBF4WvQSpyoqeJ7BE
rvPC43VZbP9x4RyW54U3oLSO4JnKYrCkf5NISC/iiK2cLVoRLy+AMgZhn05L9jYRoS6RQkzv
G7enScc3ZOaKAVpyHUQMdzk+1fIe9ecpwq0q99JkeOPwdPr3flyEqNEyxCplKnv7kaJ2zIvG
MrLbo+vhlJRyAh2PZ2Qu9AL1OwYJqP+qLRRbJSoGUOgLwMoDocip8Kew043hF1XbIg/FvlyS
OS3pd2dviDOoLQH1njaFQLRSd85RLqKuRi6oSccjZn5z47TysVjFmUSlVpiP+9p5YH5A/Cp4
hSdlLZpNazgsWSZjjOlA9R8A0PLAO6sURyjo0lkClJSsIe+AwE6oojspAYk9RbSmotJmRTOc
nB3p0mcqoDiC/eu2efPHIYxK5iH8JU2wZKtKbU3+wiGrAmm7kt5L2ebgH1GZxx1I5fMTZkxR
ZmYcF6O+1c+cnzy9lFPp2mMHxW3lpkefV7CAJXbs2QmuPKMUfIhrHaRbcQVmysY18KYyT6ge
3u6sdhuL35MdogzAZrhm0/D69PL+pqZRPN4ROCTsUOu4KYIoyOm8DpkWuAXseuDHaaGMN/qj
IWNJFXGjjjJnNkKgERn79+Ybc7OsQYXnkSCWDsT7Dpzw48bsoUZdq6ieTYSj0DbJC2lb9hy9
683K/Ka9WTiMy+RMamHIOj7ljTTT6Iv0pdq62FZINv3kvKq0qoOaLBl0dU4Cfs6jWJKWx1P4
CEN4D1opXgraD9LYw76dqjC3uSzL1swFd502pSxvCvRJ48lMkak1QdDa3Sbzsli2gP0istch
heYqgbnZtswrWpERtgWRCjqyb/FiZidmu/L3QbpHmKiXyEqMHFI8qb3qbUStyJj/LZUEJ9VQ
GoifGknnffTdFPl/rVBAnLLmomJR8riGrj6H3KJ+RRCltxZwYqd7CjEdOELA2chBWlrKrkiI
sx01vTnZrQAvrIR+ZO2x/j4oWmksnzc2QyrQ9Hmz6I3zU/Fg7bS4rObUqi/cmKnmsPTbn8D9
E1Oh94pVCL7VOHJJ23N/pQjllki2zAXmOmpDug+uvoNIiSRPiSSWtdFU7WgKWRkcbB+/v5q7
tJwgVrWSc+v51esHJLnL/k+Tm0K1zXIdEtLBGVg6DY6j6rkQZUxz0niLSMYl

/
show err
--METADATA NAME:GLOBAL_TABLE_CHANGE TYPE:GRANT TABLE_NAME:GLOBAL_TABLE_CHANGE CHANGE:CREATE
GRANT EXECUTE ON GLOBAL_TABLE_CHANGE TO PRIVUSER
/
prompt Creating procedure OPEN_TABLE_CHANGE

--METADATA NAME:OPEN_TABLE_CHANGE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OPEN_TABLE_CHANGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2dd1 4fd
G2uzILGUEiKr7d+Rt37lAme1t0wwgz3sDMfrfC+pvhud4CAuyvXgxN7TZQFgYXj0ry1GHKES
m7gW0Aw4lw0kQY0loDmesLILQuheAOr4OyunjmQlZcYV3jYmS0jYhcV+mw1N6rS7gSMdAbKJ
Ko4VBoUfFtbUicJIl1GAQw0FkU3+Ko2O6QvYS9H1MZ4uwPVFZGhtfsIl7EH1M8Sj76cRZP0k
8k0Qq9yMeWFRnmPNr8861Ng/90SEfZnrW7SLDWwQWV48b+pNH8PoHDWyMmwAcKbyOS7+wAd3
FtL/uOkCpok2FpxrPWwUcLFUB2Ujg3og0a7xt/gSfNGCKyiDXIz1idzUaul9QI2vwfgksYKI
s1Nkt6jIkfGutUH26XmHbM1//KzDM97yYpL7AmXV5kgxtIzEwu9XdTqo6UCym4OErxMMV4iA
tW5WNPjSkgDWlItvwCkn2jCtFCRLZVfLVg1oZ+6iRJgq8Z2PXN7jqqYoTIe5uuNoSMeTyrTM
WgX2Aso0REPahLnn/GudADKXE0IgksSPnInq5lBx9F6abm+2QnUjWfirMpKgJc8B1cRkSJZ4
5SAXTxoSlatkAYY9BW3Cqqclfv6F6x35rz0oHpHIyx/QP5ULYXDF+F8m+UgWEo6Ec7f4X43a
x5XFD7EKuceuk77HzPd84M16/l+NmMi+BcoNu3q/FR59MGM0g/O4sMfJuNWJGKn4bpSYIdQ7
Juj4jyl1lGgebtkE3XIbio8iBRC5mT+5FosSl//t9RxjTo+Cn7i1I22mz//L3KrzfsnBvdpT
0df4591en7iYPBvhpcefpUxvHXi1G7yCo+lSNe5MXT83wSvqVUlPpYfXUXXNvbscSOl0IE7e
l8vNqhFtpuRfpDTIQjZowYpo2WZtr+tJ5I8BpK8bp3FL1iC47+91Uj+lo4PnIspZsIqP8gvq
4u6mteZPMkSkbYu1ruR/fYy0PYuKj1Jo1LfvWb7fe6w+T/Axr/AF26WUbAA5MHYXWJn5Mrl0
/ASFWHLNP/eAwD+Qm7eALSUXxvsP1HwpXhnEmNWnusy+5/+5xxlPdr9YCPtn80fOV0M50Ian
7F9yU6+GV91shq14Uy0EhHZHU+2cau6o8InD4p4Y4GziKTkpAaeBJ1Crz9IEghLnWKQNagGE
5H4sZMDDp3tpycHGpxo3tYWf52wi5wizDWS3lV6I+pnzxDC//s3LvBms5D/HmZKL61XX0JbI
qjow+Do5uRBUfHUolCftk9IQhbttTx4C7Nc=

/
show err
--METADATA NAME:OPEN_TABLE_CHANGE TYPE:GRANT TABLE_NAME:OPEN_TABLE_CHANGE CHANGE:CREATE
GRANT EXECUTE ON OPEN_TABLE_CHANGE TO PRIVUSER
/
prompt Creating procedure CHECK_LAST_SUMM

--METADATA NAME:CHECK_LAST_SUMM TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CHECK_LAST_SUMM wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
8e4 353
dL9hGmPAPOP74BcR5wGtt+Ke4akwg5VcLiAFfHRVKvmUNK3RwlHNLWCeV9+QMA0BgPGGuRR+
3qkBuv3d/6mkkoYM1J/xPxQMGG/rlfFZIiIiCQkbXizWcWbO79JkLoo+ecNBFCt42ZGSlaL7
ouGiQXRpM8q3TdfbbajXgevXorLqE7auku+uh1ensFapVNXnevDR1xCzkqUY1nUESQRkEEXB
H0r2srgEvd/dBBCyP+yZVQBS40DciNY/AmUuqSn3+2Jt8wnhYlUioEetWY7iBjPudNLniB/f
Rpb4cBdDBsF+RUY6YrSlpaZ7KlnJkLxqE99o0cmUaJanfPjaZKdhmPvgred9TkLtgLq+jnqA
NYMC4g36AWPiM3cqbCBUb3BAbh8p9fWH2HkaWiVXP6e6hCmmYFnbXsWrGEVvYk8uMkoORN2F
BXT/aB2eiF2HNECVE1rMh1XUKRrf9wSXqXuV/PUngqMO1KNqCqPt3MaM0ocl4En5jO01X2Aw
vcCAv3n5THSJVQO+ZteAxSnroKE8ufeW8D2Dro1I2BVapV/wHj7uIUHXR1+B6gWoIBcKvWSH
Ie6dnjJ1MBJjjFeol9QUclQtYjH52gCnxx+tb7WB7HtGT5cAyHHWv0B5IwYdaSYXIqaN+IEd
iWNABwBLUF/EDnjBvTOPagMIQHzXvQCHq5mfdN+aI/99zMwtPrzqAVzceVdGdA8faV8S/cDN
9GLUsNo+b5uggQ/zbAU7gYdFXZKHvRw/AqCxORnOdSkWlIE7lspsLCaH/n6aPUnQ36dDUUY6
AFmqR+idR7sgPSXDqrm50R54cfALiWVrWma4JADhBMRimg==

/
show err
--METADATA NAME:CHECK_LAST_SUMM TYPE:GRANT TABLE_NAME:CHECK_LAST_SUMM CHANGE:CREATE
GRANT EXECUTE ON CHECK_LAST_SUMM TO PRIVUSER
/
prompt Creating procedure REFRDEL_CLEANUP

--METADATA NAME:REFRDEL_CLEANUP TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE REFRDEL_CLEANUP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
98d 41e
1m2FXhiiRulAW8TsXYYMpUnEkowwgzsrmq4FfC8ZgqoCD+gUHZcYjzcVHObAYjzTmAOkcK7M
gEdn/CiJybfIzoa/n5LZeaN79PL3q/i5mLu5vMdoH3qsV7ZnNvXpdKEcbC/C2KqP/kRN5N9Z
53KOOJMjsgZ9qeTBcqwawhc1SITzVUYGIcprohoWtmbqIQJcB1fDZ3ua4+Q+15oMoJjw3sSY
y3G2wgWJPi9aIcS8DASYPjV5yOxOpa6dOcfv2wVvymNWT+oX8+Acph81NeLms7pg7CDo7hBK
GVjhWNVB2dqp+Z6lrFPDU7zzeODlaw70R/APKEY+6+pt61RCsUt5dJTqOFU4+wif2/Z9zECL
VG/pk67gMzhusdvk6G5h/BXVOT2PsXDluiiEAAS1Qt69c1RvI315v/RbZF4q9IFp6iMHkwUD
7fZdfY4zhPqzUmPZndZr2NLZ0cDBLooa084G/b4QFia7o51H9M182pYnCfDl2/944qqozQOC
CmV3v7x2KnahL91mTesmByERdYA2h8uSUnkXW8F7ja1BnnNZDaX6tpfdxCbIMGkpywiFBQVh
cchBWHCa8DKiNLN9GhbchwiAQUHccnuMwf/1/ERaR5/vN1pYQjMXC/Y04YIHz8eXmKywTl5S
2jgiVtKgZgMbzcYjAHcSNFWC1PUnst0c4VXXjk0UXxNq2qHjRfvJ9FVVUDbjrvo9p6cHVoeZ
Qg08d6kUbv4X3khLxx/L9NpKXdvFl/ICL1tqPq2bojf3jWCosluDNbjQ35Hu0XbTOu86Vs5M
24LfTtu2p7A+TDTMhmCzd+66u+E8211+GYrmA6tmbjEJH5gBS46savNcpVdFU1NXo0I0cElK
gPJzfD5tPkJWSYwA1rlkvL/g6rcA73tMBT6fVvVmOIA3MRojIxy13y0XD+ODmQWEzS3CU7hU
vSGJMZENFm4kslo4UhinxLh4nEGSDOf+89KUQ8nAadBfuHbvqJxqoCeqaLx6uLl6U4s1k9zy
m3qHnQ8xJYjMrC8+OeAIQ7Cq0FDpmw==

/
show err
--METADATA NAME:REFRDEL_CLEANUP TYPE:GRANT TABLE_NAME:REFRDEL_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON REFRDEL_CLEANUP TO PRIVUSER
/
prompt Creating package CUST_PKG

--METADATA NAME:CUST_PKG TYPE:PACKAGE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PACKAGE CUST_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
365 134
jPgplLC6jeEiadzrUt8qRLS1BRUwg1UJf8vWfHSK8ofu9/JZTFho21Dn56e3yjIGtZ0R5pWm
YlzE8tdvHrnPIhPMv7TTfX1qR0wKUNWmEVHrr0rLVIqptr3/IfcML6hciV9HA2o33Xt1adKy
Qwn70G7ImSC6gO2W5VEGfaHJ9sAxle7y4UCrXxBamryuoERLIANbQpsi9CyZQyuuTjkdHPKQ
NRaik2z8dh3ZTfqia7F2YCz5KuMjx/sE8LKhIQh+U8EdqZsQAz19CBSTzs4QfxvPGSUZ9qMl
rtc8GG4mrig1zFU6

/
show err
--METADATA NAME:CUST_PKG TYPE:GRANT TABLE_NAME:CUST_PKG CHANGE:CREATE
GRANT EXECUTE ON CUST_PKG TO PRIVUSER
/
prompt Creating package body CUST_PKG

--METADATA NAME:CUST_PKG TYPE:PACKAGE BODY SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY CUST_PKG wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
3ff 164
FRoG0bqpAjDs51XGSfbZ42WF5lswg1UJmEhqfHSKq6pExo6FJdhBEfRSArTTNaE5ZTq1tWaR
hxFVBIVpDmcqfTWk0F33X7njADWc5L1x1wGLC5pwSKaPaYzVqOlwve/cFFfrosyo5tfJ2YV6
gHa95ka9lRBRir/d9JRCCPhIgMQh3xOksVllWyCLVMZKNnqkS8vpT2oOSB/dZUfTiT4XbA9J
wmmxXQBvcWMjW2sJQ9w4xXENfU0os9FFSMjQb91WjhD2SQzAXQpQru0J0bVcS8HTMer4XG7G
VjiBaxFUActDkYw2BcEpaAyTZIFvfgHtyjbk3J2cKt6YtWFN6uzgBQWIlIT4mQ==

/
show err
--METADATA NAME:CUST_PKG TYPE:GRANT TABLE_NAME:CUST_PKG CHANGE:CREATE
GRANT EXECUTE ON CUST_PKG TO PRIVUSER
/
prompt Creating package PRM_AUDIT

--METADATA NAME:PRM_AUDIT TYPE:PACKAGE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PACKAGE PRM_AUDIT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
a6c 2c1
Y82TiHaWEuv0z0/Rpi8bmfaPLrcwg80rLq6GfC9V1eSeDyuOvWslQ6KVr/RJr+ULuvmmI5so
Z/xBK+RzpEneuNOw/BxQHN2wzvAAQf6LbEroQ0o8Z6De4YFfmAwnlr3cXL1H/cpKbzXexo2g
kWNSG8pag6bu8XpeXiLMx4T1mI0Wu+PSLvvzBiVAiF8mH0Az7AJZqzlmHZzyzmAbN7yJ14Gf
wxAaQ2IEVlWsDYVmuN8ij1MaC42LGDSgQYYDgsOIU9iOHKxyDWvXIde3wtGch6yMX4jYfnaT
8aH9KyFhCyGhY2WlGlArYl0oJVLEKFpu2FrlmWH1yGONFJXn1hgj8422BqLvmMnLrD+0kYKX
yDvwzICccW+hM3lyoonUnl4RLWc7v7+31yPEWKidyYVzjoiIwW7WEsdf63QZBGr0Kv+MjVQL
Zi5vpG4Qh5/DHLqJV6KZXE7xGKmWFlNGJCVdsir4cA7DQJC3NKnyiOdyw84mdKDATbgfrd4e
5k0GBXsPGXuzObYF0hE8KmDtbmXXxCoisau1J0ZhB42cAeQsqCpTcAgYZY80rUX2YVE7wg/A
R8f8h+SavwZpz5LQHXR5ReS9Hu+supxg4sc0HnxhVHgGaBnLfa7EsaWlMIHBpZ/Ocz9T/N+f
5q8KHfpLUZ/b6tXw1NXkBgYwj/w/7YfvYmhLcwgfJEdG2Q==

/
show err
--METADATA NAME:PRM_AUDIT TYPE:GRANT TABLE_NAME:PRM_AUDIT CHANGE:CREATE
GRANT EXECUTE ON PRM_AUDIT TO PRIVUSER
/
prompt Creating package body PRM_AUDIT

--METADATA NAME:PRM_AUDIT TYPE:PACKAGE BODY SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY PRM_AUDIT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
2b40 ce1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/
show err
--METADATA NAME:PRM_AUDIT TYPE:GRANT TABLE_NAME:PRM_AUDIT CHANGE:CREATE
GRANT EXECUTE ON PRM_AUDIT TO PRIVUSER
/
prompt Creating procedure AUDIT_IDENTITY

--METADATA NAME:AUDIT_IDENTITY TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE AUDIT_IDENTITY wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
ee ca
rGYNLSTdYKcSYEK11bRdNoT6cFUwg43/f8sVfHQCOItuFe+NZkDikGjUqWPb8G4E9Cb+nUQ+
TaxfME79InOTsQKsPvujj0VSyiZxT7lumY0VCqC9VGdW1xocwpQlSNZn6qBUBf2Mv6XGEHyv
otr+Z0y5TQtby8ttEynUJV3Y3hK/h5KDmlSqjpJkIllKFFmwH4v1e5Q=

/
show err
--METADATA NAME:AUDIT_IDENTITY TYPE:GRANT TABLE_NAME:AUDIT_IDENTITY CHANGE:CREATE
GRANT EXECUTE ON AUDIT_IDENTITY TO PRIVUSER
/
prompt Creating procedure INTERNAL_AUDITING_SETTING

--METADATA NAME:INTERNAL_AUDITING_SETTING TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE INTERNAL_AUDITING_SETTING wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
4f5 2d5
3lzUhDOUi6UO+BIbFzvmUDHy4gswg2PDLtCDfC/NrZ3gSNzljkRplgzE8bZAbPELgPlwBbeU
NgeNo6O9K+2K0LtXLH4WYo2D50TXMIvXE8Gwd6OUU/Wra4lvDV0Vx8RWeT4sNDX9+YwEJ4l6
H2s5wGM2wFjmeYSXDIcNOrKxleweiFZSlZBLypAvw2y41maOWupDTXLG6xQGG+EWbt/yHTf7
6QFaiI5UVATuXsBjXET/DjN5GakDiRBx78zGrmMtOQa8CHlNnc/RRRBrRgqRqRbixdqie1hf
i5pe4I4PKlK+Rsv1TRfih8BtIjRU0zJsH8rKjbJF21axfSoiUMuSggxvwzQpw/0h8MGJ1ybm
YDWMPQ78gHUd3rGALModmGAxwus0IX1CTG3Cj2HDJYw88sa7yTH4fqfC30X9o50iLK5LVeu7
0gudJC9px7SvNO/W2zRxYlE4n7sCTk0ZG9Qk/PHfyzk3MOzCTMcnYddSJN5Bv65JYIIo1zPZ
Px9pBdQ/2ZgSfNGwQwsKz7R4uVRsKSGQG6Wbm8SGusFzTd0Siurr5SxWkkXGPRtGocxoTuQy
a72ZA0xM7y7PldwJ6LxPQbykSnSjOlpnODnZ2HsK9lYVPVvrmWP8A0/5WGcHrb6hjJj6fGSw
KkWxgpWa5zK6GrlFA7qxsupl5DiupwGI+CiQmAIjYsb/Y3Jf5eUl0WbyYhnkNqqLNTI=

/
show err
--METADATA NAME:INTERNAL_AUDITING_SETTING TYPE:GRANT TABLE_NAME:INTERNAL_AUDITING_SETTING CHANGE:CREATE
GRANT EXECUTE ON INTERNAL_AUDITING_SETTING TO PRIVUSER
/
prompt Creating procedure AUDITING_ENABLE

--METADATA NAME:AUDITING_ENABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE AUDITING_ENABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
a2 be
OVXgNgAUElJf3n4msQOSfGhlYoAwgy7wLZ5qfHSi2vjVIRuPY0yC+ggqKhblzNjY+bWdES6o
9UXWv2gKM4f3VWeKvqBRugfA00b0J/1j1bsOUfXCO5ZhWwF6MWP3RVoaxVeoCw68SbQCu8eP
7xR+6R0QQtY+DJ16W4OFJljv+b4Gu1KH4SGWxCjCOcXE

/
show err
--METADATA NAME:AUDITING_ENABLE TYPE:GRANT TABLE_NAME:AUDITING_ENABLE CHANGE:CREATE
GRANT EXECUTE ON AUDITING_ENABLE TO PRIVUSER
/
prompt Creating procedure AUDITING_DISABLE

--METADATA NAME:AUDITING_DISABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE AUDITING_DISABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
81 aa
9/j9bYdfUDYU4yQ0yrnxdEcPzaMwgy5ff8vWZ3Q2JruU0TXy6QwBpeZWrcubOiUZtar3UKLD
gpUR/zAgyG/KSFEmP/WzlwprX/WLbFU6RAmwKMYzXXWhS8cDFCDJXu6jK3b8Aj/MZm47tReU
QlJoMcUcxO6gjlNWah/djWbz

/
show err
--METADATA NAME:AUDITING_DISABLE TYPE:GRANT TABLE_NAME:AUDITING_DISABLE CHANGE:CREATE
GRANT EXECUTE ON AUDITING_DISABLE TO PRIVUSER
/
prompt Creating procedure CLEANUP_USESSAUD

--METADATA NAME:CLEANUP_USESSAUD TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CLEANUP_USESSAUD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
9b1 463
rnA91ig7XxGPl00hydnaApXMLBEwgw0rDCATZy+5WA8tnIVQe4Xidxz8U9NALfDCS5G/+oZG
EV/s8qekOLDNqCS8A9kFKIOE/LbZikf+10d4C2b/caXgy9tjj0ZSidvhRrjgcnzvy2W+MhY4
LRQ4dkepKIGYZ1bSmLoHmAwHqqB0DwRGaJ7IGjpcK06GhewWA8FywfC+5+PUqDpxgzesRqKS
+w5VxxTDZFVLy3bM985rRkSlYbeEJsL/BF7e9RVireMBvbHfouJ+MBEdF7/RbdXYglowoW5L
Of8QZpMJcSdbjTVGsILSQ4Q2GuVTIs6suLiI/lkhtpdvVH2iPawwA2cUBkCD/IlaF2A1sTvA
gMTcFgHHC9EESWjvRYRG510HQsQGq0QtrRc1zYc0mLrh/FEu7uXrGiW3V2uAS8XF2QresNy2
CzmZJCGO4ok/Uy+9W8YMRl0wfI1wQDmtc/3YJRCSYlUBM4Z7DHiWcp802Z+Y0gEqV7vHkAFy
+clPQyTrMnINrgo30VXhldhFr8xD9PFJG3ZFaS/VNhJW15ZeZhxG4sYBUhfAiQ4la5NhP7QT
nogwMXsFF/+rvbf3MhYnogrh9z6IugfvNzOzfz+tcVWIMAUJsaBDXkHNQWEeQdmGs02F2Jxs
y121DgQBOgthMbCaAyKsANJ7jHNhdNbSeJr5g/p5NQ2drJSAAK8jzFgLDNoOQJMDvF+3TuTE
3istc0KAElOt7JAwMlPMQ9Pmsly5NMsGJK/ue9j54HdpVVBtni6TNxjglfXflod+V+1JeQiP
sxyUtiWh6fgQAHGzKnO2ppAT6XqRxwSbz+ncRopoVoQGGdLBlYJtytsqTHYWC8wNpzVFDA2d
F3/t1OhePeSjFEW7O3MgxB4uc92co1e3xQSG5Tsikvd/Lc3H4p/vjMdzefUjaH0pvlPoIC6j
gczV2FbwI+RQrrCbRhJHnjVcvtHmG8ER0uys5YOUSZxl+zIuBfLV8w2F/Bx3D98w+xJkIkz8
lsptNLzx+/oDxnm8Zb9vkylSTDHW9Pv+0aIlF+VO7G+EiLiz42vwz61ILT6vOcjBBW7ktHYQ
rKgUBgZxpsH7ZjhBu/mmXVo4Tg==

/
show err
--METADATA NAME:CLEANUP_USESSAUD TYPE:GRANT TABLE_NAME:CLEANUP_USESSAUD CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_USESSAUD TO PRIVUSER
/
prompt Creating procedure USESSAUD_ENABLE

--METADATA NAME:USESSAUD_ENABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USESSAUD_ENABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
78 ba
PGvywGB7r3xJnMmE+agk5yz2Iwgwg5nnm7+fMr2ywFznsp+yy590MvS/gcf1m1JDwHSLwMAy
/tKGCabWcLHIL64k/o/OpcpyL7EwSaqqLLKEpESBidvx2xrbBsPt2yWJR9MAT+T1tSXTMg5G
9ofgCdwnGEXoKnc2F6oPD3Iv9tHqJB/2Oab6Ycqs

/
show err
--METADATA NAME:USESSAUD_ENABLE TYPE:GRANT TABLE_NAME:USESSAUD_ENABLE CHANGE:CREATE
GRANT EXECUTE ON USESSAUD_ENABLE TO PRIVUSER
/
prompt Creating procedure USESSAUD_DISABLE

--METADATA NAME:USESSAUD_DISABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USESSAUD_DISABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
79 be
z+k8ZcCSaqLNrztFq+t0OmQBl4Ewg5nnm7+fMr2ywFznsp+yy590MvS/CHSf9ZtSQ8B0i8DA
Mv7Shgmm1nCxyC+uJP6PzqXKci+xMEmqqiyyHaREgYnb8dsa2wbD7dsliUfTAE/k9bUl0zIO
RvaH4AncJxhF6Cp3NheqDw9yL/bR6iQf9jmmzS3K/w==

/
show err
--METADATA NAME:USESSAUD_DISABLE TYPE:GRANT TABLE_NAME:USESSAUD_DISABLE CHANGE:CREATE
GRANT EXECUTE ON USESSAUD_DISABLE TO PRIVUSER
/
prompt Creating procedure HAS_RSRC_ACCESS

--METADATA NAME:HAS_RSRC_ACCESS TYPE:PROCEDURE SET:RESOURCE_SECURITY CHANGE:CREATE
CREATE OR REPLACE PROCEDURE HAS_RSRC_ACCESS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
77e 33f
baGR0VYSHjUruijxdk0iq9vLFnYwgw1cACAFfC/NJ3MYBX6MGFCR2O439xa6pmLl5LgF9ISG
awyy2z5QqCS8gPIaFmCfzA49cAzGxpjrmP5N3KXxK6NptLbeRo5jqAGhY0cryK+NCuvxnuvD
UKBQ/GrvlK2RbZVRx/jBBsNY7zjdDZuZqD/I2h8k08y59DCFZJw7/aiN80WkmWfp9lFYrJj4
KpGiBouMKeMOO2W8E/n8CP1bS9Xxp16idH2tWvwFMyv+HhyzWu8ygAJjBrKP97nsbzgupHjt
lRs1zd6ZAA25xoTNbD6MY6z36ZWa39pw9q8oy616qhledlGaRQJInkl5AsN/5U33zsmyIExE
9CDXtNQ3fZzxn57q1F+FZXiUzNt3cQs5Bc8ErnUZxmJWlSnA+TrkzTbXtlbugZSOeErLmsaD
OZyl9SJMj8Y6RNydvA+HpxPe3wrzR5/+fNR/2Ona9bQrE4obMkYtVNvoyZGchOpGzL6FSxeP
xAeL+lkL7NqvHkDMfcBLDNPSRvVMMCR+1ipmg5gVucTZCv72RhG1djj1CCQHjJawwZHFhBOq
Ko34JC5EQxzY1gGd0Tdtd8UQevwq0fPFFDp/A+3+vzH1sVsfiD2PecNZcjd2Vczb4gSLT1GL
pB/kOeHABC/OT+mL1WD48GOKd4IkF3QSO3BX920djupWaJYZw/rD78SUm5bX2iBVUkaHytwc
KbP2+MGX7Wq0ml8bUfVZRVn6Pk8b/HLjXQpvRk9ydBnq1x3aQqqDW1VEQHnAgHzGCTDKR5+5
srbHYiR/xds4t5MJGXM5e11y0w==

/
show err
--METADATA NAME:HAS_RSRC_ACCESS TYPE:GRANT TABLE_NAME:HAS_RSRC_ACCESS CHANGE:CREATE
GRANT EXECUTE ON HAS_RSRC_ACCESS TO PRIVUSER
/
prompt Creating procedure UPDATE_RSRC_SECURITY

--METADATA NAME:UPDATE_RSRC_SECURITY TYPE:PROCEDURE SET:RESOURCE_SECURITY CHANGE:CREATE
CREATE OR REPLACE PROCEDURE UPDATE_RSRC_SECURITY wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
709 363
13jBbsQiEDcZFhrW1wAUq7hLhBEwgw3DLtCDfC/NjeQYvvsnGJ8ScfJst1nKFbQmJH25PpzA
fWPVjQDSSyS8htBXQMKgnGDmFYILnXggQVU+kzh5lKzNJ8lL6qNc7dSX5Tx6lIIWj/BkA6tc
mjxQni+fnWBc5n9YWXvwo8QJcQxcCQTPIbEJni6qcHYaKoRmlf4jhoZb6OViXizZxKFCkjoI
aQtqVnil7j/LROugjSPrCTclUEVjYEqNNzhJ6ats/j8ue1CbHm+QIi1VXPxuCVl3Nt33RtkF
PDb/OsKF3eV52R6d4RugSj6O6CwnKyYDquEA0tjlFjJrSrYgnyQPkhgr/oOfTXGCqo7YUuue
xfYTzCWUoefJbeGsPuEC3VWf2hknttNr1l+rLXIrSj/JNvJK1XIiQSS4uA+JX1IcFL3NgbIX
E9NF6SfbgAZBKwRYiRaWe0oqQc+wkevAJTTShDxwC9/LP1Iy0rnHO/WZxJpjF7vBw+AHMisL
H3iLQxilLRX/acmiGx3ZQeIUHv3eKXSwz3+SeodtB5RZzSnOtuilkp5gMz9GHde+mdzuBU4I
NiRBD4/OHvgpAUV6JNRVRVt4aH/iFMH2K83C56sKohTVQK33APE944XrjoX8HzyeCF8Qy+x8
lv+wt++ihiAnZEvAv+xAamOKBuj2rm9HJciXaJ8BSANl9xa3iQFGk3Q/T9B+dujB1nELfXEv
QL0c/Uck2bP/3Z/5NHD24Q1NpNf9XeECQuI3qmfxy+6tOtCjFFMMAAaMLxfOKYJokLpOYb/U
KUH2Ey6Q+ZgPSLeYbJUlpDdmhy+h3V3jNqrX/zousw9XxQ0o9PewTk6YmsfuZIw=

/
show err
--METADATA NAME:UPDATE_RSRC_SECURITY TYPE:GRANT TABLE_NAME:UPDATE_RSRC_SECURITY CHANGE:CREATE
GRANT EXECUTE ON UPDATE_RSRC_SECURITY TO PRIVUSER
/
prompt Creating procedure GET_PRIMARY_KEY

--METADATA NAME:GET_PRIMARY_KEY TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GET_PRIMARY_KEY wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
6dc 237
Cxb9S1gmfzsXYdAPmhzbc0Uidn0wg1XDr0qsfC9VHpuUA0khqMneEqMGa+CvYBGhPrkjBoDk
zpCsEfQR9bG3G5Qwgk6L1/3mAfXFPPDzyJkFK2CnaIoFO7Rbu4LZ6jsGY6mkeClA/dP7OYPD
k1DwRD2J1ThmTWFS/nqRN9aF555wzr4E7VkX7xEcpasMn+IFWt1fP/+3cGzAJnwcj/eIbpE/
VqhHf65DZjbiPIbjPmVMWqSsVec9vXtOqjg0g2GodsuwUTbHosxt2glVELSXMrQ9cAtYbNxx
Yp73oxY6ctglDaAJCq1aAYGP74uRYJxQdxWgJisq+ZQuJmjSmv03ulIOKnZtktzZA4ldV7VL
t2zbwTFKOxJFvKD2X9n8BuoFGbNTTp8EhQ0Aoyol5tGgId40pdKi58iVid3nD0/9ZqTMIb22
rqqazTN00cZPjNUs4ZyV7Rl/gxe2T0BZMTUsYWr70uUkMH2aeuxAKU7Y77c8lb+TwbNQBxFN
roSw3935nftbSxPVr2pBRafede13YXqrMy+yTt51tQiV9pszmZvcne4=

/
show err
--METADATA NAME:GET_PRIMARY_KEY TYPE:GRANT TABLE_NAME:GET_PRIMARY_KEY CHANGE:CREATE
GRANT EXECUTE ON GET_PRIMARY_KEY TO PRIVUSER
/
prompt Creating procedure CASCADE_DELETE_CHILD

--METADATA NAME:CASCADE_DELETE_CHILD TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CASCADE_DELETE_CHILD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
19c3 8b2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/
show err
--METADATA NAME:CASCADE_DELETE_CHILD TYPE:GRANT TABLE_NAME:CASCADE_DELETE_CHILD CHANGE:CREATE
GRANT EXECUTE ON CASCADE_DELETE_CHILD TO PRIVUSER
/
prompt Creating procedure CASCADE_DELETE

--METADATA NAME:CASCADE_DELETE TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CASCADE_DELETE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
a74 4a8
0u3SO2QSPsT6jVEXXywoTs/VtS0wgw0rmiCDfC8Zx/kYEljho9/7oSw8X6GofyFmnfxXeUIY
ReYN3kxYqSYSfSydAwvaywINPSEMjv65z/6Qu06kRNeE01yJZwSJOC/3e2a9ONvhcQBvWfxW
Wr1xNiF6mX2FN+AiIbWMRj0fNeFClcoKJb1rCXWngqjDYRWoDmWy4ien2XwvF5sEopGrw73W
0Ccptk73M1E7wsWhU5cA4pvLCg4gRGySvA46AZOMIhP35x0qfM/iPosydUmEyAy+Kb7WvGss
AIy/T7MSgIHHwk1qXz5zFP/hRU2GX/dYolQrt04YUJW8WyB8yCKlPwynZVdINyL1GIAQcPD8
Ft3m7gaa5kHUWG/sm03y65X70Iy3tvVXqANXhILXWOt/dM+ZbPIdaeDbyPub0aiyTnwecSNv
b17ssGmNRjwVTTao7XrvWjiGtASOv61lwJTxrJVC6F/3Mq2uqE2wQo3p3Wl3pTsBlhUDMYGc
mJS0pc5NcwjtstmBJ5n+HqTYP6oFuX6aelbHEiTDCY4rIbZnwlqReoQDrNQ+ZNUruiQhgD0Z
zBTDE/eDUyeGgQIK6EoErusrpnZqKXK7hC+FBt7ZJn9fg34FA+Dvy4ealhNGKte6qozULAkK
HiVzH5z4o7FQRYDhI7WWDlCjcOI8d4JZALorjrvEJkYjx26t2T1VJ8SsBdeSxqj5es9MeRQt
Nkju3UcIXrBpVYoHGw8Fh91qSH+K1+K3QTS3nO/uh3+2m+ymYQskvrnqYH6WCTTeWb6QJAR1
nTolQD8TmHaoUe9H7GDR/Td9KFJGxrhxOq5fluDAk1A0MFiBIdy0DzsuXRILjsEMbqJQ63iP
hQiR+T0fihGePj3dKWWzceWxoB2/qkUY3mI5TeslsJYsw14ZYYG5t0cqodS6Fr3VIkvriaJ/
IPnsuVyIF4LzGIAVWNiSQTVRsa3d0LCQhQUQg3CB+aSJwfq6bsGo38eLxCl14M501kjysxRi
9uTwCcOKHT/8FP/nK8XBJJ4RcnoFHzSQ/zfiLGFQes1saOJ4S9p8ypIHDr+AyHbmrQZrAR9c
F/nI1znW5/7jB2ns364REMdO9tYvIY75d8twCDsQYXW3oVnvtsl1sN5Hz0tZoFv37BZsZZp7
bweLoWW9Fb4gCOMg+aYXOvda

/
show err
--METADATA NAME:CASCADE_DELETE TYPE:GRANT TABLE_NAME:CASCADE_DELETE CHANGE:CREATE
GRANT EXECUTE ON CASCADE_DELETE TO PRIVUSER
/
prompt Creating procedure CLEANUP_LOGICAL_DELETES

--METADATA NAME:CLEANUP_LOGICAL_DELETES TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CLEANUP_LOGICAL_DELETES wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
ccb 662
SDX4hm3i//C04nIDYWfbaBUkPOMwgzvqeSAF3y8Zsc7qaAeyiX8qLZCKagZ7qVazYW/tjRol
zrcO1KPg3S3Whd54yiQ/gAm7n4N+dTfFJVUIMP5oatrf4GsukHXMSwAnRFKJMO5oDWKWUk2A
REPtt7YdZmDpwAtCL9ThrLRPCckna3LB8jALfxI4LRz1qhGAiJlYgCBNW0hpVlsH/9i0tnyi
Hcajm+/lyjN6fYRyBn08SogoY/9qKJwdIq1gEZkvPHeMoXA6jgGCb5Ivx5fTjkmffZU/ypyq
h2lYjJIrYXz7UV5ZV0NostbbMuejozfruL01Ft3HZD7IJv3k5Jn7vseFdl/HRUbuUwdPeFbk
R7ZHJHVeW8c8Ql9jG0Uc37MWcKuIwdY/ayxzZ6r5HXOVv4Gx9Vi0NxaBddaVp/T953uWZl0I
0l5ZMcIe7uB8Fs/KWXHO4RlhZyxqC8ygz1pNpAxp3qi1xb67OY1L8QpEuX48uDGpiV5SIUP3
GZ70rJW/c2HZezaZoWMO54T6zujyVgRDmamFhmLjnjKRbUhWVDDaX9XPmlQWKQikMpNP4oPE
SLbzb1sIaWLk5+8muBEmEl57v9ZBZvYTkJy2BIVDPfc8rG+4FgYMhz0VkI2AiR6CPm8haUmk
DKhocP+2YGJJ7qzuB2vFkfFcRa6dGkKfI8T6Jc3Z6ybEmA+aY/1JBZH4X3Vde9lBaM0iEvns
SKVOxJTMgR11C5Fltp/vBS+bptBIcF6EOj1HFla6oBVNCo4iFtXeRmhjW2Gct4MJY+hWCI+Y
go1S2pb6joyp+KRCKR/21qEN+pZYBzWn4huEY+n1EzmUYZCbhhWa2Q/VZJ/Y7BNgF4HaUTPr
nbS5utGfY5FXFiggRF+LXrOfCF2rwCs2ntQiMyDzPMG+sxhcx2KrpTXGYq1cIYfVGPxhbbav
yqqKvKaASti7kYngc3VDKJNhcvS9osLB+a1VZL+6cSnxIonPO/jy+pNupA2l5V2/trkJMZGq
bZTw8pSH/OkNT8ts1bdKA1gcyVQquhsYZI8COHcK3GfbcQ8zJ4qPYDgwo3JsA4qK6HZ/m3/x
0Mc6U33QDf1ziTicC4+GNmB7POAJHjzwUvGN5RLxF0JKMBselNjHtLkzSxAxfspV4o9DvZOJ
bJuopM2//D3KRmcSuZ284QmunwGMvQehHCxyKwoDnQhbKCiMbdnGgQFBCzHLp4yutzQ43JJd
UIdEMHWsX6rtRO+A11Ucq+wkT7/QpQnnjwWEM26vUud8c6othpRhXsBl0QiNj9mIqlB7DKWB
io1EFuAUJZhFeE1Mw27yn1rheWsLsdmRKsaDQi0MPUkZDahR+ZLl4fmq32Q6h0GyMrdNOjMP
YRZVMW/EYgcbQwRMU0HHik1aj/3Qq0QDGIU2OydoXChkwvDVeX96HgxLMSlTlaklagN2DSw4
UBumxeBvX9oRlHAyxp+6pfZDYS1eBV0nJaRmO9cpO9VKeUyd2XgxiY4G/3fBvYeBjFRuBp3b
xx0nLy0FsP3Itx3Sj1SQMSgpMyK6TPzxXPAOlKMsL8oj9utaj3ZQ/k6m5l/QCHuX/KoEwmyq
m0vf+VMrjpycKFrndPXk6yQY3Ob/

/
show err
--METADATA NAME:CLEANUP_LOGICAL_DELETES TYPE:GRANT TABLE_NAME:CLEANUP_LOGICAL_DELETES CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_LOGICAL_DELETES TO PRIVUSER
/
prompt Creating procedure HQUERY_PROCESS_REC

--METADATA NAME:HQUERY_PROCESS_REC TYPE:PROCEDURE SET:POPULATE_HQUERY CHANGE:CREATE
CREATE OR REPLACE PROCEDURE HQUERY_PROCESS_REC wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
b94 566
5+53YyLYKGAof18DuQCgVp5TPTwwgw0rBUgFYC/NCtKUTmGRmOddpkJr2aaODcJUzBRqbQsk
8xhaxieOoT1jH2csmjGZvtlawLIhqHD2n59AEp+LR3S3ITMxTVqIWSKOVhBWtuKFwmUBP5ry
ZY7WV8XW86KVfoUJnvQsgK0ShbJMbjm/AWU9Gzt1ohlfr+2ckraWEAz4P3EOx541NlL39gfI
VQN89u0Jp5z+hxGD51VWmLZ7cxUU/kCo1ZjGyqYzVJJSVEdmO5RU/w2Gyl3jqwJV/sIi3RAz
qDZzIZg813B8SyC+NQZjVtPMj9CiPt82p8dyxLsZoYCqFeTemJpXyzFML+7fpSSFVIXkdqJT
2E95X+oc1a4tJNyGiMl+XUNBVKpufFlr92IfR2hCs+dfoL7J0wKqZMYu1F4N2pQcdTesvsW+
xBAhdNSyzx85yK51Z3SKNzrp/8p117QWpWlmNYktIZxTT7VNiwe+DWT++EPJTNHVRbTYKIGa
W9EiEO61tW5kSg2yBhcgrcf8z1H/rHuNLjBnI+2H90SzkEImy7ZClz6gafPTBijUcauyF5P0
GqEY5LL5jTgvf21353DEcao54bC2XVL6t5FsXv2cRvHroWUfH0tULGhKjWYtsp+2iWahBCP2
0YMEyqxj0gXGOGD1DjYKdh+pih5c7VdnXJbfXHl5vxOa2SryQ+sn+VjTm1rnTCzq1UWQuy8n
Pv94k/AM4Le8NcxrUSVQkXvqj2JPnxNkm8I5R4Kqzh6+GT24CFc08QNzwtjjcdexjUteRBSs
HMmKmwAPRdStiz9bd9XdnasjnKt510xwS1OsVphhJSbFSJXpoaBbT2ytCcImaudRU10Ck0r3
Se+Q5PbDX+CPi8pH9H3zZkBFr3AUjGZ0lM72GjkK/XlcLtycBpINYj1DO4q6EfJxT3ZwrkrH
UkW8hToapscJaQPRXKEJ7+MGIeUY4+U8mjPkYbO/U94id4+mKmVV3qUuD+ruw7Ct4tM/viml
DVUcNOi/kQVDq9/GHVbfgHQDmZyYHdC5nwC1o5i7Kmpshg0r0/Lf8ZwTvCc6etJztQWlmNf5
YzxK/MnJv9Kx4O+EwmhqZ4IxbkSb4XCI9X+0ZnyoF2BWYpXSzMB8l4roVlN7mNxX/yqVdEQO
15uq4D+1jGcKR+xqHs+fTKXquVV3qtBCmmOp0dw1AiCb+fb4QsmRD/4wwGgGMGRSlyweVSRL
ZChLMVyB4o7NW5pI2NywlU7/RS2uSVsNcYBDucKDmDt3DdN7ypqgHVbRMbuB6kQgm8+V6SJu
0oA5mpNaE5m77mEG1UYTACpe5iLqi6x2pvEXZhKWEJygILedRZgEwO+lM/nrnWUuL4k=

/
show err
--METADATA NAME:HQUERY_PROCESS_REC TYPE:GRANT TABLE_NAME:HQUERY_PROCESS_REC CHANGE:CREATE
GRANT EXECUTE ON HQUERY_PROCESS_REC TO PRIVUSER
/
prompt Creating procedure HQUERY_POPULATE

--METADATA NAME:HQUERY_POPULATE TYPE:PROCEDURE SET:POPULATE_HQUERY CHANGE:CREATE
CREATE OR REPLACE PROCEDURE HQUERY_POPULATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
422 295
1Auf/Cm/tUw3si3HnnInMNI0BFAwg2NeLvZofC/NMZ3g0ZWYypffyAzXHKCbV/ZmDBgU2jG3
y/SE4WI3VeaW+QiNXdCN+n/h1uSLXrvXFmKIpztgVyKgTa7coT3AJ38FFtbUdwlTRTaz31t3
No63FQa3LnwBKTeMtqA1fU3JgOUg55H8HK5KoRnfBp4Kj4GIOydIzA83WVKKyBP2k/A8MonW
fs0JeHDwvm20dkXXTfqm3UGO5n1fDasnHavVpervMvNHrwZUeFU0qFGQQo8v/255TsfEBXmA
E0UHCF9DgHwiI5RSxxLaRHw4sftbNAoCeI2Fs2bDo9+2KRzPelGxyjjPKL21GTcY09Ob/iaO
6TM+eaFicyOjqX5RQ7Ecmwy1mKr5ma10HRqbkppuXxFRIDnZCG8sgSP5zoJED4DJzY1qncT5
aK6HhlRG0RrmLeMroaQSnjnRYxg+xaCKU1N3FZfKiPSe6QCmTyf9zlTTEB8lK8KUAfNPraGL
LEX9HZeEC24s0T2DLPnHNG9T+j06hr6dcY9zASyYoCVEQ3i8g58EeihqL21KXkt+XFSCC25g
OSng90ZI0/1BExtr/WVi4VgfcFiSRsSBof73FMU7nyCHvrQUkvPnepLahiWPR673QgwIzSRs
28us

/
show err
--METADATA NAME:HQUERY_POPULATE TYPE:GRANT TABLE_NAME:HQUERY_POPULATE CHANGE:CREATE
GRANT EXECUTE ON HQUERY_POPULATE TO PRIVUSER
/
prompt Creating procedure CHECK_SYS_PRIVS

--METADATA NAME:CHECK_SYS_PRIVS TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CHECK_SYS_PRIVS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
120 134
SXdS8BDqd/7hZ3pDXSCRp4NrrdIwgy5KDCAVfC9GvtSd4ChaZz0d7dNSfP/jVPDN9c02V+nn
JpRb0/Toc3PX1oCWAwogvxdJF7DIjnQJPncSQyi8l5Och6LHl4hrxQFg4ueRmQP7nUpQzs2m
DPrFjTQvJZlmAbv2LbRwCnnGuY3nEk1mqaB/WqCKRViAOZR9d+R3zeQBNU+xi+YPneszI9id
0LAzaHeC08waebjtEnoEAOA7PNI874qUmw5VzhecFfGZPrResO8aF7m5l6qRcN8ItbPXuK0E
gxRv7Vn5pqrXWl8=

/
show err
--METADATA NAME:CHECK_SYS_PRIVS TYPE:GRANT TABLE_NAME:CHECK_SYS_PRIVS CHANGE:CREATE
GRANT EXECUTE ON CHECK_SYS_PRIVS TO PRIVUSER
/
prompt Creating procedure HAS_TIMESHEETS

--METADATA NAME:HAS_TIMESHEETS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE HAS_TIMESHEETS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
567 2b9
BA1aAAV7xyTVcCkxowQyelMJhfkwg2OJAMcFfHRA2h7qcLc9xxChxpIl2qNRYg1lJu+omJBT
FISnyVpAdDoI+yQu5frImUmSROcAMDXHCcJDVdhX0ln9dkpx/m6M4t1kPfUZ3oL1youGSgoq
WRiMrS3zXV9jMHdbSUF1JxLovHiUAwGDk94mDs0HLYLDdFr9IREim2+v6v4PBdVCGgmbH/SH
rf5uhRvoU2e2Z0jKynnV8nsxz++Rxtc/kVvj2dPY4hN58mu3bUPuXjmziWyXZjtnMAuVZto/
BDZDbBI/aN2N71/z42KuwS69Lvl54QtoYAS/SC8WnPDiXroe052je6GauoSFqSZFtEXS6wJ1
fdMOKNTtMje13jpG1o4tX6aoLsbIWO1uKRbxjuLcudvEHnnigxPmJ3kpuSBrQJwfZ95uVfvo
LaOyxCi/0KW77r25QbssTyfGyuRdB3OqarDxqvax5q3MZElhfAen41KBDb35JamWGT4uv1T/
xQMe4KH1IohAWbXfTevGos3nAIztVyTu/AD2rIJ3lAGY+WDXCtDA4XO9YgJzsgQ/psnOU0K/
GU3f4h0f21OuOCwNjYRgqFYlIt4dpt4D02M+vJrk838YxF2AM+VfCdxrojrxOxiErwKKpNmH
ZBvmL7gYtrrLTNOL1k4S2e7jC90ZsZZkrVihUw==

/
show err
--METADATA NAME:HAS_TIMESHEETS TYPE:GRANT TABLE_NAME:HAS_TIMESHEETS CHANGE:CREATE
GRANT EXECUTE ON HAS_TIMESHEETS TO PRIVUSER
/
prompt Creating procedure SYNC_UDFTYPE

--METADATA NAME:SYNC_UDFTYPE TYPE:PROCEDURE SET:SYNC_UDFTYPE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SYNC_UDFTYPE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
10f2 4c4
0eJTtIU/N7AOnuWasr2E2Uqn6Iwwg83quq4FfI4Zxz+VQljxSsv70PXKY/re9FqKR59Teula
YiUU3y+cLlr4CE5sJpDbAfULhkQKXPYs+Gi8xwaWbIy96JSEj8EUJgr1G/8MdGYWiBiSFP83
K+FaXFn38Nfgr8EjCBTJ+sxHcI7beqZaxdQ+HT6Fd46pC0r0qSe/utvrdvbTH1crXt4aKyv8
Vj1Obv8DFP8eIW8tb/W/JsejaxwL6onGXkeBSIeNhfyTHHKBPIiMRCGvWi2H2gDmQEy/j6bm
806GCcmodxPg8eFr4aVWhqyEdzk4TLkpGQPiKowtA7EDjH6R4W24uGcxiQXa+9m2HsdQAHha
T63aVPk7TJDXQTjtYbkaLkWtAcGMocookHaGrcSwWZQuialtdb0+pOfTZt0S5h3x90LN5u63
BSEhREUfzc1aquhXclpLxdlGK6KiLGDI8zV5DVu8g0JgQzQ9122x1/mvnm/tg1tI2VE8r7i2
51Vd+drnmNB1JKlQGmwTMeMocFvb89M7zNErX03fZyaWEylVm4KANaVZgYjQFQeVQ3OG18Kn
nQ35TgHzSi7lxmGogPIM5m1mtmBt5Ohl8+Hqr0kh6RPMSdqIN4UQitrCNY+fzhw9+Qh0dLHw
H90zlmkZdrsyxVmo0qb3gWntqJsY43Sos9GdNZvlLmViMGJCJ5P0eTo7Tl8OWRB10WSn/tlE
RqVOSeej1RgvCHI6EmCugVVlCawvSGSqor+MUBYT3sm6glmOqfGGi4mnNwzHmM/mCHWo8zIR
fav1cOnmW7P2HlV0evOwwN1T4ruy1wp7v0BxG3ZYfPlhHGCkSBnuzeI4FycWziMhAF0Zh/5g
0EVpJz+iWPUcvaBT3/RMTC4LSa61s09wtDc1sNuQMwQViWO3ycRDNPG0tPpviuykdU5vTYS0
Mjej7TLNCjlFvEBkH5oc7viVPWqby9FkIDVMwehBc1wGTcxoNeU6UwXio7kOTBELTupcTdcA
aFbRuWOvsxptw7CfPLNa6xwi3yQz9zCuM2u3+Un93morJ+xj9yg6CLCEuxJAHY21SDMrGHhb
eWCkHLBgXPL2tNUkSuFAdjQfuk5AikOS9hX1I8bNshJR/uKyE0Yf0lFeqj0Dw66jGfQXvadm
jNtoDjZNWX+G37O8CZ+YoiL/9y0V5wTXTt5udgztFJA0+ETyeeSa

/
show err
--METADATA NAME:SYNC_UDFTYPE TYPE:GRANT TABLE_NAME:SYNC_UDFTYPE CHANGE:CREATE
GRANT EXECUTE ON SYNC_UDFTYPE TO PRIVUSER
/
prompt Creating procedure USESSION_CLEANUP

--METADATA NAME:USESSION_CLEANUP TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USESSION_CLEANUP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
889 343
Z8P5PLc4Mu8JdkQaY+FuwrkLTfAwg5VcDCCDZy+5lLUYvsPLCaNjADwGcIqoU9gsVUyw7pGo
fBi6nm9tlOmX0HK5Bh+P36BaJpZWT8EIEIIDhuNAy0V/6eOIZYsCNQYvoNZXZabiUZ5OcaXh
5+Cq445xdjF/7puWqCWe4oy7CxoWpHmIoogZMXeIBdLHByYg66EGZjUZed7c1+2o6UFoMTYV
dZz0/WgXxKtk7fhA13Qi8C8wCVLiNjfGqQWErC9KJ40s/QG7jU8ByF7G61Snf9u6lshZJz8P
ObgLod39rzW+dW+yn48VzBCXeM9fxVA4TShP2DleZWzJkgK0N4XrQmHPrHEa5pETMvFicAMC
5AioVej6zyrVoie5kGMgWR0yYFhV/SZeeGrILLgm2yaAk8QTKmk73loKsM+CUWuWvQcPWIpE
ETtQl4IRFw0nwVfAeRlfkNKPAd1d3TqLRawNc6a0iSnrQvTIfIoUdoC2Bn8/35pt2xwU4o5P
Pg5Ia3v8D0nSENAe+bk9zfg860wiA78w0NzYuQ67jB4mI+xt9Y25CVRIeJ3Kmkg/4wcxb9Iw
NfaLwipxvd6tmg3MzcOJZymRFU5Os4oM3UYxI/v4caHa4qkyLaOB1+gnjf+HZNbNRHaHa6YM
QmQYz3+3lVQgHBcx/0Y4WRvxKKh9uL7EMOcaC63ka1MBNOxBWr+kdNJTnEthLKkw05LSuyN7
xYNSeIeI42a1vpddq0WRHPlBI7XEaJrJrJqJCMybtXLO9YGJ43EhORnaBFKtM9OnvR3nQz9r
in0DKz8VtHisiZIrwf7clT/+4d3tIJs=

/
show err
--METADATA NAME:USESSION_CLEANUP TYPE:GRANT TABLE_NAME:USESSION_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEANUP TO PRIVUSER
/
prompt Creating procedure USESSION_CLEAR_LOGICAL_DELETES

--METADATA NAME:USESSION_CLEAR_LOGICAL_DELETES TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USESSION_CLEAR_LOGICAL_DELETES wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
36d 1f2
O5P4smW2euYUEGkChadyOkvfKFgwgzsJAK5qfC8BuWRTYjvn5wT0ZVP/DSoyirhhhFg03VBE
QPmq9MeDFGJi0+ZW9Me8Ev4iJciNVETm58uQXjyiJsxpd58mGlAt5vAcVTZwgy+StJ6y3zB8
a0HvNctMDZ/Z4oOe8dU1KHwT4yHvHa0Mj2JqpqrVW0r7YwfJECiZwios30Zt9TrC5ovuh5DG
e+Wel9v0UKDrfv68BXkkJGEgMV/9AiZno4ZShozzKsAXb5ErWYtTw0D9OejQbGiUcbQKV5PO
ebpC3rFyE/FvarZBDxkzdev70SRBl5N+BhDIP95eQXDHfYJplMS/fvhUOaozCQa0WFkq32xR
MoB+s9ocvWxO2rRkO3nOM3dfUNgNwLy/CzZigOO66A9uLt+RT3YXcwezh+uWgNDrdv+xUFVm
W4lGMhW1AAFoWn7kj7z7Hohy+yTXWmJz5FnXAPYU5XKtmnxei5NxEPsFy10z

/
show err
--METADATA NAME:USESSION_CLEAR_LOGICAL_DELETES TYPE:GRANT TABLE_NAME:USESSION_CLEAR_LOGICAL_DELETES CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEAR_LOGICAL_DELETES TO PRIVUSER
/
prompt Creating procedure USESSION_CLEANUP_EXPIRED

--METADATA NAME:USESSION_CLEANUP_EXPIRED TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USESSION_CLEANUP_EXPIRED wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
46d 268
yyicupb7Qx/Zle5NdfVbi52N6rIwg83Ds0gTfI5V9s4Y+MnIWj3JEvLsoY5IthTgdXnCM/qb
nvbI56ICKxN30JoqJhU8JiXo7f8ouBBHCK2xW4Wiq+CJmUZxUYlSlzJ1cN1OWYYub5lfdqZ4
tk3S31rK15Slz8cC4c8EUPBxsn3fL+57L4KlbmfTF9VSNlUxvsTKfBhkZA/Oao62w01cNDXj
4QIdYL9ijQS+u2L+nup/sEO3tzrT/81OFIzgvPGjcC+TZi5x1bkDFdKLbSmXA5hFIdeG7la7
l+IKg0A6dJ2k5QfCyIBnXPjCEIq9T820j/XpZX/qFloMugUWyAcwaDH/7eqyR5ybK6NOXpiS
DEmRXGOD34b5oqUxv6vrcz+jjksF1yJH/j00HkqbZGqmnMGhBgOD9e3fvxCBw/xBWWps0jvo
YAycf4tZG7YwPxyNJhu0FyBaf9D79O1/VohZXmdOw5gyBWgeM2kidUH/DKo71wB5Egy63UOA
BOU1GVvFc15ZhgwGcxJUvULOYktttfRzMuDZJHRHrxMvgulM94vBKsBaPasCNkWbr9QpH2dJ
GyRsFtvJf9E0z7DrbQLWeqM0+PtAXd9M

/
show err
--METADATA NAME:USESSION_CLEANUP_EXPIRED TYPE:GRANT TABLE_NAME:USESSION_CLEANUP_EXPIRED CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEANUP_EXPIRED TO PRIVUSER
/
prompt Creating procedure USER_DEFINED_BACKGROUND

--METADATA NAME:USER_DEFINED_BACKGROUND TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE USER_DEFINED_BACKGROUND wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
43 75
96IpEoDoSCV3fnkML8Z1oigwPQ0wg5nnm7+fMr2ywFznsp+yGL9SMk7SxzL0v8D1M58omyiB
x+6bdIvAwDL+0oYJaaWZgQgtK2mPrO/qJB/2Oaa6NChj

/
show err
--METADATA NAME:USER_DEFINED_BACKGROUND TYPE:GRANT TABLE_NAME:USER_DEFINED_BACKGROUND CHANGE:CREATE
GRANT EXECUTE ON USER_DEFINED_BACKGROUND TO PRIVUSER
/
prompt Creating procedure CLEANUP_OLD_DATA

--METADATA NAME:CLEANUP_OLD_DATA TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CLEANUP_OLD_DATA wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3f 6d
ehJNilKUmoMZSVb9xVWU35Tj7gYwg5nnm7+fMr2ywFy4M1Iy0pmy4/7+UvS/UnRSXZt0i8DA
Mv7ShglppZmBCC0raY/mYOI/0Tx0pqYvsgY=

/
show err
--METADATA NAME:CLEANUP_OLD_DATA TYPE:GRANT TABLE_NAME:CLEANUP_OLD_DATA CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_OLD_DATA TO PRIVUSER
/
prompt Creating procedure BGPLOG_CLEANUP

--METADATA NAME:BGPLOG_CLEANUP TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE BGPLOG_CLEANUP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1b0 19d
wyr8b+FmIMqFFhT/Y9HO4ss+GMgwgwHI10jWfC9GEos+zybK0/DlWs2oiR0k/cblf/V54yPC
FjUAIazn8SKqeeaJKwC5eDOKR291Scin5xToRHIm3FeiUVZ2ZGdpRRhX+gzpoliVqSJYcBsp
Ngrnt3lGCgJqGoRabO7UND2GZkt8ARPX5FV8tULo3TU3K1Yd8WCe4nzzGI5xJxuOad3d9Ddl
OKKGO3UOCe+iJqee148x8LyYZK6BgABh2YtQPFU6U18ei23Lc74FH4SaoIaF+K6xvw8FM4VF
XtrPsVuCIs1VPpkq8Ip7IUwNLpnnZjdtOmy1nUceabwME/g4JTvPzPo5Tn4ibDF58JQtgJAj
vOQtzlUwpNM61Lt/mmxCPomN4rEPB06M3fv3Ob8kGqMy1A==

/
show err
--METADATA NAME:BGPLOG_CLEANUP TYPE:GRANT TABLE_NAME:BGPLOG_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON BGPLOG_CLEANUP TO PRIVUSER
/
prompt Creating procedure PROJECT_COPY_LIST

--METADATA NAME:PROJECT_COPY_LIST TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJECT_COPY_LIST wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
58b 295
i1QempRa5TjjC8Mi/FHAyyvw5oUwgzvD2UgFfC+Kkw8tePqpJ90pO2DLI9ikYWXpyMMlQePb
9/uUQGxUSNbkEJzDYgzezLFgvVpUIslXaKQJhXqvoMjn5otPfLMb+pXqt39j7d3Lvi9NVYBl
vm1dLn2v6WLpY9eE2HQM+zAtGMyH8u4UlUf6U6MHyE3XEIm+3Id91Q1X7I2jMyHqHsy9m1rC
aBtACA/AFkxtTYXYRVaYdQlWm9jvRrXpJmk+p8fGOheXvaKX76P7AslY7PH2NvLXadftBJxf
63a6qcXgYwG42AHneCzmdS6Pb+RYKPOumpGircAV/NpdGU2sLCDuc3658Jc1C/n8EhKpYT6x
PYuUgzK+EmjqDSZBOF67+CLYHos9u1A20RTEfyX5fjiMuS8zIAQXIzDssxoVr3GPePiSEzEr
za8oa514t50LQdkzcIdBo/FaTa/prdYDSXyujVX8df+C48nIstW4yCnHhcleIBJxIEsD+I15
uj2Yhp/t9HbctCey3QzPt4uzuhQilrDf59udN8bHX/bCWTc35zcYwxxH0MY7CswX6Pq7L8Ip
vcLVD0dTYZDudtHw6pdQ78qeAGPQJ/+9MqM3D9OO7Nzc9iyF1Mi3WGN7k6NgWag7hinkVa4Y
1Cuc

/
show err
--METADATA NAME:PROJECT_COPY_LIST TYPE:GRANT TABLE_NAME:PROJECT_COPY_LIST CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_LIST TO PRIVUSER
/
prompt Creating procedure ADD_DATABASE_JOB

--METADATA NAME:ADD_DATABASE_JOB TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE ADD_DATABASE_JOB wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
9f7 467
aUWSNVGI90Bu+btU8fQl2MD7JskwgztcBdwFZy/Nx7zgGXYKPng1XDdNoC3G24UZDZ+xoHqT
N1NseaY+y1Dyz88XsbHIRhhtY1T9u0dYBVhYop4oc8NmfJpyz+gxyD5H3JVLsa59kFJv70Z2
/3XSYFm5siOlwkkIonaCuWoTaYnJe1yLFAlzORfm4sxBLX15qKHSFGV5toKOZubUr8apY/dA
qemeD/tYm5ugOQnZjkxwJhwCIjAmiYUyp8WJL8VlGmoEgp7Y1m8+TvuuaRw94UGlLfN8Uv6/
TMcpBzXIPmK6zcWWc+3WHdWzpcrVjDNPWnQIFF053gQKX5e3GiNtP5OOwIraGXosluh4JO6x
zURXpc60Br7Z/6QchOwUFvjFpPGEc+hUHePIT33M+JWk3eIM/BoPurtdN6mghTCrKLGszeKv
1q5syqY//nyzaxZ/nfDI1lDviZ591wpFmyEY2Hz+O7Y4UPSGBHZDoCUurCjXlb5lrKLBVzfQ
ASKF6hPXg6qxz/Vhnc8ZmjFS2I1aACovndY3VXNz8M6Mv92aBZpGuZ297eGVlIHoblzeTVaA
pEBUQgLzI6snnjP86OvgjcE9AcrpdOhVZUPwEVRg9WbMXIe2hBEjp9sqpkeCXVJrG8cAtd/3
bZnanwNnGl1SBwsKeYCo0fNym+KkYMmF4sUCGFkRCrShRd49G+xiDxjbRncgG/kIsVxN+zbm
IzP/3BqMbydjHghyoBFF+ThFU6zgz5Bq8ELXTh4F+M8GU2LaXwdknhqDmUDasJH01xGDWfms
Kg9XYwfTMsU6ZUlBFA6gLW6s/CnJBjotSBrSQiU99Ylv03NWJrHYTqrj8Wc7CBgkctUJHBrf
ohVgCKGWza/fdUqqHIDg5liF7CqhVzIHAGTjbrLv5QlJzhgU7bLDSCLsI6D47T9ZoUL5pujY
nwddtn2WuyjayXGw3jajaxME3L/2CvhRnut0hfyBCmk+XhsJYf2azZsKeU4ZQJTCvPasCPVg
ONFIOHpYqSSHX5bU6UgJfKXim9maS1OXa4Uf6AOeDgWTyyRIwbgkQS5JfO2TXcd77J2/Qjgg
Gx+x6Stxh0O3mJMieGIXG8YHqg2M6oM=

/
show err
--METADATA NAME:ADD_DATABASE_JOB TYPE:GRANT TABLE_NAME:ADD_DATABASE_JOB CHANGE:CREATE
GRANT EXECUTE ON ADD_DATABASE_JOB TO PRIVUSER
/
--METADATA NAME:ADD_DATABASE_JOB TYPE:GRANT TABLE_NAME:ADD_DATABASE_JOB CHANGE:CREATE
GRANT EXECUTE ON ADD_DATABASE_JOB TO PM_BG_JOB_ROLE
/
prompt Creating procedure DELETE_PROJECT_CODE_SCENARIOS

--METADATA NAME:DELETE_PROJECT_CODE_SCENARIOS TYPE:PROCEDURE SET:SCENARIOS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE DELETE_PROJECT_CODE_SCENARIOS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
5a8 32b
bnTqHrHmAylR0DjFb44BISdVuDgwg5DDr0oTfC/NlLzgSKnfGMIKuQED2F0Et1NsdYMbzUHP
EccmxQ0n/lMsmoj9fBSjJsUYZoI/Tos613Xc1dHlh5lNou/YuJArLDbESgryV2rp2aDDGy6b
Sp92F5+7isdJbthnYVAzxpBQS/ygS7nbq2ntpKze01GAA/6ztuvk3dKkjj6CPqYtply48CE8
t6whcDHi8w7896Nhjc7hmBd9q4aR9pWHfWLoTof9YwD7jwoU8tYXj29ZxByNt0eURDQjk6hN
PPznpBxGXZ/PRO9vWVS2jl4vkjrKUIhkhQ2KFg5GfoVHTRb21Xweku9cPvf2pACbY+T5CVn0
vQP++6BapM3p1ArKBo3iUG8hXad+3Zr0zoWEDhcpFjXctKMZg10V3bc6dxT6tI3kufm8pe6v
JhTOu4S0YFrimyYtgqz+E9cbfMg2Vn1DcWE7OE1HePBBVISHb7T07X6MIzAWOANwKDdEQ+Mm
c3ARr96ic9yMjiqOxkCI/7igalPBMXy7MZeGxn9Yi61KSySr/Ng47IGAtKkA49+ySZW4ZAWm
trTDk64+zAaGXmlhBBiI+uQw65KLn9qa6LmLhsk1hdWX852li7J3cR6PM4StVuYB5sjWGUh6
/xrg11zQkkGLYMg68V/QTaMn5A/GpvoYADfuhrbii/VEas26h0EwP5N+mlq5shnQtS4zLKyq
DErioihSrfDGV/Dr5zjKCv8k/5bBIMivHtVUQ325XdYxRJVlzoH4wf5OsZzkrvf7fl4aGbz4
mV21ES8=

/
show err
--METADATA NAME:DELETE_PROJECT_CODE_SCENARIOS TYPE:GRANT TABLE_NAME:DELETE_PROJECT_CODE_SCENARIOS CHANGE:CREATE
GRANT EXECUTE ON DELETE_PROJECT_CODE_SCENARIOS TO PRIVUSER
/
prompt Creating procedure INITIALIZE_BACKGROUND_PROCS

--METADATA NAME:INITIALIZE_BACKGROUND_PROCS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE INITIALIZE_BACKGROUND_PROCS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
448 203
NNVhwKFSlq7AZOm1zR55fipJw+8wg1XMLgxqZy+BaA8txKLICZntVMVZwuufeQP0mANzpcIa
YeMRuhGMj52/A71mo/c8EzcUA4Igi+2QnCYhYEiOZahEvQRt2qDz24w38vBd38cyVaaEhK+T
fonmoTwRw1l9OQu28NtoKMN6Nj3LBZD/QrFDKvuIcz6aJw1xqBU3yAGI9EZ2EQovUz0aaKhW
F0xLcFgfOmaaZOxt5PkpOMQQMVYTknntVTbiFt+VJ/7sJJwIfm8w0bNkkdLPGLMvDBijBY3Z
h+LW4nLPUNyNynr0sYJRXUoNX6nH2TfK4fAzG/AVRxDYRjaTu+xEMp1JtZuRUuwUjzlCj/l5
D9g8PGssbc25uIDtXova5Wru+ubT5b1fDG6daDWJFbR5TzRpCTmqZ4iT6SqXmk+A9GEma0dp
6+2fVhRAjVGXc+/NQzoPis3VNM0u84CGQnjsx3X+IVAmSqqcwG6GMrW7SpxdtWogxBO5Mdqk
Gyh+

/
show err
--METADATA NAME:INITIALIZE_BACKGROUND_PROCS TYPE:GRANT TABLE_NAME:INITIALIZE_BACKGROUND_PROCS CHANGE:CREATE
GRANT EXECUTE ON INITIALIZE_BACKGROUND_PROCS TO PRIVUSER
/
--METADATA NAME:INITIALIZE_BACKGROUND_PROCS TYPE:GRANT TABLE_NAME:INITIALIZE_BACKGROUND_PROCS CHANGE:CREATE
GRANT EXECUTE ON INITIALIZE_BACKGROUND_PROCS TO PM_BG_JOB_ROLE
/
prompt Creating procedure DROP_BACKGROUND_PROCS

--METADATA NAME:DROP_BACKGROUND_PROCS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE DROP_BACKGROUND_PROCS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1fe 19d
+KlcFTbV5I7xivaTxSw9KNTzGeowgwHMACAVfC/Noz+VedxvQOLz1rYsFGItO22yfm9cBE2i
1soMbD/PzY/IUaPC9T8sP8EDG1wOS0bKWt6cTgYL6Zfy7qAX7JM9R6bSA31MQ8ip0cNMxz6m
324Y8eu6/GN6fQBdKuLTpcV5kO8BHEdSXPo3bsWpObFUBOfqKyVNswQxbCarftaOZRPnSAzS
kFQ79/F5+i6ebTCruvIDNRiY4Q0miW5f0xrArP25p+73cHqOk6bmC6FgZI7+5l0ytiXBRg2D
cNP9WbVLl6t512ggxOIUG1lxRU46UBXq/r10SMTeK7zJ+i1MS4B9tUMqYL58s4C0jwwxL3v1
30q45NBGTKric+5d3FX+LbvRMUzas828miT37uycD8HAP0I=

/
show err
--METADATA NAME:DROP_BACKGROUND_PROCS TYPE:GRANT TABLE_NAME:DROP_BACKGROUND_PROCS CHANGE:CREATE
GRANT EXECUTE ON DROP_BACKGROUND_PROCS TO PRIVUSER
/
prompt Creating procedure PRMAUDIT_CLEANUP

--METADATA NAME:PRMAUDIT_CLEANUP TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PRMAUDIT_CLEANUP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
263 1e6
CkxXnFVRwa7ViTLLixuQeHFZbwcwgxDxNa7WZy8C7ZdkdW03G7R37DAWwLQVZ3gVrJiE/a5G
nn8uqyURHru/HxENqAiiMxIDIMmayNlW3UvI575Zk/PAxdY2WBbA2fpsCb7JvZFENxYlbPIf
e3XlU9b2G9aUt070lY1ESyvO2W46fgaIBJsWq+L2iyKyjrYUVvSw56jvempnL130xb7KX8yf
dSVxmizuSHHpX55E2VaCCxI80wvRoOWAqNHgXPKRON6RF6VSzUV7KwX8Cli8uxPlAKToPSYZ
pL/NB82DtCsFEF4FuWqRd5HuajHbsZs7PEL1TObVjnwnZFr81gubOp34DOt2MBJ+Ip0K7SIi
/yeY/e88axOwDO1KJTYY0+mp7QssCBY8AmQZifQzvOvwaAov+lbtiv3f1Xk5c7kurXoPMeRM
X8tn7Ru/ZQU2k6iFWsFPke4o6TlR5zJlQWOdGdcosBvo0Q==

/
show err
--METADATA NAME:PRMAUDIT_CLEANUP TYPE:GRANT TABLE_NAME:PRMAUDIT_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON PRMAUDIT_CLEANUP TO PRIVUSER
/
prompt Creating procedure PV_LOGIN

--METADATA NAME:PV_LOGIN TYPE:PROCEDURE SET:PV_LOGIN CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PV_LOGIN wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
5f1 380
QXK6pwxz5eXF3TzFG74cAxmkMQ4wg5DDDCCDZy+5DeQYvjEr2OMaAETM+tB/fguf6pj24UnV
XE1Gq/eeJeUH5M7/vN2i8pSB4QPacrsTctWNTUu5jqxxMzt1fyLyAbDMgdg5GWLyw62FmAn+
Yus5ohdwk00nh00eccUhc8IRVTvQRKq+UAMDaYVgAhz7dQ2iDuBhpwNYOV6JYqwR4ETU9nE1
vkDxCOY7EtSy/2kuFgCRy9VZYPUPMvKZRAn0ZGeAybrefi1laV52hpHnQt7ML8URiVSpFg1t
H2VbbZz/UL2FTJQYFFBhhnb0q5eUIr/yf7PRMHmu99g+ohkWcpJdTIpXADIoIpcK3mfW7WA7
WI/fX4WPTAXUXXgd5rLRdI8Ypd5agCwdGTiMqmYy+bUC/twvSf+wb8hWjsDr+Apfl+dc6xXe
PepI8AzEaE1Y0uuBMHr/ihmIhSsoAspbsu1+G4zTOzDQbcRqZg/o+jjHV35PnwUHFO95iFKn
iuflmFGQdviaWaSmmpzL6jwnrDQjApRcCAn2AshKdDxGaOcZR/facg4RWSiJWW4suvBkHe0I
m+GhQbQk7yMMWpLlZ2/FL3LYCJ/O0Qmn7TFQNeC47jgxkW0VN3kO6SKCTneyyK8fzlmZVzit
vOF461ovqR+pwcwZ4o7fNcMjO7LRFblbX7pMw6wrvmUAlm9auaLRjS8bCJRiPUfAdlBx31mz
uwF6K1GGi9sAsv/ePRuKPNDIHJjBaoe+NO2XWnB5B9LXdOiXhuc69BX7nfdmBsoiQngXTTnc
+NL3gjEAAH6PUhIwQHOLOrE/xEKpzcs/+c4Dms8Hwfgg0P0H/hap6/39bKW5UZ27/gULr06I
xlLZK2bSJDqlH2BwB50=

/
show err
--METADATA NAME:PV_LOGIN TYPE:GRANT TABLE_NAME:PV_LOGIN CHANGE:CREATE
GRANT EXECUTE ON PV_LOGIN TO PRIVUSER
/
prompt Creating procedure SQL_TRACE_USER_ENABLE

--METADATA NAME:SQL_TRACE_USER_ENABLE TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SQL_TRACE_USER_ENABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
501 2a9
4af572FeDp3SL7TWsJFFrGSLyfIwg43DLm0FfC/NMZ3gSKHynnnQsiIWm1d/hfHF+rkZR6er
RWmfa6FrB3MIpAynbLACUHas0hnPNLO32PAGVDI5rz9v1oJfhlCTIR3yn45Ufg2aoTxmzg9y
dCSCTlJkWDyIQfPyjDjizGVQ9OdDRDMW6HQxDYAhlYeZlRDkLmxNS8mQuI4W24f99YRy23Y2
5cfHAmcNM4lex/dMr377L+gR5a2GZ2lyY06zo7Rr98uutj/bXu/0DRbI2uPe2wrDGt/lgYkC
lhcaAwwXw+Z7SyYMXrCg1KzDOKu4F26DVvBT/BoFvFWUOOGaIAlXu4SAimOCMJ5UPFgnnAwT
rR112HAt431T/zr9sBYn8NgnCHq4hu1ods82simuA0b+3kve5wldFVb2zV1KfVDUm0vwBv6Z
iTbBtKOH1Ecjm7SKYUOl4K7L1P1TmR1rS1Iz3OpH7js/IG5tF9NI9b5IvdKWVWetHVxwtqSY
22b+VjQgBrUxMLFaFEUmsDJx7h2AAPYbvvFISywXTSkVK/rNQzI/xe5VB4QV6BehtOiYXyQ4
HWRkWB2gDCVR96XNATTdTtmU1JqunNV6AGqB+OedFrXhscZkJGCWPG3Md08c7iRcUP5fCp61
p+Y2q+slfsJ7NDod4MYhIw==

/
show err
--METADATA NAME:SQL_TRACE_USER_ENABLE TYPE:GRANT TABLE_NAME:SQL_TRACE_USER_ENABLE CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_USER_ENABLE TO PRIVUSER
/
prompt Creating procedure SQL_TRACE_USER_DISABLE

--METADATA NAME:SQL_TRACE_USER_DISABLE TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SQL_TRACE_USER_DISABLE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2b0 175
csCXS7j+y1nMVlbsW8jkiLsIMAAwgw0JmEjbyi9Z1+p+v/SJxUOT0XzYeRSHk92hwbW1baZh
fv9J6d4lYtpq/0cnAK03ZfPmznf2FNG4LvvejcWlNe8SgYHevjWpArd1rRA0ErlzXnJCFByN
A/3A4UZSTFM5uD6sLslng+wbWQ3EXpoEKH7doZM5DmARGlyFLA1AVwv7+5v+omHZKvxpUweM
SeWi8PM4FBfK7uDv7jYPgotQsGeaTSpellj5IZjhnZ5+dKZIbHa8+IJqSKa1zFGVlqj49ooH
k1FsGfyVaOWadOUtwxWIjODGpboOln4rO6O4QnmO/0OkB1K72Tq9SfabpBbGLftakZtX1Zic
LG3oOzU=

/
show err
--METADATA NAME:SQL_TRACE_USER_DISABLE TYPE:GRANT TABLE_NAME:SQL_TRACE_USER_DISABLE CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_USER_DISABLE TO PRIVUSER
/
prompt Creating procedure SQL_TRACE_START

--METADATA NAME:SQL_TRACE_START TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SQL_TRACE_START wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
22d 1ad
KZNZnaISYIpeBczmnUZ+B8xmM38wg43MLSdqfC/NimRTLr0wWoTraxvWJw9e1maY8XZFvYaF
yrh2S3clqCwPrb0uhVAlhHZo2hmYxl4+GI4D8sqFeOiNDj4nJk1ps10hfGjK1m4HsAbC8RYh
sPZG84Np97wJf9DZUaI1XIel/W6UKYgcUiai/+rI7pk7deGHf9/wTV9wehynJNv6zy11G7OC
4sA/MSJiN2noaamiPoBc9J40VVg7n7wzPEIFU2MsInSh4bKafzuO5ryHC6deAhdrXa76a0hZ
9tqMzTzSGWE8dEsUuFfdXOE4ZiM21mhjNqdWXd++otMd+9OrWPkFiYL/MRCqIQEi1pRbgB8U
d804wCQTAHpBNIQPu3Qh+BkTlijNP+ddqLnmu9zhsaoSPPhVdptWvvg5oUicLQ==

/
show err
--METADATA NAME:SQL_TRACE_START TYPE:GRANT TABLE_NAME:SQL_TRACE_START CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_START TO PRIVUSER
/
prompt Creating procedure SQL_TRACE_END

--METADATA NAME:SQL_TRACE_END TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SQL_TRACE_END wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
d6 103
YfbDfYvsEEl+YNe9a2RYgS3e60Awg+lKr56sZy9A2rteR3mByfGko3vYHmmso9fiJS6iK33I
5vL1pe4FFpuYR921qkduKRp8Pr01D8KDyMNUC/d8u5jJVDg56VjGWiK37K+wsLI1bKGkbAKH
BOm8cH8cJeChvxKPZYJafINSNLIAESFwT2FPYI98ct2kSHsBN2TWcAMCKbOgb5KLSGukkvq8
GwRFuSC9wY+UXN4vJXrGFI05qgdEx3JtPf3ZRlcR

/
show err
--METADATA NAME:SQL_TRACE_END TYPE:GRANT TABLE_NAME:SQL_TRACE_END CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_END TO PRIVUSER
/
prompt Creating procedure PRIMAVERA_EVENT_PRM

--METADATA NAME:PRIMAVERA_EVENT_PRM TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PRIMAVERA_EVENT_PRM wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
e77 5a3
kB7T9eOYrT7fXM9GBsfvWYrv/DQwg9fqzPZd3y+59jPqfWOFIm7vEiFivwVihYc7C8hsTxTa
oQx/a0zymfoCFNA6CKT6YRqB4obtJeaEyqeL6xG8s3glGvFmjBOjCcP6URSyjRpjskNFO5G+
48UJXGJJbOlEgLL3MZT3LNPD9J6pRS/PIa7CCF1mJifpAbp+R1Zk2YnyoGu6CYKyhNRwjURf
v4jWjlyez67arJBFhXiit6GuCKxNROYu2TZyupPHh6V2kJBj5nzyzpe0ZeL3tSlhZTmBWD5i
kDilLBBTNF/w7eiysfGL8cnUInSdjQajmit3kt9xYj2G0U2J5pIubnOYbW2ZmRFo9Iodp9Ru
JTSPpmWdbbkgLelZcV4p0GVg9kYsT7zkDfjNRFWaAGhzLZiaADRwGmRNk3a5CL0OXPTqPJQB
GByDXJDmNBkQwlmnTE2Jasx517EbYlyZpiuRKyp5r8QG7VFF11Q4SkdfH6SMhZiqEJW9PxCB
klR0JlsMNm9io2ointvz1j75RnyeS9bRr0ZfJLCHdc5EGzBqUWfavdTU2WRTv/OdLmuOE+yz
yvuIzI5MhGUHELEECbNDsSdQyWVWZnxqG1Xezb1MqNF7VZLr+1/z6lxYhDIiiiblip4YWDdR
B7T3yMZrdM5BNiFuIPMvJr1eA31FrHTs2aJnlBbQT7qwmWm2fmzphLSK0eXRDGZtTylWZRdm
bHQ38jDcrvAiAh1GaEeGDRRxeQJWsy5CFPxrIWhmTfAs4JjC5V4rTQrrPM+aO2t4jciSCqeO
AcRdfsuqMQfpieivLri4zOav9pMFCkeUU60ZNVjvMI+FWpiqHHDvEl7NeZEUeQMP/kSP1QRI
h+X3mcSYIzw1+0RazqF6Cd5mecz9NEVci/Y2YQiSlLpgwLaPYhyGyio7qFBQPOWBUKh3enoa
NXPiaieHgVe/8Pm2/zNr2vTN8102XPmazDKWZ87NnYoMmfFFS2TVASHrFrYqsbOYU16OsRVR
ihHV6SmHPQJt4H2WPBERKkXNvYqGh8V8y5oZe9U+HmaZ8+iLghjqVQF5vdizJZm+FwhIae2o
L9JEc9L7t63Rx37cXYJqhcCeURAs9ckn0nSt5Tj+ydzZMlekoQQmocDtIc/pzj3KbYz3Xz0h
qgNnBTyjSkw3omsFIpQzKlkz2d3+QoRZXqmPG5BntP/r91UotIE5W+6sAWW0MOXlfS5gCvnb
ebZm3Xh2NbQkRgDU0CRrTtAsaqZxKPyY2lkcLDpVc7l2v813DoQEj0jLbcZV61XZTw8cijBm
KBL6nuqxcpiwBv4Zcw63xGiPxw0SP0DNaOWpt790+jZ7AWXNETpA1zJVEB2254GqiRoZIs3N
DwzmVDLehw2xwlCloucw0k7n0PnW2/QMCeHFeE8E5KnQPXiqHap1JxU=

/
show err
--METADATA NAME:PRIMAVERA_EVENT_PRM TYPE:GRANT TABLE_NAME:PRIMAVERA_EVENT_PRM CHANGE:CREATE
GRANT EXECUTE ON PRIMAVERA_EVENT_PRM TO PRIVUSER
/
prompt Creating procedure PRIMAVERA_EVENT

--METADATA NAME:PRIMAVERA_EVENT TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PRIMAVERA_EVENT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
277 134
QQ8ixs1uCXa5MgWdAlwwov6eoCkwgw3I7csVfHRGk/peMDa9qHAaqV1h0aKgJkMUTE75IDcm
2w9peLQGt8dPu1SSGPwWNlZhajc2trJdrJN8ZUkHpDcyfA7DH4lVnlMXTJ5hv1hKXNHslICu
8X4Q6kyK8tNNJq+0OaQFK6rwma1sD5td7SOu/T7eNHs9BLgl3t5Q/ab4uLQsOLp18f88JthF
nlzSqAiBNP+SWlbS5V3tQBfSF4P+VCyxHqV7x5NfUGC+B7Z+ynGFWDp4YdaquPrenNfObkpo
+KXHYaxtMbL5aE2Z

/
show err
--METADATA NAME:PRIMAVERA_EVENT TYPE:GRANT TABLE_NAME:PRIMAVERA_EVENT CHANGE:CREATE
GRANT EXECUTE ON PRIMAVERA_EVENT TO PRIVUSER
/
prompt Creating procedure PROJECT_COPY_BASELINE

--METADATA NAME:PROJECT_COPY_BASELINE TYPE:PROCEDURE SET:PROJECT_COPY_BASELINE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJECT_COPY_BASELINE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
f66 58f
3sd+p8QefvvZ13WsCcR+L1COcLUwg+3quiATWo4ZsYFkVyCp/Cuf3xDeBo18HNqgBC+CUwVJ
XbQaUfLwAVqYjZKG/nR8fIK0UuyK0RjT0cHPx9GavhRf4QdHBuNnBES79GrTSeckbF4T03KB
+t0a97elrvTaHT86CMDyUe6mPzoGdWV3TvfmyYCZFaNLq73JkUjGHGqAchLLfs2+2dtOl0pu
/dpFMKf084PEwgAIdtuKbMvHoGxMhRGWwtFuW0H9426sHrW6f3Q+a3eyz/sQnjq/KeWgUY0e
yMYNVks+7KAnwrVS8rpb5ii7EGBvFEXxopEGJ2bRLjaGRDEFyOwgYjB4+4ZIEA8aYERahgFR
81Qk6wiTlqvlhcMXdaJlTsDDLHvly37k3JHwQX1TqvDlTwjjD+QgRG8cocNHcdC8NSDm03+c
UAqviVZxqt2Eglu+/Eyj6SysWmLuiwDFS/0GKI48jDJkxuodAphoBkOEzOYtrngxVSgWmwdq
GwKBSJmTk6Zo4m3SIgVjSyRdDyUuvQHLE8+1ak03L0lKzz+uz3oQP1wTg2B94wBM3Qi4ABqU
8YDzFe/5rFV1BtZEsbhSQtOw7bU6thF6Y1ZlMn04LJuUXzu522Bkt51TdlGmcbX0kyrcHFVe
/YyLLG/ENj0U1hSPxAZUwIOUKk0q81N8PERv531dLOPir6w/ASEswcxLjoJjP4EIQCELQAMX
ZsfY3HzUYw8Xtn03xC2th5VuF1YYoYQT/5abnITmQNfeUHXWTBtayd8Dt0IvjHU2z1/6q5yE
kT6RBb9pW4flBEHLtIve+5g0RtK72Bay+2tLVPDfkmSuYUrrGAUuh8PuqBbwLXkZMuz1MT1S
7sV5XwxizWk0O4KA1lfAXdta0b+3FdRX8oJwZq5GG6isGDssO8yWYW6Z7hI9pf/gYjTlPT0M
JHX3kbkxmYnfIg2T9nQyyBtHdrrsArQ6tXKmPI0Vxtc2YNf99HZoxW6w2N/ceESw4x+2xfCf
XnsO/Bbxk2rH7sRGoQkrUlNGVFwaqp+UoZDEfQI/47wwEbaqwBgdnY59sAJF9iy1ONU4HmrB
oEbojN1MP6nGRdn37Yomc8nKGyS18Jj02V2UZzrjWPy8WGBStBTPfEkxPGlX4ADixrBFGha/
ToLsBaAWbC7wFK7M+T+6TUXT3q4Kyeklfsr0VKEvBoVNrdZqv5xd39W+sc1mpVOXP6qcmhdC
efXEY0/rxSVRhZtMjDz3zjQZ7rphoboALUa6gTzjd4mJH6KGGJssC844CECade7riT0gtOXl
vJFAhHwzB6BZvDu7vi4uzVQQlHHHIY1klRdrrAIBKvg4uj+xMsTDnFzMN1243VHZn825+rex
SBpzssP12kRGIn7fdb2Eh7AwPXMzKAENNPk=

/
show err
--METADATA NAME:PROJECT_COPY_BASELINE TYPE:GRANT TABLE_NAME:PROJECT_COPY_BASELINE CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_BASELINE TO PRIVUSER
/
prompt Creating procedure PROJECT_DELETE_WBS

--METADATA NAME:PROJECT_DELETE_WBS TYPE:PROCEDURE SET:PROJECT_DELETE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJECT_DELETE_WBS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1574 2a5
Fs3+saIXh0O5txg5LSfNmRwjgOUwg1V1mMAKfC9AXk6OBTFHU/o+KLfmDkPAdON94NDVGbVi
wvEoGJaRCZFmICVrD9UQnZ9GL9reXGv1qzgl/Cwrn6e0jJU6VOx+2kJSuRRfSBbMu6lRUP9b
s9bA3+U1dlm229ZQXNXSLPGAbFLe1tujUxkVYH7Kckb6psuo3f5IT05m1S0pYPGYq2ghaxlA
vcAwvQuJvF7GsrRvc8gB4p01YlqvGcpo0m7/AIwUovezhkI7afYqZymRXg0LHcZvPqSgP52l
SEY7a02X0fLnM0JrM7W0bAyWL7Yb59NBAM/iErNpILjxH3iPyDALt8faC3EF6UsgBrJ7J/O5
jSC/RexRFF0qS3kNQqYw5VyaJtKYFVGnBqBZyQIxmsgfPkb41AszhGMGPEPemwq7H9BcEDPR
m0ftsBiXHLQTieXguy2nQ0GdoeFS/lePDrQTdpQNUxMa/bBfA2tuqkZe/xtYLISDUK5GwJIV
GpwrX9HAIR5EGQ/DHmKHTw+dEVJ2TOJY9TkqErfG7VgwEzSa2XqCJtpqtQm35Lu7kvLsSgxO
zpLZ71MfnMIaaLinnYPr2hJDUJ1plsZjmvAm3dVxC1Ly3XNLpQQMX/6UCeOUJUzYX7ychL+8
BnUPjXYpazAjHd/KZI4=

/
show err
--METADATA NAME:PROJECT_DELETE_WBS TYPE:GRANT TABLE_NAME:PROJECT_DELETE_WBS CHANGE:CREATE
GRANT EXECUTE ON PROJECT_DELETE_WBS TO PRIVUSER
/
prompt Creating procedure PROJECT_DELETE

--METADATA NAME:PROJECT_DELETE TYPE:PROCEDURE SET:PROJECT_DELETE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PROJECT_DELETE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2d87 5af
5cBz+3JOH0AmC/TcFQgeBgSrCJQwgz2j1/GMyi8Zx0GsBVnlyQrJ/lM8di8FfaKV+1kbSZq1
Ym93zh+2uurvEgzs+ezQQDlFf5RuN5y9yiaPT93DuTU2np9kJvNda4DxVp81NN5EaTr0YEYX
5dVfQ2svQU1w+5SdmoXzytdEwerpBjeuA1r3/nNKl5CZB3wx8+aX/+OWMFmOjYDzl++tW2kI
f1WqyNW2F8SY6Wno3JQV5EeI/t3dFUY08jvZw+qHpvDb50ip/PEZgA/99rZguJzNP7vSfSJj
6lsejCrapOnS+0iLpFTIdlCm+8xNyqfQHwwsFIGSXVhNZ4sgch3qzDuHJsIWCKKuxKeUl19g
yDDDWVQo1LxIWWJR703hE3185X5Rau8TNO83MWrUwcyFYsDc1f9t1kOnCbpodmeyDRfQBp8e
3wDOg12qIl95Ol9WSupsDYO66TiaCH6YY6sMBNZ0iSriVYn/yBcfoJp4ZHIS7rNtfgJqZxb1
FXDXs+w51GPCRtwWAW9GKqROxKrtCgEqqu8x47UOJHhdgsAgYTdKxljpfs9yAIOisMfcSNcb
QHW6oknugQ0ZOXsmpmRAqZy61PrLezw2+GXEKddynAFI6wUoC7oihPVlvRVme8GMWXlrx5iL
YTP/GB/SzNtw+8S+PX0PAGCNGlA9nQME0wLBjPPh3KhuuobfbwzuZ+ouhB+dL53thLl/cXId
0PPvkzbhUC6X1PvtoL1bqfSSP6cwx8Z6rcfmR2oW4OfI35WuFA4mbIamxS/QSf/b1SntdEMX
6vGSMk1CbycZrBmFDJtlfR0d7bEsayP/GJr0Qjel7yNQO4Ml1+II+kz3POnQw4H2HGMaNJga
J4NWkEPF6A3Ad1YtAbKGmllIWlPDLXCp8mKdBp6vFCvQ84Rkgk4e2oW+kOo7r8PoQeoSryvo
bwO8cUw23s8rjR3eEofX4fbP/wAo3hKHAPvez4cypt7kLMBzKQDYOM9jQ87S2CPJvOD7Jmw7
lpydZvBy2WB/1BfBp1qLfRLpu1rd++x5HLCag0X3qYMqV3M8b20doGEudg6dlP9n7qYoTNqS
k0dHTU/Eker8EXR/VPQRzR1XrsTg/ft9yz92yEK83Apl5KuCAkahrQ7cxkcH6l7SSen0PJYb
mwxMxUdcJZAIp6DwanL+BHBnD8VaLJYothtrmpKJCNY0tpRnZdrVvHXYMI/C0R0YDzClTKBZ
UOohlWS9uZehixDRBqGmtgG34UmMXzfb6nUU1pHTjE6z0KMtqosGdfjzu+rn2pvTTWxgfDhr
SqhgYYjWnD4BfN07p7EAlNN6vhlH2IOxVxpfr2zyWpwfF1DDf3VbTqaDo33aQzeTqnPkgCAd
/8u8iBrFXYvVyXnvqHG7dOan+IS+ACGSJKqt8EfPVjsBm9XhqOB5PghuLKr7Dqi9SQ==

/
show err
--METADATA NAME:PROJECT_DELETE TYPE:GRANT TABLE_NAME:PROJECT_DELETE CHANGE:CREATE
GRANT EXECUTE ON PROJECT_DELETE TO PRIVUSER
/
prompt Creating procedure REPLACE_REFLECTION_PROJECT

--METADATA NAME:REPLACE_REFLECTION_PROJECT TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE OR REPLACE PROCEDURE REPLACE_REFLECTION_PROJECT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
4d6 2bd
SN9kpNqOdthOAWLfAGJ1zuVZBtkwgxBeLtDrfC9Dbg9/xH5jSyetCSO4t954Fg3wzSGK+uW0
0Y776WMGoCRBiHgsSueiO100eD9OgVHwly1Nsqw1TPR27a8uAr7VjdKDTf71Wbmg6faIPpnI
gUjwG+tZYLsOk92uDv+76UTlnwu4F8T7aJm3JOdOOcn0S72pzJc6yXlbjWxrRIO9oERmkWSj
5zn18AUJG6IZy1mTXRyY+MP3fBaYNqhRidyVDZFSvajgC3fLUw8VZ3iIoIbhsjcgHMjU5buY
99jU755/5m+G4+iq9DABl3kkMSUJC1wyjIO4Jp7SE/J+oWYQWe+T5UlmOdeLGXvuJx7HRZeR
CxBOQ7gAALB6YOR1jMko9ZBayJcfFb2dzCq9V6zhW2oYmuKPgeCIjDQL5l4QraoAP0XmOjY+
NDSpXkG/P3irhV9Yjtydj8Y6nlvOEM6fI6xPzT3BTkS8LJZP0N6cN9N3YEAnAS1dc5+yH6BM
B3ynLDRXBHzWlV9El9dQldp1B7l7ECuwpsttCV3yJAmsh9ozF6fR+SOL5E/r0CwisDGirTS0
VpK0wgip5rc7MrpPWxOf6Cytwg2aoDpIG3VLy8ST9qMhM+Zv+H4K0Vw5taBytbaW3hj6tIJO
ASUF8IB2aOgRRNTL3xNlk35/+GvmC58U6YcwgVuOYWfg

/
show err
--METADATA NAME:REPLACE_REFLECTION_PROJECT TYPE:GRANT TABLE_NAME:REPLACE_REFLECTION_PROJECT CHANGE:CREATE
GRANT EXECUTE ON REPLACE_REFLECTION_PROJECT TO PRIVUSER
/
prompt Creating procedure OBSPROJ_UPDATE_PROCESS_KEYS

--METADATA NAME:OBSPROJ_UPDATE_PROCESS_KEYS TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_UPDATE_PROCESS_KEYS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
256 189
lUQENIOm+2E4Qsx5bUrLtruzP7Mwg433mEhGfC/pXk6U6/vzoz7es285KK/7ivcAGYCVtbXp
fta3AcSe8GO+Tlf+5jzSFu3pfJDv9rzqrgl84o5EwTy9u+JNFqHyrCUOcyVreanikBLRQz68
tmDuZn4knvi901vuF0AJWpM8ArjpBw/yH6YnMKvahK3OQtGvtOpsSh3QBElq2J8RrXp+ZSTD
Gzgq2lIDzDwmmu5fAB0uLC6fd4rf8SJUA6aG5rMqpYkYsfOEeoN8jy6tn2nN9hnE+c+0Lxr5
sSAFcH2ga0QsepDhNudiC60HEv9pMv3fOC89UPnaZm1tvo+E8mWPZRxwLF9zHAfPAPS9eWrw
PGqd2Pkl2jkyDrIg+DMd9HWNRw==

/
show err
--METADATA NAME:OBSPROJ_UPDATE_PROCESS_KEYS TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_PROCESS_KEYS CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_PROCESS_KEYS TO PRIVUSER
/
prompt Creating procedure OBSPROJ_UPDATE_EPS

--METADATA NAME:OBSPROJ_UPDATE_EPS TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_UPDATE_EPS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
7c4 3ac
7YZ3o65AOyxQhNctcvWA6FvJ3gIwg41cr0gFfHRVrQ9ruooVguyksZ+pC+v0b7olFK3ervm1
nQRss6ddFAQrDqmMSfHQ0BpNoH5rEyF8QiHy2ZpOGkXUFXSXip4y2uxYv1+ZG+gI50Xg8taQ
ZNfdXZFOarNu5O4Ns82+sySXTAufXw233wkDM0cH3IXLBEFSWwQEDg1f5tKjSkfz3ZrnGf+p
bsOMNbRY4s98BtYw73uqEp/RwT8R3Oe7nTMg2jZkHDVt3bvXLETq0C965mav9AuHdvIohS/f
voOe2XepsBUV9P97WR2BZXB0nBWIkXhKuAbhuztFc+RwZP+4+yuodzsbnxYRkMLldm+0znKY
yBmyQIn2/FxB6g2RXgDKijtec39glYVuPiheAEiBYW9r06IQXnQgKQhsgiDE+bjId+SgKwL9
wxIEbnqlMazCWri90GIWF37XyblDRkBv0HpAqk3NGgJ4tpAg+xkk5XQ60GEt5y1091Y+7DLL
TD8WnLUr9YYm4EYSTMMYPJOYnToSvnS1jga8sy1Vb6GMe19Eeearb2AyN5aEyLdIhtspG81g
2rFSOaCyZWLcVGvRB2Wcwxvv3HJ0t54IWcVYn/pAr/IsMWMh67OVp7b4Z5YomlFZYTA+JkFI
4wM0nAlMy9FLWXcozG77y3nR0k5oCPt2G90sXeVxzwHSOHxL+K6k2khWH8xQxu11/g9RETzd
IWGuFxS+i/IoTwT9ofO3nPCsM+YIimPLe+KWK74UdgOuIni6gL4ykUd2juNkiPDcDbv3gyJT
ilUrs1BFzY7E2coBdd34ECtTBSG4PZsc6tm5UWU4r7GwknOx6PwIkPShRpYfb5NjhvyAXFG+
37Ohv3bXX7oJLmHUtUKP4Z5OF6Y7gOBL0V52TObTqSuF/mrulLHj/X0gqvsRXPzl

/
show err
--METADATA NAME:OBSPROJ_UPDATE_EPS TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_EPS CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_EPS TO PRIVUSER
/
prompt Creating procedure OBSPROJ_UPDATE_PROJECT

--METADATA NAME:OBSPROJ_UPDATE_PROJECT TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_UPDATE_PROJECT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3cb 243
khYqJ/JFgwCkCGIXsJhBFQbKoMkwg/Ber9xqfHRDaGSlOwrDLt335VreHkg4edNsKZfc91fA
+6832SIcSd6ZBUZgY/KzA3OK/gYWYvZ+OfDK1Yygz8DWJ3XpwXJUBZFj4Zf9j+HbUOpNx2mr
OwUDy11wrq8ZfuFTF0UZZRBPbEcUphKVIZ4eyeJUXs6FVFiaWgL90ecgS4RtUCcx1pWHzaVw
GEbhx+Gpa4mDrAke9KfJBLG2LB8rQcTXwUhremn45zjDdbVuXOPQuhS641IcRUaVmRvsbGaR
1uLNtEDTJYSrJ4Rx1wOJqHhK06hkdk/2w6cMf7/vqmPvTlj2Q2c2pw4v1gwdLPLA2B7h0Mp7
tfv03015dyITOdUNmNnxldGIF3tcu2qnzCmFzW/508/op9s5eoeNghF0Jr2LE3ykLTwJ55oN
e2mtnKvcfg7L6+6rcspRzOqiWb8znTqolOo2jqFegdSz5gqv4im/pB/nCtJzhs0Nz1nuMHGj
kaobqu3P3L7rkgH5g9Gaui5zTDTCAjKTMXYlpxvyA6Xnp1taEri6FD9ESLz7v175iA==

/
show err
--METADATA NAME:OBSPROJ_UPDATE_PROJECT TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_PROJECT CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_PROJECT TO PRIVUSER
/
prompt Creating procedure OBSPROJ_UPDATE

--METADATA NAME:OBSPROJ_UPDATE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_UPDATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
748 3b9
pbCtxl0yaDX4fAwftckXiU23Igkwg/BcLiCMfC9V9s6UA0nxXOryJDPTdx37sAEfdGXoVUHY
fgZh9T6ivd5cJiS8Ya+9FGmNXnogIhlHetrzvaRdGzY1V/Dv0/nJoV2DjoiE4+UPXxnp53p0
eN9S4nnAOdHsMfSur6LMfstftuP5DtopN7dwGIXLxvS7KDmDNzqHWdpOwz8l8MqXSH4sFUY8
+icLLw8+htGfcF902t+mSHVHO1cnuDDfHJOewEv/XpAmAIHzap9QuCKx/8Sx48qLzp/TeI9t
CFTaWtPa+CZlrrONB0RTCyK+Ri3SM8l8fih8KxBKyhTKuAgNCLucPXqv1NF2qMCChWsAfc2g
ltGJhed9KhXlEbfBrrMVWA142TMb8USoqFhnS1WJS6MflinxanaHi5NFRs0nrZat1ZoraKCR
Gp4fs72vZZTTFDRYAcO2TfWoqygKbLtCIWEbDNQcvJv3JmXOUqSTmejvNNUC9d87/xty+BMa
0Ck5ucQ6UVltdptRRtJCjQgXQZzPk7D29cHGTQMVKR/GdWMGadjuJKq3HVWbhtPN+9/+MYk1
C8iyLq6r0SuyxMNipDacSRsrQr22oQtBlmztSbwWMRDfqsgBR9rrw2ct3Cx1yy+3l8STYdnY
/TuMr8cTmXpw4hpzrfYmBoc8ZLXfpBqTh1ZCbTPz2swES6VlKOht+WZJawaHOfvAADWUR7Jy
kSxt4BOcaizvUw8fcnAV+BITZFcTpZKFsXHWYmE9QyLkellqkjXyGoONFYHs1ZgwrZKW/Omd
FUtpO7xPKqjus5ZWXLi/vzPEu85EKWlx+A+sPaVpn8dRrU8Rp5tV2F2lgawua1OFgOB/gtM5
Z8zKbds8f73zm637kXYo0pwBdl9OPBtUL14dEFlOWxaZPsJEmn6JMNJWgRSQfOd65f88xCix
kAYg

/
show err
--METADATA NAME:OBSPROJ_UPDATE TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE TO PRIVUSER
/
prompt Creating procedure OBSPROJ_FULL_REBUILD

--METADATA NAME:OBSPROJ_FULL_REBUILD TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_FULL_REBUILD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1ca 1a1
0JuYPjkTrxUcpVEp7FZry9t0Jakwgy5p+txqfC9DbmR1uqM+5uP2ERrbQaA5IKsFYgCTYvxE
qBjyOqobDPNJnQEhTuR6rTdl86werEn+bvgaMhuK8SXCVDAVdcQ7OZxmtJF7Gp5gs0aBFki6
0xOnHJzp/Z6m9xZX4cDR4V4qEfsqGOeY0ZFsWw1JF3BT1NPrVTmtqSC9eUdOiZ7P3PafutU1
m0DjrXDnlzGqP0z1UyunxqWU6RjnlwSJ5QHDh5YkTyAHHr3iB4bGvf/Gu2TZOu3YBzbHYOb7
l9xSDcdBYs4KZkL6Em8/I8doEnEqbJJpK/lE/grJGbgkAeJIATvs/eVIXNfTjAEAGWkA5DL4
d90d27KDs/twAPeQi8iqZJKrcJEViIwG2zkX43EfX/yYDz0rvxI=

/
show err
--METADATA NAME:OBSPROJ_FULL_REBUILD TYPE:GRANT TABLE_NAME:OBSPROJ_FULL_REBUILD CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_FULL_REBUILD TO PRIVUSER
/
prompt Creating procedure PRMQUEUE_ADD

--METADATA NAME:PRMQUEUE_ADD TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PRMQUEUE_ADD wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2c4 1ad
SMD68lXliY19tei/OoSUMJz8mMwwgxAJNUjWfC+KWOqKY55aCk0axFEcdBkJCnBxBf30t7W1
bYNTqFAUQ6YekDgAgmEtXoDxYjcthni2Xi8Jb2P6DW/vNyW4b2H4jjNGcGCxWyQTEnnGzbLD
ooptiyMFHaEsrFso7AeohrAHMKvIlQR/KLfItXzwLSfCl3L0jEJ++uJfRcVG1ab/ioXJCybA
xjJzbqB46QztJRIGBRIYSeenlywSm6g1Ll0WpJksJD+jHUab7KToVFEAFJATCTCjH96ee5Z6
mFAu8XzcNLVx5oC0i1/I8UwZsMa1h2U1gKP5e+a06aNsmOBwwGkVi33zaIrmcvKnPQmWm3j6
ynZvYXrKfjZ1CocDH37C4E7qmyPAUv1IkMRDyberDw/lE/ZpKmmigNfrKFW5A6A=

/
show err
--METADATA NAME:PRMQUEUE_ADD TYPE:GRANT TABLE_NAME:PRMQUEUE_ADD CHANGE:CREATE
GRANT EXECUTE ON PRMQUEUE_ADD TO PRIVUSER
/
prompt Creating procedure OBSPROJ_PROCESS_QUEUE

--METADATA NAME:OBSPROJ_PROCESS_QUEUE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBSPROJ_PROCESS_QUEUE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1153 56f
I9+YUxnczqi9zZpu2U4VlxauYOMwg80rDMcF3y+5k53gIImrlQtC7AyOJ0Bm6mW6vOGpn/UG
hd8eTZCD4hSuEoXQuwbpN2VzXwVZsENfonAtVFafnVXQRNmEX/JAyK5Cr5ssCubyV2Qip1Tg
ZA98jj2hyGeHnoWX9Rh+5/J1m77TQTZWesu0sw4fuH37RmyGrR3edIQ4iqbbJ/cL5uYO7T2u
UwTlN1SOTYA0buyIYkp3tbMvfXxhTRU0R9svU+ei+t5voYyCp7D1CScorQBgRRjsXJPIZs6P
oYDcsDQGWkGV4O73h8jp17MrB+TCDP+oLxemEK5YXzRreJkGRjkdJUeTRnTomd1ZTwRE4cbt
TOdLj7VKHreMZDKBt3y2aRQ0GII3x5ELPgzWro2VhJNaTBkm7x2fu3uv1+Y7JHt6enYWLR5k
A3oRfpellaQzbkthsehX0IISt/4idkpcBkbjA61JxzXDKXt9vxn25xmVwJh6ukj81h4D19eS
kpzWmiAeBexmddG1VhGHTyDZ/QnleBlLvvpzSbT9euBYPQWB8uzPsLL/w/PgFuu0xWBamzTK
AlWUPfiyX9Tyq3KgcAa/F9x2C+iO/XoKFjOdLFDMZrET8OaZa3BjrpUmzxwWXJiK4KkhdHDG
YISoB9Ep1yvqCtcX/ZkOzpCxE9f8/NOnJCAeKlS3+HKclsqb8mYKgoYdJo+vRSKdhw9+j9A9
M063WcyJM2HiHpqnXYY9AYYS6xEB8X15Q+tCzJAJiUtmx6EiuxI5L42+XAGpqHiyitHkjpkA
YBijel5EmQ67LdnTqPNmaD0Nch9xvAfwoF2Fz7t+QvkeQ5KSM/wV/Xs+pQCEqEbJpAdJY5ih
ITIACciFAHxezcd1sCbSDy5Wut6a+AI/1cjOtznv28OgVU8WC0UToyJe5iqDs1j3KcgxCRHn
pR12J1PNFLYwDIH41uXnbXntbHq4+JkqtdhZ08TAM3svQ793Gj7uMGQ8pAUgbvAbCvDvO9e3
nyR++AanyNiUkVYXh8SA+EVAHzPtfOvR9b4RUtcNhf8k3n8sQhrFryAlgW7Jm8pFIxK/z0cB
0A5UFBZQEiofM+sXrxlILAA7FPjEm5I//7hY0vMZ3RMuamCAuyFSRXdJQjay0CEPIXJDL7FP
INksi7rBAWg1Ew///dx0+T7/EdQnchKSs4+d6RTOfPcvaf2y+HNi12BNnmhECnN8d9ArUKYq
fpHkXtuOgDN++tqY3QJU41eaWK2Nd/frPn5kbGpKFxb3IICGc5S34Pl/azx1e1X+SIQSdWIB
6VTooBzQQa+Jv7ilZTzbnfcqCKo8z0Q82yBy7M492DH2H2/MbrqJkEO0XOOQbBZtu5idpm/o
C84=

/
show err
--METADATA NAME:OBSPROJ_PROCESS_QUEUE TYPE:GRANT TABLE_NAME:OBSPROJ_PROCESS_QUEUE CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_PROCESS_QUEUE TO PRIVUSER
/
prompt Creating procedure CLEANUP_PRMQUEUE

--METADATA NAME:CLEANUP_PRMQUEUE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CLEANUP_PRMQUEUE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
b1d 4c8
PCSefEuJa/mwu0PejlkViPO2fi4wgw0rDCAFfHQZMZ3mnGbcnKuhN81QIR12E6Ffg6fV+hBu
X9h/PPuTJb4pYYSq5Bb6chQznxHHGKIY5Fo/FKR//Kn9gspKKJ8EgKHbrB4E4HxH4zdaSH5P
UFTIfMvo3Tn80Y/HMr8Lghc4A068OMfWyP3LrMOd5idBKPgLPp/tMdjT9tYWdshyvnbPL8jn
lqaJmGGpBoO9DGr3craWjnxbK6qR+LyJ3D6NOCFHYgSl6bni0eN2zO5p4WAgpKsfvKN6a9Mk
ZrKKmKJQotU98BjKFV6Zz1Is+z5l4sscSXR2l3HryJLyyEZh3Pohj72dMztmDfRLsCJ0iRtv
bL6sEs3oXrbmeVzJUyWJSTtj5cyp5nyyqQmL219eYHVtEY3pSswL39VL1uH/Du7XUH3JXzlj
zBC/mGeuLpGcsmBdrvSkRUaZutt6Uk2ZkeYjy7JmJrEKHnBYkYOWSfAV8PA+R+1QyMgCpRWt
rgS0SBVEatY+iHp8hQgPIA1oYp3RT14eOJDReJauK4lzzjrxvBrtM3jq3pJdeZ/eM/a+uWn4
oPwm2HItmBQABGFMZvhEA9N7Djcpy3uKjW297v5xQ4pZHl8o4YnwOItxdvVA5iNIRdy/Ju1g
3ZG0mrtl0isEFV3Qkge8m/9I348F6A1GFhwD0jpSmIcN1dBAau6dzAYhMCjjzOwAGhNVm7qD
REsdhwviNGIVcDoHeaokbTtAg5Cv4Ywn9Sps1+u8I6nPYz2KIUrfzqphv+rHsZ+vlZEWrhnY
NVluWj02nWhPteD7a8Dxrn3+7DULY8Pi3DETsfmhNwzyr8GDCQuMDuAC+Yl3QvSA9k39O/Og
I/4BqoGJNxxSUFB3My/XvPozaKR/MVBHLuAjNFj5ru/nUsx91q7ew9imL//mSMjeig+oT8/6
CvGqGAkNspE9eAxzvGhlgdlgRBCWpUbgpVO4LlgabQeHheNUK23vClHHeHnF/HengRqV5SmB
HkwbWMNWufothUp9eBUToGBKlsYNUfquTTSHm7vG/01tB7gHvmq0kb2u5sXJFvUKZtkj/LeG
XssBkB6KcqTFBpw0Fp1mzPs6Fp1pl2TXIkIQbADxYygFfgEi/vryLrCNAjtEv8uiFYzx8J5v
6Sdlh/OguTp+w4S32h41p3mCmxDHpb5t0bOWM8V8bw5JX05qD19WNF4=

/
show err
--METADATA NAME:CLEANUP_PRMQUEUE TYPE:GRANT TABLE_NAME:CLEANUP_PRMQUEUE CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_PRMQUEUE TO PRIVUSER
/
prompt Creating procedure WBSRSRC_VALIDATE

--METADATA NAME:WBSRSRC_VALIDATE TYPE:PROCEDURE SET:WBSRSRC_VALIDATE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE WBSRSRC_VALIDATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
db9 4dd
UjRPaC1HClodezS2Fnhl9M1/bKgwg9fqACAFfC/No3MYup4MTeC0pAtTpmKzSmkYw1qX9Eku
iOGgLveRPsgsmu/p9/Fi2i6rDrNwhcaGVZi/LBrFPmXssfEVPfKhbAPJDFT3ti6MU/Gss0CU
8mqnhYqshZbeNpZCxaENf+NkUTzdHsDpQ/Z+iSeGfvVa8eNNhdjxLqGpd6O4zBijKqPT4lro
ma8fTQ6/jdDXvB+eFNdGRwttjPwG0cCF6mMnd2wTYWf9Litf6IfXTXXBiaMX/K0qaoq9DduE
lr8WfakFKi/2xhrM4PLZSsUbzjnARRsq6y/CFz0wcKDEiLYubiFXew9AJC3pCdJOr8jn4ino
KrMobATijlyegnBvrHfM8NKEJGzJPoaSdQfYp/JaU/GFqQGuzGCCsqhSPqAxoa+ZdsXqJ/Y+
l9ydlExMadg6y/glB7M9G+5Uy32A6+gfnuipsV9iURHpeETQeqeja6288EncvoVJvXB04N1G
AvexRpPcse2OMqc1D2kcsqNbA1LfD6LWK2cxohkQnfuf+KXnxCi4ToaxhruhCgLyDaANrn/j
4M0KXc+tK44WYlfRxmBJAqF7oXZ6vAF/hj5H0xQRbw4x5Vgl9vAzHzXTxJtZd3FJ1NhvLhP4
dd6TiS2gndQu8VQsiT6DuR9RwEfv6O/jR4RkmXnAxoaoV2S4480BfcPtnkHBJjfHOU7b+2E8
do0dLsP4Xyc7SmtVol2fyref0KEtUBLe+b/bACIQ1Ps5MQ8L+I6FPkc4ewJBMWc0IAvS6yOW
bqHMzErXxLSud+z8ihX1Q+XJmsq2RyGsLM1hM4SdrgrtSM3ZKJGMGKRnK4lUHU4xfjwtKnQg
aN79ZAUvOkIpjN5JLzm7O4Pb8A7m4Epjwnhu2JgwQXT/ewzy1IFnMFcTDnhraC0Ddu50N3Su
CYIDRU4XQjaShcvGChNnB55J1HCwi/06TFK4IVF4vTG/nJZvXjUPnFQC7fHO52nqi3sqb0E4
8r//2NNKjZBlICnnQAG1fIhj3nr4OK94Mvh09yqcI/4/UM2NdymHdilq6zSdXH5kwflCM7Uk
1O125LJj7mAytJNkQC2xJ/i1gswG949k52rreHGIpdiSRl4S8F4+LNpNghuOMklMVGuxiDtH
xqI2O5TRWWVaC81G5ZnE0QpsuDXlH3HBfXNzVQBo+XrOy9a9egD7P8ppPgwDf2UfAiiqpoNF
Vos=

/
show err
--METADATA NAME:WBSRSRC_VALIDATE TYPE:GRANT TABLE_NAME:WBSRSRC_VALIDATE CHANGE:CREATE
GRANT EXECUTE ON WBSRSRC_VALIDATE TO PRIVUSER
/
prompt Creating procedure SYSTEM_MONITOR

--METADATA NAME:SYSTEM_MONITOR TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SYSTEM_MONITOR wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
39f 227
m6VxqkcdP0FR4nAC2QwNhgMSVb8wgw3xTAxqfAQC7Q2dZr87aZHj6v2H0oZjbaChLhnOUpRF
Yl/8PP8/qfkS63l78wI+MLclbrzBKa2h0TA2LdNnXdaihfXUiOnRbmfuidQUCeamhDsU5wfy
B8i6+1rcWJfmL7fuALe9LdBnoutncTCcjLN9fi8aDfEE56AndspZbi/Tl9jAyNTqb5i2zZ8O
4Bjs1G9aCK8LxS5zzQaXsTJMQgNDWJgNGzjxHto18yHAkJvbxwWxYYL2eSTVmEVSzVrqIUyT
Yv620y8+DF0/fnAjEmG70RjidZQ7rU+UTrABXv49Bs9toCJeCxDmXvVU4tcIzlBW2RjSO94F
wuLSzwEY5ZoRTsI+/QO0+LQrYxpuKRYCqSZxahDcRNsZacIkIRIhluWxE40pR3KFTI0PbigH
IbxmT3IGfeOB2FUhgYxh2Wjxgccgkv5BMBbHr2QyImhlPoHw4USYuF0gKbywOtEaNdGoG1qC
uCioc9DPtbiZZkEBjqr97oVPMqmVt7d4BZur2g==

/
show err
--METADATA NAME:SYSTEM_MONITOR TYPE:GRANT TABLE_NAME:SYSTEM_MONITOR CHANGE:CREATE
GRANT EXECUTE ON SYSTEM_MONITOR TO PRIVUSER
/
--METADATA NAME:SYSTEM_MONITOR TYPE:GRANT TABLE_NAME:SYSTEM_MONITOR CHANGE:CREATE
GRANT EXECUTE ON SYSTEM_MONITOR TO PM_BG_JOB_ROLE
/
prompt Creating procedure DATA_MONITOR

--METADATA NAME:DATA_MONITOR TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE DATA_MONITOR wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
c2e 394
QzMN3emaP40tetEKvL3R8P6LJrEwg9enTCATfI5Av5AP7trjRuURgz3lTFfOiaOCLAMusIeT
GlLvIeGIqPhzgiyo1mH9eQMyCY69bU5BxxydIhsGa5kUi6nnp1Q6OGcBhRdXp7GJyniLduEm
4PvPYJV0a/3L00QtnTY/kySSFYR4dZixdZ3EJFZvbUIDdG4HcX9T+0BmG46yFDBM53+hRttx
ZsNJAiN/J28UgWsPcayA1u74LCSoUtVKf1cbw8XyWTfDGYM1R3Xr5JMUMW++7YNHOzpaz01L
0maBjV698kAYAkF5O7fFzBtXOxglwMgNdxMhgArX0dXf/NHroT+0DVEbPKIWnPvLBoXivley
SjqOAdliYZhZ6iPYzVTduBSpDkWHXubvcR57sN9ZGD6too2JXOwgg6xEdbTdtkxZ1925VFcu
XcUxHm1cwP55Xm8HzxCzaSFlsYOFVjIJ+vUKO9/+9k2faQwQD+Iy3xqX7hi2cGTGeyssxxDh
Hq1/qF1AvK5DYy0h7KSqrscTfsbiSQ3VxJooklBshKSClFK1DHR/X+4uULsIAFp/WA+xTqoR
U2qHu/7e93hBFo2tMilM8T6G0+sIvAIROZAvIXSrHZujX0V1PguhyMqKvB4XRQgoJpolbsE4
EtLZjGn45a1wUYPZavmBGHz/Hm27idFUCqKra+xpk29s6yT1yRxvTJmQhixV6NTO/4/FI4vi
AD13BUixiJ/ZbvxdS9wK7ooqx4ztCQ8Azyx9tRLgfSCtNK2X6JhrHRO+OH3tbjEdc8QBn0FC
uuyCx0+LIzvcKfg12ddC7VH7Lw3buRfQB1JnQQArLNd8YL+SIXaqhJDZlOlhK4GZhOpGX3cF
Nw+LRofHI9q3t+TUTLC7za9o+wOtuz/hImPivQ==

/
show err
--METADATA NAME:DATA_MONITOR TYPE:GRANT TABLE_NAME:DATA_MONITOR CHANGE:CREATE
GRANT EXECUTE ON DATA_MONITOR TO PRIVUSER
/
--METADATA NAME:DATA_MONITOR TYPE:GRANT TABLE_NAME:DATA_MONITOR CHANGE:CREATE
GRANT EXECUTE ON DATA_MONITOR TO PM_BG_JOB_ROLE
/
prompt Creating procedure GATHER_FLUX_STATISTICS

--METADATA NAME:GATHER_FLUX_STATISTICS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE GATHER_FLUX_STATISTICS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
34c7 a54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/
show err
--METADATA NAME:GATHER_FLUX_STATISTICS TYPE:GRANT TABLE_NAME:GATHER_FLUX_STATISTICS CHANGE:CREATE
GRANT EXECUTE ON GATHER_FLUX_STATISTICS TO PRIVUSER
/
--METADATA NAME:GATHER_FLUX_STATISTICS TYPE:GRANT TABLE_NAME:GATHER_FLUX_STATISTICS CHANGE:CREATE
GRANT EXECUTE ON GATHER_FLUX_STATISTICS TO PM_BG_JOB_ROLE
/
prompt Creating procedure CHECK_BACKGROUND_JOBS

--METADATA NAME:CHECK_BACKGROUND_JOBS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CHECK_BACKGROUND_JOBS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3fa 278
+u3Y8NSTX1XqMtXLI/rtVmoPPu0wg41eLvaGfI5oxz+VmDGT8SUu2Rzgo0s7wdDfp9YUWyPT
8vxia/SyLV7n0sZkkbH0mDGO/G1Li9d63ove/wksodQv5OdzgCm++QuFJV/TOsgjz3ByiJ6+
uBfIyeERpzCFYB3OM7GFFHp+kW/RTu+cLkCPwDsNj6HyrZ5esTUzXSN99QRSRCdHVtcc9NaP
hMQA9+Icr7u2NRhXrxyvikTilgk5Toicf5QEZoLIT388b79DHEB/PeMiyOPehWyEnFrWMcZq
cbjdIysNo+XFnaPlPR7Z4mgfcurkS2KZHtPvlz3iM8BcbYHfxOz9z0hHROskn8GzfdkbcJXp
kLsZd4uqCSyHgWhTdV3+IOGwGTejPUO5wO4u/c2zkimkpUkZApT8NX/7fwD1JRTwdCbQAFvs
5LWyum12RMZwxIKbAywQauMdV5Xn/r8A9Kjj5ymP66AnXNnae6YoQ8LhYZYYMgjhz52jQ1yB
F50xdlbB24LQ6U7i12//V0Gohg//QpxY5SePB+X/xMiJlaPaEYNYSF6ZGZpyR44mIZZjeIlw
9x0vZTzSCLf5yhgbxOsUQcAZSh0JUbK4OSMyP+RECjRz+g==

/
show err
--METADATA NAME:CHECK_BACKGROUND_JOBS TYPE:GRANT TABLE_NAME:CHECK_BACKGROUND_JOBS CHANGE:CREATE
GRANT EXECUTE ON CHECK_BACKGROUND_JOBS TO PRIVUSER
/
prompt Creating procedure TA_GATHER_TIMESHEETS

--METADATA NAME:TA_GATHER_TIMESHEETS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE TA_GATHER_TIMESHEETS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1084 57f
MB5LEpwzUIpFK2YKIFg+Le2Du0Uwg9fqkyAFYC//gqqV0vSR3dOn4V3TzmcMDPR/6dMSFte2
7t0nON3isoDLL8okIgOcn6HyQBNTSLJqJblogppHSrqDR/rmaeF6u6etD/ODCMAutBgv/6xN
AUYtwiaYwPsBsg1UT9PsZxPEYnnfQj0IrmL3iS7cwQpu3Lal46xrRTcUF+0TpmQW7qTChO9T
hrec9mHDnNxCmMqUNST6VHhWWvdt8uVN5VeFk6ZLWHgqSaq4+rQrEYiuDOYXECX1ou/pNYs0
aFeC7yns/rvc+sLYWxuaF3xYND/+yZFyLxnyFSLPNNJ1FL2qATRuZzUTKuMz2MWIB9BUbOGH
AWWlHomxmaVu3TbpvAYawfJ6mVDykw6bp1BND7QEP9nKfrFrJUJu1mZb5oBAmtDB/vr6+kdV
lyMGeVOtnUU0qU4FBZgTZMHqS/ifmAIe+JbazjQCn7J4v6mrDXYYvaPZuzZMFpm3px2U5pXv
XTGPy91APm5XxIjAR60b3Hd6I4jWRdv83+U8/BptqZ51e/xlVAJb2NXRWK000SFykeVqJYOZ
8O80nz9ajBb/DXm6m4U9eAjyMUEpnV7k4/BTvduEomQGvQH10SRc76uIlFi5Ekji9fUYPusu
CvE69cvRadjYqpdeoVQqrDNxAXrBrDJOyWs5CY5RBFXC+HKxnJh8CK7n0R5t2EpBWuML/eg+
0CgiLD8AyhzNdutX5eJ7Up0Zl+377u/6FSnzV7V4pUMSjXBvIlMj7q6s99nlorN6F6JAcYQF
6OI+6GSJEi8/njfDhax3NOXs0EzMQwxYu1f3oDb4FDe3tAfmx5caNS/0/KJ6rBHTPVJiYnhN
5VvT92YHYcWr+EyyxBsykHpB0RxxyOu+uZVrq0wc2S4HlgnfQlUfJUO75Fs9d9RaHAF8pttH
evZEt6Ege3xtO+6pBDjR/YZQDOnitgryE/rs+N7Cq8tyJXMhc3AD67gkhOh/1o+ct9J9iESf
Wlgp819Ajo/fC81tcHyjr9yktCRvZly5ygLo38PQfXb6QLfmGv8t2MQgTaAmpcL6hx9yMZMH
1Hls/LiuUSg3CCT6uSRZ4rUEcBH5XqXk9Ogpj/RCcUHXcHgQtaXjeBCP0DrWmde4YzoPeP4i
mfhbMXlZST9NSO3PTwLkmyMen9kkUlg0tcLt1i+8qlsZ9Zss9BFdNYpB1bVb6ebO+MlbHwUK
zQ/BmM1EikjLKf3oFEGBTAP4pXe5amqBFQ/VNKEzwzszZwdj1r05r7jvonZ93DaDTw97bSLf
SjRuqx7UL8JSyShIqy2gJPMQl2ogwQtFfTobp9lJTGOAxjz89IIYYUCIlQpPtPTwXbP0DSOs
4Iru8A/Jlj+mw/p8Gg==

/
show err
--METADATA NAME:TA_GATHER_TIMESHEETS TYPE:GRANT TABLE_NAME:TA_GATHER_TIMESHEETS CHANGE:CREATE
GRANT EXECUTE ON TA_GATHER_TIMESHEETS TO PRIVUSER
/
prompt Creating procedure TS_AUDIT

--METADATA NAME:TS_AUDIT TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE TS_AUDIT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1529 725
4f0nIDgGHyhjygvGj49eihDL4n0wg9fqDCCG3y+5DfmUijio/S9GVwd5/Wpb6VFWKmEWyIm/
x9NotJhSt/CyDEgShdC7pWzMP3luim/23d8qhMsHmnoixYwU3TjcfwbYpU587pBIYIiyGBSi
oRglz8DwJm1labvySIJWNl5POS2uljVGjOdbelgGZhd1udFwdS1GGmJ/nlJdwQvL0IZSZIYD
y+YlfJbhl2kVL5XznsCX56Sp3PBpYPosdDIdfFwTnLro+TaxHIFw+1SpD0YEHNb2FlkErgkE
55kVth9/uU5ulPu9LW6IzGU14ax1XY6ztOlCn4JAMhackih/OVMRij5aQDn9JLICd6lbwACJ
CqA8ftqivpxV4/PlPb6xyiGgswmXqRp2ql3miFRgvnJInqXKq/jvfB4aSjHVcuZPCml0/fU5
pFR7eV9rfnS5auvnDEZiPUNBuTmaufpW5CddmJwfACYaMMPbL1qUY0i16v7tCcjOS3FWyuRL
0WreVHYNVPbQYgdirqMii/HMHLpoFEEEf2Q/P0llk1gOFHvjKpF1R/XwXUZ4LzOW0SHjG96j
CmQIFqG/hjIqonP5+JqqtzXcZkwayJT5I+2Tc+2l2X4Gysxn8jjZapWGBk7Yo1dpN3/czeXe
3H1mEI4mORfjMj/EIhFeWtPTCkhZCwQcfW8l9im/srSWuA7Z1Cwd027rPq+amJ7XnAENz6z7
dl1k4K1bH9knK3nZBkgqB2p9MucAJNp968mBRHmX11VzJ5g1ExIfebEo0HD7eZA826q5HxNE
WaXlCbR2UdUqdQDXAsN1UMAAfpax618MhKCBPCjgFCq6ZHGJQ8CBNvHuXII8l5g9Xg3OxPGX
2mJMJHEYwT/t8DFj7I0oRM4zKVIzkzar/J0ZP5hBhHpteb60dGTbIAgh+MK4otzegjbAugE4
NqFrS9eT8Ur1XsceGzz8mkjVHnGYNjklZRyC5EzhM9eM9eckN1AxpinWhB4uZpCF13J1yFm6
X3wo4AEJjdDiSMQ9oVsj3/l1uMytl/S/Pu7z+utQTYEPMAA4RPpCp8covJVXoVKx887LkMEX
3J6zzEXJsIdyViw4QeYvawodWHtcrQX/nI1nhLKmlsS7GOia/X1z0uZVHyUpU9mboXjo6cib
QRKzx/ZYiqdgcWrRItd2MZMP3x7IrQJPGzaxi8vELm+5HNp1cLRxZAHlrqRm/mpH4hFXbClb
5jf0a2SX/cu36qv2YIRzGy/azOT3Z1xxfaMaKWFUJVVjlbVEaRUP4ScQLxHycZAHgkLE6UzH
2Y1EsGAG8V08TNzLVFkWsYkbROC0OpPPZ3DAl8pr/fvkNfteeWl6nql31jPXdcjQMxvspkyR
UibC6g87is0uooOtvLcGJTWkdgNkpN2f5F0/m9Em30T1ZbjHnjvipZNkkFFRbN2VOqdY6z19
QvjOQm+sZh07rDtMJqjSgy8jskbrq4Q4FE4zfGidrqZuQbJNFw+B/Q+HtGWK4FAKrpSimE8e
/mNVxTXDbgl2yK+dniSEree3vcl/gHFsbaYA9o22AKVRaxlbtP9t9Fxiq0rvsZb2ZiTSwGrt
t0QTQg8puKz9RPOeqHEvy4euKfcePg3isPAcrX74wZwBXGKL3MehetY9e4Ax6yWda5adGtWq
DUmdjYszEpu+pDo2r7LsDP/QN+sedR74OBqt2RUpE7a2e5tC/eqkxJLFknvNXTFfnxWYxPdo
/T7/M12NWRdMUvUZ1o9+PwXHXSohsWXA7M2gtyrZkK9SkOrrg5mhzVbyCtU9NNmvtY+wtaYF
UBL/

/
show err
--METADATA NAME:TS_AUDIT TYPE:GRANT TABLE_NAME:TS_AUDIT CHANGE:CREATE
GRANT EXECUTE ON TS_AUDIT TO PRIVUSER
/
prompt Creating procedure PV_OPEN_PROJECT

--METADATA NAME:PV_OPEN_PROJECT TYPE:PROCEDURE SET:PV_OPEN_PROJECT CHANGE:CREATE
CREATE OR REPLACE PROCEDURE PV_OPEN_PROJECT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1a54 93c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/
show err
--METADATA NAME:PV_OPEN_PROJECT TYPE:GRANT TABLE_NAME:PV_OPEN_PROJECT CHANGE:CREATE
GRANT EXECUTE ON PV_OPEN_PROJECT TO PRIVUSER
/
prompt Creating procedure SOURCE_VERSION

--METADATA NAME:SOURCE_VERSION TYPE:PROCEDURE SET:SOURCE_VERSION CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SOURCE_VERSION wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
6b a2
ZCqJxJG2O30SPGqhSyjaQmTgwagwg5nnm7+fMr2ywFznMyiywJ/wKMeynjPS/oYJph2yAqZN
qayqEePmdQvIAwcLyPcbnAt8nLcKmElapFkCjTtFazfi6t6H5eL3N/f0rGs3jSY3rIxkRSqc
Ck9tKh2m3buryw==

/
show err
--METADATA NAME:SOURCE_VERSION TYPE:GRANT TABLE_NAME:SOURCE_VERSION CHANGE:CREATE
GRANT EXECUTE ON SOURCE_VERSION TO PRIVUSER
/
prompt Creating procedure ACTIVITY_COPY_API

--METADATA NAME:ACTIVITY_COPY_API TYPE:PROCEDURE SET:ACTIVITY_COPY_API CHANGE:CREATE
CREATE OR REPLACE PROCEDURE ACTIVITY_COPY_API wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
13d 113
1zCVB3xg5iadNKfLKbf/Xk9P7mQwgwFKf8vWfHTpmNSwpefT/FCNPr1vookU8uGJPv6d6bLy
fVCVwkG8+aoiVy5qq+dj3MmCKYWDOu8MIA777rdfx9/WSx5RFvXmfAVcerPXL+kuJ3jItJFQ
t3RkSghc6FmSNUo58kK3IO48RmMaUGxKMO6rB281YKbpjC2m4wFAunN6IrUaEydoOAhdwSse
S5J8Ym9DhkNhWw7QG09fA3oNrpGzY/TmorxJ5nQlovw3ilAkvK5MrjQ=

/
show err
--METADATA NAME:ACTIVITY_COPY_API TYPE:GRANT TABLE_NAME:ACTIVITY_COPY_API CHANGE:CREATE
GRANT EXECUTE ON ACTIVITY_COPY_API TO PRIVUSER
/
prompt Creating procedure SYNC_BASELINE_TASKS

--METADATA NAME:SYNC_BASELINE_TASKS TYPE:PROCEDURE SET:SYNC_BASELINE_TASKS CHANGE:CREATE
CREATE OR REPLACE PROCEDURE SYNC_BASELINE_TASKS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
886 3e1
AskBA9ppeNQTJxSdM+vX8J2TaQIwg5Arr0gFfHRVMQ+v2S8XhayRxkSkj4VZUemneqFI67ez
DYhp2BEHIwCOtMbQwmzGSIafCtH3bPz3uwj63OKUaqBQ54txwsBYBI5x4N62AyrMbv0hQNWT
m46R92LMrmbO/vfBoxAyF940Q1NgukEbFddcOJp091gyqVcuIQUUkusEU6h2O/91oMiZXsDe
UvAjNQrYUGDeuOBQoPQ2ygHIzNiwoCXFCixoBjE5oeZjOkV0+Eli+Msat4GtGtPe3thBqduC
eAg2E3QFkNRcAyWR+sROyzAv7/c+DVBUR8+bhMFFqFnz15BiAfGo6fDlxgXZux89+YuSnw/w
4zUYouR6w+E+q4v8xMGt3z0Kjh5bSGfvjB1S8E/a09EO9fPI0YJe7CDgqzaw7WPd6L++hKoq
n3HBYxby6wzt46dTi/Gf6rwM3JmPws11acWweZxHtTYmWMUa8CRf7Rt39UMupcJ9NSjy0xJN
p91LLPZ8H3gEBrqDIxtLWCLeu+v3UpN1a9e8O4c+ZNkyS93qbjKRVwOkv/xnpdn/drWwcvgm
H4FvDzWKluS9R9RweBZziI2MdJzH7rE09DTDETHo7bzZ5n4mcO6RuVDlVV2k2s0P4/o47SA/
r4JIOCIT128HkfJJ5qa/SBNq9XuprTvXdtwy/BabIS0w2zA52mFs80qxjk5S0sltewjQ6H2N
3D7L9VLGHngRBTf+CTGUUgyEdNNN9oAwyeaIz4OW6GXxwkLmOBUNGuLELPsjF/qsic31vE70
zuRuurrd+2SqDpC1Oh2M+oVzdOAvvbybgQ1OHQ1NUk1nvmETV6bQ7gxyCs149/GqbngRoMMR
iFCraEho2EylXNCK6YG2tFU9vKwHD+ofnf7qaQBxh7kK/MZq19eGEfPuSjhIKeDpUNJgzL2D
NHFallsZmppVaoF5tU8CN6MUI1WMPIhDa9Gd+JmoHpu7

/
show err
--METADATA NAME:SYNC_BASELINE_TASKS TYPE:GRANT TABLE_NAME:SYNC_BASELINE_TASKS CHANGE:CREATE
GRANT EXECUTE ON SYNC_BASELINE_TASKS TO PRIVUSER
/
prompt Creating procedure OBS_MERGE_DELETE

--METADATA NAME:OBS_MERGE_DELETE TYPE:PROCEDURE SET:OBS_MERGE_DELETE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE OBS_MERGE_DELETE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
a50 3d1
m8KnB4HLK+V0CnbE2VExNkrFftMwg1UrzCATfC8Zgp0GhxujJhhhIt8eHQRJOGwEMRvYrhYu
aG/wNekRxHP4kLKO5qMu95JQzUT/wZhOEP46foBu8/yVbuHH6UUaz9xe0DnDCR4UJcWa1nyH
RYlP+2fbJlnq3KZWpwuBCUfwI0O4wrjOOj5USksr3l24q5eg8EMH8f8+TwbbVIzGbv9aRzVx
v1FwVwu+9bkHPHBzbQzOIQ051YwVYbPTDgNEL+PWWs5+OVN0EjN47IgXDPCDdPFEefapPkzm
mVVZN7Yj3ZOsMO6ZbhPpfXjm7ymC7S9FQC/Cd8cat/9UXzzTXNSxzzPxNEwXQqOJMiO6Im+6
EidWUMqLa6fefS4P4S3qlRxQTTTGhqst7y/jyd/nGeHJXGb/m8n+q5eMMRhX+CflUjzKfBjb
lMj1nqm331Av3g+OLyXu09MP0cvl4UYCa58yZH9Lcs7d4FToXraJsvz9LvVm8N4l+hD3MV2t
aWWtcHDmb4lxOB4aA91YjPAQeZ1FCIc7gYuHebwKeaMiPIzALK8LhM/2amnXlQ+hvF4C5Tw6
E8BWpaY6clqf52vmGvtMs6Yu/9AXVHODXdCYiqFjQ9bFGfP6ztDvcfSr6M+o4AxeYviXHBxe
EsEJmNqHZoE7PqQX1R9x5NoxG7mY3GH2gegyZu3tktoQQP8z3EMnXh0Zvd5hAgXl5GsBtD0e
5UBPkxCaLkwVRPIWfpdRUNF4ne5rl5fleDBU6uV8/m0cnD0rXIPF6q7FBzuDeX7jAiz/2lbX
GbIEbYNO4GBsk3QJfj3NlXv1JddD2blWtNaBzJp16GqrXgbnBjBV7/zbYF66nfdFqWoXd6XN
9Tyfi86qg2FYoWiKW9N8NVs+DsIgcx/sI2QTXFw4sgPhmYkKe9W59cr4jz4yUNJuRDceyNXv
xM2aISQ42WOWMtNX5KVb7mKJOg==

/
show err
--METADATA NAME:OBS_MERGE_DELETE TYPE:GRANT TABLE_NAME:OBS_MERGE_DELETE CHANGE:CREATE
GRANT EXECUTE ON OBS_MERGE_DELETE TO PRIVUSER
/
prompt Creating procedure CREATE_PROJECT_TEMPLATE

--METADATA NAME:CREATE_PROJECT_TEMPLATE TYPE:PROCEDURE SET:PROJECT_TEMPLATE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CREATE_PROJECT_TEMPLATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
5a8 337
908N+nKwz07EhhL6YERjZNuexmkwg/DDBUoTfC/Nx7zgh8VnwOqoTCacfsXzBpEmU/rfk0O9
Y4lhw7rjqRENqpp/NoYUujI7Wn8XyXrHShd2A4VjCkbMuIgyNi4LbxBj4lpEsuAsN/St+3Et
214gbP4401Y+76S8UXEaKAzRLnu5YAjRTCPmucTLx7uk3x5if4xmVXsiovRXmSl0+5r1QG0E
3K3+UWnJCBVejouH2vSWKAgQ9ga49VX8QoFoi813rHKZfOjUz+GEEeVojZqKC7sXrnk66zzD
ZlOK+eME0+465DkC9D62HEPTVfJiU7iiFTXyQE94c0mLo7PE4B/rOpGheIfjGRkjjjyGpPMv
/iF6H/I8Tv9BT213lIh2E2/shEGUJEFrJkoyp2pr4j/Bk5l5RJMyMN+SV3QMVBb+IdtxHkJP
TAidlyLF9PTRQ/z/CK3tpTSHBNm3bB9Hdm7jLmkGvBZWj5FcFy91EMpwurj+RLvdBB6zgTCo
2Q7Q4lCZSECYlmvYo7gez5qLL0/b0zpPau/h1LiXTZziVOrCQlwDc/S0POan/S32YAP+sStQ
R8QROd7Eh68zKsOAQYGdMBXrZDRGIPgbqlaXNDf8UG9cMWezpuZ9WKq10I6G0d3/pXeYqEJY
ZvJDIViEx7qiqhbj1IcIFBiyKXv3fYSahDwm3o0hv5l1h0dtq7KjsVqdFhJEGJvBVwTBvzsu
1FCzbpJaRJIn+PYo6Rqbn4Xs6a987qSluK4IlKToQmsY9WlNy7JS+esNu35v1P9TbovrDQgL
p0MuC32ehrXk1w86wxfG

/
show err
--METADATA NAME:CREATE_PROJECT_TEMPLATE TYPE:GRANT TABLE_NAME:CREATE_PROJECT_TEMPLATE CHANGE:CREATE
GRANT EXECUTE ON CREATE_PROJECT_TEMPLATE TO PRIVUSER
/
prompt Creating procedure CREATE_PROJECT_FROM_TEMPLATE

--METADATA NAME:CREATE_PROJECT_FROM_TEMPLATE TYPE:PROCEDURE SET:PROJECT_TEMPLATE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CREATE_PROJECT_FROM_TEMPLATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
bd3 546
ba8cm1Flddm8tLxJMmHUYfwC5l4wg5UreSAF3y8ZweQY+GWF4Xfdm57YLuX7wllJo5H0LyYU
+RRTSkVCEVaEwHyOhdCa947el8B7/mp84T/zu/WWKLtB79cD40cYbmeJt8i38YsxuxQGQ3py
b2xJmeyPuZV94bjMqFaGWM5Pb20++gC+JO9fnCheG6IzP0e4tndFKE5930dJTXoobUbWt3vy
1Zd9wm7UaDwJ0+y2hxkHvZFEu4inrESY96yMvwQ4Vv8J8wxunyCIsN73FLnphWmBGTP2+Bzt
LJi4lKmCn+ICQZDprnK/AjSCTKvHYCI6TYrO1iocbdBUJUQCrMa9mKIwPvpCWXX1Vi8Bel1E
Hft6IoflgNIq7yRObGyxH17AtrBNpHIoxraCWBaluvEzN44INE5k+MqXyh+WzRyDTA0Zzzo5
eXMl2NW0KoEPPSMo+Ks8gbkTjBlqsRh6lLWhGLyLsZeY+qqPc6khe3tADIOhBK0ldtHPnJRe
1E73K5vPIJuvXDU4ppB3tKVwmwpbvJlPP7YXQuPG1IZGH/DQ8FC9KkmjeTi6u6gn5T284YM3
KiD8F489TrnVuZ/IpKnx90o5a5IsAJqydpo3ViwbZToBFkQM5ByVyl25iKFBt+6/JetYr5qq
K7rONCcKZBN5PebtBSD8eZkTb7iZKgpJgBKtw1+y6WQjnhiNJPE7i4P3cMoMHn051xFENPVF
oyPZcY+iF+wYOegl+KJYTsjEcXpf0lleJusKuMcWsKvMfQOcVeJILwC0O+w9xw1kq1QqlFbt
hQydmjcbXw7QWNGJCmeROJfUipilkp5RRXdyHvbGz6bscdvgFK++pm8dqJ2b2IBe4BER4qwH
uqwL6fACZ8e30b0T4qwZpi3FUw+tc99m0PNrdvSHImuWXZLYbgJ6VsGT9//cnxUpgx9LLJeS
x7pIQZFDqiYPYa6lK5QTSGGm525bK+wZuwcO1OXbbhlVccWlnGYe92AVAzel2MtbQR/bgkIw
G5+uCTsXrgANPbNRJpgDZ3BMhhiEtvBWZ1Ske/makpNhbcUVjCvaZOHG/2svCLp4xrWmaLjK
TESE/2/rW5HEdf/763uZdsBS3oAkBpM+0TkbJ/7NS6rkGpkYDa4hcbQ7duio0EgMK1aXQtMZ
WglpADE6KKCc+7d1ozqO3c59qzhIdBre/Dnfuiqo3wUkRxA1Sme0/hcO6aOrVbbS5rvP1y+s
cfXKVUEGnJjGbkeYpI0vumU05cXRLab89eZZYpcJ3BxCWECZ01eOqNAXSmywv7b2i1/u8Psm
BCPt4oM8Oq4wfVs1zTBaLEEw5CkscWcprA==

/
show err
--METADATA NAME:CREATE_PROJECT_FROM_TEMPLATE TYPE:GRANT TABLE_NAME:CREATE_PROJECT_FROM_TEMPLATE CHANGE:CREATE
GRANT EXECUTE ON CREATE_PROJECT_FROM_TEMPLATE TO PRIVUSER
/
prompt Creating procedure CHECK_DB_SIZE_LIMIT

--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:PROCEDURE SET:CHECKDB_SIZE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE CHECK_DB_SIZE_LIMIT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
431 26c
Bge7fMsmvb/w9yrzvy5TS/HtOLowgwJer0gFfHRVrQ+vhFuTkAOjNZmOfwlnwjFgTQFb8W5j
mAQxyLquBfksC5HZx8KRmLSL7zrOzhQgfl5wMaNG4PCV9url/ylktFyDESQM328QxI2UITsH
RSqeeZ77IblsqbrebQ2gmayzb1T4/1EU4sAlFRcl16Zw/VMyeXfIqTQHjdj2GGbqm8gBz1p5
s3tVd6QqcUf9vuvoKkw+7cMlOJaqbi/lyZ4P9RDkq/6T4soesE/Z6EdxRl9qnpko7VOOND0b
UjvAGRvz64EU4DOlP7S1enz5KQh6KhfPQXE7i24dKs7J0mYATHMWwTHfQN+8iHDmvNj3y+JV
UJ4d1QfynWDjKiQzmpooabmqzZ2zGtBfWdplKcE1VWkEB5uOBLmF78EEB0nA591kf1dbfOzn
qjRSO6F3E4DGu6JhUyjQU4UwPDVTEsdPDGzaaELABUP3fZHXQyel/jYu6UWPCx30JPridYW0
ohvk+KNQCBmaOVhCD/2YS8Aw9HFut7UHTOP3PxriDOD/ZEYIEO5mG7Yfu+LQQ8TKwlYH9Omq
LQAAyRcS26o4vtOcY8wvvGYwXyTkOc7uRPU=

/
show err
--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:GRANT TABLE_NAME:CHECK_DB_SIZE_LIMIT CHANGE:CREATE
GRANT EXECUTE ON CHECK_DB_SIZE_LIMIT TO PRIVUSER
/
prompt Creating view PROJRSRC_VIEW

--METADATA NAME:PROJRSRC_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJRSRC_VIEW
 as
SELECT tk.rsrc_id, tk.proj_id
FROM task tk
WHERE tk.rsrc_ID IS NOT NULL
UNION 
SELECT tr.rsrc_id, tr.proj_id
FROM taskrsrc tr
WHERE tr.rsrc_ID IS NOT NULL 
UNION 
SELECT pe.rsrc_id, pe.proj_id
FROM projest pe
WHERE pe.rsrc_ID IS NOT NULL 
UNION
SELECT ps.rsrc_id, ps.proj_id
FROM projissu ps
WHERE ps.rsrc_ID IS NOT NULL 
UNION
SELECT wr.rsrc_id, wr.proj_id
FROM wbsrsrc wr
WHERE wr.rsrc_ID IS NOT NULL 
/
show err
--METADATA NAME:PROJRSRC_VIEW TYPE:GRANT TABLE_NAME:PROJRSRC_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRC_VIEW TO PRIVUSER
/
prompt Creating view PROJROLE_VIEW

--METADATA NAME:PROJROLE_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJROLE_VIEW
 as
SELECT tr.role_id, tr.proj_id
FROM taskrsrc tr
WHERE tr.role_id IS NOT NULL
UNION 
SELECT r.role_id, pr.proj_id
FROM projrsrc_view  pr, rsrc r
WHERE r.role_id IS NOT NULL 
AND r.rsrc_id = pr.rsrc_id
UNION
SELECT  r.role_id, pr.proj_id
FROM projrsrc_view pr,  rsrcrole r
WHERE r.role_id IS NOT NULL 
AND r.rsrc_id = pr.rsrc_id
/
show err
--METADATA NAME:PROJROLE_VIEW TYPE:GRANT TABLE_NAME:PROJROLE_VIEW CHANGE:CREATE
GRANT SELECT ON PROJROLE_VIEW TO PRIVUSER
/
prompt Creating view PROJRSRCROLE_VIEW

--METADATA NAME:PROJRSRCROLE_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJRSRCROLE_VIEW
 as
SELECT rr.rsrc_id, rr.role_id, pro.proj_id
FROM projrole_view pro,  rsrcrole rr
WHERE  rr.role_id = pro.role_id
UNION 
SELECT  rr.rsrc_id, rr.role_id, pr.proj_id
FROM projrsrc_view pr, rsrcrole rr
WHERE rr.rsrc_id = pr.rsrc_id
/
show err
--METADATA NAME:PROJRSRCROLE_VIEW TYPE:GRANT TABLE_NAME:PROJRSRCROLE_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRCROLE_VIEW TO PRIVUSER
/
prompt Creating view PROJSHAR_BL_VIEW

--METADATA NAME:PROJSHAR_BL_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJSHAR_BL_VIEW
as
select p.proj_id, session_id, access_level, load_status
from  project p, projshar ps
where ps.proj_id = p.proj_id
or ps.proj_id = p.orig_proj_id
/
show err
--METADATA NAME:PROJSHAR_BL_VIEW TYPE:GRANT TABLE_NAME:PROJSHAR_BL_VIEW CHANGE:CREATE
GRANT SELECT ON PROJSHAR_BL_VIEW TO PRIVUSER
/
prompt Creating view PROJRSRC_PS_VIEW

--METADATA NAME:PROJRSRC_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJRSRC_PS_VIEW
AS
SELECT tk.rsrc_id, tk.proj_id, ps.session_id, ps.load_status
FROM task tk, projshar ps
WHERE tk.rsrc_ID IS NOT NULL
and ps.proj_id = tk.proj_id
UNION
SELECT tr.rsrc_id, tr.proj_id, ps.session_id, ps.load_status
FROM taskrsrc tr, projshar ps
WHERE tr.rsrc_id IS NOT NULL
and ps.proj_id = tr.proj_id
UNION
SELECT pe.rsrc_id, pe.proj_id, ps.session_id, ps.load_status
FROM projest pe, projshar ps
WHERE pe.rsrc_id is not null
and ps.proj_id = pe.proj_id
UNION
SELECT pi.rsrc_id, pi.proj_id, ps.session_id, ps.load_status
FROM projissu pi, projshar ps
WHERE pi.rsrc_id is not null
and ps.proj_id = pi.proj_id
UNION
SELECT wr.rsrc_id, wr.proj_id, ps.session_id, ps.load_status
FROM wbsrsrc wr, projshar ps
WHERE wr.rsrc_id is not null
and ps.proj_id = wr.proj_id
/
show err
--METADATA NAME:PROJRSRC_PS_VIEW TYPE:GRANT TABLE_NAME:PROJRSRC_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRC_PS_VIEW TO PRIVUSER
/
prompt Creating view PROJROLE_PS_VIEW

--METADATA NAME:PROJROLE_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJROLE_PS_VIEW
AS
SELECT tr.role_id, tr.proj_id, ps.session_id, ps.load_status
FROM taskrsrc tr, projshar ps
WHERE tr.role_id IS NOT NULL 
and ps.proj_id = tr.proj_id
UNION 
SELECT r.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM projrsrc_ps_view pr,rsrc r
WHERE r.role_id IS NOT NULL
AND r.rsrc_id = pr.rsrc_id
UNION
SELECT rs.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM rsrcrole rs,  PROJRSRC_PS_VIEW pr
WHERE rs.role_id IS NOT NULL
and rs.rsrc_id = pr.rsrc_id
UNION
SELECT wr.role_id, ps.proj_id, ps.session_id, ps.load_status
FROM wbsrsrc wr, PROJSHAR ps
WHERE wr.role_id is NOT NULL
and ps.proj_id = wr.proj_id
/
show err
--METADATA NAME:PROJROLE_PS_VIEW TYPE:GRANT TABLE_NAME:PROJROLE_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJROLE_PS_VIEW TO PRIVUSER
/
prompt Creating view PROJRSRCROLE_PS_VIEW

--METADATA NAME:PROJRSRCROLE_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PROJRSRCROLE_PS_VIEW
AS
SELECT rr.rsrc_id, rr.role_id, pro.proj_id, pro.session_id, pro.load_status
FROM projrole_ps_view pro, rsrcrole rr
WHERE rr.role_id = pro.role_id
UNION 
SELECT rr.rsrc_id, rr.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM projrsrc_ps_view pr, rsrcrole rr
WHERE rr.rsrc_id = pr.rsrc_id
/
show err
--METADATA NAME:PROJRSRCROLE_PS_VIEW TYPE:GRANT TABLE_NAME:PROJRSRCROLE_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRCROLE_PS_VIEW TO PRIVUSER
/
prompt Creating view PFLOAD_VIEW

--METADATA NAME:PFLOAD_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PFLOAD_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from prpfolio prf, projwbs pw
where prf.wbs_id = pw.wbs_id
union
select 0, pw.wbs_id, pw.proj_id
from projwbs pw, project p
where pw.proj_node_flag = 'Y'
and pw.proj_id = p.proj_id
and p.project_flag ='N'
/
show err
--METADATA NAME:PFLOAD_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_VIEW TO PRIVUSER
/
prompt Creating view PFLOAD_IP_VIEW

--METADATA NAME:PFLOAD_IP_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PFLOAD_IP_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from projwbs pw, prpfolio prf
where prf.wbs_id = pw.wbs_id
union
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from projwbs pw, projwbs pw2, prpfolio prf
where pw2.wbs_id = prf.wbs_id
and pw.wbs_id = pw2.parent_wbs_id
/
show err
--METADATA NAME:PFLOAD_IP_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_IP_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_IP_VIEW TO PRIVUSER
/
prompt Creating view PFLOAD_UACCESS_VIEW

--METADATA NAME:PFLOAD_UACCESS_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PFLOAD_UACCESS_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from prpfolio prf, projwbs pw, uaccess ua
where prf.wbs_id = pw.wbs_id
and pw.proj_id = ua.proj_id
union
select 0, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from projwbs pw, project p, uaccess ua
where pw.proj_node_flag = 'Y'
and pw.proj_id = p.proj_id
and p.project_flag ='N'
and pw.proj_id = ua.proj_id
/
show err
--METADATA NAME:PFLOAD_UACCESS_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_UACCESS_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_UACCESS_VIEW TO PRIVUSER
/
prompt Creating view PFLOAD_IP_UACCESS_VIEW

--METADATA NAME:PFLOAD_IP_UACCESS_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW PFLOAD_IP_UACCESS_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from projwbs pw, prpfolio prf, uaccess ua
where prf.wbs_id = pw.wbs_id
and pw.proj_id = ua.proj_id
union
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from 
projwbs pw, projwbs pw2, prpfolio prf, uaccess ua
where pw2.wbs_id = prf.wbs_id
and pw.wbs_id = pw2.parent_wbs_id
and pw.proj_id = ua.proj_id
/
show err
--METADATA NAME:PFLOAD_IP_UACCESS_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_IP_UACCESS_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_IP_UACCESS_VIEW TO PRIVUSER
/
prompt Creating view OPENING_OBS

--METADATA NAME:OPENING_OBS TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_OBS
AS
SELECT obs_id FROM dltobs
/
show err
--METADATA NAME:OPENING_OBS TYPE:GRANT TABLE_NAME:OPENING_OBS CHANGE:CREATE
GRANT SELECT ON OPENING_OBS TO PRIVUSER
/
prompt Creating view OPENING_ROLE

--METADATA NAME:OPENING_ROLE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_ROLE
AS
SELECT role_id FROM dltrole
/
show err
--METADATA NAME:OPENING_ROLE TYPE:GRANT TABLE_NAME:OPENING_ROLE CHANGE:CREATE
GRANT SELECT ON OPENING_ROLE TO PRIVUSER
/
prompt Creating view OPENING_ACCOUNT

--METADATA NAME:OPENING_ACCOUNT TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_ACCOUNT
AS
SELECT acct_id FROM dltacct
/
show err
--METADATA NAME:OPENING_ACCOUNT TYPE:GRANT TABLE_NAME:OPENING_ACCOUNT CHANGE:CREATE
GRANT SELECT ON OPENING_ACCOUNT TO PRIVUSER
/
prompt Creating view OPENING_USERS

--METADATA NAME:OPENING_USERS TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_USERS
AS
SELECT user_id FROM dltuser
/
show err
--METADATA NAME:OPENING_USERS TYPE:GRANT TABLE_NAME:OPENING_USERS CHANGE:CREATE
GRANT SELECT ON OPENING_USERS TO PRIVUSER
/
prompt Creating view OPENING_RSRC

--METADATA NAME:OPENING_RSRC TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_RSRC
AS
SELECT rsrc_id FROM dltrsrc
/
show err
--METADATA NAME:OPENING_RSRC TYPE:GRANT TABLE_NAME:OPENING_RSRC CHANGE:CREATE
GRANT SELECT ON OPENING_RSRC TO PRIVUSER
/
prompt Creating view OPENING_ACTVCODE

--METADATA NAME:OPENING_ACTVCODE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_ACTVCODE
AS
SELECT actv_code_id, parent_actv_code_id FROM dltactv
/
show err
--METADATA NAME:OPENING_ACTVCODE TYPE:GRANT TABLE_NAME:OPENING_ACTVCODE CHANGE:CREATE
GRANT SELECT ON OPENING_ACTVCODE TO PRIVUSER
/
prompt Creating view OPENING_RSRCROLE

--METADATA NAME:OPENING_RSRCROLE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW OPENING_RSRCROLE
AS
SELECT rsrc_id,role_id FROM dltrsrl
/
show err
--METADATA NAME:OPENING_RSRCROLE TYPE:GRANT TABLE_NAME:OPENING_RSRCROLE CHANGE:CREATE
GRANT SELECT ON OPENING_RSRCROLE TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJ_BY_WEEK

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_WEEK
as
select proj_id, week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJ_BY_MONTH

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_MONTH
as
select proj_id, month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJ_BY_QTR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_QTR
as
select proj_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJ_BY_YEAR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_YEAR
as
select proj_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  proj_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_RSRC_BY_WEEK

--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_WEEK
as
select rsrc_id, week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by rsrc_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_RSRC_BY_MONTH

--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_MONTH
as
select rsrc_id, month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by rsrc_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_RSRC_BY_QTR

--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_QTR
as
select rsrc_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by rsrc_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_RSRC_BY_YEAR

--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_YEAR
as
select rsrc_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  rsrc_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_ROLE_BY_WEEK

--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_WEEK
as
select role_id, week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by role_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_ROLE_BY_MONTH

--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_MONTH
as
select role_id, month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by role_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_ROLE_BY_QTR

--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_QTR
as
select role_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by role_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_ROLE_BY_YEAR

--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_YEAR
as
select role_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  role_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJRSRC_WEEK

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_WEEK
(PROJ_ID, RSRC_ID,  WEEK_START, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id,  week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id,  rsrc_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJRSRC_MON

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_MON
(PROJ_ID, RSRC_ID,  MONTH_START, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id,  month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_MON TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJRSRC_QTR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_QTR
(PROJ_ID, RSRC_ID,  QTR, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id,  to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id,  rsrc_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJRSRC_YEAR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_YEAR
(PROJ_ID, RSRC_ID,  YEAR, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id,  to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  proj_id,  rsrc_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJROLE_WEEK

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJROLE_WEEK
(PROJ_ID, ROLE_ID, WEEK_START, PROJECT_SUMM_QTY)
AS 
select proj_id, role_id,  week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id,  role_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJROLE_MON

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJROLE_MON
(PROJ_ID, ROLE_ID, MONTH_START, PROJECT_SUMM_QTY)
AS 
select proj_id, role_id,  month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, role_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_MON TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJROLE_QTR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJROLE_QTR
(PROJ_ID, ROLE_ID, QTR, PROJECT_SUMM_QTY)
AS 
select proj_id, role_id,  to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id,  role_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_BY_PROJROLE_YEAR

--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_BY_PROJROLE_YEAR
(PROJ_ID, ROLE_ID, YEAR, PROJECT_SUMM_QTY)
AS 
select proj_id, role_id,  to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  proj_id,  role_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_SUMMARY_BY_MON

--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_SUMMARY_BY_MON
(PROJ_ID, RSRC_ID, ROLE_ID, MONTH_START, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id, role_id,  month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id, role_id, month_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_MON TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_SUMMARY_BY_QTR

--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_SUMMARY_BY_QTR
(PROJ_ID, RSRC_ID, ROLE_ID, QTR, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id, role_id,  to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id, role_id, to_date('0'|| to_char(month_start, 'Q' )*3-2 || '-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_QTR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_SUMMARY_BY_WEEK

--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_SUMMARY_BY_WEEK
(PROJ_ID, RSRC_ID, ROLE_ID, WEEK_START, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id, role_id,  week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id,  role_id, week_start
/
show err
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_WEEK TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSGN_SUMMARY_BY_YEAR

--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSGN_SUMMARY_BY_YEAR
(PROJ_ID, RSRC_ID, ROLE_ID, YEAR, PROJECT_SUMM_QTY)
AS 
select proj_id, rsrc_id, role_id,  to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY') Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  proj_id, rsrc_id,  role_id, to_date('01-01-' || to_char(month_start,'YYYY'),'MM-DD-YYYY')
/
show err
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_YEAR TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSN_BY_PROJ_BY_FP

--METADATA NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSN_BY_PROJ_BY_FP
as
SELECT proj_id, fin_dates_id, SUM(proj_summ_qty) proj_summ_qty
FROM  (SELECT r.proj_id, q.fin_dates_id1 fin_dates_id, q.fin_qty1 proj_summ_qty
       FROM WBSRSRC_QTY q INNER JOIN
            WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            PROJECT p ON r.proj_id = p.proj_id
       WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
       UNION ALL
       SELECT r.proj_id, q.fin_dates_id2 fin_dates_id, q.fin_qty2 proj_summ_qty
       FROM WBSRSRC_QTY q INNER JOIN
            WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            PROJECT p ON r.proj_id = p.proj_id
       WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
       UNION ALL
       SELECT r.proj_id, f.fin_dates_id, q.qty proj_summ_qty
       FROM WBSRSRC_QTY q INNER JOIN
            WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            FINDATES f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
            PROJECT p ON r.proj_id = p.proj_id
       WHERE (to_number(to_char(q.month_start,'mm')) = to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)
       UNION ALL
       SELECT r.proj_id, f.fin_dates_id, q.qty proj_summ_qty
       FROM WBSRSRC_QTY q INNER JOIN
            WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            FINDATES f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
            PROJECT p ON r.proj_id = p.proj_id
       WHERE (to_number(to_char(q.month_start,'mm')) <> to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) X
GROUP BY proj_id, fin_dates_id
/
show err
--METADATA NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJ_BY_FP TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSN_BY_PROJROLE_BY_FP

--METADATA NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSN_BY_PROJROLE_BY_FP
as 
SELECT proj_id, role_id, fin_dates_id, SUM(proj_summ_qty) proj_summ_qty
FROM (SELECT r.proj_id, r.role_id, q.fin_dates_id1 fin_dates_id, q.fin_qty1 proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, q.fin_dates_id2 fin_dates_id, q.fin_qty2 proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) = to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) <> to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) X
GROUP BY proj_id, role_id, fin_dates_id
/
show err
--METADATA NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJROLE_BY_FP TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSN_BY_PROJRSRC_BY_FP

--METADATA NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSN_BY_PROJRSRC_BY_FP
as 
SELECT proj_id, rsrc_id, fin_dates_id, SUM(proj_summ_qty) proj_summ_qty
FROM (SELECT r.proj_id, r.rsrc_id, q.fin_dates_id1 fin_dates_id, q.fin_qty1 proj_summ_qty
      FROM WBSRSRC r INNER JOIN
           WBSRSRC_QTY q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, q.fin_dates_id2 fin_dates_id, q.fin_qty2 proj_summ_qty
      FROM WBSRSRC r INNER JOIN
           WBSRSRC_QTY q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC r INNER JOIN
           WBSRSRC_QTY q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) = to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC r INNER JOIN
           WBSRSRC_QTY q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) <> to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) X
GROUP BY proj_id, rsrc_id, fin_dates_id
/
show err
--METADATA NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TO PRIVUSER
/
prompt Creating view WBSRSRC_ASSN_SUMMARY_BY_FP

--METADATA NAME:WBSRSRC_ASSN_SUMMARY_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW WBSRSRC_ASSN_SUMMARY_BY_FP
as 
SELECT proj_id, role_id, rsrc_id, fin_dates_id, SUM(proj_summ_qty) proj_summ_qty
FROM (SELECT r.proj_id, r.role_id, r.rsrc_id, q.fin_dates_id1 fin_dates_id, q.fin_qty1 proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, q.fin_dates_id2 fin_dates_id, q.fin_qty2 proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) = to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, f.fin_dates_id, q.qty proj_summ_qty
      FROM WBSRSRC_QTY q INNER JOIN
           WBSRSRC r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT p ON r.proj_id = p.proj_id
      WHERE (to_number(to_char(q.month_start,'mm')) <> to_number(to_char(q.week_start,'mm'))) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) X
GROUP BY proj_id, role_id, rsrc_id, fin_dates_id
/
show err
--METADATA NAME:WBSRSRC_ASSN_SUMMARY_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_SUMMARY_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_SUMMARY_BY_FP TO PRIVUSER
/
prompt Creating trigger PRMAUD_ACCOUNT

--METADATA NAME:PRMAUD_ACCOUNT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ACCOUNT
after insert or update or delete on ACCOUNT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ACCOUNT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.acct_id;
				
    
    else
    	vpk1 := :new.acct_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('acct_id')) and PRM_AUDIT.column_audited('acct_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACCOUNT','acct_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.acct_id,:new.acct_id); end if;
    
    if (voper <> 'U' or  updating('acct_seq_num')) and PRM_AUDIT.column_audited('acct_seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACCOUNT','acct_seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_seq_num,:new.acct_seq_num); end if;
    
    if (voper <> 'U' or  updating('acct_short_name')) and PRM_AUDIT.column_audited('acct_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACCOUNT','acct_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_short_name,:new.acct_short_name); end if;
    
    if (voper <> 'U' or  updating('acct_name')) and PRM_AUDIT.column_audited('acct_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACCOUNT','acct_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_name,:new.acct_name); end if;
    
    if (voper <> 'U' or  updating('parent_acct_id')) and PRM_AUDIT.column_audited('parent_acct_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACCOUNT','parent_acct_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_acct_id,:new.parent_acct_id); end if;
    if voper <> 'U' or ( updating('acct_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('ACCOUNT','acct_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.acct_descr,:new.acct_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ACCOUNT',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ACCOUNT_DEL

--METADATA NAME:RT_ACCOUNT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACCOUNT_DEL
BEFORE DELETE ON ACCOUNT
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ACCOUNT',:old.acct_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ACCOUNT

--METADATA NAME:RT_ACCOUNT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACCOUNT
BEFORE UPDATE OR INSERT ON ACCOUNT
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ACCOUNT',:old.acct_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.acct_id)
			  and table_name = 'ACCOUNT';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ACTVCODE

--METADATA NAME:PRMAUD_ACTVCODE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ACTVCODE
after insert or update or delete on ACTVCODE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ACTVCODE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.actv_code_id;
				
    
    else
    	vpk1 := :new.actv_code_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('actv_code_id')) and PRM_AUDIT.column_audited('actv_code_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','actv_code_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.actv_code_id,:new.actv_code_id); end if;
    
    if (voper <> 'U' or  updating('actv_code_type_id')) and PRM_AUDIT.column_audited('actv_code_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','actv_code_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.actv_code_type_id,:new.actv_code_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('short_name')) and PRM_AUDIT.column_audited('short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.short_name,:new.short_name); end if;
    
    if (voper <> 'U' or  updating('parent_actv_code_id')) and PRM_AUDIT.column_audited('parent_actv_code_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','parent_actv_code_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_actv_code_id,:new.parent_actv_code_id); end if;
    
    if (voper <> 'U' or  updating('actv_code_name')) and PRM_AUDIT.column_audited('actv_code_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','actv_code_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.actv_code_name,:new.actv_code_name); end if;
    
    if (voper <> 'U' or  updating('color')) and PRM_AUDIT.column_audited('color', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVCODE','color',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.color,:new.color); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ACTVCODE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ACTVCODE_DEL

--METADATA NAME:RT_ACTVCODE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACTVCODE_DEL
BEFORE DELETE ON ACTVCODE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ACTVCODE',:old.actv_code_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ACTVCODE

--METADATA NAME:RT_ACTVCODE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACTVCODE
BEFORE UPDATE OR INSERT ON ACTVCODE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
  UPDATE ACTVTYPE SET update_date = sysdate WHERE actv_code_type_id = :NEW.actv_code_type_id;

		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ACTVCODE',:old.actv_code_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.actv_code_id)
			  and table_name = 'ACTVCODE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ACTVTYPE

--METADATA NAME:PRMAUD_ACTVTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ACTVTYPE
after insert or update or delete on ACTVTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ACTVTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.actv_code_type_id;
				
    
    else
    	vpk1 := :new.actv_code_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('actv_code_type_id')) and PRM_AUDIT.column_audited('actv_code_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','actv_code_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.actv_code_type_id,:new.actv_code_type_id); end if;
    
    if (voper <> 'U' or  updating('actv_short_len')) and PRM_AUDIT.column_audited('actv_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','actv_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.actv_short_len,:new.actv_short_len); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('actv_code_type')) and PRM_AUDIT.column_audited('actv_code_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','actv_code_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.actv_code_type,:new.actv_code_type); end if;
    
    if (voper <> 'U' or  updating('actv_code_type_scope')) and PRM_AUDIT.column_audited('actv_code_type_scope', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','actv_code_type_scope',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.actv_code_type_scope,:new.actv_code_type_scope); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('super_flag')) and PRM_AUDIT.column_audited('super_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ACTVTYPE','super_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.super_flag,:new.super_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ACTVTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ACTVTYPE_DEL

--METADATA NAME:RT_ACTVTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACTVTYPE_DEL
BEFORE DELETE ON ACTVTYPE
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'ACTVTYPE',:old.actv_code_type_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_ACTVTYPE

--METADATA NAME:RT_ACTVTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ACTVTYPE
BEFORE UPDATE OR INSERT ON ACTVTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'ACTVTYPE',:old.actv_code_type_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.actv_code_type_id)
			  and table_name = 'ACTVTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ADMIN_CONFIG

--METADATA NAME:PRMAUD_ADMIN_CONFIG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ADMIN_CONFIG
after insert or update or delete on ADMIN_CONFIG
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ADMIN_CONFIG',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.config_name;
				
    
    else
    	vpk1 := :new.config_name;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('config_name')) and PRM_AUDIT.column_audited('config_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ADMIN_CONFIG','config_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.config_name,:new.config_name); end if;
    
    if (voper <> 'U' or  updating('config_type')) and PRM_AUDIT.column_audited('config_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ADMIN_CONFIG','config_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.config_type,:new.config_type); end if;
    
    if (voper <> 'U' or  updating('factory_version')) and PRM_AUDIT.column_audited('factory_version', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ADMIN_CONFIG','factory_version',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.factory_version,:new.factory_version); end if;
    
    if (voper <> 'U' or  updating('last_change_date')) and PRM_AUDIT.column_audited('last_change_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ADMIN_CONFIG','last_change_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_change_date,'yyyymmddhh24miss'),to_char(:new.last_change_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('config_value')) and PRM_AUDIT.column_audited('config_value', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ADMIN_CONFIG','config_value',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.config_value,:new.config_value); end if;
    if voper <> 'U' or ( updating('config_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('ADMIN_CONFIG','config_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.config_data,:new.config_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ADMIN_CONFIG',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ADMIN_CONFIG_DEL

--METADATA NAME:RT_ADMIN_CONFIG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ADMIN_CONFIG_DEL
BEFORE DELETE ON ADMIN_CONFIG
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ADMIN_CONFIG',:old.config_name,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ADMIN_CONFIG

--METADATA NAME:RT_ADMIN_CONFIG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ADMIN_CONFIG
BEFORE UPDATE OR INSERT ON ADMIN_CONFIG
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ADMIN_CONFIG',:old.config_name,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = :old.config_name
			  and table_name = 'ADMIN_CONFIG';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ASGNMNTACAT

--METADATA NAME:PRMAUD_ASGNMNTACAT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ASGNMNTACAT
after insert or update or delete on ASGNMNTACAT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ASGNMNTACAT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.taskrsrc_id;
				
    vpk2 := :old.asgnmnt_catg_type_id;
				
    
    else
    	vpk1 := :new.taskrsrc_id;
				
    vpk2 := :new.asgnmnt_catg_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('taskrsrc_id')) and PRM_AUDIT.column_audited('taskrsrc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTACAT','taskrsrc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.taskrsrc_id,:new.taskrsrc_id); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_type_id')) and PRM_AUDIT.column_audited('asgnmnt_catg_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTACAT','asgnmnt_catg_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_type_id,:new.asgnmnt_catg_type_id); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_id')) and PRM_AUDIT.column_audited('asgnmnt_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTACAT','asgnmnt_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_id,:new.asgnmnt_catg_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTACAT','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ASGNMNTACAT',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ASGNMNTACAT_DEL

--METADATA NAME:RT_ASGNMNTACAT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTACAT_DEL
BEFORE DELETE ON ASGNMNTACAT
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'ASGNMNTACAT',:old.taskrsrc_id,:old.asgnmnt_catg_type_id,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_ASGNMNTACAT

--METADATA NAME:RT_ASGNMNTACAT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTACAT
BEFORE UPDATE OR INSERT ON ASGNMNTACAT
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.taskrsrc_id)
and pk2 = TO_CHAR(:new.asgnmnt_catg_type_id)
		and table_name = 'ASGNMNTACAT';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'ASGNMNTACAT',:old.taskrsrc_id,:old.asgnmnt_catg_type_id,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.taskrsrc_id)
and pk2 = TO_CHAR(:old.asgnmnt_catg_type_id)
			  and table_name = 'ASGNMNTACAT';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ASGNMNTCATTYPE

--METADATA NAME:PRMAUD_ASGNMNTCATTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ASGNMNTCATTYPE
after insert or update or delete on ASGNMNTCATTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ASGNMNTCATTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.asgnmnt_catg_type_id;
				
    
    else
    	vpk1 := :new.asgnmnt_catg_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('asgnmnt_catg_type_id')) and PRM_AUDIT.column_audited('asgnmnt_catg_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATTYPE','asgnmnt_catg_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.asgnmnt_catg_type_id,:new.asgnmnt_catg_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATTYPE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_short_len')) and PRM_AUDIT.column_audited('asgnmnt_catg_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATTYPE','asgnmnt_catg_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_short_len,:new.asgnmnt_catg_short_len); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_type')) and PRM_AUDIT.column_audited('asgnmnt_catg_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATTYPE','asgnmnt_catg_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_type,:new.asgnmnt_catg_type); end if;
    
    if (voper <> 'U' or  updating('super_flag')) and PRM_AUDIT.column_audited('super_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATTYPE','super_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.super_flag,:new.super_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ASGNMNTCATTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ASGNMNTCATTYPE_DEL

--METADATA NAME:RT_ASGNMNTCATTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTCATTYPE_DEL
BEFORE DELETE ON ASGNMNTCATTYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ASGNMNTCATTYPE',:old.asgnmnt_catg_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ASGNMNTCATTYPE

--METADATA NAME:RT_ASGNMNTCATTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTCATTYPE
BEFORE UPDATE OR INSERT ON ASGNMNTCATTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ASGNMNTCATTYPE',:old.asgnmnt_catg_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.asgnmnt_catg_type_id)
			  and table_name = 'ASGNMNTCATTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ASGNMNTCATVAL

--METADATA NAME:PRMAUD_ASGNMNTCATVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ASGNMNTCATVAL
after insert or update or delete on ASGNMNTCATVAL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ASGNMNTCATVAL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.asgnmnt_catg_id;
				
    
    else
    	vpk1 := :new.asgnmnt_catg_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('asgnmnt_catg_id')) and PRM_AUDIT.column_audited('asgnmnt_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','asgnmnt_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.asgnmnt_catg_id,:new.asgnmnt_catg_id); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_type_id')) and PRM_AUDIT.column_audited('asgnmnt_catg_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','asgnmnt_catg_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_type_id,:new.asgnmnt_catg_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_short_name')) and PRM_AUDIT.column_audited('asgnmnt_catg_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','asgnmnt_catg_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_short_name,:new.asgnmnt_catg_short_name); end if;
    
    if (voper <> 'U' or  updating('asgnmnt_catg_name')) and PRM_AUDIT.column_audited('asgnmnt_catg_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','asgnmnt_catg_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.asgnmnt_catg_name,:new.asgnmnt_catg_name); end if;
    
    if (voper <> 'U' or  updating('parent_asgnmnt_catg_id')) and PRM_AUDIT.column_audited('parent_asgnmnt_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ASGNMNTCATVAL','parent_asgnmnt_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_asgnmnt_catg_id,:new.parent_asgnmnt_catg_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ASGNMNTCATVAL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ASGNMNTCATVAL_DEL

--METADATA NAME:RT_ASGNMNTCATVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTCATVAL_DEL
BEFORE DELETE ON ASGNMNTCATVAL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ASGNMNTCATVAL',:old.asgnmnt_catg_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ASGNMNTCATVAL

--METADATA NAME:RT_ASGNMNTCATVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ASGNMNTCATVAL
BEFORE UPDATE OR INSERT ON ASGNMNTCATVAL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
  UPDATE ASGNMNTCATTYPE SET update_date = sysdate WHERE asgnmnt_catg_type_id = :NEW.asgnmnt_catg_type_id;

		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ASGNMNTCATVAL',:old.asgnmnt_catg_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.asgnmnt_catg_id)
			  and table_name = 'ASGNMNTCATVAL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_BASETYPE

--METADATA NAME:PRMAUD_BASETYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_BASETYPE
after insert or update or delete on BASETYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('BASETYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.base_type_id;
				
    
    else
    	vpk1 := :new.base_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('base_type_id')) and PRM_AUDIT.column_audited('base_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BASETYPE','base_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.base_type_id,:new.base_type_id); end if;
    
    if (voper <> 'U' or  updating('base_type_seq_num')) and PRM_AUDIT.column_audited('base_type_seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BASETYPE','base_type_seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.base_type_seq_num,:new.base_type_seq_num); end if;
    
    if (voper <> 'U' or  updating('base_type')) and PRM_AUDIT.column_audited('base_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BASETYPE','base_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.base_type,:new.base_type); end if;
  end if;
  PRM_AUDIT.audit_row ( 'BASETYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_BASETYPE_DEL

--METADATA NAME:RT_BASETYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BASETYPE_DEL
BEFORE DELETE ON BASETYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'BASETYPE',:old.base_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_BASETYPE

--METADATA NAME:RT_BASETYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BASETYPE
BEFORE UPDATE OR INSERT ON BASETYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'BASETYPE',:old.base_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.base_type_id)
			  and table_name = 'BASETYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_BRE_REGISTRY

--METADATA NAME:PRMAUD_BRE_REGISTRY TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_BRE_REGISTRY
after insert or update or delete on BRE_REGISTRY
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('BRE_REGISTRY',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.bre_registry_id;
				
    
    else
    	vpk1 := :new.bre_registry_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('bre_registry_id')) and PRM_AUDIT.column_audited('bre_registry_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','bre_registry_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.bre_registry_id,:new.bre_registry_id); end if;
    
    if (voper <> 'U' or  updating('ip_address')) and PRM_AUDIT.column_audited('ip_address', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','ip_address',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ip_address,:new.ip_address); end if;
    
    if (voper <> 'U' or  updating('start_time')) and PRM_AUDIT.column_audited('start_time', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','start_time',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.start_time,'yyyymmddhh24miss'),to_char(:new.start_time,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('status_code')) and PRM_AUDIT.column_audited('status_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','status_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status_code,:new.status_code); end if;
    
    if (voper <> 'U' or  updating('torched_time')) and PRM_AUDIT.column_audited('torched_time', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','torched_time',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.torched_time,'yyyymmddhh24miss'),to_char(:new.torched_time,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('config_name')) and PRM_AUDIT.column_audited('config_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','config_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.config_name,:new.config_name); end if;
    
    if (voper <> 'U' or  updating('config_changed_flag')) and PRM_AUDIT.column_audited('config_changed_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BRE_REGISTRY','config_changed_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.config_changed_flag,:new.config_changed_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'BRE_REGISTRY',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_BRE_REGISTRY_DEL

--METADATA NAME:RT_BRE_REGISTRY_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BRE_REGISTRY_DEL
BEFORE DELETE ON BRE_REGISTRY
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'BRE_REGISTRY',:old.bre_registry_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_BRE_REGISTRY

--METADATA NAME:RT_BRE_REGISTRY TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BRE_REGISTRY
BEFORE UPDATE OR INSERT ON BRE_REGISTRY
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'BRE_REGISTRY',:old.bre_registry_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = :old.bre_registry_id
			  and table_name = 'BRE_REGISTRY';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_BUDGCHNG

--METADATA NAME:PRMAUD_BUDGCHNG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_BUDGCHNG
after insert or update or delete on BUDGCHNG
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('BUDGCHNG',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.budg_chng_id;
				
    
    else
    	vpk1 := :new.budg_chng_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('budg_chng_id')) and PRM_AUDIT.column_audited('budg_chng_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','budg_chng_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.budg_chng_id,:new.budg_chng_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('wbs_id')) and PRM_AUDIT.column_audited('wbs_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','wbs_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.wbs_id,:new.wbs_id); end if;
    
    if (voper <> 'U' or  updating('chng_date')) and PRM_AUDIT.column_audited('chng_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','chng_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.chng_date,'yyyymmddhh24miss'),to_char(:new.chng_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('chng_short_name')) and PRM_AUDIT.column_audited('chng_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','chng_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.chng_short_name,:new.chng_short_name); end if;
    
    if (voper <> 'U' or  updating('chng_cost')) and PRM_AUDIT.column_audited('chng_cost', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','chng_cost',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.chng_cost,:new.chng_cost); end if;
    
    if (voper <> 'U' or  updating('chng_by_name')) and PRM_AUDIT.column_audited('chng_by_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','chng_by_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.chng_by_name,:new.chng_by_name); end if;
    
    if (voper <> 'U' or  updating('status_code')) and PRM_AUDIT.column_audited('status_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','status_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status_code,:new.status_code); end if;
    
    if (voper <> 'U' or  updating('chng_descr')) and PRM_AUDIT.column_audited('chng_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('BUDGCHNG','chng_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.chng_descr,:new.chng_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'BUDGCHNG',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_BUDGCHNG_DEL

--METADATA NAME:RT_BUDGCHNG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BUDGCHNG_DEL
BEFORE DELETE ON BUDGCHNG
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'BUDGCHNG',:old.budg_chng_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_BUDGCHNG

--METADATA NAME:RT_BUDGCHNG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_BUDGCHNG
BEFORE UPDATE OR INSERT ON BUDGCHNG
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'BUDGCHNG',:old.budg_chng_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.budg_chng_id)
			  and table_name = 'BUDGCHNG';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_CALENDAR

--METADATA NAME:PRMAUD_CALENDAR TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_CALENDAR
after insert or update or delete on CALENDAR
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('CALENDAR',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.clndr_id;
				
    
    else
    	vpk1 := :new.clndr_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('clndr_id')) and PRM_AUDIT.column_audited('clndr_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','clndr_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.clndr_id,:new.clndr_id); end if;
    
    if (voper <> 'U' or  updating('default_flag')) and PRM_AUDIT.column_audited('default_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','default_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_flag,:new.default_flag); end if;
    
    if (voper <> 'U' or  updating('rsrc_private')) and PRM_AUDIT.column_audited('rsrc_private', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','rsrc_private',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_private,:new.rsrc_private); end if;
    
    if (voper <> 'U' or  updating('clndr_name')) and PRM_AUDIT.column_audited('clndr_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','clndr_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.clndr_name,:new.clndr_name); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('base_clndr_id')) and PRM_AUDIT.column_audited('base_clndr_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','base_clndr_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.base_clndr_id,:new.base_clndr_id); end if;
    
    if (voper <> 'U' or  updating('last_chng_date')) and PRM_AUDIT.column_audited('last_chng_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','last_chng_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_chng_date,'yyyymmddhh24miss'),to_char(:new.last_chng_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('clndr_type')) and PRM_AUDIT.column_audited('clndr_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','clndr_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.clndr_type,:new.clndr_type); end if;
    if voper <> 'U' or ( updating('clndr_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('CALENDAR','clndr_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.clndr_data,:new.clndr_data); end if;
    
    if (voper <> 'U' or  updating('day_hr_cnt')) and PRM_AUDIT.column_audited('day_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','day_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.day_hr_cnt,:new.day_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('week_hr_cnt')) and PRM_AUDIT.column_audited('week_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','week_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.week_hr_cnt,:new.week_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('year_hr_cnt')) and PRM_AUDIT.column_audited('year_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','year_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.year_hr_cnt,:new.year_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('month_hr_cnt')) and PRM_AUDIT.column_audited('month_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CALENDAR','month_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.month_hr_cnt,:new.month_hr_cnt); end if;
  end if;
  PRM_AUDIT.audit_row ( 'CALENDAR',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_CALENDAR_DEL

--METADATA NAME:RT_CALENDAR_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_CALENDAR_DEL
BEFORE DELETE ON CALENDAR
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'CALENDAR',:old.clndr_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_CALENDAR

--METADATA NAME:RT_CALENDAR TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_CALENDAR
BEFORE UPDATE OR INSERT ON CALENDAR
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'CALENDAR',:old.clndr_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.clndr_id)
			  and table_name = 'CALENDAR';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_COSTTYPE

--METADATA NAME:PRMAUD_COSTTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_COSTTYPE
after insert or update or delete on COSTTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('COSTTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.cost_type_id;
				
    
    else
    	vpk1 := :new.cost_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('cost_type_id')) and PRM_AUDIT.column_audited('cost_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('COSTTYPE','cost_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.cost_type_id,:new.cost_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('COSTTYPE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('cost_type')) and PRM_AUDIT.column_audited('cost_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('COSTTYPE','cost_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_type,:new.cost_type); end if;
  end if;
  PRM_AUDIT.audit_row ( 'COSTTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_COSTTYPE_DEL

--METADATA NAME:RT_COSTTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_COSTTYPE_DEL
BEFORE DELETE ON COSTTYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'COSTTYPE',:old.cost_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_COSTTYPE

--METADATA NAME:RT_COSTTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_COSTTYPE
BEFORE UPDATE OR INSERT ON COSTTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'COSTTYPE',:old.cost_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.cost_type_id)
			  and table_name = 'COSTTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_CURRTYPE

--METADATA NAME:PRMAUD_CURRTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_CURRTYPE
after insert or update or delete on CURRTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('CURRTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.curr_id;
				
    
    else
    	vpk1 := :new.curr_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('curr_id')) and PRM_AUDIT.column_audited('curr_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','curr_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.curr_id,:new.curr_id); end if;
    
    if (voper <> 'U' or  updating('decimal_digit_cnt')) and PRM_AUDIT.column_audited('decimal_digit_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','decimal_digit_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.decimal_digit_cnt,:new.decimal_digit_cnt); end if;
    
    if (voper <> 'U' or  updating('curr_symbol')) and PRM_AUDIT.column_audited('curr_symbol', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','curr_symbol',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.curr_symbol,:new.curr_symbol); end if;
    
    if (voper <> 'U' or  updating('decimal_symbol')) and PRM_AUDIT.column_audited('decimal_symbol', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','decimal_symbol',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.decimal_symbol,:new.decimal_symbol); end if;
    
    if (voper <> 'U' or  updating('digit_group_symbol')) and PRM_AUDIT.column_audited('digit_group_symbol', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','digit_group_symbol',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.digit_group_symbol,:new.digit_group_symbol); end if;
    
    if (voper <> 'U' or  updating('pos_curr_fmt_type')) and PRM_AUDIT.column_audited('pos_curr_fmt_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','pos_curr_fmt_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pos_curr_fmt_type,:new.pos_curr_fmt_type); end if;
    
    if (voper <> 'U' or  updating('neg_curr_fmt_type')) and PRM_AUDIT.column_audited('neg_curr_fmt_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','neg_curr_fmt_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.neg_curr_fmt_type,:new.neg_curr_fmt_type); end if;
    
    if (voper <> 'U' or  updating('curr_type')) and PRM_AUDIT.column_audited('curr_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','curr_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.curr_type,:new.curr_type); end if;
    
    if (voper <> 'U' or  updating('curr_short_name')) and PRM_AUDIT.column_audited('curr_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','curr_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.curr_short_name,:new.curr_short_name); end if;
    
    if (voper <> 'U' or  updating('group_digit_cnt')) and PRM_AUDIT.column_audited('group_digit_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','group_digit_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.group_digit_cnt,:new.group_digit_cnt); end if;
    
    if (voper <> 'U' or  updating('base_exch_rate')) and PRM_AUDIT.column_audited('base_exch_rate', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('CURRTYPE','base_exch_rate',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.base_exch_rate,:new.base_exch_rate); end if;
  end if;
  PRM_AUDIT.audit_row ( 'CURRTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_CURRTYPE_DEL

--METADATA NAME:RT_CURRTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_CURRTYPE_DEL
BEFORE DELETE ON CURRTYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'CURRTYPE',:old.curr_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_CURRTYPE

--METADATA NAME:RT_CURRTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_CURRTYPE
BEFORE UPDATE OR INSERT ON CURRTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'CURRTYPE',:old.curr_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.curr_id)
			  and table_name = 'CURRTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DASHBOARD

--METADATA NAME:PRMAUD_DASHBOARD TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DASHBOARD
after insert or update or delete on DASHBOARD
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DASHBOARD',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.dashboard_id;
				
    
    else
    	vpk1 := :new.dashboard_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('dashboard_id')) and PRM_AUDIT.column_audited('dashboard_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','dashboard_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.dashboard_id,:new.dashboard_id); end if;
    
    if (voper <> 'U' or  updating('dashboard_name')) and PRM_AUDIT.column_audited('dashboard_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','dashboard_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.dashboard_name,:new.dashboard_name); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('table_name')) and PRM_AUDIT.column_audited('table_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','table_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.table_name,:new.table_name); end if;
    
    if (voper <> 'U' or  updating('fk_id')) and PRM_AUDIT.column_audited('fk_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','fk_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fk_id,:new.fk_id); end if;
    
    if (voper <> 'U' or  updating('lock_filter_flag')) and PRM_AUDIT.column_audited('lock_filter_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','lock_filter_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.lock_filter_flag,:new.lock_filter_flag); end if;
    
    if (voper <> 'U' or  updating('max_rows_per_portlet')) and PRM_AUDIT.column_audited('max_rows_per_portlet', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','max_rows_per_portlet',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_rows_per_portlet,:new.max_rows_per_portlet); end if;
    
    if (voper <> 'U' or  updating('dashboard_layout_data')) and PRM_AUDIT.column_audited('dashboard_layout_data', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHBOARD','dashboard_layout_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.dashboard_layout_data,:new.dashboard_layout_data); end if;
    if voper <> 'U' or ( updating('portlet_settings_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('DASHBOARD','portlet_settings_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.portlet_settings_data,:new.portlet_settings_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DASHBOARD',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DASHBOARD_DEL

--METADATA NAME:RT_DASHBOARD_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DASHBOARD_DEL
BEFORE DELETE ON DASHBOARD
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DASHBOARD',:old.dashboard_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DASHBOARD

--METADATA NAME:RT_DASHBOARD TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DASHBOARD
BEFORE UPDATE OR INSERT ON DASHBOARD
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DASHBOARD',:old.dashboard_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.dashboard_id)
			  and table_name = 'DASHBOARD';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DASHUSER

--METADATA NAME:PRMAUD_DASHUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DASHUSER
after insert or update or delete on DASHUSER
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DASHUSER',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  vprm_user_name := PRM_AUDIT.g_prm_user_name;PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.dashboard_id;
				
    vpk2 := :old.user_id;
				
    
    else
    	vpk1 := :new.dashboard_id;
				
    vpk2 := :new.user_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('dashboard_id')) and PRM_AUDIT.column_audited('dashboard_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHUSER','dashboard_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.dashboard_id,:new.dashboard_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DASHUSER','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DASHUSER',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DASHUSER

--METADATA NAME:RT_DASHUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DASHUSER
BEFORE UPDATE OR INSERT ON DASHUSER
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;

  :NEW.update_user := PRM_AUDIT.g_prm_user_name;
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.g_prm_user_name;
		:NEW.create_date := SYSDATE;
	  END IF;
	
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DASHUSER',:old.dashboard_id,:old.user_id,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.dashboard_id)
and pk2 = TO_CHAR(:old.user_id)
			  and table_name = 'DASHUSER';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger RT_DASHUSER_DEL

--METADATA NAME:RT_DASHUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DASHUSER_DEL
BEFORE DELETE ON DASHUSER
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DASHUSER',:old.dashboard_id,:old.user_id,null,null );

end; 
/
show err
prompt Creating trigger PRMAUD_DISCUSSION

--METADATA NAME:PRMAUD_DISCUSSION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DISCUSSION
after insert or update or delete on DISCUSSION
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DISCUSSION',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.discussion_id;
				
    
    else
    	vpk1 := :new.discussion_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('discussion_id')) and PRM_AUDIT.column_audited('discussion_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION','discussion_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.discussion_id,:new.discussion_id); end if;
    
    if (voper <> 'U' or  updating('task_id')) and PRM_AUDIT.column_audited('task_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION','task_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_id,:new.task_id); end if;
    
    if (voper <> 'U' or  updating('discussion_value')) and PRM_AUDIT.column_audited('discussion_value', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION','discussion_value',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.discussion_value,:new.discussion_value); end if;
    
    if (voper <> 'U' or  updating('discussion_date')) and PRM_AUDIT.column_audited('discussion_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION','discussion_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.discussion_date,'yyyymmddhh24miss'),to_char(:new.discussion_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DISCUSSION',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DISCUSSION_DEL

--METADATA NAME:RT_DISCUSSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DISCUSSION_DEL
BEFORE DELETE ON DISCUSSION
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DISCUSSION',:old.discussion_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DISCUSSION

--METADATA NAME:RT_DISCUSSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DISCUSSION
BEFORE UPDATE OR INSERT ON DISCUSSION
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DISCUSSION',:old.discussion_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.discussion_id)
			  and table_name = 'DISCUSSION';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DISCUSSION_READ

--METADATA NAME:PRMAUD_DISCUSSION_READ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DISCUSSION_READ
after insert or update or delete on DISCUSSION_READ
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DISCUSSION_READ',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.discussion_id;
				
    vpk2 := :old.user_id;
				
    
    else
    	vpk1 := :new.discussion_id;
				
    vpk2 := :new.user_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('discussion_id')) and PRM_AUDIT.column_audited('discussion_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION_READ','discussion_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.discussion_id,:new.discussion_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DISCUSSION_READ','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DISCUSSION_READ',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DISCUSSION_READ_DEL

--METADATA NAME:RT_DISCUSSION_READ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DISCUSSION_READ_DEL
BEFORE DELETE ON DISCUSSION_READ
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DISCUSSION_READ',:old.discussion_id,:old.user_id,null,null );

end; 
/
show err
prompt Creating trigger RT_DISCUSSION_READ

--METADATA NAME:RT_DISCUSSION_READ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DISCUSSION_READ
BEFORE UPDATE OR INSERT ON DISCUSSION_READ
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.discussion_id)
and pk2 = TO_CHAR(:new.user_id)
		and table_name = 'DISCUSSION_READ';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DISCUSSION_READ',:old.discussion_id,:old.user_id,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.discussion_id)
and pk2 = TO_CHAR(:old.user_id)
			  and table_name = 'DISCUSSION_READ';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DOCCATG

--METADATA NAME:PRMAUD_DOCCATG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DOCCATG
after insert or update or delete on DOCCATG
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DOCCATG',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.doc_catg_id;
				
    
    else
    	vpk1 := :new.doc_catg_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('doc_catg_id')) and PRM_AUDIT.column_audited('doc_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCCATG','doc_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.doc_catg_id,:new.doc_catg_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCCATG','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('doc_catg_name')) and PRM_AUDIT.column_audited('doc_catg_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCCATG','doc_catg_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_catg_name,:new.doc_catg_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DOCCATG',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DOCCATG_DEL

--METADATA NAME:RT_DOCCATG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCCATG_DEL
BEFORE DELETE ON DOCCATG
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DOCCATG',:old.doc_catg_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DOCCATG

--METADATA NAME:RT_DOCCATG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCCATG
BEFORE UPDATE OR INSERT ON DOCCATG
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DOCCATG',:old.doc_catg_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.doc_catg_id)
			  and table_name = 'DOCCATG';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DOCREVIEW

--METADATA NAME:PRMAUD_DOCREVIEW TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DOCREVIEW
after insert or update or delete on DOCREVIEW
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DOCREVIEW',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.doc_review_id;
				
    
    else
    	vpk1 := :new.doc_review_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('doc_review_id')) and PRM_AUDIT.column_audited('doc_review_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','doc_review_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.doc_review_id,:new.doc_review_id); end if;
    
    if (voper <> 'U' or  updating('doc_id')) and PRM_AUDIT.column_audited('doc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','doc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_id,:new.doc_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('review_name')) and PRM_AUDIT.column_audited('review_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','review_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.review_name,:new.review_name); end if;
    
    if (voper <> 'U' or  updating('review_descr')) and PRM_AUDIT.column_audited('review_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','review_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.review_descr,:new.review_descr); end if;
    
    if (voper <> 'U' or  updating('review_type')) and PRM_AUDIT.column_audited('review_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','review_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.review_type,:new.review_type); end if;
    
    if (voper <> 'U' or  updating('due_date')) and PRM_AUDIT.column_audited('due_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','due_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.due_date,'yyyymmddhh24miss'),to_char(:new.due_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('status')) and PRM_AUDIT.column_audited('status', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEW','status',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status,:new.status); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DOCREVIEW',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DOCREVIEW_DEL

--METADATA NAME:RT_DOCREVIEW_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCREVIEW_DEL
BEFORE DELETE ON DOCREVIEW
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DOCREVIEW',:old.doc_review_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DOCREVIEW

--METADATA NAME:RT_DOCREVIEW TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCREVIEW
BEFORE UPDATE OR INSERT ON DOCREVIEW
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DOCREVIEW',:old.doc_review_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.doc_review_id)
			  and table_name = 'DOCREVIEW';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DOCREVIEWTASK

--METADATA NAME:PRMAUD_DOCREVIEWTASK TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DOCREVIEWTASK
after insert or update or delete on DOCREVIEWTASK
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DOCREVIEWTASK',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.review_task_id;
				
    
    else
    	vpk1 := :new.review_task_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('review_task_id')) and PRM_AUDIT.column_audited('review_task_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','review_task_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.review_task_id,:new.review_task_id); end if;
    
    if (voper <> 'U' or  updating('doc_review_id')) and PRM_AUDIT.column_audited('doc_review_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','doc_review_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_review_id,:new.doc_review_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('review_date')) and PRM_AUDIT.column_audited('review_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','review_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.review_date,'yyyymmddhh24miss'),to_char(:new.review_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('comments')) and PRM_AUDIT.column_audited('comments', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','comments',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.comments,:new.comments); end if;
    
    if (voper <> 'U' or  updating('priority')) and PRM_AUDIT.column_audited('priority', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','priority',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.priority,:new.priority); end if;
    
    if (voper <> 'U' or  updating('status')) and PRM_AUDIT.column_audited('status', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','status',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status,:new.status); end if;
    
    if (voper <> 'U' or  updating('attachment_uuid')) and PRM_AUDIT.column_audited('attachment_uuid', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCREVIEWTASK','attachment_uuid',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.attachment_uuid,:new.attachment_uuid); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DOCREVIEWTASK',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DOCREVIEWTASK_DEL

--METADATA NAME:RT_DOCREVIEWTASK_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCREVIEWTASK_DEL
BEFORE DELETE ON DOCREVIEWTASK
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DOCREVIEWTASK',:old.review_task_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DOCREVIEWTASK

--METADATA NAME:RT_DOCREVIEWTASK TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCREVIEWTASK
BEFORE UPDATE OR INSERT ON DOCREVIEWTASK
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DOCREVIEWTASK',:old.review_task_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.review_task_id)
			  and table_name = 'DOCREVIEWTASK';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DOCSTAT

--METADATA NAME:PRMAUD_DOCSTAT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DOCSTAT
after insert or update or delete on DOCSTAT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DOCSTAT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.doc_status_id;
				
    
    else
    	vpk1 := :new.doc_status_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('doc_status_id')) and PRM_AUDIT.column_audited('doc_status_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCSTAT','doc_status_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.doc_status_id,:new.doc_status_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCSTAT','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('doc_status_code')) and PRM_AUDIT.column_audited('doc_status_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCSTAT','doc_status_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_status_code,:new.doc_status_code); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DOCSTAT',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DOCSTAT_DEL

--METADATA NAME:RT_DOCSTAT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCSTAT_DEL
BEFORE DELETE ON DOCSTAT
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'DOCSTAT',:old.doc_status_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_DOCSTAT

--METADATA NAME:RT_DOCSTAT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCSTAT
BEFORE UPDATE OR INSERT ON DOCSTAT
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'DOCSTAT',:old.doc_status_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.doc_status_id)
			  and table_name = 'DOCSTAT';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_DOCUMENT

--METADATA NAME:PRMAUD_DOCUMENT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_DOCUMENT
after insert or update or delete on DOCUMENT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('DOCUMENT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.doc_id;
				
    
    else
    	vpk1 := :new.doc_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('doc_id')) and PRM_AUDIT.column_audited('doc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.doc_id,:new.doc_id); end if;
    
    if (voper <> 'U' or  updating('doc_seq_num')) and PRM_AUDIT.column_audited('doc_seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_seq_num,:new.doc_seq_num); end if;
    
    if (voper <> 'U' or  updating('deliv_flag')) and PRM_AUDIT.column_audited('deliv_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','deliv_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.deliv_flag,:new.deliv_flag); end if;
    
    if (voper <> 'U' or  updating('doc_name')) and PRM_AUDIT.column_audited('doc_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_name,:new.doc_name); end if;
    
    if (voper <> 'U' or  updating('parent_doc_id')) and PRM_AUDIT.column_audited('parent_doc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','parent_doc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_doc_id,:new.parent_doc_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('doc_status_id')) and PRM_AUDIT.column_audited('doc_status_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_status_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_status_id,:new.doc_status_id); end if;
    
    if (voper <> 'U' or  updating('doc_catg_id')) and PRM_AUDIT.column_audited('doc_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_catg_id,:new.doc_catg_id); end if;
    
    if (voper <> 'U' or  updating('doc_date')) and PRM_AUDIT.column_audited('doc_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.doc_date,'yyyymmddhh24miss'),to_char(:new.doc_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('version_name')) and PRM_AUDIT.column_audited('version_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','version_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.version_name,:new.version_name); end if;
    
    if (voper <> 'U' or  updating('guid')) and PRM_AUDIT.column_audited('guid', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','guid',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.guid,:new.guid); end if;
    
    if (voper <> 'U' or  updating('tmpl_guid')) and PRM_AUDIT.column_audited('tmpl_guid', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','tmpl_guid',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.tmpl_guid,:new.tmpl_guid); end if;
    
    if (voper <> 'U' or  updating('doc_short_name')) and PRM_AUDIT.column_audited('doc_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_short_name,:new.doc_short_name); end if;
    
    if (voper <> 'U' or  updating('author_name')) and PRM_AUDIT.column_audited('author_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','author_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.author_name,:new.author_name); end if;
    
    if (voper <> 'U' or  updating('private_loc')) and PRM_AUDIT.column_audited('private_loc', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','private_loc',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.private_loc,:new.private_loc); end if;
    
    if (voper <> 'U' or  updating('public_loc')) and PRM_AUDIT.column_audited('public_loc', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','public_loc',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.public_loc,:new.public_loc); end if;
    if voper <> 'U' or ( updating('doc_content') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('DOCUMENT','doc_content',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.doc_content,:new.doc_content); end if;
    
    if (voper <> 'U' or  updating('rsrc_id')) and PRM_AUDIT.column_audited('rsrc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','rsrc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_id,:new.rsrc_id); end if;
    
    if (voper <> 'U' or  updating('doc_mgmt_type')) and PRM_AUDIT.column_audited('doc_mgmt_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','doc_mgmt_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.doc_mgmt_type,:new.doc_mgmt_type); end if;
    
    if (voper <> 'U' or  updating('external_doc_key')) and PRM_AUDIT.column_audited('external_doc_key', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','external_doc_key',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.external_doc_key,:new.external_doc_key); end if;
    
    if (voper <> 'U' or  updating('cr_external_doc_key')) and PRM_AUDIT.column_audited('cr_external_doc_key', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('DOCUMENT','cr_external_doc_key',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cr_external_doc_key,:new.cr_external_doc_key); end if;
  end if;
  PRM_AUDIT.audit_row ( 'DOCUMENT',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_DOCUMENT_DEL

--METADATA NAME:RT_DOCUMENT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCUMENT_DEL
BEFORE DELETE ON DOCUMENT
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'DOCUMENT',:old.doc_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_DOCUMENT

--METADATA NAME:RT_DOCUMENT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_DOCUMENT
BEFORE UPDATE OR INSERT ON DOCUMENT
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'DOCUMENT',:old.doc_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.doc_id)
			  and table_name = 'DOCUMENT';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_EXPPROJ

--METADATA NAME:PRMAUD_EXPPROJ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_EXPPROJ
after insert or update or delete on EXPPROJ
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('EXPPROJ',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proj_id;
				
    
    else
    	vpk1 := :new.proj_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('exp_group')) and PRM_AUDIT.column_audited('exp_group', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','exp_group',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.exp_group,:new.exp_group); end if;
    
    if (voper <> 'U' or  updating('exp_proj_name')) and PRM_AUDIT.column_audited('exp_proj_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','exp_proj_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.exp_proj_name,:new.exp_proj_name); end if;
    
    if (voper <> 'U' or  updating('login_supplied_flag')) and PRM_AUDIT.column_audited('login_supplied_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','login_supplied_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.login_supplied_flag,:new.login_supplied_flag); end if;
    
    if (voper <> 'U' or  updating('exp_user_name')) and PRM_AUDIT.column_audited('exp_user_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','exp_user_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.exp_user_name,:new.exp_user_name); end if;
    
    if (voper <> 'U' or  updating('exp_passwd')) and PRM_AUDIT.column_audited('exp_passwd', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXPPROJ','exp_passwd',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.exp_passwd,:new.exp_passwd); end if;
  end if;
  PRM_AUDIT.audit_row ( 'EXPPROJ',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_EXPPROJ_DEL

--METADATA NAME:RT_EXPPROJ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_EXPPROJ_DEL
BEFORE DELETE ON EXPPROJ
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'EXPPROJ',:old.proj_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_EXPPROJ

--METADATA NAME:RT_EXPPROJ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_EXPPROJ
BEFORE UPDATE OR INSERT ON EXPPROJ
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.proj_id)
		and table_name = 'EXPPROJ';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'EXPPROJ',:old.proj_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proj_id)
			  and table_name = 'EXPPROJ';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_EXTAPP

--METADATA NAME:PRMAUD_EXTAPP TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_EXTAPP
after insert or update or delete on EXTAPP
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('EXTAPP',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.app_id;
				
    
    else
    	vpk1 := :new.app_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('app_id')) and PRM_AUDIT.column_audited('app_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.app_id,:new.app_id); end if;
    
    if (voper <> 'U' or  updating('login_supply_flag')) and PRM_AUDIT.column_audited('login_supply_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','login_supply_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.login_supply_flag,:new.login_supply_flag); end if;
    
    if (voper <> 'U' or  updating('app_name')) and PRM_AUDIT.column_audited('app_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_name,:new.app_name); end if;
    
    if (voper <> 'U' or  updating('app_exe_name')) and PRM_AUDIT.column_audited('app_exe_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_exe_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_exe_name,:new.app_exe_name); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('app_user_name')) and PRM_AUDIT.column_audited('app_user_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_user_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_user_name,:new.app_user_name); end if;
    
    if (voper <> 'U' or  updating('app_passwd')) and PRM_AUDIT.column_audited('app_passwd', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_passwd',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_passwd,:new.app_passwd); end if;
    
    if (voper <> 'U' or  updating('app_data_name')) and PRM_AUDIT.column_audited('app_data_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_data_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_data_name,:new.app_data_name); end if;
    
    if (voper <> 'U' or  updating('app_parm_string')) and PRM_AUDIT.column_audited('app_parm_string', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_parm_string',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_parm_string,:new.app_parm_string); end if;
    
    if (voper <> 'U' or  updating('app_data_loc')) and PRM_AUDIT.column_audited('app_data_loc', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('EXTAPP','app_data_loc',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.app_data_loc,:new.app_data_loc); end if;
  end if;
  PRM_AUDIT.audit_row ( 'EXTAPP',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_EXTAPP_DEL

--METADATA NAME:RT_EXTAPP_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_EXTAPP_DEL
BEFORE DELETE ON EXTAPP
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'EXTAPP',:old.app_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_EXTAPP

--METADATA NAME:RT_EXTAPP TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_EXTAPP
BEFORE UPDATE OR INSERT ON EXTAPP
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'EXTAPP',:old.app_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.app_id)
			  and table_name = 'EXTAPP';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FACTOR

--METADATA NAME:PRMAUD_FACTOR TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FACTOR
after insert or update or delete on FACTOR
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FACTOR',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.fact_id;
				
    
    else
    	vpk1 := :new.fact_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('fact_id')) and PRM_AUDIT.column_audited('fact_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTOR','fact_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.fact_id,:new.fact_id); end if;
    
    if (voper <> 'U' or  updating('fact_seq_num')) and PRM_AUDIT.column_audited('fact_seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTOR','fact_seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_seq_num,:new.fact_seq_num); end if;
    
    if (voper <> 'U' or  updating('fact_type')) and PRM_AUDIT.column_audited('fact_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTOR','fact_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_type,:new.fact_type); end if;
    
    if (voper <> 'U' or  updating('fact_name')) and PRM_AUDIT.column_audited('fact_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTOR','fact_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_name,:new.fact_name); end if;
    
    if (voper <> 'U' or  updating('def_fact_val_id')) and PRM_AUDIT.column_audited('def_fact_val_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTOR','def_fact_val_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_fact_val_id,:new.def_fact_val_id); end if;
    if voper <> 'U' or ( updating('fact_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('FACTOR','fact_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.fact_descr,:new.fact_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FACTOR',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FACTOR_DEL

--METADATA NAME:RT_FACTOR_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FACTOR_DEL
BEFORE DELETE ON FACTOR
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FACTOR',:old.fact_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FACTOR

--METADATA NAME:RT_FACTOR TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FACTOR
BEFORE UPDATE OR INSERT ON FACTOR
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FACTOR',:old.fact_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.fact_id)
			  and table_name = 'FACTOR';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FACTVAL

--METADATA NAME:PRMAUD_FACTVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FACTVAL
after insert or update or delete on FACTVAL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FACTVAL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.fact_val_id;
				
    
    else
    	vpk1 := :new.fact_val_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('fact_val_id')) and PRM_AUDIT.column_audited('fact_val_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTVAL','fact_val_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.fact_val_id,:new.fact_val_id); end if;
    
    if (voper <> 'U' or  updating('fact_id')) and PRM_AUDIT.column_audited('fact_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTVAL','fact_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_id,:new.fact_id); end if;
    
    if (voper <> 'U' or  updating('fact_value')) and PRM_AUDIT.column_audited('fact_value', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTVAL','fact_value',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_value,:new.fact_value); end if;
    
    if (voper <> 'U' or  updating('fact_value_descr')) and PRM_AUDIT.column_audited('fact_value_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FACTVAL','fact_value_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fact_value_descr,:new.fact_value_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FACTVAL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FACTVAL_DEL

--METADATA NAME:RT_FACTVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FACTVAL_DEL
BEFORE DELETE ON FACTVAL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FACTVAL',:old.fact_val_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FACTVAL

--METADATA NAME:RT_FACTVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FACTVAL
BEFORE UPDATE OR INSERT ON FACTVAL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FACTVAL',:old.fact_val_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.fact_val_id)
			  and table_name = 'FACTVAL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FILTPROP

--METADATA NAME:PRMAUD_FILTPROP TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FILTPROP
after insert or update or delete on FILTPROP
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FILTPROP',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.filter_id;
				
    
    else
    	vpk1 := :new.filter_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('filter_id')) and PRM_AUDIT.column_audited('filter_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','filter_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.filter_id,:new.filter_id); end if;
    
    if (voper <> 'U' or  updating('table_name')) and PRM_AUDIT.column_audited('table_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','table_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.table_name,:new.table_name); end if;
    
    if (voper <> 'U' or  updating('filter_type')) and PRM_AUDIT.column_audited('filter_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','filter_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.filter_type,:new.filter_type); end if;
    
    if (voper <> 'U' or  updating('filter_name')) and PRM_AUDIT.column_audited('filter_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','filter_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.filter_name,:new.filter_name); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    if voper <> 'U' or ( updating('filter_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('FILTPROP','filter_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.filter_data,:new.filter_data); end if;
    
    if (voper <> 'U' or  updating('rpt_id')) and PRM_AUDIT.column_audited('rpt_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FILTPROP','rpt_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_id,:new.rpt_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FILTPROP',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FILTPROP_DEL

--METADATA NAME:RT_FILTPROP_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FILTPROP_DEL
BEFORE DELETE ON FILTPROP
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FILTPROP',:old.filter_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FILTPROP

--METADATA NAME:RT_FILTPROP TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FILTPROP
BEFORE UPDATE OR INSERT ON FILTPROP
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FILTPROP',:old.filter_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.filter_id)
			  and table_name = 'FILTPROP';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FINDATES

--METADATA NAME:PRMAUD_FINDATES TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FINDATES
after insert or update or delete on FINDATES
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FINDATES',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.fin_dates_id;
				
    
    else
    	vpk1 := :new.fin_dates_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('fin_dates_id')) and PRM_AUDIT.column_audited('fin_dates_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINDATES','fin_dates_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.fin_dates_id,:new.fin_dates_id); end if;
    
    if (voper <> 'U' or  updating('fin_dates_name')) and PRM_AUDIT.column_audited('fin_dates_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINDATES','fin_dates_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fin_dates_name,:new.fin_dates_name); end if;
    
    if (voper <> 'U' or  updating('start_date')) and PRM_AUDIT.column_audited('start_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINDATES','start_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.start_date,'yyyymmddhh24miss'),to_char(:new.start_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('end_date')) and PRM_AUDIT.column_audited('end_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINDATES','end_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.end_date,'yyyymmddhh24miss'),to_char(:new.end_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('fintmpl_id')) and PRM_AUDIT.column_audited('fintmpl_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINDATES','fintmpl_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fintmpl_id,:new.fintmpl_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FINDATES',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FINDATES_DEL

--METADATA NAME:RT_FINDATES_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FINDATES_DEL
BEFORE DELETE ON FINDATES
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FINDATES',:old.fin_dates_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FINDATES

--METADATA NAME:RT_FINDATES TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FINDATES
BEFORE UPDATE OR INSERT ON FINDATES
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FINDATES',:old.fin_dates_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.fin_dates_id)
			  and table_name = 'FINDATES';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FINTMPL

--METADATA NAME:PRMAUD_FINTMPL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FINTMPL
after insert or update or delete on FINTMPL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FINTMPL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.fintmpl_id;
				
    
    else
    	vpk1 := :new.fintmpl_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('fintmpl_id')) and PRM_AUDIT.column_audited('fintmpl_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINTMPL','fintmpl_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.fintmpl_id,:new.fintmpl_id); end if;
    
    if (voper <> 'U' or  updating('fintmpl_name')) and PRM_AUDIT.column_audited('fintmpl_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINTMPL','fintmpl_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fintmpl_name,:new.fintmpl_name); end if;
    
    if (voper <> 'U' or  updating('default_flag')) and PRM_AUDIT.column_audited('default_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FINTMPL','default_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_flag,:new.default_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FINTMPL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FINTMPL_DEL

--METADATA NAME:RT_FINTMPL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FINTMPL_DEL
BEFORE DELETE ON FINTMPL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FINTMPL',:old.fintmpl_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FINTMPL

--METADATA NAME:RT_FINTMPL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FINTMPL
BEFORE UPDATE OR INSERT ON FINTMPL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FINTMPL',:old.fintmpl_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.fintmpl_id)
			  and table_name = 'FINTMPL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FORMCATG

--METADATA NAME:PRMAUD_FORMCATG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FORMCATG
after insert or update or delete on FORMCATG
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FORMCATG',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.form_catg_id;
				
    
    else
    	vpk1 := :new.form_catg_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('form_catg_id')) and PRM_AUDIT.column_audited('form_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMCATG','form_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.form_catg_id,:new.form_catg_id); end if;
    
    if (voper <> 'U' or  updating('form_catg_name')) and PRM_AUDIT.column_audited('form_catg_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMCATG','form_catg_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.form_catg_name,:new.form_catg_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FORMCATG',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FORMCATG_DEL

--METADATA NAME:RT_FORMCATG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMCATG_DEL
BEFORE DELETE ON FORMCATG
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FORMCATG',:old.form_catg_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FORMCATG

--METADATA NAME:RT_FORMCATG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMCATG
BEFORE UPDATE OR INSERT ON FORMCATG
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FORMCATG',:old.form_catg_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.form_catg_id)
			  and table_name = 'FORMCATG';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FORMPROJ

--METADATA NAME:PRMAUD_FORMPROJ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FORMPROJ
after insert or update or delete on FORMPROJ
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FORMPROJ',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.form_tmpl_id;
				
    vpk2 := :old.proj_id;
				
    
    else
    	vpk1 := :new.form_tmpl_id;
				
    vpk2 := :new.proj_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('form_tmpl_id')) and PRM_AUDIT.column_audited('form_tmpl_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMPROJ','form_tmpl_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.form_tmpl_id,:new.form_tmpl_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMPROJ','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FORMPROJ',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FORMPROJ_DEL

--METADATA NAME:RT_FORMPROJ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMPROJ_DEL
BEFORE DELETE ON FORMPROJ
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'FORMPROJ',:old.form_tmpl_id,:old.proj_id,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_FORMPROJ

--METADATA NAME:RT_FORMPROJ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMPROJ
BEFORE UPDATE OR INSERT ON FORMPROJ
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.form_tmpl_id)
and pk2 = TO_CHAR(:new.proj_id)
		and table_name = 'FORMPROJ';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'FORMPROJ',:old.form_tmpl_id,:old.proj_id,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.form_tmpl_id)
and pk2 = TO_CHAR(:old.proj_id)
			  and table_name = 'FORMPROJ';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FORMTMPL

--METADATA NAME:PRMAUD_FORMTMPL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FORMTMPL
after insert or update or delete on FORMTMPL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FORMTMPL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.form_tmpl_id;
				
    
    else
    	vpk1 := :new.form_tmpl_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('form_tmpl_id')) and PRM_AUDIT.column_audited('form_tmpl_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMTMPL','form_tmpl_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.form_tmpl_id,:new.form_tmpl_id); end if;
    
    if (voper <> 'U' or  updating('form_tmpl_name')) and PRM_AUDIT.column_audited('form_tmpl_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMTMPL','form_tmpl_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.form_tmpl_name,:new.form_tmpl_name); end if;
    
    if (voper <> 'U' or  updating('form_tmpl_desc')) and PRM_AUDIT.column_audited('form_tmpl_desc', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMTMPL','form_tmpl_desc',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.form_tmpl_desc,:new.form_tmpl_desc); end if;
    
    if (voper <> 'U' or  updating('form_catg_id')) and PRM_AUDIT.column_audited('form_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FORMTMPL','form_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.form_catg_id,:new.form_catg_id); end if;
    if voper <> 'U' or ( updating('form_tmpl_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('FORMTMPL','form_tmpl_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.form_tmpl_data,:new.form_tmpl_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FORMTMPL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FORMTMPL_DEL

--METADATA NAME:RT_FORMTMPL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMTMPL_DEL
BEFORE DELETE ON FORMTMPL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FORMTMPL',:old.form_tmpl_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FORMTMPL

--METADATA NAME:RT_FORMTMPL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FORMTMPL
BEFORE UPDATE OR INSERT ON FORMTMPL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FORMTMPL',:old.form_tmpl_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.form_tmpl_id)
			  and table_name = 'FORMTMPL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_FUNDSRC

--METADATA NAME:PRMAUD_FUNDSRC TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_FUNDSRC
after insert or update or delete on FUNDSRC
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('FUNDSRC',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.fund_id;
				
    
    else
    	vpk1 := :new.fund_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('fund_id')) and PRM_AUDIT.column_audited('fund_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FUNDSRC','fund_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.fund_id,:new.fund_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FUNDSRC','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('fund_name')) and PRM_AUDIT.column_audited('fund_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FUNDSRC','fund_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fund_name,:new.fund_name); end if;
    
    if (voper <> 'U' or  updating('parent_fund_id')) and PRM_AUDIT.column_audited('parent_fund_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('FUNDSRC','parent_fund_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_fund_id,:new.parent_fund_id); end if;
    if voper <> 'U' or ( updating('fund_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('FUNDSRC','fund_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.fund_descr,:new.fund_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'FUNDSRC',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_FUNDSRC_DEL

--METADATA NAME:RT_FUNDSRC_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FUNDSRC_DEL
BEFORE DELETE ON FUNDSRC
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'FUNDSRC',:old.fund_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_FUNDSRC

--METADATA NAME:RT_FUNDSRC TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_FUNDSRC
BEFORE UPDATE OR INSERT ON FUNDSRC
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'FUNDSRC',:old.fund_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.fund_id)
			  and table_name = 'FUNDSRC';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_GCHANGE

--METADATA NAME:PRMAUD_GCHANGE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_GCHANGE
after insert or update or delete on GCHANGE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('GCHANGE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.gchange_id;
				
    
    else
    	vpk1 := :new.gchange_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('gchange_id')) and PRM_AUDIT.column_audited('gchange_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('GCHANGE','gchange_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.gchange_id,:new.gchange_id); end if;
    
    if (voper <> 'U' or  updating('gchange_name')) and PRM_AUDIT.column_audited('gchange_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('GCHANGE','gchange_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.gchange_name,:new.gchange_name); end if;
    if voper <> 'U' or ( updating('gchange_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('GCHANGE','gchange_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.gchange_data,:new.gchange_data); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('GCHANGE','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('table_name')) and PRM_AUDIT.column_audited('table_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('GCHANGE','table_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.table_name,:new.table_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'GCHANGE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_GCHANGE_DEL

--METADATA NAME:RT_GCHANGE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_GCHANGE_DEL
BEFORE DELETE ON GCHANGE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'GCHANGE',:old.gchange_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_GCHANGE

--METADATA NAME:RT_GCHANGE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_GCHANGE
BEFORE UPDATE OR INSERT ON GCHANGE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'GCHANGE',:old.gchange_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.gchange_id)
			  and table_name = 'GCHANGE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_IMAGEDATA

--METADATA NAME:PRMAUD_IMAGEDATA TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_IMAGEDATA
after insert or update or delete on IMAGEDATA
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('IMAGEDATA',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.image_id;
				
    
    else
    	vpk1 := :new.image_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('image_id')) and PRM_AUDIT.column_audited('image_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','image_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.image_id,:new.image_id); end if;
    
    if (voper <> 'U' or  updating('image_name')) and PRM_AUDIT.column_audited('image_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','image_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.image_name,:new.image_name); end if;
    if voper <> 'U' or ( updating('image_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('IMAGEDATA','image_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.image_data,:new.image_data); end if;
    if voper <> 'U' or ( updating('image_thumbnail') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('IMAGEDATA','image_thumbnail',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.image_thumbnail,:new.image_thumbnail); end if;
    
    if (voper <> 'U' or  updating('image_extension')) and PRM_AUDIT.column_audited('image_extension', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','image_extension',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.image_extension,:new.image_extension); end if;
    
    if (voper <> 'U' or  updating('default_flag')) and PRM_AUDIT.column_audited('default_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','default_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_flag,:new.default_flag); end if;
    
    if (voper <> 'U' or  updating('image_purpose')) and PRM_AUDIT.column_audited('image_purpose', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','image_purpose',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.image_purpose,:new.image_purpose); end if;
    
    if (voper <> 'U' or  updating('image_description')) and PRM_AUDIT.column_audited('image_description', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('IMAGEDATA','image_description',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.image_description,:new.image_description); end if;
  end if;
  PRM_AUDIT.audit_row ( 'IMAGEDATA',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_IMAGEDATA_DEL

--METADATA NAME:RT_IMAGEDATA_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_IMAGEDATA_DEL
BEFORE DELETE ON IMAGEDATA
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'IMAGEDATA',:old.image_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_IMAGEDATA

--METADATA NAME:RT_IMAGEDATA TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_IMAGEDATA
BEFORE UPDATE OR INSERT ON IMAGEDATA
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'IMAGEDATA',:old.image_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.image_id)
			  and table_name = 'IMAGEDATA';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ISSUHIST

--METADATA NAME:PRMAUD_ISSUHIST TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ISSUHIST
after insert or update or delete on ISSUHIST
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ISSUHIST',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.issue_id;
				
    
    else
    	vpk1 := :new.issue_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('issue_id')) and PRM_AUDIT.column_audited('issue_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ISSUHIST','issue_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.issue_id,:new.issue_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ISSUHIST','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    if voper <> 'U' or ( updating('issue_history') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('ISSUHIST','issue_history',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.issue_history,:new.issue_history); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ISSUHIST',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ISSUHIST_DEL

--METADATA NAME:RT_ISSUHIST_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ISSUHIST_DEL
BEFORE DELETE ON ISSUHIST
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'ISSUHIST',:old.issue_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_ISSUHIST

--METADATA NAME:RT_ISSUHIST TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ISSUHIST
BEFORE UPDATE OR INSERT ON ISSUHIST
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'ISSUHIST',:old.issue_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.issue_id)
			  and table_name = 'ISSUHIST';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ITERATION

--METADATA NAME:PRMAUD_ITERATION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ITERATION
after insert or update or delete on ITERATION
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ITERATION',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.iteration_id;
				
    
    else
    	vpk1 := :new.iteration_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('iteration_id')) and PRM_AUDIT.column_audited('iteration_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','iteration_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.iteration_id,:new.iteration_id); end if;
    
    if (voper <> 'U' or  updating('release_id')) and PRM_AUDIT.column_audited('release_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','release_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.release_id,:new.release_id); end if;
    
    if (voper <> 'U' or  updating('iteration_name')) and PRM_AUDIT.column_audited('iteration_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','iteration_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.iteration_name,:new.iteration_name); end if;
    
    if (voper <> 'U' or  updating('start_date')) and PRM_AUDIT.column_audited('start_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','start_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.start_date,'yyyymmddhh24miss'),to_char(:new.start_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('end_date')) and PRM_AUDIT.column_audited('end_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','end_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.end_date,'yyyymmddhh24miss'),to_char(:new.end_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('termination_date')) and PRM_AUDIT.column_audited('termination_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','termination_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.termination_date,'yyyymmddhh24miss'),to_char(:new.termination_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('capacity_pct')) and PRM_AUDIT.column_audited('capacity_pct', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','capacity_pct',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.capacity_pct,:new.capacity_pct); end if;
    
    if (voper <> 'U' or  updating('remain_qty')) and PRM_AUDIT.column_audited('remain_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERATION','remain_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.remain_qty,:new.remain_qty); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ITERATION',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ITERATION_DEL

--METADATA NAME:RT_ITERATION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERATION_DEL
BEFORE DELETE ON ITERATION
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ITERATION',:old.iteration_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ITERATION

--METADATA NAME:RT_ITERATION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERATION
BEFORE UPDATE OR INSERT ON ITERATION
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ITERATION',:old.iteration_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.iteration_id)
			  and table_name = 'ITERATION';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ITERDAYS

--METADATA NAME:PRMAUD_ITERDAYS TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ITERDAYS
after insert or update or delete on ITERDAYS
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ITERDAYS',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.task_id;
				
    vpk2 := :old.day_number;
				
    
    else
    	vpk1 := :new.task_id;
				
    vpk2 := :new.day_number;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('task_id')) and PRM_AUDIT.column_audited('task_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','task_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.task_id,:new.task_id); end if;
    
    if (voper <> 'U' or  updating('day_number')) and PRM_AUDIT.column_audited('day_number', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','day_number',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.day_number,:new.day_number); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('iteration_id')) and PRM_AUDIT.column_audited('iteration_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','iteration_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.iteration_id,:new.iteration_id); end if;
    
    if (voper <> 'U' or  updating('act_work_qty')) and PRM_AUDIT.column_audited('act_work_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','act_work_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.act_work_qty,:new.act_work_qty); end if;
    
    if (voper <> 'U' or  updating('remain_work_qty')) and PRM_AUDIT.column_audited('remain_work_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERDAYS','remain_work_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.remain_work_qty,:new.remain_work_qty); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ITERDAYS',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ITERDAYS_DEL

--METADATA NAME:RT_ITERDAYS_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERDAYS_DEL
BEFORE DELETE ON ITERDAYS
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'ITERDAYS',:old.task_id,:old.day_number,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_ITERDAYS

--METADATA NAME:RT_ITERDAYS TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERDAYS
BEFORE UPDATE OR INSERT ON ITERDAYS
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.task_id)
and pk2 = TO_CHAR(:new.day_number)
		and table_name = 'ITERDAYS';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'ITERDAYS',:old.task_id,:old.day_number,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.task_id)
and pk2 = TO_CHAR(:old.day_number)
			  and table_name = 'ITERDAYS';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_ITERGOAL

--METADATA NAME:PRMAUD_ITERGOAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_ITERGOAL
after insert or update or delete on ITERGOAL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('ITERGOAL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.iter_goal_id;
				
    
    else
    	vpk1 := :new.iter_goal_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('iter_goal_id')) and PRM_AUDIT.column_audited('iter_goal_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','iter_goal_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.iter_goal_id,:new.iter_goal_id); end if;
    
    if (voper <> 'U' or  updating('iteration_id')) and PRM_AUDIT.column_audited('iteration_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','iteration_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.iteration_id,:new.iteration_id); end if;
    
    if (voper <> 'U' or  updating('goal_name')) and PRM_AUDIT.column_audited('goal_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','goal_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.goal_name,:new.goal_name); end if;
    
    if (voper <> 'U' or  updating('goal_descr')) and PRM_AUDIT.column_audited('goal_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','goal_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.goal_descr,:new.goal_descr); end if;
    
    if (voper <> 'U' or  updating('status_code')) and PRM_AUDIT.column_audited('status_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','status_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status_code,:new.status_code); end if;
    
    if (voper <> 'U' or  updating('rfolio_id')) and PRM_AUDIT.column_audited('rfolio_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('ITERGOAL','rfolio_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rfolio_id,:new.rfolio_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'ITERGOAL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_ITERGOAL_DEL

--METADATA NAME:RT_ITERGOAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERGOAL_DEL
BEFORE DELETE ON ITERGOAL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'ITERGOAL',:old.iter_goal_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_ITERGOAL

--METADATA NAME:RT_ITERGOAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_ITERGOAL
BEFORE UPDATE OR INSERT ON ITERGOAL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'ITERGOAL',:old.iter_goal_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.iter_goal_id)
			  and table_name = 'ITERGOAL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_JOBLOG

--METADATA NAME:PRMAUD_JOBLOG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_JOBLOG
after insert or update or delete on JOBLOG
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('JOBLOG',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.job_id;
				
    
    else
    	vpk1 := :new.job_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('job_id')) and PRM_AUDIT.column_audited('job_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBLOG','job_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.job_id,:new.job_id); end if;
    if voper <> 'U' or ( updating('job_log_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('JOBLOG','job_log_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.job_log_data,:new.job_log_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'JOBLOG',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_JOBLOG_DEL

--METADATA NAME:RT_JOBLOG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBLOG_DEL
BEFORE DELETE ON JOBLOG
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'JOBLOG',:old.job_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_JOBLOG

--METADATA NAME:RT_JOBLOG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBLOG
BEFORE UPDATE OR INSERT ON JOBLOG
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'JOBLOG',:old.job_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.job_id)
			  and table_name = 'JOBLOG';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_JOBRPT

--METADATA NAME:PRMAUD_JOBRPT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_JOBRPT
after insert or update or delete on JOBRPT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('JOBRPT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.job_id;
				
    vpk2 := :old.rpt_id;
				
    
    else
    	vpk1 := :new.job_id;
				
    vpk2 := :new.rpt_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('job_id')) and PRM_AUDIT.column_audited('job_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBRPT','job_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.job_id,:new.job_id); end if;
    
    if (voper <> 'U' or  updating('rpt_id')) and PRM_AUDIT.column_audited('rpt_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBRPT','rpt_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_id,:new.rpt_id); end if;
    
    if (voper <> 'U' or  updating('table_name')) and PRM_AUDIT.column_audited('table_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBRPT','table_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.table_name,:new.table_name); end if;
    
    if (voper <> 'U' or  updating('fk_id')) and PRM_AUDIT.column_audited('fk_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBRPT','fk_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fk_id,:new.fk_id); end if;
    if voper <> 'U' or ( updating('jobrpt_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('JOBRPT','jobrpt_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.jobrpt_data,:new.jobrpt_data); end if;
    
    if (voper <> 'U' or  updating('personal_portal_flag')) and PRM_AUDIT.column_audited('personal_portal_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBRPT','personal_portal_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.personal_portal_flag,:new.personal_portal_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'JOBRPT',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_JOBRPT_DEL

--METADATA NAME:RT_JOBRPT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBRPT_DEL
BEFORE DELETE ON JOBRPT
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'JOBRPT',:old.job_id,:old.rpt_id,null,null );

end; 
/
show err
prompt Creating trigger RT_JOBRPT

--METADATA NAME:RT_JOBRPT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBRPT
BEFORE UPDATE OR INSERT ON JOBRPT
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.job_id)
and pk2 = TO_CHAR(:new.rpt_id)
		and table_name = 'JOBRPT';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'JOBRPT',:old.job_id,:old.rpt_id,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.job_id)
and pk2 = TO_CHAR(:old.rpt_id)
			  and table_name = 'JOBRPT';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_JOBSVC

--METADATA NAME:PRMAUD_JOBSVC TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_JOBSVC
after insert or update or delete on JOBSVC
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('JOBSVC',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.job_id;
				
    
    else
    	vpk1 := :new.job_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('job_id')) and PRM_AUDIT.column_audited('job_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','job_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.job_id,:new.job_id); end if;
    
    if (voper <> 'U' or  updating('parent_job_id')) and PRM_AUDIT.column_audited('parent_job_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','parent_job_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_job_id,:new.parent_job_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('audit_flag')) and PRM_AUDIT.column_audited('audit_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','audit_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.audit_flag,:new.audit_flag); end if;
    
    if (voper <> 'U' or  updating('job_type')) and PRM_AUDIT.column_audited('job_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','job_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.job_type,:new.job_type); end if;
    
    if (voper <> 'U' or  updating('job_name')) and PRM_AUDIT.column_audited('job_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','job_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.job_name,:new.job_name); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('last_run_date')) and PRM_AUDIT.column_audited('last_run_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','last_run_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_run_date,'yyyymmddhh24miss'),to_char(:new.last_run_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('status_code')) and PRM_AUDIT.column_audited('status_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','status_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.status_code,:new.status_code); end if;
    
    if (voper <> 'U' or  updating('recur_data')) and PRM_AUDIT.column_audited('recur_data', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','recur_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.recur_data,:new.recur_data); end if;
    
    if (voper <> 'U' or  updating('recur_type')) and PRM_AUDIT.column_audited('recur_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','recur_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.recur_type,:new.recur_type); end if;
    
    if (voper <> 'U' or  updating('submitted_date')) and PRM_AUDIT.column_audited('submitted_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','submitted_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.submitted_date,'yyyymmddhh24miss'),to_char(:new.submitted_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('last_error_descr')) and PRM_AUDIT.column_audited('last_error_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','last_error_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.last_error_descr,:new.last_error_descr); end if;
    
    if (voper <> 'U' or  updating('audit_file_path')) and PRM_AUDIT.column_audited('audit_file_path', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('JOBSVC','audit_file_path',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.audit_file_path,:new.audit_file_path); end if;
    if voper <> 'U' or ( updating('job_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('JOBSVC','job_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.job_data,:new.job_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'JOBSVC',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_JOBSVC_DEL

--METADATA NAME:RT_JOBSVC_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBSVC_DEL
BEFORE DELETE ON JOBSVC
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'JOBSVC',:old.job_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_JOBSVC

--METADATA NAME:RT_JOBSVC TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_JOBSVC
BEFORE UPDATE OR INSERT ON JOBSVC
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'JOBSVC',:old.job_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.job_id)
			  and table_name = 'JOBSVC';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_LOCATION

--METADATA NAME:PRMAUD_LOCATION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_LOCATION
after insert or update or delete on LOCATION
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('LOCATION',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.location_id;
				
    
    else
    	vpk1 := :new.location_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('location_id')) and PRM_AUDIT.column_audited('location_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','location_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.location_id,:new.location_id); end if;
    
    if (voper <> 'U' or  updating('location_name')) and PRM_AUDIT.column_audited('location_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','location_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.location_name,:new.location_name); end if;
    
    if (voper <> 'U' or  updating('location_type')) and PRM_AUDIT.column_audited('location_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','location_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.location_type,:new.location_type); end if;
    
    if (voper <> 'U' or  updating('address_line1')) and PRM_AUDIT.column_audited('address_line1', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','address_line1',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.address_line1,:new.address_line1); end if;
    
    if (voper <> 'U' or  updating('address_line2')) and PRM_AUDIT.column_audited('address_line2', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','address_line2',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.address_line2,:new.address_line2); end if;
    
    if (voper <> 'U' or  updating('address_line3')) and PRM_AUDIT.column_audited('address_line3', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','address_line3',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.address_line3,:new.address_line3); end if;
    
    if (voper <> 'U' or  updating('city_name')) and PRM_AUDIT.column_audited('city_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','city_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.city_name,:new.city_name); end if;
    
    if (voper <> 'U' or  updating('municipality_name')) and PRM_AUDIT.column_audited('municipality_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','municipality_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.municipality_name,:new.municipality_name); end if;
    
    if (voper <> 'U' or  updating('state_name')) and PRM_AUDIT.column_audited('state_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','state_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.state_name,:new.state_name); end if;
    
    if (voper <> 'U' or  updating('state_code')) and PRM_AUDIT.column_audited('state_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','state_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.state_code,:new.state_code); end if;
    
    if (voper <> 'U' or  updating('country_name')) and PRM_AUDIT.column_audited('country_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','country_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.country_name,:new.country_name); end if;
    
    if (voper <> 'U' or  updating('country_code')) and PRM_AUDIT.column_audited('country_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','country_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.country_code,:new.country_code); end if;
    
    if (voper <> 'U' or  updating('postal_code')) and PRM_AUDIT.column_audited('postal_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','postal_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.postal_code,:new.postal_code); end if;
    
    if (voper <> 'U' or  updating('longitude')) and PRM_AUDIT.column_audited('longitude', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','longitude',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.longitude,:new.longitude); end if;
    
    if (voper <> 'U' or  updating('latitude')) and PRM_AUDIT.column_audited('latitude', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('LOCATION','latitude',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.latitude,:new.latitude); end if;
  end if;
  PRM_AUDIT.audit_row ( 'LOCATION',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_LOCATION_DEL

--METADATA NAME:RT_LOCATION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_LOCATION_DEL
BEFORE DELETE ON LOCATION
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'LOCATION',:old.location_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_LOCATION

--METADATA NAME:RT_LOCATION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_LOCATION
BEFORE UPDATE OR INSERT ON LOCATION
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'LOCATION',:old.location_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.location_id)
			  and table_name = 'LOCATION';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_MEMOTYPE

--METADATA NAME:PRMAUD_MEMOTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_MEMOTYPE
after insert or update or delete on MEMOTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('MEMOTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.memo_type_id;
				
    
    else
    	vpk1 := :new.memo_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('memo_type_id')) and PRM_AUDIT.column_audited('memo_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','memo_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.memo_type_id,:new.memo_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('eps_flag')) and PRM_AUDIT.column_audited('eps_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','eps_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.eps_flag,:new.eps_flag); end if;
    
    if (voper <> 'U' or  updating('proj_flag')) and PRM_AUDIT.column_audited('proj_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','proj_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_flag,:new.proj_flag); end if;
    
    if (voper <> 'U' or  updating('wbs_flag')) and PRM_AUDIT.column_audited('wbs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','wbs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.wbs_flag,:new.wbs_flag); end if;
    
    if (voper <> 'U' or  updating('task_flag')) and PRM_AUDIT.column_audited('task_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','task_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_flag,:new.task_flag); end if;
    
    if (voper <> 'U' or  updating('memo_type')) and PRM_AUDIT.column_audited('memo_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('MEMOTYPE','memo_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.memo_type,:new.memo_type); end if;
  end if;
  PRM_AUDIT.audit_row ( 'MEMOTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_MEMOTYPE_DEL

--METADATA NAME:RT_MEMOTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_MEMOTYPE_DEL
BEFORE DELETE ON MEMOTYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'MEMOTYPE',:old.memo_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_MEMOTYPE

--METADATA NAME:RT_MEMOTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_MEMOTYPE
BEFORE UPDATE OR INSERT ON MEMOTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'MEMOTYPE',:old.memo_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.memo_type_id)
			  and table_name = 'MEMOTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_NONWORK

--METADATA NAME:PRMAUD_NONWORK TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_NONWORK
after insert or update or delete on NONWORK
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('NONWORK',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.nonwork_type_id;
				
    
    else
    	vpk1 := :new.nonwork_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('nonwork_type_id')) and PRM_AUDIT.column_audited('nonwork_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NONWORK','nonwork_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.nonwork_type_id,:new.nonwork_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NONWORK','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('nonwork_code')) and PRM_AUDIT.column_audited('nonwork_code', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NONWORK','nonwork_code',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.nonwork_code,:new.nonwork_code); end if;
    
    if (voper <> 'U' or  updating('nonwork_type')) and PRM_AUDIT.column_audited('nonwork_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NONWORK','nonwork_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.nonwork_type,:new.nonwork_type); end if;
  end if;
  PRM_AUDIT.audit_row ( 'NONWORK',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_NONWORK_DEL

--METADATA NAME:RT_NONWORK_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_NONWORK_DEL
BEFORE DELETE ON NONWORK
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'NONWORK',:old.nonwork_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_NONWORK

--METADATA NAME:RT_NONWORK TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_NONWORK
BEFORE UPDATE OR INSERT ON NONWORK
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'NONWORK',:old.nonwork_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.nonwork_type_id)
			  and table_name = 'NONWORK';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger TR_NOTE_FK

--METADATA NAME:TR_NOTE_FK TYPE:TRIGGER SET:INTEGRITY CHANGE:CREATE
CREATE OR REPLACE TRIGGER TR_NOTE_FK
BEFORE UPDATE OR INSERT ON NOTE
FOR EACH ROW
DECLARE
  vpk_id           number(10);
BEGIN
  begin
    if upper(:new.table_name) = 'SCENARIO' then
      select scenario_id into vpk_id
      from scenario
      where scenario_id = :new.fk_id;
    end if;
  exception
    when no_data_found then
      raise_application_error(-20300,'Integrity Error. Foreign key id ' ||
                             to_char(:new.fk_id )||' does not exist in table ' || upper(:new.table_name) );
   end;      
END;
/
show err
prompt Creating trigger PRMAUD_NOTE

--METADATA NAME:PRMAUD_NOTE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_NOTE
after insert or update or delete on NOTE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('NOTE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.note_id;
				
    
    else
    	vpk1 := :new.note_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('note_id')) and PRM_AUDIT.column_audited('note_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','note_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.note_id,:new.note_id); end if;
    
    if (voper <> 'U' or  updating('table_name')) and PRM_AUDIT.column_audited('table_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','table_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.table_name,:new.table_name); end if;
    
    if (voper <> 'U' or  updating('type_name')) and PRM_AUDIT.column_audited('type_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','type_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.type_name,:new.type_name); end if;
    
    if (voper <> 'U' or  updating('fk_id')) and PRM_AUDIT.column_audited('fk_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','fk_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fk_id,:new.fk_id); end if;
    
    if (voper <> 'U' or  updating('note_date')) and PRM_AUDIT.column_audited('note_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','note_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.note_date,'yyyymmddhh24miss'),to_char(:new.note_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('note_value')) and PRM_AUDIT.column_audited('note_value', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','note_value',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.note_value,:new.note_value); end if;
    
    if (voper <> 'U' or  updating('user_name')) and PRM_AUDIT.column_audited('user_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('NOTE','user_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_name,:new.user_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'NOTE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_NOTE_DEL

--METADATA NAME:RT_NOTE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_NOTE_DEL
BEFORE DELETE ON NOTE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'NOTE',:old.note_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_NOTE

--METADATA NAME:RT_NOTE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_NOTE
BEFORE UPDATE OR INSERT ON NOTE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'NOTE',:old.note_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.note_id)
			  and table_name = 'NOTE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_OBS

--METADATA NAME:PRMAUD_OBS TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_OBS
after insert or update or delete on OBS
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('OBS',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.obs_id;
				
    
    else
    	vpk1 := :new.obs_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('obs_id')) and PRM_AUDIT.column_audited('obs_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('OBS','obs_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.obs_id,:new.obs_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('OBS','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('obs_name')) and PRM_AUDIT.column_audited('obs_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('OBS','obs_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.obs_name,:new.obs_name); end if;
    
    if (voper <> 'U' or  updating('parent_obs_id')) and PRM_AUDIT.column_audited('parent_obs_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('OBS','parent_obs_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_obs_id,:new.parent_obs_id); end if;
    
    if (voper <> 'U' or  updating('guid')) and PRM_AUDIT.column_audited('guid', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('OBS','guid',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.guid,:new.guid); end if;
    if voper <> 'U' or ( updating('obs_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('OBS','obs_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.obs_descr,:new.obs_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'OBS',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_OBS_DEL

--METADATA NAME:RT_OBS_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_OBS_DEL
BEFORE DELETE ON OBS
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'OBS',:old.obs_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_OBS

--METADATA NAME:RT_OBS TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_OBS
BEFORE UPDATE OR INSERT ON OBS
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'OBS',:old.obs_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.obs_id)
			  and table_name = 'OBS';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PCATTYPE

--METADATA NAME:PRMAUD_PCATTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PCATTYPE
after insert or update or delete on PCATTYPE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PCATTYPE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proj_catg_type_id;
				
    
    else
    	vpk1 := :new.proj_catg_type_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proj_catg_type_id')) and PRM_AUDIT.column_audited('proj_catg_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','proj_catg_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proj_catg_type_id,:new.proj_catg_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('proj_catg_short_len')) and PRM_AUDIT.column_audited('proj_catg_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','proj_catg_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_short_len,:new.proj_catg_short_len); end if;
    
    if (voper <> 'U' or  updating('proj_catg_type')) and PRM_AUDIT.column_audited('proj_catg_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','proj_catg_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_type,:new.proj_catg_type); end if;
    
    if (voper <> 'U' or  updating('super_flag')) and PRM_AUDIT.column_audited('super_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','super_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.super_flag,:new.super_flag); end if;
    
    if (voper <> 'U' or  updating('proj_catg_type_wt')) and PRM_AUDIT.column_audited('proj_catg_type_wt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','proj_catg_type_wt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_type_wt,:new.proj_catg_type_wt); end if;
    
    if (voper <> 'U' or  updating('max_proj_catg_wt')) and PRM_AUDIT.column_audited('max_proj_catg_wt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATTYPE','max_proj_catg_wt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_proj_catg_wt,:new.max_proj_catg_wt); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PCATTYPE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PCATTYPE_DEL

--METADATA NAME:RT_PCATTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATTYPE_DEL
BEFORE DELETE ON PCATTYPE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PCATTYPE',:old.proj_catg_type_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PCATTYPE

--METADATA NAME:RT_PCATTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATTYPE
BEFORE UPDATE OR INSERT ON PCATTYPE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PCATTYPE',:old.proj_catg_type_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proj_catg_type_id)
			  and table_name = 'PCATTYPE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PCATUSER

--METADATA NAME:PRMAUD_PCATUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PCATUSER
after insert or update or delete on PCATUSER
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PCATUSER',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proj_catg_id;
				
    vpk2 := :old.user_id;
				
    
    else
    	vpk1 := :new.proj_catg_id;
				
    vpk2 := :new.user_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proj_catg_id')) and PRM_AUDIT.column_audited('proj_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATUSER','proj_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proj_catg_id,:new.proj_catg_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATUSER','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PCATUSER',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PCATUSER_DEL

--METADATA NAME:RT_PCATUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATUSER_DEL
BEFORE DELETE ON PCATUSER
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PCATUSER',:old.proj_catg_id,:old.user_id,null,null );

end; 
/
show err
prompt Creating trigger RT_PCATUSER

--METADATA NAME:RT_PCATUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATUSER
BEFORE UPDATE OR INSERT ON PCATUSER
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.proj_catg_id)
and pk2 = TO_CHAR(:new.user_id)
		and table_name = 'PCATUSER';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PCATUSER',:old.proj_catg_id,:old.user_id,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proj_catg_id)
and pk2 = TO_CHAR(:old.user_id)
			  and table_name = 'PCATUSER';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PCATVAL

--METADATA NAME:PRMAUD_PCATVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PCATVAL
after insert or update or delete on PCATVAL
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PCATVAL',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proj_catg_id;
				
    
    else
    	vpk1 := :new.proj_catg_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proj_catg_id')) and PRM_AUDIT.column_audited('proj_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','proj_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proj_catg_id,:new.proj_catg_id); end if;
    
    if (voper <> 'U' or  updating('proj_catg_type_id')) and PRM_AUDIT.column_audited('proj_catg_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','proj_catg_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_type_id,:new.proj_catg_type_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('proj_catg_short_name')) and PRM_AUDIT.column_audited('proj_catg_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','proj_catg_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_short_name,:new.proj_catg_short_name); end if;
    
    if (voper <> 'U' or  updating('parent_proj_catg_id')) and PRM_AUDIT.column_audited('parent_proj_catg_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','parent_proj_catg_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.parent_proj_catg_id,:new.parent_proj_catg_id); end if;
    
    if (voper <> 'U' or  updating('proj_catg_name')) and PRM_AUDIT.column_audited('proj_catg_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','proj_catg_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_name,:new.proj_catg_name); end if;
    
    if (voper <> 'U' or  updating('proj_catg_wt')) and PRM_AUDIT.column_audited('proj_catg_wt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PCATVAL','proj_catg_wt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_catg_wt,:new.proj_catg_wt); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PCATVAL',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PCATVAL_DEL

--METADATA NAME:RT_PCATVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATVAL_DEL
BEFORE DELETE ON PCATVAL
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PCATVAL',:old.proj_catg_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PCATVAL

--METADATA NAME:RT_PCATVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PCATVAL
BEFORE UPDATE OR INSERT ON PCATVAL
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
  UPDATE PCATTYPE SET update_date = sysdate WHERE proj_catg_type_id = :NEW.proj_catg_type_id;

		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PCATVAL',:old.proj_catg_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proj_catg_id)
			  and table_name = 'PCATVAL';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PFOLIO

--METADATA NAME:PRMAUD_PFOLIO TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PFOLIO
after insert or update or delete on PFOLIO
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PFOLIO',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.pfolio_id;
				
    
    else
    	vpk1 := :new.pfolio_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('pfolio_id')) and PRM_AUDIT.column_audited('pfolio_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','pfolio_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.pfolio_id,:new.pfolio_id); end if;
    
    if (voper <> 'U' or  updating('closed_proj_flag')) and PRM_AUDIT.column_audited('closed_proj_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','closed_proj_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.closed_proj_flag,:new.closed_proj_flag); end if;
    
    if (voper <> 'U' or  updating('whatif_proj_flag')) and PRM_AUDIT.column_audited('whatif_proj_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','whatif_proj_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.whatif_proj_flag,:new.whatif_proj_flag); end if;
    
    if (voper <> 'U' or  updating('pfolio_type')) and PRM_AUDIT.column_audited('pfolio_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','pfolio_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pfolio_type,:new.pfolio_type); end if;
    
    if (voper <> 'U' or  updating('pfolio_name')) and PRM_AUDIT.column_audited('pfolio_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','pfolio_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pfolio_name,:new.pfolio_name); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
    
    if (voper <> 'U' or  updating('pfolio_descr')) and PRM_AUDIT.column_audited('pfolio_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','pfolio_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pfolio_descr,:new.pfolio_descr); end if;
    
    if (voper <> 'U' or  updating('last_refresh_date')) and PRM_AUDIT.column_audited('last_refresh_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIO','last_refresh_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_refresh_date,'yyyymmddhh24miss'),to_char(:new.last_refresh_date,'yyyymmddhh24miss')); end if;
    if voper <> 'U' or ( updating('pfolio_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('PFOLIO','pfolio_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.pfolio_data,:new.pfolio_data); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PFOLIO',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PFOLIO_DEL

--METADATA NAME:RT_PFOLIO_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PFOLIO_DEL
BEFORE DELETE ON PFOLIO
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PFOLIO',:old.pfolio_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PFOLIO

--METADATA NAME:RT_PFOLIO TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PFOLIO
BEFORE UPDATE OR INSERT ON PFOLIO
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PFOLIO',:old.pfolio_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.pfolio_id)
			  and table_name = 'PFOLIO';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PFOLIOUSER

--METADATA NAME:PRMAUD_PFOLIOUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PFOLIOUSER
after insert or update or delete on PFOLIOUSER
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PFOLIOUSER',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.pfolio_id;
				
    vpk2 := :old.user_id;
				
    
    else
    	vpk1 := :new.pfolio_id;
				
    vpk2 := :new.user_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('pfolio_id')) and PRM_AUDIT.column_audited('pfolio_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIOUSER','pfolio_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.pfolio_id,:new.pfolio_id); end if;
    
    if (voper <> 'U' or  updating('user_id')) and PRM_AUDIT.column_audited('user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PFOLIOUSER','user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.user_id,:new.user_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PFOLIOUSER',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PFOLIOUSER_DEL

--METADATA NAME:RT_PFOLIOUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PFOLIOUSER_DEL
BEFORE DELETE ON PFOLIOUSER
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PFOLIOUSER',:old.pfolio_id,:old.user_id,null,null );

end; 
/
show err
prompt Creating trigger RT_PFOLIOUSER

--METADATA NAME:RT_PFOLIOUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PFOLIOUSER
BEFORE UPDATE OR INSERT ON PFOLIOUSER
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.pfolio_id)
and pk2 = TO_CHAR(:new.user_id)
		and table_name = 'PFOLIOUSER';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PFOLIOUSER',:old.pfolio_id,:old.user_id,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.pfolio_id)
and pk2 = TO_CHAR(:old.user_id)
			  and table_name = 'PFOLIOUSER';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PHASE

--METADATA NAME:PRMAUD_PHASE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PHASE
after insert or update or delete on PHASE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PHASE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.phase_id;
				
    
    else
    	vpk1 := :new.phase_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('phase_id')) and PRM_AUDIT.column_audited('phase_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PHASE','phase_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.phase_id,:new.phase_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PHASE','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('phase_name')) and PRM_AUDIT.column_audited('phase_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PHASE','phase_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.phase_name,:new.phase_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PHASE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PHASE_DEL

--METADATA NAME:RT_PHASE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PHASE_DEL
BEFORE DELETE ON PHASE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PHASE',:old.phase_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PHASE

--METADATA NAME:RT_PHASE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PHASE
BEFORE UPDATE OR INSERT ON PHASE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PHASE',:old.phase_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.phase_id)
			  and table_name = 'PHASE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_POBS

--METADATA NAME:PRMAUD_POBS TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_POBS
after insert or update or delete on POBS
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('POBS',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.pobs_id;
				
    
    else
    	vpk1 := :new.pobs_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('pobs_id')) and PRM_AUDIT.column_audited('pobs_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','pobs_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.pobs_id,:new.pobs_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('pobs_name')) and PRM_AUDIT.column_audited('pobs_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','pobs_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pobs_name,:new.pobs_name); end if;
    
    if (voper <> 'U' or  updating('pobs_parent_id')) and PRM_AUDIT.column_audited('pobs_parent_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','pobs_parent_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pobs_parent_id,:new.pobs_parent_id); end if;
    
    if (voper <> 'U' or  updating('pobs_descr')) and PRM_AUDIT.column_audited('pobs_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','pobs_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pobs_descr,:new.pobs_descr); end if;
    
    if (voper <> 'U' or  updating('pobs_manager')) and PRM_AUDIT.column_audited('pobs_manager', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('POBS','pobs_manager',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pobs_manager,:new.pobs_manager); end if;
  end if;
  PRM_AUDIT.audit_row ( 'POBS',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_POBS_DEL

--METADATA NAME:RT_POBS_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_POBS_DEL
BEFORE DELETE ON POBS
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'POBS',:old.pobs_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_POBS

--METADATA NAME:RT_POBS TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_POBS
BEFORE UPDATE OR INSERT ON POBS
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'POBS',:old.pobs_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.pobs_id)
			  and table_name = 'POBS';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PREFER

--METADATA NAME:PRMAUD_PREFER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PREFER
after insert or update or delete on PREFER
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PREFER',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.prefer_id;
				
    
    else
    	vpk1 := :new.prefer_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('prefer_id')) and PRM_AUDIT.column_audited('prefer_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','prefer_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.prefer_id,:new.prefer_id); end if;
    
    if (voper <> 'U' or  updating('hr_decimal_cnt')) and PRM_AUDIT.column_audited('hr_decimal_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','hr_decimal_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.hr_decimal_cnt,:new.hr_decimal_cnt); end if;
    
    if (voper <> 'U' or  updating('xfer_complete_day_cnt')) and PRM_AUDIT.column_audited('xfer_complete_day_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','xfer_complete_day_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.xfer_complete_day_cnt,:new.xfer_complete_day_cnt); end if;
    
    if (voper <> 'U' or  updating('xfer_notstart_day_cnt')) and PRM_AUDIT.column_audited('xfer_notstart_day_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','xfer_notstart_day_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.xfer_notstart_day_cnt,:new.xfer_notstart_day_cnt); end if;
    
    if (voper <> 'U' or  updating('max_wbs_level_cnt')) and PRM_AUDIT.column_audited('max_wbs_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_wbs_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_wbs_level_cnt,:new.max_wbs_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_rsrc_level_cnt')) and PRM_AUDIT.column_audited('max_rsrc_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_rsrc_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_rsrc_level_cnt,:new.max_rsrc_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_acct_level_cnt')) and PRM_AUDIT.column_audited('max_acct_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_acct_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_acct_level_cnt,:new.max_acct_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_task_actv_type_cnt')) and PRM_AUDIT.column_audited('max_task_actv_type_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_task_actv_type_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_task_actv_type_cnt,:new.max_task_actv_type_cnt); end if;
    
    if (voper <> 'U' or  updating('future_ts_cnt')) and PRM_AUDIT.column_audited('future_ts_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','future_ts_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.future_ts_cnt,:new.future_ts_cnt); end if;
    
    if (voper <> 'U' or  updating('max_obs_level_cnt')) and PRM_AUDIT.column_audited('max_obs_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_obs_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_obs_level_cnt,:new.max_obs_level_cnt); end if;
    
    if (voper <> 'U' or  updating('week_start_day_num')) and PRM_AUDIT.column_audited('week_start_day_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','week_start_day_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.week_start_day_num,:new.week_start_day_num); end if;
    
    if (voper <> 'U' or  updating('ts_approval_level')) and PRM_AUDIT.column_audited('ts_approval_level', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_approval_level',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_approval_level,:new.ts_approval_level); end if;
    
    if (voper <> 'U' or  updating('task_code_len')) and PRM_AUDIT.column_audited('task_code_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','task_code_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_code_len,:new.task_code_len); end if;
    
    if (voper <> 'U' or  updating('proj_short_len')) and PRM_AUDIT.column_audited('proj_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','proj_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_short_len,:new.proj_short_len); end if;
    
    if (voper <> 'U' or  updating('wbs_short_len')) and PRM_AUDIT.column_audited('wbs_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','wbs_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.wbs_short_len,:new.wbs_short_len); end if;
    
    if (voper <> 'U' or  updating('rsrc_short_len')) and PRM_AUDIT.column_audited('rsrc_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rsrc_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_short_len,:new.rsrc_short_len); end if;
    
    if (voper <> 'U' or  updating('acct_short_len')) and PRM_AUDIT.column_audited('acct_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','acct_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_short_len,:new.acct_short_len); end if;
    
    if (voper <> 'U' or  updating('role_short_len')) and PRM_AUDIT.column_audited('role_short_len', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','role_short_len',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.role_short_len,:new.role_short_len); end if;
    
    if (voper <> 'U' or  updating('max_base_cnt')) and PRM_AUDIT.column_audited('max_base_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_base_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_base_cnt,:new.max_base_cnt); end if;
    
    if (voper <> 'U' or  updating('def_target_drtn_hr_cnt')) and PRM_AUDIT.column_audited('def_target_drtn_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','def_target_drtn_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_target_drtn_hr_cnt,:new.def_target_drtn_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('day_hr_cnt')) and PRM_AUDIT.column_audited('day_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','day_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.day_hr_cnt,:new.day_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('week_hr_cnt')) and PRM_AUDIT.column_audited('week_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','week_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.week_hr_cnt,:new.week_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('year_hr_cnt')) and PRM_AUDIT.column_audited('year_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','year_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.year_hr_cnt,:new.year_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('month_hr_cnt')) and PRM_AUDIT.column_audited('month_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','month_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.month_hr_cnt,:new.month_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('max_actv_level_cnt')) and PRM_AUDIT.column_audited('max_actv_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_actv_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_actv_level_cnt,:new.max_actv_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_eps_level_cnt')) and PRM_AUDIT.column_audited('max_eps_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_eps_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_eps_level_cnt,:new.max_eps_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_pcat_level_cnt')) and PRM_AUDIT.column_audited('max_pcat_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_pcat_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_pcat_level_cnt,:new.max_pcat_level_cnt); end if;
    
    if (voper <> 'U' or  updating('max_rcat_level_cnt')) and PRM_AUDIT.column_audited('max_rcat_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_rcat_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_rcat_level_cnt,:new.max_rcat_level_cnt); end if;
    
    if (voper <> 'U' or  updating('complete_task_hrs_flag')) and PRM_AUDIT.column_audited('complete_task_hrs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','complete_task_hrs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.complete_task_hrs_flag,:new.complete_task_hrs_flag); end if;
    
    if (voper <> 'U' or  updating('default_timesheet_flag')) and PRM_AUDIT.column_audited('default_timesheet_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','default_timesheet_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_timesheet_flag,:new.default_timesheet_flag); end if;
    
    if (voper <> 'U' or  updating('future_ts_hrs_flag')) and PRM_AUDIT.column_audited('future_ts_hrs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','future_ts_hrs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.future_ts_hrs_flag,:new.future_ts_hrs_flag); end if;
    
    if (voper <> 'U' or  updating('ev_fix_cost_flag')) and PRM_AUDIT.column_audited('ev_fix_cost_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ev_fix_cost_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ev_fix_cost_flag,:new.ev_fix_cost_flag); end if;
    
    if (voper <> 'U' or  updating('ts_daily_flag')) and PRM_AUDIT.column_audited('ts_daily_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_daily_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_daily_flag,:new.ts_daily_flag); end if;
    
    if (voper <> 'U' or  updating('notstart_task_hrs_flag')) and PRM_AUDIT.column_audited('notstart_task_hrs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','notstart_task_hrs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.notstart_task_hrs_flag,:new.notstart_task_hrs_flag); end if;
    
    if (voper <> 'U' or  updating('prestart_task_hrs_flag')) and PRM_AUDIT.column_audited('prestart_task_hrs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','prestart_task_hrs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.prestart_task_hrs_flag,:new.prestart_task_hrs_flag); end if;
    
    if (voper <> 'U' or  updating('postend_task_hrs_flag')) and PRM_AUDIT.column_audited('postend_task_hrs_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','postend_task_hrs_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.postend_task_hrs_flag,:new.postend_task_hrs_flag); end if;
    
    if (voper <> 'U' or  updating('ermm_enabled_flag')) and PRM_AUDIT.column_audited('ermm_enabled_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ermm_enabled_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ermm_enabled_flag,:new.ermm_enabled_flag); end if;
    
    if (voper <> 'U' or  updating('name_sep_char')) and PRM_AUDIT.column_audited('name_sep_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','name_sep_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.name_sep_char,:new.name_sep_char); end if;
    
    if (voper <> 'U' or  updating('year_char')) and PRM_AUDIT.column_audited('year_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','year_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.year_char,:new.year_char); end if;
    
    if (voper <> 'U' or  updating('month_char')) and PRM_AUDIT.column_audited('month_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','month_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.month_char,:new.month_char); end if;
    
    if (voper <> 'U' or  updating('week_char')) and PRM_AUDIT.column_audited('week_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','week_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.week_char,:new.week_char); end if;
    
    if (voper <> 'U' or  updating('day_char')) and PRM_AUDIT.column_audited('day_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','day_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.day_char,:new.day_char); end if;
    
    if (voper <> 'U' or  updating('hour_char')) and PRM_AUDIT.column_audited('hour_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','hour_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.hour_char,:new.hour_char); end if;
    
    if (voper <> 'U' or  updating('minute_char')) and PRM_AUDIT.column_audited('minute_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','minute_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.minute_char,:new.minute_char); end if;
    
    if (voper <> 'U' or  updating('ts_approval_type')) and PRM_AUDIT.column_audited('ts_approval_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_approval_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_approval_type,:new.ts_approval_type); end if;
    
    if (voper <> 'U' or  updating('db_name')) and PRM_AUDIT.column_audited('db_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','db_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.db_name,:new.db_name); end if;
    
    if (voper <> 'U' or  updating('tasksum_period_type')) and PRM_AUDIT.column_audited('tasksum_period_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','tasksum_period_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.tasksum_period_type,:new.tasksum_period_type); end if;
    
    if (voper <> 'U' or  updating('trsrcsum_period_type')) and PRM_AUDIT.column_audited('trsrcsum_period_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','trsrcsum_period_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.trsrcsum_period_type,:new.trsrcsum_period_type); end if;
    
    if (voper <> 'U' or  updating('database_version')) and PRM_AUDIT.column_audited('database_version', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','database_version',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.database_version,:new.database_version); end if;
    
    if (voper <> 'U' or  updating('min_pro_version')) and PRM_AUDIT.column_audited('min_pro_version', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','min_pro_version',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.min_pro_version,:new.min_pro_version); end if;
    
    if (voper <> 'U' or  updating('phase_label')) and PRM_AUDIT.column_audited('phase_label', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','phase_label',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.phase_label,:new.phase_label); end if;
    
    if (voper <> 'U' or  updating('ts_approve_user_id')) and PRM_AUDIT.column_audited('ts_approve_user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_approve_user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_approve_user_id,:new.ts_approve_user_id); end if;
    
    if (voper <> 'U' or  updating('curr_id')) and PRM_AUDIT.column_audited('curr_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','curr_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.curr_id,:new.curr_id); end if;
    
    if (voper <> 'U' or  updating('ev_user_pct')) and PRM_AUDIT.column_audited('ev_user_pct', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ev_user_pct',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ev_user_pct,:new.ev_user_pct); end if;
    
    if (voper <> 'U' or  updating('ev_etc_user_value')) and PRM_AUDIT.column_audited('ev_etc_user_value', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ev_etc_user_value',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ev_etc_user_value,:new.ev_etc_user_value); end if;
    
    if (voper <> 'U' or  updating('ev_compute_type')) and PRM_AUDIT.column_audited('ev_compute_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ev_compute_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ev_compute_type,:new.ev_compute_type); end if;
    
    if (voper <> 'U' or  updating('ev_etc_compute_type')) and PRM_AUDIT.column_audited('ev_etc_compute_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ev_etc_compute_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ev_etc_compute_type,:new.ev_etc_compute_type); end if;
    
    if (voper <> 'U' or  updating('rpt_header_1')) and PRM_AUDIT.column_audited('rpt_header_1', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_header_1',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_header_1,:new.rpt_header_1); end if;
    
    if (voper <> 'U' or  updating('rpt_header_2')) and PRM_AUDIT.column_audited('rpt_header_2', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_header_2',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_header_2,:new.rpt_header_2); end if;
    
    if (voper <> 'U' or  updating('rpt_header_3')) and PRM_AUDIT.column_audited('rpt_header_3', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_header_3',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_header_3,:new.rpt_header_3); end if;
    
    if (voper <> 'U' or  updating('rpt_footer_1')) and PRM_AUDIT.column_audited('rpt_footer_1', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_footer_1',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_footer_1,:new.rpt_footer_1); end if;
    
    if (voper <> 'U' or  updating('rpt_footer_2')) and PRM_AUDIT.column_audited('rpt_footer_2', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_footer_2',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_footer_2,:new.rpt_footer_2); end if;
    
    if (voper <> 'U' or  updating('rpt_footer_3')) and PRM_AUDIT.column_audited('rpt_footer_3', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_footer_3',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_footer_3,:new.rpt_footer_3); end if;
    
    if (voper <> 'U' or  updating('rpt_user_1')) and PRM_AUDIT.column_audited('rpt_user_1', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_user_1',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_user_1,:new.rpt_user_1); end if;
    
    if (voper <> 'U' or  updating('rpt_user_2')) and PRM_AUDIT.column_audited('rpt_user_2', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_user_2',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_user_2,:new.rpt_user_2); end if;
    
    if (voper <> 'U' or  updating('rpt_user_3')) and PRM_AUDIT.column_audited('rpt_user_3', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','rpt_user_3',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rpt_user_3,:new.rpt_user_3); end if;
    if voper <> 'U' or ( updating('license_data') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('PREFER','license_data',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.license_data,:new.license_data); end if;
    
    if (voper <> 'U' or  updating('max_role_level_cnt')) and PRM_AUDIT.column_audited('max_role_level_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','max_role_level_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.max_role_level_cnt,:new.max_role_level_cnt); end if;
    
    if (voper <> 'U' or  updating('past_ts_cnt')) and PRM_AUDIT.column_audited('past_ts_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','past_ts_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.past_ts_cnt,:new.past_ts_cnt); end if;
    
    if (voper <> 'U' or  updating('projinit_admin_user_id')) and PRM_AUDIT.column_audited('projinit_admin_user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','projinit_admin_user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.projinit_admin_user_id,:new.projinit_admin_user_id); end if;
    
    if (voper <> 'U' or  updating('default_rsrc_sec_id')) and PRM_AUDIT.column_audited('default_rsrc_sec_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','default_rsrc_sec_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_rsrc_sec_id,:new.default_rsrc_sec_id); end if;
    
    if (voper <> 'U' or  updating('allow_user_time_period_flag')) and PRM_AUDIT.column_audited('allow_user_time_period_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','allow_user_time_period_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.allow_user_time_period_flag,:new.allow_user_time_period_flag); end if;
    
    if (voper <> 'U' or  updating('exp_root_url')) and PRM_AUDIT.column_audited('exp_root_url', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','exp_root_url',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.exp_root_url,:new.exp_root_url); end if;
    
    if (voper <> 'U' or  updating('ts_rsrc_def_asgn_actv_flag')) and PRM_AUDIT.column_audited('ts_rsrc_def_asgn_actv_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_rsrc_def_asgn_actv_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_rsrc_def_asgn_actv_flag,:new.ts_rsrc_def_asgn_actv_flag); end if;
    
    if (voper <> 'U' or  updating('ts_rsrc_def_asgn_out_actv_flag')) and PRM_AUDIT.column_audited('ts_rsrc_def_asgn_out_actv_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PREFER','ts_rsrc_def_asgn_out_actv_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_rsrc_def_asgn_out_actv_flag,:new.ts_rsrc_def_asgn_out_actv_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PREFER',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PREFER_DEL

--METADATA NAME:RT_PREFER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PREFER_DEL
BEFORE DELETE ON PREFER
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PREFER',:old.prefer_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PREFER

--METADATA NAME:RT_PREFER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PREFER
BEFORE UPDATE OR INSERT ON PREFER
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PREFER',:old.prefer_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.prefer_id)
			  and table_name = 'PREFER';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROCGROUP

--METADATA NAME:PRMAUD_PROCGROUP TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROCGROUP
after insert or update or delete on PROCGROUP
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROCGROUP',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proc_group_id;
				
    
    else
    	vpk1 := :new.proc_group_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proc_group_id')) and PRM_AUDIT.column_audited('proc_group_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCGROUP','proc_group_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proc_group_id,:new.proc_group_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCGROUP','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('proc_group_name')) and PRM_AUDIT.column_audited('proc_group_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCGROUP','proc_group_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proc_group_name,:new.proc_group_name); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PROCGROUP',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PROCGROUP_DEL

--METADATA NAME:RT_PROCGROUP_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROCGROUP_DEL
BEFORE DELETE ON PROCGROUP
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PROCGROUP',:old.proc_group_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PROCGROUP

--METADATA NAME:RT_PROCGROUP TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROCGROUP
BEFORE UPDATE OR INSERT ON PROCGROUP
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PROCGROUP',:old.proc_group_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proc_group_id)
			  and table_name = 'PROCGROUP';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROCITEM

--METADATA NAME:PRMAUD_PROCITEM TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROCITEM
after insert or update or delete on PROCITEM
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROCITEM',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proc_item_id;
				
    
    else
    	vpk1 := :new.proc_item_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proc_item_id')) and PRM_AUDIT.column_audited('proc_item_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCITEM','proc_item_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proc_item_id,:new.proc_item_id); end if;
    
    if (voper <> 'U' or  updating('proc_group_id')) and PRM_AUDIT.column_audited('proc_group_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCITEM','proc_group_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proc_group_id,:new.proc_group_id); end if;
    
    if (voper <> 'U' or  updating('seq_num')) and PRM_AUDIT.column_audited('seq_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCITEM','seq_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.seq_num,:new.seq_num); end if;
    
    if (voper <> 'U' or  updating('proc_name')) and PRM_AUDIT.column_audited('proc_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCITEM','proc_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proc_name,:new.proc_name); end if;
    
    if (voper <> 'U' or  updating('proc_wt')) and PRM_AUDIT.column_audited('proc_wt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROCITEM','proc_wt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proc_wt,:new.proc_wt); end if;
    if voper <> 'U' or ( updating('proc_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('PROCITEM','proc_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.proc_descr,:new.proc_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PROCITEM',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PROCITEM_DEL

--METADATA NAME:RT_PROCITEM_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROCITEM_DEL
BEFORE DELETE ON PROCITEM
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PROCITEM',:old.proc_item_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PROCITEM

--METADATA NAME:RT_PROCITEM TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROCITEM
BEFORE UPDATE OR INSERT ON PROCITEM
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PROCITEM',:old.proc_item_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.proc_item_id)
			  and table_name = 'PROCITEM';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROFILE

--METADATA NAME:PRMAUD_PROFILE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROFILE
after insert or update or delete on PROFILE
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROFILE',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.prof_id;
				
    
    else
    	vpk1 := :new.prof_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('prof_id')) and PRM_AUDIT.column_audited('prof_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','prof_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.prof_id,:new.prof_id); end if;
    
    if (voper <> 'U' or  updating('default_flag')) and PRM_AUDIT.column_audited('default_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','default_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.default_flag,:new.default_flag); end if;
    
    if (voper <> 'U' or  updating('superuser_flag')) and PRM_AUDIT.column_audited('superuser_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','superuser_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.superuser_flag,:new.superuser_flag); end if;
    
    if (voper <> 'U' or  updating('scope_type')) and PRM_AUDIT.column_audited('scope_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','scope_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.scope_type,:new.scope_type); end if;
    
    if (voper <> 'U' or  updating('prof_name')) and PRM_AUDIT.column_audited('prof_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','prof_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.prof_name,:new.prof_name); end if;
    
    if (voper <> 'U' or  updating('prof_descr')) and PRM_AUDIT.column_audited('prof_descr', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFILE','prof_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.prof_descr,:new.prof_descr); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PROFILE',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PROFILE_DEL

--METADATA NAME:RT_PROFILE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROFILE_DEL
BEFORE DELETE ON PROFILE
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PROFILE',:old.prof_id,null,null,null );

end; 
/
show err
prompt Creating trigger RT_PROFILE

--METADATA NAME:RT_PROFILE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROFILE
BEFORE UPDATE OR INSERT ON PROFILE
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PROFILE',:old.prof_id,null,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.prof_id)
			  and table_name = 'PROFILE';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROFPRIV

--METADATA NAME:PRMAUD_PROFPRIV TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROFPRIV
after insert or update or delete on PROFPRIV
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROFPRIV',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.prof_id;
				
    vpk2 := :old.priv_num;
				
    
    else
    	vpk1 := :new.prof_id;
				
    vpk2 := :new.priv_num;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('prof_id')) and PRM_AUDIT.column_audited('prof_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFPRIV','prof_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.prof_id,:new.prof_id); end if;
    
    if (voper <> 'U' or  updating('priv_num')) and PRM_AUDIT.column_audited('priv_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFPRIV','priv_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.priv_num,:new.priv_num); end if;
    
    if (voper <> 'U' or  updating('allow_flag')) and PRM_AUDIT.column_audited('allow_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROFPRIV','allow_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.allow_flag,:new.allow_flag); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PROFPRIV',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PROFPRIV_DEL

--METADATA NAME:RT_PROFPRIV_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROFPRIV_DEL
BEFORE DELETE ON PROFPRIV
FOR EACH ROW
DECLARE
BEGIN

  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
  values ( sysdate,'PROFPRIV',:old.prof_id,:old.priv_num,null,null );

end; 
/
show err
prompt Creating trigger RT_PROFPRIV

--METADATA NAME:RT_PROFPRIV TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROFPRIV
BEFORE UPDATE OR INSERT ON PROFPRIV
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
		DELETE FROM REFRDEL
		WHERE pk1 = TO_CHAR(:new.prof_id)
and pk2 = TO_CHAR(:new.priv_num)
		and table_name = 'PROFPRIV';
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
			  values ( sysdate,'PROFPRIV',:old.prof_id,:old.priv_num,null,null );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.prof_id)
and pk2 = TO_CHAR(:old.priv_num)
			  and table_name = 'PROFPRIV';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROJCOST

--METADATA NAME:PRMAUD_PROJCOST TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROJCOST
after insert or update or delete on PROJCOST
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROJCOST',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.cost_item_id;
				
    
    else
    	vpk1 := :new.cost_item_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('cost_item_id')) and PRM_AUDIT.column_audited('cost_item_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','cost_item_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.cost_item_id,:new.cost_item_id); end if;
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('task_id')) and PRM_AUDIT.column_audited('task_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','task_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_id,:new.task_id); end if;
    
    if (voper <> 'U' or  updating('auto_compute_act_flag')) and PRM_AUDIT.column_audited('auto_compute_act_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','auto_compute_act_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.auto_compute_act_flag,:new.auto_compute_act_flag); end if;
    
    if (voper <> 'U' or  updating('cost_load_type')) and PRM_AUDIT.column_audited('cost_load_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','cost_load_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_load_type,:new.cost_load_type); end if;
    
    if (voper <> 'U' or  updating('acct_id')) and PRM_AUDIT.column_audited('acct_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','acct_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_id,:new.acct_id); end if;
    
    if (voper <> 'U' or  updating('cost_type_id')) and PRM_AUDIT.column_audited('cost_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','cost_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_type_id,:new.cost_type_id); end if;
    
    if (voper <> 'U' or  updating('target_cost')) and PRM_AUDIT.column_audited('target_cost', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','target_cost',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.target_cost,:new.target_cost); end if;
    
    if (voper <> 'U' or  updating('act_cost')) and PRM_AUDIT.column_audited('act_cost', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','act_cost',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.act_cost,:new.act_cost); end if;
    
    if (voper <> 'U' or  updating('remain_cost')) and PRM_AUDIT.column_audited('remain_cost', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','remain_cost',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.remain_cost,:new.remain_cost); end if;
    
    if (voper <> 'U' or  updating('qty_name')) and PRM_AUDIT.column_audited('qty_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','qty_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.qty_name,:new.qty_name); end if;
    
    if (voper <> 'U' or  updating('target_qty')) and PRM_AUDIT.column_audited('target_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','target_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.target_qty,:new.target_qty); end if;
    
    if (voper <> 'U' or  updating('cost_per_qty')) and PRM_AUDIT.column_audited('cost_per_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','cost_per_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_per_qty,:new.cost_per_qty); end if;
    
    if (voper <> 'U' or  updating('po_number')) and PRM_AUDIT.column_audited('po_number', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','po_number',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.po_number,:new.po_number); end if;
    
    if (voper <> 'U' or  updating('vendor_name')) and PRM_AUDIT.column_audited('vendor_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','vendor_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.vendor_name,:new.vendor_name); end if;
    
    if (voper <> 'U' or  updating('cost_name')) and PRM_AUDIT.column_audited('cost_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','cost_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_name,:new.cost_name); end if;
    if voper <> 'U' or ( updating('cost_descr') and vupdate_level >= 3 ) then	 
       PRM_AUDIT.audit_blob ('PROJCOST','cost_descr',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1
       ,vlogical_delete,'N'       
       ,:old.cost_descr,:new.cost_descr); end if;
    
    if (voper <> 'U' or  updating('pobs_id')) and PRM_AUDIT.column_audited('pobs_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJCOST','pobs_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.pobs_id,:new.pobs_id); end if;
  end if;
  PRM_AUDIT.audit_row ( 'PROJCOST',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
                     ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,vlogical_delete,'Y' );
   
end;
/
show err
prompt Creating trigger RT_PROJCOST_DEL

--METADATA NAME:RT_PROJCOST_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROJCOST_DEL
BEFORE DELETE ON PROJCOST
FOR EACH ROW
DECLARE
BEGIN

  if refrdel_bypass.g_refrdel_project_bypass=0 then
  
  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
  values ( sysdate,'PROJCOST',:old.cost_item_id,null,null,null
  	,:old.proj_id );
  end if;
  

end; 
/
show err
prompt Creating trigger RT_PROJCOST

--METADATA NAME:RT_PROJCOST TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_PROJCOST
BEFORE UPDATE OR INSERT ON PROJCOST
FOR EACH ROW
BEGIN

  :NEW.update_date := SYSDATE;
:NEW.update_user := PRM_AUDIT.get_user;
	
	  IF INSERTING THEN
		:NEW.create_user := PRM_AUDIT.get_user;
		:NEW.create_date := SYSDATE;
		
	  END IF;
    
		  IF UPDATING ('DELETE_SESSION_ID')  THEN
			IF :old.delete_session_id is null 
			   and :new.delete_session_id is not null THEN
			  INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
			  values ( sysdate,'PROJCOST',:old.cost_item_id,null,null,null
  	,:old.proj_id );
				
			ELSIF :old.delete_session_id is not null 
			   and :new.delete_session_id is null THEN
			  DELETE FROM REFRDEL
			  WHERE pk1 = TO_CHAR(:old.cost_item_id)
			  and table_name = 'PROJCOST';
			END IF;
		  END IF;
		
end; 
/
show err
prompt Creating trigger PRMAUD_PROJECT

--METADATA NAME:PRMAUD_PROJECT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER PRMAUD_PROJECT
after insert or update or delete on PROJECT
for each row
declare
  vpk1          varchar2(255);
  vpk2          varchar2(255);
  vpk3          varchar2(255);
  vpk4          varchar2(255);
  voper         char(1);
  vaudit        number;
  vinsert_level number;
  vupdate_level number;
  vdelete_level number;
  vcol_audit    varchar2(4000);
  vsession_id   number;
  vprm_user_name USERS.user_name%TYPE;
  vapp_name     varchar2(25);
  vprogram_name varchar2(255);
  vhostname     varchar2(255);
  vnetaddress   varchar2(64);
  vrdbms_user   varchar2(30);
  vos_user      varchar2(30);
  vlogical_delete		varchar2(1);
  vproj_id      number;
  voproj_id     number;
  vnproj_id     number;
begin
PRM_AUDIT.tab_options ('PROJECT',vaudit,vinsert_level,vupdate_level,vdelete_level,vcol_audit);
  

  if nvl(vaudit,0) < 1 then return; end if ;

  PRM_AUDIT.prm_user (vsession_id,vprm_user_name,vapp_name);PRM_AUDIT.proc_info (vprogram_name, vhostname, vnetaddress, vrdbms_user, vos_user );

  vlogical_delete := 'N';

  PRM_AUDIT.g_audit_data:=null;
  if PRM_AUDIT.g_audit_extended is null then
    dbms_lob.createtemporary(PRM_AUDIT.g_audit_extended,TRUE,dbms_lob.SESSION);
  else
    dbms_lob.trim(PRM_AUDIT.g_audit_extended,0);
  end if;
  
  if updating then     
    if :old.delete_session_id is null and :new.delete_session_id is not null then
      vlogical_delete := 'Y';
      voper := 'D';
    else
      voper := 'U';
    end if;
  elsif inserting then voper := 'I';
  else                 voper := 'D';
  end if;

if    (voper = 'U' and vupdate_level = 0 ) or ( voper = 'I' and vinsert_level =0) or (voper = 'D' and vdelete_level = 0) then return; end if ;

  if deleting then
    vpk1 := :old.proj_id;
				
    
    else
    	vpk1 := :new.proj_id;
				
    
  end if;

  if (voper = 'U' and vupdate_level >= 2 ) or ( voper = 'I' and vinsert_level >= 2)
       or (voper = 'D' and vdelete_level >= 2) then
		
    
    if (voper <> 'U' or  updating('proj_id')) and PRM_AUDIT.column_audited('proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'Y'
				,:old.proj_id,:new.proj_id); end if;
    
    if (voper <> 'U' or  updating('fy_start_month_num')) and PRM_AUDIT.column_audited('fy_start_month_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','fy_start_month_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.fy_start_month_num,:new.fy_start_month_num); end if;
    
    if (voper <> 'U' or  updating('chng_eff_cmp_pct_flag')) and PRM_AUDIT.column_audited('chng_eff_cmp_pct_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','chng_eff_cmp_pct_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.chng_eff_cmp_pct_flag,:new.chng_eff_cmp_pct_flag); end if;
    
    if (voper <> 'U' or  updating('rsrc_self_add_flag')) and PRM_AUDIT.column_audited('rsrc_self_add_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','rsrc_self_add_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_self_add_flag,:new.rsrc_self_add_flag); end if;
    
    if (voper <> 'U' or  updating('rsrc_role_match_flag')) and PRM_AUDIT.column_audited('rsrc_role_match_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','rsrc_role_match_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_role_match_flag,:new.rsrc_role_match_flag); end if;
    
    if (voper <> 'U' or  updating('allow_complete_flag')) and PRM_AUDIT.column_audited('allow_complete_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','allow_complete_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.allow_complete_flag,:new.allow_complete_flag); end if;
    
    if (voper <> 'U' or  updating('rsrc_multi_assign_flag')) and PRM_AUDIT.column_audited('rsrc_multi_assign_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','rsrc_multi_assign_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_multi_assign_flag,:new.rsrc_multi_assign_flag); end if;
    
    if (voper <> 'U' or  updating('checkout_flag')) and PRM_AUDIT.column_audited('checkout_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','checkout_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.checkout_flag,:new.checkout_flag); end if;
    
    if (voper <> 'U' or  updating('project_flag')) and PRM_AUDIT.column_audited('project_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','project_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.project_flag,:new.project_flag); end if;
    
    if (voper <> 'U' or  updating('step_complete_flag')) and PRM_AUDIT.column_audited('step_complete_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','step_complete_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.step_complete_flag,:new.step_complete_flag); end if;
    
    if (voper <> 'U' or  updating('cost_qty_recalc_flag')) and PRM_AUDIT.column_audited('cost_qty_recalc_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','cost_qty_recalc_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cost_qty_recalc_flag,:new.cost_qty_recalc_flag); end if;
    
    if (voper <> 'U' or  updating('sum_only_flag')) and PRM_AUDIT.column_audited('sum_only_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','sum_only_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.sum_only_flag,:new.sum_only_flag); end if;
    
    if (voper <> 'U' or  updating('batch_sum_flag')) and PRM_AUDIT.column_audited('batch_sum_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','batch_sum_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.batch_sum_flag,:new.batch_sum_flag); end if;
    
    if (voper <> 'U' or  updating('name_sep_char')) and PRM_AUDIT.column_audited('name_sep_char', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','name_sep_char',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.name_sep_char,:new.name_sep_char); end if;
    
    if (voper <> 'U' or  updating('def_complete_pct_type')) and PRM_AUDIT.column_audited('def_complete_pct_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_complete_pct_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_complete_pct_type,:new.def_complete_pct_type); end if;
    
    if (voper <> 'U' or  updating('proj_short_name')) and PRM_AUDIT.column_audited('proj_short_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','proj_short_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_short_name,:new.proj_short_name); end if;
    
    if (voper <> 'U' or  updating('acct_id')) and PRM_AUDIT.column_audited('acct_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','acct_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.acct_id,:new.acct_id); end if;
    
    if (voper <> 'U' or  updating('orig_proj_id')) and PRM_AUDIT.column_audited('orig_proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','orig_proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.orig_proj_id,:new.orig_proj_id); end if;
    
    if (voper <> 'U' or  updating('source_proj_id')) and PRM_AUDIT.column_audited('source_proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','source_proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.source_proj_id,:new.source_proj_id); end if;
    
    if (voper <> 'U' or  updating('base_type_id')) and PRM_AUDIT.column_audited('base_type_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','base_type_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.base_type_id,:new.base_type_id); end if;
    
    if (voper <> 'U' or  updating('clndr_id')) and PRM_AUDIT.column_audited('clndr_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','clndr_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.clndr_id,:new.clndr_id); end if;
    
    if (voper <> 'U' or  updating('sum_base_proj_id')) and PRM_AUDIT.column_audited('sum_base_proj_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','sum_base_proj_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.sum_base_proj_id,:new.sum_base_proj_id); end if;
    
    if (voper <> 'U' or  updating('task_code_base')) and PRM_AUDIT.column_audited('task_code_base', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','task_code_base',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_code_base,:new.task_code_base); end if;
    
    if (voper <> 'U' or  updating('task_code_step')) and PRM_AUDIT.column_audited('task_code_step', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','task_code_step',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_code_step,:new.task_code_step); end if;
    
    if (voper <> 'U' or  updating('priority_num')) and PRM_AUDIT.column_audited('priority_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','priority_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.priority_num,:new.priority_num); end if;
    
    if (voper <> 'U' or  updating('wbs_max_sum_level')) and PRM_AUDIT.column_audited('wbs_max_sum_level', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','wbs_max_sum_level',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.wbs_max_sum_level,:new.wbs_max_sum_level); end if;
    
    if (voper <> 'U' or  updating('risk_level')) and PRM_AUDIT.column_audited('risk_level', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','risk_level',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.risk_level,:new.risk_level); end if;
    
    if (voper <> 'U' or  updating('strgy_priority_num')) and PRM_AUDIT.column_audited('strgy_priority_num', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','strgy_priority_num',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.strgy_priority_num,:new.strgy_priority_num); end if;
    
    if (voper <> 'U' or  updating('last_checksum')) and PRM_AUDIT.column_audited('last_checksum', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_checksum',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.last_checksum,:new.last_checksum); end if;
    
    if (voper <> 'U' or  updating('critical_drtn_hr_cnt')) and PRM_AUDIT.column_audited('critical_drtn_hr_cnt', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','critical_drtn_hr_cnt',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.critical_drtn_hr_cnt,:new.critical_drtn_hr_cnt); end if;
    
    if (voper <> 'U' or  updating('def_cost_per_qty')) and PRM_AUDIT.column_audited('def_cost_per_qty', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_cost_per_qty',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_cost_per_qty,:new.def_cost_per_qty); end if;
    
    if (voper <> 'U' or  updating('last_recalc_date')) and PRM_AUDIT.column_audited('last_recalc_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_recalc_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_recalc_date,'yyyymmddhh24miss'),to_char(:new.last_recalc_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('plan_start_date')) and PRM_AUDIT.column_audited('plan_start_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','plan_start_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.plan_start_date,'yyyymmddhh24miss'),to_char(:new.plan_start_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('plan_end_date')) and PRM_AUDIT.column_audited('plan_end_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','plan_end_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.plan_end_date,'yyyymmddhh24miss'),to_char(:new.plan_end_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('scd_end_date')) and PRM_AUDIT.column_audited('scd_end_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','scd_end_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.scd_end_date,'yyyymmddhh24miss'),to_char(:new.scd_end_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('add_date')) and PRM_AUDIT.column_audited('add_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','add_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.add_date,'yyyymmddhh24miss'),to_char(:new.add_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('sum_data_date')) and PRM_AUDIT.column_audited('sum_data_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','sum_data_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.sum_data_date,'yyyymmddhh24miss'),to_char(:new.sum_data_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('last_tasksum_date')) and PRM_AUDIT.column_audited('last_tasksum_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_tasksum_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_tasksum_date,'yyyymmddhh24miss'),to_char(:new.last_tasksum_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('fcst_start_date')) and PRM_AUDIT.column_audited('fcst_start_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','fcst_start_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.fcst_start_date,'yyyymmddhh24miss'),to_char(:new.fcst_start_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('def_duration_type')) and PRM_AUDIT.column_audited('def_duration_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_duration_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_duration_type,:new.def_duration_type); end if;
    
    if (voper <> 'U' or  updating('task_code_prefix')) and PRM_AUDIT.column_audited('task_code_prefix', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','task_code_prefix',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_code_prefix,:new.task_code_prefix); end if;
    
    if (voper <> 'U' or  updating('guid')) and PRM_AUDIT.column_audited('guid', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','guid',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.guid,:new.guid); end if;
    
    if (voper <> 'U' or  updating('def_qty_type')) and PRM_AUDIT.column_audited('def_qty_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_qty_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_qty_type,:new.def_qty_type); end if;
    
    if (voper <> 'U' or  updating('add_by_name')) and PRM_AUDIT.column_audited('add_by_name', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','add_by_name',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.add_by_name,:new.add_by_name); end if;
    
    if (voper <> 'U' or  updating('web_local_root_path')) and PRM_AUDIT.column_audited('web_local_root_path', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','web_local_root_path',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.web_local_root_path,:new.web_local_root_path); end if;
    
    if (voper <> 'U' or  updating('proj_url')) and PRM_AUDIT.column_audited('proj_url', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','proj_url',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.proj_url,:new.proj_url); end if;
    
    if (voper <> 'U' or  updating('def_rate_type')) and PRM_AUDIT.column_audited('def_rate_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_rate_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_rate_type,:new.def_rate_type); end if;
    
    if (voper <> 'U' or  updating('act_this_per_link_flag')) and PRM_AUDIT.column_audited('act_this_per_link_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','act_this_per_link_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.act_this_per_link_flag,:new.act_this_per_link_flag); end if;
    
    if (voper <> 'U' or  updating('def_task_type')) and PRM_AUDIT.column_audited('def_task_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_task_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_task_type,:new.def_task_type); end if;
    
    if (voper <> 'U' or  updating('act_pct_link_flag')) and PRM_AUDIT.column_audited('act_pct_link_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','act_pct_link_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.act_pct_link_flag,:new.act_pct_link_flag); end if;
    
    if (voper <> 'U' or  updating('add_act_remain_flag')) and PRM_AUDIT.column_audited('add_act_remain_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','add_act_remain_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.add_act_remain_flag,:new.add_act_remain_flag); end if;
    
    if (voper <> 'U' or  updating('critical_path_type')) and PRM_AUDIT.column_audited('critical_path_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','critical_path_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.critical_path_type,:new.critical_path_type); end if;
    
    if (voper <> 'U' or  updating('task_code_prefix_flag')) and PRM_AUDIT.column_audited('task_code_prefix_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','task_code_prefix_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.task_code_prefix_flag,:new.task_code_prefix_flag); end if;
    
    if (voper <> 'U' or  updating('def_rollup_dates_flag')) and PRM_AUDIT.column_audited('def_rollup_dates_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','def_rollup_dates_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.def_rollup_dates_flag,:new.def_rollup_dates_flag); end if;
    
    if (voper <> 'U' or  updating('rem_target_link_flag')) and PRM_AUDIT.column_audited('rem_target_link_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','rem_target_link_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rem_target_link_flag,:new.rem_target_link_flag); end if;
    
    if (voper <> 'U' or  updating('reset_planned_flag')) and PRM_AUDIT.column_audited('reset_planned_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','reset_planned_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.reset_planned_flag,:new.reset_planned_flag); end if;
    
    if (voper <> 'U' or  updating('allow_neg_act_flag')) and PRM_AUDIT.column_audited('allow_neg_act_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','allow_neg_act_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.allow_neg_act_flag,:new.allow_neg_act_flag); end if;
    
    if (voper <> 'U' or  updating('rsrc_id')) and PRM_AUDIT.column_audited('rsrc_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','rsrc_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.rsrc_id,:new.rsrc_id); end if;
    
    if (voper <> 'U' or  updating('msp_managed_flag')) and PRM_AUDIT.column_audited('msp_managed_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','msp_managed_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.msp_managed_flag,:new.msp_managed_flag); end if;
    
    if (voper <> 'U' or  updating('msp_update_actuals_flag')) and PRM_AUDIT.column_audited('msp_update_actuals_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','msp_update_actuals_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.msp_update_actuals_flag,:new.msp_update_actuals_flag); end if;
    
    if (voper <> 'U' or  updating('checkout_date')) and PRM_AUDIT.column_audited('checkout_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','checkout_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.checkout_date,'yyyymmddhh24miss'),to_char(:new.checkout_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('checkout_user_id')) and PRM_AUDIT.column_audited('checkout_user_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','checkout_user_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.checkout_user_id,:new.checkout_user_id); end if;
    
    if (voper <> 'U' or  updating('sum_assign_level')) and PRM_AUDIT.column_audited('sum_assign_level', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','sum_assign_level',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.sum_assign_level,:new.sum_assign_level); end if;
    
    if (voper <> 'U' or  updating('last_fin_dates_id')) and PRM_AUDIT.column_audited('last_fin_dates_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_fin_dates_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.last_fin_dates_id,:new.last_fin_dates_id); end if;
    
    if (voper <> 'U' or  updating('use_project_baseline_flag')) and PRM_AUDIT.column_audited('use_project_baseline_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','use_project_baseline_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.use_project_baseline_flag,:new.use_project_baseline_flag); end if;
    
    if (voper <> 'U' or  updating('last_baseline_update_date')) and PRM_AUDIT.column_audited('last_baseline_update_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_baseline_update_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_baseline_update_date,'yyyymmddhh24miss'),to_char(:new.last_baseline_update_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('ts_rsrc_vw_compl_asgn_flag')) and PRM_AUDIT.column_audited('ts_rsrc_vw_compl_asgn_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','ts_rsrc_vw_compl_asgn_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_rsrc_vw_compl_asgn_flag,:new.ts_rsrc_vw_compl_asgn_flag); end if;
    
    if (voper <> 'U' or  updating('ts_rsrc_mark_act_finish_flag')) and PRM_AUDIT.column_audited('ts_rsrc_mark_act_finish_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','ts_rsrc_mark_act_finish_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_rsrc_mark_act_finish_flag,:new.ts_rsrc_mark_act_finish_flag); end if;
    
    if (voper <> 'U' or  updating('ts_rsrc_vw_inact_actv_flag')) and PRM_AUDIT.column_audited('ts_rsrc_vw_inact_actv_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','ts_rsrc_vw_inact_actv_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.ts_rsrc_vw_inact_actv_flag,:new.ts_rsrc_vw_inact_actv_flag); end if;
    
    if (voper <> 'U' or  updating('cr_external_key')) and PRM_AUDIT.column_audited('cr_external_key', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','cr_external_key',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.cr_external_key,:new.cr_external_key); end if;
    
    if (voper <> 'U' or  updating('apply_actuals_date')) and PRM_AUDIT.column_audited('apply_actuals_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','apply_actuals_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.apply_actuals_date,'yyyymmddhh24miss'),to_char(:new.apply_actuals_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('description')) and PRM_AUDIT.column_audited('description', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','description',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.description,:new.description); end if;
    
    if (voper <> 'U' or  updating('intg_proj_type')) and PRM_AUDIT.column_audited('intg_proj_type', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','intg_proj_type',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.intg_proj_type,:new.intg_proj_type); end if;
    
    if (voper <> 'U' or  updating('matrix_id')) and PRM_AUDIT.column_audited('matrix_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','matrix_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.matrix_id,:new.matrix_id); end if;
    
    if (voper <> 'U' or  updating('location_id')) and PRM_AUDIT.column_audited('location_id', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','location_id',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.location_id,:new.location_id); end if;
    
    if (voper <> 'U' or  updating('last_schedule_date')) and PRM_AUDIT.column_audited('last_schedule_date', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','last_schedule_date',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,to_char(:old.last_schedule_date,'yyyymmddhh24miss'),to_char(:new.last_schedule_date,'yyyymmddhh24miss')); end if;
    
    if (voper <> 'U' or  updating('control_updates_flag')) and PRM_AUDIT.column_audited('control_updates_flag', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','control_updates_flag',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.control_updates_flag,:new.control_updates_flag); end if;
    
    if (voper <> 'U' or  updating('hist_interval')) and PRM_AUDIT.column_audited('hist_interval', vcol_audit)='Y' then	 PRM_AUDIT.audit_data ('PROJECT','hist_interval',voper,vpk1,vpk2,vpk3,vpk4,vprm_user_name
       ,vprogram_name,vhostname,vnetaddress,vrdbms_user,vos_user,vapp_name,1,vlogical_delete,'N'
				,:old.hist_interval,:new.hist_interval); end if;
    
    if (voper <> 'U' or  updating('hist_level')) and PRM_A