--METADATA NAME:DROP_NAMED_USER_FLAG TYPE:EXEC
declare 
colcnt pls_integer;
begin
select 1 into colcnt from user_tab_columns where column_name='NAMED_USER_FLAG' and rownum <2;
if colcnt=1 then 
execute immediate 'ALTER TABLE USERENG DROP COLUMN NAMED_USER_FLAG CASCADE CONSTRAINTS';
end if;
exception when no_data_found then null;
end;
/

--METADATA NAME:DELETE_INTERNAL_PLUGINS TYPE:EXEC    
begin
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS';
commit;
end;
/

--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.risk'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.TASKRISK'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.MTXSCRTYP'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKIMPACT'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKMTXSCR'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKMIT'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKMITIMP'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKRSPPLN'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKSCRMTX'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKSCRTHR'; exception when others then null;end;
 /
--METADATA NAME:DROP_SYNONYMS TYPE:EXEC
begin execute immediate 'drop synonym privuser.RISKSCRTYP'; exception when others then null;end;
 /

--METADATA NAME:SHRINK_JOB_DATA_X TYPE:EXEC
DECLARE
    vsecurefile       VARCHAR2(3);
    vsegment_subtype  VARCHAR2(10);
	vcnt              NUMBER;
BEGIN
    EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM V$VERSION WHERE UPPER(BANNER) LIKE ''%ENTERPRISE%'' OR UPPER(BANNER) LIKE ''%EE%'''
	INTO
	    vcnt;
    EXECUTE IMMEDIATE 'SELECT B.SECUREFILE, A.SEGMENT_SUBTYPE FROM USER_SEGMENTS A JOIN USER_LOBS B USING (SEGMENT_NAME) WHERE A.SEGMENT_TYPE=''LOBSEGMENT'' AND B.COLUMN_NAME=''JOB_DATA_X'' AND B.TABLE_NAME=''JOBSVC'''
    INTO
        vsecurefile,
        vsegment_subtype;
    IF vsecurefile = 'YES' OR ( vsecurefile = 'NO' AND vsegment_subtype = 'ASSM') THEN
        EXECUTE IMMEDIATE 'ALTER TABLE JOBSVC MOVE LOB(JOB_DATA_X) STORE AS SECUREFILE (TABLESPACE PMDB_LOB1)';
        EXECUTE IMMEDIATE 'ALTER TABLE JOBSVC MODIFY LOB (JOB_DATA_X) (RETENTION NONE)';
    ELSE
        EXECUTE IMMEDIATE 'ALTER TABLE JOBSVC MOVE LOB(JOB_DATA_X) STORE AS (TABLESPACE PMDB_LOB1)';
    END IF;
    FOR i IN (
        SELECT
            index_name
        FROM
            user_indexes
        WHERE
                table_name = 'JOBSVC'
            AND status = 'UNUSABLE'
    ) LOOP
	    IF vcnt = 1 THEN 
           EXECUTE IMMEDIATE 'ALTER INDEX '
                             || i.index_name
                             || ' REBUILD ONLINE';
		ELSE
		   EXECUTE IMMEDIATE 'ALTER INDEX '
		                     || i.index_name
							 || ' REBUILD';
		END IF;
    END LOOP;
EXCEPTION
    WHEN OTHERS THEN
        --RERUN HERE JUST TO ENSURE NO UNUSABLE INDEXES
        FOR i IN (
            SELECT
                index_name
            FROM
                user_indexes
            WHERE
                    table_name = 'JOBSVC'
                AND status = 'UNUSABLE'
        ) LOOP
	    IF vcnt = 1 THEN 
           EXECUTE IMMEDIATE 'ALTER INDEX '
                             || i.index_name
                             || ' REBUILD ONLINE';
		ELSE
		   EXECUTE IMMEDIATE 'ALTER INDEX '
		                     || i.index_name
							 || ' REBUILD';
		END IF;
        END LOOP;
END;
/

--METADATA NAME:GATHER_FLUX_STATISTICS TYPE:EXEC
BEGIN
  GATHER_FLUX_STATISTICS;
END;
/