--METADATA NAME:pdtk_fn_index_fields TYPE:VIEW CHANGE:CREATE
create or replace function pdtk_fn_index_fields(pindex_name IN varchar2)
return varchar2 
as
  cursor indcols
  is
  select column_name, column_position
  from user_ind_columns
  where index_name = pindex_name
  order by column_position;
  vres varchar2(255);
begin
  for irec in indcols loop
    if irec.column_position = 1 then
      vres := irec.column_name;
    else
      vres := vres || ',' || irec.column_name;
    end if;
  end loop;
  return lower(vres);
end;
/
show err

--METADATA NAME:pdtk_fn_cons_fields TYPE:VIEW CHANGE:CREATE
create or replace function pdtk_fn_cons_fields(pconstraint_name IN varchar2)
return varchar2 
as
  cursor conscols
  is
  select column_name, position
  from user_cons_columns
  where constraint_name = pconstraint_name
  order by position;
  vres varchar2(255);
begin
  for crec in conscols loop
    if crec.position = 1 then
      vres := crec.column_name;
    else
      vres := vres || ',' || crec.column_name;
    end if;
  end loop;
  return lower(vres);
end;
/
show err

--METADATA NAME:pdtk_fn_search_condition TYPE:VIEW CHANGE:CREATE
create or replace function pdtk_fn_search_condition(pconstraint_name IN varchar2)
return varchar2
as
  vsc varchar2(4000);
begin
  select search_condition INTO vsc
  from user_constraints
  where constraint_name = pconstraint_name;
  return vsc;
end;
/
show err

--METADATA NAME:pdtk_table TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_table
as
select table_name NAME 
, decode(duration,'SYS$SESSION','SESSION','SYS$TRANSACTION','TRANSACTION','NORMAL','GV$TRANSACTION') TABLETYPE
, tablespace_name TABLESPACE
from user_tables
where table_name not like 'BIN%'
/

--METADATA NAME:pdtk_field TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_field
as
select table_name "TABLE", column_name "NAME",
decode(substr(data_type,1,9), 
  'NUMBER',decode(data_scale,0,decode(data_precision,10,'integer',5,'smallint',3,'tinyint',2,'tinyint',1,'tinyint','number')
                  ,4,decode(data_precision,15,'float','double')
                  ,8,decode(data_precision,15,'float','double')
                  ,'double'),
  'FLOAT','number',
  'DATE','date',
  'BLOB','blob',
  'CLOB','clob',
  'VARCHAR2','string',
  'CHAR','string',
  'RAW','binary',
  'TIMESTAMP','ortimestamp',
  'UNKNOWN') DATATYPE,
data_length CHARLENGTH,
data_precision DATAPRECISION,
data_scale DATASCALE,
decode(nullable,'Y','N','Y') NOTNULL,
data_default "DEFAULT",
column_id "POSITION"
from user_tab_columns
/

--METADATA NAME:pdtk_trigger TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_trigger
as
select table_name "TABLE", trigger_name "NAME"
from user_triggers
/

--METADATA NAME:pdtk_index TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_index
as
select table_name "TABLE", lower(index_name) "NAME"
, pdtk_fn_index_fields(index_name) FIELD
, uniqueness
,tablespace_name TABLESPACE
from user_indexes
where index_type = 'NORMAL'
and not exists (select * from user_constraints where constraint_name = user_indexes.index_name)
/

--METADATA NAME:pdtk_constraint TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_constraint
as
select uc.table_name "TABLE"
, substr(lower(decode(substr(uc.constraint_name,1,5),'SYS_C'
  ,decode(uc.constraint_type,'R','FK_','C','CK_','U','UK_','PK_') 
    || decode(uc.constraint_type,'R',rc.table_name || uc.table_name,uc.table_name)
  ,uc.constraint_name) ),1,30) "NAME"
,decode(uc.constraint_type,'R','FOREIGN','C','CHECK','P','PRIMARY','U','UNIQUE','UNK') type
,pdtk_fn_cons_fields(uc.constraint_name) FIELDS
, rc.table_name "TARGETTABLE"
,pdtk_fn_cons_fields(rc.constraint_name) TARGETFIELDS
,NULL search_condition
from user_constraints uc left outer join user_constraints rc ON rc.constraint_name = uc.r_constraint_name
where uc.constraint_type != 'C'
UNION
select table_name "TABLE", lower(constraint_name) "NAME"
,'CHECK' type
,NULL FIELDS
,NULL "TARGETTABLE"
,NULL TARGETFIELDS
,pdtk_fn_search_condition(constraint_name) SEARCHCONDITION
from user_constraints
where constraint_type = 'C'
and pdtk_fn_search_condition(constraint_name) not like '%IS NOT NULL'
/

--METADATA NAME:pdtk_procedure TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_procedure
as
select object_name "NAME"
, OBJECT_TYPE "TYPE"
, 'OR,SS,ASA' "TARGET"
from user_objects
where object_type in ('PROCEDURE','FUNCTION','PACKAGE')
and object_name not like 'PDTK%'
/

--METADATA NAME:pdtk_view TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_view
as
select object_name "NAME"
, object_name "SET"
, 'OR,SS,ASA' "TARGET"
from user_objects
where object_type in ('VIEW')
and object_name not like 'PDTK%'
/

--METADATA NAME:pdtk_sequence TYPE:VIEW CHANGE:CREATE
create or replace view pdtk_sequence
as
select sequence_name "NAME"
from user_sequences
/
