#!/bin/sh

if [ -z "$JAVA_HOME" ] ; then
  echo "\$JAVA_HOME is not set"
  exit
fi

JAR_FILE_DIR=lib
JAR_FILE_NAME=dbmt.jar

JVM_PROPERTIES="-Xms256m -Xmx1024m -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner"
JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.dbschema.package.location=$JAR_FILE_DIR"

# To use the Motif look and feel, comment the MetalLookAndFeel line and uncomment the MotifLookAndFeel property.
# To use the default system look and feel, Comment both of the following lines.
JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=javax.swing.plaf.metal.MetalLookAndFeel -Dcom.primavera.database.logfile=DatabaseSetup.log -Duser.region=US -Dprimavera.bootstrap.home=."
# JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=com.sun.java.swing.plaf.motif.MotifLookAndFeel"

DBMT_ACTION=application/installppm
DBMT_COMMAND=installppm

if [ -z "$*" ] ; then
  JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner"
  $JAVA_HOME/bin/java $JVM_PROPERTIES -cp $JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/activation.jar:$JAR_FILE_DIR/commons-lang.jar:$JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/jaxb-api.jar:$JAR_FILE_DIR/jaxb-impl.jar:$JAR_FILE_DIR/log4j-api.jar:$JAR_FILE_DIR/log4j-core.jar:$JAR_FILE_DIR/log4j-jcl.jar:$JAR_FILE_DIR/log4j-web.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/oraclepki.jar:$JAR_FILE_DIR/osdt_cert12.jar:$JAR_FILE_DIR/osdt_core12.jar:$JAR_FILE_DIR/prm-common.jar:$JAR_FILE_DIR/prmdbfit.jar:$JAR_FILE_DIR/sdoapi.jar:$JAR_FILE_DIR/sqljdbc.jar:$JAR_FILE_DIR/xml-apis.jar -jar $JAR_FILE_DIR/$JAR_FILE_NAME $DBMT_ACTION
else
  JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.application.runner=com.primavera.database.tools.dbmt.cmd.CmdLineApplicationRunner"
# $JAVA_HOME/bin/java $JVM_PROPERTIES -cp $JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/activation.jar:$JAR_FILE_DIR/commons-lang.jar:$JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/jaxb-api.jar:$JAR_FILE_DIR/jaxb-impl.jar:$JAR_FILE_DIR/log4j-api.jar:$JAR_FILE_DIR/log4j-core.jar:$JAR_FILE_DIR/log4j-jcl.jar:$JAR_FILE_DIR/log4j-web.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/oraclepki.jar:$JAR_FILE_DIR/osdt_cert12.jar:$JAR_FILE_DIR/osdt_core12.jar:$JAR_FILE_DIR/prm-common.jar:$JAR_FILE_DIR/prmdbfit.jar:$JAR_FILE_DIR/sdoapi.jar:$JAR_FILE_DIR/sqljdbc.jar:$JAR_FILE_DIR/xml-apis.jar com.primavera.database.tools.dbmt.PrepScriptRunner $*
  $JAVA_HOME/bin/java $JVM_PROPERTIES -cp $JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/activation.jar:$JAR_FILE_DIR/commons-lang.jar:$JAR_FILE_DIR/dbmt.jar:$JAR_FILE_DIR/dbtools.jar:$JAR_FILE_DIR/jaxb-api.jar:$JAR_FILE_DIR/jaxb-impl.jar:$JAR_FILE_DIR/log4j-api.jar:$JAR_FILE_DIR/log4j-core.jar:$JAR_FILE_DIR/log4j-jcl.jar:$JAR_FILE_DIR/log4j-web.jar:$JAR_FILE_DIR/ojdbc.jar:$JAR_FILE_DIR/oraclepki.jar:$JAR_FILE_DIR/osdt_cert12.jar:$JAR_FILE_DIR/osdt_core12.jar:$JAR_FILE_DIR/prm-common.jar:$JAR_FILE_DIR/prmdbfit.jar:$JAR_FILE_DIR/sdoapi.jar:$JAR_FILE_DIR/sqljdbc.jar:$JAR_FILE_DIR/xml-apis.jar -jar $JAR_FILE_DIR/$JAR_FILE_NAME $DBMT_COMMAND  $*
fi

