@echo off
setlocal
REM --------------------------------------------------------------------------------------------------------------------
REM Run the Primavera Project Manager Database Configuration Tool
REM --------------------------------------------------------------------------------------------------------------------

SET JAR_FILE_DIR=lib
SET JAR_FILE_NAME=dbmt.jar

SET JVM_PROPERTIES=-Xms256m -Xmx1024m -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner -Duser.language=en -Duser.region=US
SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.dbschema.package.location=%JAR_FILE_DIR% -Dcom.primavera.database.logfile=DatabaseSetup.log -Dprimavera.bootstrap.home=.
SET DBMT_ACTION=application/installppm
SET DBMT_COMMAND=installppm
IF NOT EXIST "%JAVA_HOME%\bin\java.exe" (
 echo JAVA_HOME IS NOT SET
 pause
 goto :EXIT
) 

SET PATH="%JAVA_HOME%\bin";%PATH%;

if "" == "%*" goto :NOARGS

SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.application.runner=com.primavera.database.tools.dbmt.cmd.CmdLineApplicationRunner
REM java %JVM_PROPERTIES% -cp %JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\activation.jar;%JAR_FILE_DIR%\commons-lang.jar;%JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\jaxb-api.jar;%JAR_FILE_DIR%\jaxb-impl.jar;%JAR_FILE_DIR%\log4j-api.jar;%JAR_FILE_DIR%\log4j-core.jar;%JAR_FILE_DIR%\log4j-jcl.jar;%JAR_FILE_DIR%\log4j-web.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\oraclepki.jar;%JAR_FILE_DIR%\osdt_cert12.jar;%JAR_FILE_DIR%\osdt_core12.jar;%JAR_FILE_DIR%\prm-common.jar;%JAR_FILE_DIR%\prmdbfit.jar;%JAR_FILE_DIR%\sdoapi.jar;%JAR_FILE_DIR%\sqljdbc.jar;%JAR_FILE_DIR%\xml-apis.jar; com.primavera.database.tools.dbmt.PrepScriptRunner %*
java %JVM_PROPERTIES% -cp %JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\activation.jar;%JAR_FILE_DIR%\commons-lang.jar;%JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\jaxb-api.jar;%JAR_FILE_DIR%\jaxb-impl.jar;%JAR_FILE_DIR%\log4j-api.jar;%JAR_FILE_DIR%\log4j-core.jar;%JAR_FILE_DIR%\log4j-jcl.jar;%JAR_FILE_DIR%\log4j-web.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\oraclepki.jar;%JAR_FILE_DIR%\osdt_cert12.jar;%JAR_FILE_DIR%\osdt_core12.jar;%JAR_FILE_DIR%\prm-common.jar;%JAR_FILE_DIR%\prmdbfit.jar;%JAR_FILE_DIR%\sdoapi.jar;%JAR_FILE_DIR%\sqljdbc.jar;%JAR_FILE_DIR%\xml-apis.jar; -jar %JAR_FILE_DIR%\%JAR_FILE_NAME% %DBMT_COMMAND%  %*

IF %ERRORLEVEL% NEQ 0 (
  echo DBError: DBSetup failed to complete! Returned error level: %ERRORLEVEL% 
)

IF %ERRORLEVEL% EQU 0 (
  echo DBSetup completed successfully. Returned error level: %ERRORLEVEL% 
)

goto :EXIT

:NOARGS
SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner
START javaw %JVM_PROPERTIES% -cp %JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\activation.jar;%JAR_FILE_DIR%\commons-lang.jar;%JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\jaxb-api.jar;%JAR_FILE_DIR%\jaxb-impl.jar;%JAR_FILE_DIR%\log4j-api.jar;%JAR_FILE_DIR%\log4j-core.jar;%JAR_FILE_DIR%\log4j-jcl.jar;%JAR_FILE_DIR%\log4j-web.jar;%JAR_FILE_DIR%\ojdbc.jar;%JAR_FILE_DIR%\oraclepki.jar;%JAR_FILE_DIR%\osdt_cert12.jar;%JAR_FILE_DIR%\osdt_core12.jar;%JAR_FILE_DIR%\prm-common.jar;%JAR_FILE_DIR%\prmdbfit.jar;%JAR_FILE_DIR%\sdoapi.jar;%JAR_FILE_DIR%\sqljdbc.jar;%JAR_FILE_DIR%\xml-apis.jar; -jar %JAR_FILE_DIR%\%JAR_FILE_NAME% %DBMT_ACTION%
:EXIT

exit %ERRORLEVEL%
