#!/bin/sh

if [ -z "$JAVA_HOME" ] ; then
  echo "\$JAVA_HOME is not set"
  exit
fi

JAR_FILE_DIR=lib
JAR_FILE_NAME=dbmt.jar
DB_SCHEMA=pm

JVM_PROPERTIES="-Ddbmt.dbschema.package.location=$JAR_FILE_DIR -Dprimavera.db.schema=$DB_SCHEMA"

# To use the Motif look and feel, comment the MetalLookAndFeel line and uncomment the MotifLookAndFeel property.
# To use the default system look and feel, Comment both of the following lines.
JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=javax.swing.plaf.metal.MetalLookAndFeel -Dcom.primavera.database.logfile=CharConversion.log"
# JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=com.sun.java.swing.plaf.motif.MotifLookAndFeel"

DBMT_ACTION=application/charconv
DBMT_COMMAND=charconvpm

if [ -z "$*" ] ; then
  JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.CharConvApplicationRunner"
  $JAVA_HOME/bin/java $JVM_PROPERTIES -jar $JAR_FILE_DIR/$JAR_FILE_NAME $DBMT_ACTION
else
  JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.application.runner=com.primavera.database.tools.dbmt.cmd.CmdLineApplicationRunner"
  $JAVA_HOME/bin/java $JVM_PROPERTIES -jar $JAR_FILE_DIR/$JAR_FILE_NAME $DBMT_COMMAND  $*
fi
