
--Run Script as     
SET DEFINE OFF

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   last_schedule_date  DATE NULL
';
  end if;
END;         
/

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify private_loc varchar2(4000 CHAR)
/

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify public_loc varchar2(4000 CHAR)
/



--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
/

/ 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
declare
v_tbs varchar2(40);
begin
select tablespace_name into v_tbs from user_ts_quotas where tablespace_name like '%NDX%' and rownum =1;

execute immediate 'ALTER TABLE TASKUSER DROP CONSTRAINT PK_TASKUSER' ;

execute immediate 'ALTER TABLE TASKUSER ADD CONSTRAINT PK_TASKUSER PRIMARY KEY (task_id) USING INDEX TABLESPACE '||v_tbs ;

exception when others then
null;
end;
/

/ 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
/

/ 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2312.0006.0000.0000'
/

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:23.10.00
update prefer set min_pro_version='23.10.00'
/
commit
/
