prompt Creating users ADMUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:ADMUSER
create user ${pm.or.administrative_user}
       identified by "${pm.or.administrative_password}"
       temporary tablespace ${temporary_tablespace}
       default   tablespace ${ppm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER
grant create session,create table,create sequence,create procedure,create trigger,create type,create view to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:DBMS_REPUTIL PRIVILEGE GRANTEE:SYSTEM
GRANT EXECUTE ON sys.DBMS_REPUTIL to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:DBMS_JOB PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_JOB to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:DBMS_LOB PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_LOB to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:DBMS_SQL PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_SQL to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:DBMS_RANDOM PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_RANDOM to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT OBJECT:TRANSACTION PRIVILEGE GRANTEE:ADMUSER
GRANT SELECT ON sys.v_$transaction to ${pm.or.administrative_user}
/

GRANT SELECT ON sys.gv_$transaction to ${pm.or.administrative_user}
/
--METADATA TYPE:GRANT OBJECT:CTX_DDL PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON ctxsys.CTX_DDL to ${pm.or.administrative_user}
/
    
--METADATA TYPE:GRANT CHANGE:GRANT NAME:${ppm.data_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${ppm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${ppm.index_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${ppm.index_tablespace}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${ppm.lob_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${ppm.lob_tablespace}
/

--alter user ${pm.or.administrative_user} quota unlimited on ${ppm.px_tablespace}
--/-- Removed as there is no ${ppm.px_tablespace} tbs

prompt Creating users PRIVUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:PRIVUSER
create user ${pm.or.privileged_user}
       identified by "${pm.or.privileged_password}"
       temporary tablespace ${temporary_tablespace}
       default   tablespace ${ppm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant create session,create view,create synonym to ${pm.or.privileged_user}
/

--METADATA TYPE:GRANT OBJECT:TRANSACTION PRIVILEGE GRANTEE:PRIVUSER
GRANT SELECT ON sys.v_$transaction TO ${pm.or.privileged_user}
/

--METADATA TYPE:GRANT OBJECT:CTX_DDL PRIVILEGE GRANTEE:PRIVUSER
GRANT SELECT ON sys.gv_$transaction TO ${pm.or.privileged_user}
/

prompt Creating users PUBUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:PUBUSER
create user ${pm.or.public_user}
       identified by "${pm.or.public_password}"
       temporary tablespace ${temporary_tablespace}
       default   tablespace ${ppm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER
grant create session,create synonym  to ${pm.or.public_user}
/

prompt Creating users BGJOBUSER 
--METADATA TYPE:USER CHANGE:CREATE NAME:BGJOBUSER
create user ${pm.or.bgjob_user} 
       identified by "${pm.or.bgjob_password}" 
       temporary tablespace ${temporary_tablespace}
       default   tablespace ${ppm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant create session,create job,create synonym  to ${pm.or.bgjob_user} 
/

--METADATA TYPE:ROLE CHANGE:CREATE ROLE 
declare roleExists integer;
BEGIN
 select count(*) into roleExists from dba_roles where role='PM_BG_JOB_ROLE';
 if (roleExists=0) then
      execute immediate 'create role PM_BG_JOB_ROLE';
 end if;
 end;
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant PM_BG_JOB_ROLE to ${pm.or.bgjob_user} 
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE:SELECT GRANTEE:PRIVUSER
grant select on sys.dba_extents to ${pm.or.administrative_user},${pm.or.privileged_user}
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE:SELECT GRANTEE:PRIVUSER
grant select on sys.dba_views to ${pm.or.administrative_user}
/

