/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.util.Utils;

public class PBEAlgorithmIdentifier
extends AlgorithmIdentifier {
    public static final ASN1ObjectID pkcs5 = new ASN1ObjectID(ASN1Utils.pkcsID, 5);
    public static final ASN1ObjectID pbeWithMD2AndDES_CBC = new ASN1ObjectID(pkcs5, 1);
    public static final ASN1ObjectID pbeWithMD2AndRC2_CBC = new ASN1ObjectID(pkcs5, 4);
    public static final ASN1ObjectID pbeWithMD5AndDES_CBC = new ASN1ObjectID(pkcs5, 3);
    public static final ASN1ObjectID pbeWithMD5AndRC2_CBC = new ASN1ObjectID(pkcs5, 6);
    public static final ASN1ObjectID pbeWithSHA1AndDES_CBC = new ASN1ObjectID(pkcs5, 10);
    public static final ASN1ObjectID pbeWithSHA1AndRC2_CBC = new ASN1ObjectID(pkcs5, 11);
    public static final ASN1ObjectID id_PBKDF2 = new ASN1ObjectID(pkcs5, 12);
    public static final ASN1ObjectID id_PBES2 = new ASN1ObjectID(pkcs5, 13);
    public static final ASN1ObjectID pkcs12PBEids = new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1);
    public static final ASN1ObjectID pbeWithSHAAnd128BitRC4 = new ASN1ObjectID(pkcs12PBEids, 1);
    public static final ASN1ObjectID pbeWithSHAAnd40BitRC4 = new ASN1ObjectID(pkcs12PBEids, 2);
    public static final ASN1ObjectID pbeWithSHAAnd3_KeyTripleDES_CBC = new ASN1ObjectID(pkcs12PBEids, 3);
    public static final ASN1ObjectID pbeWithSHAAnd2_KeyTripleDES_CBC = new ASN1ObjectID(pkcs12PBEids, 4);
    public static final ASN1ObjectID pbeWithSHAAnd128BitRC2_CBC = new ASN1ObjectID(pkcs12PBEids, 5);
    public static final ASN1ObjectID pbeWithSHAAnd40BitRC2_CBC = new ASN1ObjectID(pkcs12PBEids, 6);
    public static final int DEFAULT_SALT_LEN = 8;
    public static final int DEFAULT_ITER_COUNT = 10000;
    private byte[] a;
    private int b;
    private int c;
    private AlgorithmIdentifier d;
    private AlgorithmIdentifier e;

    public PBEAlgorithmIdentifier(ASN1ObjectID aSN1ObjectID) throws AlgorithmIdentifierException {
        this(aSN1ObjectID, RandomBitsSource.getDefault());
    }

    public PBEAlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this(aSN1ObjectID, randomBitsSource.randomBytes(new byte[8]), 10000);
    }

    public PBEAlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, byte[] byArray, int n) throws AlgorithmIdentifierException {
        super(aSN1ObjectID, PBEAlgorithmIdentifier.a(byArray, n));
        if (!(aSN1ObjectID.equals(pbeWithMD2AndDES_CBC) || aSN1ObjectID.equals(pbeWithMD2AndRC2_CBC) || aSN1ObjectID.equals(pbeWithMD5AndDES_CBC) || aSN1ObjectID.equals(pbeWithMD5AndRC2_CBC) || aSN1ObjectID.equals(pbeWithSHA1AndDES_CBC) || aSN1ObjectID.equals(pbeWithSHA1AndRC2_CBC) || aSN1ObjectID.equals(pbeWithSHAAnd128BitRC4) || aSN1ObjectID.equals(pbeWithSHAAnd40BitRC4) || aSN1ObjectID.equals(pbeWithSHAAnd3_KeyTripleDES_CBC) || aSN1ObjectID.equals(pbeWithSHAAnd2_KeyTripleDES_CBC) || aSN1ObjectID.equals(pbeWithSHAAnd128BitRC2_CBC) || aSN1ObjectID.equals(pbeWithSHAAnd40BitRC2_CBC))) {
            throw new AlgorithmIdentifierException("Invalid OID: " + aSN1ObjectID);
        }
        this.a = byArray;
        this.b = n;
    }

    public PBEAlgorithmIdentifier(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws AlgorithmIdentifierException {
        super(id_PBES2, PBEAlgorithmIdentifier.a(byArray, n, n2, algorithmIdentifier, algorithmIdentifier2));
        this.a = byArray;
        this.b = n;
        this.c = n2;
        this.d = algorithmIdentifier;
        this.e = algorithmIdentifier2;
    }

    public PBEAlgorithmIdentifier(byte[] byArray, int n, AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        super(id_PBES2, PBEAlgorithmIdentifier.a(byArray, n, 0, AlgID.hmacWithSHA1, algorithmIdentifier));
        this.a = byArray;
        this.b = n;
        this.d = AlgID.hmacWithSHA1;
        this.e = algorithmIdentifier;
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID())) {
            this.c = 16;
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID())) {
            this.c = 24;
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            this.c = 32;
        }
    }

    public PBEAlgorithmIdentifier() throws IOException {
    }

    public PBEAlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public byte[] getSalt() {
        return this.a;
    }

    public int getIterationCount() {
        return this.b;
    }

    public int getKeyLength() {
        return this.c;
    }

    public AlgorithmIdentifier getPseudorandomFunc() {
        return this.d;
    }

    public AlgorithmIdentifier getEncryptionScheme() {
        return this.e;
    }

    private void a() throws AlgorithmIdentifierException {
        block17: {
            ASN1Object aSN1Object = this.getParameters();
            try {
                if (aSN1Object == null || aSN1Object instanceof ASN1Null) {
                    this.a = RandomBitsSource.getDefault().randomBytes(new byte[8]);
                    this.b = 10000;
                    this.c = 0;
                    this.d = null;
                    this.e = null;
                    break block17;
                }
                if (this.getOID().equals(pbeWithMD2AndDES_CBC) || this.getOID().equals(pbeWithMD2AndRC2_CBC) || this.getOID().equals(pbeWithMD5AndDES_CBC) || this.getOID().equals(pbeWithMD5AndRC2_CBC) || this.getOID().equals(pbeWithSHA1AndDES_CBC) || this.getOID().equals(pbeWithSHA1AndRC2_CBC) || this.getOID().equals(pbeWithSHAAnd128BitRC4) || this.getOID().equals(pbeWithSHAAnd40BitRC4) || this.getOID().equals(pbeWithSHAAnd3_KeyTripleDES_CBC) || this.getOID().equals(pbeWithSHAAnd2_KeyTripleDES_CBC) || this.getOID().equals(pbeWithSHAAnd128BitRC2_CBC) || this.getOID().equals(pbeWithSHAAnd40BitRC2_CBC)) {
                    ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
                    this.a = ASN1OctetString.inputValue(aSN1SequenceInputStream);
                    this.b = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
                    aSN1SequenceInputStream.terminate();
                    this.c = 0;
                    this.d = null;
                    this.e = null;
                    break block17;
                }
                if (this.getOID().equals(id_PBES2)) {
                    ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
                    ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                    ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
                    if (!aSN1ObjectID.equals(id_PBKDF2)) {
                        throw new AlgorithmIdentifierException("Invalid OID for the key derivation function");
                    }
                    ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                    this.a = ASN1OctetString.inputValue(aSN1SequenceInputStream3);
                    this.b = ASN1Integer.inputValue(aSN1SequenceInputStream3).intValue();
                    this.c = aSN1SequenceInputStream3.hasMoreData() && aSN1SequenceInputStream3.getCurrentTag() == 2 ? ASN1Integer.inputValue(aSN1SequenceInputStream3).intValue() : 0;
                    this.d = aSN1SequenceInputStream3.hasMoreData() ? new AlgorithmIdentifier(aSN1SequenceInputStream3) : AlgID.hmacWithSHA1;
                    aSN1SequenceInputStream3.terminate();
                    aSN1SequenceInputStream2.terminate();
                    this.e = new AlgorithmIdentifier(aSN1SequenceInputStream);
                    if (this.c == 0) {
                        ASN1ObjectID aSN1ObjectID2 = this.e.getOID();
                        if (aSN1ObjectID2.equals(AlgID.desCBC.getOID()) || aSN1ObjectID2.equals(AlgID.desECB.getOID())) {
                            this.c = 8;
                        }
                        if (aSN1ObjectID2.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID2.equals(AlgID.DES_EDE3_ECB.getOID())) {
                            this.c = 24;
                        } else if (aSN1ObjectID2.equals(AlgID.RC4.getOID()) || aSN1ObjectID2.equals(AlgID.RC2_CBC.getOID()) || aSN1ObjectID2.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID2.equals(AlgID.aes128_ECB.getOID())) {
                            this.c = 16;
                        } else if (aSN1ObjectID2.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID2.equals(AlgID.aes192_ECB.getOID())) {
                            this.c = 24;
                        } else if (aSN1ObjectID2.equals(AlgID.aes256_CBC.getOID()) || aSN1ObjectID2.equals(AlgID.aes256_ECB.getOID())) {
                            this.c = 32;
                        } else if (aSN1ObjectID2.equals(AlgID.BLOWFISH.getOID()) || aSN1ObjectID2.equals(AlgID.blowfishCBC.getOID()) || aSN1ObjectID2.equals(AlgID.blowfishECB.getOID())) {
                            this.c = 114;
                        }
                    }
                    aSN1SequenceInputStream.terminate();
                    break block17;
                }
                throw new AlgorithmIdentifierException("Invalid OID: " + this.getOID());
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
    }

    private static ASN1Object a(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1OctetString(byArray));
        aSN1Sequence.addElement(new ASN1Integer(n));
        return aSN1Sequence;
    }

    private static ASN1Object a(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(id_PBKDF2);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.addElement(new ASN1OctetString(byArray));
        aSN1Sequence3.addElement(new ASN1Integer(n));
        if (n2 > 0) {
            aSN1Sequence3.addElement(new ASN1Integer(n2));
        }
        if (!AlgID.hmacWithSHA1.getOID().equals(algorithmIdentifier.getOID())) {
            aSN1Sequence3.addElement(algorithmIdentifier);
        }
        aSN1Sequence2.addElement(aSN1Sequence3);
        aSN1Sequence.addElement(aSN1Sequence2);
        aSN1Sequence.addElement(algorithmIdentifier2);
        return aSN1Sequence;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.a();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    @Override
    public Object clone() {
        byte[] byArray = this.a != null ? (byte[])this.a.clone() : null;
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier = byArray != null ? new PBEAlgorithmIdentifier(this.getOID(), byArray, this.b) : new PBEAlgorithmIdentifier(this.getOID());
            pBEAlgorithmIdentifier.c = this.c;
            if (this.d != null) {
                pBEAlgorithmIdentifier.d = (AlgorithmIdentifier)this.d.clone();
            }
            if (this.e != null) {
                pBEAlgorithmIdentifier.e = (AlgorithmIdentifier)this.e.clone();
            }
            return pBEAlgorithmIdentifier;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
    }
}

