/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerAeadAes256CbcHmac256Factory;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithm;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithmFactory;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;

final class SQLServerEncryptionAlgorithmFactoryList {
    private ConcurrentHashMap<String, SQLServerEncryptionAlgorithmFactory> encryptionAlgoFactoryMap = new ConcurrentHashMap();
    private static final SQLServerEncryptionAlgorithmFactoryList instance = new SQLServerEncryptionAlgorithmFactoryList();

    private SQLServerEncryptionAlgorithmFactoryList() {
        this.encryptionAlgoFactoryMap.putIfAbsent("AEAD_AES_256_CBC_HMAC_SHA256", new SQLServerAeadAes256CbcHmac256Factory());
    }

    static SQLServerEncryptionAlgorithmFactoryList getInstance() {
        return instance;
    }

    String getRegisteredCipherAlgorithmNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.encryptionAlgoFactoryMap.keySet()) {
            if (bl) {
                stringBuffer.append("'");
                bl = false;
            } else {
                stringBuffer.append(", '");
            }
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    SQLServerEncryptionAlgorithm getAlgorithm(SQLServerSymmetricKey sQLServerSymmetricKey, SQLServerEncryptionType sQLServerEncryptionType, String string) throws SQLServerException {
        SQLServerEncryptionAlgorithm sQLServerEncryptionAlgorithm = null;
        SQLServerEncryptionAlgorithmFactory sQLServerEncryptionAlgorithmFactory = null;
        if (!this.encryptionAlgoFactoryMap.containsKey(string)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnknownColumnEncryptionAlgorithm"));
            Object[] objectArray = new Object[]{string, SQLServerEncryptionAlgorithmFactoryList.getInstance().getRegisteredCipherAlgorithmNames()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        sQLServerEncryptionAlgorithmFactory = this.encryptionAlgoFactoryMap.get(string);
        assert (null != sQLServerEncryptionAlgorithmFactory) : "Null Algorithm Factory class detected";
        sQLServerEncryptionAlgorithm = sQLServerEncryptionAlgorithmFactory.create(sQLServerSymmetricKey, sQLServerEncryptionType, string);
        return sQLServerEncryptionAlgorithm;
    }
}

