/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.common.DynamicSchemaBundleManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ScriptHelper {
    public static final String TEMPLATE_INSTALL = "install/";
    public static final String TEMPLATE_SOURCE = "source/";
    public static final String TEMPLATE_UPGRADE = "upgrade/";

    public static URL findScript(Object parent, String name) throws DatabaseToolException {
        URL url = null;
        File file = new File(name);
        try {
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        String localname = name;
        url = ScriptHelper.class.getClassLoader().getResource(localname);
        if (url != null) {
            return url;
        }
        String productPath = ScriptHelper.getProductPath(name) + "/";
        url = ScriptHelper.class.getClassLoader().getResource(TEMPLATE_INSTALL + productPath + name);
        if (url != null) {
            return url;
        }
        url = ScriptHelper.class.getClassLoader().getResource(TEMPLATE_SOURCE + productPath + name);
        if (url != null) {
            return url;
        }
        url = ScriptHelper.class.getClassLoader().getResource(TEMPLATE_UPGRADE + productPath + name);
        if (url != null) {
            return url;
        }
        return url;
    }

    public static String extractProductString(String script) {
        if (!script.contains("_")) {
            return "";
        }
        String pstring = "";
        StringTokenizer idTokenizer = new StringTokenizer(script, "_");
        String id = idTokenizer.nextToken();
        if (id != null && id.length() >= 4) {
            return id.substring(2).toUpperCase();
        }
        return pstring;
    }

    public static String getProductPath(String script) throws DatabaseToolException {
        String productString = ScriptHelper.extractProductString(script);
        if (productString.length() == 0) {
            throw new DatabaseToolException("Could not extract product string from script name");
        }
        String defaultVersion = DynamicSchemaBundleManager.getDefaultVersion(productString);
        return productString + "_" + defaultVersion;
    }
}

