/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.RunScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptHelper;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import java.net.URL;
import java.sql.SQLException;

public class RunScript {
    public static void main(String[] args) {
        if (args.length < 2) {
            Log.info("Usage: java -classpath dbtools.jar " + RunScript.class.getName() + " {Source String} {Script Name}");
            System.exit(-1);
        }
        String connectstring = args[0];
        String scriptname = args[1];
        try {
            ScriptRunner sr = new ScriptRunner();
            DatabaseConnection dbconn = new DatabaseConnection(connectstring);
            sr.setDbconn(dbconn);
            URL url = ScriptHelper.findScript(sr, scriptname);
            if (url == null) {
                throw new DatabaseToolException("No Script Found");
            }
            Log.info("Running Script: " + url.getPath());
            sr.setScriptUrl(url);
            sr.addListener(new RunScriptListener());
            sr.run();
        }
        catch (SQLException e) {
            Log.error("Script Failed with SQL Exception");
            Log.error(e.getMessage());
            System.exit(-1);
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
            if (e.getSql().length() > 0) {
                Log.error(e.getSql());
            }
            Log.error("Script Failed");
            System.exit(-1);
        }
        Log.info("Script Succeeded");
    }
}

