/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.tools.Dataloader.ConfigHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SampleDataExporter {
    private String configFile;
    private String destDir;

    private static boolean validateParameters(String[] args) {
        if (args.length < 2) {
            System.out.println("usage SampleDataExport <config.xml> <dest directory>");
            return false;
        }
        if (!new File(args[0]).exists()) {
            System.out.println("secified config.xml file does not exist (" + args[0] + ")");
            return false;
        }
        if (!new File(args[1]).exists()) {
            System.out.println("secified destination directory does not exist (" + args[1] + ")");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (!SampleDataExporter.validateParameters(args)) {
            return;
        }
        System.out.println("Config File=>" + args[0]);
        System.out.println("Path=>" + args[1]);
        SampleDataExporter sde = new SampleDataExporter();
        try {
            sde.setConfigFile(args[0]);
            sde.setDestDir(args[1]);
            sde.run();
        }
        catch (PrimaveraDatabaseException ex) {
            ex.printStackTrace();
            return;
        }
        System.out.println("Process Complete");
    }

    public void run() throws PrimaveraDatabaseException {
        if (this.configFile == null || this.destDir == null) {
            throw new PrimaveraDatabaseException("Must specify config file and destination directory");
        }
        this.parseConfig();
    }

    private void parseConfig() throws PrimaveraDatabaseException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader r = sp.getXMLReader();
            ConfigHandler handler = new ConfigHandler();
            handler.setPath(this.destDir);
            r.setContentHandler(handler);
            BufferedReader fileR = new BufferedReader(new FileReader(this.getConfigFile()));
            long start = System.currentTimeMillis();
            r.parse(new InputSource(fileR));
            long end = System.currentTimeMillis();
            System.out.println(String.valueOf((double)(end - start) * 0.001) + " secs");
        }
        catch (Exception ex) {
            throw new PrimaveraDatabaseException(ex.getMessage());
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }
}

