/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.DatabaseToolException;
import java.sql.Connection;
import java.sql.SQLException;

public class DataloaderDS {
    private DSType m_dsType = DSType.DATABASE;
    private DatabaseConnection m_dbconn;

    public DSType getDSType() {
        return this.m_dsType;
    }

    public void setDSType(DSType dstype) {
        this.m_dsType = dstype;
    }

    public Connection getConnection() {
        return this.m_dbconn.getConnection();
    }

    public boolean isDatabase() {
        return this.m_dsType == DSType.DATABASE;
    }

    public boolean isFile() {
        return this.m_dsType == DSType.FILE;
    }

    public DatabaseConnection getDbconn() {
        return this.m_dbconn;
    }

    public void setDbconn(DatabaseConnection dbconn) throws DatabaseToolException {
        if (dbconn == null) {
            throw new DatabaseToolException("Database connection is null");
        }
        try {
            if (this.m_dbconn != null) {
                this.m_dbconn.close();
            }
            this.m_dbconn = dbconn;
            Connection conn = dbconn.getConnection();
            if (conn == null) {
                throw new DatabaseToolException("Connection cannot be null");
            }
            if (conn.isClosed()) {
                throw new DatabaseToolException("Connection must be open");
            }
            this.m_dsType = DSType.DATABASE;
        }
        catch (SQLException e) {
            throw new DatabaseToolException("Set connection failed " + e.getMessage(), e);
        }
    }
}

