/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.DBRowGenerator;
import com.primavera.database.tools.Dataloader.DataLoaderDBHandler;
import com.primavera.database.tools.Dataloader.Dataloader;
import com.primavera.database.tools.Dataloader.DataloaderInputDS;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDataloaderInputDS
implements DataloaderInputDS {
    private DatabaseConnection m_dbConnection;
    private DBRowGenerator m_dbRowGen = new DBRowGenerator();

    public DatabaseDataloaderInputDS(DatabaseConnection dbConnection) throws DatabaseToolException {
        if (dbConnection == null) {
            throw new DatabaseToolException("DatabaseConnection cannot be null in DatabaseDataloaderInputDS constructor");
        }
        this.m_dbConnection = dbConnection;
    }

    @Override
    public DSType getDSType() {
        return DSType.DATABASE;
    }

    @Override
    public List<String> getTableList() throws DatabaseToolException {
        return this.getTables(this.m_dbConnection.getConnection());
    }

    @Override
    public void init(String tableName, SQLRowInserter inserter, Dataloader loader) throws DatabaseToolException {
    }

    @Override
    public void init(SQLRowInserter inserter, Dataloader loader) throws DatabaseToolException {
        DataLoaderDBHandler rowhandler = new DataLoaderDBHandler();
        rowhandler.inserter = inserter;
        rowhandler.dataloader = loader;
        this.m_dbRowGen.setRowhandler(rowhandler);
    }

    private ArrayList<String> getTables(Connection conn) throws DatabaseToolException {
        ArrayList<String> list = null;
        try {
            DataDictionary dd = new DataDictionary(conn);
            list = dd.getTables(null);
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage());
        }
        return list;
    }

    protected final DatabaseConnection getDbConnection() {
        return this.m_dbConnection;
    }

    protected final DBRowGenerator getDbRowGen() {
        return this.m_dbRowGen;
    }
}

