/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DAFImporter;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.RunScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CommonMethods {
    public static String getSqlScript(String path, String type, String attribute, String pmVersion) throws XPathExpressionException {
        String workflow = "install/" + pmVersion + "/SchemaWorkflow.xml";
        InputStream inStream = ClassLoader.getSystemResourceAsStream(workflow);
        InputSource in = new InputSource(new InputStreamReader(inStream));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(path);
        String sqlScript = "null";
        if ("attribute".equalsIgnoreCase(type)) {
            Node currentVersionResult = (Node)expr.evaluate(in, XPathConstants.NODE);
            sqlScript = currentVersionResult.getAttributes().getNamedItem(attribute).getNodeValue();
        } else if ("element".equalsIgnoreCase(type)) {
            sqlScript = (String)expr.evaluate(in, XPathConstants.STRING);
        }
        return sqlScript;
    }

    public static String[] getSqlScript(String path, String pmVersion) throws XPathExpressionException {
        String workflow = "install/" + pmVersion + "/SchemaWorkflow.xml";
        InputStream inStream = ClassLoader.getSystemResourceAsStream(workflow);
        InputSource in = new InputSource(new InputStreamReader(inStream));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(path);
        NodeList nl = (NodeList)expr.evaluate(in, XPathConstants.NODESET);
        ArrayList<String> sqlScripts = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String scriptName = nl.item(i).getTextContent();
            NamedNodeMap nnm = nl.item(i).getAttributes();
            Node dirValue = nnm.getNamedItem("dir");
            if (dirValue != null) {
                String dirPath = nl.item(i).getAttributes().getNamedItem("dir").getNodeValue();
                if ("/".equalsIgnoreCase(dirPath)) {
                    Log.info("script name: " + dirPath);
                    sqlScripts.add(scriptName);
                    continue;
                }
                sqlScripts.add(dirPath + "/" + pmVersion + "/" + scriptName);
                continue;
            }
            sqlScripts.add("install/" + pmVersion + "/" + scriptName);
        }
        return sqlScripts.toArray(new String[0]);
    }

    public static void runDB_Script(String connect, String sqlScript, Properties extendedProperties) throws DatabaseToolException, SQLException {
        Log.info("Running Script " + sqlScript);
        ScriptRunner sr = null;
        sr = new ScriptRunner();
        sr.setExtendedProperties(extendedProperties);
        DatabaseConnection dbconn = null;
        dbconn = new DatabaseConnection(connect);
        sr.setDbconn(dbconn);
        URL url = ClassLoader.getSystemResource(sqlScript);
        if (url == null) {
            throw new DatabaseToolException("No Script Found: " + sqlScript);
        }
        Log.info("Running Script: " + url.getPath());
        sr.setScriptUrl(url);
        sr.addListener(new RunScriptListener());
        sr.run();
    }

    public static String getMasterFileDirectory(DatabaseConnection dbconn) {
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute("select filename from sysdatabases where name = 'master'");
            ResultSet rs = stmt.getResultSet();
            rs.next();
            String masterFile = rs.getString("filename");
            int pos = masterFile.lastIndexOf("\\");
            return masterFile.substring(0, pos);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void runAuxScripts(String dbType, String connect, Properties properties, String pmVersion) throws XPathExpressionException, DatabaseToolException, SQLException {
        String[] sqlScripts;
        for (String sqlScript : sqlScripts = CommonMethods.getSqlScript("/schema/install/" + dbType + "/step[@name='create_aux']/script", pmVersion)) {
            CommonMethods.runDB_Script(connect, sqlScript, properties);
        }
    }

    public static void runInstallScript(String dbType, String connect, Properties properties, String pmVersion) throws XPathExpressionException, DatabaseToolException, SQLException {
        String sqlScript = CommonMethods.getSqlScript("/schema/install/" + dbType + "/step[@name='create_tables']/script", "element", "", pmVersion);
        sqlScript = "install/" + pmVersion + "/" + sqlScript;
        CommonMethods.runDB_Script(connect, sqlScript, properties);
    }

    public static void runCreateScriptOR(String dbType, String connect, Properties properties, String pmVersion) throws XPathExpressionException, DatabaseToolException, SQLException {
        String sqlScript = CommonMethods.getSqlScript("/schema/create/" + dbType + "/tablespaces", "attribute", "script", pmVersion);
        sqlScript = "install/" + pmVersion + "/" + sqlScript;
        CommonMethods.runDB_Script(connect, sqlScript, properties);
        sqlScript = CommonMethods.getSqlScript("/schema/create/" + dbType + "/users", "attribute", "script", pmVersion);
        sqlScript = "install/" + pmVersion + "/" + sqlScript;
        CommonMethods.runDB_Script(connect, sqlScript, properties);
    }

    public static void runCreateScriptSS(String dbType, String connectMaster, String connectCreatedDatabase, Properties properties, String pmVersion) throws XPathExpressionException, DatabaseToolException, SQLException {
        String sqlScript = CommonMethods.getSqlScript("/schema/create/" + dbType + "/tablespaces", "attribute", "script", pmVersion);
        sqlScript = "install/" + pmVersion + "/" + sqlScript;
        CommonMethods.runDB_Script(connectMaster, sqlScript, properties);
        sqlScript = CommonMethods.getSqlScript("/schema/create/" + dbType + "/users", "attribute", "script", pmVersion);
        sqlScript = "install/" + pmVersion + "/" + sqlScript;
        CommonMethods.runDB_Script(connectCreatedDatabase, sqlScript, properties);
    }

    public static String connectAsUser(String connectstring, String admUsername, String admPassword) {
        String m_admPassword = admPassword;
        String m_admUsername = admUsername;
        return m_admUsername + "/" + m_admPassword + connectstring.substring(connectstring.indexOf("@"));
    }

    public static String getPath(String sqlString, ConnectStringParse connectParse) throws SQLException {
        Connection con = null;
        String path = null;
        String connectionURL = connectParse.getDatabaseUrl();
        Properties conProps = new Properties();
        conProps.put("user", connectParse.getUsername());
        conProps.put("password", connectParse.getPassword());
        conProps.put("defaultRowPrefetch", "15");
        con = DriverManager.getConnection(connectionURL, conProps);
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(sqlString);
        while (rs.next()) {
            path = rs.getString("file_name");
        }
        return path;
    }

    public static void upgrade(String dbType, String pmVersion, String installedVersion, String dbStringConnect, Properties properties) {
        DatabaseConnection dbconn = null;
        try {
            dbconn = new DatabaseConnection(dbStringConnect);
            String upgradeFile = CommonMethods.getUpgradeFile(installedVersion, pmVersion);
            upgradeFile = "oracle".equalsIgnoreCase(dbType) ? (pmVersion.startsWith("DBS_PPM") ? "ORPPM_" : "ORPM_") + upgradeFile + ".sql" : (pmVersion.startsWith("DBS_PPM") ? "SSPPM_" : "SSPM_") + upgradeFile + ".sql";
            String upgradeFilePath = "upgrade/" + pmVersion + "/" + upgradeFile;
            String[] sqlScripts = CommonMethods.getSqlScript("/schema/upgrade/" + dbType + "/step[@name='core_upgrade']/script", pmVersion);
            CommonMethods.runDB_Script(dbconn.getConnectionString(), upgradeFilePath, properties);
            for (int i = 0; i < sqlScripts.length - 1; ++i) {
                try {
                    CommonMethods.runDB_Script(dbconn.getConnectionString(), sqlScripts[i], properties);
                    continue;
                }
                catch (DatabaseToolException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            String[] sqlScriptsPost = null;
            sqlScriptsPost = CommonMethods.getSqlScript("/schema/upgrade/" + dbType + "/step[@name='post_upgrade']/script", pmVersion);
            for (int i = 0; i < sqlScripts.length; ++i) {
                CommonMethods.runDB_Script(dbconn.getConnectionString(), sqlScriptsPost[i], properties);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static String getUpgradeFile(String installedVersion, String pmVersion) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath versionHistoryPath = factory.newXPath();
        String versionHistoryPathString = "/PrimaveraDatabaseSchema/HISTORY";
        XPathExpression verisionHistoryExpression = null;
        try {
            verisionHistoryExpression = versionHistoryPath.compile(versionHistoryPathString);
            DocumentBuilderFactory domfactory = DocumentBuilderFactory.newInstance();
            domfactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            builder = domfactory.newDocumentBuilder();
            String pmSchema = "install/" + pmVersion + "/pmSchema.xml";
            InputStream inStream = ClassLoader.getSystemResourceAsStream(pmSchema);
            InputSource in = new InputSource(new InputStreamReader(inStream));
            Document doc = null;
            doc = builder.parse(in);
            NodeList result = null;
            result = (NodeList)verisionHistoryExpression.evaluate(doc, XPathConstants.NODESET);
            int length = result.getLength();
            for (int i = 0; i < length; ++i) {
                String schemaVersion = result.item(i).getAttributes().getNamedItem("VERSION").getNodeValue();
                if (!schemaVersion.equalsIgnoreCase(installedVersion)) continue;
                String fileName = result.item(i).getAttributes().getNamedItem("UPGRADE_FILE").getNodeValue();
                return fileName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void clearDB(String dbStringConnect, String dbType, Properties properties) {
        DatabaseConnection dbconn = null;
        try {
            dbconn = new DatabaseConnection(dbStringConnect);
            Statement stmt = null;
            stmt = dbconn.getConnection().createStatement();
            String sqlStatement = null;
            if ("oracle".equalsIgnoreCase(dbType)) {
                sqlStatement = "drop user " + properties.getProperty("pm.or.administrative_user") + " cascade";
                stmt.executeUpdate(sqlStatement);
                sqlStatement = "drop user " + properties.getProperty("pm.or.privileged_user") + " cascade";
                stmt.executeUpdate(sqlStatement);
                sqlStatement = "drop user " + properties.getProperty("pm.or.public_user") + " cascade";
                stmt.executeUpdate(sqlStatement);
                sqlStatement = "drop user " + properties.getProperty("pm.or.bgjob_user") + " cascade";
                stmt.executeUpdate(sqlStatement);
                if (properties.getProperty("pm.or.odsplus_user") != null) {
                    sqlStatement = "drop user " + properties.getProperty("pm.or.odsplus_user") + " cascade";
                    stmt.executeUpdate(sqlStatement);
                }
                sqlStatement = "commit";
                stmt.executeUpdate(sqlStatement);
            } else {
                stmt.executeUpdate("EXEC msdb.dbo.sp_delete_database_backuphistory @database_name = N'" + properties.getProperty("pm.ss.database_name") + "'");
                stmt.executeUpdate("USE [master]");
                stmt.executeUpdate("ALTER DATABASE [" + properties.getProperty("pm.ss.database_name") + "] SET  SINGLE_USER WITH ROLLBACK IMMEDIATE");
                stmt.executeUpdate("ALTER DATABASE [" + properties.getProperty("pm.ss.database_name") + "] SET  SINGLE_USER");
                stmt.executeUpdate("USE [master]");
                stmt.executeUpdate("DROP DATABASE [" + properties.getProperty("pm.ss.database_name") + "]");
                Log.info("Dropped database " + properties.getProperty("pm.ss.database_name"));
                if (properties.getProperty("pm.or.plus_user") != null) {
                    stmt.executeUpdate("DROP LOGIN  [" + properties.getProperty("pm.ss.plus_user") + "]");
                    stmt.executeUpdate("DROP LOGIN  [" + properties.getProperty("pm.ss.odsplus_user") + "]");
                }
                Log.info("Dropped login " + properties.getProperty("pm.ss.odsplus_user") + "; " + properties.getProperty("pm.ss.plus_user"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

