/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.ServerType;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.InsertExpCustomFieldInfo;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import com.primavera.database.tools.RetrieveExpCustomfieldInfoFromSampleDataZip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class CustomColumnUtil<T> {
    private static final String FILE_SEPARATOR = File.separator;
    private static final String CSDF_SCRIPT_FILE_NAME = "csdf";
    private static final String GCDF_SCRIPT_FILE_NAME = "gcdf";
    private static final String OR_SCRIPT_FILE_PREFIX = "or";
    private static final String SS_SCRIPT_FILE_PREFIX = "ss";
    private static final String EXP_USER = "exp";
    public static final String DDL_GENERATOR_XSL = "ddl_generator.xsl";
    public static final WorklistCreator<CSDFRecord> s_creator = new WorklistCreator<CSDFRecord>(){

        @Override
        public Document createWorklistFromRecords(Collection<CSDFRecord> records) throws Exception {
            return InsertExpCustomFieldInfo.getCSDefWorklistDocument(records);
        }
    };

    public String createCustomColumnScript(RetrieveExpCustomFieldInfo<T> customColumnRetriever, WorklistCreator<T> worklistCreator, ServerType dbType, Transformer trans) throws SQLException, Exception, TransformerException {
        Collection<T> records = customColumnRetriever.getRecords();
        Document worklistDoc = worklistCreator.createWorklistFromRecords(records);
        String updateScript = InsertExpCustomFieldInfo.createScriptFileFromWorklist(worklistDoc, dbType, trans);
        System.out.println(updateScript);
        return updateScript;
    }

    public static void main(String[] args) throws TransformerConfigurationException, FileNotFoundException {
        String pathToSampleDataFile = args[0];
        String pathToSqlFile = args[1];
        String xslDirectory = args[2];
        FileInputStream xsltStream = new FileInputStream(xslDirectory + FILE_SEPARATOR + DDL_GENERATOR_XSL);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer trans = factory.newTransformer(new StreamSource(xsltStream));
        CustomColumnUtil.writeCSDF(ServerType.ORACLE, pathToSampleDataFile, pathToSqlFile, trans);
        CustomColumnUtil.writeCSDF(ServerType.SQLSERVER, pathToSampleDataFile, pathToSqlFile, trans);
        CustomColumnUtil.writeGCDF(ServerType.ORACLE, pathToSampleDataFile, pathToSqlFile, trans);
        CustomColumnUtil.writeGCDF(ServerType.SQLSERVER, pathToSampleDataFile, pathToSqlFile, trans);
    }

    public static void writeCSDF(ServerType st, String pathToSampleDataFile, String pathToSqlFile, Transformer transform) {
        String sqlScript = null;
        pathToSqlFile = st.toString().equals("ORACLE") ? pathToSqlFile + FILE_SEPARATOR + OR_SCRIPT_FILE_PREFIX + EXP_USER + "_" + CSDF_SCRIPT_FILE_NAME + ".sql" : pathToSqlFile + FILE_SEPARATOR + SS_SCRIPT_FILE_PREFIX + EXP_USER + "_" + CSDF_SCRIPT_FILE_NAME + ".sql";
        CustomColumnUtil<CSDFRecord> gcdfUtil = new CustomColumnUtil<CSDFRecord>();
        RetrieveExpCustomfieldInfoFromSampleDataZip genericRetriever = new RetrieveExpCustomfieldInfoFromSampleDataZip(pathToSampleDataFile);
        WorklistCreator<CSDFRecord> csdfCreator = new WorklistCreator<CSDFRecord>(){

            @Override
            public Document createWorklistFromRecords(Collection<CSDFRecord> records) throws Exception {
                return InsertExpCustomFieldInfo.getCSDefWorklistDocument(records);
            }
        };
        try {
            sqlScript = gcdfUtil.createCustomColumnScript(genericRetriever.m_csdfRecordRetriever, csdfCreator, st, transform);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream out = new FileOutputStream(pathToSqlFile);
            PrintStream p = new PrintStream(out);
            p.print(sqlScript);
            p.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeGCDF(ServerType st, String pathToSampleDataFile, String pathToSqlFile, Transformer trans) {
        String sqlScript = null;
        pathToSqlFile = st == ServerType.ORACLE ? pathToSqlFile + FILE_SEPARATOR + OR_SCRIPT_FILE_PREFIX + "_" + GCDF_SCRIPT_FILE_NAME + ".sql" : pathToSqlFile + FILE_SEPARATOR + SS_SCRIPT_FILE_PREFIX + "_" + GCDF_SCRIPT_FILE_NAME + ".sql";
        CustomColumnUtil<GCDFRecord> gcdfUtil = new CustomColumnUtil<GCDFRecord>();
        RetrieveExpCustomfieldInfoFromSampleDataZip genericRetriever = new RetrieveExpCustomfieldInfoFromSampleDataZip(pathToSampleDataFile);
        WorklistCreator<GCDFRecord> gcdfCreator = new WorklistCreator<GCDFRecord>(){

            @Override
            public Document createWorklistFromRecords(Collection<GCDFRecord> records) throws Exception {
                return InsertExpCustomFieldInfo.getGCDefWorklistDocument(records);
            }
        };
        try {
            sqlScript = gcdfUtil.createCustomColumnScript(genericRetriever.m_gcdfRecordRetriever, gcdfCreator, st, trans);
            if (sqlScript.length() > 0) {
                try {
                    FileOutputStream out = new FileOutputStream(pathToSqlFile);
                    PrintStream p = new PrintStream(out);
                    p.print(sqlScript);
                    p.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface WorklistCreator<U> {
        public Document createWorklistFromRecords(Collection<U> var1) throws Exception;
    }
}

