/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.common.JVMParam;
import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.container.ColumnDetails;
import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.tools.BlobEncodingUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class SQLRowInserter {
    private static boolean s_bUseOracleBatchInserts = JVMParam.USEBATCHINSERTS.getBooleanValue();
    private static boolean s_bUseMSSQLBatchInserts = JVMParam.USEMSSQLBATCHINSERTS.getBooleanValue();
    private static final String SDO_GEOMETRY_NATIVE_DATATYPE = "SDO_GEOMETRY";
    public static int batchRowCounter = 0;
    Connection connection = null;
    ServerType st = null;
    private String sql = null;
    private String table_name = null;
    private PreparedStatement stmt = null;
    List<String> blob_fields;
    Map<String, ColumnDetails> databaseColumns;
    BLOB blobdata;

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.st = DatabaseHelper.getServerType(connection);
    }

    public void initializeMetaData(String table, RowContainer rc) throws SQLException {
        this.blob_fields = new ArrayList<String>();
        this.databaseColumns = new HashMap<String, ColumnDetails>();
        String insert_sql = "insert into " + table + "(";
        String value_sql = " values (";
        String bind_val = "?";
        this.table_name = table;
        int cnt = 1;
        if (this.st == ServerType.ORACLE) {
            if (this.blobdata != null && this.blobdata.isOpen()) {
                this.blobdata.close();
            }
            this.blobdata = BLOB.createTemporary((Connection)this.connection, (boolean)false, (int)10);
        }
        Iterator<RowElement> i = rc.iterator();
        while (i.hasNext()) {
            RowElement re = i.next();
            String datatype = DatabaseHelper.getColumnDataType(this.connection, this.table_name.toUpperCase(), re.getName().toUpperCase());
            GenericDataTypes generic = re.getType();
            if (generic == GenericDataTypes.CLOB && datatype.compareTo("BLOB") == 0) {
                generic = GenericDataTypes.BLOB;
            } else if (generic == GenericDataTypes.BLOB && "text".equalsIgnoreCase(datatype)) {
                generic = GenericDataTypes.CLOB;
            } else if (generic == GenericDataTypes.MEMO && "clob".equalsIgnoreCase(datatype)) {
                generic = GenericDataTypes.CLOB;
            } else if (generic == GenericDataTypes.CLOB && "XMLTYPE".equalsIgnoreCase(datatype)) {
                generic = GenericDataTypes.XMLTYPE;
            } else if (SDO_GEOMETRY_NATIVE_DATATYPE.equalsIgnoreCase(datatype)) {
                generic = GenericDataTypes.GEOMETRY;
                re.setType(generic);
            }
            this.databaseColumns.put(re.getName().toUpperCase(), new ColumnDetails(datatype.length() > 0, datatype, generic));
            if (datatype.length() <= 0) continue;
            if (re.getType() == GenericDataTypes.BLOB) {
                this.blob_fields.add(re.getName());
                bind_val = "?";
            } else if (re.getType() == GenericDataTypes.CLOB) {
                this.blob_fields.add(re.getName());
                bind_val = "?";
            } else if (re.getType() == GenericDataTypes.DATE) {
                if (this.st == ServerType.ORACLE) {
                    bind_val = "to_date(?,'YYYY-MM-DD HH24:MI:SS')";
                }
            } else if (re.getType() == GenericDataTypes.XMLTYPE) {
                if (this.st == ServerType.ORACLE) {
                    bind_val = "xmltype(?)";
                }
            } else {
                bind_val = re.getType() == GenericDataTypes.GEOMETRY && SDO_GEOMETRY_NATIVE_DATATYPE.equalsIgnoreCase(datatype) ? "SDO_GEOMETRY(2001, 8307, sdo_point_type(?, ?, null), null, null)" : "?";
            }
            if (cnt == 1) {
                insert_sql = insert_sql + re.getName();
                value_sql = value_sql + bind_val;
            } else {
                insert_sql = insert_sql + "," + re.getName();
                value_sql = value_sql + "," + bind_val;
            }
            ++cnt;
        }
        this.sql = insert_sql + ")" + value_sql + ")";
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = this.connection.prepareCall(this.sql);
    }

    private String scrubString(boolean treatEmptyStringAsNull, ServerType serverType, String value) {
        if (!treatEmptyStringAsNull && serverType == ServerType.ORACLE && value != null && value.isEmpty()) {
            return " ";
        }
        return value;
    }

    boolean treatEmptyStringsAsNull(RowContainer rc, RowElement re) {
        if (rc.getScrubber() == null) {
            return true;
        }
        return rc.getScrubber().treatEmptyStringsAsNull(rc.getName(), re.getName());
    }

    private void bind(RowContainer rc) throws SQLException {
        Iterator<RowElement> i = rc.iterator();
        int col = 1;
        while (i.hasNext()) {
            RowElement re = i.next();
            ColumnDetails cd = this.databaseColumns.get(re.getName().toUpperCase());
            boolean treatEmptyStringAsNull = this.treatEmptyStringsAsNull(rc, re);
            if (cd == null || !cd.columnExists) continue;
            if (SDO_GEOMETRY_NATIVE_DATATYPE.equalsIgnoreCase(cd.nativeDataType)) {
                cd.genericType = GenericDataTypes.GEOMETRY;
            }
            if (re.isNull(treatEmptyStringAsNull)) {
                if (cd.genericType.equals((Object)GenericDataTypes.GEOMETRY)) {
                    this.stmt.setDouble(col++, 0.0);
                    this.stmt.setDouble(col, 0.0);
                } else {
                    this.stmt.setNull(col, DatabaseHelper.javaFromGenericType(cd.genericType), cd.nativeDataType);
                }
            } else {
                switch (cd.genericType) {
                    case CHARACTER: 
                    case OCHARACTER: 
                    case STRING: {
                        this.stmt.setString(col, this.scrubString(treatEmptyStringAsNull, this.st, re.getValue()));
                        break;
                    }
                    case SMALLINT: 
                    case TINYINT: 
                    case INTEGER: {
                        this.stmt.setInt(col, re.getInt());
                        break;
                    }
                    case NUMBER: 
                    case DOUBLE: {
                        this.stmt.setDouble(col, re.getDouble());
                        break;
                    }
                    case IMAGE: 
                    case MEMO: 
                    case BLOB: {
                        if (this.st == ServerType.ORACLE) {
                            if (BlobEncodingUtil.isImageField(this.table_name, re.getName())) {
                                this.stmt.setBytes(col, re.getBytes());
                                break;
                            }
                            if (this.blobdata != null && this.blobdata.isOpen()) {
                                this.blobdata.close();
                            }
                            this.blobdata = BLOB.createTemporary((Connection)this.connection, (boolean)false, (int)10);
                            String data = re.getValue().replace('\r', '\n');
                            byte[] dataBytes = new byte[]{};
                            try {
                                dataBytes = data.getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                            int startIndex = 1;
                            if (!BlobEncodingUtil.isNonHTMLField(this.table_name, re.getName())) {
                                this.blobdata.setBytes((long)startIndex, BlobEncodingUtil.UTF_8_BOM);
                                startIndex += BlobEncodingUtil.UTF_8_BOM.length;
                            }
                            this.blobdata.setBytes((long)startIndex, dataBytes);
                            this.stmt.setBlob(col, (Blob)this.blobdata);
                            break;
                        }
                        if ("text".equalsIgnoreCase(cd.nativeDataType)) {
                            this.stmt.setString(col, re.getValue());
                            break;
                        }
                        this.stmt.setBytes(col, re.getBytes());
                        break;
                    }
                    case CLOB: {
                        String value;
                        if (this.st != ServerType.ORACLE) {
                            value = re.getValue();
                            value = value.replace('\r', '\n');
                            this.stmt.setString(col, value);
                            break;
                        }
                        this.stmt.setString(col, re.getValue());
                        break;
                    }
                    case XMLTYPE: {
                        String value;
                        if (this.st != ServerType.ORACLE) {
                            value = re.getValue();
                            value = value.replace('\r', '\n');
                            this.stmt.setString(col, value);
                            break;
                        }
                        if (re.getSize() > 4000) {
                            try {
                                CLOB clob = this.getCLOB(re.getValue());
                                this.stmt.setObject(col, clob);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        this.stmt.setString(col, re.getValue());
                        break;
                    }
                    case BINARY: {
                        byte[] bytes = re.getBytes();
                        this.stmt.setBytes(col, bytes);
                        break;
                    }
                    case GEOMETRY: {
                        if (SDO_GEOMETRY_NATIVE_DATATYPE.equalsIgnoreCase(cd.nativeDataType)) {
                            String[] strPoint = re.getValue().split(",");
                            double x = Double.parseDouble(strPoint[0]);
                            double y = Double.parseDouble(strPoint[1]);
                            this.stmt.setDouble(col++, x);
                            this.stmt.setDouble(col, y);
                            break;
                        }
                        this.stmt.setString(col, re.getValue());
                        break;
                    }
                    default: {
                        this.stmt.setString(col, this.scrubString(treatEmptyStringAsNull, this.st, re.getValue()));
                    }
                }
            }
            ++col;
        }
    }

    public void insert(RowContainer rc) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection is not open");
        }
        this.bind(rc);
        if (this.useBatchInserts()) {
            this.stmt.addBatch();
            ++batchRowCounter;
        } else {
            this.stmt.execute();
        }
    }

    private boolean useBatchInserts() {
        return this.st == ServerType.ORACLE || this.st == ServerType.SQLSERVER;
    }

    public void executeBatch() throws SQLException {
        if (this.useBatchInserts() && this.stmt != null) {
            this.stmt.executeBatch();
        }
    }

    public String getSql() {
        return this.sql;
    }

    private CLOB getCLOB(String xmlData) throws SQLException, IOException {
        CLOB tempClob = null;
        try {
            tempClob = CLOB.createTemporary((Connection)this.connection, (boolean)true, (int)10);
            tempClob.open(1);
            Writer tempClobWriter = tempClob.getCharacterOutputStream();
            tempClobWriter.write(xmlData);
            tempClobWriter.flush();
            tempClobWriter.close();
            tempClob.close();
        }
        catch (SQLException sqlexp) {
            if (tempClob != null) {
                tempClob.freeTemporary();
            }
            sqlexp.printStackTrace();
        }
        return tempClob;
    }
}

