/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.container.EncodingUtil;
import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.RowScrubber;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.BlobEncodingUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SQLRowContainer
extends RowContainer {
    private final ResultSet m_rs;
    private ResultSetMetaData m_meta;
    private final Connection m_connection;
    private String m_dbEncoding;
    private static String m_dbEncode;

    public SQLRowContainer(Connection c, ResultSet rs, String tablename, RowScrubber scrubber) throws SQLException {
        this.m_connection = c;
        this.m_rs = rs;
        this.setName(tablename.toUpperCase());
        this.setScrubber(scrubber);
        this.initializeContainer();
    }

    public SQLRowContainer(Connection c, ResultSet rs) throws SQLException {
        this.m_connection = c;
        this.m_rs = rs;
        this.initializeContainer();
    }

    private synchronized String getDatabaseEncoding() {
        if (this.m_dbEncoding == null) {
            try {
                this.m_dbEncoding = BlobEncodingUtil.getDBEncoding(this.m_connection);
            }
            catch (SQLException e) {
                DBMTLogger.error(Channel.USER, "Uable to retrieve database encoding, using UTF-8", e);
            }
        }
        return this.m_dbEncoding;
    }

    private boolean doNext() throws SQLException {
        boolean keep = false;
        while (this.m_rs.next()) {
            this.updateContainer();
            keep = this.needsScrub(this.getName()) ? this.getScrubber().keepRow(this) : true;
            if (!keep) continue;
            return true;
        }
        return false;
    }

    public boolean Next() throws SQLException {
        this.clearValues();
        boolean b = this.doNext();
        this.scrub();
        return b;
    }

    private void updateContainer() throws SQLException {
        for (int i = 1; i <= this.m_meta.getColumnCount(); ++i) {
            try {
                if (!(this.get(i).getType() != GenericDataTypes.MEMO && this.get(i).getType() != GenericDataTypes.BLOB || BlobEncodingUtil.isImageField(this.getName(), this.m_meta.getColumnName(i)) || this.m_meta.getColumnTypeName(i).equalsIgnoreCase(GenericDataTypes.CLOB.toString()))) {
                    if (this.m_rs.getBytes(i) == null) continue;
                    byte[] bytes = this.m_rs.getBytes(i);
                    if (BlobEncodingUtil.hasBOM(bytes)) {
                        if (BlobEncodingUtil.UTF_8_BOM.length >= bytes.length - BlobEncodingUtil.UTF_8_BOM.length) continue;
                        this.get(i).setBytes(Arrays.copyOfRange(bytes, BlobEncodingUtil.UTF_8_BOM.length, bytes.length));
                        continue;
                    }
                    if (m_dbEncode == null) {
                        m_dbEncode = BlobEncodingUtil.getDBEncoding(this.m_connection);
                    }
                    String encodedBytes = new String(bytes, m_dbEncode);
                    this.get(i).setBytes(encodedBytes.getBytes("UTF-8"));
                    continue;
                }
                if (this.m_meta.getColumnType(i) == 2004 || this.get(i).getType() == GenericDataTypes.BINARY || DatabaseHelper.genericFromJavaType(this.m_meta.getColumnType(i)) == GenericDataTypes.BINARY) {
                    if (this.m_rs.getBytes(i) == null) continue;
                    this.get(i).setBytes(this.m_rs.getBytes(i));
                    continue;
                }
                if (this.get(i).getType() == GenericDataTypes.GEOMETRY) {
                    Object obj = this.m_rs.getObject(i);
                    if (obj != null) {
                        if (obj instanceof STRUCT) {
                            STRUCT st = (STRUCT)obj;
                            JGeometry geom = JGeometry.load((STRUCT)st);
                            double[] point = geom.getFirstPoint();
                            String sPoint = Double.toString(point[0]) + "," + Double.toString(point[1]);
                            this.get(i).setValue(sPoint);
                            this.get(i).setObject(obj);
                            continue;
                        }
                        if (!(obj instanceof String)) continue;
                        this.get(i).setValue((String)obj);
                        continue;
                    }
                    this.get(i).setValue("0,0");
                    continue;
                }
                if (this.m_rs.getString(i) != null && this.m_meta.getColumnTypeName(i).equalsIgnoreCase(GenericDataTypes.CLOB.toString())) {
                    String value = EncodingUtil.removeBOMCharactersFromString(this.m_rs.getString(i));
                    this.get(i).setValue(value);
                    continue;
                }
                if (this.m_rs.getString(i) == null) continue;
                this.get(i).setValue(this.m_rs.getString(i));
                continue;
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
        }
    }

    private void initializeContainer() throws SQLException {
        this.m_meta = this.m_rs.getMetaData();
        for (int i = 1; i <= this.m_meta.getColumnCount(); ++i) {
            RowElement re = new RowElement();
            re.setName(this.m_meta.getColumnName(i));
            if (this.forceBase64(this.getName(), re.getName())) {
                re.setType(GenericDataTypes.BLOB);
            } else {
                re.setType(DatabaseHelper.genericFromJavaType(this.m_meta.getColumnType(i)));
            }
            re.setSize(this.m_meta.getColumnDisplaySize(i));
            this.addElement(re);
        }
    }
}

