/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentErrorException;
import com.primavera.database.common.argsprocessor.CharTracker;
import com.primavera.database.common.argsprocessor.ParameterDef;
import com.primavera.database.common.argsprocessor.ParameterSet;
import com.primavera.database.common.argsprocessor.StringTracker;
import java.io.PrintStream;
import java.lang.reflect.Field;

public class ArgumentProcessor {
    private final ParameterSet m_parameterSet;
    private CharTracker m_currentArg;
    private int m_currentIndex;
    private StringTracker m_remainingArgs;
    private Object m_targetObject;

    public ArgumentProcessor(ParameterSet set) {
        this.m_parameterSet = set;
    }

    public ArgumentProcessor(ParameterDef[] defs) {
        this(new ParameterSet(defs, null));
    }

    private void bindDefinitions(Object parm) {
        ParameterDef def;
        int index = 0;
        Class<?> clas = parm.getClass();
        while ((def = this.m_parameterSet.indexDef(index++)) != null) {
            def.bindToClass(clas);
        }
    }

    public Object processArgs(String[] args, Object target) {
        this.bindDefinitions(target);
        String[] trims = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            trims[i] = args[i].trim();
        }
        this.m_currentArg = new CharTracker("", 0);
        this.m_remainingArgs = new StringTracker(trims, 0);
        this.m_targetObject = target;
        while (true) {
            String next;
            if (this.m_currentArg.hasNext()) {
                char flag = this.m_currentArg.next();
                ParameterDef def = this.m_parameterSet.findDef(flag);
                if (def != null) {
                    def.handle(this);
                    continue;
                }
                throw new IllegalArgumentException("Control flag '" + flag + "' in argument " + this.m_currentIndex + " is not defined");
            }
            if (!this.m_remainingArgs.hasNext() || (next = this.m_remainingArgs.peek()).length() <= 0 || next.charAt(0) != '-') break;
            this.m_remainingArgs.next();
            this.m_currentIndex = this.m_remainingArgs.nextOffset();
            this.m_currentArg = new CharTracker(next, 1);
        }
        return this.m_targetObject;
    }

    CharTracker getChars() {
        return this.m_currentArg;
    }

    int getIndex() {
        return this.m_currentIndex;
    }

    public StringTracker getArgs() {
        return this.m_remainingArgs;
    }

    void setValue(Object value, Field field) {
        try {
            field.set(this.m_targetObject, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Field " + field.getName() + " is not accessible in object of class " + this.m_targetObject.getClass().getName());
        }
    }

    public void reportArgumentError(char flag, String text) {
        throw new ArgumentErrorException(text + " for parameter '" + flag + "' in argument " + this.m_currentIndex);
    }

    public void listParameters(int width, PrintStream print) {
        int i;
        int count = 0;
        int maxlen = 0;
        ParameterDef def = null;
        while ((def = this.m_parameterSet.indexDef(count)) != null) {
            int length = def.getAbbreviation().length();
            if (maxlen < length) {
                maxlen = length;
            }
            ++count;
        }
        StringBuffer line = new StringBuffer(width);
        int lead = maxlen + 2;
        char[] blanks = new char[lead];
        for (i = 0; i < lead; ++i) {
            blanks[i] = 32;
        }
        for (i = 0; i < count; ++i) {
            line.setLength(0);
            def = this.m_parameterSet.indexDef(i);
            line.append(' ');
            line.append(def.getAbbreviation());
            line.append(blanks, 0, lead - line.length());
            String text = def.getDescription();
            while (line.length() + text.length() > width) {
                int limit = width - line.length();
                int mark = text.indexOf(32);
                if (mark < 0) break;
                int split = mark;
                while (mark >= 0 && mark <= limit) {
                    split = mark;
                    mark = text.indexOf(32, mark + 1);
                }
                line.append(text.substring(0, split));
                print.println(line.toString());
                line.setLength(0);
                line.append(blanks);
                text = text.substring(split + 1);
            }
            line.append(text);
            print.println(line.toString());
        }
    }

    public static int processArgs(String[] args, ParameterDef[] parms, Object target) {
        ArgumentProcessor inst = new ArgumentProcessor(parms);
        inst.processArgs(args, target);
        return inst.m_remainingArgs.nextOffset();
    }
}

