/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.Base64;
import com.primavera.database.common.Field;
import com.primavera.database.common.Table;
import com.primavera.database.common.TableManipulatorInterface;
import com.primavera.database.common.logging.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TableManipulator
implements TableManipulatorInterface {
    private static Hashtable<String, Table> s_tables = new Hashtable();
    private static Hashtable<String, Table> s_pmSchemaTables = new Hashtable();
    private static final String s_tmConfigFile = "DAFImporterTMConfig.xml";
    private ArrayList<String> m_excluded_tables = new ArrayList();

    public TableManipulator() {
        Document doc = null;
        try {
            String tableName;
            int i;
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(s_tmConfigFile));
            NodeList nodes = doc.getElementsByTagName("excludedTable");
            for (i = 0; i < nodes.getLength(); ++i) {
                tableName = nodes.item(i).getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
                this.addExcludedTable(tableName);
            }
            nodes = doc.getElementsByTagName("specialField");
            for (i = 0; i < nodes.getLength(); ++i) {
                tableName = nodes.item(i).getAttributes().getNamedItem("tablename").getNodeValue().toUpperCase();
                String fieldName = nodes.item(i).getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
                boolean toEncode = false;
                toEncode = nodes.item(i).getAttributes().getNamedItem("toEncode").getNodeValue().equalsIgnoreCase("Y");
                boolean toDecode = false;
                toDecode = nodes.item(i).getAttributes().getNamedItem("toDecode").getNodeValue().equalsIgnoreCase("Y");
                String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
                Field fld = new Field(fieldName, type, "", toEncode, toDecode);
                Table t = new Table(tableName);
                t.addField(fld);
                this.addTable(tableName, t);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printPMSchema() {
        Enumeration<String> enumTables = s_pmSchemaTables.keys();
        while (enumTables.hasMoreElements()) {
            String tableName = enumTables.nextElement();
            Log.info("TABLE: " + tableName);
            Table t = s_pmSchemaTables.get(tableName);
            Enumeration<String> enumFieldNames = t.getFields().keys();
            while (enumFieldNames.hasMoreElements()) {
                String fldName = enumFieldNames.nextElement();
                Field fld = t.getFields().get(fldName);
                boolean nNUL = fld.getNotNUL();
                Log.info("\t" + fldName + " is " + nNUL);
            }
        }
    }

    @Override
    public void getPMSchemaTables(String pmVersion) {
        try {
            String[] tablesList;
            for (String element : tablesList = TableManipulator.getTablesList("/PrimaveraDatabaseSchema/TABLE", pmVersion)) {
                try {
                    String[] fieldsList;
                    Table t = new Table(element);
                    String path = "/PrimaveraDatabaseSchema/TABLE[@NAME='" + element + "']/FIELD";
                    for (String element2 : fieldsList = TableManipulator.getNotNullFields(path, pmVersion)) {
                        Field fld = null;
                        fld = new Field(element2, true);
                        t.addField(fld);
                    }
                    s_pmSchemaTables.put(element, t);
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public static String[] getTablesList(String path, String pmVersion) throws XPathExpressionException {
        String pmSchema = "install/" + pmVersion + (pmVersion.startsWith("PPM") ? "/ppmSchema.xml" : "/pmSchema.xml");
        String namedItem = "NAME";
        InputStream inStream = ClassLoader.getSystemResourceAsStream(pmSchema);
        InputSource in = new InputSource(new InputStreamReader(inStream));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(path);
        NodeList nl = (NodeList)expr.evaluate(in, XPathConstants.NODESET);
        ArrayList<String> sqlScripts = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String dirPath = nl.item(i).getAttributes().getNamedItem(namedItem).getNodeValue();
            sqlScripts.add(dirPath);
        }
        return sqlScripts.toArray(new String[0]);
    }

    public static String[] getNotNullFields(String path, String pmVersion) throws XPathExpressionException {
        String pmSchema = "install/" + pmVersion + (pmVersion.startsWith("PPM") ? "/ppmSchema.xml" : "/pmSchema.xml");
        String namedItem = "NOTNULL";
        String columnName = "NAME";
        InputStream inStream = ClassLoader.getSystemResourceAsStream(pmSchema);
        InputSource in = new InputSource(new InputStreamReader(inStream));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(path);
        NodeList nl = (NodeList)expr.evaluate(in, XPathConstants.NODESET);
        ArrayList<String> sqlScripts = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String dirPath = nl.item(i).getAttributes().getNamedItem(namedItem).getNodeValue();
            String cName = nl.item(i).getAttributes().getNamedItem(columnName).getNodeValue();
            if (!"Y".equalsIgnoreCase(dirPath)) continue;
            sqlScripts.add(cName);
        }
        return sqlScripts.toArray(new String[0]);
    }

    @Override
    public Reader removeRowsWithNullsInNotNull(Reader reader, String tableName) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, TransformerConfigurationException {
        String fileContent = this.readFileToString(reader);
        String fileName = "temp_xmlFileForNotNullRowsRemove.xml";
        String transformNotNullFieldsFile = "temp_transformNotNullFieldsFile.xml";
        this.writeStringToFile(fileName, fileContent);
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(fileName));
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (doc == null) {
            return null;
        }
        NodeList nodes = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer tFormer = tFactory.newTransformer();
        nodes = doc.getElementsByTagName("ROW");
        block5: for (int rowIndex = 0; rowIndex < nodes.getLength(); ++rowIndex) {
            Enumeration<String> enumNotNullFields = s_pmSchemaTables.get(tableName).getFields().keys();
            while (enumNotNullFields.hasMoreElements()) {
                Element rowToRemove;
                String fieldName = enumNotNullFields.nextElement().toUpperCase();
                Log.info("Check whether field:" + fieldName + " in table:" + tableName + " has NULL values");
                NamedNodeMap nnm = nodes.item(rowIndex).getAttributes();
                String notNullFieldValue = null;
                Element currentNode = (Element)doc.getElementsByTagName("ROW").item(rowIndex);
                if (!currentNode.hasAttribute(fieldName)) {
                    rowToRemove = (Element)doc.getElementsByTagName("ROW").item(rowIndex);
                    rowToRemove.getAttribute(fieldName);
                    rowToRemove.getParentNode().removeChild(rowToRemove);
                    Log.info("RemoveRow " + rowIndex + " because of " + fieldName);
                    doc.normalize();
                    --rowIndex;
                    continue block5;
                }
                notNullFieldValue = nnm.getNamedItem(fieldName).getNodeValue();
                if (notNullFieldValue != null && !"".equalsIgnoreCase(notNullFieldValue)) continue;
                rowToRemove = (Element)doc.getElementsByTagName("ROW").item(rowIndex);
                rowToRemove.getAttribute(fieldName);
                rowToRemove.getParentNode().removeChild(rowToRemove);
                Log.info("RemoveRow " + rowIndex + " because of " + fieldName);
                doc.normalize();
                --rowIndex;
                continue block5;
            }
        }
        DOMSource source = new DOMSource(doc);
        StreamResult dest = new StreamResult(new File(transformNotNullFieldsFile));
        try {
            tFormer.transform(source, dest);
        }
        catch (TransformerException e) {
            Log.warn("Failed to replace row with not nullable attribute that is null." + e.toString());
        }
        return new BufferedReader(new FileReader(transformNotNullFieldsFile));
    }

    private void writeStringToFile(String fileName, String fileContent) throws IOException {
        File file = new File(fileName);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        output.write(fileContent);
        ((Writer)output).close();
    }

    private String readFileToString(Reader reader) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        String fileStringData = fileData.toString();
        return fileStringData;
    }

    @Override
    public boolean toDecodeField(String tableName, String fieldName) {
        if (s_tables.containsKey(tableName) && s_tables.get(tableName).getFields().containsKey(fieldName)) {
            return s_tables.get(tableName).getFields().get(fieldName).getToDecode();
        }
        return false;
    }

    @Override
    public void addTable(String tableName, Table t) {
        s_tables.put(tableName, t);
    }

    @Override
    public Hashtable<String, Table> getHashToEncode() {
        return s_tables;
    }

    public static void setHashToEncode(Hashtable<String, Table> hashTables) {
        s_tables = hashTables;
    }

    @Override
    public ArrayList<String> getExcludedTables() {
        return this.m_excluded_tables;
    }

    public void setExcludedTables(ArrayList<String> excludedTables) {
        this.m_excluded_tables = excludedTables;
    }

    @Override
    public void addExcludedTable(String tableName) {
        this.m_excluded_tables.add(tableName.toUpperCase());
    }

    @Override
    public boolean isExcluded(String tableName) {
        if (tableName.toUpperCase().startsWith("DLT") || tableName.toUpperCase().startsWith("TEMPKEYS") || tableName.toUpperCase().startsWith("TPROJMAP")) {
            return true;
        }
        return this.m_excluded_tables.contains(tableName.toUpperCase());
    }

    @Override
    public Reader encodeXmlTable(Reader reader, String tableName) throws Exception {
        String encoded = "";
        String notEncoded = "";
        String attrName = null;
        if (this.getHashToEncode().containsKey(tableName)) {
            String[] str;
            StringBuffer fileData = new StringBuffer(1000);
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            String fileStringData = fileData.toString();
            String[] stringArray = str = this.getHashToEncode().get(tableName).getFieldsToEncode();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element;
                attrName = element = stringArray[i];
                int index = fileStringData.indexOf(attrName = attrName.toUpperCase());
                if (index == -1 && (index = fileStringData.indexOf(attrName.toLowerCase())) == -1) {
                    return reader;
                }
                int attrIndex = fileStringData.substring(0, index).lastIndexOf("attrname");
                if (attrIndex == -1) {
                    return reader;
                }
                int firstDQ = fileStringData.indexOf("\"", attrIndex);
                int secondDQ = fileStringData.indexOf("\"", firstDQ + 1);
                attrName = attrName + "=\"";
                firstDQ = fileStringData.indexOf(attrName);
                while (firstDQ != -1) {
                    firstDQ = fileStringData.indexOf("\"", firstDQ);
                    secondDQ = fileStringData.indexOf("\"", firstDQ + 1);
                    notEncoded = fileStringData.substring(firstDQ + 1, secondDQ);
                    byte[] notEncodedBytes = notEncoded.getBytes();
                    encoded = Base64.encodeBytes(notEncodedBytes);
                    fileStringData = fileStringData.substring(0, firstDQ + 1) + encoded + fileStringData.substring(secondDQ);
                    firstDQ = fileStringData.indexOf(attrName, firstDQ + 5);
                }
            }
            String tempFile = "tempFile.xml";
            File file = new File(tempFile);
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            output.write(fileStringData);
            ((Writer)output).close();
            reader.close();
            return new BufferedReader(new FileReader(tempFile));
        }
        return reader;
    }
}

