/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.workflow.nodes;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.SchemaActions;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.RootNodeAdapter;
import com.primavera.database.tools.dbmt.xml.util.workflow.WorkflowSchemaNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.CreateNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.DatabaseNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.FeaturesNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.InstallNodeNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.KeyStoreNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.MigrateNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.UpgradeNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.VersionNode;
import org.xml.sax.Attributes;

public class SchemaNode
extends RootNodeAdapter
implements WorkflowSchemaNode {
    private final String m_name;
    private final String m_version;
    private final SchemaActions m_actions;
    private final SchemaInfoImpl m_schema;

    public SchemaNode(Attributes attr, SchemaActions actions) {
        super("schema");
        this.m_actions = actions;
        this.m_name = attr.getValue("name");
        this.m_version = attr.getValue("version");
        this.m_schema = SchemaInfoImpl.create(this.m_name, this.m_version);
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("database".equals(elemName)) {
            return new DatabaseNode(this, attr);
        }
        if ("keystore".equals(elemName)) {
            return new KeyStoreNode(this, attr);
        }
        if ("create".equals(elemName)) {
            return new CreateNode(this, attr);
        }
        if ("version".equals(elemName)) {
            return new VersionNode(this, attr);
        }
        if ("install".equals(elemName)) {
            return new InstallNodeNode(this, attr);
        }
        if ("upgrade".equals(elemName)) {
            return new UpgradeNode(this, attr);
        }
        if ("pre-migrate".equals(elemName)) {
            return new MigrateNode(this, attr, ActionType.PRE_MIGRATE);
        }
        if ("post-migrate".equals(elemName)) {
            return new MigrateNode(this, attr, ActionType.POST_MIGRATE);
        }
        if ("features".equals(elemName)) {
            return new FeaturesNode(this, attr);
        }
        if ("schema-migrate".equals(elemName)) {
            return new MigrateNode(this, attr, ActionType.SCHEMA_MIGRATE);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String getPropertyIdPath() {
        return "schema." + this.m_name + "." + this.m_version;
    }

    @Override
    public final SchemaActions getActions() {
        return this.m_actions;
    }

    @Override
    public final SchemaInfo getSchema() {
        return this.m_schema;
    }

    public void setVersionQuery(String versionQuery, ServerType type) {
        this.m_schema.setVersionQuery(versionQuery, type);
    }
}

