/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.workflow.nodes;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.xml.util.workflow.WorkflowSchemaSubNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.SchemaNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.VersionNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class QueryNode
extends WorkflowSchemaSubNode<VersionNode> {
    private final StringBuffer m_queryString = new StringBuffer();
    private final String m_dbType;

    public QueryNode(VersionNode parent, Attributes attr) {
        super(parent, "query", attr);
        this.m_dbType = attr.getValue("rdbms");
    }

    @Override
    public void onContent(char[] ch, int start, int length) {
        this.m_queryString.append(new String(ch, start, length));
    }

    @Override
    public void onEnd() throws SAXException {
        if (this.m_dbType == null) {
            for (ServerType server : ServerType.values()) {
                ((SchemaNode)((VersionNode)this.getParent()).getParent()).setVersionQuery(this.m_queryString.toString(), server);
            }
        }
        ServerType server = null;
        for (ServerType type : ServerType.values()) {
            if (!type.getShortName().equals(this.m_dbType)) continue;
            server = type;
            break;
        }
        if (server == null) {
            DBMTLogger.error(Channel.DEV, "Unknown server type " + this.m_dbType);
        }
        ((SchemaNode)((VersionNode)this.getParent()).getParent()).setVersionQuery(this.m_queryString.toString(), server);
    }
}

