/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.suite.nodes;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.tools.dbmt.ProductId;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.ProductInfoImpl;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.RootNodeAdapter;
import com.primavera.database.tools.dbmt.xml.util.suite.nodes.SchemaNode;
import java.util.Collection;
import java.util.HashSet;
import org.xml.sax.Attributes;

public class SuiteNode
extends RootNodeAdapter {
    private final Collection<SchemaInfo> m_reqSchemas = new HashSet<SchemaInfo>();
    private final Collection<SchemaInfo> m_optSchemas = new HashSet<SchemaInfo>();
    private final ProductInfo m_info;

    public SuiteNode(Attributes attr) {
        super("suite");
        ProductSuiteType type = ProductSuiteType.valueOf(attr.getValue("type"));
        ProductVersion version = ProductVersion.fromString(attr.getValue("version"));
        this.m_info = new ProductInfoImpl(new ProductId(type, version));
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("schema".equals(elemName)) {
            return new SchemaNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    public void addSchema(boolean required, SchemaInfo info) {
        if (required) {
            this.m_reqSchemas.add(info);
        } else {
            this.m_optSchemas.add(info);
        }
    }

    @Override
    public void onEnd() {
        this.m_info.getRequiredSchemas().addAll(this.m_reqSchemas);
        this.m_info.getOptionalSchemas().addAll(this.m_optSchemas);
    }

    public final ProductInfo getInfo() {
        return this.m_info;
    }
}

