/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.propgen.Identification;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.TemplateAccessor;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ReferenceNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ValueRemapNode;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RemapNode
extends PropSubNode<ReferenceNode> {
    private final String m_id;
    private final Map<String, String> m_valueMap = new HashMap<String, String>();

    public RemapNode(ReferenceNode parent, Attributes attr) {
        super(parent, "remap", attr);
        this.m_id = attr.getValue("id");
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("value".equals(elemName)) {
            return new ValueRemapNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    public String getId() {
        return this.m_id;
    }

    public void setValue(String valueId, String valueValue) {
        this.m_valueMap.put(valueId, valueValue);
    }

    public Identification remapIdentifiable(Identification base) {
        String desc = this.m_valueMap.get("desc");
        String title = this.m_valueMap.get("title");
        String mnemonic = this.m_valueMap.get("mnemonic");
        if (desc == null) {
            desc = base.m_descVal;
        }
        if (title == null) {
            title = base.m_nameVal;
        }
        return new Identification(title, desc, Character.valueOf(PropSubNode.getMnemonic(title, mnemonic)));
    }

    @Override
    public void onEnd() throws SAXException {
        Map<String, Identification> template = ((TemplateAccessor)((ReferenceNode)this.getParent()).getParent()).getTemplate(((ReferenceNode)this.getParent()).getId());
        String finalId = this.m_id;
        String newId = this.m_valueMap.get("id");
        if (newId != null) {
            finalId = newId;
        }
        Identification ident = this.remapIdentifiable(template.get(this.m_id));
        template.remove(this.m_id);
        template.put(finalId, ident);
    }
}

