/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.propgen.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.TemplateSetNode;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportNode
extends PropSubNode<ActionContainer> {
    private final String m_location;

    public ImportNode(ActionContainer parent, Attributes attr) {
        super(parent, "import", attr);
        this.m_location = attr.getValue("location");
    }

    public String getLocation() {
        return this.m_location;
    }

    @Override
    public void onStart() throws SAXException {
        try {
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(this.getLocation());
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource " + this.getLocation());
                throw new SAXException("Unable to find resource " + this.getLocation());
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new SimpleHandler(new TemplateHandlerRoot((ActionContainer)this.getParent())));
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public class TemplateHandlerRoot
    implements NodeLink {
        private final ActionContainer m_actionContainer;

        public TemplateHandlerRoot(ActionContainer actionContainer) {
            this.m_actionContainer = actionContainer;
        }

        @Override
        public NodeHandler nextNode(String elemName, Attributes attr) {
            if ("templateset".equals(elemName)) {
                return new TemplateSetNode(this.m_actionContainer, attr);
            }
            return null;
        }

        @Override
        public String path() {
            return "";
        }

        public final ActionContainer getActionContainer() {
            return this.m_actionContainer;
        }
    }
}

