/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.SubNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ContextNode;
import com.primavera.database.tools.dbmt.xml.util.templates.TemplateSetNode;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportNode
extends SubNode<ContextNode> {
    private final String m_location;

    public ImportNode(ContextNode parent, Attributes attr) {
        super(parent, "context", attr);
        this.m_location = attr.getValue("location");
    }

    public final String getLocation() {
        return this.m_location;
    }

    @Override
    public void onStart() throws SAXException {
        try {
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(this.getLocation());
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource " + this.getLocation());
                throw new SAXException("Unable to find resource " + this.getLocation());
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new SimpleHandler(new TemplateHandlerRoot(((ContextNode)this.getParent()).getActionManager())));
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public class TemplateHandlerRoot
    implements NodeLink {
        private final ActionLogicManager m_actionMgr;

        public TemplateHandlerRoot(ActionLogicManager actionMgr) {
            this.m_actionMgr = actionMgr;
        }

        @Override
        public NodeHandler nextNode(String elemName, Attributes attr) {
            if ("templateset".equals(elemName)) {
                return new TemplateSetNode(this.m_actionMgr);
            }
            return null;
        }

        @Override
        public String path() {
            return "";
        }

        public final ActionLogicManager getActionMgr() {
            return this.m_actionMgr;
        }
    }
}

