/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.ForwardLogic;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.tests.TestOp;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.TranslatedDecoratedSubNode;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionNodeContext;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ForwardCommitNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.WizardNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CommitNode
extends TranslatedDecoratedSubNode<WizardNode>
implements ActionNodeContext {
    private final CommitPageDataDef m_dataDef;
    private final boolean m_finishable;
    private ForwardLogic m_forward;
    private final String m_id;
    private final String m_nameKey;
    private final String m_descKey;

    public CommitNode(WizardNode parent, Attributes attr) {
        super(parent, "commit", attr);
        this.m_finishable = Boolean.TRUE.toString().equalsIgnoreCase(attr.getValue("finish"));
        this.m_id = attr.getValue("id");
        this.m_nameKey = this.getPropertyRoot() + ".name";
        this.m_descKey = this.getPropertyRoot() + ".desc";
        this.m_dataDef = new CommitPageDataDef(this.m_id, this.path(), this.m_nameKey, this.m_descKey);
    }

    @Override
    public String getPropertyRoot() {
        return ((WizardNode)this.getParent()).getPropertyRoot() + ".commit." + this.getId();
    }

    public void setForward(ForwardLogic forward) {
        this.m_forward = forward;
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("forward".equals(elemName)) {
            return new ForwardCommitNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public void onStart() throws SAXException {
        ((WizardNode)this.getParent()).getDataDef().getDataDefMap().put(this.getId(), this.m_dataDef);
    }

    @Override
    public void onEnd() throws SAXException {
        if (this.m_forward != null) {
            ((WizardNode)this.getParent()).setForwardForPage(this.m_id, this.m_forward);
        }
        ((WizardNode)this.getParent()).getDataDef().getForwardDependencies(this.getId()).add("commit-status");
        ((WizardNode)this.getParent()).getDataDef().addCommitPage(this.m_id);
        if (this.isFinishable()) {
            ((WizardNode)this.getParent()).getDataDef().addFinishablePage(this.getId());
        }
        ((WizardNode)this.getParent()).getDataDef().getForwardValidators(this.getId()).add(new FieldTester(new TestOp(){

            @Override
            public boolean validate(Object context, InteractorData data, List<String> fieldIds, List<String> params) throws InteractorDataError {
                String value = data.getValue("commit-status");
                boolean isFinished = data.getValue("commit-status").equals(CommitPageDataDef.CommitStatus.FINISHED.toString());
                return isFinished;
            }

            @Override
            public String[] reasonParams(InteractorData data, List<String> fieldIds, List<String> params) throws InvalidDialogField {
                return new String[0];
            }
        }, new ArrayList<String>(), new ArrayList<String>(), null));
        ((WizardNode)this.getParent()).getDataDef().getForwardDependencies(this.m_id).add("commit-status");
    }

    @Override
    public ActionLogicManager getActionManager() {
        return ((WizardNode)this.getParent()).getActionManager();
    }

    @Override
    public String getContextClass() {
        return ((WizardNode)this.getParent()).getContextClass();
    }

    public final boolean isFinishable() {
        return this.m_finishable;
    }
}

