/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.actions.SimpleActionOperation;
import com.primavera.database.tools.dbmt.xml.util.IdentifiableSubNode;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionNodeContext;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionOperationFactory;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionPathable;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.DialogNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.WizardNode;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ActionNode
extends IdentifiableSubNode<ActionContainer>
implements ActionOperationFactory,
ActionPathable,
ActionNodeContext {
    private final String m_actionClass;
    private final String m_contextClass;
    private final String m_filterClass;
    private ActionOperationFactory m_interactorFactory = null;

    public ActionNode(ActionContainer parent, Attributes attr) {
        super(parent, "action", attr);
        this.m_actionClass = attr.getValue("class");
        this.m_contextClass = attr.getValue("context");
        this.m_filterClass = attr.getValue("filter");
    }

    public final ActionOperationFactory getActionFactory() {
        if (this.m_interactorFactory == null) {
            return this;
        }
        return this.m_interactorFactory;
    }

    public final void setActionFactory(ActionOperationFactory factory) throws SAXException {
        if (this.m_interactorFactory != null) {
            throw new SAXException("Cannot set Action Factory for " + this.getPropertyRoot() + ", a wizard or dialog has already been set");
        }
        this.m_interactorFactory = factory;
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("wizard".equals(elemName)) {
            return new WizardNode(this, attr);
        }
        if ("dialog".equals(elemName)) {
            return new DialogNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String getPropertyRoot() {
        return ((ActionContainer)this.getParent()).getPropertyRoot() + "." + this.getId();
    }

    public final String getActionClass() {
        return this.m_actionClass;
    }

    public final String getFilterClass() {
        return this.m_filterClass;
    }

    @Override
    public void onEnd() {
        String actionClassName = this.getActionClass();
        String actionPath = this.getActionPath();
        ActionOperation actionOp = null;
        try {
            actionOp = this.getActionFactory().createAction(this.getActionClass(), this.getContextClass(), this.getActionPath(), this.getNameKey(), this.getDescKey());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.classnotfound", new String[]{actionClassName, actionPath}));
        }
        catch (InstantiationException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.cantinstantiate", new String[]{actionClassName, actionPath}));
        }
        catch (IllegalAccessException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.illegalaccess", new String[]{actionClassName, actionPath}));
        }
        catch (SecurityException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.securityexception", new String[]{actionClassName, actionPath}));
        }
        catch (NoSuchMethodException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.nosuchmethodexception", new String[]{actionClassName, actionPath}));
        }
        catch (IllegalArgumentException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.illegalargument", new String[]{actionClassName, actionPath}));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.invocationexception", new String[]{actionClassName, actionPath}));
        }
        if (actionOp != null) {
            ((ActionContainer)this.getParent()).addAction(this.getId(), actionOp);
        }
    }

    private String getNameKey() {
        return this.getPropertyRoot() + ".name";
    }

    private String getDescKey() {
        return this.getPropertyRoot() + ".desc";
    }

    @Override
    public ActionOperation createAction(String actionClassName, String contextClassName, String actionPath, String nameKey, String descKey) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class<?> actionClass = Class.forName(actionClassName);
        Class<?> contextClass = Class.forName(contextClassName);
        Object contextObject = contextClass.newInstance();
        Object actionObject = actionClass.getConstructor(contextClass).newInstance(contextObject);
        if (actionObject instanceof SimpleActionOperation) {
            SimpleActionOperation action = (SimpleActionOperation)actionObject;
            action.setActionPath(actionPath);
            action.setNameKey(nameKey);
            action.setDescKey(descKey);
            return action;
        }
        DBMTLogger.error(Channel.USER, "Class " + actionClassName + " is not a " + SimpleActionOperation.class.getName() + " for action " + actionPath);
        return null;
    }

    @Override
    public ActionLogicManager getActionManager() {
        return ((ActionContainer)this.getParent()).getActionManager();
    }

    @Override
    public String getActionPath() {
        return ((ActionContainer)this.getParent()).getActionPath() + "/" + this.getId();
    }

    @Override
    public final String getContextClass() {
        return this.m_contextClass;
    }
}

