/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.SubNode;
import com.primavera.database.tools.dbmt.xml.util.actions.AbstractFieldHolderNode;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionNodeContext;
import com.primavera.database.tools.dbmt.xml.util.actions.RemapNode;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReferenceNode
extends SubNode<AbstractFieldHolderNode<?>> {
    private final String m_id;
    private Map<String, ValueDef> m_templateFields = new HashMap<String, ValueDef>();

    public ReferenceNode(AbstractFieldHolderNode<?> parent, Attributes attr) {
        super(parent, "reference", attr);
        this.m_id = attr.getValue("id");
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public void onStart() throws SAXException {
        Map<String, ValueDef> templates = ((ActionNodeContext)((AbstractFieldHolderNode)this.getParent()).getParent()).getActionManager().getTemplate(this.getId());
        if (templates == null) {
            DBMTLogger.error(Channel.DEV, "No template found for id " + this.getId());
        } else {
            String propertyRoot = ((AbstractFieldHolderNode)this.getParent()).getPropertyRoot();
            for (Map.Entry<String, ValueDef> entry : templates.entrySet()) {
                ValueDef def = entry.getValue();
                this.m_templateFields.put(entry.getKey(), def.remapToProperty(propertyRoot));
            }
        }
    }

    @Override
    public void onEnd() throws SAXException {
        for (Map.Entry<String, ValueDef> values : this.m_templateFields.entrySet()) {
            ((AbstractFieldHolderNode)this.getParent()).addField(values.getKey(), values.getValue());
        }
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("remap".equals(elemName)) {
            return new RemapNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    public ValueDef getValueDef(String id) {
        return this.m_templateFields.get(id);
    }

    public void replaceTemplateField(String oldId, String newId, ValueDef valueDef) {
        String id = oldId;
        if (newId != null) {
            this.m_templateFields.remove(oldId);
            id = newId;
        }
        this.m_templateFields.put(id, valueDef);
    }
}

