/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.AbstractJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaCallJob
extends AbstractJob {
    private final String connectionString;
    private final String className;
    private final String methodName;
    private final String description;
    private final List<Object> parameters = new ArrayList<Object>();

    public JavaCallJob(String connection, String clsName, String methName, String desc, List<Object> params) {
        this.connectionString = connection;
        this.className = clsName;
        this.methodName = methName;
        this.description = desc;
        this.parameters.addAll(params);
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        DatabaseConnection connection = null;
        if (this.connectionString != null) {
            connection = new DatabaseConnection(this.connectionString);
            DBMTLogger.info(Channel.DEV, "Getting class for name " + this.className);
        }
        Class<?> callClass = Class.forName(this.className);
        DBMTLogger.info(Channel.DEV, "Creating instance of class " + this.className);
        Object obj = this.connectionString != null ? callClass.getConstructor(DatabaseConnection.class).newInstance(connection) : callClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        DBMTLogger.info(Channel.DEV, "Getting method " + this.methodName + " on class " + this.className);
        Method m = callClass.getMethod(this.methodName, this.getArgumentTypes());
        try {
            m.invoke(obj, this.getArgumentValues());
        }
        catch (InvocationTargetException e) {
            DBMTLogger.error(Channel.DEV, "Exception performing job", e.getTargetException());
            throw e;
        }
        return true;
    }

    private String argumentsToString(Object[] argumentValues) {
        StringBuffer sbuf = new StringBuffer();
        String prefix = "";
        for (Object o : argumentValues) {
            sbuf.append(prefix + (o != null ? o.toString() : "<NULL>"));
            prefix = ", ";
        }
        return sbuf.toString();
    }

    private Object[] getArgumentValues() {
        Object[] values = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            values[i] = this.parameters.get(i);
        }
        return values;
    }

    private Class<?>[] getArgumentTypes() {
        Class[] types = new Class[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            types[i] = this.parameters.get(i) != null ? this.parameters.get(i).getClass() : Object.class;
        }
        return types;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return true;
    }

    public String toString() {
        return StringLocalizer.get(this.description);
    }
}

