/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import com.primavera.database.tools.RetrieveExpCustomfieldInfoFromDatabase;
import com.primavera.database.tools.RetrieveExpCustomfieldInfoFromSampleDataZip;
import com.primavera.database.tools.dbmt.InvalidCustomColumnDatasourceException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.WorkflowStepJob;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.workflow.ExpeditionCSDFCustomColumnJob;
import com.primavera.database.tools.dbmt.workflow.ExpeditionGCDFCustomColumnJob;
import com.primavera.database.tools.dbmt.workflow.ScriptStringValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExpedtionCustomColumnJobFactory
implements ParameterizedJobFactory<WorkflowStepJob> {
    private final ScriptStringValue m_value;
    private final ConnectionClass m_connection;

    public ExpedtionCustomColumnJobFactory(ScriptStringValue value, ConnectionClass connection) {
        this.m_value = value;
        this.m_connection = connection;
    }

    @Override
    public WorkflowStepJob createJob(JobProperties props) throws ValueNotFound, ConnectionNotFoundException {
        try {
            String connectString = this.m_value.getValue(props.cloneJobProperties());
            ConnectStringParse parsedConnectionString = new ConnectStringParse(connectString);
            if (parsedConnectionString.getConnectionType() == DSType.DATABASE) {
                RetrieveExpCustomfieldInfoFromDatabase dbRetriever = new RetrieveExpCustomfieldInfoFromDatabase(connectString);
                return ExpedtionCustomColumnJobFactory.createJobFromRetrievers(dbRetriever.m_csdfRecordRetriever, dbRetriever.m_gcdfRecordRetriever, props.getConnection(this.m_connection));
            }
            if (parsedConnectionString.getConnectionType() == DSType.SAMPLE) {
                for (Map.Entry<Object, Object> entry : props.getJobPropertyEntries()) {
                    DBMTLogger.info(Channel.DEV, " ------- " + entry.getKey() + " = " + entry.getValue());
                }
                List schemaInfoList = (List)props.getJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
                if (schemaInfoList == null || schemaInfoList.isEmpty()) {
                    throw new JobPropertyNotFound(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
                }
                RetrieveExpCustomfieldInfoFromSampleDataZip retriever = new RetrieveExpCustomfieldInfoFromSampleDataZip(connectString, (SchemaInfo)schemaInfoList.get(0));
                return ExpedtionCustomColumnJobFactory.createJobFromRetrievers(retriever.m_csdfRecordRetriever, retriever.m_gcdfRecordRetriever, props.getConnection(this.m_connection));
            }
            throw new InvalidCustomColumnDatasourceException(connectString);
        }
        catch (ValueNotFound e) {
            throw e;
        }
        catch (ConnectionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static WorkflowStepJob createJobFromRetrievers(RetrieveExpCustomFieldInfo<CSDFRecord> csdfRecordRetriever, RetrieveExpCustomFieldInfo<GCDFRecord> gcdfRecordRetriever, String targetConnectString) {
        ArrayList<Job> jobList = new ArrayList<Job>();
        jobList.add(new ExpeditionCSDFCustomColumnJob(csdfRecordRetriever, targetConnectString));
        jobList.add(new ExpeditionGCDFCustomColumnJob(gcdfRecordRetriever, targetConnectString));
        return new WorkflowStepJob(StringLocalizer.get("dbmt.customcolumns.job.jobname"), null, jobList);
    }
}

