/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.util;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.UnknownProductSuiteException;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TablespaceUtil {
    public static Map<String, String> resetOracleTablespacesMap(DatabaseConnection connection) {
        TreeMap<String, String> oracleTablespaceMap = new TreeMap<String, String>();
        oracleTablespaceMap.clear();
        oracleTablespaceMap.putAll(OracleLogic.getTablespaceMap(connection));
        for (String tablespaceName : oracleTablespaceMap.keySet()) {
            StringLocalizer.setAsOwnTranslation(tablespaceName);
        }
        return oracleTablespaceMap;
    }

    public static Map<String, String> getAvailableTablespaces(String connectString) {
        HashMap<String, String> oracleTablespaceMap = new HashMap<String, String>();
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectString);
            oracleTablespaceMap.putAll(TablespaceUtil.resetOracleTablespacesMap(connection));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        return oracleTablespaceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getTemporaryTablespaces(String connectString) {
        HashSet<String> tablespaces = new HashSet<String>();
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectString);
            tablespaces.addAll(OracleLogic.getTemporaryTablespaces(conn));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        return tablespaces;
    }

    public static String getTablespaceBaseName(JobProperties jobProps) throws DBMTException, UnknownProductSuiteException {
        ProductSuiteType suiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
        if (suiteType == ProductSuiteType.PM) {
            String pmProduct = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY).toString();
            if (pmProduct.equals("MM")) {
                return "MMDB";
            }
            if (pmProduct.equals("PM")) {
                return "PMDB";
            }
            throw new RuntimeException(StringLocalizer.get("dbmt.action.error.setavailabletablespaces.unknownproduct.pm", new String[]{pmProduct.toString()}));
        }
        if (suiteType == ProductSuiteType.PPM) {
            String ppmProduct = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY).toString();
            if (ppmProduct.equals("PPM")) {
                return "PMDB";
            }
            throw new RuntimeException(StringLocalizer.get("dbmt.action.error.setavailabletablespaces.unknownproduct.pm", new String[]{ppmProduct.toString()}));
        }
        if (suiteType == ProductSuiteType.EXP) {
            return "EXP";
        }
        throw new UnknownProductSuiteException((Object)suiteType);
    }

    public static class TablespaceCreateInfo {
        private final Map<String, String> m_params = new HashMap<String, String>();

        public void addParam(String wizFieldName, String scriptParamName) {
            this.m_params.put(wizFieldName, scriptParamName);
        }
    }

    public static class TablespaceDefaultsInfo {
        private final Map<String, String> m_defaultTablespaceSuffixMap = new HashMap<String, String>();

        public void addTablespaceSuffix(String fieldId, String defaultName) {
            this.m_defaultTablespaceSuffixMap.put(fieldId, defaultName);
        }

        public Set<String> getTablespaceFields() {
            return this.m_defaultTablespaceSuffixMap.keySet();
        }

        public String getTablespaceSuffix(String fieldId) {
            String mappedValue = this.m_defaultTablespaceSuffixMap.get(fieldId);
            if (mappedValue != null) {
                return mappedValue;
            }
            return "";
        }
    }
}

