/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins;

import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import com.primavera.database.tools.dbmt.updatelogins.LoginTableDelta;
import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginsTableModel;
import com.primavera.database.tools.dbmt.updatelogins.ui.UnableToCreateConnectionFromConnectString;
import java.io.Console;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SilentDBConfiguration {
    private Properties keyValuePairs = null;
    public DatabaseConnection m_connection = null;
    private static final String FIELD_PASS = "PASS";
    private static final String FIELD_NAME = "NAME";
    private static final String FIELD_ID = "ID";
    private Console console = null;
    private static final String SQL_STMT_SELECT_FROM_PUBUSER = "SELECT public_group_id ID, private_db_user_name NAME, private_db_passwd PASS FROM PUBUSER";

    public SilentDBConfiguration(Properties keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    public void createConnection() throws Exception {
        String dbType = this.keyValuePairs.getProperty("dbtype").trim();
        if (StringUtils.equalsIgnoreCase((CharSequence)dbType, (CharSequence)"ORACLE")) {
            String url = null;
            if (this.keyValuePairs.containsKey("url")) {
                url = this.keyValuePairs.getProperty("url").trim();
            }
            String username = this.keyValuePairs.getProperty("username").trim();
            String password = this.keyValuePairs.getProperty("password").trim();
            if (StringUtils.isEmpty((CharSequence)url)) {
                String host = this.keyValuePairs.getProperty("host").trim();
                String port = this.keyValuePairs.getProperty("port").trim();
                String instance = this.keyValuePairs.getProperty("dbname").trim();
                String type = this.keyValuePairs.getProperty("type").trim();
                OracleServerInfo info = new OracleServerInfo(username, host, instance);
                info.setPort(Integer.parseInt(port));
                info.setDatabase(instance);
                info.setUsername(username);
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"SERVICE")) {
                    info.setService(true);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"SID")) {
                    info.setService(false);
                }
                String connectString = info.createConnectString(password);
                try {
                    this.m_connection = new DatabaseConnection(connectString);
                }
                catch (SQLException e) {
                    throw new Exception(new UnableToCreateConnectionFromConnectString(info.createConnectString("*********"), e).getLocalizedMessage());
                }
            } else {
                Properties properties = new Properties();
                properties.put("user", username);
                properties.put("password", password);
                this.m_connection = new DatabaseConnection();
                Class.forName("oracle.jdbc.OracleDriver");
                this.m_connection.setConnection(DriverManager.getConnection(url, properties), ServerType.ORACLE);
            }
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)dbType, (CharSequence)"ORACLEATP")) {
                String host = this.keyValuePairs.getProperty("host").trim();
                String username = this.keyValuePairs.getProperty("username").trim();
                String password = this.keyValuePairs.getProperty("password").trim();
                String instance = this.keyValuePairs.getProperty("dbname").trim();
                OracleServerInfo info = new OracleServerInfo(username, host, instance);
                info.setDatabase(instance);
                info.setUsername(username);
                String connectString = info.createATPConnectString(password);
                try {
                    this.m_connection = new DatabaseConnection(connectString);
                }
                catch (SQLException e) {
                    throw new Exception(new UnableToCreateConnectionFromConnectString(info.createConnectString("*********"), e).getLocalizedMessage());
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dbType, (CharSequence)"SQLSERVER")) {
                String host = this.keyValuePairs.getProperty("host").trim();
                String port = this.keyValuePairs.getProperty("port").trim();
                String username = this.keyValuePairs.getProperty("username").trim();
                String password = this.keyValuePairs.getProperty("password").trim();
                String database = this.keyValuePairs.getProperty("dbname").trim();
                MSSqlServerInfo info = new MSSqlServerInfo(database, host);
                info.setPort(Integer.parseInt(port));
                info.setDatabase(database);
                info.setUsername(username);
                String connectString = info.createConnectString(password);
                try {
                    this.m_connection = new DatabaseConnection(connectString);
                }
                catch (SQLException e) {
                    throw new Exception(new UnableToCreateConnectionFromConnectString(info.createConnectString("*********"), e).getLocalizedMessage());
                }
            }
        }
    }

    public void doDBOperation() {
        Set<String> keys = this.keyValuePairs.stringPropertyNames();
        ArrayList<String> commandKeyList = new ArrayList<String>();
        for (String key : keys) {
            if (!key.contains("command")) continue;
            commandKeyList.add(key);
        }
        Collections.sort(commandKeyList, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return Integer.parseInt(a.substring(7)) - Integer.parseInt(b.substring(7));
            }
        });
        for (String key : commandKeyList) {
            String parameters = this.keyValuePairs.getProperty(key);
            String[] parameterArray = parameters.split(" ");
            try {
                if (parameterArray.length <= 0) continue;
                if (parameterArray[0].equalsIgnoreCase("addUser")) {
                    this.addUser(parameterArray);
                    System.out.println("User added");
                    continue;
                }
                if (parameterArray[0].equalsIgnoreCase("listUser")) {
                    this.listUsers();
                    continue;
                }
                if (parameterArray[0].equalsIgnoreCase("updateUser")) {
                    this.updateUserName(parameterArray);
                    System.out.println("Username  updated");
                    continue;
                }
                if (parameterArray[0].equalsIgnoreCase("updatePassword")) {
                    this.updatePassword(parameterArray);
                    System.out.println("Password updated");
                    continue;
                }
                if (parameterArray[0].equalsIgnoreCase("updateP6UserPassword")) {
                    this.updateP6UserPassword(parameterArray);
                    System.out.println(String.format("P6 User Password updated for user '%s'", parameterArray[1]));
                    continue;
                }
                if (parameterArray[0].equalsIgnoreCase("updatePublicGroupId")) {
                    this.updatePublicGroupId(parameterArray);
                    System.out.println("Public Group Id updated");
                    continue;
                }
                if (!parameterArray[0].equalsIgnoreCase("deleteUser")) continue;
                this.deleteUser(parameterArray);
            }
            catch (Exception e) {
                System.out.println("Problem during processing command:" + e.getMessage());
            }
        }
    }

    private void listUsers() {
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        System.out.println("     Public Group Id                        Username");
        System.out.println("     ===============                        ========");
        System.out.println();
        for (PrivateDatabaseLoginsTableModel.Record user : userList) {
            System.out.println("     " + user.group_id + "                                      " + user.username);
        }
    }

    private void addUser(String[] parameterValues) throws Exception {
        if (parameterValues.length < 3) {
            throw new Exception("All parameter for the command adduser not given");
        }
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        PrivateDatabaseLoginsTableModel.Record userRecord = this.isNameAvailable(userList, parameterValues[1]);
        if (userRecord != null) {
            throw new Exception("Username not available");
        }
        String newpasswordArray = parameterValues[2];
        this.writeToDatabase(new LoginTableDelta.AddDelta(0, new PrivateDatabaseLoginsTableModel.Record(this.generateUniqueGroupId(userList), parameterValues[1], EntryPoint.b((String)newpasswordArray))));
    }

    private void updateUserName(String[] parameterValues) throws Exception {
        if (parameterValues.length < 3) {
            throw new Exception("All parameter for the command updateusername are not given");
        }
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        PrivateDatabaseLoginsTableModel.Record userRecord = this.isNameAvailable(userList, parameterValues[1]);
        if (userRecord == null) {
            throw new Exception("User does not exist");
        }
        PrivateDatabaseLoginsTableModel.Record newUserRecord = this.isNameAvailable(userList, parameterValues[2]);
        if (newUserRecord != null) {
            throw new Exception("User already exists. Please choose different username.");
        }
        this.writeToDatabase(new LoginTableDelta.AlterUsername(0, userRecord.group_id, userRecord.username, parameterValues[2]));
    }

    private void updatePassword(String[] parameterValues) throws Exception {
        if (parameterValues.length < 3) {
            throw new Exception("All parameter for the command updatepassword are not given");
        }
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        PrivateDatabaseLoginsTableModel.Record rec = this.isNameAvailable(userList, parameterValues[1]);
        if (rec == null) {
            throw new Exception("User does not exist");
        }
        this.writeToDatabase(new LoginTableDelta.AlterPassword(0, rec.group_id, rec.password, EntryPoint.b((String)parameterValues[2])));
    }

    private boolean updateP6UserPassword(String[] parameterValues) throws Exception {
        if (parameterValues.length < 3) {
            throw new Exception("Missing required paremeters for UpdateP6UserPassword. Usage: command=UpdateP6UserPassword <username> <newPassword>");
        }
        String username = parameterValues[1];
        String newPasswd = parameterValues[2];
        String hash = EntryPoint.e((String)newPasswd);
        Connection connection = this.m_connection.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement("update users set passwd=? where user_name=?");){
            stmt.setString(1, hash);
            stmt.setString(2, username);
            int numRecordsUpdated = stmt.executeUpdate();
            if (numRecordsUpdated == 0) {
                throw new Exception(String.format("Error updating P6 User password: User %s was not found in USERS table", username));
            }
            if (!connection.getAutoCommit()) {
                if (numRecordsUpdated == 1) {
                    connection.commit();
                } else {
                    connection.rollback();
                    throw new Exception(String.format("ERROR: more than one P6 user found with name %s, unable to update password", username));
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private void updatePublicGroupId(String[] parameterValues) throws Exception {
        if (parameterValues.length < 3) {
            throw new Exception("All parameter for the command updatepublicgroupid are not given");
        }
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        PrivateDatabaseLoginsTableModel.Record rec = this.checkUserForGroupId(userList, parameterValues[1]);
        if (rec == null) {
            throw new Exception("User doesnot exist with given public group id.");
        }
        System.out.println("Public Group Id: " + rec.group_id + " User Name: " + rec.username);
        PrivateDatabaseLoginsTableModel.Record newrec = this.checkUserForGroupId(userList, parameterValues[2]);
        if (newrec != null) {
            throw new Exception("Group Id already exists");
        }
        this.writeToDatabase(new LoginTableDelta.AlterGroupId(0, rec.group_id, Integer.parseInt(parameterValues[2])));
    }

    private void deleteUser(String[] parameterValues) throws Exception {
        if (parameterValues.length < 2) {
            throw new Exception("All parameter for the command deleteuser not given");
        }
        List<PrivateDatabaseLoginsTableModel.Record> userList = this.getUser();
        PrivateDatabaseLoginsTableModel.Record userRecord = this.isNameAvailable(userList, parameterValues[1]);
        if (userRecord == null) {
            throw new Exception("User does not exist.");
        }
        this.writeToDatabase(new LoginTableDelta.DeleteDelta(0, userRecord));
        System.out.println("User deleted");
    }

    public void writeToDatabase(LoginTableDelta delta) throws Exception {
        String sql = delta.asSql();
        try (PreparedStatement stmt = this.m_connection.getConnection().prepareStatement(sql);){
            delta.setParametersIntoStatement(stmt);
            stmt.execute();
            Connection connection = this.m_connection.getConnection();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.m_connection.getConnection().rollback();
        }
    }

    public List<PrivateDatabaseLoginsTableModel.Record> getUser() {
        ArrayList<PrivateDatabaseLoginsTableModel.Record> recordList = new ArrayList<PrivateDatabaseLoginsTableModel.Record>();
        try (PreparedStatement stmt = this.m_connection.getConnection().prepareStatement(SQL_STMT_SELECT_FROM_PUBUSER);
             ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                recordList.add(new PrivateDatabaseLoginsTableModel.Record(result.getInt(FIELD_ID), result.getString(FIELD_NAME), result.getString(FIELD_PASS)));
            }
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        return recordList;
    }

    private PrivateDatabaseLoginsTableModel.Record isNameAvailable(List<PrivateDatabaseLoginsTableModel.Record> userList, String userName) {
        PrivateDatabaseLoginsTableModel.Record r = null;
        for (PrivateDatabaseLoginsTableModel.Record rec : userList) {
            if (!StringUtils.equals((CharSequence)rec.username, (CharSequence)userName)) continue;
            r = rec;
            break;
        }
        return r;
    }

    private PrivateDatabaseLoginsTableModel.Record checkUserForGroupId(List<PrivateDatabaseLoginsTableModel.Record> recordList, String groupId) {
        PrivateDatabaseLoginsTableModel.Record rec = null;
        for (PrivateDatabaseLoginsTableModel.Record r : recordList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(r.group_id), (CharSequence)groupId)) continue;
            rec = r;
            break;
        }
        return rec;
    }

    private int generateUniqueGroupId(List<PrivateDatabaseLoginsTableModel.Record> userList) {
        HashSet<Integer> usedIds = new HashSet<Integer>();
        for (PrivateDatabaseLoginsTableModel.Record r : userList) {
            usedIds.add(r.group_id);
        }
        int newId = 1;
        while (usedIds.contains(newId)) {
            ++newId;
        }
        return newId;
    }

    public String readInput(String msg) {
        if (this.console == null) {
            this.console = System.console();
        }
        return this.console.readLine(msg, new Object[0]);
    }

    public char[] readPassword(String msg) {
        if (this.console == null) {
            this.console = System.console();
        }
        return this.console.readPassword(msg, new Object[0]);
    }
}

