/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.schemaval;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.osutils.BrowserLaunch;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderEvent;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderListener;
import com.primavera.database.tools.SchemaValidation.SchemaValidation;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationImpl;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.Main;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RunSchemaVal
extends SchemaValidation {
    private static RunSchemaVal m_runSchemaVal;

    public static RunSchemaVal getRunSchemaVal() {
        if (m_runSchemaVal == null) {
            m_runSchemaVal = new RunSchemaVal();
        }
        return m_runSchemaVal;
    }

    public void runTransform() throws DatabaseToolException {
        ApplicationSchemaInfoResolver resolver = new ApplicationSchemaInfoResolver(this.getSuite());
        File sourceFile = new File(COMPARE_TEMP_FILE);
        try {
            this.setSourceURL(sourceFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        try {
            this.run(resolver);
        }
        catch (DBMTException e) {
            throw new DatabaseToolException(e.getLocalizedMessage(), e);
        }
    }

    public void runTransformForMigration() throws DatabaseToolException {
        ApplicationSchemaInfoResolver resolver = new ApplicationSchemaInfoResolver(this.getSuite());
        File sourceFile = new File(COMPARE_TEMP_FILE);
        try {
            this.setSourceURL(sourceFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        try {
            this.runForMigration(resolver);
        }
        catch (DBMTException e) {
            throw new DatabaseToolException(e.getLocalizedMessage(), e);
        }
    }

    public void saveToFile(String filename) throws DatabaseToolException {
        Document result = (Document)this.getHTMLReport().getNode();
        this.docToFile(result, new File(filename));
    }

    public void launchReport() throws IOException, DatabaseToolException {
        Document result = (Document)this.getHTMLReport().getNode();
        this.docToFile(result, new File(REPORT_FILE));
        BrowserLaunch.launch(REPORT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException, IOException, DatabaseToolException {
        try (DatabaseConnection conn = new DatabaseConnection("admuser/admuser@oracle:bala-olympia.us.oracle.com:1521:olympia1");){
            SchemaValidation sv = new SchemaValidation();
            sv.setConnection(conn);
            SchemaBuilderListener listener = new SchemaBuilderListener(){

                @Override
                public void schemaBuilderBegin(SchemaBuilderEvent event) {
                    System.out.println("BEGIN");
                }

                @Override
                public void schemaBuilderComplete(SchemaBuilderEvent event) {
                }

                @Override
                public void schemaBuilderError(SchemaBuilderEvent event) {
                }

                @Override
                public void tableBegin(SchemaBuilderEvent event) {
                }

                @Override
                public void tableComplete(SchemaBuilderEvent event) {
                    System.out.println(event.getTableName() + ": " + String.valueOf(event.getProcessedTables()) + " out of " + String.valueOf(event.getTotalTables()));
                }
            };
            sv.setBuildListener(listener);
            File sourceFile = new File("c:\\temp\\or_pmitval.xml");
            if (!sourceFile.exists()) {
                System.out.println("file " + sourceFile.getPath() + " does not exist");
                System.exit(1);
            }
            System.out.println("source: " + sourceFile.toURI().toURL());
            File targetFile = new File("c:\\temp\\pmSchema.xml");
            if (!targetFile.exists()) {
                System.out.println("file " + targetFile.getPath() + " does not exist");
                System.exit(1);
            }
            ApplicationSchemaInfoResolver resolver = new ApplicationSchemaInfoResolver(ProductSuiteType.PM);
            try {
                sv.run(resolver);
            }
            catch (DBMTException e) {
                throw new DatabaseToolException(e.getLocalizedMessage(), e);
            }
            Document result = (Document)sv.getHTMLReport().getNode();
            sv.docToFile(result, new File("c:\\temp\\sv_report.html"));
        }
    }

    private static class ApplicationSchemaInfoResolver
    implements SchemaValidation.SchemaInfoRetriever {
        private Application app;
        private ProductSuiteType m_suite = ProductSuiteType.PM;

        public ApplicationSchemaInfoResolver(ProductSuiteType suite) {
            this.app = ApplicationImpl.createApplication();
            this.m_suite = suite;
            Main.findAndAddSchemaJarsToClassPath(this.app);
        }

        ProductInfo getCurrentProductInfo(ProductSuiteType ptype) {
            List<ProductInfo> productList = this.app.getSuiteInfo(ptype);
            ProductInfo returnInfo = null;
            for (ProductInfo pinfo : productList) {
                if (returnInfo != null && returnInfo.getVersion().compareTo(pinfo.getVersion()) >= 0) continue;
                returnInfo = pinfo;
            }
            return returnInfo;
        }

        public String getBuildVersion(String schemaFile, String version) throws XPathException, ParserConfigurationException, SAXException, IOException {
            String versionHistoryPathString;
            InputSource in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(schemaFile)));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(versionHistoryPathString = "/PrimaveraDatabaseSchema/HISTORY[@VERSION='" + version + "']");
            Node currentVersionResult = (Node)expr.evaluate(in, XPathConstants.NODE);
            if (currentVersionResult.getAttributes().getNamedItem("BUILD_VERSION_ID") != null) {
                return currentVersionResult.getAttributes().getNamedItem("BUILD_VERSION_ID").getNodeValue();
            }
            in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(schemaFile)));
            String rootPathString = "/PrimaveraDatabaseSchema";
            expr = xpath.compile(rootPathString);
            Node rootPathResult = (Node)expr.evaluate(in, XPathConstants.NODE);
            String currentVersion = rootPathResult.getAttributes().getNamedItem("VERSION").getNodeValue();
            in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(schemaFile)));
            versionHistoryPathString = "/PrimaveraDatabaseSchema/HISTORY[@VERSION='" + currentVersion + "']";
            expr = xpath.compile(versionHistoryPathString);
            currentVersionResult = (Node)expr.evaluate(in, XPathConstants.NODE);
            return currentVersionResult.getAttributes().getNamedItem("BUILD_VERSION_ID").getNodeValue();
        }

        @Override
        public SchemaInfo loadSchemaInfo(DatabaseConnection conn) throws DBMTException {
            SchemaType type = null;
            try {
                type = conn.getServerType() == ServerType.ORACLE ? OracleLogic.getSchemaType(conn, this.m_suite) : SqlServerLogic.getSchemaType(conn, this.m_suite);
            }
            catch (SchemaTypeNotFoundError e) {
                e.printStackTrace();
            }
            String versionQuery = SchemaInfoImpl.getVersionQuery(conn.getServerType(), type);
            ProductInfo pinfo = this.getCurrentProductInfo(this.m_suite);
            SchemaInfo info = null;
            for (SchemaInfo schemaInfo : pinfo.getAllSchemas()) {
                if (schemaInfo.getSchemaType() != type) continue;
                info = schemaInfo;
                break;
            }
            String schemaFile = SchemaJarUtil.getResource(info, "install", SchemaJarUtil.getSchemaSpecFilename(info));
            String version = null;
            PreparedStatement stmt = null;
            try {
                stmt = conn.getConnection().prepareStatement(versionQuery);
                stmt.execute();
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    version = resultSet.getString("VERSION");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            String buildVersion = null;
            try {
                buildVersion = this.getBuildVersion(schemaFile, version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String jarFileName = "DBS_" + buildVersion + ".jar";
            return SchemaInfoImpl.createFromFileName(jarFileName);
        }

        @Override
        public SchemaInfo loadSchemaInfoForMigration(DatabaseConnection conn) throws DBMTException {
            SchemaType type = null;
            String versionQuery = "";
            try {
                if (conn.getServerType() == ServerType.ORACLE) {
                    type = OracleLogic.getSchemaType(conn, this.m_suite);
                    versionQuery = "select substr( database_version, instr(database_version, ',',1)+1, 100 ) VERSION from prefer";
                } else {
                    type = SqlServerLogic.getSchemaType(conn, this.m_suite);
                    versionQuery = "select substring( database_version, charindex(',',database_version, 1) + 1, 100 ) VERSION from prefer";
                }
            }
            catch (SchemaTypeNotFoundError e) {
                e.printStackTrace();
            }
            ProductInfo pinfo = this.getCurrentProductInfo(this.m_suite);
            SchemaInfo info = null;
            if (type == SchemaType.PM) {
                for (SchemaInfo schemaInfo : pinfo.getAllSchemas()) {
                    if (schemaInfo.getSchemaType() != SchemaType.PPM) continue;
                    info = schemaInfo;
                    break;
                }
            } else if (type == SchemaType.PPM) {
                for (SchemaInfo schemaInfo : pinfo.getAllSchemas()) {
                    if (schemaInfo.getSchemaType() != SchemaType.PM) continue;
                    info = schemaInfo;
                    break;
                }
            }
            String schemaFile = SchemaJarUtil.getResourceForMigration(info, "migrate", SchemaJarUtil.getSchemaSpecFilename(info), "changeFilename");
            String version = null;
            PreparedStatement stmt = null;
            try {
                stmt = conn.getConnection().prepareStatement(versionQuery);
                stmt.execute();
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    version = resultSet.getString("VERSION");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            String buildVersion = null;
            try {
                buildVersion = this.getBuildVersion(schemaFile, version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (buildVersion.startsWith("PPM_")) {
                buildVersion = buildVersion.replace("PPM_", "PM_");
            } else if (buildVersion.startsWith("PM_")) {
                buildVersion = buildVersion.replace("PM_", "PPM_");
            }
            String jarFileName = "DBS_" + buildVersion + ".jar";
            return SchemaInfoImpl.createFromFileNameForMigration(jarFileName);
        }
    }
}

