/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SelectComponentBinding
extends ComponentBinding {
    private final List<String> m_ids = new ArrayList<String>();
    private final JComboBox m_combo = new JComboBox();

    public SelectComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        SelectTypeDef selectTypeDef = (SelectTypeDef)this.getData().getDef().get(this.getFieldId()).getTypeDef();
        List<EnumDataEntry> enumValues = selectTypeDef.getValues();
        for (EnumDataEntry enumValue : enumValues) {
            this.m_combo.addItem(StringLocalizer.get(enumValue.getNameKey()));
            this.m_ids.add(enumValue.getId());
        }
        this.m_combo.setToolTipText(data.getDesc(fieldId));
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        this.m_combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.onValueChanged(SelectComponentBinding.this.getFieldId());
            }
        });
    }

    @Override
    public String getComponentData() {
        return this.m_ids.get(this.m_combo.getSelectedIndex());
    }

    @Override
    public JComponent[] getComponents() {
        return new JComboBox[]{this.m_combo};
    }

    @Override
    public void setComponentData(String dataString) {
        int selectedIndex = this.m_combo.getItemCount();
        String selectedButton = dataString;
        for (int i = 0; i < this.m_combo.getItemCount(); ++i) {
            if (!selectedButton.equals(this.m_ids.get(i))) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex < this.m_combo.getItemCount()) {
            this.m_combo.setSelectedIndex(selectedIndex);
        }
    }
}

