/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.job.Job;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class JobTreeRenderer
implements TreeCellRenderer {
    private static final String IMAGE_NAME_BASE = "JobTreeBackground";
    private static Map<CommitPageDataDef.JobStatus, ImageIcon> s_backgroundMap = new HashMap<CommitPageDataDef.JobStatus, ImageIcon>();
    private final Map<TreeNode<Job>, CommitPageDataDef.JobStatus> m_jobStatusMap;
    private final Map<Object, Renderer> m_panelMap = new HashMap<Object, Renderer>();

    public JobTreeRenderer(Map<TreeNode<Job>, CommitPageDataDef.JobStatus> jobStatusMap) {
        this.m_jobStatusMap = jobStatusMap;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree arg0, Object arg1, boolean arg2, boolean arg3, boolean arg4, int arg5, boolean arg6) {
        Renderer renderer = null;
        renderer = this.getRenderer(arg1);
        renderer.setText(arg1.toString());
        CommitPageDataDef.JobStatus status = null;
        status = this.getStatus(arg1);
        renderer.setIcon(this.getJobIcon(status));
        return renderer.getPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Renderer getRenderer(Object obj) {
        Renderer renderer = null;
        Map<Object, Renderer> map = this.m_panelMap;
        synchronized (map) {
            renderer = this.m_panelMap.get(obj);
            if (renderer != null) {
                return renderer;
            }
        }
        renderer = new Renderer();
        map = this.m_panelMap;
        synchronized (map) {
            this.m_panelMap.put(obj, renderer);
        }
        return renderer;
    }

    private Icon getJobIcon(CommitPageDataDef.JobStatus status) {
        ImageIcon background = JobTreeRenderer.getJobIconBackground(status);
        return background;
    }

    private static synchronized ImageIcon getJobIconBackground(CommitPageDataDef.JobStatus status) {
        ImageIcon image = s_backgroundMap.get((Object)status);
        if (image == null) {
            String imageName = "JobTreeBackground_" + status.toString() + ".png";
            image = new ImageIcon(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/" + imageName));
            s_backgroundMap.put(status, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitPageDataDef.JobStatus getStatus(Object arg1) {
        Map<TreeNode<Job>, CommitPageDataDef.JobStatus> map = this.m_jobStatusMap;
        synchronized (map) {
            return this.m_jobStatusMap.get(arg1);
        }
    }

    private class Renderer {
        private final JPanel m_panel = new JPanel();
        private final JLabel m_iconLabel = new JLabel();
        private final JLabel m_textLabel = new JLabel();

        public Renderer() {
            this.m_panel.setLayout(new BorderLayout());
            this.m_textLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.m_panel.add((Component)this.m_iconLabel, "West");
            this.m_panel.add((Component)this.m_textLabel, "Center");
        }

        public void setIcon(Icon icon) {
            this.m_iconLabel.setIcon(icon);
        }

        public void setText(String text) {
            this.m_textLabel.setText(text);
        }

        public JPanel getPanel() {
            return this.m_panel;
        }
    }
}

