/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.model;

import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationAdaptor;
import com.primavera.database.tools.dbmt.ApplicationEventSource;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.OpConsoleInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ConnectionTreeModel
extends ApplicationAdaptor
implements TreeModel {
    public static final Object ROOT = new Object(){

        public String toString() {
            return "ALL SERVERS";
        }
    };
    private static Comparator<ServerInfo> s_connectionComparator;
    private static Comparator<DatabaseInfo> s_databaseCompare;
    private static Comparator<OpConsoleInfo> s_opConsoleCompare;
    private static final TreeEventInformer s_nodesChanged;
    private static final TreeEventInformer s_nodesInserted;
    private static TreeEventInformer s_nodesRemoved;
    private static TreeEventInformer s_structureChanged;
    private static final ListAlterLogic<ServerInfo> s_addServerLogic;
    private static final ListAlterLogic<ServerInfo> s_delServerLogic;
    private Application m_app;
    private Application m_connections;
    private Collection<TreeModelListener> m_listeners = new HashSet<TreeModelListener>();
    private List<ServerInfo> m_servers = new ArrayList<ServerInfo>();
    private Map<ServerInfo, List<DatabaseInfo>> m_databases = new HashMap<ServerInfo, List<DatabaseInfo>>();

    public ConnectionTreeModel() {
        s_connectionComparator = new Comparator<ServerInfo>(){

            @Override
            public int compare(ServerInfo o1, ServerInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        s_databaseCompare = new Comparator<DatabaseInfo>(){

            @Override
            public int compare(DatabaseInfo o1, DatabaseInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }

    protected ConnectionTreeModel(Application app, ApplicationEventSource eventSource) {
        s_connectionComparator = new /* invalid duplicate definition of identical inner class */;
        s_databaseCompare = new /* invalid duplicate definition of identical inner class */;
    }

    protected void connect(Application app) {
        this.m_connections = app;
        app.addApplicationListener(this);
        this.resetState();
    }

    protected void resetState() {
        this.refreshServers();
        for (ServerInfo server : this.m_servers) {
            this.refreshDatabases(server);
        }
        this.informStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT}));
    }

    protected void disconnect(Application app) {
        this.m_connections = null;
        app.removeApplicationListener(this);
    }

    public synchronized void setApplication(Application app) {
        if (this.m_app != null) {
            this.disconnect(this.m_app);
        }
        this.m_app = null;
        if (app == null) {
            return;
        }
        this.m_app = app;
        this.connect(this.m_app);
        this.resetState();
    }

    @Override
    public void databasesAdded(Collection<DatabaseInfo> databases) {
        HashMap newDatabaseMap = new HashMap();
        for (DatabaseInfo databaseInfo : databases) {
            if (!newDatabaseMap.containsKey(databaseInfo.getServer())) {
                newDatabaseMap.put(databaseInfo.getServer(), new ArrayList());
            }
            ((Collection)newDatabaseMap.get(databaseInfo.getServer())).add(databaseInfo);
        }
        for (Map.Entry entry : newDatabaseMap.entrySet()) {
            ArrayList<DatabaseInfo> databaseListBefore = new ArrayList<DatabaseInfo>();
            if (this.m_databases.get(entry.getKey()) != null) {
                databaseListBefore.addAll((Collection)this.m_databases.get(entry.getKey()));
            }
            this.refreshDatabases((ServerInfo)entry.getKey());
            TreeModelEvent event = this.createDatabaseInsertOrDeleteEvent((ServerInfo)entry.getKey(), databaseListBefore, this.m_databases.get(entry.getKey()));
            for (TreeModelListener listener : this.m_listeners) {
                listener.treeNodesInserted(event);
            }
        }
    }

    @Override
    public void databasesDeleted(Collection<DatabaseInfo> databases) {
        HashMap newDatabaseMap = new HashMap();
        for (DatabaseInfo databaseInfo : databases) {
            if (!newDatabaseMap.containsKey(databaseInfo.getServer())) {
                newDatabaseMap.put(databaseInfo.getServer(), new ArrayList());
            }
            ((Collection)newDatabaseMap.get(databaseInfo.getServer())).remove(databaseInfo);
        }
        for (Map.Entry entry : newDatabaseMap.entrySet()) {
            ArrayList<DatabaseInfo> databaseListBefore = new ArrayList<DatabaseInfo>();
            if (this.m_databases.get(entry.getKey()) != null) {
                databaseListBefore.addAll((Collection)this.m_databases.get(entry.getKey()));
            }
            this.refreshDatabases((ServerInfo)entry.getKey());
            TreeModelEvent event = this.createDatabaseInsertOrDeleteEvent((ServerInfo)entry.getKey(), this.m_databases.get(entry.getKey()), databaseListBefore);
            for (TreeModelListener listener : this.m_listeners) {
                listener.treeNodesRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTreeModelListener(TreeModelListener l) {
        Collection<TreeModelListener> collection = this.m_listeners;
        synchronized (collection) {
            if (!this.m_listeners.contains(l)) {
                this.m_listeners.add(l);
            }
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == ROOT) {
            if (index < this.m_servers.size()) {
                return this.m_servers.get(index);
            }
            return null;
        }
        if (parent instanceof ServerInfo) {
            List<DatabaseInfo> databases = this.m_databases.get(parent);
            if (databases == null || index >= databases.size()) {
                return null;
            }
            return databases.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.m_servers.size();
        }
        if (parent instanceof ServerInfo) {
            ServerInfo server = (ServerInfo)parent;
            Collection databases = this.m_databases.get(server);
            if (databases == null) {
                return 0;
            }
            return databases.size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == ROOT && child instanceof ServerInfo) {
            for (int i = 0; i < this.m_servers.size(); ++i) {
                if (!this.m_servers.get(i).equals(child)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ServerInfo) {
            ServerInfo server = (ServerInfo)node;
            return !server.isConnected();
        }
        return node instanceof DatabaseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        Collection<TreeModelListener> collection = this.m_listeners;
        synchronized (collection) {
            this.m_listeners.remove(l);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public Collection<TreeModelListener> getListeners() {
        return this.m_listeners;
    }

    public void setListeners(Collection<TreeModelListener> listeners) {
        this.m_listeners = listeners;
    }

    public static synchronized Comparator<ServerInfo> getConnectionComparator() {
        return s_connectionComparator;
    }

    public static synchronized void setConnectionComparator(Comparator<ServerInfo> connectionComparator) {
        s_connectionComparator = connectionComparator;
    }

    public static synchronized Comparator<DatabaseInfo> getDatabaseCompare() {
        return s_databaseCompare;
    }

    public static synchronized void setDatabaseCompare(Comparator<DatabaseInfo> databaseCompare) {
        s_databaseCompare = databaseCompare;
    }

    public static synchronized Comparator<OpConsoleInfo> getOpConsoleCompare() {
        return s_opConsoleCompare;
    }

    public static synchronized void setOpConsoleCompare(Comparator<OpConsoleInfo> opConsoleCompare) {
        s_opConsoleCompare = opConsoleCompare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informTree(TreeModelEvent event, TreeEventInformer informer) {
        ArrayList<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
        Object object = this.m_listeners;
        synchronized (object) {
            listeners.addAll(this.m_listeners);
        }
        object = listeners.iterator();
        while (object.hasNext()) {
            TreeModelListener l;
            TreeModelListener treeModelListener = l = (TreeModelListener)object.next();
            synchronized (treeModelListener) {
                informer.informTreeListener(l, event);
            }
        }
    }

    public final void informNodeValueChanged(TreeModelEvent event) {
        this.informTree(event, s_nodesChanged);
    }

    public final void informNodesInserted(TreeModelEvent event) {
        this.informTree(event, s_nodesInserted);
    }

    public final void informNodesRemoved(TreeModelEvent event) {
        this.informTree(event, s_nodesRemoved);
    }

    public final void informStructureChanged(TreeModelEvent event) {
        this.informTree(event, s_structureChanged);
    }

    private synchronized void serverListAltered(Collection<ServerInfo> servers, ListAlterLogic<ServerInfo> logic) {
        ArrayList serverListBefore = new ArrayList();
        logic.modifyCollection(serverListBefore, this.m_servers);
        this.refreshServers();
        TreeModelEvent event = logic.createEvent(this, serverListBefore, this.m_servers);
        for (TreeModelListener listener : this.m_listeners) {
            logic.informListeners(listener, event);
        }
    }

    @Override
    public synchronized void serversAdded(Collection<ServerInfo> servers) {
        this.serverListAltered(servers, s_addServerLogic);
    }

    @Override
    public synchronized void serversDeleted(Collection<ServerInfo> servers) {
        this.serverListAltered(servers, s_delServerLogic);
    }

    TreeModelEvent createEvent(ServerInfo server) {
        return new TreeModelEvent((Object)this, new Object[]{ROOT});
    }

    TreeModelEvent createDatabaseInsertOrDeleteEvent(ServerInfo server, List<DatabaseInfo> databasesBefore, List<DatabaseInfo> databasesAfter) {
        ArrayList<DatabaseInfo> addedDatabases = new ArrayList<DatabaseInfo>();
        ArrayList<Integer> addedIndices = new ArrayList<Integer>();
        for (int i = 0; i < databasesAfter.size(); ++i) {
            if (databasesBefore.contains(databasesAfter.get(i))) continue;
            addedDatabases.add(databasesAfter.get(i));
            addedIndices.add(i);
        }
        int[] arrayIndices = new int[addedIndices.size()];
        for (int i = 0; i < arrayIndices.length; ++i) {
            arrayIndices[i] = (Integer)addedIndices.get(i);
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{ROOT, server}, arrayIndices, (Object[])addedDatabases.toArray(new DatabaseInfo[0]));
        return event;
    }

    private static TreeModelEvent createServerInsertionOrDeletionEvent(Object source, List<ServerInfo> serversBefore, List<ServerInfo> serversAfter) {
        ArrayList<ServerInfo> addedServers = new ArrayList<ServerInfo>();
        ArrayList<Integer> addedIndices = new ArrayList<Integer>();
        for (int i = 0; i < serversAfter.size(); ++i) {
            if (serversBefore.contains(serversAfter.get(i))) continue;
            addedServers.add(serversAfter.get(i));
            addedIndices.add(i);
        }
        int[] arrayIndices = new int[addedIndices.size()];
        for (int i = 0; i < arrayIndices.length; ++i) {
            arrayIndices[i] = (Integer)addedIndices.get(i);
        }
        TreeModelEvent event = new TreeModelEvent(source, new Object[]{ROOT}, arrayIndices, (Object[])addedServers.toArray(new ServerInfo[0]));
        return event;
    }

    private synchronized void refreshServers() {
        this.m_servers.clear();
        ArrayList<ServerInfo> serverCollection = new ArrayList<ServerInfo>();
        for (ServerInfo server : this.m_connections.getConnections()) {
            serverCollection.add(server);
        }
        ServerInfo[] serverArray = serverCollection.toArray(new ServerInfo[0]);
        Arrays.sort(serverArray, ConnectionTreeModel.getConnectionComparator());
        for (int i = 0; i < serverArray.length; ++i) {
            this.m_servers.add(serverArray[i]);
        }
    }

    private synchronized void refreshDatabases(ServerInfo server) {
        if (!this.m_databases.containsKey(server)) {
            this.m_databases.put(server, new ArrayList());
        }
        ArrayList<DatabaseInfo> databaseCollection = new ArrayList<DatabaseInfo>();
        Iterable<DatabaseInfo> dabaseIterable = this.m_app.getDatabases(server);
        for (DatabaseInfo database : dabaseIterable) {
            databaseCollection.add(database);
        }
        DatabaseInfo[] databaseArray = databaseCollection.toArray(new DatabaseInfo[0]);
        Arrays.sort(databaseArray, ConnectionTreeModel.getDatabaseCompare());
        this.m_databases.get(server).clear();
        for (int j = 0; j < databaseArray.length; ++j) {
            this.m_databases.get(server).add(databaseArray[j]);
        }
    }

    static {
        s_nodesChanged = new TreeEventInformer(){

            @Override
            public void informTreeListener(TreeModelListener listener, TreeModelEvent event) {
                listener.treeNodesChanged(event);
            }
        };
        s_nodesInserted = new TreeEventInformer(){

            @Override
            public void informTreeListener(TreeModelListener listener, TreeModelEvent event) {
                listener.treeNodesInserted(event);
            }
        };
        s_nodesRemoved = new TreeEventInformer(){

            @Override
            public void informTreeListener(TreeModelListener listener, TreeModelEvent event) {
                listener.treeNodesRemoved(event);
            }
        };
        s_structureChanged = new TreeEventInformer(){

            @Override
            public void informTreeListener(TreeModelListener listener, TreeModelEvent event) {
                listener.treeStructureChanged(event);
            }
        };
        s_addServerLogic = new ListAlterLogic<ServerInfo>(){

            @Override
            public void informListeners(TreeModelListener listener, TreeModelEvent event) {
                listener.treeNodesInserted(event);
            }

            @Override
            public void modifyCollection(Collection<ServerInfo> baseCollection, Collection<ServerInfo> modificationParam) {
                baseCollection.addAll(modificationParam);
            }

            @Override
            public TreeModelEvent createEvent(Object source, List<ServerInfo> beforeList, List<ServerInfo> afterList) {
                return ConnectionTreeModel.createServerInsertionOrDeletionEvent(source, beforeList, afterList);
            }
        };
        s_delServerLogic = new ListAlterLogic<ServerInfo>(){

            @Override
            public void informListeners(TreeModelListener listener, TreeModelEvent event) {
                listener.treeNodesRemoved(event);
            }

            @Override
            public void modifyCollection(Collection<ServerInfo> baseCollection, Collection<ServerInfo> modificationParam) {
                baseCollection.addAll(modificationParam);
            }

            @Override
            public TreeModelEvent createEvent(Object source, List<ServerInfo> beforeList, List<ServerInfo> afterList) {
                return ConnectionTreeModel.createServerInsertionOrDeletionEvent(source, afterList, beforeList);
            }
        };
    }

    private static interface TreeEventInformer {
        public void informTreeListener(TreeModelListener var1, TreeModelEvent var2);
    }

    private static interface ListAlterLogic<T> {
        public void modifyCollection(Collection<T> var1, Collection<T> var2);

        public void informListeners(TreeModelListener var1, TreeModelEvent var2);

        public TreeModelEvent createEvent(Object var1, List<T> var2, List<T> var3);
    }
}

