/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationRunner;
import com.primavera.database.tools.dbmt.actions.DialogRunnerFactory;
import com.primavera.database.tools.dbmt.actions.WizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.InitializationException;
import com.primavera.database.tools.dbmt.gui.ApplicationUI;
import com.primavera.database.tools.dbmt.gui.ApplicationUIWizardRunnerFactory;
import com.primavera.database.tools.dbmt.gui.DefaultGuiDialogRunnerFactory;
import com.primavera.database.tools.dbmt.gui.util.LookAndFeelUtil;

public class GuiApplicationRunner
implements ApplicationRunner {
    private final ApplicationUI m_ui = ApplicationUI.inst();

    @Override
    public void initializeLogging() {
        DBMTLogger.addAppender(DBMTLogger.CONSOLE_APPENDER);
        DBMTLogger.addChannel(Channel.DEV);
        DBMTLogger.addChannel(Channel.USER);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.CONSOLE_APPENDER, DBMTLogger.LogLevel.WARN);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.CONSOLE_APPENDER, DBMTLogger.LogLevel.WARN);
    }

    @Override
    public void processCmdLineParameters(String[] args) {
    }

    @Override
    public void initialize(Application app) throws InitializationException {
    }

    @Override
    public void start(Application app) {
        this.m_ui.setApplication(app);
        LookAndFeelUtil.setLookAndFeelAndUIDefaults();
        this.m_ui.show();
    }

    @Override
    public DialogRunnerFactory createDialogRunnerFactory() {
        return new DefaultGuiDialogRunnerFactory();
    }

    @Override
    public WizardRunnerFactory createWizardRunnerFactory() {
        return new ApplicationUIWizardRunnerFactory(this.m_ui);
    }
}

