/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.tools.dbmt.actions.DialogNavigationAction;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.ApplicationUI;
import com.primavera.database.tools.dbmt.gui.GuiDialogRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DefaultGuiDialogRunner
extends GuiDialogRunner {
    private static final String DISMISS_DIALOG_ACTION = "DismissDialog";
    private JPanel m_panel = new JPanel();
    private JPanel m_buttonPanel = new JPanel(new FlowLayout());
    private Action m_cancelAction = new CancelAction();
    private JButton m_okButton = new JButton(new OKAction());
    private JButton m_cancelButton = new JButton(this.m_cancelAction);
    private JDialog m_dialog = new JDialog();
    private boolean m_isAccept = false;

    public DefaultGuiDialogRunner(InteractorData data, String actionPath) {
        super(data, actionPath);
        this.initialize();
    }

    private void initialize() {
        this.m_dialog.setLayout(new BorderLayout());
        this.m_dialog.getContentPane().add((Component)this.m_panel, "Center");
        this.m_dialog.getContentPane().add((Component)this.m_buttonPanel, "South");
        this.m_dialog.setLocationRelativeTo(ApplicationUI.inst().getMainFrame());
        this.m_dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), DISMISS_DIALOG_ACTION);
        this.m_dialog.getRootPane().getActionMap().put(DISMISS_DIALOG_ACTION, this.m_cancelAction);
        ApplicationUI.setIcon(this.m_dialog.getOwner());
        this.m_dialog.getRootPane().setDefaultButton(this.getButton(DialogNavigationAction.OK));
    }

    @Override
    public JButton getButton(DialogNavigationAction action) {
        if (action == DialogNavigationAction.OK) {
            return this.m_okButton;
        }
        if (action == DialogNavigationAction.CANCEL) {
            return this.m_cancelButton;
        }
        return null;
    }

    @Override
    public JDialog getDialog() {
        return this.m_dialog;
    }

    @Override
    public boolean isAccept() {
        return this.m_isAccept;
    }

    @Override
    public JPanel getContainerPanel() {
        return this.m_panel;
    }

    @Override
    public JPanel getContentPanel() {
        return this.m_panel;
    }

    @Override
    public JPanel getButtonPanel() {
        return this.m_buttonPanel;
    }

    @Override
    public void setPageSize(Dimension size) {
        this.m_panel.setPreferredSize(size);
    }

    @Override
    public void displayMessage(String message) {
        JOptionPane.showMessageDialog(this.getDialog(), message, "ERROR", 0);
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 4502501325098400561L;

        public OKAction() {
            super(DialogNavigationAction.OK.getName());
            this.putValue("ShortDescription", DialogNavigationAction.OK.getDesc());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultGuiDialogRunner.this.m_isAccept = true;
            try {
                String errorMessage = DefaultGuiDialogRunner.this.getAction().canAccept(DefaultGuiDialogRunner.this.getData());
                if (errorMessage == null) {
                    DefaultGuiDialogRunner.this.m_dialog.dispose();
                } else {
                    DefaultGuiDialogRunner.this.displayMessage(errorMessage);
                }
            }
            catch (InteractorDataError error) {
                DefaultGuiDialogRunner.this.displayMessage(error.getLocalizedMessage());
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 8622502021087470545L;

        public CancelAction() {
            super(DialogNavigationAction.CANCEL.getName());
            this.putValue("ShortDescription", DialogNavigationAction.CANCEL.getDesc());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultGuiDialogRunner.this.m_isAccept = false;
            DefaultGuiDialogRunner.this.m_dialog.dispose();
        }
    }
}

