/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationListener;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import java.util.ArrayList;
import java.util.Collection;

public class ApplicationEventMultiplexer
implements ApplicationListener {
    Collection<ApplicationListener> m_listeners = new ArrayList<ApplicationListener>();

    protected void connect(Application app) {
        app.addApplicationListener(this);
    }

    protected void disconnect(Application app) {
        app.removeApplicationListener(this);
    }

    @Override
    public void databasesAltered(Collection<DatabaseInfo> databases) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.databasesAltered(databases);
        }
    }

    @Override
    public void databasesAdded(Collection<DatabaseInfo> databases) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.databasesAdded(databases);
        }
    }

    @Override
    public void databasesDeleted(Collection<DatabaseInfo> databases) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.databasesDeleted(databases);
        }
    }

    @Override
    public void serversAdded(Collection<ServerInfo> servers) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.serversAdded(servers);
        }
    }

    @Override
    public void serversAltered(Collection<ServerInfo> servers) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.serversAltered(servers);
        }
    }

    @Override
    public void serversDeleted(Collection<ServerInfo> servers) {
        for (ApplicationListener listener : this.m_listeners) {
            listener.serversAltered(servers);
        }
    }
}

