/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.dbservers.mssql;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.DatabaseInfoImpl;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.ServerLogic;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SqlServerLogic
extends ServerLogic {
    private static final String SCHEMA_NAME_FIELD = "SCHEMA_NAME";
    static final String PM_SCHEMATYPE_QUERY = "select substring (database_version, 1, patindex ('%,%', database_version)-1) SCHEMA_NAME from prefer";
    static final String CM_SCHEMATYPE_QUERY = "select username SCHEMA_NAME from cvrt";
    static final String DATABASE_USERS = "select name from sys.sql_logins where name !='sa' and name NOT LIKE '%#%' order by name";
    static final String PRIVILEGED_USERS = "select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='pubuser' and privilege_type='UPDATE'";
    static final String PUBLIC_USERS = "select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='pubuser' and grantee not in (select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='pubuser' and privilege_type='UPDATE')";
    static final String PXRPT_USERS = "select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='taskx'   and privilege_type='SELECT' except select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='taskx' and privilege_type='UPDATE' ";
    static final String DATABASE_NONPUBPRIVDBO_USERS = "select name from sys.sql_logins where name in (select loginname  from sys.syslogins where name !='sa' and name not like '%#%' and (sysadmin<>1 or serveradmin<>1)and name not in (select distinct grantee from information_schema.table_privileges where table_catalog = ? and table_name='pubuser' and privilege_type='SELECT'))";
    static final Comparator<String> s_pubUserComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            String name0 = arg0.toUpperCase();
            String name1 = arg1.toUpperCase();
            int privIndex0 = name0.indexOf("PUB");
            int privIndex1 = name1.indexOf("PUB");
            if (privIndex0 < 0 && privIndex1 < 0 || privIndex0 == privIndex1) {
                return name0.compareTo(name1);
            }
            if (privIndex0 < 0 || privIndex1 < 0) {
                return privIndex1 - privIndex0;
            }
            return privIndex0 - privIndex1;
        }
    };

    @Override
    public Set<DatabaseInfo> getDatabases(ServerInfo server) {
        HashSet<DatabaseInfo> databases = new HashSet<DatabaseInfo>();
        try {
            DatabaseConnection connection = server.getConnection();
            ResultSet results = connection.getConnection().getMetaData().getCatalogs();
            while (results.next()) {
                String dbName = results.getString("TABLE_CAT");
                databases.add(new DatabaseInfoImpl(server, dbName));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return databases;
    }

    public static Set<String> getDatabaseNames(DatabaseConnection connection) {
        HashSet<String> databases = new HashSet<String>();
        try {
            ResultSet results = connection.getConnection().getMetaData().getCatalogs();
            while (results.next()) {
                String dbName = results.getString("TABLE_CAT");
                databases.add(dbName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return databases;
    }

    public static List<String> getDatabaseUsers(DatabaseConnection connection) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Statement stmt = connection.getConnection().createStatement();
            stmt.execute(DATABASE_USERS);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String userName = rs.getString("name");
                users.add(userName);
                StringLocalizer.setAsOwnTranslation(userName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    public static List<String> getExistingUsers(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            List<String> list = SqlServerLogic.getDatabaseUsers(conn);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    public static String getPrivilegedUser(DatabaseConnection connection, String dbName) {
        try {
            PreparedStatement prepSql = connection.getConnection().prepareStatement(PRIVILEGED_USERS);
            prepSql.setString(1, dbName);
            prepSql.execute();
            ResultSet rs = prepSql.getResultSet();
            if (rs.next()) {
                String privUser = rs.getString("grantee");
                return privUser;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getPublicUser(DatabaseConnection connection, String dbName) {
        try {
            PreparedStatement prepSql = connection.getConnection().prepareStatement(PUBLIC_USERS);
            prepSql.setString(1, dbName);
            prepSql.setString(2, dbName);
            prepSql.execute();
            ResultSet rs = prepSql.getResultSet();
            if (rs.next()) {
                String pubUser = rs.getString("grantee");
                return pubUser;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getDefaultSSUserName(Set<String> existingSSUsers, String defaultName) {
        String normalizedName = defaultName.toLowerCase();
        if (!existingSSUsers.contains(normalizedName)) {
            return normalizedName;
        }
        int firstTerminalDigit = normalizedName.length();
        while (Character.isDigit(normalizedName.charAt(firstTerminalDigit - 1))) {
            --firstTerminalDigit;
        }
        if (firstTerminalDigit < normalizedName.length()) {
            normalizedName = normalizedName.substring(0, firstTerminalDigit);
        }
        int appendedNumber = 1;
        String constructedName;
        while (existingSSUsers.contains(constructedName = normalizedName + appendedNumber)) {
            ++appendedNumber;
        }
        return constructedName;
    }

    public static String setDataFileDirectory(String dbNameField, String dbDatafileField) {
        String nameField = "";
        if (dbNameField != null) {
            nameField = dbNameField.trim();
        }
        String dataFileText = "";
        if (dbDatafileField != null) {
            dataFileText = dbDatafileField.trim();
        }
        String dataFileDirectory = SqlServerLogic.getDirectory(dataFileText) + nameField + "_DAT.MDF";
        return dataFileDirectory;
    }

    public static String setLogFileDirectory(String dbNameField, String dbLogfileField) {
        String logFileText = "";
        if (dbLogfileField != null) {
            logFileText = dbLogfileField.trim();
        }
        String nameField = "";
        if (dbNameField != null) {
            nameField = dbNameField.trim();
        }
        String logFileDirectory = SqlServerLogic.getDirectory(logFileText) + nameField + "_LOG.LDF";
        return logFileDirectory;
    }

    public static String getMasterFileDirectory(DatabaseConnection dbconn) {
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute("select filename from sysdatabases where name = 'master'");
            ResultSet rs = stmt.getResultSet();
            rs.next();
            String masterFile = rs.getString("filename");
            int pos = masterFile.lastIndexOf("\\");
            return masterFile.substring(0, pos);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SchemaType getSchemaType(DatabaseConnection dbconn, ProductSuiteType suite) throws SchemaTypeNotFoundError {
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            if (suite == ProductSuiteType.EXP) {
                stmt.execute(CM_SCHEMATYPE_QUERY);
                ResultSet rs = stmt.getResultSet();
                if (rs.next()) {
                    try {
                        return SchemaType.valueOf(rs.getString(SCHEMA_NAME_FIELD));
                    }
                    catch (Throwable e) {
                        throw new SchemaTypeNotFoundError(dbconn.getServer());
                    }
                }
                throw new SchemaTypeNotFoundError(dbconn.getServer());
            }
            stmt.execute(PM_SCHEMATYPE_QUERY);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                if (rs.getString(SCHEMA_NAME_FIELD).equalsIgnoreCase("PMDB")) {
                    return SchemaType.PM;
                }
                if (rs.getString(SCHEMA_NAME_FIELD).equalsIgnoreCase("PPMDB")) {
                    return SchemaType.PPM;
                }
                if (rs.getString(SCHEMA_NAME_FIELD).equalsIgnoreCase("MMDB")) {
                    return SchemaType.MM;
                }
                throw new SchemaTypeNotFoundError(dbconn.getServer());
            }
            throw new SchemaTypeNotFoundError(dbconn.getServer());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getSortedPossiblePubusers(DatabaseConnection dbconn) {
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            ResultSet rs = this.getPubUsersResultSet(dbconn);
            while (rs.next()) {
                usernames.add(rs.getString("grantee"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String[] userArray = usernames.toArray(new String[0]);
        Arrays.sort(userArray, s_pubUserComparator);
        usernames.clear();
        for (String username : userArray) {
            usernames.add(username);
            StringLocalizer.setAsOwnTranslation(username);
        }
        return usernames;
    }

    @Override
    protected ResultSet getPrivUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        PreparedStatement prepSql = dbconn.getConnection().prepareStatement(PRIVILEGED_USERS);
        String dbName = dbconn.getDatabase();
        prepSql.setString(1, dbName);
        prepSql.execute();
        ResultSet rs = prepSql.getResultSet();
        return rs;
    }

    @Override
    protected ResultSet getPubUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        PreparedStatement prepSql = dbconn.getConnection().prepareStatement(PUBLIC_USERS);
        String dbName = dbconn.getDatabase();
        prepSql.setString(1, dbName);
        prepSql.setString(2, dbName);
        prepSql.execute();
        ResultSet rs = prepSql.getResultSet();
        return rs;
    }

    @Override
    protected ResultSet getPxrptUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        PreparedStatement prepSql = dbconn.getConnection().prepareStatement(PXRPT_USERS);
        String dbName = dbconn.getDatabase();
        prepSql.setString(1, dbName);
        prepSql.setString(2, dbName);
        prepSql.execute();
        ResultSet rs = prepSql.getResultSet();
        return rs;
    }

    @Override
    protected String getPrivUsersSQL() {
        return PRIVILEGED_USERS;
    }

    @Override
    protected String getPxtUsersSQL() {
        return PXRPT_USERS;
    }

    @Override
    protected String getPubUsersSQL() {
        return PUBLIC_USERS;
    }

    public static List<String> getAllbutPubPrivDboUsers(DatabaseConnection dbconn) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            PreparedStatement prepSql = dbconn.getConnection().prepareStatement(DATABASE_NONPUBPRIVDBO_USERS);
            String dbName = dbconn.getDatabase();
            prepSql.setString(1, dbName);
            prepSql.execute();
            ResultSet rs = prepSql.getResultSet();
            while (rs.next()) {
                String userName = rs.getString("name");
                users.add(userName);
                StringLocalizer.setAsOwnTranslation(userName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    protected void getPossiblePxrptusers(DatabaseConnection dbconn, List<String> usernames) throws SQLException {
        ResultSet rs = this.getPxrptUsersResultSet(dbconn);
        while (rs.next()) {
            usernames.add(rs.getString("grantee"));
        }
    }

    @Override
    protected void getPossiblePrivusers(DatabaseConnection dbconn, List<String> usernames) throws SQLException {
        ResultSet rs = this.getPrivUsersResultSet(dbconn);
        while (rs.next()) {
            usernames.add(rs.getString("grantee"));
        }
    }
}

