/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;

public class OracleDatapathFromTablespaceName
implements FieldProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties jobProps) throws Exception {
        try (DatabaseConnection conn = null;){
            boolean isOracle = PageInitializerHelper.isOracle(jobProps, data);
            if (!isOracle) {
                String string = null;
                return string;
            }
            conn = new DatabaseConnection(jobProps.getConnection(ConnectionClass.SYSADMIN));
            String defaultOracleTablespaceDirectory = OracleLogic.getDefaultDirectory(conn);
            String string = defaultOracleTablespaceDirectory + fieldValue + ".DBF";
            return string;
        }
    }

    @Override
    public boolean validateValue(String fieldValue) {
        return true;
    }
}

