/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;

public class ExpRepositoryOption
implements FieldProcessor {
    private static final String[] ACCEPTABLE_VALUES = new String[]{"SAME", "DIFFERENT", "ONLY"};

    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        String uppercaseFieldValue = fieldValue.toUpperCase();
        if ("SAME".equals(uppercaseFieldValue)) {
            return "exp_same_instance";
        }
        if ("DIFFERENT".equals(uppercaseFieldValue)) {
            return "exp_diff_instance";
        }
        if ("ONLY".equals(uppercaseFieldValue)) {
            return "workflow_only";
        }
        return "exp_same_instance";
    }

    @Override
    public boolean validateValue(String fieldValue) {
        String uppercaseFieldValue = fieldValue.toUpperCase();
        for (String possibleValue : ACCEPTABLE_VALUES) {
            if (!possibleValue.equals(uppercaseFieldValue)) continue;
            return true;
        }
        return false;
    }
}

