/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.BaseWizardRunner;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.RollbackJob;
import com.primavera.database.tools.dbmt.actions.SetActionTypeTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.actions.WizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionObject;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgument;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgumentValue;
import com.primavera.database.tools.dbmt.gui.dialogs.CustomErrorDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public class CmdLineWizardRunnerFactory
implements WizardRunnerFactory {
    private final Map<String, String> m_parameterMap;
    private final CommandLineActionObject m_action;

    public CmdLineWizardRunnerFactory(CommandLineActionObject action, Map<String, String> parameterMap) {
        this.m_action = action;
        this.m_parameterMap = parameterMap;
    }

    @Override
    public WizardRunner createWizardRunner(WizardInteractorData data, String actionPath) {
        return new BaseWizardRunner(data, actionPath){

            @Override
            protected boolean performWizardAction() {
                DBMTLogger.info(Channel.DEV, "Calling performAction");
                HashMap<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap = new HashMap<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>>();
                try {
                    CmdLineWizardRunnerFactory.this.m_action.processCommandLine(CmdLineWizardRunnerFactory.this.m_parameterMap, valueMap);
                }
                catch (InvalidCommandLineArgument e) {
                    DBMTLogger.error(Channel.USER, "Invalid Command Line", e);
                    e.getCmdLineAction().printInvalidArgumentMessage(CmdLineWizardRunnerFactory.this.m_action.getCommandId(), e);
                    return false;
                }
                catch (InvalidCommandLineArgumentValue e) {
                    DBMTLogger.error(Channel.USER, "Invalid Command Line Argument Value", e);
                    e.getCmdLineAction().printInvalidArgumentValueMessage(CmdLineWizardRunnerFactory.this.m_action.getCommandId(), e);
                    return false;
                }
                catch (InteractorDataError e) {
                    DBMTLogger.error(Channel.DEV, "OOPS", e);
                }
                try {
                    Log.info("Calling Perform Action");
                    String pageId = this.getData().getStart();
                    DBMTLogger.info(Channel.DEV, "Start Page = " + pageId);
                    while (!this.getData().canFinish(pageId)) {
                        String error;
                        String error2;
                        this.getAction().preparePage(this, this.getData(), this.m_jobProps, pageId);
                        this.setPageValues(pageId, this.getData(), this.m_jobProps, valueMap);
                        String prevPageId = pageId;
                        String procError = this.getAction().postProcess(this, this.getData(), this.m_jobProps, pageId);
                        if (procError != null) {
                            DBMTLogger.info(procError);
                            throw new RuntimeException("Leave Page Failed: " + procError);
                        }
                        pageId = this.getData().getNextPage(pageId);
                        DBMTLogger.info(Channel.DEV, "Next Page = " + pageId);
                        if (pageId == null && (error2 = this.getAction().tryToFinish(this, this.getData(), this.m_jobProps, prevPageId)) != null) {
                            DBMTLogger.info(Channel.DEV, "Caught Exception: " + error2);
                            throw new RuntimeException("Finish Wizard Failed: " + error2);
                        }
                        this.pushPage(prevPageId);
                        InteractorData pageData = this.getData().getPageData(prevPageId);
                        DBMTLogger.info(Channel.DEV, "Calling testers for page " + prevPageId);
                        ArrayList<String> errorList = new ArrayList<String>();
                        if (!prevPageId.equalsIgnoreCase("create_keyStore")) {
                            for (FieldTester tester : this.getData().getNextValidators(prevPageId)) {
                                if (tester.doTest(pageData)) continue;
                                DBMTLogger.info(Channel.DEV, "Failed to leave page: " + prevPageId + ": " + tester.getClass().getSimpleName() + " (" + tester.getReason(pageData) + ")");
                                errorList.add(StringLocalizer.get("dbmt.error.wizardpageincomplete", new String[]{tester.getReason(pageData), pageData.getTitle(), pageId}));
                            }
                        }
                        if (!errorList.isEmpty()) {
                            for (String error3 : errorList) {
                                this.displayMessage(error3);
                            }
                            return false;
                        }
                        if (pageId.equals("upgrade_status") && this.m_jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.UPGRADE && this.m_rollbackFilePrefix == null) {
                            this.m_rollbackFilePrefix = this.m_jobProps.getJobProperty("version").toString();
                        }
                        if ((error = this.getAction().tryToLeavePage(this, this.getData(), this.m_jobProps, prevPageId, pageId)) == null) continue;
                        DBMTLogger.error(error.getClass().getSimpleName(), error);
                        this.displayMessage(error);
                        throw new RuntimeException("Leave Page " + prevPageId + " Failed: " + error);
                    }
                    return true;
                }
                catch (Throwable e) {
                    DBMTLogger.error(Channel.DEV, "ERROR: " + e.toString(), e);
                    System.exit(1);
                    return false;
                }
            }

            @Override
            public void commit(JobListener listener, List<Job> jobs, JobWatcher watcher) {
                for (Job job : jobs) {
                    if (this.runJob(job, listener, watcher)) continue;
                    boolean rollbackSelected = false;
                    boolean isNotHeadless = false;
                    try {
                        if (this.m_jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM && this.m_jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.UPGRADE) {
                            RollbackJob rollbackJob = new RollbackJob(this.m_jobProps, this.m_rollbackFilePrefix);
                            try {
                                m_ROLLBACK_ASKED = true;
                                JFrame frame = new JFrame();
                                frame.setAlwaysOnTop(true);
                                String confirmationMessage = StringLocalizer.get(this.getPopUpMessage(), new String[]{rollbackJob.getInstalledSchemaVersion(), rollbackJob.getToBeInstalledSchemaVersion()});
                                rollbackSelected = CustomErrorDialog.showDialog(confirmationMessage, job.getFailureReason());
                                isNotHeadless = true;
                                if (!rollbackSelected) {
                                    throw new RuntimeException(StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{job.toString()}));
                                }
                                rollbackJob.doRollBack(frame, this.m_isCompleteRollback);
                                System.exit(0);
                            }
                            catch (Throwable ex) {
                                if (!isNotHeadless) {
                                    rollbackSelected = this.getUserSelectionFromCommandLine(job, rollbackJob);
                                    if (rollbackSelected) {
                                        rollbackJob.doRollBack(null, this.m_isCompleteRollback);
                                        System.exit(0);
                                    } else {
                                        throw new RuntimeException(StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{job.toString()}));
                                    }
                                }
                                System.exit(1);
                            }
                            break;
                        }
                        throw new RuntimeException(StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{job.toString()}));
                    }
                    catch (JobPropertyNotFound e) {
                        throw new RuntimeException(StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{job.toString()}));
                    }
                }
                jobs.clear();
            }

            private String getPopUpMessage() {
                return "dbmt.rollback.confirmation.message.full";
            }

            private boolean getUserSelectionFromCommandLine(Job job, RollbackJob rollbackjob) {
                String userSelection = "N";
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println(StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{job.toString()}));
                    System.out.print(StringLocalizer.get(this.getCommandLineMessage(job), new String[]{rollbackjob.getInstalledSchemaVersion(), rollbackjob.getToBeInstalledSchemaVersion()}));
                    userSelection = reader.readLine();
                }
                catch (IOException e) {
                    DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.cmdline.userInputError"));
                }
                return "Y".equalsIgnoreCase(userSelection);
            }

            private String getCommandLineMessage(Job job) {
                String jobName = job.toString();
                if (jobName.equals(StringLocalizer.get("dbmt.upgrade.step.coreUpgrade")) || jobName.equals(StringLocalizer.get("dbmt.upgrade.step.coreUpgrade"))) {
                    this.m_isCompleteRollback = true;
                    return "dbmt.rollback.cmdLine.enterY.toConfirm.full";
                }
                return "dbmt.rollback.cmdLine.enterY.toConfirm.partial";
            }

            private void setPageValues(String pageId, WizardInteractorData data, JobProperties jobProps, Map<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap) throws Exception {
                Map<String, Set<CommandLineActionObject.ValueAndProcessor>> pageValueMap = valueMap.get(pageId);
                if (pageValueMap == null) {
                    pageValueMap = new HashMap<String, Set<CommandLineActionObject.ValueAndProcessor>>();
                }
                InteractorData pageData = data.getPageData(pageId);
                for (Map.Entry<String, Set<CommandLineActionObject.ValueAndProcessor>> entry : pageValueMap.entrySet()) {
                    CommandLineActionObject.ValueAndProcessor lastValueProc;
                    if (entry.getValue() != null && entry.getValue().size() > 1) {
                        HashSet<Integer> intSet = new HashSet<Integer>();
                        for (CommandLineActionObject.ValueAndProcessor vap : entry.getValue()) {
                            int seq = vap.getSequence();
                            if (intSet.contains(seq)) {
                                DBMTLogger.warn(Channel.DEV, "Whoops, there is more than one value for " + pageId + "/" + entry.getKey() + " at sequence " + seq);
                            }
                            intSet.add(seq);
                        }
                    }
                    if ((lastValueProc = this.getHighestValueProc(entry.getValue())) == null) continue;
                    String fieldValue = lastValueProc.getProcessedValue(data, jobProps);
                    if (pageId.equals("configure_px_users") && entry.getKey().equals("useexistingpxrptuser") && pageData.getString("existingPxrpt") != null) {
                        fieldValue = "true";
                    }
                    pageData.setValue(entry.getKey(), fieldValue);
                }
            }

            private CommandLineActionObject.ValueAndProcessor getHighestValueProc(Set<CommandLineActionObject.ValueAndProcessor> value) {
                CommandLineActionObject.ValueAndProcessor bestSoFar = null;
                for (CommandLineActionObject.ValueAndProcessor proc : value) {
                    if (bestSoFar != null && bestSoFar.getSequence() > proc.getSequence()) continue;
                    bestSoFar = proc;
                }
                return bestSoFar;
            }

            @Override
            public void displayMessage(String message) {
                System.err.println(message);
            }

            @Override
            public boolean inializePages() {
                return false;
            }

            @Override
            public boolean commitAsync() {
                return false;
            }
        };
    }
}

