/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.common.StrUtil;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.dbmt.ActionContext;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationRunner;
import com.primavera.database.tools.dbmt.actions.DialogRunner;
import com.primavera.database.tools.dbmt.actions.DialogRunnerFactory;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.CmdLineDialogRunner;
import com.primavera.database.tools.dbmt.cmd.CmdLineWizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionMap;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionObject;
import com.primavera.database.tools.dbmt.cmd.CommandNotSpecified;
import com.primavera.database.tools.dbmt.cmd.CommandlineUI;
import com.primavera.database.tools.dbmt.cmd.InitializationException;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgument;
import com.primavera.database.tools.dbmt.cmd.UnableToInitializeCommands;
import com.primavera.database.tools.dbmt.xml.util.LogFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CmdLineApplicationRunner
implements ApplicationRunner {
    private static final String PROPERTIES_FILE_NAME = "dbsetup.properties";
    private static final String PROPERTY_FILE_LOCATION = ".";
    private static final List<String> EXTRA_PARAMS_DESC = Arrays.asList("dbmt.warn.readfromfileargument");
    CommandLineActionObject m_action = null;
    Map<String, String> m_paramterMap = new HashMap<String, String>();
    String[] m_args = new String[0];

    @Override
    public void initialize(Application app) throws InitializationException {
        CommandlineUI.initializeActionLogicActions(app);
    }

    @Override
    public void start(Application app) throws UnableToInitializeCommands {
        this.m_action.getActionOperation().contextLogic().resetFromContext(new ActionContext(app));
        try {
            this.m_action.getActionOperation().perform();
        }
        catch (ActionFailed e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadParameters() {
        Properties props = new Properties();
        FileInputStream in = null;
        ArrayList<String> cmdParams = new ArrayList<String>();
        try {
            File f = new File(PROPERTY_FILE_LOCATION, PROPERTIES_FILE_NAME);
            in = new FileInputStream(f);
            props.load(in);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                if (StrUtil.isEmpty((String)value)) continue;
                cmdParams.add("-" + key);
                cmdParams.add(value);
            }
            ArrayList<String> arrayList = cmdParams;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            DBMTLogger.error("Could not find the properties file: " + e.getMessage(), e);
        }
        catch (IOException ex) {
            DBMTLogger.error("Could not read the properties file: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return null;
    }

    @Override
    public final void processCmdLineParameters(String[] args) throws InvalidCommandLineArgument {
        this.m_args = args;
        if (args.length == 0) {
            throw new CommandNotSpecified();
        }
        String commandName = args[0];
        String readFromFileFlag = args[1];
        if ("-readfromfile".equalsIgnoreCase(readFromFileFlag)) {
            List<String> cmdParamsInPropertiesFile = CmdLineApplicationRunner.loadParameters();
            if (cmdParamsInPropertiesFile == null || cmdParamsInPropertiesFile.size() == 0) {
                DBMTLogger.error("dbsetup.properties is empty!");
                throw new CommandNotSpecified();
            }
            cmdParamsInPropertiesFile.add(0, commandName);
            args = cmdParamsInPropertiesFile.toArray(args);
        }
        try {
            DBMTLogger.info(Channel.DEV, "Calling command " + commandName);
            CommandLineActionMap aoMgr = CommandLineActionMap.inst();
            CommandLineActionObject cmdObj = (CommandLineActionObject)aoMgr.findAction(commandName);
            DBMTLogger.info(Channel.DEV, "Command = " + cmdObj);
            this.m_action = cmdObj;
            cmdObj.validateCommandLine(args);
            for (int i = 1; i < args.length; i += 2) {
                String paramId = args[i].substring(1).toLowerCase();
                if (i + 1 >= args.length) {
                    throw new InvalidCommandLineArgument(cmdObj, args, i + 1);
                }
                this.m_paramterMap.put(paramId, args[i + 1]);
            }
        }
        catch (InvalidCommandLineArgument e) {
            e.getCmdLineAction().printInvalidArgumentMessage(commandName, e, EXTRA_PARAMS_DESC);
            throw e;
        }
    }

    @Override
    public DialogRunnerFactory createDialogRunnerFactory() {
        return new DialogRunnerFactory(){

            @Override
            public DialogRunner createDialogRunner(InteractorData data, String actionPath) {
                return new CmdLineDialogRunner(data, actionPath);
            }
        };
    }

    @Override
    public void initializeLogging() {
        DBMTLogger.LogLevel devLogLevel = LogFileUtil.getDevLogLevel();
        DBMTLogger.addAppender(DBMTLogger.LOG4J_APPENDER);
        DBMTLogger.addAppender(DBMTLogger.CONSOLE_APPENDER);
        DBMTLogger.addChannel(Channel.DEV);
        DBMTLogger.addChannel(Channel.USER);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.CONSOLE_APPENDER, devLogLevel);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.CONSOLE_APPENDER, DBMTLogger.LogLevel.INFO);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.INFO);
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LogFileUtil.getLogFileName());
    }

    @Override
    public WizardRunnerFactory createWizardRunnerFactory() {
        return new CmdLineWizardRunnerFactory(this.m_action, this.m_paramterMap);
    }
}

